/*  

                       Copyright (c) 1990 by:
        Leif Laaksonen , Centre for Scientific Computing, ESPOO, FINLAND
            Confidential unpublished property of Leif Laaksonen
                        All rights reserved
  

*/

#include <stdio.h>
#include <string.h>
#include <math.h>
#include <sys/types.h>
#include <malloc.h>
#include "maxdefs.h"

#define FNKEYS 12        /* number of function keys */

extern int atom_list_max();
extern int read_traj();
extern void PrintMessage();
extern void rgb_to_name();
extern float GetXCoord();
extern float GetYCoord();
extern float GetZCoord();
extern int GetResNum1();
extern char *GetSegName();
extern char *GetResName();
extern char *GetAtmName();
extern int   InformIObytes();
extern int TrajectoryLastFrame();
extern int TrajectoryFirstFrame();
extern int TrajectoryStepFrame();
extern int FramesInSet();

     extern int current_struct;  /* current molecule number */
     extern int mlist_deep;      /* stack number indicator */
     extern int mlists[MAX_MLIST]; /* First index for molecule list */
     extern int mliste[MAX_MLIST]; /* Second index for molecule list */
     extern char mnlist[MAX_MLIST][BUFF_LEN]; 
                                /* name list for molecule file names */

     extern short bgcolor[];
     extern short txcolor[];
     extern short obcolor[];

     extern struct {  /* structure to hold the command for the Funct keys */
       char f1[BUFF_LEN];
       char f2[BUFF_LEN];
       char f3[BUFF_LEN];
       char f4[BUFF_LEN];
       char f5[BUFF_LEN];
       char f6[BUFF_LEN];
       char f7[BUFF_LEN];
       char f8[BUFF_LEN];
       char f9[BUFF_LEN];
       char f10[BUFF_LEN];
       char f11[BUFF_LEN];
       char f12[BUFF_LEN]; } FUNKEY;

     extern float sumx,sumy,sumz;
     extern float near;
     extern float far;
     extern int col_tbl_max;  /* number of entries in the colour table */
     extern struct SCARE_col_table {
     int red;      /* read value */
     int green;    /* green value */
     int blue;     /* blue value */
     char name[MAX_COL_LEN]; } ;

     extern struct SCARE_col_table *col_table;  /* name of colour */

     extern struct LineSeg {
      int    Show;           /* if != 0 show the lines     */
      int    Lines;          /* number of lines            */
      float *LineCoord;      /* pointer to the coordinates */
      short *Red;            /* pointer to contain the colour */
      short *Green;
      short *Blue;
     } PlotLine;

     extern struct SphereSeg {
      int    Show;             /* if != 0 show the sphere      */
      int    Spheres;          /* number of spheres            */
      float *SphereCoord;      /* pointer to the coordinates   */
      float *Radius;           /* pointer to sphere radius     */
      short *Red;            /* pointer to contain the colour */
      short *Green;
      short *Blue;
     } PlotSphere;

/*  cell dimensions */
    extern struct cell_dim {
    float a;
    float b;
    float c;
    float alpha;
    float beta;
    float gamma;
    float Xtrans;
    float Ytrans;
    float Ztrans;};
    
    extern struct cell_dim cell;

       extern struct {
         float Angle;       /* rotation angle */
         float Translate;   /* translation from the centre */
         int   Active;      /* == 0 off , != 0 on */
         int   Set;         /* == 0 reset , != do not reset */
                  } StereoPlot;

/* contour structure */
     extern int    ContoursDefined;   /* number of contours defined */

     extern struct Contour_Struct {
     float *data;           /* contour data */
     float min;
     float max;
     int xdim;
     int ydim;
     int zdim;
     float Xtrans;
     float Ytrans;
     float Ztrans;
     float Xscale;
     float Yscale;
     float Zscale;
     float ColVal[MAX_CONT];
     int   NumVal;
     char  ColNam[MAX_CONT][BUFF_LEN];
     char  ContFile[BUFF_LEN];
     float AlphaBlend;
     int   ContSmooth;
     char  Name[BUFF_LEN];
     int   Display;} ContourInfo[MAX_CONTOURS];

/* structure for the dynamics trajectory file */

   extern struct {
    char traj_file[BUFF_LEN];                 /* file name          */
    int natom;                                /* number of atoms    */
    int nstep;                                /* number of steps    */
    int time_bw_steps;                        /* time between steps */
    int time_first_frame;                     /* time of first frame */
    int first_frame;                          /* first frame to be displayed */
    int last_frame;                           /* last frame to be displayed  */
    int delta_frame;                          /* display every delta frame */
                   }    trajectory_info;     

     void ShowColortable();
     int  ShowTrajectoryStats();


/************************************************************************/
show_fac(input,num)   /* interpret the show command */
   char *input; 
   int num;
/************************************************************************/
{

     extern char parsed[MAXparse][MAXlinel];
     extern char *segment;
     extern char *resnam;
     extern char *atnam;
     extern int **atmcol;
     extern int numat;
     extern int *res1;
     extern int *atm_type;
     extern float *atm_charge;
     extern int atnam_stack_deep;
     extern char *atnam_stack;
     extern int *atnam_stack_num;
     extern int resnam_stack_deep;
     extern char *resnam_stack;
     extern char *segment_stack;
     extern int segment_stack_deep;
     extern int *resnam_stack_num;
     extern char traj_file[BUFF_LEN];
     extern int traj_file_set;
     extern int dynamics_frames;
     extern int dynamics_pasback[20];

     extern int alias_deep;
     extern char alias_stack[][MAXlinel];
     extern char alias_eq[][MAXlinel];
     extern int *atm_type;
     extern float *atm_charge;
     extern float find_mass();

     int i;
     float charge;
     char OutText[BUFF_LEN];
     char Help[BUFF_LEN];

/* switch to small characters                 */
     toller(parsed[1]);

/* '?' help facility                          */
   if(indexo(parsed[1],"?") == 1) {
PrintMessage("Help facility for 'show' ");
PrintMessage("show alia*s                           ! Show alias stack ");
PrintMessage("     atom char*ges     seg:res:atom   ! Show atom charges ");
PrintMessage("          cent*ering                  ! Show centering translation");
PrintMessage("          coor*dinates seg:res:atom   ! Show atom coord ");
PrintMessage("          list                        ! Show atom list ");
PrintMessage("          type*s       seg:res:atom   ! Show atom types ");
PrintMessage("     cell dime*nsions                 ! Show cell dimensions");
PrintMessage("     cont*oure                        ! Show contour statistics");
PrintMessage("     curr*ent struc*ture              ! Show current structure number");
PrintMessage("     dist*ance list                   ! Show dist list ");
PrintMessage("     fkey*s                           ! Show def function keys");
PrintMessage("     angl*e list                      ! Show ang list ");
PrintMessage("     tors*ion list                    ! Show tors list ");
PrintMessage("     comm*and stac*k                  ! Show command stack ");
PrintMessage("     line*s                           ! Show defined lines ");
PrintMessage("     sphe*res                         ! Show defined spheres");
PrintMessage("     resi*due char*ges                ! Show residue charges ");
PrintMessage("     atomc                            ! Show atom colours ");       
PrintMessage("     atomn                            ! Show atom names ");
PrintMessage("     dyna*mics file                   ! Show trajectory info ");
PrintMessage("     colo*ourtable                    ! Show colour table ");
PrintMessage("     resi*due name*s                  ! Show residue names ");
PrintMessage("     segm*ent name*s                  ! Show segment names ");
PrintMessage("     ster*eo                          ! Show stereo parameters");
PrintMessage("     traj*ectory info                 ! Show traj info");
PrintMessage("     proc*ess                         ! Show process info ");
PrintMessage("     time                             ! Show time and cpu secs ");
PrintMessage("     bgcolour                         ! Show back ground colour");
PrintMessage("     txcolour                         ! Show text colour");
PrintMessage("     obcolour                         ! Show object colour");
   return;}
 
/* show atom colour                           */
   if(indexo(parsed[1],"atomc") == 1) {
   if(mliste[0] < 1) {
   PrintMessage("?ERROR - no atoms defined ");
   return;}
/*
   sprintf(OutText,"Display atom colours for structure: %d\n",(current_struct + 1));
   PrintMessage(OutText);
   for(i=mlists[current_struct] ; i < mliste[current_struct] ; i++) {
   sprintf(OutText," Nr: %d , colour %d %d %d \n",i+1,atmcol[i][0],
                                             atmcol[i][1],
                                             atmcol[i][2]);
   PrintMessage(OutText);}
*/
   show_atom_color();
   return;
   }

/* show atom name stack                      */
   if(indexo(parsed[1],"atomn") == 1) {
   build_name_stack(1);
   if(atnam_stack_deep == 0){
   PrintMessage("?WARNING - atom stack is empty \n");
   return;}
   PrintMessage("\nDisplay atom name stack:\n");
   PrintMessage("  Nr:   atom name   numbers of this atom\n");

    for(i = 0 ; i < atnam_stack_deep ; i++) {
    sprintf(OutText,"    %d     '%.4s'         %d ",i+1,atnam_stack+4*i,atnam_stack_num[i]);
    PrintMessage(OutText);
    }
   return;
   }

/* show residue name stack                   */
   if(indexo(parsed[1],"resi") == 1) {
     toller(parsed[2]);
     if(indexo(parsed[2],"name") == 1) {
     build_name_stack(2);
     if(resnam_stack_deep == 0) {
     PrintMessage("?WARNING - residue stack is empty \n");
     return;}
     PrintMessage("\nDisplay of residue name stack:\n");
     PrintMessage("  Nr:   residue name  numbers of this residue\n");

    for(i = 0 ; i < resnam_stack_deep ; i++ ) {
     sprintf(OutText,"    %d     %.4s         %d ",i+1,resnam_stack+4*i,resnam_stack_num[i]);
     PrintMessage(OutText);
     }
   return;
   }}

/* show segment name stack                   */
   if(indexo(parsed[1],"segm") == 1) {
     toller(parsed[2]);
     if(indexo(parsed[2],"name") == 1) {
   build_name_stack(3);
   if(segment_stack_deep == 0) {
   PrintMessage("?WARNING - segment stack is empty \n");
   return;}
   PrintMessage("\nDisplay of segment name stack:\n");
   PrintMessage("  Nr:   segment name ");

    for(i = 0 ; i < segment_stack_deep ; i++ ) {
     sprintf(OutText,"    %d     %.4s \n",i+1,segment_stack+4*i);
     PrintMessage(OutText);
     }
   return;
   }}

/* show alias stack                           */
   if(indexo(parsed[1],"alia") == 1) {
   if(alias_deep < 1)  {
   PrintMessage("?WARNING - alias stack is empty \n");
   return;}

   if(alias_deep == 0) {
   PrintMessage("?WARNING - alias stack is empty \n");
   return;}
 
   PrintMessage("\nDisplay of alias stack:");
     for(i = 0 ; i < alias_deep ; i++) 
      sprintf(OutText," alias : %s ==> %s\n",alias_eq[i],alias_stack[i]);
      PrintMessage(OutText);
     return;
   }

/* show atom charges                          */
   if(indexo(parsed[1],"atom") == 1) {
   if( mliste[mlist_deep - 1] < 1) {
   PrintMessage("?ERROR - no atoms defined \n");
   return;}
     toller(parsed[2]);
     if(indexo(parsed[2],"char") == 1) {
     show_atomic_charges();
      return;}
     if(indexo(parsed[2],"type") == 1) {
     show_atomic_types();
      return;}
     if(indexo(parsed[2],"coor") == 1) {
     show_atomic_coord();
      return;}
     if(indexo(parsed[2],"cent") == 1) {
     show_atom_cent();
      return;}
   }

/* show residue charges                        */
    if(indexo(parsed[1],"resi") == 1) {
      toller(parsed[2]);
      if(indexo(parsed[2],"char") == 1) {

      if( mliste[mlist_deep - 1] < 1) {
      PrintMessage("?ERROR - no atoms set \n");
      return;}

      sprintf(OutText,"Residue charges for structure: %d \n",(current_struct + 1));
      PrintMessage(OutText);

      charge = atm_charge[0];
      for(i = mlists[current_struct] ; i < mliste[current_struct] ; i++) {
      if(i > 0) {
       if(res1[i] == res1[i-1]) {
       charge+=atm_charge[i];}
       else {
       sprintf(OutText," >%.4s<>%.4s:%d:< charge %f\n",segment+4*(i-1),resnam+4*(i-1),
       res1[i-1],charge);
       PrintMessage(OutText);
       charge=atm_charge[i];}}
       }
       sprintf(OutText," >%.4s<>%.4s:%d:< charge %f\n",segment+4*(mliste[0]-1),resnam+4*(mliste[0]-1),
       res1[mliste[0]-1],charge);       
       PrintMessage(OutText);
     return;
     }

    }

/* show atoms                                 */
   if(indexo(parsed[1],"atom") == 1) {
      toller(parsed[2]);
      if(indexo(parsed[2],"list") == 1) {
   if(mliste[0] < 1) {
   PrintMessage("?ERROR - no atoms defined \n");
   return;}

   sprintf(OutText,"Atom list for structure: %d\n",(current_struct + 1));
   PrintMessage(OutText);

   for(i = mlists[current_struct] ; i < mliste[current_struct] ; i++) {
   charge = find_mass(atm_type[i]);
   sprintf(OutText,">%.4s<>%.4s(%d)<>%.4s<>%d<>%f<>%f< \n",GetSegName(i),
            GetResName(i),GetResNum1(i),GetAtmName(i),
   atm_type[i],atm_charge[i],charge);
   PrintMessage(OutText);}
   return;}
 }

/* show time                                  */
    if(indexo(parsed[1],"time") == 1) {
      show_time();
      return;
    }

/* show process info                         */
    if(indexo(parsed[1],"proc") == 1) {
      get_proc_info();
      (void) InformIObytes();
      return;
    }

/* show angle list                           */
    if(indexo(parsed[1],"angl") == 1) {
       toller(parsed[2]);
       if(indexo(parsed[2],"list") == 1) {
       study_dynamics(23);
       return;}
    }

/* show distance list                           */
    if(indexo(parsed[1],"dist") == 1) {
       toller(parsed[2]);
       if(indexo(parsed[2],"list") == 1) {
       study_dynamics(24);
       return;}
    }

/* show torsion list                           */
    if(indexo(parsed[1],"tors") == 1) {
       toller(parsed[2]);
       if(indexo(parsed[2],"list") == 1) {
       study_dynamics(25);
       return;}
    }

/* show dynamics trajectory information       */
   if(indexo(parsed[1],"dyna") == 1) {
      toller(parsed[2]);
      if(indexo(parsed[2],"file") == 1) {

      if(traj_file[0] == NULL) {
      PrintMessage("?WARNING - no trajectory file set \n");
      return;}

      sprintf(OutText,"Dynamics trajectory file name: %s \n",traj_file);
      PrintMessage(OutText);
      traj_file_set = 1;
      i = read_traj(1,&dynamics_frames,dynamics_pasback);
      return;}
   }

/* show command stack                         */
   if(indexo(parsed[1],"comm") == 1) {
     toller(parsed[2]);
     if(indexo(parsed[2],"stac") == 1) {
       show_comm_stack();
       return;}
   }

/* show current structure number              */
   if(indexo(parsed[1],"curr") == 1) {
     toller(parsed[2]);
     if(indexo(parsed[2],"stru") == 1) {
       if(mlist_deep == 0) {
         PrintMessage("?WARNING - no structure(s) defined \n");
         return;}
       sprintf(OutText,"Current structure number is           : %d ",(current_struct + 1));
       PrintMessage(OutText);
       sprintf(OutText,"Total number of structures (molecules): %d ",mlist_deep);
       PrintMessage(OutText);
       return;}
   }

/* show text colour */
   if(indexo(parsed[1],"txco") == 1) {
     rgb_to_name(Help,txcolor[0],txcolor[1],txcolor[2]);
     sprintf(OutText,"Text colour is (rgb) %d:%d:%d '%s'",txcolor[0],
                                                     txcolor[1],
                                                     txcolor[2],Help);
     PrintMessage(OutText);
    return;}

/* show back ground colour colour */
   if(indexo(parsed[1],"bgco") == 1) {
    rgb_to_name(Help,bgcolor[0],bgcolor[1],bgcolor[2]);
     sprintf(OutText,"Back ground colour is (rgb) %d:%d:%d '%s'",bgcolor[0],
                                                     bgcolor[1],
                                                     bgcolor[2],Help);
     PrintMessage(OutText);
    return;}

/* show object colour */
   if(indexo(parsed[1],"obco") == 1) {
     rgb_to_name(Help,obcolor[0],obcolor[1],obcolor[2]);
     sprintf(OutText,"Object colour is (rgb) %d:%d:%d '%s'",obcolor[0],
                                                     obcolor[1],
                                                     obcolor[2],Help);
     PrintMessage(OutText);
    return;}

/* show colour table */
   if(indexo(parsed[1],"colo") == 1) {
     ShowColourTable();
      return;}

/* show near/far     */
   if(indexo(parsed[1],"nearfar") == 1) {
     ShowNearFar();
     return;}


/* show defined function keys    */
   if(indexo(parsed[1],"fkey") == 1) {
     ShowFuncKeys();
     return;}

/* show defined lines            */
   if(indexo(parsed[1],"line") == 1) {
      if(ShowDefLines()) return;
      return;}

/* show defined spheres            */
   if(indexo(parsed[1],"sphe") == 1) {
      if(ShowDefSpheres()) return;
      return;}

/* show shell dimensions           */
   if(indexo(parsed[1],"cell") == 1) {
      toller(parsed[2]);
      if(indexo(parsed[2],"dime") == 1) {

         ShowCellDim();

      return;}}

/*  show stereo parameters         */
   if(indexo(parsed[1],"ster") == 1) {
     PrintMessage(" **** Stereo mode parameters ****");
     if(StereoPlot.Active) {
          sprintf(OutText," Stereo mode ON  , angle: %f , translation: %f",
                  StereoPlot.Angle / 10.0 , StereoPlot.Translate);
                  PrintMessage(OutText);}
     else {
          sprintf(OutText," Stereo mode OFF , angle: %f , translation: %f",
                  StereoPlot.Angle / 10.0 , StereoPlot.Translate);
                  PrintMessage(OutText);}
     return;}

/*  show contour statistics        */
    if(indexo(parsed[1],"cont") == 1) {
       (void)ShowContourStats();
       return;}

/*  show trajectory info           */
    if(indexo(parsed[1],"traj") == 1) {
       toller(parsed[2]);
       if(indexo(parsed[2],"info") == 1) {
       (void)ShowTrajectoryStats();
       return;}}

/* default position "command not recognized"  */

     sprintf(OutText,"?ERROR: Following command not recognized: %s \n",input);
     PrintMessage(OutText);

}      /* end of show_fac */

/************************************************************************/
show_atomic_charges()
/************************************************************************/
{
     extern char parsed[][MAXlinel];
     extern int *ivector();
     extern int numat;
     extern char *segment;
     extern char *resnam;
     extern char *atnam;
     extern float *atm_charge;
     extern int select_list();

     static int i,si;
     static char chelp[BUFF_LEN];
     static int ihelp,atom_max;
     static int *sel_list;
     static int slong;
     static float fhelp;

     char OutText[BUFF_LEN];

     atom_max = atom_list_max();
     sel_list = ivector(atom_max);

     sprintf(OutText,"Atomic charges for selection list %.4s:%.4s:%.4s \n",
     parsed[3],parsed[4],parsed[5]);
     PrintMessage(OutText);

     slong = select_list(parsed[3],parsed[4],parsed[5],sel_list);

     if(slong > 0) {
        fhelp = 0.0;
        for(i = 0 ; i < slong ; i++) {
        si = sel_list[i];
        sprintf(OutText,">%.4s<>%.4s(%d)<>%.4s<  =  %f ",
                GetSegName(si),GetResName(si),GetResNum1(si),
                GetAtmName(si),atm_charge[si]);
        PrintMessage(OutText);
        fhelp -= atm_charge[si];
        }
        sprintf(OutText,"Total charge : %f ",fhelp);
        PrintMessage(OutText);}
      else
      PrintMessage("?ERROR - no atoms in the selection list \n");

        free(sel_list);
}
/************************************************************************/
show_atomic_types()
/************************************************************************/
{
     extern char parsed[][MAXlinel];
     extern int *ivector();
     extern int numat;
     extern char *segment;
     extern char *resnam;
     extern char *atnam;
     extern float *atm_charge;
     extern int *atm_type;
     extern int select_list();

     static int i,si;
     static char chelp[BUFF_LEN];
     static int ihelp,atom_max;
     static int *sel_list;
     static int slong;

     char OutText[BUFF_LEN];

     atom_max = atom_list_max();
     sel_list = ivector(atom_max);

     sprintf(OutText,"Atomic types for selection list %.4s:%.4s:%.4s ",
     parsed[3],parsed[4],parsed[5]);
     PrintMessage(OutText);

     slong = select_list(parsed[3],parsed[4],parsed[5],sel_list);

     if(slong > 0) {
        for(i = 0 ; i < slong ; i++) {
           si = sel_list[i];
        sprintf(OutText,">%.4s<>%.4s(%d)<>%.4s<  =  %d ",GetSegName(si),
                GetResName(si),GetResNum1(si),
                GetAtmName(si),atm_type[si]);
        PrintMessage(OutText);}
      }
     else
     PrintMessage("?ERROR - no atoms in the selection list \n");

        free(sel_list);
}

/************************************************************************/
show_atomic_coord()
/************************************************************************/
{
     extern char parsed[][MAXlinel];
     extern int *ivector();
     extern int numat;
     extern char *segment;
     extern char *resnam;
     extern char *atnam;
     extern float *atm_charge;
     extern int *atm_type;
     extern int select_list();

     static int i,si;
     static char chelp[BUFF_LEN];
     static int ihelp,atom_max;
     static int *sel_list;
     static int slong;

     char OutText[BUFF_LEN];

     atom_max = atom_list_max();
     sel_list = ivector(atom_max);

     slong = select_list(parsed[3],parsed[4],parsed[5],sel_list);

     if(slong > 0) {
        for(i = 0 ; i < slong ; i++) {
           si = sel_list[i];
        sprintf(OutText,">%.4s<>%.4s(%d)<>%.4s<\n %f %f %f ",
                GetSegName(si),
                GetResName(si),GetResNum1(si),
                GetAtmName(si),GetXCoord(si)+sumx,GetYCoord(si)+sumy,
                GetZCoord(si)+sumz);
        PrintMessage(OutText);}
      }
     else
     PrintMessage("?ERROR - no atoms in the selection list \n");

        free(sel_list);
}

/************************************************************************/
show_time()   /* show date time and cpu time */
/************************************************************************/
{
     float secs;
     float secs1;
     float TimeSecs;
     char OutText[BUFF_LEN];

     secs = 0.0;
      secs1 = 0.0;
     get_cpu_secs(&secs , &secs1);
     get_wall_secs(&TimeSecs);
     get_date(3);
     sprintf(OutText,"   Wasted cpu secs: %f (Child cpu secs: %f)",secs,secs1);
     PrintMessage(OutText);
     sprintf(OutText,"   In %.3f hours wall clock time (%.3f%c)",
       TimeSecs/3600.,(secs/TimeSecs)*100.,'%');
     PrintMessage(OutText);

}

/************************************************************************/
show_atom_color()
/************************************************************************/
{
     extern char parsed[][MAXlinel];
     extern int *ivector();
     extern int numat;
     extern char *segment;
     extern char *resnam;
     extern char *atnam;
     extern float *atm_charge;
     extern int *atm_type;
     extern int select_list();
     extern int **atmcol;

     static int i,si;
     static char chelp[BUFF_LEN];
     static int ihelp,atom_max;
     static int *sel_list;
     static int slong;

     char OutText[BUFF_LEN];

     atom_max = atom_list_max();
     sel_list = ivector(atom_max);

     sprintf(OutText,"Atom colours for selection list %.4s:%.4s:%.4s ",
     parsed[3],parsed[4],parsed[5]);

     slong = select_list(parsed[2],parsed[3],parsed[4],sel_list);

     if(slong > 0) {
        for(i = 0 ; i < slong ; i++) {
           si = sel_list[i];
        sprintf(OutText,">%.4s<>%.4s(%d)<>%.4s< R = %d, G = %d, B = %d ",
                GetSegName(si),GetResName(si),GetResNum1(si),
                GetAtmName(si),atmcol[si][0],atmcol[si][1],atmcol[si][2]);
        PrintMessage(OutText);}
      }
     else
     PrintMessage("?ERROR - no atoms in the selection list \n");

        free(sel_list);
}

/************************************************************************/
ShowColourTable()
/************************************************************************/
{
     int i;
     char OutText[BUFF_LEN];

     if(col_tbl_max < 1) {
       PrintMessage("?WARNING - no colour table defined");
       return;}

     PrintMessage("Colour table definitions (Name and RGB values)");

     for(i = 0 ; i < col_tbl_max ; i++) {
        sprintf(OutText,"'%s' , red: %d , green: %d , blue: %d",
               col_table[i].name,
               col_table[i].red,
               col_table[i].green,
               col_table[i].blue);
        PrintMessage(OutText);}
}


/************************************************************************/
ShowNearFar()
/************************************************************************/
{
    char OutText[BUFF_LEN];

    sprintf(OutText,"Current values 'near': %f and 'far': %f\n",near,far);
    PrintMessage(OutText);
}
/************************************************************************/
ShowFuncKeys()
/************************************************************************/
{
   int i;
   char OutText[BUFF_LEN];

   PrintMessage(".... Function keys ....");

   for(i = 0 ; i < FNKEYS ; i++) {

      switch(i) {

      case 0:
         if(FUNKEY.f1[0] == '\0') 
           sprintf(OutText,"F1  : **** Not defined ****");
         else
           sprintf(OutText,"F1  : %s",FUNKEY.f1);
         break;
      case 1:
         if(FUNKEY.f2[0] == '\0') 
           sprintf(OutText,"F2  : **** Not defined ****");
         else
           sprintf(OutText,"F2  : %s",FUNKEY.f2);
         break;
      case 2:
         if(FUNKEY.f3[0] == '\0') 
           sprintf(OutText,"F3  : **** Not defined ****");
         else
           sprintf(OutText,"F3  : %s",FUNKEY.f3);
         break;
      case 3:
         if(FUNKEY.f4[0] == '\0') 
           sprintf(OutText,"F4  : **** Not defined ****");
         else
           sprintf(OutText,"F4  : %s",FUNKEY.f4);
         break;
      case 4:
         if(FUNKEY.f5[0] == '\0') 
           sprintf(OutText,"F5  : **** Not defined ****");
         else
           sprintf(OutText,"F5  : %s",FUNKEY.f5);
         break;
      case 5:
         if(FUNKEY.f6[0] == '\0') 
           sprintf(OutText,"F6  : **** Not defined ****");
         else
           sprintf(OutText,"F6  : %s",FUNKEY.f6);
         break;
      case 6:
         if(FUNKEY.f7[0] == '\0') 
           sprintf(OutText,"F7  : **** Not defined ****");
         else
           sprintf(OutText,"F7  : %s",FUNKEY.f7);
         break;
      case 7:
         if(FUNKEY.f8[0] == '\0') 
           sprintf(OutText,"F8  : **** Not defined ****");
         else
           sprintf(OutText,"F8  : %s",FUNKEY.f8);
         break;
      case 8:
         if(FUNKEY.f9[0] == '\0') 
           sprintf(OutText,"F9  : **** Not defined ****");
         else
           sprintf(OutText,"F9  : %s",FUNKEY.f9);
         break;
      case 9:
         if(FUNKEY.f10[0] == '\0') 
           sprintf(OutText,"F10 : **** Not defined ****");
         else
           sprintf(OutText,"F10 : %s",FUNKEY.f10);
         break;
      case 10:
         if(FUNKEY.f11[0] == '\0') 
           sprintf(OutText,"F11 : **** Not defined ****");
         else
           sprintf(OutText,"F11 : %s",FUNKEY.f11);
         break;
      case 11:
         if(FUNKEY.f12[0] == '\0') 
           sprintf(OutText,"F12 : **** Not defined ****");
         else
           sprintf(OutText,"F12 : %s",FUNKEY.f12);
         break;
       }
      PrintMessage(OutText);
    }
 }
/************************************************************************/
int ShowDefLines()
/************************************************************************/
{
    int i;
    char OutText[BUFF_LEN];

    if(PlotLine.Lines < 1) {
       PrintMessage("?ERROR - no lines defined ");
       return(1);}

    PrintMessage("** defined lines **");

    for(i = 0 ; i < PlotLine.Lines ; i++) {
       sprintf(OutText,"(%d) x:%f y:%f z:%f <--> x:%f y:%f z:%f",
               (i+1),
               PlotLine.LineCoord[6*i]     + sumx, 
               PlotLine.LineCoord[6*i + 1] + sumy, 
               PlotLine.LineCoord[6*i + 2] + sumz, 
               PlotLine.LineCoord[6*i + 3] + sumx, 
               PlotLine.LineCoord[6*i + 4] + sumy, 
               PlotLine.LineCoord[6*i + 5] + sumz);
        PrintMessage(OutText);}
     return(0);
}
/************************************************************************/
int ShowDefSpheres()
/************************************************************************/
{
    int i;
    char OutText[BUFF_LEN];

    if(PlotSphere.Spheres < 1) {
       PrintMessage("?ERROR - no spheres defined ");
       return(1);}

    PrintMessage("** defined spheres **");

    for(i = 0 ; i < PlotSphere.Spheres ; i++) {
       sprintf(OutText,"(%d) x:%f y:%f z:%f radius:%f",
               (i+1),
               PlotSphere.SphereCoord[3*i]     + sumx, 
               PlotSphere.SphereCoord[3*i + 1] + sumy, 
               PlotSphere.SphereCoord[3*i + 2] + sumz,
               PlotSphere.Radius[i]);
        PrintMessage(OutText);}
     return(0);
}
/************************************************************************/
ShowCellDim()
/************************************************************************/
{
         char OutText[BUFF_LEN];

         PrintMessage("Cell dimensions:");
         sprintf(OutText,"a: %g , b: %g , c: %g",cell.a,cell.b,cell.c);
         PrintMessage(OutText);
         sprintf(OutText,"Alpha: %f , Beta: %f , Gamma: %f",
              cell.alpha,cell.beta,cell.gamma);
         PrintMessage(OutText);
         sprintf(OutText,"Xtrans: %f , Ytrans: %f , Ztrans: %f",
              cell.Xtrans,cell.Ytrans,cell.Ztrans);
         PrintMessage(OutText);
}

/************************************************************************/
show_atom_cent()
/************************************************************************/
{

     char OutText[BUFF_LEN];

     sprintf(OutText,"XCent: %f  YCent: %f  ZCent: %f",sumx,sumy,sumz);

     PrintMessage(OutText);
}
/************************************************************************/
ShowContourStats()
/************************************************************************/
{
    char OutText[BUFF_LEN];
    int  i,j,k;

    if(ContoursDefined < 1) {
       PrintMessage("** No contour information available **");
       return;}

    PrintMessage("** Contour information **");

    j = 1;

    for(k = 0 ; k < ContoursDefined ; k++) {

/*
    if(ContourInfo[k].Display) {
       continue;}
*/
    sprintf(OutText," (%d) Contour name    :  '%s'",j,ContourInfo[k].Name);
    PrintMessage(OutText);
    sprintf(OutText,"      Contour file name: '%s'",ContourInfo[k].ContFile);
    PrintMessage(OutText);
    
    sprintf(OutText," Min value: %.3f , Max value: %.3f",ContourInfo[k].min,
                                                         ContourInfo[k].max);
    PrintMessage(OutText);
 
   for(i = 0 ; i < ContourInfo[i].NumVal ; i++) {
    sprintf(OutText," Show level: %.3f in colour '%s'",ContourInfo[k].ColVal[i],
                                                       ContourInfo[k].ColNam[i]);
    PrintMessage(OutText);}
    
    sprintf(OutText," Eating memory (kB): %d",(ContourInfo[k].xdim*
                                               ContourInfo[k].ydim*
                                               ContourInfo[k].zdim*
                                               sizeof(float)) / 1000);
    PrintMessage(OutText);

    sprintf(OutText," Alpha blend: %.3f",ContourInfo[k].AlphaBlend);
    PrintMessage(OutText);
    if(ContourInfo[k].ContSmooth)
      sprintf(OutText," Smoothing is ON");
    else
      sprintf(OutText," Smoothing is OFF");

    PrintMessage(OutText);

    if(ContourInfo[k].Display)
      sprintf(OutText," Display is ON");
    else
      sprintf(OutText," Display is OFF");
   
    PrintMessage(OutText);
    j++;}
}
/************************************************************************/
int ShowTrajectoryStats()
/************************************************************************/
{

    char OutText[BUFF_LEN];

    PrintMessage("********** Trajectory info **********");
    if(trajectory_info.traj_file[0] == '\0') {
       PrintMessage("+++ Trajectory file not set +++");
       return(1);}

    sprintf(OutText,"Trajectory file name: '%s'",trajectory_info.traj_file);
    PrintMessage(OutText);

    sprintf(OutText,"Total number of frames in file: '%d'",
            trajectory_info.nstep);
    PrintMessage(OutText);

    sprintf(OutText,"Number of frames to be shown:   '%d'",
            FramesInSet());
    PrintMessage(OutText);

    sprintf(OutText,"First frame (nr): '%d'",TrajectoryFirstFrame());
    PrintMessage(OutText);

    sprintf(OutText,"Last frame (nr) : '%d'",TrajectoryLastFrame());
    PrintMessage(OutText);

    sprintf(OutText,"Step frames (nr): '%d'",TrajectoryStepFrame());
    PrintMessage(OutText);
}
