/*  

                       Copyright (c) 1990 by:
        Leif Laaksonen , Centre for Scientific Computing , ESPOO , FINLAND
            Confidential unpublished property of Leif Laaksonen
                        All rights reserved
  

*/

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <math.h>
#include <sys/types.h>
#include <malloc.h>

#ifdef sgi
#include <device.h>
#include <gl/gl.h>
#define SURFACE_DEF()     {  mmode(MVIEWING);\
                             MakeOrtho();\
                             def_simple_light_calc();\
                             use_simple_light_calc();}

#define NO_SURFACE()      {  getmatrix(CurrM);\
                             mmode(MSINGLE);\
                             MakeOrtho();\
                             /*loadmatrix(CurrM);*/}
#endif

#include "maxdefs.h"
#include "traja.h"

#define RABS(x) ((x) >= 0.0 ? (x) : -(x))
#define STRTOK(a,b) own_strtok(a,b)

#define SELECTION(a,b) {   strncpy(chelp,a,BUFF_LEN);\
         toller(chelp);\
          strncpy(chelp1,b,BUFF_LEN);\
           toller(chelp1);\
         ihelp     = 0;\
         color_def = 0;\
\
        if(chelp[0] != '\0') { \
           if(indexo(chelp,"appe") == 1) {\
            ihelp=1;}\
           else {/* yes a color is defined */\
            color_def = 1;\
            ihelp1 = name_to_rgb(chelp,&crgb[0],&crgb[1],&crgb[2]);\
            if(ihelp1 > 0) color_def = 0;}}\
\
        if(chelp1[0] != '\0') {\
           if(indexo(chelp1,"appe") == 1) {\
             ihelp=1;}\
           else {/* yes a color is defined */\
            color_def = 1;\
            ihelp1 = name_to_rgb(chelp1,&crgb[0],&crgb[1],&crgb[2]);\
            if(ihelp1 > 0) color_def = 0;}}}


extern int Show_Form_StereoMode();
extern int read_traj();
extern char *LookForPar();
extern char *LookForBra();
extern void PrintMessage();
extern int show_text_world();
extern float GetXCoord();
extern float GetYCoord();
extern float GetZCoord();
extern int GetResNum1();
extern char *GetResName();
extern void MakeOrtho();
extern void PutSBuffer();
extern void PutDBuffer();
extern int  set_type();
extern int  DeleteTrajectoryInfo();
extern char *own_strtok();
extern int   SetTorsPeriod();
extern char *GetInsideLim();
extern void  DisableMultiWindow();
extern void  EnableMultiWindow();
extern int   SetTrajectoryUserLimits();
extern int   SetRealStereoON();
extern int   IsStereoON();
extern int   SetRealStereoOFF();

 extern int term_type;
 extern int dic_read;
 extern int current_struct;
 extern short line_width;
 extern int search_window;
 extern short bgcolor[]; /* background colour */
 extern short obcolor[];
 extern short txcolor[];
 extern int indexo();
 extern int label_deep;
 extern char *label_list;
 extern int max_traj_mem;
 extern int traj_in_core;
 extern int dampfn;
 extern float near;
 extern float far;
 extern short BOX;
 extern int disp_obj[];
 extern int check_if_file_exist();
 extern int win_ids[];
 extern int winnr;
 extern int force_type; /* type of force field used */
 extern char energy_file[];
 extern float *bvalue;
 extern char *liquorice_list;
 extern float HitSphere2; /* square of the "hit sphere" when picking */
 extern float sumx,sumy,sumz;
     extern int *res1;
     extern int minres1;
     extern int maxres1;

     extern int mlist_deep;      /* stack number indicator */
     extern int mlists[MAX_MLIST]; /* First index for molecule list */
     extern int mliste[MAX_MLIST]; /* Second index for molecule list */
     extern char mnlist[MAX_MLIST][BUFF_LEN]; 
                                /* name list for molecule file names */
     extern int yn_surf;
     extern int liq_surf;
     extern char parsed[][MAXlinel];
     extern char  prompt[BUFF_LEN]; 
     extern int surf_style;
     extern float liq_rads;
     extern float liq_radc; 
     extern int alpha_trace;
     extern char traj_file[BUFF_LEN];
     extern int traj_file_set;
     extern int sphere_seg;
     extern int cyl_seg;
     extern int **atmcol;
     extern char *disp_list;
     extern float *atm_charge;
     extern char *surface_list;
     extern char *atnam;
     extern char *resnam;
     extern char *segment;
     extern float *x,*y,*z;
     extern float *cpk_scale;
     extern int *atm_type;
     extern int *ivector();
     extern float find_mass();
     extern int select_list();
     extern int indexo();

     extern int col_tbl_max;  /* number of entries in the colour table */
     extern struct SCARE_col_table {
     int red;      /* read value */
     int green;    /* green value */
     int blue;     /* blue value */
     char name[MAX_COL_LEN]; } ;

    extern struct SCARE_col_table *col_table;  /* name of colour */

/*  cell dimensions */
    extern struct cell_dim {
    float a;
    float b;
    float c;
    float alpha;
    float beta;
    float gamma;
    float Xtrans;
    float Ytrans;
    float Ztrans;};
    
    extern struct cell_dim cell;

/*  debug structure */
    extern struct {
    int DebugL;} DebugS;

/* structur containing pointers to dynamics display variables */
    extern struct dyna_disp_var {
      int numset;             /* number of sets (or variables) */
      int current_set;        /* index to current set          */
      int point_len;          /* length of point array         */
      int *point_vec;         /* pointer to point array        */
      int dist_len;           /* length of dist array          */
      int *dist_vec;          /* pointer to dist array         */
      int ang_len;            /* length of angle array         */
      int *ang_vec;           /* pointer to angle array        */
      int tors_len;           /* length of torsion array       */
      int *tors_vec;          /* pointer to torsion array      */
      int obs_vec_len;        /* observation array length      */
      int obs_vec_curr;       /* display current               */
      float *obs_vec;};       /* pointer to observation array  */

    extern struct dyna_disp_var play_dynam_frames;

/* structure for the dynamics trajectory file */

   extern struct {
    char traj_file[BUFF_LEN];                 /* file name          */
    int natom;                                /* number of atoms    */
    int nstep;                                /* number of steps    */
    int time_bw_steps;                        /* time between steps */
    int time_first_frame;                     /* time of first frame */
    int first_frame;                          /* first frame to be displayed */
    int last_frame;                           /* last frame to be displayed  */
    int delta_frame;                          /* display every delta frame */
                   }    trajectory_info;     

   struct {
    int   tote_set;
    int   kine_set;
    int   pote_set;
    int   temp_set;
    int   bond_set;
    int   angl_set;
    int   dihe_set;
    int   impr_set;
    int   vdw_set;
    int   elec_set;
    int   hbond_set;
    int   charm_set;
   float min_tote;
   float max_tote;
   float min_kine;
   float max_kine;
   float min_pote;
   float max_pote;
   float min_temp;
   float max_temp;
   float min_bond;
   float max_bond;
   float min_angl;
   float max_angl;
   float min_dihe;
   float max_dihe;
   float min_impr;
   float max_impr;
   float min_vdw;
   float max_vdw;
   float min_elec;
   float max_elec;
   float min_hbond;
   float max_hbond;
   float min_charm;
   float max_charm; } traj_energy_limits ;

   extern struct {
   int txcolor[3]; /* text colour , default white */
   char txfont[BUFF_LEN]; /*text font */
   float  txtsize; /* text size */} txt_param;

   extern struct et {
   int step_nr;
   float time_in_fs;
   float tote;
   float kine;
   float pote;
   float temp;
   float bond;
   float angl;
   float dihe;
   float impr;
   float vdw;
   float elec;
   float hbond;
   float charm; };

   extern struct et *traj_energy;

   extern int et_count;

/* pointers for force calculation */

     extern struct force_struct {
     int    set;  /* switch if the forces are set = 0 , not != 0, yes */
     int   plot;  /* switch for a plot = 0 , no plot , != 0 a plot */
     float  *fx;  /* pointers to the forces */
     float  *fy;
     float  *fz;
     int *sel_list; /* selection list */
     int  ent_list; /* entries in the selection list */
     float scale; /* scale factor */
     int   maxfi; /* index of max force atom */
     float maxfa; /* value of the max force  */
     int   minfi; /* index on min force atom */
     float minfa; /* value of the min force  */ } atm_force; 

     extern int CurMaterial;

     extern int surface_reset;

     extern int fake_now;

/* contour structure */
     extern int    ContoursDefined;   /* number of contours defined */

     extern struct Contour_Struct {
     float *data;           /* contour data */
     float min;
     float max;
     int xdim;
     int ydim;
     int zdim;
     float Xtrans;
     float Ytrans;
     float Ztrans;
     float Xscale;
     float Yscale;
     float Zscale;
     float ColVal[MAX_CONT];
     int   NumVal;
     char  ColNam[MAX_CONT][BUFF_LEN];
     char  ContFile[BUFF_LEN];
     float AlphaBlend;
     int   ContSmooth;
     char  Name[BUFF_LEN];
     int   Display;} ContourInfo[MAX_CONTOURS];


    extern struct SURF_LIM {
    int set;             /* = 0 , not set , > 0 set */
    float Xmin;
    float Xmax;
    float Ymin;
    float Ymax;
    float Zmin;
    float Zmax;
    char  MeshFile[BUFF_LEN];
    char  WFFile[BUFF_LEN];
    float ProbeVal;
    int Orbital;
    int Dmethod;
    int Xpts;
    int Ypts;
    int Zpts;
                   } DENSITY_limits , PROBE_limits , VSS_limits;

    extern struct {
     char Changed;
     int BufferMode;
    } DBuffer;


    extern struct {
      int zbuffer;      /* number of bitplanes in the zbuffer */
      int XPmax;        /* number of pixels in x */
      int YPmax;        /* number of pixels in y */
      int Blend;        /* 1 alpha blend possible , 0 not possible */
      char Info[BUFF_LEN]; /* Hardware and GL library version */
      } HW;

/*
      Scarecrow is using the following Projection Transformations

      0 => Scarecrow is using ortho
      1 =>                    perspective
*/
      extern struct Projection {
       int Fovy;           /* in tenths of degrees */
       int Transformation; } Model;

       extern struct {
         float Angle;       /* rotation angle */
         float Translate;   /* translation from the centre */
         int   Active;      /* == 0 off , != 0 on */
         int   Set;         /* == 0 reset , != do not reset */
                  } StereoPlot;


int dynamics_frames;  /* number of "frames" in the trajectory file */
int dynamics_pasback[20]; /* usefull information from the trajectory file */

int bg_window_id = -1;  /* id of the back ground window , if = -1 there is
                           no back ground window */

int colour_structure_by = 0; /* = 0 , normal colouring
                                = 1 , by frame total energy
                                = 2 , by frame kinetic energy
                                = 3 , by frame potential energy
                                = 4 , by frame temperature 
                             */

     int display_text = 0; /* display text if > 0 */

     int selection_mode = 0; /* = 0 select by residue , = 1 select by atom */

     int b_disp_a = 0; /* bond display type o => "soft" , 1 => "half" */

     int video_dev = 0;  /* output device for making video recording 
                            = 0 , tape
                            = 1 , CD device */

     struct {
       int set;          /* = 0 , colouring not set , > 0 colouring set */
       float max;
       float min;}   charge_color;

     int struc_peek = 0;   /* peek to the selected structure */


     struct {        /* structure to hold the command for the Funct keys */
       char f1[BUFF_LEN];
       char f2[BUFF_LEN];
       char f3[BUFF_LEN];
       char f4[BUFF_LEN];
       char f5[BUFF_LEN];
       char f6[BUFF_LEN];
       char f7[BUFF_LEN];
       char f8[BUFF_LEN];
       char f9[BUFF_LEN];
       char f10[BUFF_LEN];
       char f11[BUFF_LEN];
       char f12[BUFF_LEN]; } FUNKEY = { "\0" ,"\0" ,"\0" ,"\0" ,"\0" ,"\0" ,
                                        "\0" ,"\0" ,"\0" ,"\0" ,"\0" ,"\0" } ;


       int LookForHat();

       int AutoScreenBlank = 1;    /* != 0 do always screenblank between
                                           frames
                                      == 0 no screenblank between frames */

       struct {
        int CalcConn; /* if != 0 connectivity is calculated for each frame */
              } Connect = { 0 };

       struct {
        int InUse;
        int  slong;           /* length of the list */
        int *sel_list;        /* index to atoms     */
          } ManSelection = { 0 , 0 , NULL};


       int ChooseManSelection(char *text1 , char *text2 , char *text3);
       int DelManSelectionList();
       int SelectionListInUse();

/************************************************************************/
set_fac(input,num)   /* interpret the set command */
   char *input; 
   int num;
/************************************************************************/
{

     static int i;
     static int ihelp;
     static float fhelp;
     static char  chelp[BUFF_LEN];
     static float CurrM[4][4];

     char OutText[BUFF_LEN];

     toller(parsed[1]);

/* ? help facility                                                         */
    if(indexo(parsed[1],"?") == 1) {
 PrintMessage("Help for the 'set' command \n");
 PrintMessage("set alph*a on/off                          ! Set alpha trace on/off");
 PrintMessage("set atom cpk seg:res:atom [appe*end]       ! Set cpk display ");
 PrintMessage("             scal*e fnum [seg:res:atom]    ! Scale cpk radius ");
 PrintMessage("             styl*e cova*lent              ! Use covalent cpks ");
 PrintMessage("                    vdw                    ! Use vdw cpks    ");
 PrintMessage("         colo*our seg:res:atom nr1 nr2 n3  ! Set atom colours ");
 PrintMessage("         disp*lay seg:res:atom [appe*end]  ! Set atom display ");
 PrintMessage("         labe*ls seg:res:atom              ! Set atom labels ");
 PrintMessage("        -lab*els seg:res:atom              ! Set atom labels off");
 PrintMessage("         lico*rice seg:res:atom [append]   ! Set licorice on ");
 PrintMessage("         list on                           ! Set selection active");
 PrintMessage("         list off                          ! Set selection off");
 PrintMessage("         arou*nd s:r:a [x:y:z] rad [appe*nd][colo] ! Set display select ");
 PrintMessage("         arou*nd cmas*s s:r:a  rad [color][appe*nd]! Set display select ");
 PrintMessage("         sear*ch inum                      ! Set search window ");
 PrintMessage("         type*s                            ! Set atom types");
 PrintMessage("     bmod*e single/double                  ! Set buffer mode");
 PrintMessage("     bond soft/half                        ! Set bond display soft/half");
 PrintMessage("     box on/off                            ! Set box on/off ");
 PrintMessage("     cell dime*nsions a b c alpha beta gamma xtrans ytrans ztrans");
 PrintMessage("     colo*ur char*ge                       ! Colour by charge ");
 PrintMessage("             hydr*o                        ! Colour by hydropho/hydrophi");
 PrintMessage("             forc*e                        ! Set colour by atom forces");
 PrintMessage("             resi*due num*bers             ! Colour by residue numbers");
 PrintMessage("             four*thparameter              ! Colour by fourth parameter");
 PrintMessage("             fram*e tote*nergy              ! Colour by frame total energy");
 PrintMessage("                    kine*nergy              ! Colour by frame kinetic energy");
 PrintMessage("                    pote*nergy              ! Colour by frame potential energy");
 PrintMessage("                    temp*erature            ! Colour by frame temperature");
 PrintMessage("     cont*our alph*ablend  value [tag]     ! Set alpha blend ");
 PrintMessage("              dime*nsions  xmin value ...  ! Set contour dimensions");
 PrintMessage("              smoo*th on/off     [tag]     ! Smooth the contour");
 PrintMessage("     curr*ent stru*cture nr                ! Set current structure");
 PrintMessage("     cyli*nder points  inr                 ! Set num of cyl points ");
 PrintMessage("     dyna*mics file file.name  [type]      ! Set dyn file name and type");
 PrintMessage("               conn*ectivity on/off        ! Connectivity for each frame");
 PrintMessage("               ener*gy file file.name      ! Set energy file name ");
 PrintMessage("               obje*ct on/off              ! Set dyn obj on/off ");
 PrintMessage("               obje*ct inumber             ! Set dyn obj number ");
 PrintMessage("     fkey1 [fkey2,fkey3...] command        ! Set function keys");
 PrintMessage("     fulls*creen on/off                    ! Set fullscreen on/off");
 PrintMessage("     hits*sphere   nr                      ! Set hit sphere ");
 PrintMessage("     line widt*h inr                       ! Set line width (in pixels)");
 PrintMessage("     liqu*ourice cyli*nder frad            ! Set liq cyl radius ");
 PrintMessage("                 sphe*re   frad            ! Set liq sphere radius ");
 PrintMessage("     sele*ction resi*due/atom              ! Set selection mode ");
 PrintMessage("     sphe*re points  inr                   ! Set num of sphere points ");
 PrintMessage("     ster*eo on                            ! Set stereo mode on");
 PrintMessage("             off                           ! Set stereo mode off");
 PrintMessage("             angl*e       fvalue           ! Set stereo object angle");
 PrintMessage("             tran*slation fvalue           ! Set stereo object distance");
 PrintMessage("     video cd   on/off                     ! Use cd for video ");
 PrintMessage("           tape on/off                     ! Use tape for video ");
 PrintMessage("     prom*pt text                          ! Set prompt to 'text' ");
 PrintMessage("     bgco*lour name [nr1 nr2 nr3]          ! Set background colour");
 PrintMessage("     obco*lour name [nr1 nr2 nr3]          ! Set object colour");
 PrintMessage("     txco*lour name [nr1 nr2 nr3]          ! Set text colour");
 PrintMessage("     text co*lour name [nr1 nr2 nr3]       ! Set text colour ");
 PrintMessage("          fo*nt name                       ! Set text font to 'name'");
 PrintMessage("          mode on/off                      ! Display text ");
 PrintMessage("          si*ze nr                         ! Set text size to 'nr'");
 PrintMessage("     tors*ion rang*e half/full             ! Set torsion range");
 PrintMessage("     trajm*emory  inr                      ! Set max traj memory ");
 PrintMessage("     surf*ace rese*t on/off                ! Set default surface on/off");

/*  This has to be fixed asap
 PrintMessage("     wind*ow loca*tion xpixel ypixel       ! Set window location");
 PrintMessage("             size ipixels                  ! Set Window size in pixels");
*/
 return;}

/* set prompt      (default is ':> ')                                      */
    if(indexo(parsed[1],"prom") == 1) {
    change_prompt(num);
    sprintf(OutText,"Prompt changed to : '%s' \n",prompt);
     PrintMessage(OutText);
    return;}

    if(indexo(parsed[1],"test") == 1) {

    (void)AcceptCallsIn();
/*
      if(LookForPar(parsed[1]) != NULL) printf("'%s'\n",LookForPar(parsed[1]));
      {
         char Junk[BUFF_LEN];
         printf("'%s'\n",GetInsideLim(parsed[1] , "()"));
       }
*/
/*      Driver_MakeSequence(); */
      return;
    }

/* debug levels                     */
    if(indexo(parsed[1],"debug") == 1) {
      DebugS.DebugL = atoi(parsed[2]);
      return;}

/* set atom display , select the atoms to be displayed    (by default all) */

    if(indexo(parsed[1],"atom") == 1) {

        toller(parsed[2]);

        if(indexo(parsed[2],"sear") == 1) {
          ihelp = atoi(parsed[3]);
          sprintf(OutText,"Search window for atom connections is: %d",search_window);
          PrintMessage(OutText);
          if(ihelp < 1) return;
          search_window = ihelp;
          sprintf(OutText,"Search window is changed to %d",search_window);
          PrintMessage(OutText);
          atom_conn();         /* make new atom connection list */
          return;
        }

/*      atom list      */
         if(indexo(parsed[2],"list")   == 1 ||
            indexo(parsed[2],"sele")   == 1) {
            toller(parsed[3]);
            if(indexo(parsed[3],"on")  == 1) {
               ManSelection.InUse = 1;
               return;}
            if(indexo(parsed[3],"off") == 1) {
               ManSelection.InUse = 0;
               return;}
	  }

/*      atom types     */
         if(indexo(parsed[2],"type") == 1) {
           if(!dic_read) {
              PrintMessage("?ERROR - no dictionary file defined");
              return;}
              ihelp = set_type();
              return;}

/*       atom labels   */
         if(indexo(parsed[2],"labe") == 1 || indexo(parsed[2],"labe") == 2) {

           if(parsed[2][0] == '-') 
                                  ihelp = 1;  /* subtract from list */
           else
                                  ihelp = 0;

           parse_label_list(ihelp , parsed[3],parsed[4],parsed[5]);
           return;}

        if(indexo(parsed[2],"disp") == 1 || indexo(parsed[2],"disp") == 2) {
           if(parsed[2][0] == '-') ihelp = 1;
           else
           ihelp = 0;
/*         if(num < 6) return; */
         parse_display_list(ihelp);
         return;}

        if(indexo(parsed[2],"roun") == 1 || indexo(parsed[2],"arou") == 1 ) {

/* round centre of mass                       */
          strncpy(chelp,parsed[3],BUFF_LEN);
          toller(chelp);
          if(indexo(chelp,"cmas") == 1) {
            select_round_atoms(3);
            return;}
/* .......................................... */

/* it as accepted as a number if first character is number,+ ,- or . */
/* handle the fact that the segment name can have a digit as the first char */
/* temporary fix up (if it happens change it to a char) */

          if((isdigit(parsed[3][0]) || parsed[3][0] == '+' || 
                                       parsed[3][0] == '-' ||
                                       parsed[3][0] == '.' ) &&
             (isdigit(parsed[4][0]) || parsed[4][0] == '+' || 
                                       parsed[4][0] == '-' ||
                                       parsed[4][0] == '.' ) &&
             (isdigit(parsed[5][0]) || parsed[5][0] == '+' || 
                                       parsed[5][0] == '-' ||
                                       parsed[5][0] == '.' )) {
          select_round_atoms(1);
          return;}
          else {
          select_round_atoms(2);
          return;}}

/* licorice display */
        if(indexo(parsed[2],"liqu") == 1 ||
           indexo(parsed[2],"lico") == 1) {
           ihelp = 0;
            parse_licorice_list(ihelp);
             liq_surf = 1;
              return;}
        if(indexo(parsed[2],"-liq") == 1 ||
           indexo(parsed[2],"-lic") == 1) {
           ihelp = 1;
            parse_licorice_list(ihelp);
             if(parsed[3][0] == '\0' ||
                (parsed[3][0] == '*' &&
                 parsed[4][0] == '*' &&
                 parsed[5][0] == '*')) liq_surf = 0;
              return;}

        if(indexo(parsed[2],"cpk") == 1 || indexo(parsed[2],"cpk") == 2) {
          ihelp = 0;
          yn_surf = 1;

         if(parsed[2][0] == '-') {
           ihelp = 1;
             if(parsed[3][0] == '\0' ||
                (parsed[3][0] == '*' &&
                 parsed[4][0] == '*' &&
                 parsed[5][0] == '*')) yn_surf = 0;}

          if(num <  3 && yn_surf) ihelp = 1;

         if(term_type == 1 || term_type == 3) {
#ifdef sgi
/*
         if(yn_surf != 0) {
                         SURFACE_DEF();}
         else {
                          NO_SURFACE();}
*/
#endif
       }

/* check for cpk style                             */
           strncpy(chelp,parsed[3],BUFF_LEN);
           toller(chelp);
           if(indexo(chelp,"styl") == 1) {  /* define cpk type */
           toller(parsed[4]);
           if(indexo(parsed[4],"vdw") == 1) { 
            surf_style = 0;
            return;}
           if(indexo(parsed[4],"cova") == 1) {
            surf_style = 1;
            return;}
           PrintMessage("?ERROR - undefined cpk display style \n");
	 }
/* end cpk style                                  */

/* check for cpk scale factor                     */
         if(indexo(chelp,"scal") == 1) { /* cpk scale factor */
           fhelp = atof(parsed[4]);
           if(fhelp < 0.0001) {
           PrintMessage("?ERROR - scale factor too small \n");
           return;}

           parse_cpk_scale(parsed[5],parsed[6],parsed[7],fhelp);
           return;
         }
/* end of cpk scale                               */


         parse_surface_list(ihelp);
      return;}     
/* set atom colour                                 */
/* the command should look like this: 
       set atom colour segment residue atom nr1 nr2 n3  or
       set atom colour segment residue atom colourname  where
       the 'colourname' has been defined before as an 3 element array */
         if(indexo(parsed[2],"colo") == 1) {

         if(parsed[6][0] == '\0') {
           PrintMessage("?ERROR - color code or name not defined \n");
           return;
         }

         if(isalpha(parsed[6][0]) || (indexo(parsed[6],SEP_COLOR) > 0)) {
         parse_color_name();
         }
         else
         parse_color_list();
       return;
       }
      }


/* set cell dimensions                      */
      if(indexo(parsed[1],"cell") == 1) {
         toller(parsed[2]);
         if(indexo(parsed[2],"dime") == 1) {
         cell.a = atof(parsed[3]); 
      if(cell.a < 1.e-05) PrintMessage("?ERROR - too small value given (a)");
         cell.b = atof(parsed[4]); 
         cell.c = atof(parsed[5]); 

      if(cell.b < 1.e-05) cell.b = cell.a;
      if(cell.c < 1.e-05) cell.c = cell.a;

         if(parsed[5][0] != '\0')
            cell.alpha = atof(parsed[6]); 
         if(parsed[6][0] != '\0')
            cell.beta  = atof(parsed[7]); 
         if(parsed[7][0] != '\0')
            cell.gamma = atof(parsed[8]); 

         if(parsed[8][0] != '\0')
            cell.Xtrans = atof(parsed[9]);
         if(parsed[9][0] != '\0')
            cell.Ytrans = atof(parsed[10]);
         if(parsed[10][0] != '\0')
            cell.Ztrans = atof(parsed[11]);

         return;}}

/* set selection mode                       */
      if(indexo(parsed[1],"sele") == 1) {
        toller(parsed[2]);
        if(indexo(parsed[2],"resi") == 1) {
          selection_mode = 0;
          return;}
        if(indexo(parsed[2],"atom") == 1) {
          selection_mode = 1;
          return;}
       }

/* set box on/off                           */
      if(indexo(parsed[1],"box") == 1) {
        toller(parsed[2]);
        if(indexo(parsed[2],"on") == 1) 
          BOX = 1;
        if(indexo(parsed[2],"off") == 1) 
          BOX = 0;
        return;}

/* set contour alpha blend                       */
        if(indexo(parsed[1],"cont") == 1) {
          toller(parsed[2]);
          if(indexo(parsed[2],"alph") == 1) {
          /* check if HW supported */
          if(!HW.Blend) {
            PrintMessage("?WARNING - alpha blending not supported on current hardware");
            return;}

            fhelp = atof(parsed[3]);
            if(fhelp < 0.001) {
              PrintMessage("?ERROR - alpha blend factor too small");
              return;}
/* valid values 0.0 ... 1.0 */
                if(parsed[4][0] != '\0') {
/* chack that name exists                      */
                   i = CheckContourName(parsed[4]);
                     if(i < 0) {
                     PrintMessage("?ERROR - no contour defined or wrong name");
                     return;}

            if(fhelp < 0.0) fhelp = 0.0;
            if(fhelp > 1.0) fhelp = 1.0;
            sprintf(OutText,"Changing alpha blend factor from %f ==> %f",
                    ContourInfo[i].AlphaBlend,fhelp);
            PrintMessage(OutText);
            ContourInfo[i].AlphaBlend = fhelp;
               return;}
               else {
                (void) SetContAlpha(fhelp);
                return;}}

/* define new limits */
          if(indexo(parsed[2],"dime") == 1) { /* set contour dimensions */

             if(indexo(parsed[3],"defa") == 1) { /* set default on */
                       DENSITY_limits.set = 0;
                       PROBE_limits.set   = 0;
                       VSS_limits.set     = 0;
                return;}
             DefNewLimits();
                return;
	  }
          if(indexo(parsed[2],"smoo") == 1) {
             toller(parsed[3]);
             if(indexo(parsed[3],"on") == 1)  {
                if(parsed[4][0] != '\0') {
/* chack that name exists                      */
                   i = CheckContourName(parsed[4]);
                     if(i < 0) {
                     PrintMessage("?ERROR - no contours defined or wrong name");
                     return;}

               ContourInfo[i].ContSmooth = 1;
               return;}
               else {
                (void) SetContSmoothOn();
                return;}}

             if(indexo(parsed[3],"off") == 1) {
                if(parsed[4][0] != '\0') {
/* chack that name exists                      */
                   i = CheckContourName(parsed[4]);
                     if(i < 0) {
                     PrintMessage("?ERROR - no contour defined or wrong name");
                     return;}

               ContourInfo[i].ContSmooth = 0;
               return;}
               else {
                (void) SetContSmoothOff();
                return;}}
             }}

/* set hit sphere                                */
      if(indexo(parsed[1],"hits") == 1) {
        fhelp = atof(parsed[2]);
        if(fhelp < 0.001) {
          PrintMessage("?ERROR - radius too small");
          return;}
        sprintf(OutText,"Hit radius changed from '%f' to '%f'",
                sqrt(HitSphere2),fhelp);
        PrintMessage(OutText);
        HitSphere2 = fhelp*fhelp;
        return;}

/* set depthcue on/off                           */
      if(indexo(parsed[1],"dept") == 1) {
#ifdef sgi
        toller(parsed[2]);
         if(indexo(parsed[2],"on") == 1) { 
PrintMessage("?ERROR - not yet working");
return;
         lsetdepth(0x0 , 0x7FFFFF);
         lRGBrange( 0 , 0 , 0 , 255 , 255 , 255 , 0 , 0x7FFFFF );
         depthcue(TRUE);
         return;}
         if(indexo(parsed[2],"off") == 1) {
         lsetdepth(0x0 , 0x7fffff );
         depthcue(FALSE);
        return;}
#else
        PrintMessage("?ERROR - not implemented on this device \n");
        return;
#endif
        }

/* set object colour */
      if(indexo(parsed[1],"obco") == 1) {
        set_obcolour(parsed[2],parsed[3],parsed[4]);
         return;
      }

/* set back ground colour */
      if(indexo(parsed[1],"bgco") == 1) {
        set_bgcolour(parsed[2],parsed[3],parsed[4]);
         return;
      }
/* set text colour (same as the next position, included just for symmetry)*/
      if(indexo(parsed[1],"txco") == 1) {
        set_txcolour(parsed[2],parsed[3],parsed[4]);
         return;
      }

/* text                   */
      if(indexo(parsed[1],"text") == 1) {

      toller(parsed[2]);

/* set text colour        */
      if(indexo(parsed[2],"colo") == 1) {
        set_txt_colour(parsed[3],parsed[4],parsed[5]);
         return;
      }

/* set text font          */
      if(indexo(parsed[2],"font") == 1) {
         ihelp = check_font(parsed[3]);
         if(ihelp < 0) {
         check_if_fatal(ihelp);
         return;}
         strncpy(txt_param.txfont,parsed[3],BUFF_LEN);
         return;
      }

/* set text size          */
      if(indexo(parsed[2],"size") == 1) {
         fhelp = atof(parsed[3]);
         if(fhelp > 0.0) {
         sprintf(OutText,"Text font size changed to %f ",fhelp);
         PrintMessage(OutText);
         txt_param.txtsize = fhelp;}
         return;}

/* set text mode on/off                       */
      if(indexo(parsed[2],"mode") == 1) {
        toller(parsed[3]);
        if(indexo(parsed[3],"on") == 1) 
          display_text = 1;
        if(indexo(parsed[3],"off") == 1) 
          display_text = 0;
        return;}

    }

/* set colour by charge                       */
      if(indexo(parsed[1],"colo") == 1) {
        toller(parsed[2]);
        if(indexo(parsed[2],"char") == 1) {
        color_by_charge(0);
        return;}
       }

/* set colour by residue numbers              */
      if(indexo(parsed[1],"colo") == 1) {
        toller(parsed[2]);
        if(indexo(parsed[2],"resi") == 1) {
        toller(parsed[3]);
          if(indexo(parsed[3],"num") == 1) {
          color_by_residue();
        return;}}
       }

/* set colour by fourth parameter             */
      if(indexo(parsed[1],"colo") == 1) {
        toller(parsed[2]);
        if(indexo(parsed[2],"four") == 1) {
        color_by_fourth();
        return;}
       }

/* set colour by frame total energy                       */
      if(indexo(parsed[1],"colo") == 1) {
        toller(parsed[2]);
        if(indexo(parsed[2],"fram") == 1) {
          toller(parsed[3]);
/* check that the entries are read in */
    if(et_count < 1) {
    PrintMessage("?ERROR - trajectory entries are not read in ");
    colour_structure_by = 0;
    return;}
          if(indexo(parsed[3],"tote") == 1) {
              if(traj_energy_limits.tote_set < 1) {
              PrintMessage("?ERROR - total energy array is not set up ");
              return;}
          colour_structure_by = 1;
          return;}

/* set colour by kinetic energy                   */

         if(indexo(parsed[3],"kine") == 1) {
              if(traj_energy_limits.kine_set < 1) {
              PrintMessage("?ERROR - kinetic energy array is not set up ");
              return;}
          colour_structure_by = 2;
        return;}

/* set colour by potential energy                */

        if(indexo(parsed[3],"pote") == 1) {
              if(traj_energy_limits.pote_set < 1) {
              PrintMessage("?ERROR - potential energy array is not set up ");
              return;}
          colour_structure_by = 3;
        return;}

/* set colour by temperature                       */

        if(indexo(parsed[3],"temp") == 1) {
              if(traj_energy_limits.temp_set < 1) {
              PrintMessage("?ERROR - temp array is not set up ");
              return;}
          colour_structure_by = 4;
        return;}
	}
      }


/* set colour by hydropho/hydrophi                       */
      if(indexo(parsed[1],"colo") == 1) {
        toller(parsed[2]);
        if(indexo(parsed[2],"hydr") == 1) {
        in_water();
        return;}
       }

/* set colour by force                        */
      if(indexo(parsed[1],"colo") == 1) {
        toller(parsed[2]);
        if(indexo(parsed[2],"forc") == 1) {
        if(atm_force.set == 0) {
          PrintMessage("?ERROR - force vectors not filled");
          return;}
        colour_by_force();
        return;}
       }

/* set video                                  */
#ifdef VIDEO_SCARE
       if(indexo(parsed[1],"vide") == 1) {
         toller(parsed[2]);
         if(indexo(parsed[2],"tape") == 1) {
           toller(parsed[3]);
            if(indexo(parsed[3],"on") == 1) video_dev = 0;
            if(indexo(parsed[3],"off") == 1) video_dev = 1;}
         if(indexo(parsed[2],"cd") == 1) {
           toller(parsed[3]);
            if(indexo(parsed[3],"on") == 1) video_dev = 1;
            if(indexo(parsed[3],"off") == 1) video_dev = 0;}

       switch(video_dev) {
       case 0:
               PrintMessage("Video device is tape ");
               break;
       case 1:
               PrintMessage("Video device is cd");
               break;
       default:
               PrintMessage("?ERROR - wrong device in command 'set video' ");
               break;}
       return;
       }
#endif

/* set bond half/soft                                    */
      if(indexo(parsed[1],"bond") == 1) {
        toller(parsed[2]);
          if(indexo(parsed[2],"soft")) {
             b_disp_a = 0;
             return;}
             
          if(indexo(parsed[2],"half")) {
             b_disp_a = 1;
             return;}
       }

/* set buffer mode 1 = single buffer , 2 = double buffer */
       if(indexo(parsed[1],"bmod") == 1) {
          toller(parsed[2]);
             if(indexo(parsed[2],"sing") == 1) {
                 if(DBuffer.BufferMode == 2) DBuffer.Changed = 1;
                 DBuffer.BufferMode = 1;
                 PrintMessage("#  Single Buffer Mode > ON <");
                 PutSBuffer();
                 return;}
             if(indexo(parsed[2],"doub") == 1) {
                 if(DBuffer.BufferMode == 1) DBuffer.Changed = 1;
                 DBuffer.BufferMode = 2;
                 PrintMessage("## Double Buffer Mode > ON <");
                 PutDBuffer();
                 return;}
          PrintMessage("?ERROR - unknown buffer mode");
        }

/* set frame "damping" factor                            */
      if(indexo(parsed[1],"fram") == 1) {
        toller(parsed[2]);
        if(indexo(parsed[2],"damp") == 1) {
        ihelp = atoi(parsed[3]);
        if(ihelp < 1) ihelp = 1;
        sprintf(OutText,"Frame 'damping factor' is changed from '%d' to '%d' \n",dampfn,ihelp);
        PrintMessage(OutText);
        dampfn = ihelp;
        return;}}

/* set liquorice cylinder and sphere radius              */
    if(indexo(parsed[1],"liqu") == 1 || indexo(parsed[1],"lico") == 1 ) {
     toller(parsed[2]);
      if(indexo(parsed[2],"cyli") == 1) {
       fhelp = atof(parsed[3]);
       if(fhelp < 0.01) {
       PrintMessage("?ERROR - radius too small. Radius not changed");
       return;}
       sprintf(OutText,"Licorice cylinder radius changed from %f to %f",
                       liq_radc,fhelp);
       PrintMessage(OutText);
       liq_radc = fhelp;
       return;}
      if(indexo(parsed[2],"sphe") == 1) {
       fhelp = atof(parsed[3]);
       if(fhelp < 0.01) {
       PrintMessage("?ERROR - radius too small. Radius not changed\n");
       return;}
       sprintf(OutText,"Licorice sphere radius changed from %f to %f",
                       liq_rads,fhelp);
       PrintMessage(OutText);
       liq_rads = fhelp;
       return;}

/* set liquorice mode on/off                  */    
      if(indexo(parsed[2],"on") == 1) {
      PrintMessage("!!!Please use command 'set atom lico seg:res:atm'");
      return;} /* on */
      if(indexo(parsed[2],"off") == 1) {
      PrintMessage("!!!Please use command 'set atom -lico'");
      return;} /* off */
}


/* set current structure                      */
      if(indexo(parsed[1],"curr") == 1) {
        toller(parsed[2]);
              if(indexo(parsed[2],"stru") == 1) {
              ihelp = atoi(parsed[3]);
              if(ihelp < 1 || ihelp > mlist_deep) {
              PrintMessage("?ERROR - wrong structure number \n");
              return;}
              current_struct = ihelp - 1;}
       return;}

/* set alpha trace on/off                     */
      if(indexo(parsed[1],"alph") == 1) {
         toller(parsed[2]);
           if(indexo(parsed[2],"on") == 1) {
           alpha_trace = 1;
           disp_zone(4);
           return;} /* on */
           if(indexo(parsed[2],"off") == 1) {
           alpha_trace = 0; /* off */
           disp_zone(2);
           return;}
        }
           
/* set dynamics trajectory file name and type and dynamics object on/off and nr  */
   if(indexo(parsed[1],"dyna") == 1) {
     toller(parsed[2]);

     if(indexo(parsed[2],"conn") == 1) {
        toller(parsed[3]);
        if(indexo(parsed[3],"on") == 1) Connect.CalcConn = 1;
        if(indexo(parsed[3],"off") == 1) Connect.CalcConn = 0;
        return;}

     if(indexo(parsed[2],"ener") == 1) {
        toller(parsed[3]);
        if(indexo(parsed[3],"file") == 1) {
          ihelp = check_if_file_exist(parsed[4]);
          if(ihelp < 0) return;
          strncpy(energy_file,parsed[4],BUFF_LEN);
          return;}}

     if(indexo(parsed[2],"file") == 1) {
       if(num < 3) {
       PrintMessage("?ERROR - incomplete set dynamics file command ");
       return;}
/* check that file exist */
     ihelp = check_if_file_exist(parsed[3]);
     if(ihelp < 0) {
     check_if_fatal(ihelp);
     return;}
     (void)DeleteTrajectoryInfo();
     strncpy(traj_file,parsed[3],BUFF_LEN);
     strncpy(trajectory_info.traj_file,parsed[3],BUFF_LEN);
     traj_file_set = set_traj_type(parsed[4]); /* set dyna file type */
     force_type    = traj_file_set;
     i = read_traj(1,&dynamics_frames,dynamics_pasback);
     return;}

/* dynamics time between frames              */
        if(indexo(parsed[2],"ftim") == 1) {
           trajectory_info.time_bw_steps = atoi(parsed[3]);
           return;}

/* set dynamics object on/off                */
        if(indexo(parsed[2],"obje") == 1) {
          toller(parsed[3]);

          if(isdigit(parsed[3][0])) { /* display object number */
            ihelp = atoi(parsed[3]);
            if(ihelp < 1 || ihelp > play_dynam_frames.obs_vec_len) {
              sprintf(OutText,"?ERROR - alloved range is 0 - %d \n",
                     play_dynam_frames.obs_vec_len);
              PrintMessage(OutText);
                     return;}
            play_dynam_frames.obs_vec_curr = ihelp - 1;
            return;}

          if(indexo(parsed[3],"on") == 1) 
          disp_obj[0] = 1;
          if(indexo(parsed[3],"off") == 1) 
          disp_obj[0] = 0;
          return;}
          if(indexo(parsed[3],"grap") == 1) {
            toller(parsed[4]);
            if(indexo(parsed[4],"on") == 1) {
             disp_obj[1] = 1;
             return;}
            if(indexo(parsed[4],"off") == 1) {
             disp_obj[1] = 0;
             return;}}
   }

/* set number of points used to construct a sphere (pi and 2*n in 2*pi)  */
      if(indexo(parsed[1],"sphe") == 1) {
        toller(parsed[2]);
        if(indexo(parsed[2],"poin") == 1) {
      sprintf(OutText,"Number of sphere points is now: %d",sphere_seg);
      PrintMessage(OutText);
      ihelp = atoi(parsed[3]);
       if(ihelp > 0) {
       sprintf(OutText,"Number of sphere points is changed to : %d",ihelp);
       PrintMessage(OutText);
       sphere_seg = ihelp;}
      return;}}

/* set number of points used to construct a cylinder  ( 2*pi)  */
      if(indexo(parsed[1],"cyli") == 1) {
        toller(parsed[2]);
        if(indexo(parsed[2],"poin") == 1) {
      sprintf(OutText,"Number of cylinder points is now: %d",cyl_seg);
      PrintMessage(OutText);
      ihelp = atoi(parsed[3]);
       if(ihelp > 0) {
       sprintf(OutText,"Number of cylinder points is changed to : %d",ihelp);
       PrintMessage(OutText);
       cyl_seg = ihelp;}
      return;}}

/* set line width                                             */
      if(indexo(parsed[1],"line") == 1) {
        toller(parsed[2]);
        if(indexo(parsed[2],"widt") == 1) {
#ifdef sgi
        ihelp = atoi(parsed[3]);
        if(ihelp < 1) {
          PrintMessage("?ERROR - number of pixels has to be > 0 ");
          return;}
        sprintf(OutText,"Linewidth changed from %d pixel(s) to %d pixel(s)",
                line_width,ihelp);
        PrintMessage(OutText);
        linewidth(ihelp);
        line_width = ihelp;
#else
        PrintMessage("?ERROR - not implemented on this device ");
#endif
        return;}
      }

/* set maximun trajectory store memory                       */
      if(indexo(parsed[1],"traj") == 1) {
         toller(parsed[2]);

         if(indexo(parsed[2],"memo") == 1) {
           sprintf(OutText,
               "Maximum trajectory memory is now: %d Mbytes",max_traj_mem);
           PrintMessage(OutText);
           ihelp = atoi(parsed[3]);
           if(ihelp < 1) return;
           sprintf(OutText,
                "Maximum trajectory memory limit changed to: %d Mbytes",ihelp);
           PrintMessage(OutText);
           max_traj_mem = ihelp;
           traj_in_core = 0; /* reset switch to force check */
           return;}

         if(indexo(parsed[2],"limi") == 1) {
            if(SetTrajectoryUserLimits(atoi(parsed[3]) ,
                                       atoi(parsed[4]) ,
                                       atoi(parsed[5]))) {
                                       return;}
         return;}
       }

/* > fullscreen on                      < */
     if(indexo(parsed[1],"fulls") == 1) {
#ifdef sgi
       toller(parsed[2]);
       if(indexo(parsed[2],"on") == 1) {
       full_screen();
       return;}
       if(indexo(parsed[2],"off") == 1) {
/* > fullscreen off                     < */
       endfull_screen();
       return;}
#else
     PrintMessage("?ERROR - not implemented on this device ");
     return(0);
#endif
     }

/* set material                                */
     if(indexo(parsed[1],"mate") == 1) {
       ihelp = atoi(parsed[2]);
       if(ihelp < 1) ihelp = 22;
       DefineMaterials();
       SetMaterial(ihelp);
       return;
     }     

/* set light                                   */
     if(indexo(parsed[1],"ligh") == 1) {
       ihelp = atoi(parsed[2]);
       if(ihelp > 6) return;
       if(ihelp < 1) ihelp = 1;
       DefineLights();
       SetLight(ihelp);
       return;
     }

/* surface reset                             */
     if(indexo(parsed[1],"surf") == 1) {
       toller(parsed[2]);
       if(indexo(parsed[2],"rese") == 1) {
         toller(parsed[3]);
         if(indexo(parsed[3],"on") == 1) {
           PrintMessage("Surface default is now ON ");
           surface_reset = 1;
           return;} 
         if(indexo(parsed[3],"off") == 1) {
           PrintMessage("Surface default is now OFF ");
           surface_reset = 0;
           return;}
        }
      }
 
/* set near/far    */
     if(indexo(parsed[1],"nearfar") == 1) {
        Set_NearFar(parsed[2],parsed[3]);
         return;}

/* define function keys           */
     if(indexo(parsed[1],"fkey") == 1)   {
       if(DefFKey(atoi(&parsed[1][4]) , num)) {
         PrintMessage("?ERROR - can't define function keys");
         return;}
       return;}

/*   define window size and locations                                      */
     if(indexo(parsed[1],"wind") == 1) {
        toller(parsed[2]);
        if(indexo(parsed[2],"loca") == 1) {
           SetWindowLocation(atoi(parsed[3]) , atoi(parsed[4]));
           return;}
        if(indexo(parsed[2],"size") == 1) {
           SetWindowSize(atoi(parsed[3]) , atoi(parsed[4]));
           return;}

        if(indexo(parsed[2],"mult") == 1) {
           EnableMultiWindow();
	   return;}
        if(indexo(parsed[2],"sing") == 1) {
           DisableMultiWindow();
	   return;}
	
      }

/*   set perspective on/off                                                 */
     if(indexo(parsed[1],"pers") == 1) {
        toller(parsed[2]);
        if(indexo(parsed[2],"on") == 1) {
           Model.Transformation = USE_PERSPECTIVE;
           MakeOrtho();
           return;}
        if(indexo(parsed[2],"off") == 1) {
           Model.Transformation = USE_ORTHO;
           MakeOrtho();
           return;}
        if(indexo(parsed[2],"fovy") == 1) {
           sprintf(chelp,"Old fovy angle: %.2f",((float)Model.Fovy)/10.);
           PrintMessage(chelp);
           Model.Fovy = atoi(parsed[3]) * 10;
           if(Model.Fovy < 3) Model.Fovy = 3;
           sprintf(chelp,"New fovy angle: %.2f",((float)Model.Fovy)/10.);
           PrintMessage(chelp);
           return;}
      }

/* set stereo plot angle and translation */
     if(indexo(parsed[1],"ster") == 1) {
        toller(parsed[2]);
        if(indexo(parsed[2],"on") == 1) {
           if(SetRealStereoON()) return;
           StereoPlot.Active = 1;
           return;}
        if(indexo(parsed[2],"angl") == 1) {
           StereoPlot.Angle = 10. * atof(parsed[3]);
           return;}
        if(indexo(parsed[2],"tran") == 1) {
           StereoPlot.Translate = atof(parsed[3]);
           return;}
        if(indexo(parsed[2],"pair") == 1) {
           StereoPlot.Active = 1;
           StereoPlot.Translate = far / 2.0;
           return;}
        if(indexo(parsed[2],"off") == 1) {
           StereoPlot.Active = 0;
           if(IsStereoON())
                            SetRealStereoOFF();
           return;}
#ifdef USEFORMS
        if(term_type == 1)
           (void)Show_Form_StereoMode();
           return;
#endif
     }

/* screenblank                   */
     if(indexo(parsed[1],"screenb") == 1) {
        toller(parsed[2]);
        if(indexo(parsed[2],"on") == 1) {
           AutoScreenBlank = 1;
           return;}
        if(indexo(parsed[2],"off") == 1) {
           AutoScreenBlank = 0;
           return;}}

/* set torsion period to -180 to 180 or 0 to 360 degrees      */
     if(indexo(parsed[1],"tors") == 1) {
        toller(parsed[2]);
        if(indexo(parsed[2],"rang") == 1) {
         toller(parsed[3]);
           ihelp = 0;
           if(indexo(parsed[3],"half") == 1) ihelp = 0;
           if(indexo(parsed[3],"full") == 1) ihelp = 1;
       (void) SetTorsPeriod(ihelp);
       return;
     }}

     sprintf(OutText,"?ERROR: Following command not recognized: %s \n",input);
     PrintMessage(OutText);

/*  &&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&  */
}      /* end of set_fac */
/*  &&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&  */

/************************************************************************/
parse_surface_list(alt)
            int alt;
/************************************************************************/
{
     register int i;
     static int ihelp,atom_list;
     static int slong;
     static int *sel_list;
     char chelp[BUFF_LEN];

     atom_list = atom_list_max();

     sel_list = ivector(atom_list);

     slong = select_list(parsed[3],parsed[4],parsed[5],sel_list);

     if(slong > 0) { 

/* check if the idea was to turn the cpk for selected atoms off */
        if(alt > 0) { /* yes it was ... */
        for(i = 0 ; i < slong ; i++) surface_list[sel_list[i]] = 0;     
        free(sel_list);
        return;}

        strncpy(chelp,parsed[6],BUFF_LEN);
        toller(chelp);
        if(indexo(chelp,"appe") == 1) ihelp=0;
        else
        ihelp = 1;
           
        if(ihelp) {
        for(i = mlists[struc_peek] ; i < mliste[struc_peek] ; i++) 
            surface_list[i] = 0;}

        for(i = 0 ; i < slong ; i++) surface_list[sel_list[i]] = 1;
        }  
        else { 
        PrintMessage("?ERROR - no atoms in the selection list ");
        yn_surf = 0;}

        free(sel_list);
        
}



/************************************************************************/
parse_licorice_list(alt)
            int alt;
/************************************************************************/
{

     register int i;
     static int ihelp,atom_list;
     static int slong;
     static int *sel_list;
     char chelp[BUFF_LEN];

     atom_list = atom_list_max();

     sel_list = ivector(atom_list);

     slong = select_list(parsed[3],parsed[4],parsed[5],sel_list);

     if(slong > 0) { 

/* check if the idea was to turn the cpk for selected atoms off */
        if(alt > 0) { /* yes it was ... */
        for(i = 0 ; i < slong ; i++) liquorice_list[sel_list[i]] = 0;     
        free(sel_list);
        return;}

        strncpy(chelp,parsed[6],BUFF_LEN);
        toller(chelp);
        if(indexo(chelp,"appe") == 1) ihelp=0;
        else
        ihelp = 1;
           
        if(ihelp) {
        for(i = mlists[struc_peek] ; i < mliste[struc_peek] ; i++) 
            liquorice_list[i] = 0;}

        for(i = 0 ; i < slong ; i++) liquorice_list[sel_list[i]] = 1;
        }  
        else { 
        PrintMessage("?ERROR - no atoms in the selection list ");
        yn_surf = 0;}

        free(sel_list);
        
}



/************************************************************************/
parse_display_list(alt)
       int alt;
/************************************************************************/
{

     register int i;
     static int ihelp,atom_list;
     static int *sel_list;
     static int slong;
     char chelp[BUFF_LEN];

     atom_list = atom_list_max();

     sel_list = ivector(atom_list);

     slong = select_list(parsed[3],parsed[4],parsed[5],sel_list);

     if(slong > 0) {

/* check if the idea was to turn the selected atoms off */
        if(alt > 0) { /* yes it was ... */
        for(i = 0 ; i < slong ; i++) disp_list[sel_list[i]] = 0;     
        free(sel_list);
        return;}

        strncpy(chelp,parsed[6],BUFF_LEN);
        toller(chelp);
        if(indexo(chelp,"appe") == 1) ihelp=0;
        else ihelp = 1;

        if(ihelp) {
        for(i = 0 ; i < mliste[mlist_deep - 1] ; i++) disp_list[i] = 0;}

        for(i = 0 ; i < slong ; i++) disp_list[sel_list[i]] = 1;
        }
        else
        PrintMessage("?ERROR - no atoms in the selection list ");

        free(sel_list);
}



/************************************************************************/
parse_color_list()
/************************************************************************/
{
     register int i,j;
     static int atom_list;
     static int *sel_list;
     static int slong;
     static int ihelp,ihelp1,ihelp2,ihelp3;

     ihelp1 = atoi(parsed[6]);
      ihelp2 = atoi(parsed[7]);
       ihelp3 = atoi(parsed[8]);

   atom_list = atom_list_max();

   sel_list = ivector(atom_list);

   slong = select_list(parsed[3],parsed[4],parsed[5],sel_list);

   if(slong > 0) {
        for(i = 0 ; i < slong ; i++) {

/* now bang it together  .... */
        j = sel_list[i];
                        atmcol[j][0] = ihelp1;
                        atmcol[j][1] = ihelp2;
                        atmcol[j][2] = ihelp3;}}
        else
        PrintMessage("?ERROR - no atoms in the selection list ");
   
         free(sel_list);
}

/************************************************************************/
parse_color_name()
/************************************************************************/
{

     static int i,j;
     static int *sel_list;
     static int slong,atom_list;
     static int ihelp,ihelp1,ihelp2,ihelp3;
     static char chelp1[MAX_COL_LEN],chelp2[MAX_COL_LEN];
     static char OutText[BUFF_LEN];

     if(parsed[7][0] != '\0') {
       strncat(parsed[6]," ",(BUFF_LEN - strlen(parsed[6])));
       strncat(parsed[6],parsed[7],(BUFF_LEN - strlen(parsed[6])));}
     if(parsed[8][0] != '\0') {
       strncat(parsed[6]," ",(BUFF_LEN - strlen(parsed[6])));
       strncat(parsed[6],parsed[8],(BUFF_LEN - strlen(parsed[6])));}

       strncpy(chelp1,parsed[6],MAX_COL_LEN);
       toller(chelp1);

/* check if the name is in the colour table */
   j = name_to_rgb(chelp1,&ihelp1,&ihelp2,&ihelp3);

   if(j != 0) {
    sprintf(OutText,"?ERROR - unknown colour '%s' ",chelp1);
     PrintMessage(OutText);
      return;}

   atom_list = atom_list_max();

   sel_list = ivector(atom_list);

   slong = select_list(parsed[3],parsed[4],parsed[5],sel_list);

   if(slong > 0) {
        for(i = 0 ; i < slong ; i++) {

/* now bang it together  .... */
        j = sel_list[i];
                        atmcol[j][0] = ihelp1;
                        atmcol[j][1] = ihelp2;
                        atmcol[j][2] = ihelp3;}}
        else
        PrintMessage("?ERROR - no atoms in the selection list ");
   
         free(sel_list);
}

/************************************************************************/
color_by_charge(alt)
      int alt; /* if 0 calc first min max , if != 0 that is already done */
/************************************************************************/
{

        register int i;
        static int rr,gg,bb;
        float min_charge;
        float max_charge;
        float delta;
        double step;
        char OutText[BUFF_LEN];

        if(!alt) {
        min_charge =  1.e+30;
        max_charge = -1.e+30;

        for(i = mlists[current_struct] ; i < mliste[current_struct] ; i++) {
          if(atm_charge[i] < min_charge) min_charge = atm_charge[i];
          if(atm_charge[i] > max_charge) max_charge = atm_charge[i];}

        charge_color.max = max_charge;
        charge_color.min = min_charge;
        charge_color.set = 1;

        }
        else {
        max_charge = charge_color.max;
        min_charge = charge_color.min;} 
  
        delta = max_charge - min_charge;

        if(RABS(delta) < 1.e-05) { /* charges most likely not assigned */
          printf("?ERROR - charges not assigned (most likely) \n");
          return;}

        sprintf(OutText,"Max charge: %7.3f (red)",max_charge);
        PrintMessage(OutText);
        sprintf(OutText,"Min charge: %7.3f (blue)",min_charge);
        PrintMessage(OutText);

        for(i = mlists[current_struct] ; i < mliste[current_struct] ; i++) {
           step = (atm_charge[i] - min_charge) / delta;
           pre_rainbow(step,&rr,&gg,&bb);
           atmcol[i][0] = rr;
           atmcol[i][1] = gg;
           atmcol[i][2] = bb;
	 }
}
/************************************************************************/
color_by_fourth()
/************************************************************************/
{

        register int i;
        float min_fourth;
        float max_fourth;
        float delta;
        double step;
        static rr,gg,bb;
        char OutText[BUFF_LEN];

        min_fourth =  1.e+30;
        max_fourth = -1.e+30;

        for(i = mlists[current_struct] ; i < mliste[current_struct] ; i++) {
          if(bvalue[i] < min_fourth) min_fourth = bvalue[i];
          if(bvalue[i] > max_fourth) max_fourth = bvalue[i];
        }

        if(RABS(max_fourth - min_fourth) < 1.e-10) {
          PrintMessage("?WARNING - fourth value is not set ");
          return;}

        sprintf(OutText,"Max fourth value: %7.3f (red)",max_fourth);
        PrintMessage(OutText);
        sprintf(OutText,"Min fourth value: %7.3f (blue)",min_fourth);
        PrintMessage(OutText);

        delta = max_fourth - min_fourth;

        for(i = mlists[current_struct] ; i < mliste[current_struct] ; i++) {
           step = (bvalue[i] - min_fourth) / delta;
           pre_rainbow(step,&rr,&gg,&bb);
           atmcol[i][0] = rr;
           atmcol[i][1] = gg;
           atmcol[i][2] = bb;
	 }
}
/************************************************************************/
color_by_residue()
/************************************************************************/
{
        float delta;
        double step;
        int i,rr,gg,bb;
        char OutText[BUFF_LEN];

        sprintf(OutText,"Max res1: %d (red)",maxres1);
        PrintMessage(OutText);
        sprintf(OutText,"Min res1: %d (blue)",minres1);
        PrintMessage(OutText);

        delta = (float)(maxres1 - minres1);

        for(i = mlists[current_struct] ; i < mliste[current_struct] ; i++) {
           step = (double)(res1[i] - minres1) / delta;
           pre_rainbow(step,&rr,&gg,&bb);
           atmcol[i][0] = rr;
           atmcol[i][1] = gg;
           atmcol[i][2] = bb;
	 }
}

/*   Check the input names against the list and mark a '1' in the list if 
     it is found */


/************************************************************************/
int select_list(wsegment,wresnam,watnam,sel_list)  
     char *watnam;                          
     char *wresnam;
     char *wsegment;
     int  *sel_list;
/************************************************************************/
{

     static char qatnam[MAX_ATM_NAME_LEN];
     static char qresnam[MAX_RES_NAME_LEN];
     static char qsegment[MAX_SEG_NAME_LEN];
     static int i,ii,j;
     static int ihelp;
     static long ihelp1,ihelp2;
     static int sel_long;
     static char *serie[MAX_ENT_ON_LINE];
     static int iseries,from1,to1,atm_hit,res_hit,seg_hit;
/* different lists */
     static char seg_list[MAX_ENT_ON_LINE][MAX_SEG_NAME_LEN];
     static int  seg_list_ent;
     static char res_list[MAX_ENT_ON_LINE][MAX_RES_NAME_LEN];
     static int  res_list_ent;
     static int  res_from_i[MAX_ENT_ON_LINE];
     static int  res_to_i[MAX_ENT_ON_LINE];
     static int  res_ind_ent;
     static char atm_list[MAX_ENT_ON_LINE][MAX_ATM_NAME_LEN];
     static int  atm_list_ent;
     static int atm_from_i[MAX_ENT_ON_LINE];
     static int atm_to_i[MAX_ENT_ON_LINE];
     static int atm_ind_ent;
     static int Low,High;
     static int StructNumb;
/* There is a bug somewhere which screwes up the input text
   to avoid problems I save the input text and put it back just
   before the return */
     static char Save1[MAXlinel];
     static char Save2[MAXlinel];
     static char Save3[MAXlinel];
     static char *ws;
     static char *wr;
     static char *wa;

     sel_long = 0;
     ihelp1 = 0;

     seg_list_ent = 0;
     res_list_ent = 0;
     res_ind_ent = 0;
     atm_list_ent = 0;
     atm_ind_ent = 0; 

     ws = wsegment;
     wr = wresnam;
     wa = watnam;

     strncpy(Save1,wsegment,MAXlinel);
      strncpy(Save2,wresnam,MAXlinel);
       strncpy(Save3,watnam,MAXlinel);
/*
     In the wsegment variable there can be as the first characters
     a number and the hat '^' where the number refers to the current
     structure.
*/
     if(LookForHat(wsegment , &StructNumb)) {
        if((StructNumb > mlist_deep) || (StructNumb < 1)) {
           PrintMessage("?ERROR - wrong structure number");
/* protect against a bug */
     strncpy(ws,Save1,MAXlinel);
      strncpy(wr,Save2,MAXlinel);
       strncpy(wa,Save3,MAXlinel);
           return(0);}

        ihelp1 =  StructNumb - 1;
     }
     else {
/* if mlist_deep > 1 there are several structures in the display list
   so the user has to pick just one */

   if(mlist_deep > 1 && term_type == 1 && fake_now == 0) {
      sel_struct(&ihelp1);
      struc_peek = ihelp;}
   else
   ihelp1 = current_struct;

   if(ihelp1 < 0) { /* the user did most likely not do a selection */
/* protect against a bug */
     strcpy(ws,Save1);
      strcpy(wr,Save2);
       strcpy(wa,Save3);
     return(0);}}

/* substitute for NULL */

     if(wa[0] == '\0') strncpy(wa,"*\0",2);
     if(wr[0] == '\0') strncpy(wr,"*\0",2);
     if(ws[0] == '\0') strncpy(ws,"*\0",2);

/* check that wsegment is supplied ( <> NULL ). If wsegment = NULL
   the rest is also NULL */
   if(wsegment[0] == '\0') { /* not supplied */
     j = 0;
     if(ihelp1 != mlist_deep) {
     for(i = mlists[ihelp1] ; i < mliste[ihelp1] ; i++) sel_list[j++] = i;
/* protect against a bug */
     strcpy(ws,Save1);
      strcpy(wr,Save2);
       strcpy(wa,Save3);
      return(mliste[ihelp1] - mlists[ihelp1] + 1);}
     else {
     for(i = mlists[0] ; i < mliste[mlist_deep - 1] ; i++) sel_list[j++] = i;
/* protect against a bug */
     strcpy(ws,Save1);
      strcpy(wr,Save2);
       strcpy(wa,Save3);
      return(mliste[0] - mlists[mlist_deep - 1] + 1);}
   }


/* go and hunt for the segment ... */
/*     tupper(wsegment);           */
/* check first for series */
   seg_list_ent = check_if_serie(wsegment,serie);
   if(seg_list_ent > 1) {
     for(i = 0 ; i < seg_list_ent ; i++) {
                 strncpy(seg_list[i],serie[i],MAX_SEG_NAME_LEN);
                 sign_char(seg_list[i]);}
   }
   else {
                 strncpy(seg_list[0],wsegment,MAX_SEG_NAME_LEN);
                 sign_char(seg_list[0]);
                 seg_list_ent = 1;}
   

/* go and hunt for the residue name */
/*       tupper(wresnam);           */
/* check first for series */
   iseries = check_if_serie(wresnam,serie);
   if(iseries > 1) {
     for(i = 0 ; i < iseries ; i++) {

        if(isdigit(serie[i][0])) { /* number or numbers coming */
                                 check_if_region(serie[i],&from1,&to1);
                                 res_from_i[res_ind_ent] = from1;
                                 res_to_i[res_ind_ent] = to1;
                                 res_ind_ent++;}
         else {
         strncpy(res_list[res_list_ent],serie[i],MAX_RES_NAME_LEN);
         sign_char(res_list[res_list_ent]);
         res_list_ent++;}

      }}
   else {
        if(isdigit(wresnam[0])) { /* number or numbers coming */
                                 check_if_region(wresnam,&from1,&to1);
                                 res_from_i[0] = from1;
                                 res_to_i[0]   = to1;
                                 res_ind_ent = 1;}
                 else {
                 strncpy(res_list[0],wresnam,MAX_RES_NAME_LEN);
                 sign_char(res_list[0]);
                 res_list_ent = 1;}}
 

/* Go and hunt for the atom names ... */
/*          tupper(watnam);           */
/* check first for series */
   iseries = check_if_serie(watnam,serie);
   if(iseries > 1) {
     for(i = 0 ; i < iseries ; i++) {

        if(isdigit(serie[i][0])) { /* number or numbers coming */
                                 check_if_region(serie[i],&from1,&to1);
                                 atm_from_i[atm_ind_ent] = from1 - 1;
                                 atm_to_i[atm_ind_ent] = to1 - 1;
                                 atm_ind_ent++;}
         else {
         strncpy(atm_list[atm_list_ent],serie[i],MAX_ATM_NAME_LEN);
         sign_char(atm_list[atm_list_ent]);
         atm_list_ent++;}}

   }
   else {
        if(isdigit(watnam[0])) { /* number or numbers coming */
                                 check_if_region(watnam,&from1,&to1);
                                 atm_from_i[0] = from1 - 1;
                                 atm_to_i[0]   = to1 - 1;
                                 atm_ind_ent = 1;}
                 else {
                 strncpy(atm_list[0],watnam,MAX_ATM_NAME_LEN);
                 sign_char(atm_list[0]);
                 atm_list_ent = 1;}}
/* do it now! */
        j = 0;

        if(ihelp1 != mlist_deep){
          Low  = mlists[ihelp1];
          High = mliste[ihelp1];}
        else {
          Low  = mlists[0];
          High = mliste[mlist_deep - 1];}

        for(i = Low ; i < High ; i++) {
          sel_list[j++] = 0;
          strncpy(qsegment,segment+4*i,MAX_SEG_NAME_LEN);
/*          tupper(qsegment);                               */
          sign_char(qsegment);
           strncpy(qresnam,resnam+4*i,MAX_RES_NAME_LEN);
/*         tupper(qresnam);                                 */
           sign_char(qresnam);
            strncpy(qatnam,atnam+4*i,MAX_ATM_NAME_LEN); 
                         /* no switch to upper characters for the atom name */
            sign_char(qatnam);  

/* now bang it together  .... */

        atm_hit = 0;
        res_hit = 0;
        seg_hit = 0;

            switch(seg_list_ent) {

            case 0: break;

            case 1:
                   if(comp_str(qsegment,seg_list[0])) seg_hit = 1;
                   break;

	    default:
                   for(ii = 0 ; ii < seg_list_ent ; ii++) 
                   if(comp_str(qsegment,seg_list[ii])) seg_hit = 1;
                   break;
	    }

            switch(res_list_ent) {

            case 0: break;

            case 1:
                   if(comp_str(qresnam,res_list[0])) res_hit = 1;
                   break;

	    default:
                   for(ii = 0 ; ii < res_list_ent ; ii++) 
                   if(comp_str(qresnam,res_list[ii])) res_hit = 1;
                   break;
	    }

            switch(res_ind_ent) {

            case 0: break;

            case 1:
                   if(res1[i] >= res_from_i[0] && res1[i] <= res_to_i[0]) res_hit = 1;
                   break;

            default:
                   for(ii = 0 ; ii < res_ind_ent ; ii++) 
                   if(res1[i] >= res_from_i[ii] && res1[i] <= res_to_i[ii]) res_hit = 1;
                   break;
	    }

            switch(atm_list_ent) {

            case 0: break;

            case 1:
                   if(comp_str(qatnam,atm_list[0])) atm_hit = 1;
                   break;

	    default:
                   for(ii = 0 ; ii < atm_list_ent ; ii++) 
                   if(comp_str(qatnam,atm_list[ii])) atm_hit = 1;
                   break;
	    }


            switch(atm_ind_ent) {

            case 0: break;

            case 1:
                   ihelp2 = i - mlists[ihelp1];
                   if(ihelp2 >= atm_from_i[0] && 
                      ihelp2 <= atm_to_i[0]) atm_hit = 1;
                   break;

            default:
                   ihelp2 = i - mlists[ihelp1];
                   for(ii = 0 ; ii < atm_ind_ent ; ii++) 
                   if(ihelp2 >= atm_from_i[ii] && 
                      ihelp2 <= atm_to_i[ii]) atm_hit = 1;
                   break;
	    }


            if(seg_hit && res_hit && atm_hit) {
                          sel_list[sel_long] = i;
                                     sel_long++;}
       }


/* protect against a bug */
/*
     strncpy(ws,Save1,MAXlinel);
      strncpy(wr,Save2,MAXlinel);
       strncpy(wa,Save3,MAXlinel);
*/

     strcpy(ws,Save1);
      strcpy(wr,Save2);
       strcpy(wa,Save3);
       return(sel_long); /* return with the length of select list */
}       


/************************************************************************/
select_round_atoms(alt)
     int alt;
/************************************************************************/
{

     static int i,j;
     static int *sel_list;
     static int slong;
     static float rad;
     static float xcm,ycm,zcm;
     static char chelp[BUFF_LEN];
     static char chelp1[BUFF_LEN];
     static int ihelp;
     static int ihelp1,atom_list;
     static int color_def; /* switch for the color information */
     static int crgb[3];

     color_def = 0; /* not defined */
     ihelp = 0;     

     if(selection_mode == 0) 
       printf("Selecting by whole residues ...\n");
     if(selection_mode == 1)
       printf("Selecting by atoms ...\n");

     switch(alt) {

     case 1: /* given as x,y and z coordinates */

/* these can contain a colour or "appen" */

     SELECTION(parsed[7],parsed[8]);

           select_round_xyz(atof(parsed[3]),atof(parsed[4]),atof(parsed[5]),
                            atof(parsed[6]),ihelp,
                            crgb,color_def);
           break;

     case 2: /* given as res:seg:atom */

/* these can contain a colour or "appen" */

     SELECTION(parsed[7],parsed[8]);

     atom_list = atom_list_max();

     sel_list = ivector(atom_list);

     slong = select_list(parsed[3],parsed[4],parsed[5],sel_list);

     if(slong > 0) {
     rad = atof(parsed[6]);
     if(rad < 0.001) {
      printf("?ERROR - search radius too small \n");
       free(sel_list);
        return;}

     ihelp1 = ihelp;

     j = 0;
     for(i = 0 ; i < slong ; i++ ) {
           select_round(i,sel_list,slong,rad,ihelp,ihelp1,crgb,color_def);
           ihelp = 1; /* append from now */
           j++;}
     }
     else
     printf("?ERROR - no atoms in the selection list \n");

     free(sel_list);
     break;

     case 3:  /* select round centre of mass (select list can be used ) */     

/* these can contain a colour or "appen" */

     SELECTION(parsed[8],parsed[9]);

     rad = atof(parsed[7]);
     if(rad < 0.001) {
     printf("?ERROR - search radius too small \n");
     return;}

     ihelp1 = calc_cmass_gen(parsed[4],parsed[5],parsed[6],&xcm,&ycm,&zcm);

     if(ihelp1 > 0) return;

     select_round_xyz(xcm,ycm,zcm,rad,ihelp,crgb,color_def);

     break;

     }
}

/**********************************************************************/
check_if_region(inpt,from,till)
       char *inpt;
       int *from;
       int *till;
/**********************************************************************/
{


     static int num;
     static int retv;
     char *find;

     find = STRTOK(inpt,"-");

     *from = atoi(find);
     *till   = *from;

     find = STRTOK(NULL,"-");
     if(find == NULL) return;

     *till   = atoi(find);

          if(*from > *till) {
           retv = *from;
            *from = *till;
             *till = retv;}
         
     return;

}
/**********************************************************************/
int check_if_serie(inpt,serie) /* this function returns always at least 1 */
       char *inpt;
       char *serie[];
/**********************************************************************/
{

     static int num,loop;
     static int retv;

     loop = 0;

      serie[loop] = STRTOK(inpt,",");

      if(serie[loop] == NULL) return(loop);

     while(1) {
     loop++;
     if(loop == MAX_ENT_ON_LINE) {
     loop--;
     PrintMessage("?ERROR - to meny entries on list , taking as much as possible");
     return(loop);}

       serie[loop] = STRTOK(NULL,",");
       if(serie[loop] == NULL) return(loop);
     }

}
/**********************************************************************/
change_prompt(num)
       int num;
/**********************************************************************/
{


     int i,j;

     j = num - 2;

     strncpy(prompt,parsed[2],BUFF_LEN);
     for(i = 1 ; i < j ; i++) {
        strncat(prompt," ",(BUFF_LEN - strlen(prompt)));
         strncat(prompt,parsed[2+i],(BUFF_LEN - strlen(prompt)));}
}


/************************************************************************/
int calc_cmass_gen(seg,res,atm,xcm,ycm,zcm)    /* calculate centre of mass */
           char *seg;   /* segment name */
           char *res;   /* residue name */
           char *atm;   /* atom name    */
           float *xcm;  /* x-coordinate of centre of mass */
           float *ycm;  /* y-           -"-               */
           float *zcm;  /* z-           -"-               */

/*
           Leif Laaksonen 1990
*/
/************************************************************************/
{

     static int i,si;
     static int *sel_list;
     static int slong;
     static int ihelp,atom_list;
     static float mass1[3],mass2,mass3;
     char OutText[BUFF_LEN];
     
   atom_list = atom_list_max();
   sel_list = ivector(atom_list);

   sprintf(OutText,"Centre of mass calculated from selection list : >%.4s<>%.4s<>%.4s< ",seg,res,atm);
   PrintMessage(OutText);

   slong = select_list(seg,res,atm,sel_list);

   if(slong > 0) {
   ihelp = 0;
   mass1[0] = mass1[1] = mass1[2] = 0.0;
   mass2 = 0.0;

        for(i = 0 ; i < slong ; i++) {
        si = sel_list[i];

/* now bang it together  .... */
          ihelp++;
          mass3 = find_mass(atm_type[si]);
          mass1[0] += mass3*x[si];
           mass1[1] += mass3*y[si];
            mass1[2] += mass3*z[si];
          mass2 +=mass3;}

         if(mass2 < 0.01) {
         PrintMessage("?ERROR - atomic masses are not defined or set ");
         return(1);}

         mass1[0] /= mass2;
         mass1[1] /= mass2;
         mass1[2] /= mass2;

         sprintf(OutText,"Centre of mass is: x = %f , y = %f , z = %f",
               mass1[0]+sumx,mass1[1]+sumy,mass1[2]+sumz);
         PrintMessage(OutText);
         sprintf(OutText,"Total mass is: %f for %d atoms",mass2,ihelp);
         PrintMessage(OutText);
         }
         else {
         PrintMessage("?ERROR - no atoms in the selection list ");
         free(sel_list);
         return(1);}

/* save centre of mass and return */
         *xcm = mass1[0];
          *ycm = mass1[1];
           *zcm = mass1[2];
/* .............................. */
         free(sel_list);
          return(0);
}

/************************************************************************/
int calc_ccentre_gen(seg,res,atm,xcm,ycm,zcm) /* calculate coordinate centre */
           char *seg;   /* segment name */
           char *res;   /* residue name */
           char *atm;   /* atom name    */
           float *xcm;  /* x-coordinate coordinate centre */
           float *ycm;  /* y-           -"-               */
           float *zcm;  /* z-           -"-               */

/*
           Leif Laaksonen 1990
*/
/************************************************************************/
{

     static int i,si;
     static int *sel_list;
     static int slong;
     static int ihelp,atom_list;
     static float mass1[3],mass2,mass3;
     char OutText[BUFF_LEN];
     
   atom_list = atom_list_max();
   sel_list = ivector(atom_list);

   sprintf(OutText,"Coordinate centre calculated from selection list : >%.4s<>%.4s<>%.4s< ",seg,res,atm);
   PrintMessage(OutText);

   slong = select_list(seg,res,atm,sel_list);

   if(slong > 0) {
   ihelp = 0;
   mass1[0] = mass1[1] = mass1[2] = 0.0;
   mass2 = (float)slong;

        for(i = 0 ; i < slong ; i++) {
        si = sel_list[i];

/* now bang it together  .... */
          ihelp++;
          mass1[0] += x[si];
           mass1[1] += y[si];
            mass1[2] += z[si];}


         mass1[0] /= mass2;
         mass1[1] /= mass2;
         mass1[2] /= mass2;

         sprintf(OutText,"Coordinate centre is: x = %f , y = %f , z = %f",
               mass1[0]+sumx,mass1[1]+sumy,mass1[2]+sumz);
         PrintMessage(OutText);
         }
         else {
         PrintMessage("?ERROR - no atoms in the selection list ");
         free(sel_list);
         return(1);}

/* save coordinate centre and return */
         *xcm = mass1[0];
          *ycm = mass1[1];
           *zcm = mass1[2];
/* .............................. */
         free(sel_list);
          return(0);
}


/*************************************************************************/
set_obcolour(text1,text2,text3)
       char *text1;
       char *text2;
       char *text3;
/*************************************************************************/
{

     char chelp1[MAX_COL_LEN];
     char chelp2[MAX_COL_LEN];
     char OutText[BUFF_LEN];
     int i,j;
     int ihelp1,ihelp2,ihelp3;


     if(isalpha(text1[0])||
       (indexo(text1,SEP_COLOR) > 0)) { /* colour is as a name */
     if(text2[0] != '\0') {
       strcat(text1," ");
       strcat(text1,text2);}
     if(text3[0] != '\0') {
       strcat(text1," ");
       strcat(text1,text3);}

       strncpy(chelp1,text1,MAX_COL_LEN);
       toller(chelp1);

/* check if the name is in the colour table */
   j = name_to_rgb(text1,&ihelp1,&ihelp2,&ihelp3);

   if(j != 0) {
   sprintf(OutText,"?ERROR - unknown colour '%s' ",text1);
   PrintMessage(OutText);
    return;}
   }
   else {

    obcolor[0] = atoi(text1);
    obcolor[1] = atoi(text2);
    obcolor[2] = atoi(text3);
    return;
  }
/* ready to assign the colours */
   obcolor[0] = ihelp1;
   obcolor[1] = ihelp2;
   obcolor[2] = ihelp3;
}


/*************************************************************************/
set_bgcolour(text1,text2,text3)
       char *text1;
       char *text2;
       char *text3;
/*************************************************************************/
{

     char chelp1[MAX_COL_LEN];
     char chelp2[MAX_COL_LEN];
     char OutText[BUFF_LEN];
     int i,j;
     int ihelp1,ihelp2,ihelp3;


     if(isalpha(text1[0])||
       (indexo(text1,SEP_COLOR) > 0)) { /* colour is as a name */
     if(text2[0] != '\0') {
       strcat(text1," ");
       strcat(text1,text2);}
     if(text3[0] != '\0') {
       strcat(text1," ");
       strcat(text1,text3);}

       strncpy(chelp1,text1,MAX_COL_LEN);
       toller(chelp1);

/* check if the name is in the colour table */
   j = name_to_rgb(text1,&ihelp1,&ihelp2,&ihelp3);

   if(j != 0) {
   sprintf(OutText,"?ERROR - unknown colour '%s' ",text1);
   PrintMessage(OutText);
    return;}
   }
   else {

    bgcolor[0] = atoi(text1);
    bgcolor[1] = atoi(text2);
    bgcolor[2] = atoi(text3);
    return;
  }
/* ready to assign the colours */
   bgcolor[0] = ihelp1;
   bgcolor[1] = ihelp2;
   bgcolor[2] = ihelp3;
}


/*************************************************************************/
set_txcolour(text1,text2,text3)
       char *text1;
       char *text2;
       char *text3;
/*************************************************************************/
{

     char chelp1[MAX_COL_LEN];
     char chelp2[MAX_COL_LEN];
     char OutText[BUFF_LEN];
     int i,j;
     int ihelp1,ihelp2,ihelp3;


     if(isalpha(text1[0])||
       (indexo(text1,SEP_COLOR) > 0)) { /* colour is as a name */
     if(text2[0] != '\0') {
       strcat(text1," ");
       strcat(text1,text2);}
     if(text3[0] != '\0') {
       strcat(text1," ");
       strcat(text1,text3);}

       strncpy(chelp1,text1,MAX_COL_LEN);
       toller(chelp1);

/* check if the name is in the colour table */
   j = name_to_rgb(text1,&ihelp1,&ihelp2,&ihelp3);

   if(j != 0) {
   sprintf(OutText,"?ERROR - unknown colour '%s' ",text1);
   PrintMessage(OutText);
    return;}
   }
   else {

    txcolor[0] = atoi(text1);
    txcolor[1] = atoi(text2);
    txcolor[2] = atoi(text3);
    return;
  }
/* ready to assign the colours */
   txcolor[0] = ihelp1;
   txcolor[1] = ihelp2;
   txcolor[2] = ihelp3;
}


/*************************************************************************/
set_txt_colour(text1,text2,text3)
       char *text1;
       char *text2;
       char *text3;
/*************************************************************************/
{

     char chelp1[MAX_COL_LEN];
     char chelp2[MAX_COL_LEN];
     char OutText[BUFF_LEN];
     int i,j;
     int ihelp1,ihelp2,ihelp3;


     if(isalpha(text1[0])) { /* colour is as a name */
     if(text2[0] != '\0') {
       strcat(text1," ");
       strcat(text1,text2);}
     if(text3[0] != '\0') {
       strcat(text1," ");
       strcat(text1,text3);}

       strncpy(chelp1,text1,MAX_COL_LEN);
       toller(chelp1);

/* check if the name is in the colour table */
   j = name_to_rgb(text1,&ihelp1,&ihelp2,&ihelp3);

   if(j != 0) {
   sprintf(OutText,"?ERROR - unknown colour '%s' ",text1);
   PrintMessage(OutText);
    return;}
   }
   else {

    txt_param.txcolor[0] = atoi(text1);
    txt_param.txcolor[1] = atoi(text2);
    txt_param.txcolor[2] = atoi(text3);
    return;
  }
/* ready to assign the colours */
   txt_param.txcolor[0] = ihelp1;
   txt_param.txcolor[1] = ihelp2;
   txt_param.txcolor[2] = ihelp3;
}


/*************************************************************************/
int set_traj_type(text)  /* determine trajectory file type */
    char *text;
/*************************************************************************/
{
    int i;
    char OutText[BUFF_LEN];

    if(text[0] == '\0') 
      return(1); /* default trajectory type (CHARMM)*/

    toller(text);

/* do it ... */
       if(indexo(text,"charm") == 1) {
       return(1);}
        if((indexo(text,"disc") == 1) || (indexo(text,"insi") == 1)) {
        return(2);}
         if(indexo(text,"ambe") == 1) {
         return(3);}
          if(indexo(text,"yasp") == 1) {
          return(4);}
           if(indexo(text,"mumo") == 1) {
           return(5);}
            if(indexo(text,"ambe") == 1) {
            return(3);}
             if(indexo(text,"grom") == 1) {
             return(6);}
              if(indexo(text,"hype") == 1) {
              return(7);}

    sprintf(OutText,"?WARNING - can't assign trajectory type to '%s' ",text);
    PrintMessage(OutText);
    return(0);
}

/*************************************************************************/
int name_to_rgb(colour,r,g,b)      /* on return = 0 ok != 0 not in table */
     char *colour;
     int *r;
     int *g;
     int *b;
/*************************************************************************/
{
       char chelp1[MAX_COL_LEN];
       char chelp2[MAX_COL_LEN];
       char OutText[BUFF_LEN];
       char ColPar[MAXparse][MAXlinel];
       int ColI;
       int i,j;
       static int sr = 255,sg = 255,sb = 255;

if(colour[0] == '\0') {
        *r = sr;
        *g = sg;
        *b = sb;
return(0);}

/* the colour name can also be a rgb coded name like 255|34|90 
   (where the '|' is used by default, look at the SEL_COLOR definition)
   so look if the first character is a number (this is only used
   as an internal way of defining the colour) */

       if(isdigit(colour[0])) {
             own_parser(colour,ColPar,&ColI,SEP_COLOR);
            if(ColI < 1) {
              PrintMessage("?ERROR - error in colour parser");
                 *r = 255;
                  *g = 255;
                   *b = 255;
                 return(0);}
              *r = atoi(ColPar[0]);
               *g = atoi(ColPar[1]);
                *b = atoi(ColPar[2]);
         return(0);}

       strncpy(chelp1,colour,MAX_COL_LEN);
       toller(chelp1);

/* check if the name is in the colour table */

    for(i = 0 ; i < col_tbl_max ; i++) {
       strncpy(chelp2,col_table[i].name,MAX_COL_LEN);
       toller(chelp2);
       if(indexo(chelp1,chelp2) == 1) { /* yes it is */
       *r = sr = col_table[i].red;
       *g = sg = col_table[i].green;
       *b = sb = col_table[i].blue;
        return(0);
       }
     } 

   sprintf(OutText,"?ERROR - unknown colour '%s' (will put it to white) ",colour);
   PrintMessage(OutText);

        *r = 255;
        *g = 255;
        *b = 255;
    return(1);

}

/*************************************************************************/
rgb_to_name(colour,r,g,b)
     char *colour;
     int r;
     int g;
     int b;
/*************************************************************************/
{

       register int i;
       char OutText[BUFF_LEN];


/* check if the rgb is in the colour table */

    colour[0] = '\0';

    for(i = 0 ; i < col_tbl_max ; i++) {

       if( r == col_table[i].red &&
           g == col_table[i].green &&
           b == col_table[i].blue) { /* yes it is */
       strncpy(colour,col_table[i].name,MAX_COL_LEN);
        return;
       }
     } 

   sprintf(OutText,"?WARNING - rgb given ('%d %d %d') does not match a name in the colour table",r,g,b);
   PrintMessage(OutText);
   strcpy(colour,"** UNKNOWN **");
    return;

}


#ifdef sgi

/************************************************************************/
parse_label_list(alt,text1,text2,text3)
            int   alt;
            char *text1;
            char *text2;
            char *text3;
/************************************************************************/
{

     register  int i,j,k;
     static int slong,atom_list;
     static int *sel_list;
     char chelp[BUFF_LEN];
     int ihelp;

     atom_list = atom_list_max();
     sel_list = ivector(atom_list);

     slong = select_list(text1,text2,text3,sel_list);

     if(slong > 0) { 

        if(!alt) { /* add to list */ 
           for(i = 0 ; i < slong ; i++) {
            j = sel_list[i];
             if(!disp_list[j]) continue;
              label_list[j] = 1;}
        label_deep = slong;}

        else {
           for(i = 0 ; i < slong ; i++) {
             j = sel_list[i];
              label_list[j] = 0;}

           j = 0;
           for(i = 0 ; i < mliste[mlist_deep - 1]; i++) {
              if(label_list[i]) j++;}

              label_deep = j;}

      }
        else 
        PrintMessage("?ERROR - no atoms in the selection list");

        free(sel_list);
        
}

/************************************************************************/
parse_cpk_scale(text1,text2,text3,fhelp)
            char *text1;
            char *text2;
            char *text3;
            float fhelp;
/************************************************************************/
{

     register int i,j;
     static int ihelp;
     static int slong,atom_list;
     static int *sel_list;
     char chelp[BUFF_LEN];

     atom_list = atom_list_max();
     sel_list = ivector(atom_list);

     slong = select_list(text1,text2,text3,sel_list);

     if(slong > 0) { 

        for(i = 0 ; i < slong ; i++) {
         j = sel_list[i];
         cpk_scale[j] = fhelp;}}
        else 
        PrintMessage("?ERROR - no atoms in the selection list ");

        free(sel_list);
        
}

/************************************************************************/
label_ident()
/************************************************************************/
{

    int i,j,k;
    char chelp[BUFF_LEN];

    if(label_deep == 0) return;


     c3s(obcolor);

     pushmatrix();
     frontbuffer(TRUE);

        for(i = mlists[0] ; i < mliste[mlist_deep - 1] ; i++) {
         if(!label_list[i]) continue;
         sprintf(chelp,"%d_%.4s",GetResNum1(i),GetResName(i));
         k = show_text_world(chelp,txt_param.txfont,txt_param.txcolor,
                             txt_param.txtsize,
                             GetXCoord(i) , GetYCoord(i) , GetZCoord(i),
                             BACKBUFFER);}

      frontbuffer(FALSE);
      popmatrix();

}

#endif

/* function which looks into the different atom list and finds the max */
/************************************************************************/
int atom_list_max()
/************************************************************************/
{    
        static int i,ahelp,atom_list; 

        if(mlist_deep < 1) {
          PrintMessage("?ERROR - no atoms defined to be selected from ");
          return(-1);}

        atom_list = mliste[mlist_deep - 1] - mlists[0] + 1;

        return(atom_list);
}

/************************************************************************/
full_screen()
/************************************************************************/
{
   int save_win_id;

#ifdef sgi
    if(term_type == 3) {
      PrintMessage("?ERROR - can't be used in batch mode");
      return;}

   save_win_id = winget();  /* save current win id */
 
   noborder();
   winconstraints();
   noborder();
   prefposition(0 , SCREENXP , 0 , SCREENYP);
   bg_window_id = winopen(" ");
   if(bg_window_id < 0) {
     PrintMessage("?ERROR - can't open background window ");
     return;}
   c3s(bgcolor);
   clear();

   winset(save_win_id);
   winpop();
#else
   PrintMessage("?ERROR - not implemented on this device");
#endif
}


/************************************************************************/
endfull_screen()
/************************************************************************/
{
    int save_curr_wind;

#ifdef sgi
    if(term_type == 3) {
      PrintMessage("?ERROR - can't be used in batch mode ");
      return;}

    if(bg_window_id < -1) {
       PrintMessage("?ERROR - no back ground window to close");
       return;}

    winclose(bg_window_id);
    bg_window_id = -1;

    winconstraints();
    winconstraints();
    keepaspect( 1 , 1);
    winconstraints();
#else
    PrintMessage("?ERROR - not implemented on this device");
#endif
}
/************************************************************************/
colour_by_force()
/************************************************************************/
{
        float delta,force;
        double step;
        int i,rr,gg,bb;
        char OutText[BUFF_LEN];

        delta = atm_force.maxfa - atm_force.minfa;

        sprintf(OutText,"Max force: %7.3f (red)",atm_force.maxfa);
        PrintMessage(OutText);
        sprintf(OutText,"Min force: %7.3f (blue)",atm_force.minfa);
        PrintMessage(OutText);

        for(i = mlists[0] ; i < mliste[0] ; i++) {

        force =  sqrt(atm_force.fx[i]*atm_force.fx[i] +
                      atm_force.fy[i]*atm_force.fy[i] +
                      atm_force.fz[i]*atm_force.fz[i]);

        step = (double)((force - atm_force.minfa) / delta);

           pre_rainbow(step,&rr,&gg,&bb);
           atmcol[i][0] = rr;
           atmcol[i][1] = gg;
           atmcol[i][2] = bb;
	 }


}
/************************************************************************/
SetLicoParam(alt)    /* set licorice parameters
                        alt = 1 , set licorice cylinder rad
                        alt = 2 , set licorice sphere rad */
      int alt;
/************************************************************************/
{
     char text[BUFF_LEN];
     char Say[BUFF_LEN];
     float rad;

#ifdef sgi

     switch(alt) {

     case 1:
     sprintf(Say,"Set new licorice cylinder rad ('%5.3f')",liq_radc);
     dialog4(Say,"Give new rad:  ",text);
     rad = atof(text);
     if(rad < 0.01) {
       PrintMessage("?ERROR - radius too small. Radius not changed");
       return;}
     liq_radc = rad;
     break;

     case 2:
     sprintf(Say,"Set new licorice sphere rad ('%5.3f')",liq_rads);
     dialog4(Say,"Give new rad:  ",text);
     rad = atof(text);
     if(rad < 0.01) {
       PrintMessage("?ERROR - radius too small. Radius not changed");
       return;}
     liq_rads = rad;
     break;

     default:
     PrintMessage("?ERROR - in SetLicoParam (This should not happen)");
     break;}
#else
     PrintMessage("?ERROR - not supported on this device");
#endif

}
/************************************************************************/
SetSearchWindow()
/************************************************************************/
{
     int i;
     char Say[BUFF_LEN];
     char text[BUFF_LEN];

#ifdef sgi

     sprintf(Say,"Set new atom connection search window ('%d')",search_window);
     dialog4(Say,"Give new window value:  ",text);
     i = atoi(text);
     if(i < 1) {
       PrintMessage("?ERROR - wrong window value. Window not changed");
       return;}
     search_window = i;

#else
     PrintMessage("?ERROR - not supported on this device");
#endif
}

/************************************************************************/
SetLineWidth()    /* set line width in pixels */
/************************************************************************/
{
     char text[BUFF_LEN];
     char Say[BUFF_LEN];
     int ihelp;

#ifdef sgi

     sprintf(Say,"Set new line width ('%d')",line_width);
     dialog4(Say,"Give new line width (pixels):  ",text);
     ihelp = atof(text);
     if(ihelp < 1) {
          PrintMessage("?ERROR - number of pixels has to be > 0 ");
       return;}

        sprintf(Say,"Linewidth changed from %d pixel(s) to %d pixel(s)",
                line_width,ihelp);
        PrintMessage(Say);
        linewidth(ihelp);
        line_width = ihelp;
#else
     PrintMessage("?ERROR - not supported on this device");
#endif

}

/************************************************************************/
Set_NearFar(SetNear,SetFar)
     char *SetNear;
     char *SetFar;
/************************************************************************/
{

#ifdef sgi
     float SaveM[4][4];
     float Fnear,Ffar;
     char OutText[BUFF_LEN];

     Fnear = atof(SetNear);
      near = Fnear;
     Ffar  = atof(SetFar);
      far  = Ffar;

     getmatrix(SaveM);

     mmode(MVIEWING);

     MakeOrtho();

     loadmatrix(SaveM);

     sprintf(OutText,"Changed values for 'near': %f and 'far': %f\n",
     near,far);
     PrintMessage(OutText);
#endif
}

/************************************************************************/
DefNewLimits()
/************************************************************************/
{

   int ihelp;

	    ihelp = 3; /* start point */
                  while(1) {

            if(ihelp == MAXparse) { /* no infinit loops!! */
              PrintMessage("?ERROR - looks like a runaway loop in 'def lim'");
              break;} 

                       if(parsed[ihelp][0] == '\0') break; /* all done */

                       if(indexo(parsed[ihelp],"xmin") == 1) {
                          ihelp++;
                          DENSITY_limits.Xmin = atof(parsed[ihelp]);
                          PROBE_limits.Xmin   = atof(parsed[ihelp]);
                          VSS_limits.Xmin     = atof(parsed[ihelp]);}

                       if(indexo(parsed[ihelp],"xmax") == 1) {
                          ihelp++;
                          DENSITY_limits.Xmax = atof(parsed[ihelp]);
                          PROBE_limits.Xmax   = atof(parsed[ihelp]);
                          VSS_limits.Xmax     = atof(parsed[ihelp]);}

                       if(indexo(parsed[ihelp],"ymin") == 1) {
                          ihelp++;
                          DENSITY_limits.Ymin = atof(parsed[ihelp]);
                          PROBE_limits.Ymin   = atof(parsed[ihelp]);
                          VSS_limits.Ymin     = atof(parsed[ihelp]);}

                       if(indexo(parsed[ihelp],"ymax") == 1) {
                          ihelp++;
                          DENSITY_limits.Ymax = atof(parsed[ihelp]);
                          PROBE_limits.Ymax   = atof(parsed[ihelp]);
                          VSS_limits.Ymax     = atof(parsed[ihelp]);}

                       if(indexo(parsed[ihelp],"zmin") == 1) {
                          ihelp++;
                          DENSITY_limits.Zmin = atof(parsed[ihelp]);
                          PROBE_limits.Zmin   = atof(parsed[ihelp]);
                          VSS_limits.Zmin     = atof(parsed[ihelp]);}

                       if(indexo(parsed[ihelp],"zmax") == 1) {
                          ihelp++;
                          DENSITY_limits.Zmax = atof(parsed[ihelp]);
                          PROBE_limits.Zmax   = atof(parsed[ihelp]);
                          VSS_limits.Zmax     = atof(parsed[ihelp]);}

                       if(indexo(parsed[ihelp],"prob") == 1) {
                          ihelp++;
                          PROBE_limits.ProbeVal   = atof(parsed[ihelp]);}

                       if(indexo(parsed[ihelp],"xpts") == 1) {
                          ihelp++;
                          DENSITY_limits.Xpts = atoi(parsed[ihelp]);
                          PROBE_limits.Xpts   = atoi(parsed[ihelp]);
                          VSS_limits.Xpts     = atoi(parsed[ihelp]);}


                       if(indexo(parsed[ihelp],"ypts") == 1) {
                          ihelp++;
                          DENSITY_limits.Ypts = atoi(parsed[ihelp]);
                          PROBE_limits.Ypts   = atoi(parsed[ihelp]);
                          VSS_limits.Ypts     = atoi(parsed[ihelp]);}


                       if(indexo(parsed[ihelp],"zpts") == 1) {
                          ihelp++;
                          DENSITY_limits.Zpts = atoi(parsed[ihelp]);
                          PROBE_limits.Zpts   = atoi(parsed[ihelp]);
                          VSS_limits.Zpts     = atoi(parsed[ihelp]);}

                       DENSITY_limits.set = 2;
                       PROBE_limits.set   = 2;
                       VSS_limits.set     = 2;

                       ihelp++;}
}

/************************************************************************/
LookForHat(IString , StructNumb)
    char *IString;
    int  *StructNumb;
/************************************************************************/
{
    register int i,j;

    int k;

    int SLong;

    *StructNumb = 0;

    SLong = strlen(IString);

    for(i = 0 ; i < SLong ; i++) {

       if(IString[i] == SEP_STRUCT) { /* structure number is included */

          IString[i] = ' ';
          *StructNumb = atoi(IString);

          k = i + 1;

          if(k < SLong) {
           for(j = k ; j < SLong ; j++) {
              IString[j - k] = IString[j];
              IString[j]     = '\0';}

           }
          else {
           for(j = 0 ; j < SLong ; j++) IString[j] = '\0';
          }

          return(1);
       }
     }

          return(0);
}
/*
         Move current window to location (Xloca,Yloca)

         Leif Laaksonen 1992
*/
/************************************************************************/
SetWindowLocation(Xloca , Yloca)
         int Xloca;
         int Yloca;
/************************************************************************/
{
#ifdef sgi
       long CXloca;
       long CYloca;
       long CXsize;
       long CYsize;

       if((CXsize = getgdesc(GD_XPMAX)) < 0) {
           PrintMessage("?ERROR - can't get screen resolution");
           return;}
       if((CYsize = getgdesc(GD_YPMAX)) < 0) {
           PrintMessage("?ERROR - can't get screen resolution");
           return;}

    if(Xloca < 0 || Xloca > CXsize ||
       Yloca < 0 || Yloca > CYsize) {
          PrintMessage("?ERROR - window size wrongly defined");
          return;}

       getorigin(&CXloca , &CYloca);
       getsize  (&CXsize , &CYsize);

       winconstraints();
       prefposition(Xloca , (Xloca + CXsize) ,
                    Yloca , (Yloca + CYsize));
       keepaspect(1 , 1);
       winconstraints();
       reshapeviewport();
#else
       PrintMessage("ERROR - not implemented on this device");
#endif
}
/*
       Size current windows to Xsize and Ysize pixels

       Leif Laaksonen 1992
*/
/************************************************************************/
SetWindowSize(Xsize , Ysize)
/************************************************************************/
{
#ifdef sgi
       long CXloca;
       long CYloca;
       long CXsize;
       long CYsize;

       if((CXsize = getgdesc(GD_XPMAX)) < 0) {
           PrintMessage("?ERROR - can't get screen resolution");
           return;}
       if((CYsize = getgdesc(GD_YPMAX)) < 0) {
           PrintMessage("?ERROR - can't get screen resolution");
           return;}

    if(Xsize < 0 || Xsize > CXsize ||
       Ysize < 0 || Ysize > CYsize) {
          PrintMessage("?ERROR - window size wrongly defined");
          return;}

       getorigin(&CXloca , &CYloca);
       getsize  (&CXsize , &CYsize);

       winconstraints();
       prefsize(Xsize , Ysize);
       keepaspect( 1 , 1 );
       winconstraints();
       reshapeviewport();
#else
       PrintMessage("ERROR - not implemented on this device");
#endif
}
/************************************************************************/
int SetContSmoothOn()
/************************************************************************/
{
    int i;

    for(i = 0 ; i < ContoursDefined ; i++) ContourInfo[i].ContSmooth = 1;

    return(0);
}
/************************************************************************/
int SetContSmoothOff()
/************************************************************************/
{
    int i;

    for(i = 0 ; i < ContoursDefined ; i++) ContourInfo[i].ContSmooth = 0;

    return(0);
}
/************************************************************************/
int SetContAlpha(AValue)
    float AValue;
/************************************************************************/
{
    int i;

    for(i = 0 ; i < ContoursDefined ; i++) ContourInfo[i].AlphaBlend = AValue;

    return(0);
}
/************************************************************************/
int ChooseManSelection(char *text1 , char *text2 , char *text3)
/************************************************************************/
{
     register int i;
     static int ihelp,atom_list;
     static int slong;
     static int *sel_list;
     char chelp[BUFF_LEN];

     atom_list = atom_list_max();

     sel_list = ivector(atom_list);

     slong = select_list(text1,text2,text3,sel_list);

     if(slong > 0) { 

     if(ManSelection.slong) 
                   (void)DelManSelectionList();

     ManSelection.sel_list = ivector(slong);
     ManSelection.slong    = slong;

     for(i = 0 ; i < slong ; i++)
                             ManSelection.sel_list[i] = sel_list[i];

     free(sel_list);

     }
        else { 
        PrintMessage("?ERROR - no atoms in the selection list ");
        free(sel_list);
        return(1);
        }

    return(0);        
}
/************************************************************************/
int DelManSelectionList()
/************************************************************************/
{
    if(ManSelection.slong) {
       free(ManSelection.sel_list);
            ManSelection.slong = 0;
            ManSelection.InUse = 0;
     }
     else {
/*
     PrintMessage("?ERROR - no selection list defined to be deleted");
*/
     return(1);}

     return(0);
}
/************************************************************************/
int SelectionListInUse()
/************************************************************************/
{
/*
    if(ManSelection.slong < 1)
                    ManSelection.InUse = 0;
*/
    return(ManSelection.InUse);
}
