/*  

                       Copyright (c) 1990 by:
        Leif Laaksonen , VTT/Biotechnical laboratory, ESPOO, FINLAND
            Confidential unpublished property of Leif Laaksonen
                        All rights reserved
  

*/

#include <stdio.h>
#include <math.h>
#include <string.h>
#ifdef sgi
#include <gl.h>
#endif
#include "maxdefs.h"

     extern int current_struct;  /* current structure      */
     extern int mlist_deep;      /* stack number indicator */
     extern int mlists[MAX_MLIST]; /* First index for molecule list */
     extern int mliste[MAX_MLIST]; /* Second index for molecule list */
     extern char mnlist[MAX_MLIST][BUFF_LEN]; 
                                /* name list for molecule file names */

/*************************************************************************/
sel_struct(alt)  /* if mlist_deep > 1 it means that the user has to pick
                 one structure from the list */
     long *alt;    /* selected structure number IN THE ARRAY */
/*************************************************************************/
{

      static long struc_menu;
      static char *TakeAll = "Apply on all";
      int i;

      if(mlist_deep < 2) {
      printf("?ERROR - just one structure to choose from\n");
      *alt = 0;
      return;}

#ifdef sgi
      struc_menu = newpup(); /* create the menu */
      addtopup(struc_menu, "Choose structure %t");

      for(i = 0 ; i < mlist_deep ; i++) 
                          addtopup(struc_menu,mnlist[i]);

      addtopup(struc_menu,TakeAll);

      *alt = dopup(struc_menu) - 1;

      freepup(struc_menu); /* delete the menu to be able to create it again */

      current_struct = *alt;
#endif

}
