/*  

                       Copyright (c) 1993 by:
        Leif Laaksonen , Center for Scientific Computing, ESPOO, FINLAND
            Confidential unpublished property of Leif Laaksonen
                        All rights reserved
  

*/

#include <stdio.h>
#include <string.h>
#include <math.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/signal.h>

#include "maxdefs.h"
#include "NetServicesPut.h"

extern int ServerPort;

/*   networking functions  */
 extern int NetStart();       /*  Start communication                  */
 extern int NetClose();       /*  Terminate a connection               */
 extern int NetAccept();      /*  Accept an incoming connection        */
 extern int NetRInt();        /*  Receive an integer                   */
 extern int NetRIntN();       /*  Receive n integers                   */
 extern int NetRFloat();      /*  Receive a floating point number      */
 extern int NetRFloatN();     /*  Receive n floating point numbers     */
 extern int NetRText();       /*  Receive a text string                */
 extern int NetSInt();        /*  Send an integer                      */
 extern int NetSIntN();       /*  Send n integers                      */
 extern int NetSFloat();      /*  Send a floating point number         */
 extern int NetSFloatN();     /*  Send n floating point numbers        */
 extern int NetSText();       /*  Send a text string                   */
 extern int NetAllowed();     /*  Check if connection is allowed       */
/*.........................*/
 extern void PrintMessage();

extern   struct MOL_STRUCT_DATA {
  char   AtomicSymbol[BUFF_LEN];
  char   AtomicLabel[BUFF_LEN];
  char   GBasisSetTag[BUFF_LEN];
  float  ChargeCenter;
  float  XCoord;
  float  YCoord;
  float  ZCoord;
                  } *MolStructData;

     extern int MAXatom;
     extern int mlist_deep;      /* stack number indicator */
     extern int mlists[MAX_MLIST]; /* First index for molecule list */
     extern int mliste[MAX_MLIST]; /* Second index for molecule list */
     extern char mnlist[MAX_MLIST][BUFF_LEN];
                                /* name list for molecule file names */


void GetSIGUSR2();
int  AcceptCallsIn();
int  BangTheStuff();

void   *GetMolStructPoint();
int     GetMolStructLen();
int     GetMolStructSpace(int Atoms);
int     DelMolStruct();
int     PrintMolStruct();
int     MolStructAtoms();
float   MolStructAtomXC(int i);
float   MolStructAtomYC(int i);
float   MolStructAtomZC(int i);
float   MolStructAtomCharge(int i);
char   *MolStructGBasisSetTag(int i);
char   *MolStructAtomLabel(int i);
/* */
int   PutMolStructAtomXC(int i , float value);
int   PutMolStructAtomYC(int i , float value);
int   PutMolStructAtomZC(int i , float value);
int   PutMolStructAtomCharge(int i , float value);
int   PutMolStructGBasisSetTag(int i , char *text);
int   PutMolStructAtomLabel(int i , char *text);
int   PutMolStructAtomSymbol(int i , char *text);

int read_coord_sock(char *Param);

int NumberOfAtoms;

struct {
    int CoordType;
    int NumberOfAtoms;
   } SockCoordStat;

/************************************************************************/
void GetSIGUSR2(int sig)
/************************************************************************/
{
     PrintMessage("*** Client connecting to socket ***");

     (void)AcceptCallsIn();

     return;
}
/*************************************************************************/
int AcceptCallsIn()
/*************************************************************************/
{
    int sock, length, msgsock, childpid;
    int i,j;
    char line[BUFF_LEN];
    char OutText[BUFF_LEN];
    int  socket;
    int  ScarePort;

    ScarePort = ServerPort + 10;

    (void)NetStart(0 , "****" , ScarePort , &socket);

    (void)NetAccept(socket , &msgsock);

    (void)GetSocketStuff(msgsock);

          NetClose(msgsock);
          NetClose(socket);
}

/*************************************************************************/
int GetSocketStuff(int msgsock)
/*************************************************************************/
{
    int sock;
    char String[BUFF_LEN];
    char *SendText;
    int   SendTextLen;
    char  SocketText[BUFF_LEN];
    char  OutText[BUFF_LEN];
    int ActionCode;

/*  (1)   USER NAME */

    if(NetRText(msgsock , SocketText , &SendTextLen)) {
       PrintMessage("?ERROR - can't read user name from socket");
       return(1);}

    *(SocketText+SendTextLen) = '\0';
    sprintf(OutText,"User '%s' connecting to socket",SocketText);
    PrintMessage(OutText);

/*  (2)   NODE NAME */

    if(NetRText(msgsock , SocketText , &SendTextLen)) {
       PrintMessage("?ERROR - can't read host name from socket");
       return(1);}

    *(SocketText+SendTextLen) = '\0';
    sprintf(OutText,"From host '%s'",SocketText);
    PrintMessage(OutText);

/*  Get the action code ... */

    if(NetRInt(msgsock , &ActionCode)) {
       PrintMessage("?ERROR - can't read action code from socket");
       return(1);}

    switch(ActionCode) {

        case GET_COORD_OPENMOL:    /* Get coordinates through the network */
             SockCoordStat.CoordType = OPENMOL_TYPE;
             if(GetCoordFromNet(msgsock)) {
                PrintMessage("?ERROR - can't get coordinates from net");
                return(1);}
             break;

        case PUT_COORD_OPENMOL:   /* Put Coordinates through the network  */
             break;

        default:  /* you should never end up here */
             PrintMessage("?ERROR - in action code");
             return(1);
     }
} 

/***************************************************************************/
int GetMolStructLen()
/***************************************************************************/
{
    if(NumberOfAtoms < 1) {
       PrintMessage("?ERROR - no atoms defined");
       return(-1);}

    return(sizeof(*MolStructData) * NumberOfAtoms);
}
/***************************************************************************/
void *GetMolStructPoint()
/***************************************************************************/
{
    if(NumberOfAtoms < 1) {
       PrintMessage("?ERROR - no atoms defined");
       return(NULL);}

     return(&MolStructData[0]);
}
/***************************************************************************/
int  GetMolStructSpace(int Atoms)
/***************************************************************************/
{
     int i;


       if(!NumberOfAtoms) {   /* first time down here */
           MolStructData = (struct MOL_STRUCT_DATA *)
                           malloc(Atoms * sizeof(*MolStructData));
         }
       else {
           MolStructData = (struct MOL_STRUCT_DATA *)
                           realloc(MolStructData ,
                           (Atoms + NumberOfAtoms) * sizeof(*MolStructData));
         }

       if(MolStructData == NULL) {
         PrintMessage("?ERROR - can't allocate space for molecular structure");
         return(1);}

      NumberOfAtoms = Atoms;

      return(0);
}
/***************************************************************************/
int DelMolStruct()
/***************************************************************************/
{

    if(MolStructData == NULL) {
       PrintMessage("?ERROR - no structure set up to be deleted");
       return(1);}

    NumberOfAtoms = 0;
    free(MolStructData);
    MolStructData = NULL;
}
/***************************************************************************/
int PrintMolStruct()
/***************************************************************************/
{
    int  i;
    char OutText[BUFF_LEN];

    if(NumberOfAtoms < 1) {
       PrintMessage("?ERROR - no atom structure information available");
       return(1);}

    for(i = 0 ; i < NumberOfAtoms ; i++) {
       sprintf(OutText,"(%d): Atomic symbol: '%s', atomic label: '%s'",
               (i+1), MolStructData[i].AtomicSymbol,
                      MolStructData[i].AtomicLabel);
       PrintMessage(OutText);
       sprintf(OutText,"Gaussian basis set tag: '%s'",
                      MolStructData[i].GBasisSetTag);
       PrintMessage(OutText);
       sprintf(OutText,"Charge: %f, xc: %f, yc: %f, zc: %f",
                      MolStructData[i].ChargeCenter,
                      MolStructData[i].XCoord,
                      MolStructData[i].YCoord,
                      MolStructData[i].ZCoord);
       PrintMessage(OutText);
     }

     return(0);
}
/***************************************************************************/
int MolStructAtoms()
/***************************************************************************/
{
    return(NumberOfAtoms);
}
/***************************************************************************/
float   MolStructAtomXC(int i)
/***************************************************************************/
{

        return(MolStructData[i].XCoord);
}
/***************************************************************************/
float   MolStructAtomYC(int i)
/***************************************************************************/
{

        return(MolStructData[i].YCoord);
}
/***************************************************************************/
float   MolStructAtomZC(int i)
/***************************************************************************/
{

        return(MolStructData[i].ZCoord);
}
/***************************************************************************/
float   MolStructAtomCharge(int i)
/***************************************************************************/
{
        return(MolStructData[i].ChargeCenter);
}
/***************************************************************************/
char   *MolStructGBasisSetTag(int i)
/***************************************************************************/
{
        return(MolStructData[i].GBasisSetTag);
}
/***************************************************************************/
char   *MolStructAtomLabel(int i)
/***************************************************************************/
{
        return(MolStructData[i].AtomicLabel);
}
/***************************************************************************/
int read_coord_sock(char *Param)
/***************************************************************************/
{
    if(AcceptCallsIn())
                 return(1);
    else
                 return(0);
}


/*************************************************************************/
int GetCoordFromNet(int sock)
/*************************************************************************/
{
   int NumAtoms;
   int Chars2Come;

/* here we go ...     (number of atoms to come)    */
     if(NetRInt(sock , &NumAtoms)) {
       PrintMessage("ERROR - can't receive stuff through the socket");
       return(1);}

/* get the space for the structure                   */
     if(GetMolStructSpace(NumAtoms)) {
        PrintMessage("?ERROR - can't get space for the molecule structure");
        return(1);}

/* now the structure containing the atom information */
     if(NetRText(sock , (char *)MolStructData , 
                                &Chars2Come)) {
       PrintMessage("ERROR - can't receive stuff through the socket");
       return(1);}

     if(Chars2Come != GetMolStructLen()) {
       PrintMessage("?ERROR - characters got != structure length");
       return(1);}

     (void)PrintMolStruct();

     if(PlaceCoordinates()) {
        PrintMessage("?ERROR - can't place coordinates");
        return(1);}

     return(0);
}
/*************************************************************************/
int PlaceCoordinates()
/*************************************************************************/
{
   int i,j;
   int NumAt;
   int atoms;
   char OutText[BUFF_LEN];
   float conv = 0.52917715;

       NumAt = 0 ; /* start counting number of atoms */
       if(mlist_deep == 0) 
        i = 0;
         else
          i = mliste[mlist_deep - 1];

        if(NumberOfAtoms < 1) {
           PrintMessage("?ERROR - no atoms in SOCKET structure");
           return(1);}

        if((NumberOfAtoms + i) >= MAXatom) {
        PrintMessage("?ERROR - max number of atoms reached");
        return(1);}


       for(atoms = 0 ; atoms < MolStructAtoms() ; atoms++) {

       strncpy(OutText,(const char *)MolStructAtomLabel(atoms),
                                     MAX_ATM_NAME_LEN);

          j = PutAtmName(OutText   , (atoms + i));
          j = PutResName("NN"      , (atoms + i));
          j = PutSegName("NN"      , (atoms + i));

          j = PutResNum1( 1 , (atoms + i));
          j = PutResNum2( 1 , (atoms + i));

      j = PutXCoord(MolStructAtomXC(atoms)*conv   , (atoms + i));
       j = PutYCoord(MolStructAtomYC(atoms)*conv  , (atoms + i));
        j = PutZCoord(MolStructAtomZC(atoms)*conv , (atoms + i));

      j = PutBValue( 0.0 , i);
       j = PutAtmCharge( 0.0 , i);

         NumAt++;
}

     update_mlist(NumAt);

     (void)DelMolStruct();

     PrintMessage("**********   Done   **********");

     return(0);

}


/***************************************************************************/
int   PutMolStructAtomXC(int i , float value)
/***************************************************************************/
{

        MolStructData[i].XCoord = value;

        return(0);
}
/***************************************************************************/
int   PutMolStructAtomYC(int i , float value)
/***************************************************************************/
{

       MolStructData[i].YCoord = value;

       return(0);
}
/***************************************************************************/
int   PutMolStructAtomZC(int i , float value)
/***************************************************************************/
{

        MolStructData[i].ZCoord = value;

        return(0);
}
/***************************************************************************/
int   PutMolStructAtomCharge(int i , float value)
/***************************************************************************/
{
        MolStructData[i].ChargeCenter = value;

        return(0);
}
/***************************************************************************/
int   PutMolStructGBasisSetTag(int i , char *text)
/***************************************************************************/
{
        strncpy(MolStructData[i].GBasisSetTag,text,BUFF_LEN);

        return(0);
}
/***************************************************************************/
int   PutMolStructAtomLabel(int i , char *text)
/***************************************************************************/
{
        strncpy(MolStructData[i].AtomicLabel,text,BUFF_LEN);

        return(0);
}
/***************************************************************************/
int   PutMolStructAtomSymbol(int i , char *text)
/***************************************************************************/
{
        strncpy(MolStructData[i].AtomicSymbol,text,BUFF_LEN);

        return(0);
}
/*************************************************************************/
int PutCoordToNet(int sock)
/*************************************************************************/
{
   int NumAtoms;
   int Chars2Come;

/* here we go ...     (number of atoms to come)    */
     if(NetSInt(sock , NumAtoms)) {
       PrintMessage("ERROR - can't send stuff through the socket");
       return(1);}

/* get the space for the structure                   */
     if(GetMolStructSpace(NumAtoms)) {
        PrintMessage("?ERROR - can't get space for the molecule structure");
        return(1);}

/* now the structure containing the atom information */
     if(NetSText(sock , (char *)MolStructData , 
                                Chars2Come)) {
       PrintMessage("ERROR - can't receive stuff through the socket");
       return(1);}

     if(Chars2Come != GetMolStructLen()) {
       PrintMessage("?ERROR - characters got != structure length");
       return(1);}

     (void)PrintMolStruct();

     if(PlaceCoordinates()) {
        PrintMessage("?ERROR - can't place coordinates");
        return(1);}

     return(0);
}
