/*  

                       Copyright (c) 1990, 1992 by:
        Leif Laaksonen , Center for Scientific Computing, ESPOO, FINLAND
            Confidential unpublished property of Leif Laaksonen
                        All rights reserved
  

*/

#include <stdio.h>
#include <math.h>
#include <malloc.h>
#include <string.h>

#include "maxdefs.h"

#define MOD(a,b)  (((a+1)/b)*b - (a+1))

  extern int   *ivector();
  extern float *vector();
  extern int force_type;

  extern struct {
  int nfreat;                        /* number of free atoms */
  int *free_atom_list;} free_alist;  /* list of free (not fixed) atoms */

/***************************************************************************/
int rtraj_frame(alt)  /* read one frame from trajectory   */
    int alt;          /* mode of operation (=0) first time in read
                                      (>0) trajectory number */
/***************************************************************************/
{
         static int retv;

         switch(force_type) {

         case 0: /* type is not set */
                 printf("?ERROR - trajectory type is not set \n");
                 return(-1);

	 case 1: /* charmm type */
                 retv =  get_frame_charmm(alt , 0);
                 return(retv);              

	 case 2: /* discover type */
                 retv = get_frame_discover(alt , 0);
                 return(retv);

 	 case 3: /* amber type */
                 retv =  get_frame_amber(alt , 0);
                 return(retv);

	 case 4: /* yasp type */
                 retv =  get_frame_yasp(alt , 0);
                 return(retv);

	 case 5: /* mumod type */
                 retv = get_frame_mumod(alt , 0);
                 return(retv);

	 case 6: /* gromos type */
                 retv = get_frame_gromos(alt , 0);
                 return(retv);

	 case 7: /* hyperchem type */
                 retv = get_frame_hyperchem(alt , 0);
                 return(retv);

	 default: /* there is something wrong */
                 printf("?ERROR - can't continue \n");
                 shut_down(1);
	       }
}

