/*  

                       Copyright (c) 1990 by:
        Leif Laaksonen , Center for Scientific Computing, ESPOO, FINLAND
            Confidential unpublished property of Leif Laaksonen
                        All rights reserved
  

*/

/*

   This is the piece of code from MOPAC 5 which writes the data to disk

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
*
* write to disk the following data for graphics calculation, in order:
*
*      number of atoms, orbital, electrons
*      all atomic coordinates
*      orbital counters
*      orbital exponents, s, p, and d, and atomic numbers
*      eigenvectors (m.o.s not re-normalized)
*      inverse-square root of the overlap matrix.
*
         write(13)numat,norbs,nelecs,((xyz(i,j),j=1,numat),i=1,3)
         write(13)(nlast(i),nfirst(i),i=1,numat)
         write(13)(zs(nat(i)),i=1,numat),(zp(nat(i)),i=1,numat),
     1         (zd(nat(i)),i=1,numat),(nat(i),i=1,numat)
         linear=norbs*norbs
         write(13)(c(i),i=1,linear)
         write(13)(f(i),i=1,linear)
         if(index(keywrd,'mullik').eq.0)return
      endif
*/

#include <stdio.h>
#include <math.h>
#include <string.h>
#include <ctype.h>
#include <malloc.h>
#include "maxdefs.h"

#if defined(USEFORMS) && defined(sgi)
#include "../forms/FORMS/forms.h"
#endif

    extern int numat;
    extern float *x;
    extern float *y;
    extern float *z;
    extern char *segment;
    extern char *resnam;
    extern char *atnam;
    extern char *element;
    extern int  *res1;
    extern int  *res2;
    extern int element_p[];
     extern char input_file[BUFF_LEN];
     extern int mlist_deep;      /* stack number indicator */
     extern int mlists[MAX_MLIST]; /* First index for molecule list */
     extern int mliste[MAX_MLIST]; /* Second index for molecule list */
     extern char mnlist[MAX_MLIST][BUFF_LEN]; 
                                /* name list for molecule file names */

     extern void PrintMessage();
     extern void dialog4();

extern void send_command();
extern int PutSegName();
extern int PutResName();
extern int PutAtmName();
extern int PutResNum1();
extern int PutResNum2();
extern int PutXCoord();
extern int PutYCoord();
extern int PutZCoord();
extern int PutBValue();
extern int PutAtmCharge();

/*************************************************************************/
pre_read_mopac()  /* pre routine for reading a mopac graph file */

/*************************************************************************/
{

    extern char *bottom_line;
    char text[BUFF_LEN];
    char Cline[BUFF_LEN];
    int ret_val;

#ifdef sgi

#if defined(USEFORMS) && defined(sgi)
  { char *fname;
  fname = fl_show_file_selector("Give name of MOPAC graph file:  ","","","");
  if(fname == NULL) 
    text[0] = '\0';
      else
      strncpy(text,fname,BUFF_LEN);}
#else
    dialog4("Reading MOPAC graph file.","Give name of MOPAC graph file:  ",text);
#endif
     if(text[0] == '\0') return;
    strncpy(input_file,text,BUFF_LEN);
      strncpy(Cline,"read coord mopac ",BUFF_LEN);
       strncat(Cline,text,(BUFF_LEN - strlen(Cline)));
    strncpy(bottom_line,"Reading MOPAC graph file ...",PORTchar);
    going_on();
    send_command(Cline);
    return;
#else

    printf("?ERROR - not implemented on this device \n");

#endif
}


/***************************************************************************/
int read_mopac(filen)

      char *filen;
/***************************************************************************/
{

      FILE *mopac_p;
      int record;
      int i,j,k,l,found_el;
      int numatm;  /* number of atoms */
      int norbs;   /*           orbitals */
      int nelecs;  /*           electrons */
      double **xyz; /* coordinates pointer */
      int *nlast,*nfirst; /* orbital counters */
      double *zs;   /* orbital exponents s,p,d */
      double *zp;
      double *zd;
      int *nat;
      char OutText[BUFF_LEN];

      mopac_p = fopen(filen,"r");
      if(mopac_p == NULL) {
        sprintf(OutText,"?ERROR - can't open MOPAC output file '%s'",filen);
        PrintMessage(OutText);
        return;}

       fread(&record,sizeof(int),1,mopac_p); /* controll record */
       fread(&numatm,sizeof(int),1,mopac_p);
       fread(&norbs,sizeof(int),1,mopac_p);
       fread(&nelecs,sizeof(int),1,mopac_p);

sprintf(OutText,"Reading MOPAC graphics output file '%s'",filen);
PrintMessage(OutText);
sprintf(OutText,"numat: %d norbs: %d nelecs: %d",numatm,norbs,nelecs);
PrintMessage(OutText);

/* update display list */
     numat = numatm;
     update_mlist(numat);

/* get space for the rest */

       nlast  = (int *) malloc( numatm * sizeof(int));
       nfirst = (int *) malloc( numatm * sizeof(int));

       if(nlast == NULL || nfirst == NULL) {
         PrintMessage("?ERROR - can't allocate space for arrays 'rmopac'");
         exit(1);}

       xyz = (double **) malloc( numatm * sizeof(double *));
       
       if(xyz == NULL ) {
         PrintMessage("?ERROR - can't allocate space for arrays 'rmopac'");
         exit(1);}

 
       for(i = 0 ; i < numatm ; i++) {
            xyz[i] = (double *) malloc( 3 * sizeof(double));
       if(xyz[i] == NULL ) {
         PrintMessage("?ERROR - can't allocate space for arrays 'rmopac'");
         exit(1);}}

       zs = (double *) malloc(numatm * sizeof(double));
       zp = (double *) malloc(numatm * sizeof(double));
       zd = (double *) malloc(numatm * sizeof(double));

       nat = (int *) malloc(numatm * sizeof(int));

       for(j = 0 ; j < 3 ; j++) {
           for(i = 0 ; i < numatm ; i++) {
               fread(&xyz[i][j],sizeof(double), 1 ,mopac_p);}}

       fread(&record,sizeof(int),1,mopac_p); /* controll record */

       fread(&record,sizeof(int),1,mopac_p); /* controll record */
       for(i = 0 ; i < numatm ; i++) {
       fread(&nlast[i],sizeof(int), 1 ,mopac_p);
       fread(&nfirst[i],sizeof(int), 1 ,mopac_p);}
       fread(&record,sizeof(int),1,mopac_p); /* controll record */

       fread(&record,sizeof(int),1,mopac_p); /* controll record */
          fread(zs,sizeof(double),numatm,mopac_p);
          fread(zp,sizeof(double),numatm,mopac_p);
          fread(zd,sizeof(double),numatm,mopac_p);
          fread(nat,sizeof(int),numatm,mopac_p);
       fread(&record,sizeof(int),1,mopac_p); /* controll record */

/* flush coordinates to the scarecrow vectors */
       k = 0;
       for(i = mlists[mlist_deep - 1] ; i < mliste[mlist_deep - 1] ; i++) {
          l = PutXCoord(xyz[i][0] , i); 
           l = PutYCoord(xyz[i][1] , i); 
            l = PutZCoord(xyz[i][2] , i);
             l = PutAtmCharge( 0.0 , i);
/* segment name    */
          l = PutSegName("MOPC",i);
/* residue name    */
          l = PutResName("MOPC",i);
/* residue number  */
          l = PutResNum1( 1 , i);
           l = PutResNum2( 1 , i);
/* set atom symbol */
          l = nat[k];
          found_el = 0;
          for(j = 0 ; j < MAXelements ; j++) {
              if(l == element_p[j]) {
               found_el = 1;
                if(element[4*j+1] == ' ') 
                    sprintf(atnam+4*i,"%.1s%.2d",element+4*j,(i+1));
                else 
                    sprintf(atnam+4*i,"%.2s%.2d",element+4*j,(i+1));
                 break;}
	   }
          if(found_el == 0) {
            PrintMessage("?ERROR - can't find element");
            sprintf(OutText,"Element number: %d is unknown",nat[i]);
            PrintMessage(OutText);}
        k++; /* increment mopac list pointer */
	}
/* free memory */
        free(nlast);
         free(nfirst);
          free(xyz);
           free(zs);
            free(zp);
             free(zd);
              free(nat);
        return(0);
}




