/*  

                       Copyright (c) 1990, 1993 by:
        Leif Laaksonen , Center for Scientific Computing, ESPOO, FINLAND
            Confidential unpublished property of Leif Laaksonen
                        All rights reserved
  

*/


/*
   This program reads a Charmm coordinate file

   Leif Laaksonen 1989
*/

#include <stdio.h>
#include <math.h>
#include <string.h>
#include <ctype.h>

#if defined(USEFORMS) && defined(sgi)
#include "../forms/FORMS/forms.h"
#endif

#include "maxdefs.h"
#define KARP_LINE_LEN   80   /* pdb file line length */

extern float *vector();
extern char  *sprint_names();
extern int NumStructLists();
extern int StartIndexStructList();

extern char input_file[BUFF_LEN];
     extern int mlist_deep;      /* stack number indicator */
     extern int mlists[MAX_MLIST]; /* First index for molecule list */
     extern int mliste[MAX_MLIST]; /* Second index for molecule list */
     extern char mnlist[MAX_MLIST][BUFF_LEN]; 
                                /* name list for molecule file names */

     extern int MAXatom;
     extern void dialog4();
     extern void send_command();
     extern int    *ivector();
     extern float  *vector();
     extern char   *cvector();

/* define the CHARMm structure                          */
   struct CHARMm { /* Charmm structure */
   int numat;          /* number of atoms in this structure */
   int *res1;          /* residue number 1 list */
   int *res2;          /* residue number 2 list */
   char *resnam;       /* residue name list */
   char *atnam;        /* atom name list */
   char *segment;      /* segment name list */
   float *x;           /* x,y and z coordinates */
   float *y;
   float *z;
   float *bvalue;};      /* bvalue list */

struct  CHARMm TCHARMm;

/* pointers for force calculation */

     struct force_struct {
     int    set;  /* switch if the forces are set = 0 , not != 0, yes */
     int   plot;  /* switch for a plot = 0 , no plot , != 0 a plot */
     float  *fx;  /* pointers to the forces */
     float  *fy;
     float  *fz;
     int *sel_list; /* selection list */
     int  ent_list; /* entries in the selection list */
     float scale; /* scale factor */
     int   maxfi; /* index of max force atom */
     float maxfa; /* value of the max force  */
     int   minfi; /* index on min force atom */
     float minfa; /* value of the min force  */ } atm_force; 

/* define the CHARMm structure                          */
   extern struct CHARMm  *Charmm_struct;
/* end of CHARMm structure                              */

   extern int numat,*res1,*res2;
   extern char *bottom_line;
   extern float *x,*y,*z,*bvalue;
   extern char  *resnam,*atnam,*segment;
/*                                                 */

extern int PutSegName();
extern int PutResName();
extern int PutAtmName();
extern int PutResNum1();
extern int PutResNum2();
extern int PutXCoord();
extern int PutYCoord();
extern int PutZCoord();
extern int PutBValue();
extern int PutAtmCharge();

/*************************************************************************/
pre_read_karp()  /* pre routine for reading a charmm file */

/*************************************************************************/
{

    static char Text[BUFF_LEN];
    static char Cline[BUFF_LEN];
    static int ret_val;

#ifdef sgi

#if defined(USEFORMS) && defined(sgi)
  { char *fname;
  fname = fl_show_file_selector("Give name of CHARMm file:  ","","*.CRD","");
  if(fname == NULL) 
    Text[0] = '\0';
      else
      strncpy(Text,fname,BUFF_LEN);}
#else
    dialog4("Reading CHARMM file.","Give name of CHARMm file:  ",Text);
#endif
     if(Text[0] == '\0') return;
     strncpy(input_file,Text,BUFF_LEN);
      strncpy(Cline,"read coord karp ",BUFF_LEN);
       strncat(Cline,Text,(BUFF_LEN - strlen(Cline)));
       strncpy(bottom_line,"Reading CHARMM file ...",PORTchar);
       going_on();
      send_command(Cline);
    return;

#else

    printf("?ERROR - not implemented on this device \n");

#endif
}

/*************************************************************************/
int read_karp(inp_file)
/*************************************************************************/
    char *inp_file;
{


static char inputl[KARP_LINE_LEN];
static int tatomn;
static int i,j,k;
static int type_warning;

   int     TRs1,TRs2;
   float   TXc,TYc,TZc,TBv;
   char    TSegN[BUFF_LEN];
   char    TResN[BUFF_LEN];
   char    TAtmN[BUFF_LEN];

char OutText[BUFF_LEN];

FILE *chm_in;

   type_warning = 0;

      chm_in=fopen(inp_file,"r");
       if(chm_in == NULL) {
        sprintf(OutText,"Can't open input file : %s",inp_file);
        PrintMessage(OutText);
        return(1);
       }

      sprintf(OutText,"********** Reading : %s **********",inp_file);
      PrintMessage(OutText);
      PrintMessage("           Title   : ");
/*
      Start reading file

*/

/*  1.0 A title is expected    */

       fgets(inputl,KARP_LINE_LEN,chm_in);
       PrintMessage(inputl);

       while(strncmp(inputl,"*",1) == 0) {
         fgets(inputl,KARP_LINE_LEN,chm_in);
         if(strncmp(inputl,"*",1) != 0) break;
         PrintMessage(inputl);
       }
/*   2.0 Numbers of atoms */

       sscanf(inputl,"%d",&numat);

/* it's possible to already update now */

       update_mlist(numat);

/*   3.0 Read atom cards  */

     for(i = mlists[mlist_deep - 1] ; i < mliste[mlist_deep - 1]; i++ ) {
       fgets(inputl,KARP_LINE_LEN,chm_in);
/*
         sscanf(inputl," %d %d %s %s %f %f %f %s %d %f ",
	 &tatomn,&res1[i],resnam+4*i,atnam+4*i,
	 &x[i],&y[i],&z[i],segment+4*i,&res2[i],&bvalue[i]);
*/
         sscanf(inputl," %d %d %s %s %f %f %f %s %d %f ",
	 &tatomn,&TRs1,TResN,TAtmN,&TXc,&TYc,&TZc,TSegN,&TRs2,&TBv);

         j = PutSegName(TSegN , i);
          j = PutResName(TResN , i);
           j = PutAtmName(TAtmN , i);

         j = PutXCoord(TXc , i);
          j = PutYCoord(TYc , i);
           j = PutZCoord(TZc , i);

         j = PutResNum1(TRs1 , i);
         j = PutResNum2(TRs2 , i);

         j = PutBValue(TBv , i);
          j = PutAtmCharge( 0.0 , i);

     }

      PrintMessage("**********   Done   **********");

     fclose(chm_in);

     return(0);
}

/***********************************************************************/
update_mlist(atoms)  /* update molecule list */
       int atoms;    /* with atoms */
/***********************************************************************/
{
     if(mlist_deep == 0) {
     mlists[0] = 0;
     mliste[0] = atoms;}
     else {
     mlists[mlist_deep] = mliste[mlist_deep - 1]; /* first index */
     mliste[mlist_deep] = mlists[mlist_deep] + atoms;} /* second index */

/* check boundaries */
    if(mliste[mlist_deep] >= MAXatom ) {
    PrintMessage("?ERROR - Limit of maximum number of allowed atoms reached");
    return;}

     mlist_deep++;

/* update CHARMm structure pointers */

     UpdateCharmmStruct(atoms);
}
/*
    Read in forces from a charmm file

    Leif Laaksonen 1990
*/
/*************************************************************************/
int read_charmm_force(inp_file)
    char *inp_file;
/*************************************************************************/
{

/*  externals                                      */
   extern int numat,*res1,*res2;
   extern float *x,*y,*z,*bvalue;
   extern char  *resnam,*atnam,*segment;
/*                                                 */

static char inputl[KARP_LINE_LEN];
static int tatomn,tres1,tres2;
static int i,j,k;
static int type_warning;
static float tf;

       char tseg[BUFF_LEN];
       char tres[BUFF_LEN];
       char tatm[BUFF_LEN];

char OutText[BUFF_LEN];

FILE *chm_in;

   type_warning = 0;

      chm_in=fopen(inp_file,"r");
       if(chm_in == NULL) {
        sprintf(OutText,"Can't open input file : %s ",inp_file);
        PrintMessage(OutText);
        return(1);
       }

/*
      Start reading file

*/

/*  1.0 A title is expected    */

       fgets(inputl,KARP_LINE_LEN,chm_in);
       printf("%s",inputl);

       while(strncmp(inputl,"*",1) == 0) {
         fgets(inputl,KARP_LINE_LEN,chm_in);
         if(strncmp(inputl,"*",1) != 0) break;
         if(inputl[strlen(inputl) - 1] == '\n') 
                  inputl[strlen(inputl) - 1] = '\0';
         sprintf(OutText,"%s",inputl);
         PrintMessage(OutText);
       }
/*   2.0 Numbers of atoms */

       sscanf(inputl,"%d",&tatomn);

/* check that the number of atoms match the current molecule */
       if(tatomn != mliste[0]) {
         PrintMessage("?ERROR - number of atoms in the force file does not match current molecule\n");
         return(1);} 

/*   3.0 Read force cards  */
     if(atm_force.set != 0) { /* there is already data, delete it first */
       free(atm_force.fx);
        free(atm_force.fy);
         free(atm_force.fz);}

      if(atm_force.ent_list) {
        free(atm_force.sel_list);
        atm_force.ent_list = 0;}

      atm_force.fx = vector(tatomn);
       atm_force.fy = vector(tatomn);
        atm_force.fz = vector(tatomn);

     atm_force.plot = 0;
     atm_force.set  = 1; /* forces are set */

     for(i = 0 ; i < tatomn; i++ ) {
       fgets(inputl,KARP_LINE_LEN,chm_in);
         sscanf(inputl,"%d %d %s %s %f %f %f %s %d",
          &j,&tres1,tres,tatm,&atm_force.fx[i],
                              &atm_force.fy[i],
                              &atm_force.fz[i],tseg,&tres2);

     }
/* look for the min/max */
         atm_force.maxfi =  -1;
         atm_force.maxfa = 0.0;
         atm_force.minfi =  -1;
         atm_force.minfa = 1.e+20;

         for( i = 0 ; i < tatomn ; i++) {
            tf = sqrt(atm_force.fx[i]*atm_force.fx[i] +
                      atm_force.fy[i]*atm_force.fy[i] +
                      atm_force.fz[i]*atm_force.fz[i]);
            if(tf > atm_force.maxfa) {
              atm_force.maxfa = tf;
              atm_force.maxfi = i ;}

            if(tf < atm_force.minfa) {
              atm_force.minfa = tf;
              atm_force.minfi = i ;}
	  }

       sprintf(OutText,"*** Force statistics from file '%s' ",inp_file);
       PrintMessage(OutText);

    if(atm_force.maxfi >= 0) {
      sprintf(OutText,"Max force is for %s : %f",sprint_names(atm_force.maxfi),
                                                 atm_force.maxfa);
       PrintMessage(OutText);}
      else
       PrintMessage("?ERROR - problems in assigning max force");

    if(atm_force.minfi >= 0) {
      sprintf(OutText,"Min force is for %s : %f",sprint_names(atm_force.minfi),
                                                 atm_force.minfa);
       PrintMessage(OutText);}
      else
       PrintMessage("?ERROR - problems in assigning min force");

      atm_force.scale = (atm_force.maxfa - atm_force.minfa) / 3.;

      PrintMessage("**********   Done   **********\n");

     fclose(chm_in);

     return(0);
}
/*************************************************************************/
int GetCHARMmStructSpace(int Atoms)
/*************************************************************************/
{

/* residue number 1 list */
   TCHARMm.res1   =   ivector(Atoms);
/* residue number 2 list */
   TCHARMm.res2   =   ivector(Atoms);
/* residue name list     */
   TCHARMm.resnam =   cvector(Atoms * MAX_RES_NAME_LEN);
/* atom name list        */
   TCHARMm.atnam  =   cvector(Atoms * MAX_ATM_NAME_LEN);
/* segment name list     */
   TCHARMm.segment =  cvector(Atoms * MAX_SEG_NAME_LEN);
/* x coordinate          */
   TCHARMm.x       =  vector(Atoms);
/* y coordinate          */
   TCHARMm.y       =  vector(Atoms);
/* z coordinate          */
   TCHARMm.z       =  vector(Atoms);
/* bvalue list           */
   TCHARMm.bvalue  =  vector(Atoms);

   return(0);
}
/*************************************************************************/
int DelCHARMmStruct(struct CHARMm DelCHARMm)
/*************************************************************************/
{
   if(DelCHARMm.numat < 1) {
      PrintMessage("?ERROR - no structure defined to be deleted");
      return(1);}

   free(DelCHARMm.res1);
   free(DelCHARMm.res2);
   free(DelCHARMm.resnam);
   free(DelCHARMm.atnam);
   free(DelCHARMm.segment);
   free(DelCHARMm.x);
   free(DelCHARMm.y);
   free(DelCHARMm.z);
   free(DelCHARMm.bvalue);
}
