/*  

                       Copyright (c) 1990 by:
        Leif Laaksonen , VTT/Biotechnical laboratory, ESPOO, FINLAND
            Confidential unpublished property of Leif Laaksonen
                        All rights reserved
  

*/


/*
   This program reads a Insight *.car coordinate file

   Leif Laaksonen 1990
*/

#include <stdio.h>
#include <math.h>
#include <string.h>

#if defined(USEFORMS) && defined(sgi)
#include "../forms/FORMS/forms.h"
#endif

#include "maxdefs.h"

#define INST_LINE_LEN   120 /* insight file line length is 80 char
                           but this prevents from getting less than 80 char*/
/*  externals                                      */
   extern int numat;
   extern float *atm_charge;

extern void send_command();
extern int MAXatom;
extern char input_file[BUFF_LEN];
     extern int mlist_deep;      /* stack number indicator */
     extern int mlists[MAX_MLIST]; /* First index for molecule list */
     extern int mliste[MAX_MLIST]; /* Second index for molecule list */
     extern char mnlist[MAX_MLIST][BUFF_LEN]; 
                                /* name list for molecule file names */

extern void PrintMessage();
extern int PutSegName();
extern int PutResName();
extern int PutAtmName();
extern int PutResNum1();
extern int PutResNum2();
extern int PutXCoord();
extern int PutYCoord();
extern int PutZCoord();
extern int PutBValue();
extern char GetSegName();
extern char GetResName();
extern char GetAtmName();
extern int GetResNum1();
extern int GetResNum2();
extern float GetXCoord();
extern float GetYCoord();
extern float GetZCoord();
extern float GetBValue();
extern int PutAtmCharge();

/*************************************************************************/
pre_read_insight()  /* pre routine for reading a insight file */

/*************************************************************************/
{

    extern char *bottom_line;
    char text[BUFF_LEN];
    char Cline[BUFF_LEN];
    int ret_val;

#ifdef sgi

#if defined(USEFORMS) && defined(sgi)
  { char *fname;
  fname = fl_show_file_selector("Give name of INSIGHT file:  ","","*.car","");
  if(fname == NULL) 
    text[0] = '\0';
      else
      strncpy(text,fname,BUFF_LEN);}
#else
    dialog4("Reading INSIGHT file.","Give name of INSIGHT file:  ",text);
#endif
     if(text[0] == '\0') return;
    strncpy(input_file,text,BUFF_LEN);
      strncpy(Cline,"read coord insigh ",BUFF_LEN);
       strncat(Cline,text,(BUFF_LEN - strlen(Cline)));
        strncpy(bottom_line,"Reading INSIGHT file ...",PORTchar);
         going_on();
        send_command(Cline);
       return;

#else

    printf("?ERROR - not implemented on this device \n");

#endif

}

/*************************************************************************/
int read_insight(inp_file)
/*************************************************************************/
    char *inp_file; /* name of file to be read */
{


   int     TRs1,TRs2;
   float   TXc,TYc,TZc,TBv;
   char    TSegN[BUFF_LEN];
   char    TResN[BUFF_LEN];
   char    TAtmN[BUFF_LEN];

char input[INST_LINE_LEN];
char temp[BUFF_LEN];
int tatomn,tres1,tres2;
int i,j,k;
char OutText[BUFF_LEN];

FILE *chm_in;

      chm_in=fopen(inp_file,"r");
       if(chm_in == NULL) {
        sprintf(OutText,"Can't open input file : %s",inp_file);
        PrintMessage(OutText);
        return(1);
       }

      sprintf(OutText,"********** Reading : %s **********",inp_file);
      PrintMessage(OutText);
      PrintMessage("           Title   : ");
/*
      Start reading file

*/

/*  1     */

       fgets(input,INST_LINE_LEN,chm_in);
       PrintMessage(input);

/*  2     */

       fgets(input,INST_LINE_LEN,chm_in);
       PrintMessage(input);

       i = 0;
       if(indexo(input,"on") > 0 ||
          indexo(input,"ON") > 0) i = 1; /* PBC is on */
/*  3     */

       fgets(input,INST_LINE_LEN,chm_in);
       PrintMessage(input);

/*  4     */

       fgets(input,INST_LINE_LEN,chm_in);
       PrintMessage(input);

/*  5     */

       if(i) {
       fgets(input,INST_LINE_LEN,chm_in);
       PrintMessage(input);}

/*  6 Read atom cards  */

       numat = 0 ; /* start counting number of atoms */
       if(mlist_deep == 0) 
        i = 0;
         else
          i = mliste[mlist_deep - 1];

       while(fgets(input,INST_LINE_LEN,chm_in) != NULL) { 

       strncpy(temp,input,INST_LINE_LEN);
        toller(temp);
         if(indexo(temp,"end") == 1) continue;

      j = PutAtmName(input , i);   /* atom name */
      strncpy(temp,input+5,15);    /* x - coordinate */
       j = PutXCoord(atof(temp) , i);
      strncpy(temp,input+20,15);    /* y - coordinate */
       j = PutYCoord(atof(temp) , i); 
      strncpy(temp,input+35,15);    /* z - coordinate */
       j = PutZCoord(atof(temp) , i);
      j = PutResName(input+51 , i); /* residue name */
      strncpy(temp,input+55,5);       /* residue sequence number relative to
                                         the beginning of the current mol */
       j = PutResNum1(atoi(temp) , i);

      strncpy(temp,input+65,10);   /* partial charge */
       atm_charge[i] = atof(temp);
      strncpy(temp,input+75,5);  /* absolute atomic sequence number relative
                                    to the beginning of the entire molecule */ 
       temp[5] = '\0'; /* prevent from including the <cr> */
       j = PutResNum2(atoi(temp) , i);

/* value added stuff      */
         j = PutSegName("INTH" , i); /* give it a segment name */
/* ...................... */

#ifdef DEBUG
         printf(" '%s' '%s' '%s' \n",
	 GetSegName(i),GetResName(i),GetAtmName(i));
#endif

         j = PutAtmCharge( 0.0 , i);
         i++;
         numat++;

        if(i == MAXatom) {
          PrintMessage("?ERROR - max atoms reached");
          return(1);}

     }

      PrintMessage("**********   Done   **********");
    
     update_mlist(numat);

     fclose(chm_in);

     return(0);
}
