/*  

                       Copyright (c) 1990, 1993 by:
        Leif Laaksonen , Center for Scientific Computing, ESPOO, FINLAND
            Confidential unpublished property of Leif Laaksonen
                        All rights reserved
  

*/
 
 
/*
   This program reads a HYPERCHEM coordinate file
 
   Leif Laaksonen 1993
*/
 
#include <stdio.h>
#include <math.h>
#include <string.h>

#include "maxdefs.h"

#if defined(USEFORMS) && defined(sgi)
#include "../forms/FORMS/forms.h"
#endif

#define HYPER_LINE_LEN   132   /* hyper file line length */
 
extern char *bottom_line;
extern int MAXatom;
extern int numat;
extern char input_file[BUFF_LEN];
extern int indexo();
extern void toller();

     extern int mlist_deep;      /* stack number indicator */
     extern int mlists[MAX_MLIST]; /* First index for molecule list */
     extern int mliste[MAX_MLIST]; /* Second index for molecule list */
     extern char mnlist[MAX_MLIST][BUFF_LEN]; 
                                /* name list for molecule file names */
 
     extern void send_command();
     extern void PrintMessage();
     extern void dialog4();

extern int PutSegName();
extern int PutResName();
extern int PutAtmName();
extern int PutResNum1();
extern int PutResNum2();
extern int PutXCoord();
extern int PutYCoord();
extern int PutZCoord();
extern int PutBValue();
extern int PutAtmCharge();
extern int NumStructLists();
extern int StartIndexStructList();

/*************************************************************************/
pre_read_hyper()  /* pre routine for reading a hyper file */
/*************************************************************************/
{
 
    char text[BUFF_LEN];
    char Cline[BUFF_LEN];
    int ret_val;

#ifdef sgi
 
#ifdef USEFORMS 
#ifdef sgi
  { char *fname;
  fname = fl_show_file_selector("Give name of HyperChem file:  ","","","");
  if(fname == NULL) 
    text[0] = '\0';
      else
      strncpy(text,fname,BUFF_LEN);}
#endif
#else
    dialog4("Reading HyperChem file.","Give name of HyperChem file:  ",text);
#endif
     if(text[0] == '\0') return;
    strncpy(input_file,text,BUFF_LEN);
      strncpy(Cline,"read coord hyper ",BUFF_LEN);
       strncat(Cline,text,(BUFF_LEN - strlen(Cline)));
    strncpy(bottom_line,"Reading HyperChem file ...",PORTchar);
    going_on();
    send_command(Cline);
    return; 
#else

    printf("?ERROR - not implemented on this device \n");

#endif

}
 
/*************************************************************************/
int read_hyper(inp_file)
/*************************************************************************/
    char *inp_file;
{
 

   int   TRs1,TRs2,NumAtomMol;
   float TXc,TYc,TZc,TBv,TCh;
   char  TResN[BUFF_LEN];
   char  TAtmN[BUFF_LEN];
   char  TSegN[BUFF_LEN];

 
   char inputl[HYPER_LINE_LEN];
   char temp[HYPER_LINE_LEN];
   int i,j,k;
   char OutText[BUFF_LEN];
   int  MolNum;
 
FILE *hyper_in;
 
      hyper_in=fopen(inp_file,"r");
       if(hyper_in == NULL) {
        sprintf(OutText,"Can't open input file : %s",inp_file);
        PrintMessage(OutText);
        return(1);
      }
 
      TRs1 = 1;
      TRs2 = 1;
      TBv  = 0.0;

      sprintf(OutText,"********** Reading : %s **********",inp_file);
      PrintMessage(OutText);
/*
      Start reading file
 
*/

       numat = 0 ; /* start counting number of atoms */

       i = StartIndexStructList();

       while(fgets(inputl,HYPER_LINE_LEN,hyper_in) != NULL) { 

/* Title/comment card (;) */
        if(inputl[0] == ';') 
                     PrintMessage(&inputl[1]);

/* Coordinates card (mol) */
        if(indexo(inputl,"mol") == 1) {

          sscanf(inputl,"%*s %d %s",&TRs1,TSegN);

          MolNum = TRs1;

          if(TSegN[0] != '\0')
                 strncpy(TResN,TSegN,BUFF_LEN);
          else   {
                 strncpy(TSegN,"HYPE",4);
                 strncpy(TResN,"HYPE",4);}
        }

/* Coordinates card (endmol) */
        else if(indexo(inputl,"endmol") == 1) {

          sscanf(inputl,"%*s %d",&TRs2);

          if(TRs2 < 1) TRs2 = 1;

          if(MolNum != TRs2) {
             PrintMessage("?ERROR - mol/endmol numbers do not match");}
         }

/* residue card           */
        else if(indexo(inputl,"endres") == 1) {

          sscanf(inputl,"%d",&TRs1);

          if(TRs1 != TRs2) {
           PrintMessage("?ERROR - residue number in res/endres does not mach");
	 }
        }

        else if(indexo(inputl,"res") == 1) {

          sscanf(inputl,"%*s %d %s",&TRs1,OutText);

          TRs2 = TRs1;

          if(OutText[0] == '\0')
                                 strncpy(TResN,"HYPE",4);
          else
                                 strncpy(TResN,OutText,BUFF_LEN);
	}


/* atom card              */
        else if(indexo(inputl,"atom") == 1) {

          sscanf(inputl,"%*s %d %s %s %*s %*c %f %f %f %f", &NumAtomMol,
                                                         TAtmN, OutText,
                                                        &TCh,&TXc,&TYc,&TZc);

         TRs2 = TRs1;

         j = PutResNum1(TRs1 , i);
         j = PutResNum2(TRs2 , i);

         j = PutResName(TResN , i);

          if(TAtmN[0] == '-') {
              j = PutAtmName(OutText, i);}
          else {
              j = PutAtmName(TAtmN, i);}

         j = PutXCoord(TXc , i);
          j = PutYCoord(TYc , i);
           j = PutZCoord(TZc , i);


         j = PutSegName(TSegN , i);

         j = PutBValue(TBv , i);
         j = PutAtmCharge( TCh , i);

         i++;
         numat++;

        if(i == MAXatom) {
        PrintMessage("?ERROR - max atoms reached");
        return(1);}

      }
    }

      update_mlist(numat);
 
      PrintMessage("**********   Done   **********");
    
     return(0);
 }
