/*  

                       Copyright (c) 1990, 1993 by:
        Leif Laaksonen , Center for Scientific Computing, ESPOO, FINLAND
            Confidential unpublished property of Leif Laaksonen
                        All rights reserved
  

*/
 
 
/*
   This program reads a GROMOS coordinate file
 
   Leif Laaksonen 1993
*/
 
#include <stdio.h>
#include <math.h>
#include <string.h>

#include "maxdefs.h"

#if defined(USEFORMS) && defined(sgi)
#include "../forms/FORMS/forms.h"
#endif

#define GROMOS_LINE_LEN   132   /* gromos file line length */
 
extern int numat;
extern char input_file[BUFF_LEN];
extern int indexo();
     extern int mlist_deep;      /* stack number indicator */
     extern int mlists[MAX_MLIST]; /* First index for molecule list */
     extern int mliste[MAX_MLIST]; /* Second index for molecule list */
     extern char mnlist[MAX_MLIST][BUFF_LEN]; 
                                /* name list for molecule file names */
 
     extern void send_command();
     extern void PrintMessage();
     extern void dialog4();

extern int PutSegName();
extern int PutResName();
extern int PutAtmName();
extern int PutResNum1();
extern int PutResNum2();
extern int PutXCoord();
extern int PutYCoord();
extern int PutZCoord();
extern int PutBValue();
extern int PutAtmCharge();

/*************************************************************************/
pre_read_gromos()  /* pre routine for reading a gromos file */
 
/*************************************************************************/
{
 
    extern char *bottom_line;
    char text[BUFF_LEN];
    char Cline[BUFF_LEN];
    int ret_val;

#ifdef sgi
 
#ifdef USEFORMS 
#ifdef sgi
  { char *fname;
  fname = fl_show_file_selector("Give name of GROMOS file:  ","","","");
  if(fname == NULL) 
    text[0] = '\0';
      else
      strncpy(text,fname,BUFF_LEN);}
#endif
#else
    dialog4("Reading GROMOS file.","Give name of GROMOS file:  ",text);
#endif
     if(text[0] == '\0') return;
    strncpy(input_file,text,BUFF_LEN);
      strncpy(Cline,"read coord gromos ",BUFF_LEN);
       strncat(Cline,text,(BUFF_LEN - strlen(Cline)));
    strncpy(bottom_line,"Reading GROMOS file ...",PORTchar);
    going_on();
    send_command(Cline);
    return; 
#else

    printf("?ERROR - not implemented on this device \n");

#endif

}
 
/*************************************************************************/
int read_gromos(inp_file)
/*************************************************************************/
    char *inp_file;
{
 

   int   TRs1,TRs2;
   float TXc,TYc,TZc,TBv;
   char  TResN[BUFF_LEN];
   char  TAtmN[BUFF_LEN];
   char  TSegN[BUFF_LEN];

 
char input[GROMOS_LINE_LEN];
char temp[GROMOS_LINE_LEN];
int i,j,k;
char OutText[BUFF_LEN];
 
FILE *gromos_in;
 
      gromos_in=fopen(inp_file,"r");
       if(gromos_in == NULL) {
        sprintf(OutText,"Can't open input file : %s",inp_file);
        PrintMessage(OutText);
        return(1);
      }
 
      TRs1 = 1;
      TRs2 = 1;
      TBv  = 0.0;

      sprintf(OutText,"********** Reading : %s **********",input_file);
      PrintMessage(OutText);
/*
      Start reading file
 
*/
/* Title card */
 
       fgets(input,GROMOS_LINE_LEN,gromos_in);
        PrintMessage(input);

/* number of atoms card */

       fgets(input,GROMOS_LINE_LEN,gromos_in);
       sscanf(input,"%d",&numat);
       if(numat < 1) {
         PrintMessage("?ERROR - not an acceptable number of atoms");
       return(1);}

/* it's possible to already update now */

       update_mlist(numat);

/* Coordinates card */
 
      for(i = mlists[mlist_deep - 1] ; i < mliste[mlist_deep - 1] ; i++ ) {
       fgets(input,GROMOS_LINE_LEN,gromos_in);
         sscanf(input," %d ",&TRs1);

         TRs2 = TRs1;

         j = PutResNum1(TRs1 , i);
         j = PutResNum2(TRs2 , i);

      j = PutResName((input+5) , i);
          if(isalpha(input[10])) {
             sprintf(OutText,"Atom nr: %d , '%.5s' will be truncated to '%.4s'",
             (i+1),input+10);
             PrintMessage(OutText);
             j = PutAtmName((input+10) , i);}
          else
             j = PutAtmName((input+11) , i);

         sscanf(input+20,"%f %f %f", &TXc ,&TYc ,&TZc );

         TXc *= 10.;
          TYc *= 10.;
           TZc *= 10.;

         j = PutXCoord(TXc , i);
          j = PutYCoord(TYc , i);
           j = PutZCoord(TZc , i);


/* add dummies */
         j = PutSegName("GROM" , i);

         j = PutBValue(TBv , i);
         j = PutAtmCharge( 0.0 , i);
     }
 
      PrintMessage("**********   Done   **********");
    
     return(0);
 }
