/*  

                       Copyright (c) 1990 by:
        Leif Laaksonen , Center for Scientific Computing, ESPOO, FINLAND
            Confidential unpublished property of Leif Laaksonen
                        All rights reserved
  

*/

/*
  FORTRAN code in GAMESS to produce the MOLPLT information

C*MODULE INPUT   *DECK MOLPLT
      SUBROUTINE MOLPLT(IZMAT,IPAIRS,KINDS)
C
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
C
      DIMENSION IZMAT(*),IPAIRS(2,*),KINDS(*)
C
      PARAMETER (MXATM=50, MXAO=2047)
C
      CHARACTER*4 ATMSYM(MXATM),SKINDS(MXATM)
C
      COMMON /ECP2  / CLP(400),ZLP(400),NLP(400),KFIRST(MXATM,6),
     *                KLAST(MXATM,6),LMAX(MXATM),LPSKIP(MXATM),
     *                IZCORE(MXATM)
      COMMON /INFOA / NAT,ICH,MUL,NUM,NX,NE,NA,NB,ZAN(MXATM),C(3,MXATM)
      COMMON /IOFILE/ IR,IW,IP,IS,IPK,IDAF,NAV,IODA(99)
      COMMON /RUNLAB/ TITLE(10),ANAM(MXATM),BNAM(MXATM),BFLAB(MXAO)
      COMMON /RUNOPT/ RUNTYP,EXETYP,NEVALS
C
      DATA HESS/8HHESSIAN /
      DATA UNIT/0.52917724924D+00/
C
C     ----- PUNCH AN INPUT FILE FOR THE -MOLPLT- PROGRAM -----
C
      WRITE(IW,9000)
      WRITE(IP,8000)
      CALL SETLAB(2,ATMSYM)
      NBONDS = 0
      IF(RUNTYP.NE.HESS) CALL GTBOND(IZMAT,IPAIRS,NBONDS,0)
C
      NKINDS=1
      KINDS(1) = ZAN(1) + IZCORE(1)
      SKINDS(1) = ATMSYM(1)
      DO 120 IAT=2,NAT
         NUCZ = ZAN(IAT) + IZCORE(IAT)
         MATCH=0
         DO 110 I=1,NKINDS
            IF(NUCZ.EQ.KINDS(I)) MATCH=MATCH+1
  110    CONTINUE
         IF(MATCH.EQ.0) THEN
            NKINDS = NKINDS+1
            KINDS(NKINDS) = NUCZ
            SKINDS(NKINDS) = ATMSYM(IAT)
         END IF
  120 CONTINUE
C
C     ----- OPTIONS CARD -----
C
      WRITE(IP,8010) NAT,NKINDS,NBONDS,TITLE
C
C     ----- PUNCH ATOMIC SYMBOL, KOLOR, SIZE -----
C     THE BALL SIZES ARE DETERMINED BY PLAYING WITH THE RADIAL
C     EXPECTATION VALUES OF THE HIGHEST AO IN C,SI,GE,SN,PB.
C
      CARBON = 0.3
      DO 210 I=1,NKINDS
         NUCZ = KINDS(I)
                        SIZE=0.75* CARBON
         IF(NUCZ.GT. 2) SIZE=      CARBON
         IF(NUCZ.GT.10) SIZE=1.6 * CARBON
         IF(NUCZ.GT.18) SIZE=1.7 * CARBON
         IF(NUCZ.GT.36) SIZE=1.9 * CARBON
         IF(NUCZ.GT.54) SIZE=2.0 * CARBON
         IF(NUCZ.GT.86) SIZE=2.1 * CARBON
         WRITE(IP,8020) SKINDS(I),SIZE
  210 CONTINUE
C
C     ----- PUNCH ATOMIC COORDINATES IN ANGSTROMS -----
C
      DO 310 IAT=1,NAT
         X = UNIT * C(1,IAT)
         Y = UNIT * C(2,IAT)
         Z = UNIT * C(3,IAT)
         WRITE(IP,8030) ATMSYM(IAT),X,Y,Z
  310 CONTINUE
C
C     ----- PUNCH BONDED ATOM LIST -----
C
      IF(NBONDS.GT.0) CALL GTBOND(IZMAT,IPAIRS,NBONDS,IP)
      WRITE(IP,8040)
      RETURN
C
 8000 FORMAT('-------- START OF -MOLPLT- INPUT FILE ----------')
 8010 FORMAT('NATOMS=',I4,'   NKINDS=',I4,'    NBONDS=',I4/10A8)
 8020 FORMAT(A4,'  1  ',F5.2)
 8030 FORMAT(A4,3F12.6)
 8040 FORMAT('-------- END OF -MOLPLT- INPUT FILE ----------')
 9000 FORMAT(1X,'AN INPUT FILE FOR -MOLPLT- HAS BEEN PUNCHED.')
      END
*/

/*
   This program reads a GAMESS MOLPLT coordinate file

   Leif Laaksonen 1990
*/

#include <stdio.h>
#include <math.h>
#include <string.h>
#include <ctype.h>

#include "maxdefs.h"

#define GAMESS_LINE_LEN   132   /* gamess file line length */

extern void send_command();
extern char input_file[BUFF_LEN];
     extern int mlist_deep;      /* stack number indicator */
     extern int mlists[MAX_MLIST]; /* First index for molecule list */
     extern int mliste[MAX_MLIST]; /* Second index for molecule list */
     extern char mnlist[MAX_MLIST][BUFF_LEN]; 
                                /* name list for molecule file names */

extern int indexo();
extern void PrintMessage();
extern void dialog4();


/*************************************************************************/
pre_read_gamess(alt)  /* pre routine for reading a gamess file */

    int alt;
/*************************************************************************/
{
    extern char *bottom_line;
    extern int MAXatom;
    char text[BUFF_LEN];
    char Cline[BUFF_LEN];
    int ret_val;

#ifdef sgi
    switch(alt) {

    case 0:
    dialog4("Reading GAMESS output file","Give name of GAMESS file:  ",text);
     if(text[0] == '\0') return;
    strncpy(input_file,text,BUFF_LEN);
      strncpy(Cline,"read coord gamess ",BUFF_LEN);
       strncat(Cline,text,(BUFF_LEN - strlen(Cline)));
    strncpy(bottom_line,"Reading gamess file...",PORTchar);
    going_on();
    send_command(Cline);
    break;

    case 1:
    strcpy(text,input_file);
    break;}

    ret_val = read_gamess(text);
    if(ret_val) return;
    do_util();
#else

    printf("?ERROR - not implemented on this device \n");

#endif

}

/*************************************************************************/
int read_gamess(inp_file)  /* GAMESS MOLPLT file reader */
/*************************************************************************/
    char inp_file[];
{

/*  externals                                      */
   extern int numat,*res1,*res2;
   extern float *x,*y,*z,*bvalue;
   extern char  *resnam,*atnam,*segment;
   extern int MAXatom;
/*                                                 */

  char inputl[GAMESS_LINE_LEN];   /* input line */
  char text[BUFF_LEN];
  char OutText[BUFF_LEN];
  int i,j,k,natoms,nkinds,nbonds;


FILE *gamess_in;

      gamess_in=fopen(inp_file,"r");
       if(gamess_in == NULL) {
        sprintf(OutText,"Can't open input file : %s",inp_file);
        PrintMessage(OutText);
        return(1);
       }

      sprintf(OutText,"********** Reading : %s **********",input_file);
      PrintMessage(OutText);

       numat = 0 ; /* start counting number of atoms */
       if(mlist_deep == 0) 
        i = 0;
         else
          i = mlists[mlist_deep - 1];

       while(fgets(inputl,GAMESS_LINE_LEN,gamess_in) != NULL) { 

/* MOLPLT card */
        if(indexo(inputl,"-MOLPLT-") > 0) { /* Found the first card */
          printf("**** Found '-MOLPLT-' card \n");

       fgets(inputl,GAMESS_LINE_LEN,gamess_in);
       sscanf(inputl,"%*s %d %*s %d %*s %d",&natoms,&nkinds,&nbonds);
       sprintf(OutText,"Natoms: %d , nkinds: %d , nbonds: %d",natoms,nkinds,nbonds);
       PrintMessage(OutText);

          fgets(inputl,GAMESS_LINE_LEN,gamess_in);
          sprintf(OutText,"Title:\n%s",inputl);
          PrintMessage(OutText);

          for(j = 0 ; j < nkinds ; j++)
             fgets(inputl,GAMESS_LINE_LEN,gamess_in);

          for(j = 0 ; j < natoms ; j++) {
             fgets(inputl,GAMESS_LINE_LEN,gamess_in);
              sscanf(inputl,"%s %f %f %f",text,&x[i],&y[i],&z[i]);
               strncpy(atnam+4*i,text,4);
                strncpy(segment+4*i,"GMS",3);
                strncpy(resnam+4*i,"GMS",3);
               res1[i] = 1;
              res2[i] = 1;
             i++;}
           numat = natoms;

        if((i + natoms) >= MAXatom) {
        PrintMessage("?ERROR - max atoms reached \n");
        return(1);}

        break;
	}
       }
       update_mlist(numat);

      PrintMessage("**********   Done   **********");

     return(0);

}

