
/*

     Routine to scan the residue names and make a list of them
     to be used for CHARMm input 

     Leif Laaksonen 1990

*/

#include <stdio.h>
#include <math.h>
#include <string.h>
#include <malloc.h>

#include "maxdefs.h"

   extern int current_struct;    /* current structure number */
     extern int mlist_deep;      /* stack number indicator */
     extern int mlists[MAX_MLIST]; /* First index for molecule list */
     extern int mliste[MAX_MLIST]; /* Second index for molecule list */
     extern char mnlist[MAX_MLIST][BUFF_LEN]; 
                                /* name list for molecule file names */
      extern int numat;  /* number of atoms */
      extern int *res1;  /* residue numbers */
      extern char *segment; /* segment name */
      extern char *resnam;  /* residue name */
      extern char *atnam;   /* atom name    */

/***********************************************************************/
sort_resi()
/***********************************************************************/
{
      int i,prev;
      int diff_res;        /* number of residues */
      char *diff_res_nam;  /* names of the residues (only 4 characters) */
      

      if(numat < 1) return;  /* no atoms */

/* first residue */

      diff_res_nam = (char *) malloc( 4 * sizeof(char));
       strncpy(diff_res_nam,resnam+4*mlists[current_struct],4);
        prev = res1[mlists[current_struct]];
         diff_res = 1;

      for(i = mlists[current_struct] + 1 ; i < mliste[current_struct] ; i++) {

       if(res1[i] == prev) continue; /* same residue */

       /* new residue */

       diff_res_nam = (char *) realloc((char *) diff_res_nam , 
                      (diff_res + 1) * sizeof(char)); /* space taken */
       strncpy(diff_res_nam+4*diff_res,resnam+4*i,4);

       diff_res++;
       prev = res1[i];
     }
}
 
       
