/*  

                       Copyright (c) 1990 by:
        Leif Laaksonen , VTT/Biotechnical laboratory, ESPOO, FINLAND
            Confidential unpublished property of Leif Laaksonen
                        All rights reserved
  

*/


#include <stdio.h>

#include "maxdefs.h"

/***************************************************************************/
int read_start(start_file)
     char *start_file;               /* name of the START file to be read */
/***************************************************************************/
{
/*  externals       */
 extern char input_file[BUFF_LEN];
 extern char traj_file[BUFF_LEN];
 extern int input_file_set;
 extern traj_file_set;
 extern char scr_data[BUFF_LEN];

     int i,j,k;
     int print_input;
     char input[MAXlinel],parsed[MAXparse][MAXlinel];
     char text[MAXlinel];
     FILE *own_p;
     
     print_input=0;
     own_p=fopen(start_file,"r");
     if(own_p==NULL) {
     printf("    Can't open startup file: %s - starting without it \n",start_file);
     return (1); }

/*   We are ready now to start reading.
     First line is a comment line. 
*/

#ifdef DEBUG
     printf("Reading start file: %s ...",start_file);
#endif

/* 1 line */
     fgets(input,MAXlinel,own_p);   /*  */

/*  read rest of the file (main loop)    */
     i=0;
     while(fgets(input,MAXlinel,own_p) != NULL) {
     if(print_input > 0) print_line(input);

     k=0;                         /* k before parsing */
     parsing(input,parsed,&k," ");

     tupper(parsed[0]);   /*  switch to upper case letters   */

/*   The following subcommands are recogniced:

     MOLFILE       Name of molecule file(s) 

     DYNFILE       Name of dynamics file(s)

     END           This subcommand terminates all input definitions.

*/
     if(k >= 0) {

/*   MOLFILE  card                 */

     if( indexo(parsed[0],"MOLFILE") == 1)  {
     sscanf(input,"%s %s %d",text,input_file,&input_file_set);
     continue;}

/*   DYNFILE card                  */

     if( indexo(parsed[0],"DYNFILE") == 1) {
     sscanf(input,"%s %s %d",text,traj_file,&traj_file_set);
     continue;}

/*   PRINT card                 */

     if( indexo(parsed[0],"PRINT") == 1) {
     print_input=1;continue;}
     
/*   END card                   */

     if( indexo(parsed[0],"END") == 1 ) {
     fclose(own_p);

#ifdef DEBUG
     printf(" done\n");
#endif

     return (0) ;}                        /*  return now ...  */
     }
   }
}

