/*  

                       Copyright (c) 1990,1992 by:
        Leif Laaksonen , Centre for Scientific Computing, ESPOO, FINLAND
            Confidential unpublished property of Leif Laaksonen
                        All rights reserved
  

*/

#include <stdio.h>
#include <string.h>
#include <math.h>
#include <ctype.h>

#include "maxdefs.h"

#define MAX(a,b)  ( ( a ) > (b) ? (a) : (b))
#define MIN(a,b)  ( ( a ) < (b) ? (a) : (b))
#define Rabs(a)    ( ( a ) > 0 ? (a) : -(a))

     extern void PrintMessage();
     extern char scr_data[];
     extern FILE *RetFilePoint();

     int force_types=0;     
     struct ftype {
     char resnam[4];
     char atnam[4];
     int  type;
     float charge;};

/*  debug structure */
    extern struct {
    int DebugL;} DebugS;

     struct ftype force[MAXft];

/***********************************************************************/
int read_type(type_file)
     char *type_file;               /* name of the type file to be read */
/***********************************************************************/
{

/*  externals    */
    extern char parsed[MAXparse][MAXlinel];

/*               */

     int  i,j,k,lines=0;
     char input[MAXlinel];
     char text[MAXlinel];
     char chelp[BUFF_LEN];
     char OutText[BUFF_LEN];
     FILE *par_p;

     par_p = RetFilePoint(type_file);

     if(!par_p) {
       sprintf(OutText,"?ERROR - con't open dictionary file: '%s'",type_file);
        PrintMessage(OutText);
         return(1);}

/*   We are ready now to start reading.
     First line HAS to start with a "*". After that it is free to have or
     have not a coment. Last line has to be just a "*"  */

     sprintf(OutText,"Reading dictionary file: %s ...",type_file);
     PrintMessage(OutText);

/* 1 line */
     fgets(input,MAXlinel,par_p);   /*    read first line and check for "*" */
     if(input[0] != '*') {
     sprintf(OutText,"\n>>>>>> First line in a dictionary file has to start with a '*'-sign <<<<<<");
     PrintMessage(OutText);
     fclose(par_p);
     return (1); }

/*  read rest of the file (main loop)    */
     i=0;
     while(fgets(input,MAXlinel,par_p) != NULL) {

/*
     tupper(input); */  /*  switch to upper case letters   */

     j = own_parser(input,parsed,&k,SEP_STRING);

     strncpy(force[i].resnam,parsed[0],MAX_RES_NAME_LEN);
     strncpy(force[i].atnam,parsed[1],MAX_ATM_NAME_LEN);
     force[i].type = atoi(parsed[2]);
     force[i].charge = atof(parsed[3]);
     ++i; 
     if(i > MAXft) {
     PrintMessage(">>>>>>> MAXft reached in read_type <<<<<<<");
     force_types = 0;
     return (1);}}

     force_types = i;
     fclose(par_p);

     if(DebugS.DebugL) {
       sprintf(OutText,"Number of atom types defined : %d",force_types);
       PrintMessage(OutText);
     }
     return (0);
}

