/*  

                       Copyright (c) 1990, 1992 by:
        Leif Laaksonen , Centre for Scientific Computing, ESPOO, FINLAND
            Confidential unpublished property of Leif Laaksonen
                        All rights reserved
  

*/

#include <stdio.h>
#include <string.h>
#include <math.h>
#include <malloc.h>
#ifdef sgi
#include <gl.h>
#endif
#include "maxdefs.h"

#define Clean_Up()       { if(graf_dist_list.num > 0) \
                            free(graf_dist_list.list); \
                            graf_dist_list.num = 0; \
                            calc_neigh = 0;\
                            if(atm_force.set != 0) {\
                                free(atm_force.fx);\
                                 free(atm_force.fy);\
                                  free(atm_force.fz);\
                                   atm_force.plot = 0;\
                                   atm_force.set  = 0;}\
                            scale_plot.plot_color_scale = 0;\
                            scale_plot.which_plot       = 0;\
                            charge_color.set = 0;\
                            (void)UpdateAllOpenWindows();\
                           if(!is_it_frame) {\
                            traj_file_set = 0;\
                            traj_file[0] = '\0';\
                            (void)DeleteTrajectoryInfo();\
                             DENSITY_limits.set = 0;\
                             PROBE_limits.set   = 0;\
                             VSS_limits.set     = 0;\
                             StereoPlot.Active = 0;\
                             StereoPlot.Set    = 0;\
                             if(ContoursDefined)\
                               (void)DeleteContoursAll();\
                               (void)ResetRealStereoParams();\
                               (void)DelManSelectionList();\
                               (void)TurnOFFObjPlot();\
                            energy_file[0] = '\0';}\
                            if(trace_info.trace_on == 1 && !is_it_frame) {\
                            free((char *)trace_info.trx);\
                             free((char *)trace_info.try);\
                              free((char *)trace_info.trz);\
                               free((char *)trace_info.trace_list);\
                                free((char *)trace_info.trace_atoms);\
                            trace_info.trace_on = 0;\
                            trace_wind = 0;\
                            is_it_frame = 0;}}
#if defined(USEFORMS) && defined(sgi)
extern char  *ShowForm4();
#endif

extern int DeleteContoursAll();
extern float *vector();
extern int get_frame();
extern int DeleteContour();
extern int read_charmm_force();
extern void PrintMessage();
extern void iso_release_memory();
extern void going_on();
extern void MakeOrtho();
extern int  ShowTextInput(); 
extern void send_command();
extern int check_if_file_exist();
extern int DeleteTrajectoryInfo();
extern int read_gromos();
extern int read_amber();
extern int read_coord_sock();
extern int    CalcCluster();
extern int    DeleteClusterData();
extern int    GetClusterSpace();
extern int    PutClusterData();
extern int    ResetRealStereoParams();
extern int    DelManSelectionList();
extern int    TurnOFFObjPlot();

     extern float near;
     extern float far;
     extern int dic_read;
     extern int term_type;
     extern float rotB[][4];
     extern int current_struct;  /* current molecule number */
     extern char energy_file[];
     extern float damp;
     extern int alpha_trace;
     extern int colour_structure_by;
     extern char *bottom_line;
     extern int mlist_deep;      /* stack number indicator */
     extern int mlists[MAX_MLIST]; /* First index for molecule list */
     extern int mliste[MAX_MLIST]; /* Second index for molecule list */
     extern char mnlist[MAX_MLIST][BUFF_LEN]; 
                                /* name list for molecule file names */
     extern char parsed[MAXparse][MAXlinel];

/* structur containing pointers to dynamics display variables */
    extern struct dyna_disp_var {
      int numset;             /* number of sets (or variables) */
      int current_set;        /* index to current set          */
      int point_len;          /* length of point array         */
      int *point_vec;         /* pointer to point array        */
      int dist_len;           /* length of dist array          */
      int *dist_vec;          /* pointer to dist array         */
      int ang_len;            /* length of angle array         */
      int *ang_vec;           /* pointer to angle array        */
      int tors_len;           /* length of torsion array       */
      int *tors_vec;          /* pointer to torsion array      */
      int obs_vec_len;        /* observation array length      */
      int obs_vec_curr;       /* display current               */
      float *obs_vec;};       /* pointer to observation array  */

    extern struct dyna_disp_var play_dynam_frames;

    extern struct flush_dist_list {
     int num;
     int *list;};

    extern struct flush_dist_list graf_dist_list;

    extern int calc_neigh;   /* = 0 no calculation , > 0 calculation */

    extern float idmat[4][4];

/* pointers for force calculation */

     extern struct force_struct {
     int    set;  /* switch if the forces are set = 0 , not != 0, yes */
     int   plot;  /* switch for a plot = 0 , no plot , != 0 a plot */
     float  *fx;  /* pointers to the forces */
     float  *fy;
     float  *fz;
     int *sel_list; /* selection list */
     int  ent_list; /* entries in the selection list */
     float scale; /* scale factor */
     int   maxfi; /* index of max force atom */
     float maxfa; /* value of the max force  */
     int   minfi; /* index on min force atom */
     float minfa; /* value of the min force  */ } atm_force; 

    extern struct {
     int plot_color_scale; /* = 0 , off , != 0 on */
     int which_plot;       /* = 0 no plot,
                                1 force plot,
                                2 energy scale
                           */
     int num_level; } scale_plot;

     extern struct {
       int set;          /* = 0 , colouring not set , > 0 colouring set */
       float max;
       float min;}   charge_color;

/* structure to hold the trace of atoms       */

   extern struct {
   int trace_on;        /* switch to indicate that a trace is saved (=1)   */
   int trace_sets;      /* number of trace sets                            */
   int trace_step;      /* step length                                     */
   int *trace_atoms;    /* number of traced atoms in each set              */
   int *trace_list;     /* list of atoms to be traced                      */
   float *trx;          /* array to contain the x coordinates of the trace */
   float *try;
   float *trz;} trace_info;

   extern int trace_wind; /* = 0 no display , = 1 display on */

/* contour structure */
     extern int ContoursDefined;

     extern struct Contour_Struct {
     float *data;           /* contour data */
     float min;
     float max;
     int xdim;
     int ydim;
     int zdim;
     float Xtrans;
     float Ytrans;
     float Ztrans;
     float Xscale;
     float Yscale;
     float Zscale;
     float ColVal[MAX_CONT];
     int   NumVal;
     char  ColNam[MAX_CONT][BUFF_LEN];
     char  ContFile[BUFF_LEN];
     float AlphaBlend;
     int   ContSmooth;
     char  Name[BUFF_LEN];
     int   Display;} ContourInfo[MAX_CONTOURS];

     extern struct {                /* structure to handle error situations */
     int ERRORcode;} Problems;

    extern struct SURF_LIM {
    int set;             /* = 0 , not set , > 0 set */
    float Xmin;
    float Xmax;
    float Ymin;
    float Ymax;
    float Zmin;
    float Zmax;
    char  MeshFile[BUFF_LEN];
    char  WFFile[BUFF_LEN];
    float ProbeVal;
    int Orbital;
    int Dmethod;
    int Xpts;
    int Ypts;
    int Zpts;
                   } DENSITY_limits , PROBE_limits , VSS_limits;

/*  debug structure */
    extern struct {
    int DebugL;} DebugS;

    extern char *GetResName();
    extern char *GetAtmName();

     struct QMenergy {
     int ndim;              /* dimension of Fock matrix */
     int Nocc;              /* number of occupied orbitals */
     int numat;             /* number of atoms in the system */
     float *Energy;         /* orbital energy pointer   */
     float *Occ;            /* orbital occupation pointer */
     int    NPDens;         /* number of points in the density of states */
     float *DensState;      /* density of states pointer  */
     float *Pcharge;        /* atom partial charges  */
                      } QMstat;

       extern struct {
         float Angle;       /* rotation angle */
         float Translate;   /* translation from the centre */
         int   Active;      /* == 0 off , != 0 on */
         int   Set;         /* == 0 reset , != do not reset */
                  } StereoPlot;

       extern struct {
	         int CalcConn; 
                 /* if != 0 connectivity is calculated for each frame */
	       } Connect;

    extern struct {
       int NumSets;
       float *DataArray;
     } ClusterData;

    struct {                 /* coordinate manipulation at read coordinates */
     int AtomCent;
           } CoordMani = { 0 };

    int NumStructLists();
    int DelNumStructLists();
    int StartIndexStructList();
    int ReadClusterData();
    int AddNames();

#ifndef OPENMOL
  struct MOL_STRUCT_DATA {
  char   AtomicSymbol[BUFF_LEN];
  char   AtomicLabel[BUFF_LEN];
  char   GBasisSetTag[BUFF_LEN];
  float  ChargeCenter;
  float  XCoord;
  float  YCoord;
  float  ZCoord;
                  } *MolStructData;
#endif

/************************************************************************/
read_fac(input,num)   /* interpret the read command */
   char *input; 
   int num;
/************************************************************************/
{

     extern FILE *charmm_oc;
     extern int **atmcol;
     extern int numat;
     extern char traj_file[BUFF_LEN];
     extern int traj_file_set;
     extern int dynamics_frames;
     extern int dynamics_pasback[20];
     extern float *x;
     extern float *y;
     extern float *z;
     extern float sumx,sumy,sumz;
     extern int dic_read;
     extern char dic_file[BUFF_LEN];

     int i,j;
     int ret_val;
     int ihelp;
     float fhelp;
     int iappend;
     char chelp[MAXlinel];
     char OutText[BUFF_LEN];
     int is_it_frame;

   toller(parsed[1]);

/* read help                                  */
   if(indexo(parsed[1],"?")  == 1) {
   PrintMessage("****** read commands ******");
   PrintMessage("read coor*dinates ambe*r   file.name [appe*nd] ! Read an AMBER coordinate file");
   PrintMessage("                  char*mm  file.name [appe*nd] ! Read a CHARMM coordinate file ");
   PrintMessage("                  free     file.name [appe*nd] ! Read a file in 'free format'");
   PrintMessage("                  game*ss  file.name [appe*nd] ! Read a GAMESS MOLPLT file ");
   PrintMessage("                  grom*os  file.name [appe*nd] ! Read a GROMOS coordinate file ");
   PrintMessage("                  hype*r   file.name [appe*nd] ! Read a HypeChem HIN file");
   PrintMessage("                  insi*ght file.name [appe*nd] ! Read an INSIGHT coordinate file ");
   PrintMessage("                  mopa*c   file.name [appe*nd] ! Read Mopac graphics file ");
   PrintMessage("                  mumo*d   file.name [appe*nd] ! Read MUMOD input file");
   PrintMessage("                  pdb      file.name [appe*nd] ! Read a PDB coordinate file ");
   PrintMessage("                  yasp     file.name [appe*nd] ! Read yasp coordinate file ");
   PrintMessage("     clus*ter data file.name      ! Read cluster data from file");
   PrintMessage("     colo*ourtable file.name      ! Read a colour table file");
   PrintMessage("     dict*ionary file.name        ! Read atom dictionary file ");
   PrintMessage("     dyna*mics fram*e inr [appe*nd]!Read frame nr inr from dynamics file");
   PrintMessage("     text                         ! Read text to be displayed ");
   PrintMessage("    -text                         ! Delete text stack "); 
   PrintMessage("     forc*e file.name             ! Read atom forces ");
   PrintMessage("    -forc*e                       ! Delete force vectors ");
   return;}

   is_it_frame = 0;  /* no it is not */

#if defined(USEFORMS) && defined(sgi)
   if(parsed[1][0] == '\0' && term_type == 1) {
     { char *TempRead;
     if((TempRead = ShowForm4()) != NULL ) 
         send_command(TempRead);
         return;
     }}
#endif

/* read text                                  */
     if(indexo(parsed[1],"text") == 1 || indexo(parsed[1],"text") == 2) {
       if(parsed[1][0] == '-')
         read_txt(0); /* kill stack */
       else
         read_txt(1); /* add text */
       return;}

   if(num < 3)  {
   sprintf(OutText,"?ERROR - incomplete read command - : %s",input);
   PrintMessage(OutText);
   return;}


/* read CHARMM file                           */  

   if((indexo(parsed[1],"karp") == 1) || (indexo(parsed[1],"char") == 1) ) {

   if(ReadCoordinates(CHARMM_COORD , parsed[2] , parsed[3])) {
      PrintMessage("?ERROR - can't read CHARMM coordinates");}

   return;}

/* read PDB file                              */

   else if(indexo(parsed[1],"pdb") == 1) {

   if(ReadCoordinates(PDB_COORD , parsed[2] , parsed[3])) {
      PrintMessage("?ERROR - can't read PDB coordinates");}

   return;}

/* read INSIGHT file                              */

   else if(indexo(parsed[1],"insi") == 1) {

   if(ReadCoordinates(INSIGHT_COORD , parsed[2] , parsed[3])) {
      PrintMessage("?ERROR - can't read INSIGHT coordinates");}

   return;}

/* read GAMESS MOLPLT file                              */

   else if(indexo(parsed[1],"game") == 1) {

   if(ReadCoordinates(GAMESS_COORD , parsed[2] , parsed[3])) {
      PrintMessage("?ERROR - can't read GAMESS coordinates");}

   return;}

/* read FREE file                              */

   else if(indexo(parsed[1],"free") == 1) {

   if(ReadCoordinates(FREE_COORD , parsed[2] , parsed[3])) {
      PrintMessage("?ERROR - can't read FREE coordinates");}

   return;}

/* read MOPAC graphics file for the coordinates           */

   else if(indexo(parsed[1],"mopa") == 1) {

   if(ReadCoordinates(MOPAC_COORD , parsed[2] , parsed[3])) {
      PrintMessage("?ERROR - can't read MOPAC coordinates");}

   return;}

/* read atom force file                            */
    else if(indexo(parsed[1],"forc") == 1) {

/* check that file exist */
     if((ret_val = check_if_file_exist(parsed[2])) < 0) {
     check_if_fatal(ret_val);
     return;}

      ret_val = read_charmm_force(parsed[2]);
      if(ret_val > 0) {
        PrintMessage("?ERROR - problems reading force file \n");
        return;}
      return;}

/* delete force vectors                            */
     else if(indexo(parsed[1],"-for") == 1) {
       if(atm_force.set == 0) {
         PrintMessage("?ERROR - force vectors not defined\n");
         return;}
      if(atm_force.ent_list) {
        free(atm_force.sel_list);
        atm_force.ent_list = 0;}
      atm_force.plot = 0;
      atm_force.set  = 0;
      free(atm_force.fx);
      free(atm_force.fy);
      free(atm_force.fz);
      }

/* read dictionary file                            */
    else if(indexo(parsed[1],"dict") == 1) {
      if(numat < 1) {
      PrintMessage("?ERROR - can't read the dictionary parameters because no atoms defined \n");
       return;}
    if(num < 3 || parsed[2][0] == '\0') {
    PrintMessage("?ERROR - file name missing \n");
    return;}

/* check that file exist 
     if((ret_val = check_if_file_exist(parsed[2])) < 0) {
     check_if_fatal(ret_val);
     return;}
*/

    strncpy(dic_file,parsed[2],MAXlinel);
    ret_val = read_type(parsed[2]);
    if(ret_val) {
    sprintf(OutText,"?ERROR - unable to open dictionary file: '%s' \n",dic_file);
    PrintMessage(OutText);
    check_if_fatal(ret_val);
    return;}
    ret_val = set_type();
    dic_read = 1;        /* dictionary/atom types read */
    cal_moment();
    return;}

/* read a colour table file                            */
    else if(indexo(parsed[1],"colo") == 1) {
     if(num < 3 || parsed[2][0] == '\0') {
      PrintMessage("?ERROR - file name missing \n");
       return;}

/* check that file exist */
     if((ret_val = check_if_file_exist(parsed[2])) < 0) {
     check_if_fatal(ret_val);
     return;}

    ret_val = read_col_tbl(parsed[2]);
      if(ret_val) {
       sprintf(OutText,
        "?ERROR - unable to open colour table file: '%s' \n",parsed[2]);
         PrintMessage(OutText);
          check_if_fatal(ret_val);
           return;}
    return;}

/* read yasp file */

   else if(indexo(parsed[1],"yasp") == 1) {

   if(ReadCoordinates(YASP_COORD , parsed[2] , parsed[3])) {
      PrintMessage("?ERROR - can't read YASP coordinates");}

   return;}

/* read dynamics frame                        */
    else if(indexo(parsed[1],"dyna") == 1) {
        toller(parsed[2]);
        if(indexo(parsed[2],"fram") == 1) {
        if(dynamics_frames < 1) {
        PrintMessage("?ERROR - number of frames is not defined \n");
        return;}
        sprintf(OutText,"Total number of frames is: %d\n",dynamics_frames);
        PrintMessage(OutText);
        if(traj_file_set == 0) {
        PrintMessage("?ERROR - no trajectory file name set \n");
        return;}
        charmm_oc = fopen(traj_file,"r");
        if(charmm_oc == NULL) {
        sprintf(OutText,"?ERROR - can't open trajectory file : %s\n",traj_file);
        PrintMessage(OutText);
         ret_val = 1;
         check_if_fatal(ret_val);
        return;}
        ihelp = atoi(parsed[3]);
          if(ihelp < 1) {
          PrintMessage("?ERROR - frame number supplied was < 1 , it is put = 1 \n");
          ihelp = 1;}
          if(ihelp > dynamics_frames) {
          sprintf(OutText,"?ERROR - frame number supplied was > max frames, it is put = %d \n",dynamics_frames);
          PrintMessage(OutText);
          ihelp = dynamics_frames;}

          is_it_frame = 1;    /* yes it is */
/* check if it should be appended */
        toller(parsed[4]);
        iappend = 0;
     if(indexo(parsed[4],"appe") == 1) {
        iappend = 1;
        if(mlist_deep < 1) {
           PrintMessage("?ERROR - can't append to an empty list");
           iappend = 0;}}

        if(iappend == 0) {
          current_struct = 0;
          mlist_deep = 0;
          Clean_Up();}  /* new structure , trash the rest */

        sprintf(chelp,"Dyna frame nr: %d",ihelp);
        strncpy(mnlist[mlist_deep],chelp,BUFF_LEN); /* input name saved */

        play_dynam_frames.current_set = (ihelp - 1);

        ret_val = get_frame(ihelp - 1,iappend);
        if(colour_structure_by) do_colouring((ihelp - 1), colour_structure_by);
        fclose(charmm_oc);
        if(ret_val < 0) {
          PrintMessage("?ERROR - can't retrieve frame \n");
          return;}

        ihelp = mlists[mlist_deep - 1];
        j     = mliste[mlist_deep - 1] - ihelp;

        if(mlist_deep == 1) {
           vecsub(&x[ihelp] , sumx , j );
            vecsub(&y[ihelp] , sumy , j );
             vecsub(&z[ihelp] , sumz , j );}

        print_num_atoms();
        if(mlist_deep > 1)  
          add_names();   /* add the atom- , segment- , residue names ... */

/* just for yasp */
        if((traj_file_set == 4) || Connect.CalcConn)
          atom_conn(mlist_deep);
/*               */
#ifdef sgi
   iappend = 1;       /* frames are always done in 'append' mode */
   clean_read(iappend);
#endif
        return;}
    }

/* read icon8 energy/charge data */

   else if(indexo(parsed[1],"icon") == 1) {
     toller(parsed[2]);
       if(indexo(parsed[2],"stat") == 1) {
         GetIcon8Stat(parsed[3]);
         return;}}

/* read mumod file */

   else if(indexo(parsed[1],"mumo") == 1) {

   if(ReadCoordinates(MUMOD_COORD , parsed[2] , parsed[3])) {
      PrintMessage("?ERROR - can't read MUMOD coordinates");}

   return;}

/* read GROMOS file                              */

   else if(indexo(parsed[1],"grom") == 1) {

   if(ReadCoordinates(GROMOS_COORD , parsed[2] , parsed[3])) {
      PrintMessage("?ERROR - can't read GROMOS coordinates");}

   return;}

/* read AMBER file (almost PDB)                              */

   else if(indexo(parsed[1],"ambe") == 1) {

   if(ReadCoordinates(AMBER_COORD , parsed[2] , parsed[3])) {
      PrintMessage("?ERROR - can't read AMBER coordinates");}

   return;}

/* read hyperchem file */

   else if(indexo(parsed[1],"hype") == 1) {

   if(ReadCoordinates(HYPER_COORD , parsed[2] , parsed[3])) {
      PrintMessage("?ERROR - can't read HyperChem coordinates");}

   return;}

/* read socket file */

   else if(indexo(parsed[1],"sock") == 1) {

      strncpy(OutText,parsed[2],BUFF_LEN);
      toller(OutText);
      if(indexo(OutText,"coor") == 1) {
        if(ReadCoordinates(SOCKET_COORD , parsed[2] , parsed[3])) {
         PrintMessage("?ERROR - can't read coordinates from socket");
         return;}
      return;
      }
   }

/* read coordinates */
   else if(indexo(parsed[1],"coor") == 1) {
        toller(parsed[2]);
  
/* read CHARMM file                           */  

   if((indexo(parsed[2],"karp") == 1) || (indexo(parsed[2],"char") == 1) ) {

   if(ReadCoordinates(CHARMM_COORD , parsed[3] , parsed[4])) {
      PrintMessage("?ERROR - can't read CHARMM coordinates");}

   return;}

/* read PDB file                              */

   else if(indexo(parsed[2],"pdb") == 1) {

   if(ReadCoordinates(PDB_COORD , parsed[3] , parsed[4])) {
      PrintMessage("?ERROR - can't read PDB coordinates");}

   return;}

/* read INSIGHT file                              */

   else if(indexo(parsed[2],"insi") == 1) {

   if(ReadCoordinates(INSIGHT_COORD , parsed[3] , parsed[4])) {
      PrintMessage("?ERROR - can't read INSIGHT coordinates");}

   return;}

/* read GAMESS MOLPLT file                              */

   else if(indexo(parsed[2],"game") == 1) {

   if(ReadCoordinates(GAMESS_COORD , parsed[3] , parsed[4])) {
      PrintMessage("?ERROR - can't read GAMESS coordinates");}

   return;}

/* read FREE file                              */

   else if(indexo(parsed[2],"free") == 1) {

   if(ReadCoordinates(FREE_COORD , parsed[3] , parsed[4])) {
      PrintMessage("?ERROR - can't read FREE coordinates");}

   return;}

/* read MOPAC graphics file for the coordinates           */

   else if(indexo(parsed[2],"mopa") == 1) {

   if(ReadCoordinates(MOPAC_COORD , parsed[3] , parsed[4])) {
      PrintMessage("?ERROR - can't read MOPAC coordinates");}

   return;}

/* read yasp file */

   else if(indexo(parsed[2],"yasp") == 1) {

   if(ReadCoordinates(YASP_COORD , parsed[3] , parsed[4])) {
      PrintMessage("?ERROR - can't read YASP coordinates");}

   return;}

/* read mumod file */

   else if(indexo(parsed[2],"mumo") == 1) {

   if(ReadCoordinates(MUMOD_COORD , parsed[3] , parsed[4])) {
      PrintMessage("?ERROR - can't read MUMOD coordinates");}

   return;}

/* read GROMOS file                              */

   else if(indexo(parsed[2],"grom") == 1) {

   if(ReadCoordinates(GROMOS_COORD , parsed[3] , parsed[4])) {
      PrintMessage("?ERROR - can't read GROMOS coordinates");}

   return;}

/* read AMBER file (almost PDB)                              */

   else if(indexo(parsed[2],"ambe") == 1) {

   if(ReadCoordinates(AMBER_COORD , parsed[3] , parsed[4])) {
      PrintMessage("?ERROR - can't read AMBER coordinates");}

   return;}

/* read hyperchem file */

   else if(indexo(parsed[2],"hype") == 1) {

   if(ReadCoordinates(HYPER_COORD , parsed[3] , parsed[4])) {
      PrintMessage("?ERROR - can't read HyperChem coordinates");}

   return;}

   }
#if defined(OPENMOL)
/* read OPENMOL file                              */

   else if(indexo(parsed[1],"openm") == 1) {

   if(ReadCoordinates(OPENMOL_COORD , parsed[2] , parsed[3])) {
      PrintMessage("?ERROR - can't read OpenMol coordinates");}

   return;}
#endif

/* read cluster data                            */
    else if(indexo(parsed[1],"clus") == 1) {
       toller(parsed[2]);
       if(indexo(parsed[2],"data") == 1) {
          if(ReadClusterData(parsed[3])) {
             PrintMessage("?ERROR - can't read cluster data");
             return;}
             return;}
     }


/* default position "command not recognized"  */

     sprintf(OutText,"?ERROR: Following command not recognized: %s \n",input);
      PrintMessage(OutText);
     sprintf(OutText,"?ERROR - following parameter is wrong: %s \n",parsed[1]);
      PrintMessage(OutText);

}      /* end of read_fac */

/****************************************************************************/
int set_type()     /* set atom type                    */
/****************************************************************************/
{
     extern char *resnam;
     extern char *atnam;
     extern char *segment;
     extern int *res1;
     extern int *atm_type;
     extern float *atm_charge;
     extern float find_vdwrad();
     extern float *vdw_list;

     extern int numat;
     extern int force_types;
     extern struct ftype {
        char resnam[4];
        char atnam[4];
        int type;
        float charge;};
     extern struct ftype force[MAXft];

     extern int com_str();

        float tot_charge;
        float min_charge;
        int   min_charge_id;
        float max_charge;
        int   max_charge_id;
      register int i,j;
        char OutText[BUFF_LEN];

      static char qresnam[MAX_RES_NAME_LEN];
      static char wresnam[MAX_RES_NAME_LEN];
      static char qatnam[MAX_ATM_NAME_LEN];
      static char watnam[MAX_ATM_NAME_LEN];

      for( i = mlists[0] ; i < mliste[mlist_deep - 1] ; i++) {
      atm_type[i] = 499;
      atm_charge[i] = 0.0;
        strncpy(qatnam,GetAtmName(i),MAX_ATM_NAME_LEN);
        sign_char(qatnam);
        strncpy(qresnam,GetResName(i),MAX_RES_NAME_LEN);
        sign_char(qresnam);
       for( j = 0 ; j < force_types ; j++) {
        strncpy(wresnam,force[j].resnam,MAX_ATM_NAME_LEN);
        sign_char(wresnam);
        strncpy(watnam,force[j].atnam,MAX_RES_NAME_LEN);
        sign_char(watnam);
        if( comp_str(qatnam,watnam) && comp_str(qresnam,wresnam)) {
            atm_type[i] = force[j].type;
            atm_charge[i] = force[j].charge;
            break;}
      }
       }

     for(j = 0 ; j < mlist_deep ; j++) {

      tot_charge = 0.0;
       min_charge = 1.e+20;
       max_charge = -1.e+20;
       min_charge_id = -1;
       max_charge_id = -1;

      for(i = mlists[j] ; i < mliste[j] ; i++) { 
                                  /* check for undefined type (=499) */
      if(atm_type[i] == 499) {
      sprintf(OutText,"Following atom has the default type: >%.4s<>%.4s<>%.4s<",
      segment+4*i,resnam+4*i,atnam+4*i);
      PrintMessage(OutText);}

      tot_charge += atm_charge[i];

      if(atm_charge[i] < min_charge) {
        min_charge = atm_charge[i];
        min_charge_id = i;}

      if(atm_charge[i] > max_charge) {
        max_charge = atm_charge[i];
        max_charge_id = i;}
      }

      sprintf(OutText,"***************> Charge analysis (%d)<***************",(j+1));
       PrintMessage(OutText);
      sprintf(OutText,"Total charge of system : %f\n",tot_charge);
       PrintMessage(OutText);
      i = max_charge_id;
      sprintf(OutText,"Max charge: >%.4s<>%.4s<>%.4s< %f\n",segment+4*i,
                                                   resnam+4*i,
                                                   atnam+4*i,max_charge);
       PrintMessage(OutText);
      i = min_charge_id;
      sprintf(OutText,"Min charge: >%.4s<>%.4s<>%.4s< %f\n",segment+4*i,
                                                   resnam+4*i,
                                                   atnam+4*i,min_charge);
       PrintMessage(OutText);

/*  put in the right vdw radius instead of the defaults        */

    for(i = mlists[j] ; i < mliste[j] ; i++) {
       vdw_list[i] = find_vdwrad(atm_type[i]);
     }}

    return(0);
}

/************************************************************************/
pre_force()
/************************************************************************/
{

     static char text[BUFF_LEN];
     int i;


#ifdef sgi
     dialog4("Reading force field parameters ...","Give file name:  ",text);

     i = read_type(text);

     if(i) return; /* error in dictionary file */

     i = set_type();

         cal_moment();
#else

     PrintMessage("?ERROR - not implemented on this device \n");

#endif

}

/****************************************************************************/
add_names()
/****************************************************************************/
{

     extern char *atnam;
     extern char *resnam;
     extern char *segment;
     extern int  *res1;
     extern int  *res2;

     int i,j;

     j = 0;
     for(i = mlists[mlist_deep - 1] ; i < mliste[mlist_deep - 1] ; i++) {

     strncpy(segment+4*i,segment+4*j,MAX_SEG_NAME_LEN);
     strncpy(resnam+4*i, resnam+4*j, MAX_RES_NAME_LEN);
     strncpy(atnam+4*i,  atnam+4*j,  MAX_ATM_NAME_LEN);

     res1[i] = res1[j];
     res2[i] = res2[j];

     j++;}

     do_util();
}


/* clean up the file reading 
   if AppSwitch == 0 the new structure will be displayed with the
   identity matrix as the ModelView matrix
   if AppSwitch >  0 the old ModelView matrix will be used but a new 
   Projection matrix has to be defined (it is recalculated in 'do_util') */
/*************************************************************************/
clean_read(AppSwitch)
      int AppSwitch;
/*************************************************************************/
{

#if defined(sgi)
      float RTemp[4][4];

         if(term_type == 1 || term_type == 3) {

          if(!AppSwitch) { /* no append */
             MakeOrtho();
              mmode(MPROJECTION);
               getmatrix(rotB);
                mmode(MVIEWING);
                 loadmatrix(idmat);}
          else {           /* append */
             getmatrix(RTemp);
              MakeOrtho();
               mmode(MPROJECTION);
                getmatrix(rotB);
                 mmode(MVIEWING);
                  loadmatrix(RTemp);}

/* 1 tick => 0.05 A when (far - near) == 10 A       */

             damp = (near - far) / 200.; 
             reshapeviewport();

         }
#endif
}

/*************************************************************************/
check_if_fatal(ret_val)  /* check if the error is fatal */
       int ret_val;
/*************************************************************************/
{

    if(ret_val == 0) return; /* you should in the first place not be here */

    if((term_type == 3) || (term_type == 4)) { /* yes it is */
     PrintMessage("?ERROR - because this is a batch job program must halt \n");
      exit(1);}
}

/*************************************************************************/
print_num_atoms()     /* print number of atoms */
/*************************************************************************/
{
     char OutText[BUFF_LEN];

     if(mlist_deep == 1) {
     PrintMessage("******************************************************");
     sprintf(OutText,"*      Number of new atoms  : %d",mliste[0]);
     PrintMessage(OutText);
     sprintf(OutText,"*      Total number of atoms: %d",mliste[0]);
     PrintMessage(OutText);
     PrintMessage("******************************************************");

/* redo it */
     sprintf(OutText,"* Number of new atoms  : %d",mliste[0]);
     strncpy(bottom_line,OutText,PORTchar);
     sprintf(OutText,",   Total number of atoms: %d",mliste[0]);
     strncat(bottom_line,OutText,(PORTchar - strlen(bottom_line)));
     going_on();
     return;}

     if(mlist_deep > 1) {
   PrintMessage("******************************************************");
   sprintf(OutText,"*      Number of new atoms  : %d",( mliste[mlist_deep - 1] 
                                                 - mlists[mlist_deep - 1]
                                                 ));
   PrintMessage(OutText);
   sprintf(OutText,"*      Total number of atoms: %d",mliste[mlist_deep - 1]);
   PrintMessage(OutText);
   PrintMessage("******************************************************");

/* redo it */
   sprintf(OutText,"* Number of new atoms  : %d",( mliste[mlist_deep - 1] 
                                                 - mlists[mlist_deep - 1]
                                                 ));
   strncpy(bottom_line,OutText,PORTchar);
   sprintf(OutText,",   Total number of atoms: %d",mliste[mlist_deep - 1]);
   strncat(bottom_line,OutText,(PORTchar - strlen(bottom_line)));
   going_on();
   return;}

     PrintMessage("?ERROR - No atoms at all (This should not happen)\n");
     return;
}
/*************************************************************************/
int  GetIcon8Stat(FileN)
     char *FileN;
/*************************************************************************/
{
     FILE *icon8_p;
     int i;
     float Etemp;
     char OutText[BUFF_LEN];

     icon8_p = fopen(FileN,"r");
     if(icon8_p == NULL) {
     sprintf(OutText,"Can't open icon8 output statistics file '%s'",FileN);
     PrintMessage(OutText);
     return(1);}

     fgets(OutText,BUFF_LEN,icon8_p);
     sscanf(OutText,"%d %d",&QMstat.ndim,&QMstat.numat);

     QMstat.Energy = vector(QMstat.ndim);
     QMstat.Occ    = vector(QMstat.ndim);
     QMstat.Pcharge= vector(QMstat.numat);

     for(i = 0; i < QMstat.ndim ; i++) {
        fgets(OutText,BUFF_LEN,icon8_p);
        sscanf(OutText,"%f %f %f",&QMstat.Energy[i],&Etemp,&QMstat.Occ[i]);

        if(DebugS.DebugL) {
         printf(":%d: Energy (ev) %f energy (au) %f occ. %f \n",
          (i+1),QMstat.Energy[i],Etemp,QMstat.Occ[i]);
           }
      }

/*
     for(i = 0 ; i < QMstat.numat ; i++) {
        fgets(OutText,BUFF_LEN,icon8_p);

*/

     for(i = 0 ; i < QMstat.ndim ; i++) {
        if(QMstat.Occ[i] < 1.0) {
          QMstat.Nocc = i;
          break;}
     }
     fclose(icon8_p);
     return(0);
}
/*************************************************************************/
int FREE_QMstat()
/*************************************************************************/
{
    if(QMstat.ndim) {
      free(QMstat.Occ);
       free(QMstat.Energy);
        free(QMstat.Pcharge);
      QMstat.ndim  = 0;
      QMstat.numat = 0;}
    else {
      PrintMessage("?ERROR - nothing to free in QMstat");
      return(1);}

     if(QMstat.NPDens) {
       free(QMstat.DensState);
        QMstat.NPDens = 0;}

     return(0);

}
/*************************************************************************/
FormsForRead()
/*************************************************************************/
{ 
#if defined(USEFORMS) && defined(sgi)
  char *TempRead;
     if((TempRead = ShowForm4()) != NULL ) 
         send_command(TempRead);
#endif
         return;
}

/*************************************************************************/
ReadCoordinates(int Choice , char *FileName , char *Append)
/*************************************************************************/
{

   int ret_val;
   int iappend;
   int is_it_frame;
   char OutText[BUFF_LEN];

/* check that file exist */
   if(Choice != OPENMOL_COORD && Choice != SOCKET_COORD) {
     if((ret_val = check_if_file_exist(FileName)) < 0) {
     check_if_fatal(ret_val);
     return;}}

   is_it_frame = 0;
   iappend     = 0;
     toller(Append);
     if(indexo(Append,"appe") == 1) {
        iappend = 1;
        if(mlist_deep < 1) {
           PrintMessage("?ERROR - can't append to an empty list");
           iappend = 0;}}

   if(iappend == 0) {
   alpha_trace = 0;
   current_struct = 0;
   mlist_deep = 0;
   Clean_Up();}  /* new structure , trash the rest */

   if(Choice != OPENMOL_COORD && Choice != SOCKET_COORD) {
     strcpy(mnlist[mlist_deep],FileName);} /* input name saved */
   else 
     strncpy(mnlist[mlist_deep],"** Outside connection ***",BUFF_LEN);

   switch(Choice) {

      case CHARMM_COORD:  /* CHARMM file */
        ret_val = read_karp(FileName);
        break;

      case PDB_COORD:     /* PDB file    */
        ret_val = read_pdb(FileName);
        break;

      case INSIGHT_COORD: /* Insight file */
        ret_val = read_insight(FileName);
        break;

      case GAMESS_COORD: /* GAMESS file   */
        ret_val = read_gamess(FileName);
        break;

      case FREE_COORD:   /* Free file     */
        ret_val = read_free(FileName);
        break;

      case MOPAC_COORD:  /* Mopac file    */
        ret_val = read_mopac(FileName);
        break;

      case YASP_COORD:   /* YASP file     */
        ret_val = read_yasp(FileName);
        break;

      case MUMOD_COORD:  /* MUMOD file */
        ret_val = read_mumod(FileName);
        break;

      case GROMOS_COORD: /* GROMOS file */
        ret_val = read_gromos(FileName);
        break;

      case HYPER_COORD:  /* HyperChem file */
        ret_val = read_hyper(FileName);
        break;

      case AMBER_COORD:  /* AMBER file  */
        ret_val = read_amber(FileName);
        break;


      case SOCKET_COORD: /* Coordinates from socket */
        ret_val = read_coord_sock(FileName);
        break;

#if defined(OPENMOL)
      case OPENMOL_COORD: /* OPENMOL data */
        ret_val = read_openmol(FileName);
        break;
#endif

      default:
        PrintMessage("?ERROR - unknown file type to be read");
        ret_val = 1;
        break;
   }

   if(ret_val) {
    sprintf(OutText,"?ERROR - unable to read file : %s ",FileName);
    PrintMessage(OutText);
    check_if_fatal(ret_val);
    return(1);}

   print_num_atoms();
   do_util();

#ifdef sgi
       clean_read(iappend);
#endif
   return(0);
}
/*
   Returns number of structures (systems) currently defined 
*/
/*************************************************************************/
int NumStructLists()
/*************************************************************************/
{
    return(mlist_deep);
}
/*
  Delete structure list
*/
/*************************************************************************/
int DelNumStructLists()
/*************************************************************************/
{
    mlist_deep = 0;

    return(0);
}
/*
   Returns index to the position where new atoms should be filled
   into the data storage
*/
/*************************************************************************/
int StartIndexStructList()
/*************************************************************************/
{
    if(mlist_deep == 0)
        return(0);
    else
        return(mliste[mlist_deep - 1]);
}
/*************************************************************************/
int ReadClusterData(char *FileName)
/*************************************************************************/
{

    FILE *File_p;
    char OutText[BUFF_LEN];
    int ContrlR;
    int CSize;
    int TotalSize;
    int i;
    float MaxC;
    float MinC;

    if(FileName[0] == '\0') {
       PrintMessage("?ERROR - file name missing");
       return(1);}


    File_p = fopen(FileName,"r");
    if(File_p == NULL) {
       sprintf(OutText,"?ERROR - can't open file '%s'",FileName);
       PrintMessage(OutText);
       return(1);}   

    if(ClusterData.NumSets) 
              (void)DeleteClusterData();

/* title record */
    ContrlR = fread(OutText,sizeof(char),80,File_p);
    PrintMessage(OutText);
/* size record  */
    ContrlR = fread(&CSize,sizeof(int),1,File_p);
    ClusterData.NumSets = CSize;
/* data         */
    (void)GetClusterSpace(CSize);
    TotalSize = CSize * (CSize - 1) / 2;
    ContrlR = fread(ClusterData.DataArray,sizeof(float),TotalSize,File_p);
    fclose(File_p);

    MaxC = 0.0;
    MinC = 1.e+10;

    for(i = 0 ; i < TotalSize ; i++) {
        if(ClusterData.DataArray[i] < MinC) MinC = ClusterData.DataArray[i];
        if(ClusterData.DataArray[i] > MaxC) MaxC = ClusterData.DataArray[i];
    }

    sprintf(OutText,"Min cluster value: %f",MinC);
    PrintMessage(OutText);
    sprintf(OutText,"Max cluster value: %f",MaxC);
    PrintMessage(OutText);

    return(0);
}

/****************************************************************************/
int AddNames()
/****************************************************************************/
{

     extern char *atnam;
     extern char *resnam;
     extern char *segment;
     extern int  *res1;
     extern int  *res2;

     int i,j;

     j = 0;
     for(i = mlists[mlist_deep - 1] ; i < mliste[mlist_deep - 1] ; i++) {

     strncpy(segment+4*i,segment+4*j,MAX_SEG_NAME_LEN);
     strncpy(resnam+4*i, resnam+4*j, MAX_RES_NAME_LEN);
     strncpy(atnam+4*i,  atnam+4*j,  MAX_ATM_NAME_LEN);

     res1[i] = res1[j];
     res2[i] = res2[j];

     j++;}
}

