/*  

                       Copyright (c) 1990, 1992 by:
        Leif Laaksonen , Centre for Scientific Computing, ESPOO, FINLAND
            Confidential unpublished property of Leif Laaksonen
                        All rights reserved
  

*/

#include <stdio.h>
#include <math.h>
#include <malloc.h>
#include <string.h>

#include "maxdefs.h"

#define LINE 120

   extern int check_if_fatal();
   extern int keyb_command;

   extern char energy_file[BUFF_LEN];

   extern struct et {
   int step_nr;
   float time_in_fs;
   float tote;
   float kine;
   float pote;
   float temp;
   float bond;
   float angl;
   float dihe;
   float impr;
   float vdw;
   float elec;
   float hbond;
   float charm; };

   extern struct et *traj_energy;

   struct {
    int   tote_set;
    int   kine_set;
    int   pote_set;
    int   temp_set;
    int   bond_set;
    int   angl_set;
    int   dihe_set;
    int   impr_set;
    int   vdw_set;
    int   elec_set;
    int   hbond_set;
    int   charm_set;
   float min_tote;
   float max_tote;
   float min_kine;
   float max_kine;
   float min_pote;
   float max_pote;
   float min_temp;
   float max_temp;
   float min_bond;
   float max_bond;
   float min_angl;
   float max_angl;
   float min_dihe;
   float max_dihe;
   float min_impr;
   float max_impr;
   float min_vdw;
   float max_vdw;
   float min_elec;
   float max_elec;
   float min_hbond;
   float max_hbond;
   float min_charm;
   float max_charm; } traj_energy_limits ;

   extern int et_count;

/************************************************************************/
int read_et() /* read the file containing the energies for a trajectory */
/************************************************************************/

{


   FILE *et_point;
   char input[LINE];
   char InBuff[BUFF_LEN];
   int i;


   if(et_count > 0) 
     free(traj_energy);

   et_count = 0;

    traj_energy_limits.tote_set = 0; 
    traj_energy_limits.kine_set = 0;
    traj_energy_limits.pote_set = 0;
    traj_energy_limits.temp_set = 0;
    traj_energy_limits.bond_set = 0;
    traj_energy_limits.angl_set = 0;
    traj_energy_limits.dihe_set = 0;
    traj_energy_limits.impr_set = 0;
    traj_energy_limits.vdw_set = 0;
    traj_energy_limits.elec_set = 0;
    traj_energy_limits.hbond_set = 0;
    traj_energy_limits.charm_set = 0;

   if(energy_file[0] == '\0') {
      printf("?ERROR energy file is not set \n");
      check_if_fatal(1);
      return(-1);}
   
   et_point = fopen(energy_file,"r");
   if(et_point == NULL) {
   printf("\n\n**** ERROR. Input file : '%s' is missing \07\n\n",energy_file);
   check_if_fatal(1);
   return(-1); } 


/* ready to continue ... */

   while(fgets(input,LINE,et_point) != NULL)  et_count++;   
   rewind(et_point);

/* from now on this works only for CHARMM22 ?!?!?!?!?!?!? */

   et_count = et_count / 3;

/* now I know how many lines there are in the input file , go on .. */

    traj_energy = (struct et *)malloc(et_count * sizeof(struct et));
    if(traj_energy == NULL) {
    printf("\n\n**** ERROR in memory allocation for trajectory energies \07");}

    for(i = 0 ; i < et_count ; i++ ) {
    fgets(input,LINE,et_point);
    sscanf(input,"%d %f %f %f %f",       &traj_energy[i].step_nr, 
                                         &traj_energy[i].time_in_fs, 
                                         &traj_energy[i].tote, 
                                         &traj_energy[i].kine, 
                                         &traj_energy[i].pote); 
    fgets(input,LINE,et_point);
    sscanf(input,"%*f %f %f %f %f",      &traj_energy[i].temp, 
                                         &traj_energy[i].bond, 
                                         &traj_energy[i].angl, 
                                         &traj_energy[i].dihe); 
    fgets(input,LINE,et_point);
    sscanf(input," %f %f %f %f %f",      &traj_energy[i].impr, 
                                         &traj_energy[i].vdw, 
                                         &traj_energy[i].elec, 
                                         &traj_energy[i].hbond, 
                                         &traj_energy[i].charm); 
/* for CHARMM22 
      IF(KUNIT.GE.0 .AND. IOLEV.GE.0)
      WRITE(KUNIT,160) NPRIV,TIME,EPROP(TOTE),EPROP(TOTKE),EPROP(EPOT),
     1                 EPROP(EPOT)-EPROP(TOTKE),EPROP(TEMPS),
     1                 ETERM(BOND),ETERM(ANGLE),ETERM(DIHE),
     &                 ETERM(IMDIHE),ETERM(VDW),ETERM(ELEC),
     &                 ETERM(HBOND),ETERM(CHARM)
##IF APOLLO
  160 FORMAT(I16,14F16.4)
##ELSE
  160 FORMAT(I16,4F16.4,/,5F16.4,/,5F16.4)
##ENDIF
*/
    }

/* make some comments about the file ... */

     printf("\nTrajectory file containing energies is: %s\n",energy_file);
     printf("Number of steps retrieved : %d \n",et_count);

    stack_text(" ");
    sprintf(input,"Trajectory file containing energies is: %s",energy_file);
    stack_text(input);
    sprintf(input,"Number of steps retrieved : %d ",et_count);
    stack_text(input);

/* calculate min and max for the entries */
    traj_energy_limits.min_tote =  1.e20;
    traj_energy_limits.max_tote = -1.e20;
    traj_energy_limits.min_kine =  1.e20;
    traj_energy_limits.max_kine =  0.0;
    traj_energy_limits.min_pote =  1.e20;
    traj_energy_limits.max_pote = -1.e20;
    traj_energy_limits.min_temp =  1.e20;
    traj_energy_limits.max_temp = 0.0;
    traj_energy_limits.min_bond =  1.e20;
    traj_energy_limits.max_bond = 0.0;
    traj_energy_limits.min_angl =  1.e20;
    traj_energy_limits.max_angl = 0.0;
    traj_energy_limits.min_dihe =  1.e20;
    traj_energy_limits.max_dihe = 0.0;
    traj_energy_limits.min_impr =  1.e20;
    traj_energy_limits.max_impr = 0.0;
    traj_energy_limits.min_vdw  =  1.e20;
    traj_energy_limits.max_vdw  = 0.0;
    traj_energy_limits.min_elec =  1.e20;
    traj_energy_limits.max_elec = 0.0;
    traj_energy_limits.min_hbond =  1.e20;
    traj_energy_limits.max_hbond = 0.0;
    traj_energy_limits.min_charm =  1.e20;
    traj_energy_limits.max_charm = 0.0;

    for(i = 0 ; i < et_count ; i++) {

    if(traj_energy[i].tote < traj_energy_limits.min_tote)
       traj_energy_limits.min_tote = traj_energy[i].tote ;
    if(traj_energy[i].tote > traj_energy_limits.max_tote)
       traj_energy_limits.max_tote = traj_energy[i].tote;

    if(traj_energy[i].kine < traj_energy_limits.min_kine)
       traj_energy_limits.min_kine = traj_energy[i].kine ;
    if(traj_energy[i].kine > traj_energy_limits.max_kine)
       traj_energy_limits.max_kine = traj_energy[i].kine;

    if(traj_energy[i].pote < traj_energy_limits.min_pote)
       traj_energy_limits.min_pote = traj_energy[i].pote ;
    if(traj_energy[i].pote > traj_energy_limits.max_pote)
       traj_energy_limits.max_pote = traj_energy[i].pote;

    if(traj_energy[i].temp < traj_energy_limits.min_temp)
       traj_energy_limits.min_temp = traj_energy[i].temp ;
    if(traj_energy[i].temp > traj_energy_limits.max_temp)
       traj_energy_limits.max_temp = traj_energy[i].temp;

    if(traj_energy[i].bond < traj_energy_limits.min_bond)
       traj_energy_limits.min_bond = traj_energy[i].bond ;
    if(traj_energy[i].bond > traj_energy_limits.max_bond)
       traj_energy_limits.max_bond = traj_energy[i].bond;

    if(traj_energy[i].angl < traj_energy_limits.min_angl)
       traj_energy_limits.min_angl = traj_energy[i].angl ;
    if(traj_energy[i].angl > traj_energy_limits.max_angl)
       traj_energy_limits.max_angl = traj_energy[i].angl;

    if(traj_energy[i].dihe < traj_energy_limits.min_dihe)
       traj_energy_limits.min_dihe = traj_energy[i].dihe ;
    if(traj_energy[i].dihe > traj_energy_limits.max_dihe)
       traj_energy_limits.max_dihe = traj_energy[i].dihe;

    if(traj_energy[i].impr < traj_energy_limits.min_impr)
       traj_energy_limits.min_impr = traj_energy[i].impr ;
    if(traj_energy[i].impr > traj_energy_limits.max_impr)
       traj_energy_limits.max_impr = traj_energy[i].impr;

    if(traj_energy[i].vdw  < traj_energy_limits.min_vdw )
       traj_energy_limits.min_vdw  = traj_energy[i].vdw  ;
    if(traj_energy[i].vdw  > traj_energy_limits.max_vdw )
       traj_energy_limits.max_vdw  = traj_energy[i].vdw ;

    if(traj_energy[i].elec < traj_energy_limits.min_elec)
       traj_energy_limits.min_elec = traj_energy[i].elec ;
    if(traj_energy[i].elec > traj_energy_limits.max_elec)
       traj_energy_limits.max_elec = traj_energy[i].elec;

    if(traj_energy[i].hbond < traj_energy_limits.min_hbond)
       traj_energy_limits.min_hbond = traj_energy[i].hbond ;
    if(traj_energy[i].hbond > traj_energy_limits.max_hbond)
       traj_energy_limits.max_hbond = traj_energy[i].hbond;

    if(traj_energy[i].charm < traj_energy_limits.min_charm)
       traj_energy_limits.min_charm = traj_energy[i].charm ;
    if(traj_energy[i].charm > traj_energy_limits.max_charm)
       traj_energy_limits.max_charm = traj_energy[i].charm;

  }

sprintf(InBuff,"*** Trajectory statistics for '%d' frames ***",et_count);
PrintMessage(InBuff);
sprintf(InBuff,"Total energy. Min: %f , Max: %f",traj_energy_limits.min_tote,
                                           traj_energy_limits.max_tote);
PrintMessage(InBuff);
sprintf(InBuff,"Kin.  energy. Min: %f , Max: %f",traj_energy_limits.min_kine,
                                           traj_energy_limits.max_kine);
PrintMessage(InBuff);
sprintf(InBuff,"Pot.  energy. Min: %f , Max: %f",traj_energy_limits.min_pote,
                                           traj_energy_limits.max_pote);
PrintMessage(InBuff);
sprintf(InBuff,"Temp.         Min: %f , Max: %f",traj_energy_limits.min_temp,
                                           traj_energy_limits.max_temp);
PrintMessage(InBuff);
sprintf(InBuff,"Bond. energy  Min: %f , Max: %f",traj_energy_limits.min_bond,
                                           traj_energy_limits.max_bond);
PrintMessage(InBuff);
sprintf(InBuff,"Angl. energy  Min: %f , Max: %f",traj_energy_limits.min_angl,
                                           traj_energy_limits.max_angl);
PrintMessage(InBuff);
sprintf(InBuff,"Dihe. energy  Min: %f , Max: %f",traj_energy_limits.min_dihe,
                                           traj_energy_limits.max_dihe);
PrintMessage(InBuff);
sprintf(InBuff,"Impr. energy  Min: %f , Max: %f",traj_energy_limits.min_impr,
                                           traj_energy_limits.max_impr);
PrintMessage(InBuff);
sprintf(InBuff,"vdW.  energy  Min: %f , Max: %f",traj_energy_limits.min_vdw,
                                           traj_energy_limits.max_vdw);
PrintMessage(InBuff);
sprintf(InBuff,"Elec. energy  Min: %f , Max: %f",traj_energy_limits.min_elec,
                                           traj_energy_limits.max_elec);

    return(0);
}




