/*  

                       Copyright (c) 1990 by:
        Leif Laaksonen , VTT/Biotechnical laboratory, ESPOO, FINLAND
            Confidential unpublished property of Leif Laaksonen
                        All rights reserved
  

*/

/*

   Read colour table to be used by scarecrow

   Leif Laaksonen 1990

*/

#include <stdio.h>
#include <math.h>
#include <string.h>
#include <malloc.h>
#include <ctype.h>

#include "maxdefs.h"

#define COL_TBL_INC 50

     extern char parsed[MAXparse][MAXlinel];
     extern char text[MAXlinel];
     extern char scr_data[BUFF_LEN];

     extern void PrintMessage();

     int col_tbl_max  = 0;  /* number of entries in the colour table */
     int col_tbl_high = 0;

     struct SCARE_col_table {
     int red;      /* read value */
     int green;    /* green value */
     int blue;     /* blue value */
     char name[MAX_COL_LEN]; } ;

     struct SCARE_col_table *col_table;  /* colour table pointer */

/***************************************************************************/
int read_col_tbl(tbl_name)
     char *tbl_name;               /* name of colour table file to be read */
/***************************************************************************/
{
     int i,j,k;
     int ColLoop;
     int Cr,Cg,Cb;
     int print_input;
     FILE *own_p;
     char chelp[BUFF_LEN];
     char inputl[MAXlinel];
     char OutText[BUFF_LEN];
     
/* look only into the data directory */
     strcpy(chelp,scr_data);
     strcat(chelp,"/");
     strcat(chelp,tbl_name);

     print_input=0;
     own_p=fopen(chelp,"r");
     if(own_p==NULL) {
     printf("**** Can't open colour table file: %s \n",chelp);
     return(1); }

/*   We are ready now to start reading.
     First line is a comment line. 
*/

#ifdef DEBUG
     printf("    Reading colour table file: %s ...\n",tbl_name);
#endif

/* calculate first number of entries in the file */
     ColLoop = 0;
     while(fgets(inputl,MAXlinel,own_p) != NULL)  ColLoop++;
     rewind(own_p);

     ColLoop--;

/* 1 line is a comment */
     fgets(inputl,MAXlinel,own_p);   /*  */

/*  read rest of the file (main loop)    */

     for(i = 0 ; i < ColLoop ; i++) {

      fgets(inputl,MAXlinel,own_p);

     toller(inputl);   /*  switch to lower case letters   */

     k=0;                         /* k before parsing */
     own_parser(inputl,parsed,&k," ");

     if(k < 3) {
     sprintf(OutText,"?ERROR - error on colour definition : %s",inputl);
      PrintMessage(OutText);
       return(1);}

     Cr = atoi(parsed[0]);
      Cg = atoi(parsed[1]);
       Cb = atoi(parsed[2]);     

     k = strlen(inputl);
     if(inputl[k-1] == '\n') inputl[k-1] = '\0';

     for(j = 0 ; j < k ; j++) {
      if(isalpha(inputl[j])) break;}

     if(j == k) {
       PrintMessage("?ERROR - no name in colour definition");
        return(1);}

     if(PushColTable(Cr , Cg , Cb , (inputl+j))) {
       PrintMessage("?ERROR - in colour table set up ");
        return(1);}

     }


     return (0);
}
/***************************************************************************/
int  PushColTable(Cr , Cg , Cb , chelp)   /* push new colour into table */
     int Cr;
     int Cg;
     int Cb;
     char *chelp;
/***************************************************************************/
{
     char OutText[BUFF_LEN];

     if(!col_tbl_high) { /* first time down here , grab space */
       col_table = (struct SCARE_col_table *) malloc(COL_TBL_INC * 
                                        sizeof(struct SCARE_col_table));
       col_tbl_high = COL_TBL_INC;

       if(col_table == NULL) {
         PrintMessage("?ERROR - can't allocate space for colour table");
         return(1);}}

      if(col_tbl_max == col_tbl_high) {
         col_tbl_high += COL_TBL_INC;
         col_table = (struct SCARE_col_table *) 
                     realloc((char *) col_table , 
                     col_tbl_high * sizeof(struct SCARE_col_table));
    
       if(col_table == NULL) {
         PrintMessage("?ERROR - can't reallocate space for colour table");
         return(1);}}
      
     col_table[col_tbl_max].red = Cr;
      col_table[col_tbl_max].green = Cg;
       col_table[col_tbl_max].blue = Cb;     

       strncpy(col_table[col_tbl_max].name,chelp,MAX_COL_LEN);

       col_tbl_max++;

     return(0);
}






