/*  

                       Copyright (c) 1990, 1992 by:
        Leif Laaksonen , Centre for Scientific Computing, Espoo, FINLAND
            Confidential unpublished property of Leif Laaksonen
                        All rights reserved
  

*/

/*
     calculate atomic radial distribution function for a single
     confguration. 

             Where box is the length of the cubic periodic box 
             cutoff is the limit up to which the rdf is calculated
             (the lower limit is zero)

     fmp oct 89
     modified to c by 
     Leif Laaksonen dec 89


     Na      = 6.0221 10^23/mol
     density = 1000 kg/mol
     water   = 18.0073 g/mol

     ====>  0.033442 molecules/A^3
*/

#include <stdio.h>
#include <math.h>
#include <malloc.h>
#include "maxdefs.h"

#define  WATER_DENS  0.033442

     struct {
       int    Mean;                   /* != 0 average is calulated  */
       int    Plot;                   /* != 0 plot is on            */
       int    Set;                    /* != 0 collection is on      */
       int    Numbers;                /* number of observations     */
       float *XValues;                /* X - pointer to values      */
       float *YValues;                /* Y - pointer to values      */
     } RaDiFu = { 0 , 0 , 0 , 0 , NULL , NULL};

     int    GetNumRDFObs();
     float *GetRDFVecX();
     float *GetRDFVecY();

     extern int mlist_deep;      /* stack number indicator */
     extern int mlists[MAX_MLIST]; /* First index for molecule list */

     extern int mliste[MAX_MLIST]; /* Second index for molecule list */
     extern char mnlist[MAX_MLIST][BUFF_LEN]; 
                                /* name list for molecule file names */

     extern int *res1;
     extern int  atom_list_max();
     extern int *ivector();
     extern int  DeleteRDF();
     extern int term_type;

      extern float  *x, *y, *z;
      extern int *ivector();
      extern float *vector();
      extern int numat;

/*************************************************************************/
void rdf(fromi,fromlong,boxl1,boxl2,boxl3,rcut,mbin,Text1,Text2,Text3)
      int  *fromi;       /* distribution function is calculated for atom i */
      int   fromlong;
      float boxl1;        /* box dimension x              */
      float boxl2;        /* box dimension y              */
      float boxl3;        /* box dimension z              */
      float rcut;        /* cut off distance            */
      int   mbin;        /* number of rdf values (bins) */
      char *Text1;       /* Segment name                */
      char *Text2;       /* Residue name                */
      char *Text3;       /* Atom name                   */
/*************************************************************************/
{

      static int i,j,k,l,id,il;
      static int *ibin;                 /* pointer to number array */
      static float *g;                  /* pointer to distribution funct */
      static float *x_axis;
      static float *y_axis;
      static float delta;               /* step length             */
      static float d,dx,dy,dz,xboxl,yboxl,zboxl;
      static float fact,rl,ru,rideal;
      static float Tmp1,Tmp2;
      static int atom_list,slong;
      static int *sel_list;


      if(RaDiFu.Set && (mbin != RaDiFu.Numbers)) {
           PrintMessage("?ERROR - RDFs are collected and new nbin != old");
           PrintMessage(" Will scrap old values and start collecting new");
        (void)DeleteRDF();
      }

      if(RaDiFu.Set && RaDiFu.Mean) {
           PrintMessage("?ERROR - Average RDF is already calulated");
           PrintMessage(" Will start collecting new series        ");
         (void)DeleteRDF();}

      if(!RaDiFu.Set) {
          RaDiFu.XValues = vector(mbin);
          RaDiFu.YValues = vector(mbin);
      for(i = 0 ; i < mbin ; i++) RaDiFu.YValues[i] = 0.0;
      }

      RaDiFu.Numbers = mbin;

   atom_list = atom_list_max();

   sel_list = ivector(atom_list);

   slong = select_list(Text1,Text2,Text3,sel_list);

      delta = rcut / (float)(mbin-1) ;

/*     ... initialise */
       
      ibin   = ivector(mbin);       /* reserve memory for mbin elements */
      g      =  vector(mbin);       /* reserve memory for dist funct    */
      x_axis =  vector(mbin);
      y_axis =  vector(mbin);

      for(i=0 ; i < mbin  ; i++)  ibin[i] = 0;

      xboxl = 1. / boxl1;
      yboxl = 1. / boxl2;
      zboxl = 1. / boxl3;
/*     ... calculate rdf      */

/* apply always to FIRST structure */

       for(il = 0 ; il < fromlong ; il++) {
        l = fromi[il];
         i = res1[l];
          for(k = 0 ; k < slong ; k++) {
              j = sel_list[k];
              if(res1[j] == i) continue;
            dx = x[l] - x[j];
            dy = y[l] - y[j];
            dz = z[l] - z[j];
  
            dx = dx - boxl1 * rint (xboxl * dx);
            dy = dy - boxl2 * rint (yboxl * dy);
            dz = dz - boxl3 * rint (zboxl * dz);
  
            d = sqrt (dx * dx + dy * dy + dz * dz);
            id = (int)(d / delta) ;

            if (id < mbin ) ibin[id] = ibin[id] + 1; /* I use 1 here not 2!!*/

	  }}

/*
      fact = 3.1415927 * 4.0 * WATER_DENS / 3.0;
*/
      Tmp1 = (float)(fromlong);
      Tmp2 = (float)(slong);

      fact = 3.1415927 * 4.0 * Tmp2 / (3.0 * boxl1 * boxl2 * boxl3);

      for(i = 0 ; i < mbin ; i++) {
         rl = i * delta;
         x_axis[i] = rl;
/*         y_axis[i] = (float)(ibin[i]); */
         ru = rl + delta;
         rideal = fact * (ru*ru*ru - rl*rl*rl);
         g[i] = y_axis[i] =  (float)(ibin[i]) / (Tmp1 * rideal);
      }

      for(i = 0 ; i < mbin ; i++) {
        RaDiFu.XValues[i]  = i * delta;
        RaDiFu.YValues[i] += g[i];
      }

        RaDiFu.Set++;

      free(g);
      free(ibin);
      free(x_axis);
      free(y_axis);
      free(sel_list);

}

/*

     Calculate RDF from centre of mass

*/

/*************************************************************************/
void cmass_rdf(CMASSx,CMASSy,CMASSz,
               boxl1,boxl2,boxl3,rcut,mbin,Text1,Text2,Text3)
      float CMASSx;
      float CMASSy;
      float CMASSz;
      float boxl1;        /* box dimension x              */
      float boxl2;        /* box dimension y              */
      float boxl3;        /* box dimension z              */
      float rcut;        /* cut off distance            */
      int   mbin;        /* number of rdf values (bins) */
      char *Text1;       /* Segment name                */
      char *Text2;       /* Residue name                */
      char *Text3;       /* Atom name                   */
/*************************************************************************/
{

      static int i,j,k,l,id,il;
      static int *ibin;                 /* pointer to number array */
      static float *g;                  /* pointer to distribution funct */
      static float *x_axis;
      static float *y_axis;
      static float delta;               /* step length             */
      static float d,dx,dy,dz,xboxl,yboxl,zboxl;
      static float fact,rl,ru,rideal;
      static float Tmp1,Tmp2;
      static int atom_list,slong;
      static int *sel_list;


      if(RaDiFu.Set && (mbin != RaDiFu.Numbers)) {
           PrintMessage("?ERROR - RDFs are collected and new nbin != old");
           PrintMessage(" Will scrap old values and start collecting new");
        (void)DeleteRDF();
      }

      if(RaDiFu.Set && RaDiFu.Mean) {
           PrintMessage("?ERROR - Average RDF is already calulated");
           PrintMessage(" Will start collecting new series        ");
         (void)DeleteRDF();}

      if(!RaDiFu.Set) {
          RaDiFu.XValues = vector(mbin);
          RaDiFu.YValues = vector(mbin);
      for(i = 0 ; i < mbin ; i++) RaDiFu.YValues[i] = 0.0;
      }

      RaDiFu.Numbers = mbin;

   atom_list = atom_list_max();

   sel_list = ivector(atom_list);

   slong = select_list(Text1,Text2,Text3,sel_list);

      delta = rcut / (float)(mbin-1) ;

/*     ... initialise */
       
      ibin   = ivector(mbin);       /* reserve memory for mbin elements */
      g      =  vector(mbin);       /* reserve memory for dist funct    */
      x_axis =  vector(mbin);
      y_axis =  vector(mbin);

      for(i=0 ; i < mbin  ; i++)  ibin[i] = 0;

      xboxl = 1. / boxl1;
      yboxl = 1. / boxl2;
      zboxl = 1. / boxl3;
/*     ... calculate rdf      */

/* apply always to FIRST structure */

          for(k = 0 ; k < slong ; k++) {
              j = sel_list[k];
              if(res1[j] == i) continue;
            dx = CMASSx - x[j];
            dy = CMASSy - y[j];
            dz = CMASSz - z[j];

            dx = dx - boxl1 * rint (xboxl * dx);
            dy = dy - boxl2 * rint (yboxl * dy);
            dz = dz - boxl3 * rint (zboxl * dz);

            d = sqrt (dx * dx + dy * dy + dz * dz);
            id = (int)(d / delta) ;

            if (id < mbin ) ibin[id] = ibin[id] + 1; /* I use 1 here not 2!!*/

	  }

/*
      fact = 3.1415927 * 4.0 * WATER_DENS / 3.0;
*/
      Tmp1 = 1.0;
      Tmp2 = (float)(slong);

      fact = 3.1415927 * 4.0 * Tmp2 / (3.0 * boxl1 * boxl2 * boxl3);

      for(i = 0 ; i < mbin ; i++) {
         rl = i * delta;
         x_axis[i] = rl;
/*         y_axis[i] = (float)(ibin[i]); */
         ru = rl + delta;
         rideal = fact * (ru*ru*ru - rl*rl*rl);
         g[i] = y_axis[i] =  (float)(ibin[i]) / (Tmp1 * rideal);
      }

      for(i = 0 ; i < mbin ; i++) {
        RaDiFu.XValues[i]  = i * delta;
        RaDiFu.YValues[i] += g[i];
      }

        RaDiFu.Set++;

      free(g);
      free(ibin);
      free(x_axis);
      free(y_axis);
      free(sel_list);

}

/*************************************************************************/
int GetNumRDFObs()
/*************************************************************************/
{
    return(RaDiFu.Numbers);
}
/*************************************************************************/
float *GetRDFVecX()
/*************************************************************************/
{
    return(RaDiFu.XValues);
}
/*************************************************************************/
float *GetRDFVecY()
/*************************************************************************/
{
    return(RaDiFu.YValues);
}
