/*  

                       Copyright (c) 1990, 1993 by:
        Leif Laaksonen , Center for Scientific Computing, ESPOO, FINLAND
            Confidential unpublished property of Leif Laaksonen
                        All rights reserved
  

*/


/*
   This program reads a AMBER coordinate files.
   Files are very close to pdb files

   Leif Laaksonen 1989
*/

#include <stdio.h>
#include <math.h>
#include <string.h>
#include <ctype.h>

#if defined(USEFORMS) && defined(sgi)
#include "../forms/FORMS/forms.h"
#endif

#include "maxdefs.h"

#define AMBER_LINE_LEN   120   /* amber file line length */

extern char input_file[BUFF_LEN];
     extern int mlist_deep;      /* stack number indicator */
     extern int mlists[MAX_MLIST]; /* First index for molecule list */
     extern int mliste[MAX_MLIST]; /* Second index for molecule list */
     extern char mnlist[MAX_MLIST][BUFF_LEN]; 
                                /* name list for molecule file names */

extern void PrintMessage();
extern void dialgog4();
extern int  ExtractFromString();
extern int PutSegName();
extern int PutResName();
extern int PutAtmName();
extern int PutResNum1();
extern int PutResNum2();
extern int PutXCoord();
extern int PutYCoord();
extern int PutZCoord();
extern int PutBValue();
extern int PutAtmCharge();
extern int NumStructLists();
extern int StartIndexStructList();

/*************************************************************************/
pre_read_amber()  /* pre routine for reading a amber file */

/*************************************************************************/
{
    extern char *bottom_line;
    extern int MAXatom;
    char text[BUFF_LEN];
    char Cline[BUFF_LEN];
    int ret_val;

#ifdef sgi

#ifdef USEFORMS
#ifdef sgi
  { char *fname;
  fname = fl_show_file_selector("Give name of AMBER file:  ","","*.pdb","");
  if(fname == NULL) 
    text[0] = '\0';
      else
        strncpy(text,fname,BUFF_LEN);}
#endif
#else
    dialog4("Reading Brookhaven file","Give name of AMBER file:  ",text);
#endif
     if(text[0] == '\0') return;
    strncpy(input_file,text,BUFF_LEN);
      strncpy(Cline,"read coord amber ",BUFF_LEN);
       strncat(Cline,text,(BUFF_LEN - strlen(Cline)));
       strncpy(bottom_line,"Reading AMBER file ...",PORTchar);
       going_on();
      send_command(Cline);
    return;

#else

    printf("?ERROR - not implemented on this device \n");

#endif

}

/*************************************************************************/
int read_amber(inp_file)  /* Brookhaven format file reader */
    char inp_file[];
/*************************************************************************/
{

/*  externals                                      */
   extern int numat,*res1,*res2;
   extern float *x,*y,*z,*bvalue;
   extern char  *resnam,*atnam,*segment;
   extern int MAXatom;
/*                                                 */

 char inputl[AMBER_LINE_LEN];   /* input line */
 char ident[BUFF_LEN];              /* tag at the beginning of line */

 char tmp_atm[BUFF_LEN];
 char tmp_res[BUFF_LEN];

 char OutText[BUFF_LEN];

 float TXc,TYc,TZc,TBv;
 int   TRs1,TRs2;

static int tatomn,tres1,tres2;
static int i,j,k,loop,step;
static int type_warning;


FILE *amber_in;

   type_warning = 0;

      amber_in=fopen(inp_file,"r");
       if(amber_in == NULL) {
        sprintf(OutText,"Can't open input file : %s",inp_file);
        PrintMessage(OutText);
        return(1);
       }

      sprintf(OutText,"********** Reading : %s **********",input_file);
      PrintMessage(OutText);

/*
      Start reading file
      Tags recogniced by this routine are:

      ATOM:   Atom coordinate records for "standard groups"
      HETATM: Atom coordinate records for "non-standard" groups
      END:    End-of-entry record
*/

      i = StartIndexStructList();

/* text label */
       fgets(inputl,AMBER_LINE_LEN,amber_in);
       PrintMessage(inputl);

/* read number of atoms */
       fgets(inputl,AMBER_LINE_LEN,amber_in);
       sscanf(inputl,"%d",&numat);

       loop = 0;

       while(fgets(inputl,AMBER_LINE_LEN,amber_in) != NULL) { 

/* ATOM and HETATM */
        if((strncmp(inputl,"ATOM",4)   == 0) ||
           (strncmp(inputl,"HETATM",6) == 0) ) { /*start atom or hetatm*/

      j = PutAtmName((inputl+12) , i);
      j = PutResName((inputl+17) , i);
      j = PutSegName((inputl+21) , i);

        sscanf(inputl+22,"%d",&TRs1);
      j = PutResNum1(TRs1 , i);
      j = PutResNum2(TRs1 , i);
        sscanf(inputl+30,"%f %f %f",&TXc,&TYc,&TZc);
      j = PutXCoord(TXc , i);
       j = PutYCoord(TYc , i);
        j = PutZCoord(TZc , i);
        sscanf(inputl+60,"%f",&TBv);
      j = PutBValue(TBv , i);
       j = PutAtmCharge( 0.0 , i);

        if(inputl[21] == ' ')
             PutSegName("S1",i);

         i++;
         loop++;

        if(i == MAXatom) {
        PrintMessage("?ERROR - max atoms reached");
        return(1);}

         continue; } /*end atom*/

/* END */
        if(strncmp(inputl,"END",3) == 0) break; /*the end*/

     }

       update_mlist(loop);

/* check that res1 is in an increasing order */
/*
     step = 0;
     for(i = mlists[mlist_deep - 1] + 1 ; i < mliste[mlist_deep - 1] ; i++) {
     if(res2[i] >= res2[i-1]) {
     res1[i] = res2[i] + step; continue;}
     step =  res1[i-1];  
     res1[i] = step + 1;}

     for(i = mlists[mlist_deep - 1] ; i < mliste[mlist_deep - 1] ; i++) 
         printf("%d '%s'-'%s'-'%s'\n",(i+1),segment+4*i,resnam+4*i,atnam+4*i);
*/
      if(numat > 0) {
        if(numat != loop) {
           PrintMessage("?WARNING - number of atoms defined do not match real number");
	 }}

      PrintMessage("**********   Done   **********");

     fclose(amber_in);

     return(0);

}
