/*  

                       Copyright (c) 1990 by:
        Leif Laaksonen , VTT/Biotechnical laboratory, ESPOO, FINLAND
            Confidential unpublished property of Leif Laaksonen
                        All rights reserved
  

*/

#include <stdio.h>
#include <string.h>
#include <math.h>
#ifdef sgi
#include <gl/gl.h>
#endif

#include "maxdefs.h"

/*

   Leif Laaksonen 1990

*/

     extern int mlist_deep;      /* stack number indicator */
     extern int mlists[MAX_MLIST]; /* First index for molecule list */
     extern int mliste[MAX_MLIST]; /* Second index for molecule list */
     extern char mnlist[MAX_MLIST][BUFF_LEN]; 
                                /* name list for molecule file names */
     extern int b_disp_a;  /* display style 0 => "soft" 1 => half */

/*  externals */ 

   extern int numat;
   extern short BLACKv[3],BLUEv[3],CYANv[3];
   extern int **atmcol;
   extern int **cnct;
   extern char *disp_list;

   extern float *x,*y,*z;


/***********************************************************************/
plot_stick()  /* Plot molecule as sticks */
/***********************************************************************/
{

   register int i,j,k,l;
   static float vec[9];
   register float *vec_run;
   static int *cnct_run;
   static char *disp_run;
   static int first,last;

#ifdef sgi

   disp_run = disp_list;

   first = 0;
   last  = mliste[mlist_deep - 1];


   if(b_disp_a == 0) {

   for(i = first ; i < last ; i++ ) { /* main loop over atoms */

       if(*disp_run++ != 1) continue;  /* look into display list */

       c3s(CYANv); /* default colour */

   cnct_run = cnct[i];

   l = *cnct_run++;

        vec_run = vec;

        *vec_run++ = x[i]; /* coordinates of the first point */
         *vec_run++ = y[i];
          *vec_run++ = z[i];

       switch(l) { /* check if the atom is connected */

       case 0: /* no connections */
  
               c3i(&atmcol[i][0]);
               plot_cross(x[i],y[i],z[i]);
               break;

	case 4: /* four bonded atoms  */

             vec_run = &vec[3];
                k = *cnct_run++; 
                if(k < i) {;     /* avoid counting the bond twice */
      if(disp_list[k] != 0) {
      bgnline();
              c3i(&atmcol[i][0]);
              v3f(&vec[0]);

       *vec_run++   = x[k]; /* second point */
        *vec_run++  = y[k];
         *vec_run   = z[k];
  
              c3i(&atmcol[k][0]);
              v3f(&vec[3]);
      endline();}}

	case 3: /* three bonded atoms */

             vec_run = &vec[3];
                k = *cnct_run++; 
                if(k < i) {;     /* avoid counting the bond twice */
      if(disp_list[k] != 0) {
      bgnline();
              c3i(&atmcol[i][0]);
              v3f(&vec[0]);

       *vec_run++   = x[k]; /* second point */
        *vec_run++  = y[k];
         *vec_run   = z[k];
  
              c3i(&atmcol[k][0]);
              v3f(&vec[3]);
      endline();}}

	case 2: /* two bonded atoms */

             vec_run = &vec[3];
                k = *cnct_run++; /* one of two */
                if(k < i) {;     /* avoid counting the bond twice */
      if(disp_list[k] != 0) {
      bgnline();
              c3i(&atmcol[i][0]);
              v3f(&vec[0]);

       *vec_run++   = x[k]; /* second point */
        *vec_run++  = y[k];
         *vec_run   = z[k];
  
              c3i(&atmcol[k][0]);
              v3f(&vec[3]);
      endline();}}

        case 1: /* one bonded atom */

             vec_run = &vec[3];
                k = *cnct_run;
                if(k > i) break;     /* avoid counting the bond twice */
      if(disp_list[k] != 0) {
      bgnline();
              c3i(&atmcol[i][0]);
              v3f(&vec[0]);

       *vec_run++   = x[k]; /* second point */
        *vec_run++  = y[k];
         *vec_run   = z[k];
  
              c3i(&atmcol[k][0]);
              v3f(&vec[3]);
      endline();}
              break;

	default: /* rest of the bonds */

             for( j = 1 ; j <= l ; j ++) {

             vec_run = &vec[3];
  
              k = *cnct_run++; 
        if(k > i) continue;     /* avoid counting the bond twice */

      if(disp_list[k] == 0) continue;

      bgnline();
               c3i(&atmcol[i][0]);
               v3f(&vec[0]);

        *vec_run++  = x[k]; /* second point */
         *vec_run++ = y[k];
          *vec_run  = z[k];
  
               c3i(&atmcol[k][0]);
               v3f(&vec[3]);
      endline(); }


     } 

     }}

     if(b_disp_a == 1) {


   for(i = first ; i < last ; i++ ) { /* main loop over atoms */

       if(*disp_run++ != 1) continue;  /* look into display list */

       c3s(CYANv); /* default colour */

   cnct_run = cnct[i];

   l = *cnct_run++;

        vec_run = vec;

        *vec_run++ = x[i]; /* coordinates of the first point */
         *vec_run++ = y[i];
          *vec_run++ = z[i];

       switch(l) { /* check if the atom is connected */

       case 0: /* no connections */
  
               c3i(&atmcol[i][0]);
               plot_cross(x[i],y[i],z[i]);
               break;

	case 4: /* four bonded atoms  */

             vec_run = &vec[3];
                k = *cnct_run++; 
                if(k < i) {;     /* avoid counting the bond twice */
      if(disp_list[k] != 0) {
      bgnline();
              c3i(&atmcol[i][0]);
              v3f(&vec[0]);

       *vec_run++     = (x[k] + x[i]) / 2.; /* second point */
        *vec_run++    = (y[k] + y[i]) / 2.;
         *vec_run++   = (z[k] + z[i]) / 2.;
  
              c3i(&atmcol[i][0]);
              v3f(&vec[3]);
      endline();

      bgnline();
              c3i(&atmcol[k][0]);
              v3f(&vec[3]);

       *vec_run++   = x[k]; /* second point */
        *vec_run++  = y[k];
         *vec_run   = z[k];
  
              c3i(&atmcol[k][0]);
              v3f(&vec[6]);
      endline();}}


	case 3: /* three bonded atoms */

             vec_run = &vec[3];
                k = *cnct_run++; 
                if(k < i) {;     /* avoid counting the bond twice */
      if(disp_list[k] != 0) {
      bgnline();
              c3i(&atmcol[i][0]);
              v3f(&vec[0]);

       *vec_run++     = (x[k] + x[i]) / 2.; /* second point */
        *vec_run++    = (y[k] + y[i]) / 2.;
         *vec_run++   = (z[k] + z[i]) / 2.;
  
              c3i(&atmcol[i][0]);
              v3f(&vec[3]);
      endline();

      bgnline();
              c3i(&atmcol[k][0]);
              v3f(&vec[3]);

       *vec_run++   = x[k]; /* second point */
        *vec_run++  = y[k];
         *vec_run   = z[k];
  
              c3i(&atmcol[k][0]);
              v3f(&vec[6]);
      endline();}}

	case 2: /* two bonded atoms */

             vec_run = &vec[3];
                k = *cnct_run++; 
                if(k < i) {;     /* avoid counting the bond twice */
      if(disp_list[k] != 0) {
      bgnline();
              c3i(&atmcol[i][0]);
              v3f(&vec[0]);

       *vec_run++     = (x[k] + x[i]) / 2.; /* second point */
        *vec_run++    = (y[k] + y[i]) / 2.;
         *vec_run++   = (z[k] + z[i]) / 2.;
  
              c3i(&atmcol[i][0]);
              v3f(&vec[3]);
      endline();

      bgnline();
              c3i(&atmcol[k][0]);
              v3f(&vec[3]);

       *vec_run++   = x[k]; /* second point */
        *vec_run++  = y[k];
         *vec_run   = z[k];
  
              c3i(&atmcol[k][0]);
              v3f(&vec[6]);
      endline();}}

        case 1: /* one bonded atom */

             vec_run = &vec[3];
                k = *cnct_run;
                if(k > i) break;     /* avoid counting the bond twice */
      if(disp_list[k] != 0) {
      bgnline();
              c3i(&atmcol[i][0]);
              v3f(&vec[0]);

       *vec_run++     = (x[k] + x[i]) / 2.; /* second point */
        *vec_run++    = (y[k] + y[i]) / 2.;
         *vec_run++   = (z[k] + z[i]) / 2.;

              c3i(&atmcol[i][0]);
              v3f(&vec[3]);
      endline();

      bgnline();
  
              c3i(&atmcol[k][0]);
              v3f(&vec[3]);

       *vec_run++   = x[k]; /* second point */
        *vec_run++  = y[k];
         *vec_run   = z[k];
  
              c3i(&atmcol[k][0]);
              v3f(&vec[6]);
      endline();}
              break;

	default: /* rest of the bonds */

             for( j = 1 ; j <= l ; j ++) {

             vec_run = &vec[3];
  
              k = *cnct_run++; 
        if(k > i) continue;     /* avoid counting the bond twice */

      if(disp_list[k] == 0) continue;

      bgnline();
               c3i(&atmcol[i][0]);
               v3f(&vec[0]);

       *vec_run++     = (x[k] + x[i]) / 2.; /* second point */
        *vec_run++    = (y[k] + y[i]) / 2.;
         *vec_run++   = (z[k] + z[i]) / 2.;

              c3i(&atmcol[i][0]);
              v3f(&vec[3]);
      endline();

      bgnline();

              c3i(&atmcol[k][0]);
              v3f(&vec[3]);

        *vec_run++  = x[k]; /* second point */
         *vec_run++ = y[k];
          *vec_run  = z[k];

               c3i(&atmcol[k][0]);
               v3f(&vec[6]);
      endline(); }


     } 

     }}
#else

    printf("?ERROR - not implemented on this device \n");

#endif
 }

