/*  

                       Copyright (c) 1990 by:
        Leif Laaksonen , VTT/Biotechnical laboratory, ESPOO, FINLAND
            Confidential unpublished property of Leif Laaksonen
                        All rights reserved
  

*/

#include <stdio.h>
#include <string.h>

#ifdef sgi
#include <gl/gl.h>
#endif

#include "maxdefs.h"

#define PLOT_X_SIZE       30
#define PLOT_Y_TOP        40
#define PLOT_Y_BOT        40
#define PLOT_SIZE_LIMIT   100

     extern int mlist_deep;      /* stack number indicator */
     extern int mlists[MAX_MLIST]; /* First index for molecule list */
     extern int mliste[MAX_MLIST]; /* Second index for molecule list */
     extern char mnlist[MAX_MLIST][BUFF_LEN]; 
                                /* name list for molecule file names */

     extern void  MakeOrtho();
     extern float near,far;
     extern short BLACKv[];
     extern YELLOWv[];
     extern short obcolor[];
     extern short bgcolor[];
     extern short line_width;
     extern int rama_plot_char;
     extern char mnlist[MAX_MLIST][BUFF_LEN];
     extern short txcolor[];
     extern void PrintMessage();
     extern int show_text();
     extern int check_pow_2();
     extern int disp_obj[];
     extern int num_ka;
     extern char *nam_ka3;
     extern char *nam_ka1;
     extern char *atnam;
     extern char *resnam;
     extern char *segment;
     extern float rotB[][4];
     extern float idmat[][4];

    extern struct {
      int corr_wind;   /* switch to indicate that window is on = 1 , off = 0 */
      int corr_vec1;   /* number of correlation vector 1 */
      int corr_vec2;   /* number of correlation vector 2 */
      int corr_obs;    /* number of points in vectors 1 and 2 */
      float *corr_val;} /* pointer to the values  correlation values */  
    corr_info;

/* pointers for force calculation */

     extern struct force_struct {
     int    set;  /* switch if the forces are set = 0 , not != 0, yes */
     int   plot;  /* switch for a plot = 0 , no plot , != 0 a plot */
     float  *fx;  /* pointers to the forces */
     float  *fy;
     float  *fz;
     int *sel_list; /* selection list */
     int  ent_list; /* entries in the selection list */
     float scale; /* scale factor */
     int   maxfi; /* index of max force atom */
     float maxfa; /* value of the max force  */
     int   minfi; /* index on min force atom */
     float minfa; /* value of the min force  */ } atm_force; 

    extern struct {
    int plot_color_scale; /* = 0 , off , != 0 on */
    int which_plot;       /* = 0 no plot,
                               1 force plot,
                               2 energy scale
                               3 total energy
                               4 kinetic energy
                               5 potential energy
                               6 temperature
                          */
    int num_level; } scale_plot;

     extern struct {
       int set;          /* = 0 , colouring not set , > 0 colouring set */
       float max;
       float min;}   charge_color;

   extern struct et {
   int step_nr;
   float time_in_fs;
   float tote;
   float kine;
   float pote;
   float temp;
   float bond;
   float angl;
   float dihe;
   float impr;
   float vdw;
   float elec;
   float hbond;
   float charm; };

   extern struct et *traj_energy;


   struct {
    int   tote_set;
    int   kine_set;
    int   pote_set;
    int   temp_set;
    int   bond_set;
    int   angl_set;
    int   dihe_set;
    int   impr_set;
    int   vdw_set;
    int   elec_set;
    int   hbond_set;
    int   charm_set;
   float min_tote;
   float max_tote;
   float min_kine;
   float max_kine;
   float min_pote;
   float max_pote;
   float min_temp;
   float max_temp;
   float min_bond;
   float max_bond;
   float min_angl;
   float max_angl;
   float min_dihe;
   float max_dihe;
   float min_impr;
   float max_impr;
   float min_vdw;
   float max_vdw;
   float min_elec;
   float max_elec;
   float min_hbond;
   float max_hbond;
   float min_charm;
   float max_charm; } traj_energy_limits ;

     extern  struct {
       int    Mean;                   /* != 0 average is calulated  */
       int    Plot;                   /* != 0 plot is on            */
       int    Set;                    /* != 0 collection is on      */
       int    Numbers;                /* number of observations     */
       float *XValues;                /* X - pointer to values      */
       float *YValues;                /* Y - pointer to values      */
     } RaDiFu;

/*
      Scarecrow is using the following Projection Transformations

      0 => Scarecrow is using ortho
      1 =>                    perspective
*/
      extern struct Projection {
       int Fovy;           /* in tenths of degrees */
       int Transformation; } Model;


/*************************************************************************/
plot_2d(where,tag,num_obs,obs_vec)

   int tag;      /* if tag != neg value place a tag for observation num tag */
   int where;    /* code for placing the 2d plot in the window */
   int num_obs;  /* numbers of observations */
   float *obs_vec; /* array with the observations */

/* there are no values for the x-axis coming in because the observations
   are plotted against the conformation number */
/*************************************************************************/

{

   extern long xsize,ysize,xorg,yorg;
   extern int deep;
   extern float near,far;
   extern float *trax,*tray,*traz;

   long chr_hight,space_for1,space_for2;
   int i;
   static float step1,step2,maxo,mino;
   static float vec_2d[4];
   static float xmin,xmax,ymin,ymax;
   static float xm1,xm2,ym1,ym2;
   static float s1,s2,s3;
   static float RotS[4][4];
   char text[BUFF_LEN];

/* look for min/max */

   maxo = -1.e+30;
    mino = 1.e+30;
   for(i=0;i<num_obs;i++) {

   mino = ( obs_vec[i] < mino ? obs_vec[i] : mino );
   maxo = ( obs_vec[i] > maxo ? obs_vec[i] : maxo ); }

   switch(where) {

/* The window is numbered in the following way 

    1  I  2
    -------
    3  I  4

*/

   case 1: xmin = 1.;
           xmax = num_obs + (num_obs-1);
           ymin = mino - (maxo - mino);
           ymax = maxo;
           xm1 = xmin;
           s1 = ym1 = ymin + (ymax - ymin)/2.;
           s3 = xm2 = xmin + (xmax - xmin)/2.;
           s2 = ym2 = ymax;
           break;

   case 2: xmin = 1. - (num_obs-1);
           xmax = num_obs;
           ymin = mino - (maxo - mino);
           ymax = maxo;
           s1 = ym1 = ymin + (ymax - ymin)/2.;
           xm1 = xmin + (xmax - xmin)/2.;
           s3 = xm2 = xmax;
           s2 = ym2 = ymax;
           break;

   case 3: xmin = 1.;
           xmax = num_obs + (num_obs-1);
           ymin = mino;
           ymax = maxo + (maxo - mino);
           xm1 = xmin;
           s1 = ym1 = ymin;
           s2 = ym2 = ymin + (ymax - ymin)/2.;
           s2 = xm2 = xmin + (xmax - xmin)/2.;
           break;

   case 4: xmin = 1. - (num_obs-1);
           xmax = num_obs;
           ymin = mino;
           ymax = maxo + (maxo - mino);
           xm1 = xmin + (xmax - xmin)/2.;
           s1 = ym1 = ymin;
           s2 = xm2 = xmax;
           s2 = ym2 = ymin + (ymax - ymin)/2.;
           break;
   }

#ifdef sgi

     if(line_width > 2) linewidth(line_width);
     else
     linewidth(2);
/*
   bgnpolygon();
    vec_2d[0] = xmin;
     vec_2d[1] = ymin;
      v2f(vec_2d);
    vec_2d[0] = xmax;
     vec_2d[1} = ymin;
      v2f(vec_2d);
    vec_2d[0] = xmax;
     vec_2d[1] = ymax;
      v2f(vec_2d);
    vec_2d[0] = xmin;
     vec_2d[1] = ymax;
      v2f(vec_2d);
   endpoygon();
*/


/* determine size of window and lower left corner */

   getsize(&xsize,&ysize);
   getorigin(&xorg,&yorg);

/* determine hight of character font  */

   chr_hight = getheight();
   space_for1 = ysize / chr_hight; /* space for lines */
   space_for2 = xsize / chr_hight; /* space for lines */
   step1 = (far-near)/(float)(space_for1);
   step2 = (far-near)/(float)(space_for2);

   pushmatrix();
   loadmatrix(idmat);
   translate(trax[1],tray[1],traz[1]);
   zbuffer(FALSE);
   c3s(obcolor);
     loctow1(xmin,xmax,ymin,ymax,&xm1,&ym1);
     loctow1(xmin,xmax,ymin,ymax,&xm2,&ym2);
   rect(xm1,ym1,xm2,ym2);
   sprintf(text,"%.2f",s1);
   cmov2(xm1-4.*step2,ym1); charstr(text);
   sprintf(text,"%.2f",s2);
   cmov2(xm1-4.*step2,ym2-step1); charstr(text);
   sprintf(text,"%4.f",s3);
   cmov2(xm2-4.*step2,ym1-step1); charstr(text);

/* place ticks on the axes */
    for(i = 0 ; i < 10 ; i++) {
      bgnline();
      vec_2d[0] = xm1 + i * (xm2 - xm1)/10.;
      vec_2d[1] = ym1;
      v2f(vec_2d);
      vec_2d[1] = ym1 + (ym2 - ym1)/100.;
      v2f(vec_2d);
      endline();
     }
    for(i = 0 ; i < 10 ; i++) {
      bgnline();
      vec_2d[0] = xm1;
      vec_2d[1] = ym1 + i * (ym2 - ym1)/10.;
      v2f(vec_2d);
      vec_2d[0] = xm1 + (xm2 - xm1)/100.;
      v2f(vec_2d);
      endline();
     }


   c3s(obcolor);

    for(i = 0 ; i < num_obs-1 ; i++) {

     bgnline();
    xm1 = (float)(i+1);
    ym1 = obs_vec[i]; 
    loctow1(xmin,xmax,ymin,ymax,&xm1,&ym1);
      vec_2d[0] = xm1;
       vec_2d[1] = ym1;
        v2f(vec_2d);
    xm1 = (float)(i+2);
    ym1 = obs_vec[i+1]; 
    loctow1(xmin,xmax,ymin,ymax,&xm1,&ym1);
      vec_2d[2] = xm1;
       vec_2d[3] = ym1;
        v2f(&vec_2d[2]);
     endline();}

/* plot zero line */
   if((maxo*mino) < 0.0) {
    xm1 = 1.0;
    ym1 = 0.0; 
    loctow1(xmin,xmax,ymin,ymax,&xm1,&ym1);
    bgnline();
    vec_2d[0] = xm1;
     vec_2d[1] = ym1;
      v2f(vec_2d);
    xm1 = num_obs;
    ym1 = 0.0; 
    loctow1(xmin,xmax,ymin,ymax,&xm1,&ym1);
    vec_2d[0] = xm1;
     vec_2d[1] = ym1;
      v2f(vec_2d);
    endline();}

    if(tag >= 0 ) {
    c3s(YELLOWv);
    xm1 = (float)(tag+1);
    ym1 = obs_vec[tag]; 
    loctow1(xmin,xmax,ymin,ymax,&xm1,&ym1);
    cmov2( xm1 , ym1);
    charstr("+");}


   popmatrix();
   zbuffer(TRUE);

   linewidth(line_width);
#else
   PrintMessage("?ERROR - not implemented ");
#endif


}

/************************************************************************/
loctow1( xmin , xmax ,
         ymin , ymax ,
         xpoint , ypoint ) /* transforms a point in the axis
                                        x: xmin -> xmax 
                                        y: ymin -> ymax 
                                     to the working coordinate system */
     float xmin,xmax;
     float ymin,ymax;
     float *xpoint;
     float *ypoint;
/************************************************************************/
{

     extern float near,far;

     static float delta;
     static float delta1;
     static float delta2;
     static long Xwind;
     static long Ywind;

     register float GlobalScale;

     getsize(&Xwind , &Ywind);

     GlobalScale = (float)Xwind / (float)Ywind;

     delta = far - near;
     delta1= xmax - xmin;
     delta2= ymax - ymin;

     *xpoint = GlobalScale * (((*xpoint) - xmin)/delta1 * delta + near) ;
     *ypoint =                ((*ypoint) - ymin)/delta2 * delta + near ;

}
/*************************************************************************/
plot_2de(where,tag,num_obs,obsx_vec,obsy_vec) /* extended 2d-plotter */

   int tag;      /* if tag != neg value place a tag for observation num tag */
   int where;    /* code for placing the 2d plot in the window */
   int num_obs;  /* numbers of observations */
   float *obsx_vec; /* array with the x-observations */
   float *obsy_vec; /* array with the y-observations */

/*************************************************************************/

{

   extern long xsize,ysize,xorg,yorg;
   extern int deep;
   extern YELLOWv[3];
   extern float near,far;
   extern float rotB[][4];
   extern float *trax,*tray,*traz;

   long chr_hight,space_for1,space_for2;
   int i;
   static float step1,step2,xmaxo,xmino,ymaxo,ymino;
   static float vec_2d[4];
   static float xmin,xmax,ymin,ymax;
   static float xm1,xm2,ym1,ym2;
   static float s1,s2,s3;
   static float saveP[4][4];
   char text[BUFF_LEN];

/* look for min/max */

   xmaxo = 0.0;
    xmino = 1.e+30;
   ymaxo = 0.0;
    ymino = 1.e+30;
   for(i=0;i<num_obs;i++) {

   xmino = ( obsx_vec[i] < xmino ? obsx_vec[i] : xmino );
   xmaxo = ( obsx_vec[i] > xmaxo ? obsx_vec[i] : xmaxo ); 

   ymino = ( obsy_vec[i] < ymino ? obsy_vec[i] : ymino );
   ymaxo = ( obsy_vec[i] > ymaxo ? obsy_vec[i] : ymaxo ); }

   switch(where) {

/* The window is numbered in the following way 

    1  I  2
    -------     
    3  I  4

*/

   case 1: xmin = xmino;
           xmax = xmino + (xmaxo - xmino);
           ymin = ymino - (ymaxo - ymino);
           ymax = ymaxo;
           xm1 = xmin;
           s1 = ym1 = ymin + (ymax - ymin)/2.;
           s3 = xm2 = xmin + (xmax - xmin)/2.;
           s2 = ym2 = ymax;
           break;

   case 2: xmin = xmino - (xmaxo - xmino);
           xmax = xmaxo;
           ymin = ymino - (ymaxo - ymino);
           ymax = ymaxo;
           s1 = ym1 = ymin + (ymax - ymin)/2.;
           xm1 = xmin + (xmax - xmin)/2.;
           s3 = xm2 = xmax;
           s2 = ym2 = ymax;
           break;

   case 3: xmin = xmino;
           xmax = xmaxo + (xmaxo - xmino);
           ymin = ymino;
           ymax = ymaxo + (ymaxo - ymino);
           xm1 = xmin;
           s1 = ym1 = ymin;
           s2 = ym2 = ymin + (ymax - ymin)/2.;
           s2 = xm2 = xmin + (xmax - xmin)/2.;
           break;

   case 4: xmin = xmino - (xmaxo - xmino);
           xmax = xmaxo;
           ymin = ymino;
           ymax = ymaxo + (ymaxo - ymino);
           xm1 = xmin + (xmax - xmin)/2.;
           s1 = ym1 = ymin;
           s2 = xm2 = xmax;
           s2 = ym2 = ymin + (ymax - ymin)/2.;
           break;
   }

#ifdef sgi

/*
   bgnpolygon();
    vec_2d[0] = xmin;
     vec_2d[1] = ymin;
      v2f(vec_2d);
    vec_2d[0] = xmax;
     vec_2d[1} = ymin;
      v2f(vec_2d);
    vec_2d[0] = xmax;
     vec_2d[1] = ymax;
      v2f(vec_2d);
    vec_2d[0] = xmin;
     vec_2d[1] = ymax;
      v2f(vec_2d);
   endpoygon();
*/


/* determine size of window and lower left corner */

   getsize(&xsize,&ysize);
   getorigin(&xorg,&yorg);

/* determine hight of character font  */

   chr_hight = getheight();
   space_for1 = ysize / chr_hight; /* space for lines */
   space_for2 = xsize / chr_hight; /* space for lines */
   step1 = (far-near)/(float)(space_for1);
   step2 = (far-near)/(float)(space_for2);

      if(Model.Transformation) {
        mmode(MPROJECTION);
        getmatrix(saveP);
        mmode(MVIEWING);}

   pushmatrix();
   loadmatrix(idmat);
   translate(trax[1],tray[1],traz[1]);
/*   ortho2( xmin , xmax , ymin , ymax ); */
/*   drawmode(OVERDRAW);*/
   frontbuffer(TRUE);
/*   gconfig();*/
   c3s(obcolor);
     loctow1(xmin,xmax,ymin,ymax,&xm1,&ym1);
     loctow1(xmin,xmax,ymin,ymax,&xm2,&ym2);
   rect(xm1,ym1,xm2,ym2);
   sprintf(text,"%.2f",s1);
   cmov2(xm1-4.*step2,ym1); charstr(text);
   sprintf(text,"%.2f",s2);
   cmov2(xm1-4.*step2,ym2-step1); charstr(text);
   sprintf(text,"%.2f",s3);
   cmov2(xm2-4.*step2,ym1-step1); charstr(text);

/* place ticks on the axes */
    for(i = 0 ; i < 10 ; i++) {
      bgnline();
      vec_2d[0] = xm1 + i * (xm2 - xm1)/10.;
      vec_2d[1] = ym1;
      v2f(vec_2d);
      vec_2d[1] = ym1 + (ym2 - ym1)/100.;
      v2f(vec_2d);
      endline();
     }
    for(i = 0 ; i < 10 ; i++) {
      bgnline();
      vec_2d[0] = xm1;
      vec_2d[1] = ym1 + i * (ym2 - ym1)/10.;
      v2f(vec_2d);
      vec_2d[0] = xm1 + (xm2 - xm1)/100.;
      v2f(vec_2d);
      endline();
     }

   c3s(obcolor);

    for(i = 0 ; i < num_obs-1 ; i++) {

     bgnline();
    xm1 = obsx_vec[i];
    ym1 = obsy_vec[i]; 
    loctow1(xmin,xmax,ymin,ymax,&xm1,&ym1);
      vec_2d[0] = xm1;
       vec_2d[1] = ym1;
        v2f(vec_2d);
    xm1 = obsx_vec[i+1];
    ym1 = obsy_vec[i+1]; 
    loctow1(xmin,xmax,ymin,ymax,&xm1,&ym1);
      vec_2d[2] = xm1;
       vec_2d[3] = ym1;
        v2f(&vec_2d[2]);
     endline();}

/* plot zero line */
   if((ymaxo*ymino) < 0.0) {
    xm1 = 1.0;
    ym1 = 0.0; 
    loctow1(xmin,xmax,ymin,ymax,&xm1,&ym1);
    bgnline();
    vec_2d[0] = xm1;
     vec_2d[1] = ym1;
      v2f(vec_2d);
    xm1 = num_obs;
    ym1 = 0.0; 
    loctow1(xmin,xmax,ymin,ymax,&xm1,&ym1);
    vec_2d[0] = xm1;
     vec_2d[1] = ym1;
      v2f(vec_2d);
    endline();}


    if(tag >= 0 ) {
    c3s(YELLOWv);
    xm1 = obsx_vec[tag]; 
    ym1 = obsy_vec[tag]; 
    loctow1(xmin,xmax,ymin,ymax,&xm1,&ym1);
    cmov2( xm1 , ym1);
    charstr("+");}

   frontbuffer(FALSE);

   popmatrix();

      if(Model.Transformation) {
        mmode(MPROJECTION);
        loadmatrix(saveP);
        mmode(MVIEWING);}

/*
   drawmode(NORMALDRAW);
   gconfig();
*/

#else
   PrintMessage("?ERROR - not implemented ");
#endif
}

/*************************************************************************/
pre_plot_corr()
/*************************************************************************/
{

     static int i,num;

     num = corr_info.corr_obs;


#ifdef sgi
     if(disp_obj[0]) /* use the lower space */
      plot_2d_fb(4,-1,num,corr_info.corr_val);
     else
      plot_2d_fb(2,-1,num,corr_info.corr_val);

#else
     PrintMessage("?ERROR - not implemented on this device ");
#endif

}

/*************************************************************************/
plot_2d_fb(where,tag,num_obs,obs_vec)

   int tag;      /* if tag != neg value place a tag for observation num tag */
   int where;    /* code for placing the 2d plot in the window */
   int num_obs;  /* numbers of observations */
   float *obs_vec; /* array with the observations */

/* there are no values for the x-axis coming in because the observations
   are plotted against the conformation number */
/*************************************************************************/

{

   extern long xsize,ysize,xorg,yorg;
   extern int deep;
   extern YELLOWv[3];
   extern float near,far;
   extern float rotB[][4];
   extern float *trax,*tray,*traz;

   long chr_hight,space_for1,space_for2;
   int i;
   static float step1,step2,maxo,mino;
   static float vec_2d[4];
   static float xmin,xmax,ymin,ymax;
   static float xm1,xm2,ym1,ym2;
   static float s1,s2,s3;
   static float saveP[4][4];
   char text[BUFF_LEN];

/* look for min/max */

   maxo = -1.e+30;
    mino = 1.e+30;
   for(i=0;i<num_obs;i++) {

   mino = ( obs_vec[i] < mino ? obs_vec[i] : mino );
   maxo = ( obs_vec[i] > maxo ? obs_vec[i] : maxo ); }

   switch(where) {

/* The window is numbered in the following way 

    1  I  2
    -------
    3  I  4

*/

   case 1: xmin = 1.;
           xmax = num_obs + (num_obs-1);
           ymin = mino - (maxo - mino);
           ymax = maxo;
           xm1 = xmin;
           s1 = ym1 = ymin + (ymax - ymin)/2.;
           s3 = xm2 = xmin + (xmax - xmin)/2.;
           s2 = ym2 = ymax;
           break;

   case 2: xmin = 1. - (num_obs-1);
           xmax = num_obs;
           ymin = mino - (maxo - mino);
           ymax = maxo;
           s1 = ym1 = ymin + (ymax - ymin)/2.;
           xm1 = xmin + (xmax - xmin)/2.;
           s3 = xm2 = xmax;
           s2 = ym2 = ymax;
           break;

   case 3: xmin = 1.;
           xmax = num_obs + (num_obs-1);
           ymin = mino;
           ymax = maxo + (maxo - mino);
           xm1 = xmin;
           s1 = ym1 = ymin;
           s2 = ym2 = ymin + (ymax - ymin)/2.;
           s2 = xm2 = xmin + (xmax - xmin)/2.;
           break;

   case 4: xmin = 1. - (num_obs-1);
           xmax = num_obs;
           ymin = mino;
           ymax = maxo + (maxo - mino);
           xm1 = xmin + (xmax - xmin)/2.;
           s1 = ym1 = ymin;
           s2 = xm2 = xmax;
           s2 = ym2 = ymin + (ymax - ymin)/2.;
           break;
   }

#ifdef sgi

     if(line_width > 2) linewidth(line_width);
     else
     linewidth(2);

/* determine size of window and lower left corner */

   getsize(&xsize,&ysize);
   getorigin(&xorg,&yorg);

/* determine hight of character font  */

   chr_hight = getheight();
   space_for1 = ysize / chr_hight; /* space for lines */
   space_for2 = xsize / chr_hight; /* space for lines */
   step1 = (far-near)/(float)(space_for1);
   step2 = (far-near)/(float)(space_for2);

      if(Model.Transformation) {
        mmode(MPROJECTION);
        getmatrix(saveP);
        mmode(MVIEWING);}

   pushmatrix();
   loadmatrix(idmat);
   translate(trax[1],tray[1],traz[1]);
   zbuffer(FALSE);
   c3s(obcolor);
     loctow1(xmin,xmax,ymin,ymax,&xm1,&ym1);
     loctow1(xmin,xmax,ymin,ymax,&xm2,&ym2);
   rect(xm1,ym1,xm2,ym2);
   sprintf(text,"%.2f",s1);
   cmov2(xm1-4.*step2,ym1); charstr(text);
   sprintf(text,"%.2f",s2);
   cmov2(xm1-4.*step2,ym2-step1); charstr(text);
   sprintf(text,"%4.f",s3);
   cmov2(xm2-2.*step2,ym1-step1); charstr(text);

/* place ticks on the axes */
    for(i = 0 ; i < 10 ; i++) {
      bgnline();
      vec_2d[0] = xm1 + i * (xm2 - xm1)/10.;
      vec_2d[1] = ym1;
      v2f(vec_2d);
      vec_2d[1] = ym1 + (ym2 - ym1)/100.;
      v2f(vec_2d);
      endline();
     }
    for(i = 0 ; i < 10 ; i++) {
      bgnline();
      vec_2d[0] = xm1;
      vec_2d[1] = ym1 + i * (ym2 - ym1)/10.;
      v2f(vec_2d);
      vec_2d[0] = xm1 + (xm2 - xm1)/100.;
      v2f(vec_2d);
      endline();
     }


   c3s(obcolor);

    for(i = 0 ; i < num_obs-1 ; i++) {

     bgnline();
    xm1 = (float)(i+1);
    ym1 = obs_vec[i]; 
    loctow1(xmin,xmax,ymin,ymax,&xm1,&ym1);
      vec_2d[0] = xm1;
       vec_2d[1] = ym1;
        v2f(vec_2d);
    xm1 = (float)(i+2);
    ym1 = obs_vec[i+1]; 
    loctow1(xmin,xmax,ymin,ymax,&xm1,&ym1);
      vec_2d[2] = xm1;
       vec_2d[3] = ym1;
        v2f(&vec_2d[2]);
     endline();}

/* plot zero line */
   if((maxo*mino) < 0.0) {
    xm1 = 1.0;
    ym1 = 0.0; 
    loctow1(xmin,xmax,ymin,ymax,&xm1,&ym1);
    bgnline();
    vec_2d[0] = xm1;
     vec_2d[1] = ym1;
      v2f(vec_2d);
    xm1 = num_obs;
    ym1 = 0.0; 
    loctow1(xmin,xmax,ymin,ymax,&xm1,&ym1);
    vec_2d[0] = xm1;
     vec_2d[1] = ym1;
      v2f(vec_2d);
    endline();}

    if(tag >= 0 ) {
    c3s(YELLOWv);
    xm1 = (float)(tag+1);
    ym1 = obs_vec[tag]; 
    loctow1(xmin,xmax,ymin,ymax,&xm1,&ym1);
    cmov2( xm1 , ym1);
    charstr("+");}

   popmatrix();

      if(Model.Transformation) {
        mmode(MPROJECTION);
        loadmatrix(saveP);
        mmode(MVIEWING);}

   zbuffer(TRUE);

   linewidth(line_width);

#else
   PrintMessage("?ERROR - not implemented ");
#endif

}
/*************************************************************************/
plot_rama(num_obs,obsx_vec,obsy_vec , x_start , y_start , resi_num) 
                                            /* plot a Ramachandran plot */

   int num_obs;  /* numbers of observations */
   float *obsx_vec; /* array with the x-observations */
   float *obsy_vec; /* array with the y-observations */
   int   x_start;   /* start residue number for x - value */
   int   y_start;   /* start residue number for y - value */
   int *resi_num;   /* residue numbers                    */

/*************************************************************************/

{

   extern long xsize,ysize,xorg,yorg;
   extern int deep;
   extern YELLOWv[3];
   extern float near,far;
   extern float rotB[][4];
   extern float *trax,*tray,*traz;

   static int i;
   static float xmin,xmax,ymin,ymax;
   static float xm1,xm2,ym1,ym2;
   static char text[BUFF_LEN];
   static float saveM[4][4];
   static float saveP[4][4];
   static float vec2[2];
   static char out_t[BUFF_LEN];
   

/*  min/max */

   xmax = 180.;
    xmin = -180.;
   ymax = 180.;
    ymin = -180.;

#ifdef sgi
     if(line_width > 2) linewidth(line_width);
     else
     linewidth(2);

      if(Model.Transformation) {
        mmode(MPROJECTION);
        getmatrix(saveP);
        mmode(MVIEWING);}

   getmatrix(saveM);
   pushmatrix();
   ortho2( xmin , xmax , ymin , ymax ); 
   loadmatrix(idmat);
/* select as backround the curent background colour */
   c3s(bgcolor);
   clear();
   zclear();

   c3s(obcolor);

    for(i = 0 ; i < num_obs-1 ; i++) {
    xm1 = obsx_vec[i]; 
    ym1 = obsy_vec[i+1]; 
    cmov2( xm1 , ym1);

    switch(rama_plot_char) {
   
    case 0:
          charstr("+");
          break;
    case 1:
          sprintf(out_t,"%-d",resi_num[i+1]);
          charstr(out_t);
          break;}
    }

    bgnline();
      vec2[0] = 0.0;
       vec2[1] = -180.;
      v2f(vec2);
      vec2[0] = 0.0;
       vec2[1] = 180.;
      v2f(vec2);
    endline();

    bgnline();
      vec2[0] = -180.;
       vec2[1] = 0.0;
      v2f(vec2);
      vec2[0] = 180.;
       vec2[1] = 0.0;
      v2f(vec2);
    endline();

    c3s(txcolor);
      cmov2(-90.0,-175.0);
      charstr("Input file name: ");
      charstr(mnlist[0]); /* gives always the name of the FIRST molecule */

    i = show_text("f","Symbol",txcolor,60.,0.6,0.05,BACKBUFFER); 
                  /* phi symbol */
    i = show_text("y","Symbol",txcolor,60.,0.05,0.6,BACKBUFFER); 
                  /* psi symbol */

   popmatrix();
   MakeOrtho();
   loadmatrix(saveM);

      if(Model.Transformation) {
        mmode(MPROJECTION);
        loadmatrix(saveP);
        mmode(MVIEWING);}

   linewidth(line_width);

#else
   PrintMessage("?ERROR - not implemented ");
#endif
}
/*************************************************************************/
plot_rama_trace() /* plot a Ramachandran trace plot */

/*************************************************************************/

{

   extern long xsize,ysize,xorg,yorg;
   extern int deep;
   extern YELLOWv[3];
   extern float near,far;
   extern float rotB[][4];
   extern float *trax,*tray,*traz;

   int i;
   static float xmin,xmax,ymin,ymax;
   static float xm1,xm2,ym1,ym2;
   static char text[BUFF_LEN];
   static float saveM[4][4];
   static float saveP[4][4];
   static float vec2[2];
   static char out_t[BUFF_LEN];

   static int num_obs;  /* numbers of observations */
   static float *obsx_vec; /* array with the x-observations */
   static float *obsy_vec; /* array with the y-observations */

/*  min/max */

   xmax = 180.;
    xmin = -180.;
   ymax = 180.;
    ymin = -180.;

#ifdef sgi
     if(line_width > 2) linewidth(line_width);
     else
     linewidth(2);

      if(Model.Transformation) {
        mmode(MPROJECTION);
        getmatrix(saveP);
        mmode(MVIEWING);}

   getmatrix(saveM);
   pushmatrix();
   ortho2( xmin , xmax , ymin , ymax ); 
   loadmatrix(idmat);
   c3s(BLACKv);
   clear();

   c3s(obcolor);

    for(i = 0 ; i < num_obs-1 ; i++) {
    xm1 = obsx_vec[i]; 
    ym1 = obsy_vec[i+1]; 
    cmov2( xm1 , ym1);

    switch(rama_plot_char) {
   
    case 0:
          charstr("+");
          break;
    case 1:
          sprintf(out_t,"%-d",(i+2));
          charstr(out_t);
          break;}
    }

    bgnline();
      vec2[0] = 0.0;
       vec2[1] = -180.;
      v2f(vec2);
      vec2[0] = 0.0;
       vec2[1] = 180.;
      v2f(vec2);
    endline();

    bgnline();
      vec2[0] = -180.;
       vec2[1] = 0.0;
      v2f(vec2);
      vec2[0] = 180.;
       vec2[1] = 0.0;
      v2f(vec2);
    endline();

    c3s(txcolor);
      cmov2(-90.0,-175.0);
      charstr("Input file name: ");
      charstr(mnlist[0]); /* gives always the name of the FIRST molecule */

    i = show_text("f","Symbol",txcolor,60.,0.6,0.05,BACKBUFFER); 
                  /* phi symbol */
    i = show_text("y","Symbol",txcolor,60.,0.05,0.6,BACKBUFFER); 
                  /* psi symbol */

   popmatrix();
   MakeOrtho();
   loadmatrix(saveM);

      if(Model.Transformation) {
        mmode(MPROJECTION);
        loadmatrix(saveP);
        mmode(MVIEWING);}

   linewidth(line_width);

#else
   PrintMessage("?ERROR - not implemented ");
#endif
}

/*************************************************************************/
disp_color_scale()
/*************************************************************************/
{

     int  x_step;
     long xsz,ysz,xlo,ylo;
     char text[BUFF_LEN];
     float RotT[4][4];
     float saveP[4][4];
     float co[2];
     float Range;

        float delta,delta1,mmin;
        double step;
        int i,rrggbb[3];

#ifdef sgi

      x_step = PLOT_X_SIZE;

      getmatrix(RotT);

      if(Model.Transformation) {
        mmode(MPROJECTION);
        getmatrix(saveP);
        mmode(MVIEWING);}

      getsize(&xsz,&ysz);
      getorigin(&xlo,&ylo);

/* check that there is space for the scale ... */
      if((ysz - PLOT_Y_BOT - PLOT_Y_TOP) < PLOT_SIZE_LIMIT) {
        PrintMessage("?ERROR - the window is too small for the scale plot ");
         return;}

     zbuffer(FALSE);

     ortho2( 1.0 , (float)xsz , 1.0 , (float)ysz );

     ysz = (ysz - PLOT_Y_BOT - PLOT_Y_TOP) / (scale_plot.num_level + 1);

     loadmatrix(idmat);

             delta = 1.0 / (float)(scale_plot.num_level);

     for(i = 0 ; i <= scale_plot.num_level ; i++) {

           step = (double)(i) * delta;;
           pre_rainbow(step,&rrggbb[0],&rrggbb[1],&rrggbb[2]);

           c3i(rrggbb);

     bgnpolygon();

      co[0] = 0.0;
      co[1] = (float)(i * ysz)     + PLOT_Y_BOT;

      v2f(co);

      co[0] = 0.0;
      co[1] = (float)(i*ysz + ysz) + PLOT_Y_BOT;

      v2f(co);

      co[0] = (float)(x_step);
      co[1] = (float)(i*ysz + ysz) + PLOT_Y_BOT;

      v2f(co);

      co[0] = (float)(x_step);
      co[1] = (float)(i * ysz) + PLOT_Y_BOT;

      v2f(co);

     endpolygon();
   }

    switch(scale_plot.which_plot) {

    case 0: 
       mmin  = 0.0;
       Range = 0.0;
    break;

    case 1:    
       mmin  = atm_force.minfa;
       Range = atm_force.maxfa - atm_force.minfa;
       break;

    case 2:
       mmin  = charge_color.min;
       Range = charge_color.max - charge_color.min;
       break;

    case 3:
        mmin  = traj_energy_limits.min_tote;
        Range = traj_energy_limits.max_tote - traj_energy_limits.min_tote;
        break;

    case 4:
        mmin  = traj_energy_limits.min_kine;
        Range = traj_energy_limits.max_kine - traj_energy_limits.min_kine;
        break;
  
    case 5:
        mmin  = traj_energy_limits.min_pote;
        Range = traj_energy_limits.max_pote - traj_energy_limits.min_pote;
        break;

    case 6:
        mmin  = traj_energy_limits.min_temp;
        Range = traj_energy_limits.max_temp - traj_energy_limits.min_temp;
        break;

    }

    for(i = 0 ; i <= scale_plot.num_level ; i++) {
      co[0] = (float)(x_step);
      co[1] = (float)((i + i + 1)*ysz)/2. + 1 + PLOT_Y_BOT;

           step = (double)(i) * delta ;
           pre_rainbow(step,&rrggbb[0],&rrggbb[1],&rrggbb[2]);
           c3i(rrggbb);

      delta1 = step * Range + mmin;
      sprintf(text," = %6.2e ",delta1);
      cmov2(co[0],co[1]);
      charstr(text);}

     MakeOrtho();

     loadmatrix(RotT); 

      if(Model.Transformation) {
        mmode(MPROJECTION);
        loadmatrix(saveP);
        mmode(MVIEWING);}

     zbuffer(TRUE);

#else 

   PrintMessage("?ERROR - not implemented on this device ");

#endif

}

/****************************************************************************/
PlotRDFcurve()
/****************************************************************************/
{

#ifdef sgi
   plot_2de( 2 , -1 , RaDiFu.Numbers , 
                      RaDiFu.XValues ,
                      RaDiFu.YValues );
#else
   PrintMessage("?ERROR - can't plot RDF on this device");
#endif
}
