/*  

                       Copyright (c) 1990, 1992 by:
        Leif Laaksonen , Center for Scientific Computing, ESPOO, FINLAND
            Confidential unpublished property of Leif Laaksonen
                        All rights reserved
  

*/

#include <stdio.h>
#include <string.h>
#include <math.h>
#include <ctype.h>
#include "maxdefs.h"

extern int check_frame_region();
extern int get_frame();
extern void PrintMessage();
extern short CheckEventQueue();
extern void send_command();
extern int TrajectoryLastFrame();
extern int TrajectoryFirstFrame();
extern int TrajectoryStepFrame();
extern int FramesInSet();
extern int  UpdateAllOpenWindows();
extern int  UpdateAllPlots();

     extern int numat;
     extern int current_struct;  /* current molecule number */
     extern float damp;
     extern int colour_structure_by;
     extern int alpha_trace;
     extern int mlist_deep;      /* stack number indicator */
     extern int mlists[MAX_MLIST]; /* First index for molecule list */
     extern int mliste[MAX_MLIST]; /* Second index for molecule list */
     extern char mnlist[MAX_MLIST][BUFF_LEN]; 
                                /* name list for molecule file names */


     extern int term_type;
     extern FILE *charmm_oc;
     extern char traj_file[BUFF_LEN];
     extern int traj_file_set;
     extern int dynamics_frames;
     extern int dynamics_pasback[20];
     extern float *x;
     extern float *y;
     extern float *z;
     extern float sumx,sumy,sumz;

/* structur containing pointers to dynamics display variables */
    extern struct dyna_disp_var {
      int numset;             /* number of sets (or variables) */
      int current_set;        /* index to current set          */
      int point_len;          /* length of point array         */
      int *point_vec;         /* pointer to point array        */
      int dist_len;           /* length of dist array          */
      int *dist_vec;          /* pointer to dist array         */
      int ang_len;            /* length of angle array         */
      int *ang_vec;           /* pointer to angle array        */
      int tors_len;           /* length of torsion array       */
      int *tors_vec;          /* pointer to torsion array      */
      int obs_vec_len;        /* observation array length      */
      int obs_vec_curr;       /* display current               */
      float *obs_vec;};       /* pointer to observation array  */

/* structure to contain information about window update */
   extern struct {
     int MainW;      /* Main window          */
     int LDPW;       /* Distance plot window */
     int Rama;       /* Ramachandran plot    */
     int Cluster;    /* Cluster plot         */
   } WUpdate;

    extern struct dyna_disp_var play_dynam_frames;

    extern int rama_wind;
    extern int draw_obj_disp;
    extern int rama_plot_char;
    extern int ldp_wind;

    extern int text_bottom;

/************************************************************************/
play_fac(input,num)   /* play command */
   char *input; 
   int num;
/************************************************************************/
{

     extern char parsed[MAXparse][MAXlinel];
     extern int numat;
     int i;
     char OutText[BUFF_LEN];

/* switch to small characters                 */
     toller(parsed[1]);

/* help play                               */
   if(indexo(parsed[1],"?") == 1) {
PrintMessage("play fram*es ifrom ito istep           ! Play dynamics frames ");
PrintMessage("     ldp     ifrom ito istep           ! Play ldp plots       ");
PrintMessage("     rama*chandran ifrom ito istep [symbol/number] ! Play Ramachandran plots"); 
   return;}

/* play  frames                                  */
   if(indexo(parsed[1],"fram") == 1) {
   if(term_type == 1 || term_type == 3) 
      play_dyn_frames(parsed[2],parsed[3],parsed[4]);
   else
      PrintMessage("?ERROR - not allowed from your terminal ");
   return;
   }

/* play ldp plots                                */
   if(indexo(parsed[1],"ldp") == 1) {
   if(term_type == 1 || term_type == 3) {
      ldp_wind = 1;
      WUpdate.LDPW  = 1;
      draw_obj_disp = 0;     
      play_dyn_ldp(parsed[2],parsed[3],parsed[4]);
         draw_obj_disp = 1;
         ldp_wind = 0;
         WUpdate.LDPW  = 0;
         send_command("set atom displ *:*:*");
         alpha_trace = 0;}
   else
      PrintMessage("?ERROR - not allowed from your terminal");
   return;
   }

/* play ramachandran plots                                */
   if(indexo(parsed[1],"rama") == 1) {
   if(term_type == 1 || term_type == 3) {
      rama_wind = 1;
      draw_obj_disp = 0;
      WUpdate.Rama = 1;
      play_dyn_rama(parsed[2],parsed[3],parsed[4],parsed[5]);
               rama_wind = 0;
               draw_obj_disp = 1;}
   else
      PrintMessage("?ERROR - not allowed from your terminal");
   return;
   }
     
/* default position "command not recognized"  */

     sprintf(OutText,"?ERROR: Following command not recognized: %s \n",input);
     PrintMessage(OutText);

}      /* end of play_fac */

/**************************************************************************/
play_dyn_frames(text1,text2,text3)
     char *text1; /* from frame */
     char *text2; /* to frame   */
     char *text3; /* step       */
/**************************************************************************/
{
     static int i,j;
     static int from_frame;
     static int to_frame;
     static int delta_frame;
     static char chelp[BUFF_LEN];
     static char OutText[BUFF_LEN];

#ifdef sgi

        if(dynamics_frames < 1) {
        PrintMessage("?ERROR - number of frames is not defined ");
        return;}
   
     if(text1[0] != '\0') {
        from_frame    = atoi(text1);
        to_frame      = atoi(text2);
        delta_frame   = atoi(text3);
        if(delta_frame < 1) delta_frame = 1;

/* check the boundaries */
      i = check_frame_region(&from_frame,&to_frame,&delta_frame);

      if(i > 0) return;
      }
      else {
        from_frame    = TrajectoryFirstFrame();
        to_frame      = TrajectoryLastFrame();
        delta_frame   = TrajectoryStepFrame();
      }
      
sprintf(OutText,"> Play dynamics frames, first frame: %d , last frame: %d , step: %d \n",from_frame,to_frame,delta_frame);
PrintMessage(OutText);

/* read dynamics frame                        */

        sprintf(OutText,"Total number of frames is: %d",dynamics_frames);
        PrintMessage(OutText);
         if(traj_file_set == 0) {
          sprintf(OutText,"?ERROR - no trajectory file name set");
          PrintMessage(OutText);
           return;}

        charmm_oc = fopen(traj_file,"r");

        if(charmm_oc == NULL) {
         sprintf("?ERROR - can't open trajectory file : %s",traj_file);
         PrintMessage(OutText);
        return;}


     text_bottom = 0; /* bottom text off */


/* main loop read in the frames */
        for(i = from_frame ; i <= to_frame ; i += delta_frame) {

/*look for user interrupt */
         if(CheckEventQueue()) break;
/*                        */
         sprintf(chelp,"Dyna frame nr: %d",i);
          strcpy(mnlist[mlist_deep],chelp); /* input name saved */

          current_struct = 0;
          mlist_deep = 0;  /* new structure , scrap the rest */
          play_dynam_frames.current_set = (i - 1);

           j = get_frame((i - 1), 0 );
           if(j < 0) {
             PrintMessage("?ERROR - problems in reading frames ");
             fclose(charmm_oc);
             return;}
           rewind(charmm_oc);

        vecsub(&x[0] , sumx , numat);
        vecsub(&y[0] , sumy , numat);
        vecsub(&z[0] , sumz , numat);

        if(traj_file_set == 4) atom_conn(mlist_deep);

/* bang it */
        (void)UpdateAllPlots();

        if(colour_structure_by) do_colouring((i - 1) , colour_structure_by);
        bang_it();
       }

        fclose(charmm_oc);

        text_bottom = 1; /* bottom text on */
        return;
#else

      PrintMessage("?ERROR - not implemented on this device ");
      return;
#endif

}
/**************************************************************************/
play_dyn_ldp(text1,text2,text3)
     char *text1; /* from frame */
     char *text2; /* to frame   */
     char *text3; /* step       */
/**************************************************************************/
{
     static int i,j;
     static int from_frame;
     static int to_frame;
     static int delta_frame;
     static char chelp[BUFF_LEN];
     static char save[BUFF_LEN];
     static char OutText[BUFF_LEN];

#ifdef sgi

        if(dynamics_frames < 1) {
        PrintMessage("?ERROR - number of frames is not defined");
        return;}

     if(text1[0] != '\0') {
        from_frame  = atoi(text1);
        to_frame    = atoi(text2);
        delta_frame = atoi(text3);
        if(delta_frame < 1) delta_frame = 1;

/* check the boundaries */
     i = check_frame_region(&from_frame,&to_frame,&delta_frame);

     if(i > 0) return;
     }
     else {
        from_frame    = TrajectoryFirstFrame();
        to_frame      = TrajectoryLastFrame();
        delta_frame   = TrajectoryStepFrame();
     }
     
sprintf(OutText,"> Play ldp frames, first frame: %d , last frame: %d , step: %d",from_frame,to_frame,delta_frame);
PrintMessage(OutText);

/* read dynamics frame                        */

        sprintf(OutText,"Total number of frames is: %d",dynamics_frames);
        PrintMessage(OutText);
         if(traj_file_set == 0) {
          PrintMessage("?ERROR - no trajectory file name set");
           return;}

        charmm_oc = fopen(traj_file,"r");

        if(charmm_oc == NULL) {
         sprintf(OutText,"?ERROR - can't open trajectory file : %s",traj_file);
         PrintMessage(OutText);
        return;}

          current_struct = 0;
          mlist_deep = 0;  /* new structure , scrap the rest */

          strncpy(save,mnlist[mlist_deep],BUFF_LEN); /* save old file name */

/* main loop read in the frames */
        for(i = from_frame ; i <= to_frame ; i += delta_frame) {

/*look for user interrupt */
         if(CheckEventQueue()) break;
/*                        */

          current_struct = 0;
          mlist_deep = 0;  /* new structure , scrap the rest */

         sprintf(chelp,"Dyna frame nr: %d",i);
          strncpy(mnlist[mlist_deep],chelp,BUFF_LEN); /* input name saved */

          play_dynam_frames.current_set = (i - 1);

           j = get_frame((i - 1), 0 );
           if(j < 0) {
             PrintMessage("?ERROR - problems in reading frames");
             fclose(charmm_oc);
             return;}
           rewind(charmm_oc);

        vecsub(&x[0] , sumx , numat);
        vecsub(&y[0] , sumy , numat);
        vecsub(&z[0] , sumz , numat);

/* bang it */
     ldp_wind = 1;
     draw_obj_disp = 0;
     text_bottom = 0; /* bottom text off */
     (void)UpdateAllPlots();
        bang_it(); /* the ldp plot */
       }

        fclose(charmm_oc);

     text_bottom = 1; /* bottom text on */
     strncpy(mnlist[mlist_deep - 1],save,BUFF_LEN); /* put old file name back */

        return;
#else

      PrintMessage("?ERROR - not implemented on this device ");
      return;
#endif

}
/**************************************************************************/
play_dyn_rama(text1,text2,text3,text4)
     char *text1; /* from frame */
     char *text2; /* to frame   */
     char *text3; /* step       */
     char *text4; /* symbol/number */
/**************************************************************************/
{
     static int i,j;
     static int from_frame;
     static int to_frame;
     static int delta_frame;
     static char chelp[BUFF_LEN];
     static char save[BUFF_LEN];
     static char OutText[BUFF_LEN];

#ifdef sgi

        if(dynamics_frames < 1) {
        PrintMessage("?ERROR - number of frames is not defined");
        return;}

       rama_plot_char = 0; /* default plot character */

     from_frame = atoi(text1);
     to_frame   = atoi(text2);

     if(isdigit(text3[0])) { /* ok step is given */
     delta_frame = atoi(text3);

       toller(text4);
       if(indexo(text4,"char") == 1) 
         rama_plot_char = 0;

       if(indexo(text4,"num") == 1) 
         rama_plot_char = 1;}
      else { /* step is not given */
       toller(text3);
       if(indexo(text3,"char") == 1) 
         rama_plot_char = 0;

       if(indexo(text3,"num") == 1) 
         rama_plot_char = 1;}

       if(delta_frame < 1) delta_frame = 1;

       if(from_frame == 0) {
          from_frame    = TrajectoryFirstFrame();
	  to_frame      = TrajectoryLastFrame();
	  delta_frame   = TrajectoryStepFrame();
       }
      
/* check the boundaries */
       i = check_frame_region(&from_frame,&to_frame,&delta_frame);

       if(i > 0) return;

sprintf(OutText,"> Play Ramachandran frames, first frame: %d , last frame: %d , step: %d",from_frame,to_frame,delta_frame);
PrintMessage(OutText);

/* read dynamics frame                        */

        sprintf(OutText,"Total number of frames is: %d",dynamics_frames);
        PrintMessage(OutText);
         if(traj_file_set == 0) {
          PrintMessage("?ERROR - no trajectory file name set");
           return;}

        charmm_oc = fopen(traj_file,"r");

        if(charmm_oc == NULL) {
         sprintf(OutText,"?ERROR - can't open trajectory file : %s",traj_file);
         PrintMessage(OutText);
        return;}

          current_struct = 0;
          mlist_deep = 0;  /* new structure , scrap the rest */

          strncpy(save,mnlist[mlist_deep],BUFF_LEN); /* save old file name */

/* main loop read in the frames */
        for(i = from_frame ; i <= to_frame ; i += delta_frame) {

/*look for user interrupt */
         if(CheckEventQueue()) break;
/*                        */

          current_struct = 0;
          mlist_deep = 0;  /* new structure , scrap the rest */

         sprintf(chelp,"Dyna frame nr: %d",i);
          strncpy(mnlist[mlist_deep],chelp,BUFF_LEN); /* input name saved */

          play_dynam_frames.current_set = (i - 1);

        sprintf(chelp,"Dyna frame nr: %d",i);
        strcpy(mnlist[mlist_deep],chelp); /* input name saved */

           j = get_frame((i - 1), 0 );
           if(j < 0) {
             PrintMessage("?ERROR - problems in reading frames");
             fclose(charmm_oc);
             return;}
           rewind(charmm_oc);

        vecsub(&x[0] , sumx , numat);
        vecsub(&y[0] , sumy , numat);
        vecsub(&z[0] , sumz , numat);

/* bang it */
       rama_wind = 1;
       draw_obj_disp = 0;
       text_bottom = 0; /* bottom text off */
       (void)UpdateAllPlots();
        bang_it();
       }

        fclose(charmm_oc);

    text_bottom = 1; /* bottom text on */
    strncpy(mnlist[mlist_deep - 1],save,BUFF_LEN); /* put old file name back */

        return;
#else

      PrintMessage("?ERROR - not implemented on this device");
      return;
#endif

}

















