
/*  

                       Copyright (c) 1990, 1992 by:
        Leif Laaksonen , Centre for Scientific Computing, ESPOO, FINLAND
            Confidential unpublished property of Leif Laaksonen
                        All rights reserved
  

*/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <sys/types.h>

#define BUFF_LEN 256

#define LBR  '['
#define RBR  ']'
#define LPA  '('
#define RPA  ')'
#define LCB  '{'
#define RCB  '}'
#define QUO  '\"'

char *own_strtok();
int TokenHook();
int TokenPause();

/******************************************************************************/
char *own_strtok(String1,String2)
      char *String1;              /* string to separate into tokens */
      char *String2;              /* separtator characters          */
/******************************************************************************/
{
      static int i;               /* loop counter               */
      static int FromLoop = 0;    /* index into the string      */
      static int SaveLen  = 0;    /* length of string           */
      static int StartLoop= 0;
      static int Hit      = 0;             
      register char TempChar;
      static   char *OutLoop;

      Hit = 0;

       if(String1 != NULL) {
          if(*String1 == '\0') return(NULL);
          SaveLen  = strlen(String1);
          if(SaveLen >= BUFF_LEN) 
                               return(NULL);

          OutLoop = String1;
          FromLoop = 0;
          StartLoop= 0;}
      else {
          if(FromLoop >= SaveLen) 
                                return(NULL);
          StartLoop = FromLoop;}

      for(i = FromLoop ; i < SaveLen ; i++) 
        {

          if((TempChar = OutLoop[i]) == NULL) 
                                              return(OutLoop+StartLoop);

          if(TokenPause(TempChar)) 
	    {
               Hit = 1;
               continue;}

            if(TokenHook(TempChar,String2)) 
               {
                  if(Hit) 
                         {
                         OutLoop[i] = '\0';
                         FromLoop   = i + 1;
                         return(OutLoop+StartLoop);
                         }
                   else
                         StartLoop++;
               }
            else 
              {
               Hit = 1;
              }
	}
        if(OutLoop[StartLoop] == '\0') 
                                return(NULL);
        FromLoop = i + 1;
        return(OutLoop+StartLoop);
}
/******************************************************************************/
int TokenHook(CheckChar,StringHook)
           char  CheckChar;
           char *StringHook;
/******************************************************************************/
{
    register int i;
    register int j;

    j = strlen(StringHook);

    for(i = 0 ; i < j ; i++) 
      {
       if(CheckChar == StringHook[i]) return(1);
      }
    return(0);
  }
/******************************************************************************/
int TokenPause(CheckChar)
    char CheckChar;
/******************************************************************************/
{
    static int InBr  = 0;
    static int InPa  = 0;
    static int InCBr = 0;
    static int InQu  = 0;

    if(CheckChar == LBR) InBr++;    
     if(CheckChar == RBR) InBr--;

    if(CheckChar == LPA) InPa++;    
     if(CheckChar == RPA) InPa--;

    if(CheckChar == LCB) InCBr++;    
     if(CheckChar == RCB) InCBr--;

    if(CheckChar == QUO) InQu = (InQu == 0) ? 1 : 0;    

    return(InBr | InPa | InCBr | InQu);
  }
