
/* FULL LIST OF KEYWORDS USED IN MOPAC5  */

   char *mopac5_key[] = {
       "0SCF",      /* READ IN DATA, THEN STOP */
       "1ELECTRON", /* PRINT FINAL ONE-ELECTRON MATRIX */
       "1SCF"     , /* DO ONE SCF AND THEN STOP */
       "ANALYT"   , /* USE ANALYTICAL DERIVATIVES OF ENERGY W.R.T. GEOMETRY */
       "AM1"      , /* USE THE AM1 HAMILTONIAN */
       "BAR"      , /* =n.n  - REDUCE BAR LENGTH BY A MAXIMUM OF n.n */
       "BIRADICAL", /* SYSTEM HAS TWO UNPAIRED ELECTRONS */
       "BONDS"    , /* PRINT FINAL BOND-ORDER MATRIX */
       "C.I."     , /* A MULTI-ELECTRON CONFIGURATION INTERACTION SPECIFIED */
       "CHARGE"   , /* =n - CHARGE ON SYSTEM = n (e.g. NH4 => CHARGE=1) */
       "COMPFG"   , /* PRINT HEAT OF FORMATION CALCULATED IN COMPFG */
       "CYCLES"   , /* PERFORM MAXIMUM NUMBER OF CYCLES IN NLLSQ */
       "DCART"    , /* PRINT DETAILS OF WORKING IN DCART */
       "DEBUG"    , /* DEBUG OPTION TURNED ON */
       "DEBUGPULAY",/* PRINT DETAILS OF WORKING IN PULAY */
       "DENOUT"   , /* DENSITY MATRIX OUTPUT (CHANNEL 10) */
       "DENSITY"  , /* PRINT FINAL DENSITY MATRIX */
       "DEP"      , /* GENERATE FORTRAN CODE FOR PARAMETERS FOR NEW ELEMENTS */
       "DEPVAR"   , /* =n - TRANSLATION VECTOR IS A MULTIPLE OF BOND-LENGTH */
       "DERIV"    , /* PRINT PART OF WORKING IN DERIV */
       "DFORCE"   , /* FORCE CALCULATION SPECIFIED, ALSO PRINT FORCE MATRIX. */
       "DFP"      , /* USE DAVIDON-FLETCHER-POWELL METHOD TO OPTIMIZE GEOMETRIES */
       "DOUBLET"  , /* RHF DOUBLET STATE REQUIRED */
       "DRC"      , /* DYNAMIC REACTION COORDINATE CALCULATION */
       "DUMP"     , /* =n - WRITE RESTART FILES EVERY n SECONDS */
       "ECHO"     , /* DATA ARE ECHOED BACK BEFORE CALCULATION STARTS */
       "EIGS"     , /* PRINT ALL EIGENVALUES IN ITER */
       "ENPART"   , /* PARTITION ENERGY INTO COMPONENTS */
       "ESR"      , /* CALCULATE RHF UNPAIRED SPIN DENSITY */
       "EXCITED"  , /* OPTIMIZE FIRST EXCITED SINGLET STATE */
       "EXTERNAL" , /* READ MNDO OR AM1 PARAMETERS OFF DISK */
       "FILL"     , /* =n   - IN RHF OPEN AND CLOSED SHELL, FORCE M.O. n 
                       TO BE FILLED */
       "FLEPO"    , /* PRINT DETAILS OF GEOMETRY OPTIMIZATION */
       "FMAT"     , /* PRINT DETAILS OF WORKING IN FMAT */
       "FOCK"     , /* PRINT LAST FOCK MATRIX */
       "FORCE"    , /* FORCE CALCULATION SPECIFIED */
       "FULSCF"   , /* FULL SCF CALCN'S TO BE DONE IN SEARCHES, AND DERIVATIVES
                       WHEN NON-VARIATIONALLY OPTIMIZED WAVEFUNCTIONS USED */
       "GEO-OK"   , /* OVERRIDE INTERATOMIC DISTANCE CHECK */
       "GNORM"    , /* =n.n, EXIT WHEN GRADIENT NORM DROPS BELOW n.n */
       "GRADIENTS", /* PRINT ALL GRADIENTS */
       "GRAPH"    , /* GENERATE FILE FOR GRAPHICS */
       "HCORE"    , /* PRINT DETAILS OF WORKING IN HCORE */
       "H-PRIO"   , /* HEAT OF FORMATION TAKES PRIORITY IN DRC */
       "IRC"      , /* INTRINSIC REACTION COORDINATE CALCULATION */
       "ISOTOPE"  , /* FORCE MATRIX WRITTEN TO DISK (CHANNEL 9 ) */
       "ITER"     , /* PRINT DETAILS OF WORKING IN ITER */
       "ITRY"     , /* =N, SET LIMIT OF NUMBER OF SCF ITERATIONS TO N. */
       "KINETIC"  , /* EXCESS KINETIC ENERGY ADDED TO DRC CALCULATION */
       "LINMIN"   , /* PRINT DETAILS OF LINE MINIMIZATION */
       "LARGE"    , /* PRINT EXPANDED OUTPUT */
       "LET"      , /* OVERRIDE CERTAIN SAFETY CHECKS */
       "LOCALIZE" , /* PRINT LOCALIZED ORBITALS */
       "MINDO/3"  , /* USE THE MINDO/3 HAMILTONIAN  */
       "MECI"     , /* PRINT DETAILS OF MECI CALCULATION */
       "MICROS"   , /* USE SPECIFIC MICROSTATES IN THE C.I. */
       "MMOK"     , /* USE MOLECULAR MECHANICS CORRECTION TO CONH BONDS */
       "MOLDAT"   , /* PRINT DETAILS OF WORKING IN MOLDAT */
       "MULLIK"   , /* PRINT THE MULLIKEN POPULATION ANALYSIS */
       "NLLSQ"    , /* MINIMIZE GRADIENTS USING NLLSQ */
       "NOINTER"  , /* DO NOT PRINT INTERATOMIC DISTANCES  */
       "NOMM"     , /* DO NOT USE MOLECULAR MECHANICS CORRECTION TO CONH BONDS */
       "NOXYZ"    , /* DO NOT PRINT CARTESIAN COORDINATES */
       "OLDENS"   , /* READ INITIAL DENSITY MATRIX OFF DISK */
       "OPEN"     , /* OPEN-SHELL RHF CALCULATION REQUESTED */
       "PI"       , /* RESOLVE DENSITY MATRIX INTO SIGMA AND PI BONDS */
       "PL"       , /* MONITOR CONVERGENCE OF DENSITY MATRIX IN ITER */
       "PM3"      , /* USE THE MNDO-PM3 HAMILTONIAN */
       "POLAR"    , /* CALCULATE FIRST, SECOND AND THIRD ORDER POLARIZABILITIES */
       "POWSQ"    , /* PRINT DETAILS OF WORKING IN POWSQ */
       "PRECISE"  , /* CRITERIA TO BE INCREASED BY 100 TIMES */
       "PULAY"    , /* USE PULAY'S CONVERGER TO OBTAIN A SCF */
       "QUARTET"  , /* RHF QUARTET STATE REQUIRED */
       "QUINTET"  , /* RHF QUINTET STATE REQUIRED */
       "RESTART"  , /* CALCULATION RESTARTED */
       "ROOT"     , /* =n , ROOT n TO BE OPTIMIZED IN A C.I. CALCULATION */
       "ROT"      , /* =n , THE SYMMETRY NUMBER OF THE SYSTEM IS n. */
       "SADDLE"   , /* OPTIMIZE TRANSITION STATE */
       "SCFCRT"   , /* =n - DEFAULT SCF CRITERION REPLACED BY THE VALUE SUPPLIED */
       "SEARCH"   , /* Use LINMIN instead of this keyword */
       "SEXTET"   , /* RHF SEXTET STATE REQUIRED */
       "SHIFT"    , /* =n  - A DAMPING FACTOR OF n DEFINED TO START SCF */
       "SIGMA"    , /* MINIMIZE GRADIENTS USING SIGMA */
       "SINGLET"  , /* RHF SINGLET STATE REQUIRED */
       "SPIN"     , /* PRINT FINAL UHF SPIN MATRIX */
       "STEP1"    , /* =n , STEP SIZE n FOR FIRST COORDINATE IN GRID CALCULATION */
       "STEP2"    , /* =n , STEP SIZE n FOR SECOND COORDINATE IN GRID CALCULATION */
       "SYMMETRY" , /* IMPOSE SYMMETRY CONDITIONS */
       "T"        , /* =n , A TIME OF n SECONDS REQUESTED   */
       "THERMO"   , /* PERFORM A THERMODYNAMICS CALCULATION  */
       "TIMES"    , /* PRINT TIMES OF VARIOUS STAGES */
       "T-PRIO"   , /* TIME TAKES PRIORITY IN DRC */
       "TRANS"    , /* THE SYSTEM IS A TRANSITION STATE  
                       (USED IN THERMODYNAMICS CALCULATION) */
       "TRIPLET"  , /* TRIPLET STATE REQUIRED */
       "UHF"      , /* UNRESTRICTED HARTREE-FOCK CALCULATION  */
       "VECTORS"  , /* PRINT FINAL EIGENVECTORS */
       "VELOCITY" , /* SUPPLY THE INITIAL VELOCITY VECTOR IN A DRC CALCULATION */
       "X-PRIO"   , /* GEOMETRY CHANGES TAKE PRIORITY IN DRC */
       "XYZ"      }; /* DO ALL GEOMETRIC OPERATIONS IN CARTESIAN COORDINATES. */

#define N_MOPAC5_KEY (sizeof(mopac5_key) / sizeof(char *))
   

   
