/*  

                       Copyright (c) 1990 and 1992, 1993 by:
        Leif Laaksonen , Centre for Scientific Computing, ESPOO, FINLAND
            Confidential unpublished property of Leif Laaksonen
                        All rights reserved
  

*/


#include <stdio.h>
#include <math.h>
#include <string.h>
#include <ctype.h>
#include <malloc.h>

#include "maxdefs.h"

#define MAX_FLOAT  1.e+35    /* This max float is just a guess */
#define MAX(a,b)  ((a) > (b) ? (a) : (b))
#define MIN(a,b)  ((a) < (b) ? (a) : (b))
#define Rabs(a)    ( ( a ) > 0   ? (a) : -(a))
#define Fabs(a)    ( ( a ) > 0.0 ? (a) : -(a))


extern void toller();
extern void PrintMessage();
extern int   indexo();
extern void mantime();

   float Simpson38();
   float Simpson();
   float Trapez();
   int   ArrayManipulation();

/*
    Very simple routine for integration:

    (1) Check number of points.
    (2) Integrate using the 3/8 Simpson's rule
    (3) a) Use  Simpson's rule for the leftover points or
        b) -"-  Trapezoidal rule for the leftover points.

    Leif Laaksonen 1992

*/
/***********************************************************************/
float Trapez(Fvalues , NumF , DeltaF)
    float *Fvalues;    /* Function values */
    int    NumF;       /* number of function values */
    float  DeltaF;     /* function step  */
/***********************************************************************/
{
    int i;
    float sum;

    sum = Fvalues[0] - Fvalues[NumF - 1];

    for(i = 1 ; i < NumF - 1 ; i++) 
        sum += 2.0 * Fvalues[i];

    return(sum = sum * DeltaF / 2.0);
  }

/***********************************************************************/
float Simpson(Fvalues , NumF , DeltaF)
    float *Fvalues;    /* Function values */
    int    NumF;       /* number of function values */
    float  DeltaF;     /* function step  */
/***********************************************************************/
{
    int i;
    float sum;

    sum = Fvalues[0] - Fvalues[NumF - 1];

    for(i = 1 ; i < NumF - 1 ; i += 2) 
        sum += 4.0 * Fvalues[i] + 2.0 * Fvalues[i + 1];

    return(sum = sum * DeltaF / 3.0);
  }
/***********************************************************************/
float Simpson38(Fvalues , NumF , DeltaF)
    float *Fvalues;    /* Function values */
    int    NumF;       /* number of function values */
    float  DeltaF;     /* function step  */
/***********************************************************************/
{
    int i;
    int RealNumF;
    int LeftOver;
    register float sum;

    RealNumF = 3 * ((NumF - 1) / 3) + 1;

    LeftOver = NumF - RealNumF;

    sum = 3.0 * (Fvalues[0] - Fvalues[RealNumF - 1]);

    for(i = 1 ; i < RealNumF - 1 ; i += 3) {
        sum += 9.0 * Fvalues[i] + 
               9.0 * Fvalues[i + 1] + 
               6.0 * Fvalues[i + 2];}

    sum *=  DeltaF / 8.0;

    switch(LeftOver) {

     case 0:
           break;
     case 1:
           sum += Trapez(&Fvalues[RealNumF - 1] , 2 , DeltaF);
           break;
     case 2:
           sum += Simpson(&Fvalues[RealNumF - 1] , 3 , DeltaF);
           break;
	 default:
           printf("LeftOver: %d\n",LeftOver);
           printf("***** ERROR *****\n");
           exit(1);
	 }

    return(sum);
  }

/************************************************************************/
int ArrayManipulation(input,num,vec,param)   /* manipulate series */
   char  *input;       /* type of manipulation */
   int    num;         /* length of array      */
   float *vec;         /* array to manipulate  */
   char  *param;       /* extra parameter      */
/************************************************************************/
{

     char OutText[BUFF_LEN];
     char Temp[BUFF_LEN];

/* switch to small characters                 */
     strncpy(Temp,input,BUFF_LEN);
     toller(Temp);

/*
     DAVErage  ;  Q(t) = Q(t) - <Q(t)>
     SQUAre  ;  Q(t) = Q(t) ** 2  
     COS  ;  Q(t) = cos(Q(t)) 
     COS2  ;  Q(t) = 3*cos(Q(t))**2 - 1 
     SQRT  ;  Q(t) = sqrt(Q(t)) 
     DINItial  ;  Q(t) = Q(t) - Q(0) 
     COPY nr ;  Q(t) = Q2(t)            Not Available
     ADD nr ;  Q(t) = Q(t) + Q2(t)      Not Available
     LOG ;  Q(t) = log(Q(t)) 
     EXP ;  Q(t) = exp(Q(t)) 
     POWer real ;  Q(t) = Q(t) ** real 
     MULT real ;  Q(t) = real * Q(t) 
     DIVIde real ;  Q(t) = Q(t) / real
     SHIFt real ;  Q(t) = Q(t) + real 
     DMIN ;  Q(t) = Q(t) - Q(min)
     ABS ;  Q(t) = abs(Q(t))
     DIVFirst ;  Q(t) = Q(t) / Q(0) 
     DIVMaximum ;  Q(t) = Q(t) /max(Q(t)) 
     ZERO ;  Q(t) = 0.0  
     INTE dx ;  Integrate the array
     PSPEctrum file.name ; Power spectrum of data from file
*/

/* DAVErag                          */
   if(indexo(Temp,"dave") == 1) {
   mantime(vec,num,1,1,atof(param),atoi(param));
   return;
   }

/* SQUAre                          */
   if(indexo(Temp,"squa") == 1) {
   mantime(vec,num,1,2,atof(param),atoi(param));
   return;
   }

/* COS                          */
   if(indexo(Temp,"cos") == 1) {
   mantime(vec,num,1,3,atof(param),atoi(param));
   return;
   }

/* COS2                          */
   if(indexo(Temp,"cos2") == 1) {
   mantime(vec,num,1,4,atof(param),atoi(param));
   return;
   }

/* SQRT                          */
   if(indexo(Temp,"sqrt") == 1) {
   mantime(vec,num,1,5,atof(param),atoi(param));
   return;
   }

/* DINItial                          */
   if(indexo(Temp,"dini") == 1) {
   mantime(vec,num,1,6,atof(param),atoi(param));
   return;
   }

/* COPY                          */
   if(indexo(Temp,"copy") == 1) {
   PrintMessage("?ERROR - not available in this context");
    return;
   mantime(vec,num,1,7,atof(param),atoi(param));
   return;
   }

/* ADD                          */
   if(indexo(Temp,"add") == 1) {
   PrintMessage("?ERROR - not available in this context");
    return;
   mantime(vec,num,1,8,atof(param),atoi(param));
   return;
   }

/* log                          */
   if(indexo(Temp,"log") == 1) {
   mantime(vec,num,1,9,atof(param),atoi(param));
   return;
   }

/* exp                          */
   if(indexo(Temp,"exp") == 1) {
   mantime(vec,num,1,10,atof(param),atoi(param));
   return;
   }

/* powe                          */
   if(indexo(Temp,"powe") == 1) {
   mantime(vec,num,1,11,atof(param),atoi(param));
   return;
   }

/* mult                          */
   if(indexo(Temp,"mult") == 1) {
   mantime(vec,num,1,12,atof(param),atoi(param));
   return;
   }

/* DIVIde                          */
   if(indexo(Temp,"divi") == 1) {
   mantime(vec,num,1,13,atof(param),atoi(param));
   return;
   }

/* SHIFt                          */
   if(indexo(Temp,"shif") == 1) {
   mantime(vec,num,1,14,atof(param),atoi(param));
   return;
   }

/* DMIN                          */
   if(indexo(Temp,"dmin") == 1) {
   mantime(vec,num,1,15,atof(param),atoi(param));
   return;
   }

/* ABS                          */
   if(indexo(Temp,"abs") == 1) {
   mantime(vec,num,1,16,atof(param),atoi(param));
   return;
   }

/* DIVFirst                          */
   if(indexo(Temp,"divf") == 1) {
   mantime(vec,num,1,17,atof(param),atoi(param));
   return;
   }

/* DIVMaximum                          */
   if(indexo(Temp,"divm") == 1) {
   mantime(vec,num,1,18,atof(param),atoi(param));
   return;
   }

/* INTE                          */
   if(indexo(Temp,"inte") == 1) {
   sprintf(OutText,"Integral: %f",Simpson38(vec,num,atof(param)));
   PrintMessage(OutText);
   return;
   }

/* POWEr spectrum                */
   if(indexo(Temp,"pspe") == 1) {
   PrintMessage("?ERROR - not available in this context");
    return;
     (void)DoTheJobSpec(vec,num);
    return;}

/* ZERO                          */
   if(indexo(Temp,"zero") == 1) {
   mantime(vec,num,1,19,atof(param),atoi(param));
   return;
   }

   sprintf(OutText,"?ERROR - unknown command '%s'",input);
   PrintMessage(OutText);
}     
