/*  

                       Copyright (c) 1990, 1993 by:
        Leif Laaksonen , Centre for Scientific Computing , ESPOO , FINLAND
            Confidential unpublished property of Leif Laaksonen
                        All rights reserved
  


     This routine takes one line and analyzes if there are
     words beginning with '?'.

     ?cputime   fills in the used cpu time.
     ?date      fills in date and time.
     ?frames    fills in the number of frames.
     ?natoms    fills in the number of atoms for the current structure.
     ?node      fills in the node name.
     ?username  fills in the user name.
     ?cxmin     clipping plane for xmin
     ?cxmax     clipping plane for xmax
     ?cymin     clipping plane for ymin
     ?cymax     clipping plane for ymax
     ?czmin     clipping plane for zmin
     ?czmax     clipping plane for zmax
     
     ?atm_cm(seg:res:atm)          fill in centre of mass of selection     
     ?atm_coord(seg:res:atm)       fill in coords for the selected atom
     ?atm_gc(seq:res:atm)          fill in geometric centre for selected atoms

     ?atm_dist(seq1:res1:atm1 seq2:res2:atm2)  Distance between atoms
     ?atm_angle(seq1:res1:atm1 seq2:res2:atm2 seq3:res3:atm3)
                                               Angle between atoms
     ?atm_dihe(seq1:res1:atm1 seq2:res2:atm2 seq3:res3.atm3 seq4:res4:atm4)
                                               Torsion angle between atoms

     Leif Laaksonen 1990

*/



#include <stdio.h>
#include <math.h>
#include <string.h>
#include <sys/types.h>     /* this is needed for IRIX 3.2 */
#include <time.h>
#include <unistd.h>

#include "maxdefs.h"
#include "ScareTypedefs.h"

#define QUERY_ENTRY 18

#define CLEAN_IT_UP()  {if(strlen(string)+strlen(fill_string) >= BUFF_LEN) { \
                        printf("ERROR - string does not fit into BUFF_LEN\n");\
                        return;} \
                            strcpy(chelp,string+end); \
                            string[start] = '\0'; \
                            strcat(string,fill_string); \
                            strcat(string,chelp); \
                            goto loop; }
#define  ZERO_STRING(txt , a); { int tmp;\
                               for(tmp = 0 ; tmp < (a) ; tmp++) txt[tmp]='\0';}

int    qulen = QUERY_ENTRY;
char   qucomm[QUERY_ENTRY][10] = {"date",
                                  "cputime",
                                  "node",
                                  "username",
                                  "natoms",
                                  "frames",
                                  "xcmin",
                                  "xcmax",
                                  "ycmin",
                                  "ycmax",
                                  "zcmin",
                                  "zcmax",
                                  "atm_coord",
                                  "atm_cm",
                                  "atm_gc",
                                  "atm_dist",
                                  "atm_angle",
                                  "atm_dihe"};

char **SegResAtm2Split(char *);
void FillCM();
void FillAC();
int  FillGC();
int  FillDIST();
int  FillANGLE();
int  FillDIHE();
int SegResAtm2Num();

extern int *ivector();
extern int atom_list_max();
extern int select_list();
extern void toller();
extern int GetStringLenPAR();
extern char *LookForPar();
extern void PrintMessage();
extern float GetXCoord();
extern float GetYCoord();
extern float GetZCoord();
extern int   calc_cmass_gen();
extern void  Bangle();
extern void  Dihed();
extern int IsNumber();

     extern int mlist_deep;      /* stack number indicator */
     extern int mlists[MAX_MLIST]; /* First index for molecule list */
     extern int mliste[MAX_MLIST]; /* Second index for molecule list */
     extern char mnlist[MAX_MLIST][BUFF_LEN]; 
                                /* name list for molecule file names */
     extern float sumx;
     extern float sumy;
     extern float sumz;

     extern float *x;
     extern float *y;
     extern float *z;

   extern struct {
    char traj_file[BUFF_LEN];                 /* file name          */
    int natom;                                /* number of atoms    */
    int nstep;                                /* number of steps    */
    int time_bw_steps;                        /* time between steps */
    int time_first_frame;                     /* time of first frame */
    int first_frame;                          /* first frame to be displayed */
    int last_frame;                           /* last frame to be displayed  */
    int delta_frame;                          /* display every delta frame */
                   }    trajectory_info;     

    extern int current_struct;
    extern float near;
    extern float far;

/*******************************************************************/
void qcomm(string)
     char *string;
/*******************************************************************/
{
     int i,j,k,l;
     int start,end;
     char chelp[BUFF_LEN];
     char chelp1[BUFF_LEN];
     char chelp2[BUFF_LEN];
     char fill_string[BUFF_LEN];

loop:;

     j = strlen(string);
     strncpy(chelp1,string,j);
     toller(chelp1);

     for(i = 0 ; i < j ; i++) {
        if(string[i] == '?')  { /* go and get it */

          start = i;
          for(k = 0 ; k < qulen ; k++) {
          l = strlen(qucomm[k]);
             if(strncmp(chelp1+start+1,qucomm[k],l) == 0) { /* hit */

             strncpy(chelp2,string,BUFF_LEN);
             end  = start + strlen(qucomm[k]) + 1;
             end += GetStringLenPAR(&chelp2[end]); 

             ZERO_STRING(fill_string , BUFF_LEN);

             switch(k) {

             case 0: /* date */

                     get_fill_string(fill_string,0);
                     CLEAN_IT_UP();
                     break;

             case 1: /* cputime */

                     get_fill_string(fill_string,1);
                     CLEAN_IT_UP();
                     break;

	     case 2: /* node name */

                     get_fill_string(fill_string,2);
                     CLEAN_IT_UP();
                     break;

	     case 3: /* user name */
                     get_fill_string(fill_string,3);
                     CLEAN_IT_UP();
                     break;

             case 4: /* number of atoms (natoms) */
                     get_fill_string(fill_string,4);
                     CLEAN_IT_UP();
                     break;

	     case 5: /* number of frames         */
                     get_fill_string(fill_string,5);
                     CLEAN_IT_UP();
                     break;

             case 6:  /* cxmin */
             case 8:  /* cymin */
             case 10: /* czmin */
                     get_fill_string(fill_string,6);
                     CLEAN_IT_UP();
                     break;      

             case 7:  /* cxmax */
             case 9:  /* cymax */
             case 11: /* czmax */
                     get_fill_string(fill_string,7);
                     CLEAN_IT_UP();
                     break;      

             case 12: /* atm_coord */
                     strncpy(fill_string,string+start,BUFF_LEN);
                     get_fill_string(fill_string,8);
                     CLEAN_IT_UP();
                     break;

             case 13: /* atm_cm   */       
                     strncpy(fill_string,string+start,BUFF_LEN);
                     get_fill_string(fill_string,9);
                     CLEAN_IT_UP();
                     break;

             case 14: /* atm_gc */
                     strncpy(fill_string,string+start,BUFF_LEN);
                     get_fill_string(fill_string,10);
                     CLEAN_IT_UP();
                     break;

             case 15: /* atm_dist */
                     strncpy(fill_string,string+start,BUFF_LEN);
                     get_fill_string(fill_string,11);
                     CLEAN_IT_UP();
                     break;

             case 16: /* atm_angle */
                     strncpy(fill_string,string+start,BUFF_LEN);
                     get_fill_string(fill_string,12);
                     CLEAN_IT_UP();
                     break;

             case 17: /* atm_dihe */
                     strncpy(fill_string,string+start,BUFF_LEN);
                     get_fill_string(fill_string,13);
                     CLEAN_IT_UP();
                     break;
  

	     default:
             printf("?ERROR - Can't resolve '%s' \n",chelp1+start);
             break; 
		   }

	   }
	 }
        }
      }
}
/*******************************************************************/
get_fill_string(text,alt)
        char *text;
        int   alt;
/*******************************************************************/
{
    char *date_time;
    time_t t;
    float secs;
    float secs1;
    char this_host[BUFF_LEN];
    char *getlogin();
    char *user_name;
    int i;

        switch(alt) {

        case 0: /* fill in date */

             time(&t);
             if(t == -1) {
             printf("?ERROR - can't get the time \n");
             strcpy(text,"** can't get date and time **");
             return;}

             date_time = ctime(&t);
             strcpy(text,date_time);
             i = strlen(text);
             if(text[i - 1] == '\n')
                text[i - 1] = '\0';  
             break;

            case 1:  /* fill in used cpu time */

              secs = 0.0;
               secs1 = 0.0;
              get_cpu_secs(&secs , &secs1);
              sprintf(text,"%.2f %.2f",secs,secs1);
              break;    

	    case 2:  /* fill in host name */

             gethostname(this_host,sizeof(this_host));
             strcpy(text,this_host);
             break; 

	    case 3:  /* user name */

             if((user_name = getlogin()) == NULL) {
               strcpy(text,"** can't get login name **");
               return;}
             strncpy(text,user_name,BUFF_LEN);
             break; 

	    case 4: /* number of atoms */
              sprintf(text," %d ",mliste[current_struct]);
              break;

	    case 5: /* number of frames */
              sprintf(text," %d ",trajectory_info.nstep);
              break;

	    case 6: /* cmin */
              sprintf(text," %f \0",near);
              break;

	    case 7: /* cmax */
              sprintf(text," %f \0",far);
              break;

	    case 8: /* atm_coord */
              (void)FillAC(text);
              break;

	    case 9: /* atm_coord */
              (void)FillCM(text);
              break;

	    case 10: /* atm_gc */
              (void)FillGC(text);
              break;

	    case 11: /* atm_dist */
              (void)FillDIST(text);
              break;

	    case 12: /* atm_angle */
              (void)FillANGLE(text);
              break;

	    case 13: /* atm_dihe */
              (void)FillDIHE(text);
              break;

	    default: /* error */

            printf("?ERROR - wrong number sent to 'get_fill_string' \n");
            strcpy(text,"** error in 'get_fill_string'");
            break;
	   }
}
/*******************************************************************/
int SegResAtm2Num(text)
    char *text;
/*******************************************************************/
{
     static int ihelp,atom_list;
     static int slong;
     static int *sel_list;
     static char chelp[BUFF_LEN];
     static PARSING ParseStuff;

    strncpy(chelp,LookForPar(text),BUFF_LEN);

    (void)own_parser( chelp , 
                    ParseStuff.ISparsed , 
                   &ParseStuff.IParams , 
                    SEP_STRING);

    if(ParseStuff.IParams < 1) return(-1); /* nothing to report */

     atom_list = atom_list_max();

     sel_list = ivector(atom_list);

     slong = select_list(ParseStuff.ISparsed[0],
                         ParseStuff.ISparsed[1],
                         ParseStuff.ISparsed[2],sel_list);
     if(slong > 0) {
 
     if(slong > 1) {
        PrintMessage("?ERROR - more than one atom in the selection list");
        PrintMessage("         supply a selection for one atom  ");
        slong = -1;
        free(sel_list);
        return(slong);}
     slong = sel_list[0];
     free(sel_list);            
     return(slong);
     }
      else {
      PrintMessage("?ERROR - no atoms in the selection list ");}

     free(sel_list);

     return(-1);
}
/*******************************************************************/
void FillAC(text)
    char *text;
/*******************************************************************/
{
    static int AtmIndex;
    static float Xcoord;
    static float Ycoord;
    static float Zcoord;

    AtmIndex = SegResAtm2Num(text);

    if(AtmIndex > -1) {
      Xcoord = GetXCoord(AtmIndex);
      Ycoord = GetYCoord(AtmIndex);
      Zcoord = GetZCoord(AtmIndex);
      sprintf(text,"%.3f %.3f %.3f",Xcoord+sumx,Ycoord+sumy,Zcoord+sumz);
    }
    else {
/*    for(AtmIndex = 0 ; AtmIndex < BUFF_LEN ; AtmIndex++) text[AtmIndex] = '\0';*/
    return;
    }
}
/*******************************************************************/
void FillCM(text)
    char *text;
/*******************************************************************/
{
    static int AtmIndex;
    static float CMass[3];
    char (*Text)[BUFF_LEN];

    Text  = (char (*) []) SegResAtm2Split(text);

    if(Text != NULL) {
      AtmIndex =  calc_cmass_gen(Text[0]  , Text[1]   , Text[2] ,
                               &CMass[0], &CMass[1] , &CMass[2]);

      if(AtmIndex) {
/*        for(AtmIndex = 0 ; AtmIndex < BUFF_LEN ; AtmIndex++) text[AtmIndex] = '\0'; */
        return;}

      sprintf(text,"%.3f %.3f %.3f",CMass[0]+sumx,CMass[1]+sumy,CMass[2]+sumz);
    }
    else {
/*    for(AtmIndex = 0 ; AtmIndex < BUFF_LEN ; AtmIndex++) text[AtmIndex] = '\0';*/
    return;
    }
}
/*******************************************************************/
char **SegResAtm2Split(text)
    char *text;
/*******************************************************************/
{
     static char chelp[BUFF_LEN];
     static PARSING ParseStuff;

    strncpy(chelp,LookForPar(text),BUFF_LEN);

    strncpy(text,chelp,BUFF_LEN);

    (void)own_parser( chelp , 
                    ParseStuff.ISparsed , 
                   &ParseStuff.IParams , 
                    SEP_STRING);

    if(ParseStuff.IParams < 1) return(NULL); /* nothing to report */

    return(ParseStuff.ISparsed);
}
/*******************************************************************/
int FillGC(text)
    char *text;
/*******************************************************************/
{
    static int AtmIndex;
    static char  (*Text)[BUFF_LEN];
     static int ihelp,atom_list,i,j;
     static int slong;
     static int *sel_list;
     static char chelp[BUFF_LEN];
     static float GCent[3];

    Text = (char (*) [])SegResAtm2Split(text);

    if(Text != NULL) {

     atom_list = atom_list_max();

     sel_list = ivector(atom_list);

     slong = select_list(Text[0],
                         Text[1],
                         Text[2],sel_list);
     if(slong > 0) {

      GCent[0] = 0.0;
       GCent[1] = 0.0;
        GCent[2] = 0.0;

      for(i = 0 ; i < slong ; i++) {
          j = sel_list[i];
          GCent[0] += x[j];
           GCent[1] += y[j];
            GCent[2] += z[j];}

          GCent[0] /= (float)slong;
          GCent[1] /= (float)slong;
          GCent[2] /= (float)slong;

      sprintf(text,"%.3f %.3f %.3f",GCent[0]+sumx,GCent[1]+sumy,GCent[2]+sumz);
      free(sel_list);
      return(0);
      }
      else {
      PrintMessage("?ERROR - no atoms in the selection list ");
      free(sel_list);
      return(-1);}
    }
    else
         return(-1);
}
/*******************************************************************/
int FillDIST(text)
    char *text;
/*******************************************************************/
{
    static int AtmIndex;
    static char  (*Text)[BUFF_LEN];
     static int ihelp,atom_list,i,j;
     static int slong,slong1;
     static int *sel_list,*sel_list1;
     static char chelp[BUFF_LEN];
     static float Dist;
     static int Posit1;
     static float PosX1,PosY1,PosZ1;
     static int Posit2;
     static float PosX2,PosY2,PosZ2;

    Text = (char (*) [])SegResAtm2Split(text);

    if(Text != NULL) {

    Posit1 = Posit2 = 0;
    slong  = slong1 = 0;

    if(IsNumber(Text[0]) && IsNumber(Text[1]) && IsNumber(Text[2])) Posit1 = 1;
    if(IsNumber(Text[3]) && IsNumber(Text[4]) && IsNumber(Text[5])) Posit2 = 1;

     atom_list = atom_list_max();

    if(Posit1) {
        PosX1 = atof(Text[0]);
        PosY1 = atof(Text[1]);
        PosZ1 = atof(Text[2]);
    }
    else {
     sel_list  = ivector(atom_list);

     slong = select_list(Text[0],
                         Text[1],
                         Text[2],sel_list);
       if(slong  > 1) {
             PrintMessage("?ERROR - more than one atom in select list 1");
             free(sel_list);
             return(-1);}
       if(!slong) {
             PrintMessage("?ERROR - no atoms in the selection list 1 ");
             free(sel_list);
             return(-1);}
        PosX1 = x[sel_list[0]];
        PosY1 = y[sel_list[0]];
        PosZ1 = z[sel_list[0]];
    }

    if(Posit2) {
        PosX2 = atof(Text[3]);
        PosY2 = atof(Text[4]);
        PosZ2 = atof(Text[5]);
    }
    else {
     sel_list1 = ivector(atom_list);

     slong1= select_list(Text[3],
                         Text[4],
                         Text[5],sel_list1);
       if(slong1 > 1) {
             PrintMessage("?ERROR - more than one atom in select list 2");
             if(!Posit1)
                 free(sel_list);
                 free(sel_list1);
             return(-1);}
       if(!slong1) {
             PrintMessage("?ERROR - no atoms in the selection list 2 ");
             if(!Posit1)
                 free(sel_list);
                 free(sel_list1);
             return(-1);}
        PosX2 = x[sel_list1[0]];
        PosY2 = y[sel_list1[0]];
        PosZ2 = z[sel_list1[0]];
    }

      Dist = sqrt(pow((PosX1 - PosX2),2.0) +
                  pow((PosY1 - PosY2),2.0) +
                  pow((PosZ1 - PosZ2),2.0) );

      sprintf(text,"%.3f",Dist);
      if(!Posit1)
          free(sel_list);
      if(!Posit2)
          free(sel_list1);
      return(0);
    }
    else
         return(-1);
}
/*******************************************************************/
int FillANGLE(text)
    char *text;
/*******************************************************************/
{
    static int AtmIndex;
    static char  (*Text)[BUFF_LEN];
     static int ihelp,atom_list,i,j;
     static int slong,slong1,slong2;
     static int *sel_list,*sel_list1,*sel_list2;
     static char chelp[BUFF_LEN];
     static float Dist;
     static int Posit1;
     static float PosX1,PosY1,PosZ1;
     static int Posit2;
     static float PosX2,PosY2,PosZ2;
     static int Posit3;
     static float PosX3,PosY3,PosZ3;

    Text = (char (*) [])SegResAtm2Split(text);

    if(Text != NULL) {

    Posit1 = Posit2 = Posit3 = 0;
    slong  = slong1 = slong2 = 0;

    if(IsNumber(Text[0]) && IsNumber(Text[1]) && IsNumber(Text[2])) Posit1 = 1;
    if(IsNumber(Text[3]) && IsNumber(Text[4]) && IsNumber(Text[5])) Posit2 = 1;
    if(IsNumber(Text[6]) && IsNumber(Text[7]) && IsNumber(Text[8])) Posit3 = 1;

     atom_list = atom_list_max();

    if(Posit1) {
        PosX1 = atof(Text[0]);
        PosY1 = atof(Text[1]);
        PosZ1 = atof(Text[2]);
    }
    else {
     sel_list  = ivector(atom_list);

     slong = select_list(Text[0],
                         Text[1],
                         Text[2],sel_list);
       if(slong  > 1) {
             PrintMessage("?ERROR - more than one atom in select list 1");
             free(sel_list);
             return(-1);}
       if(!slong) {
             PrintMessage("?ERROR - no atoms in the selection list 1 ");
             free(sel_list);
             return(-1);}
        PosX1 = x[sel_list[0]];
        PosY1 = y[sel_list[0]];
        PosZ1 = z[sel_list[0]];
    }

    if(Posit2) {
        PosX2 = atof(Text[3]);
        PosY2 = atof(Text[4]);
        PosZ2 = atof(Text[5]);
    }
    else {
     sel_list1 = ivector(atom_list);

     slong1= select_list(Text[3],
                         Text[4],
                         Text[5],sel_list1);
       if(slong1 > 1) {
             PrintMessage("?ERROR - more than one atom in select list 2");
             if(!Posit1)
                 free(sel_list);
                 free(sel_list1);
             return(-1);}
       if(!slong1) {
             PrintMessage("?ERROR - no atoms in the selection list 2 ");
             if(!Posit1)
                 free(sel_list);
                 free(sel_list1);
             return(-1);}
        PosX2 = x[sel_list1[0]];
        PosY2 = y[sel_list1[0]];
        PosZ2 = z[sel_list1[0]];
    }

    if(Posit3) {
        PosX3 = atof(Text[6]);
        PosY3 = atof(Text[7]);
        PosZ3 = atof(Text[8]);
    }
    else {
     sel_list2 = ivector(atom_list);

     slong2= select_list(Text[6],
                         Text[7],
                         Text[8],sel_list2);
       if(slong2 > 1) {
             PrintMessage("?ERROR - more than one atom in select list 3");
             if(!Posit1)
                 free(sel_list);
             if(!Posit2)
                 free(sel_list1);
                 free(sel_list2);
             return(-1);}
       if(!slong2) {
             PrintMessage("?ERROR - no atoms in the selection list 3 ");
             if(!Posit1)
                 free(sel_list);
             if(!Posit2)
                 free(sel_list1);
                 free(sel_list2);
             return(-1);}
        PosX3 = x[sel_list2[0]];
        PosY3 = y[sel_list2[0]];
        PosZ3 = z[sel_list2[0]];
    }

      (void) Bangle( PosX1 , PosY1 , PosZ1 , 
                     PosX2 , PosY2 , PosZ2 ,
                     PosX3 , PosY3 , PosZ3 , &Dist);

      Dist = Dist * 180. / M_PI;

      sprintf(text,"%.3f",Dist);
      if(!Posit1)
          free(sel_list);
      if(!Posit2)
          free(sel_list1);
      if(!Posit3)
          free(sel_list2);
      return(0);
     }
    else
         return(-1);
}
/*******************************************************************/
int FillDIHE(text)
    char *text;
/*******************************************************************/
{
    static int AtmIndex;
    static char  (*Text)[BUFF_LEN];
     static int ihelp,atom_list,i,j;
     static int slong,slong1,slong2,slong3;
     static int *sel_list,*sel_list1,*sel_list2,*sel_list3;
     static char chelp[BUFF_LEN];
     static float Dist;
     static int Posit1;
     static float PosX1,PosY1,PosZ1;
     static int Posit2;
     static float PosX2,PosY2,PosZ2;
     static int Posit3;
     static float PosX3,PosY3,PosZ3;
     static int Posit4;
     static float PosX4,PosY4,PosZ4;

    Text = (char (*) [])SegResAtm2Split(text);

    if(Text != NULL) {

    Posit1 = Posit2 = Posit3 = Posit4 = 0;
    slong  = slong1 = slong2 = Posit4 = 0;

    if(IsNumber(Text[0]) && IsNumber(Text[1])  && IsNumber(Text[2]))  Posit1 = 1;
    if(IsNumber(Text[3]) && IsNumber(Text[4])  && IsNumber(Text[5]))  Posit2 = 1;
    if(IsNumber(Text[6]) && IsNumber(Text[7])  && IsNumber(Text[8]))  Posit3 = 1;
    if(IsNumber(Text[9]) && IsNumber(Text[10]) && IsNumber(Text[11])) Posit4 = 1;

     atom_list = atom_list_max();

    if(Posit1) {
        PosX1 = atof(Text[0]);
        PosY1 = atof(Text[1]);
        PosZ1 = atof(Text[2]);
    }
    else {
     sel_list  = ivector(atom_list);

     slong = select_list(Text[0],
                         Text[1],
                         Text[2],sel_list);
       if(slong  > 1) {
             PrintMessage("?ERROR - more than one atom in select list 1");
             free(sel_list);
             return(-1);}
       if(!slong) {
             PrintMessage("?ERROR - no atoms in the selection list 1 ");
             free(sel_list);
             return(-1);}
        PosX1 = x[sel_list[0]];
        PosY1 = y[sel_list[0]];
        PosZ1 = z[sel_list[0]];
    }

    if(Posit2) {
        PosX2 = atof(Text[3]);
        PosY2 = atof(Text[4]);
        PosZ2 = atof(Text[5]);
    }
    else {
     sel_list1 = ivector(atom_list);

     slong1= select_list(Text[3],
                         Text[4],
                         Text[5],sel_list1);
       if(slong1 > 1) {
             PrintMessage("?ERROR - more than one atom in select list 2");
             if(!Posit1)
                 free(sel_list);
                 free(sel_list1);
             return(-1);}
       if(!slong1) {
             PrintMessage("?ERROR - no atoms in the selection list 2 ");
             if(!Posit1)
                 free(sel_list);
                 free(sel_list1);
             return(-1);}
        PosX2 = x[sel_list1[0]];
        PosY2 = y[sel_list1[0]];
        PosZ2 = z[sel_list1[0]];
    }

    if(Posit3) {
        PosX3 = atof(Text[6]);
        PosY3 = atof(Text[7]);
        PosZ3 = atof(Text[8]);
    }
    else {
     sel_list2 = ivector(atom_list);

     slong2= select_list(Text[6],
                         Text[7],
                         Text[8],sel_list2);
       if(slong2 > 1) {
             PrintMessage("?ERROR - more than one atom in select list 3");
             if(!Posit2)
                 free(sel_list);
             if(!Posit2)
                 free(sel_list1);
                 free(sel_list2);
             return(-1);}
       if(!slong2) {
             PrintMessage("?ERROR - no atoms in the selection list 3 ");
             if(!Posit1)
                 free(sel_list);
             if(!Posit2)
                 free(sel_list1);
                 free(sel_list2);
             return(-1);}
        PosX3 = x[sel_list2[0]];
        PosY3 = y[sel_list2[0]];
        PosZ3 = z[sel_list2[0]];
    }

    if(Posit4) {
        PosX4 = atof(Text[9]);
        PosY4 = atof(Text[10]);
        PosZ4 = atof(Text[11]);
    }
    else {
     sel_list3 = ivector(atom_list);

     slong3 = select_list(Text[9],
                          Text[10],
                          Text[11],sel_list3);
       if(slong3 > 1) {
             PrintMessage("?ERROR - more than one atom in select list 4");
             if(!Posit1)
                 free(sel_list);
             if(!Posit2)
                 free(sel_list1);
             if(!Posit3)
                 free(sel_list2);
                 free(sel_list3);
             return(-1);}
       if(!slong3) {
             PrintMessage("?ERROR - no atoms in the selection list 4 ");
             if(!Posit1)
                 free(sel_list);
             if(!Posit2)
                 free(sel_list1);
             if(!Posit3)
                 free(sel_list2);
                 free(sel_list3);
             return(-1);}
        PosX4 = x[sel_list3[0]];
        PosY4 = y[sel_list3[0]];
        PosZ4 = z[sel_list3[0]];
    }

      (void) Dihed(  PosX1 , PosY1 , PosZ1 , 
                     PosX2 , PosY2 , PosZ2 ,
                     PosX3 , PosY3 , PosZ3 , 
                     PosX4 , PosY4 , PosZ4 , &Dist);

      Dist = Dist * 180. / M_PI;

      sprintf(text,"%.3f",Dist);
      if(!Posit1)
          free(sel_list);
      if(!Posit2)
          free(sel_list1);
      if(!Posit3)
          free(sel_list2);
      if(!Posit4)
          free(sel_list3);
      return(0);
    }
    else
         return(-1);
}
