/*  

                       Copyright (c) 1990, 1993 by:
        Leif Laaksonen , Center for Scientific Computing, ESPOO, FINLAND
            Confidential unpublished property of Leif Laaksonen
                        All rights reserved
  

*/

#include <stdio.h>
#include <math.h>
#include <string.h>
#include <malloc.h>
#include "maxdefs.h"
#ifdef sgi
#include <gl/gl.h>
#include <device.h>
#endif

#ifdef sgi
#define MOUSEXMAP(x)  ((LDP_info.NumAtoms1*((x)-Wxorg))/(Wxsize))
#define MOUSEYMAP(y)  ((LDP_info.NumAtoms2*((y)-Wyorg))/(Wysize))
#endif

extern void PrintMessage();
extern void MakeOrtho();
extern void send_command();
extern void SetActiveWindow(long WinId);
extern long GetMainWindowID();
extern int  UsingMultiWindowing();
extern int *ivector(int TakeLen);
extern int select_list();
extern int  HandleInputChange(int Window);
extern int  atom_list_max();

extern short BLACKv[];
extern short WHITEv[];
extern short BLUEv[];
extern short GREENv[];
extern short REDv[];
extern short YELLOWv[];
extern short CYANv[];
extern short bgcolor[]; /* background colour */
extern short txcolor[]; /* text colour       */

     extern int mlist_deep;      /* stack number indicator */
     extern int mlists[MAX_MLIST]; /* First index for molecule list */
     extern int mliste[MAX_MLIST]; /* Second index for molecule list */
     extern char mnlist[MAX_MLIST][BUFF_LEN];
                                /* name list for molecule file names */

extern char parsed[MAXparse][MAXlinel];
extern int winnr; /* number of windows */
extern int win_ids[];

extern float *x;
extern float *y;
extern float *z;
extern int *res1;
extern char *resnam;
extern char *atnam;

extern float near,far;

extern int term_type;
extern int draw_obj_disp;
extern int alpha_trace;
extern float idmat[][4];

extern char mnlist[MAX_MLIST][BUFF_LEN];


/* define the different menus which are in use */
      extern struct MuList {
        int SaveMenu;
        int Menu;          /* = 1 , display main menu
                              = 2 , display dynamics menu
                              = 3 , display ldp menu
                           */
                     } MenuList;


     int ldp_wind = 0; /* = 0 no ldp window open, = 1 ldp window is open */

/*
      Scarecrow is using the following Projection Transformations

      0 => Scarecrow is using ortho
      1 =>                    perspective
*/
      extern struct Projection {
       int Fovy;           /* in tenths of degrees */
       int Transformation; } Model;

/* structure to contain information about window update */
   extern struct {
     int MainW;      /* Main window          */
     int LDPW;       /* Distance plot window */
     int Rama;       /* Ramachandran plot    */
     int Cluster;    /* Cluster plot         */
   } WUpdate;


int BuildLDPList();
int DeleteLDPList();
int PushAtomToLDP(int Watom , char *segm , char *resi , char *atom);

    struct LDP_Struct {
       char Atom1[MAX_ATM_NAME_LEN];   /* first atom in list      */
       char Resi1[MAX_RES_NAME_LEN];
       char Segm1[MAX_SEG_NAME_LEN];
       char Atom2[MAX_ATM_NAME_LEN];   /* second atom in list     */
       char Resi2[MAX_RES_NAME_LEN];
       char Segm2[MAX_SEG_NAME_LEN];
       int  NumAtoms1;              /* number of atoms in list 1 */
       int  *AtomIndexList1;        /* Atom index list of entries 1 */
       int  NumAtoms2;              /* number of atoms in list 2 */
       int  *AtomIndexList2;        /* Atom index list of entries 2 */
     }  LDP_info;

struct {
     float min1;
     float max1;
     float min2;
     float max2;
     float min3;
     float max3;
     float min4;
     float max4;
     float rest;} LDPBounds = { 3.5 , 4.0 , 4.0 , 6.0 , 6.0 , 8.0 , 8.0 ,
                                    10.0 , 10.0};


     int ChangeLDPBounds();
     int ResetLDPBounds();

/***********************************************************************/
pre_ldp()
/***********************************************************************/
{
       char TempS[BUFF_LEN];
       static float min1,min2,min3,min4;
       static float max1,max2,max3,max4;
       static float rest;
       static float saveM[4][4];
       static float saveP[4][4];

#ifdef sgi

     if(term_type == 1 || term_type == 3) {

     if(!WUpdate.LDPW) return;

     if(OrderLDPWindow(LDP_PLOT)) {
        PrintMessage("?ERROR - in window handling in LDP plot");
        return;}

     min1  = LDPBounds.min1;
      max1 = LDPBounds.max1;
     min2  = LDPBounds.min2;
      max2 = LDPBounds.max2;
     min3  = LDPBounds.min3;
      max3 = LDPBounds.max3;
     min4  = LDPBounds.min4;
      max4 = LDPBounds.max4;
     rest  = LDPBounds.rest;

/*
    PrintMessage("The displayed intervals are:");
    sprintf(TempS,"          dist <  %4.2f \n",min1);
    PrintMessage(TempS);
    sprintf(TempS,"%4.2f   < dist <  %4.2f \n",min1,max1);
    PrintMessage(TempS);
    sprintf(TempS,"%4.2f   < dist <  %4.2f \n",min2,max2);
    PrintMessage(TempS);
    sprintf(TempS,"%4.2f   < dist <  %4.2f \n",min3,max3);
    PrintMessage(TempS);
    sprintf(TempS,"%4.2f   < dist <  %4.2f \n",min4,max4);
    PrintMessage(TempS);
    sprintf(TempS,"%4.2f   < dist          \n\n",rest);
    PrintMessage(TempS);
*/
    if(BuildLDPList()) { /* prepare the lists */
      PrintMessage("?ERROR - can't build the LDP lists");
      return;}

    sprintf(TempS,"(1) Number of '%s' atoms is: %d",LDP_info.Atom1,
                                                LDP_info.NumAtoms1);
    PrintMessage(TempS);

    sprintf(TempS,"(2) Number of '%s' atoms is: %d",LDP_info.Atom2,
                                                LDP_info.NumAtoms2);
    PrintMessage(TempS);


      if(LDP_info.NumAtoms1 < 1) {
        PrintMessage("?WARNING - no atoms in list (1) to be displayed ");
         draw_obj_disp = 1;
         ldp_wind = 0;
         (void)DeleteLDPList();
         return;}

      if(LDP_info.NumAtoms2 < 1) {
        PrintMessage("?WARNING - no atoms in list (2) to be displayed ");
         draw_obj_disp = 1;
         ldp_wind = 0;
         (void)DeleteLDPList();
         return;}

      if(Model.Transformation) {
        mmode(MPROJECTION);
        getmatrix(saveP);
        mmode(MVIEWING);}

      getmatrix(saveM); /* save current matrix */
       ortho2(1,LDP_info.NumAtoms1,1,LDP_info.NumAtoms2 );
        loadmatrix(idmat);

/* put background to the current background colour */
      c3s(bgcolor);
      clear();
      c3s(WHITEv);

     draw_ldp(LDP_info.NumAtoms1 , 
              LDP_info.NumAtoms2 ,
              min1,min2,min3,min4,max1,max2,max3,max4,rest);

     MakeOrtho(); /* back to real life */

     loadmatrix(saveM);

      if(Model.Transformation) {
        mmode(MPROJECTION);
        loadmatrix(saveP);
        mmode(MVIEWING);}

      if(UsingMultiWindowing()) {
         ScareSwapbuffers();
         winset(GetMainWindowID());}
     }
     else {
     PrintMessage("?ERROR - not implemented on this device ");
     return;}

#else

  PrintMessage("?ERROR - not implemented on this device ");

#endif

}

/*  drawit handles the 2-d plotting of the distance matrix  */
/***********************************************************************/
draw_ldp(num1, num2,min1,min2,min3,min4,max1,max2,max3,max4,rest)
       int num1;
       int num2;
       float min1,min2,min3,min4;
       float max1,max2,max3,max4;
       float rest;
/***********************************************************************/
{
      float vec[2],dist,st;
      long xsize1,ysize1;
      long xorg1,yorg1;
      char text[BUFF_LEN];
      static float RotT[4][4],tmp1,tmp2,tmp3;
      static float saveP[4][4];
      static int i,ii,j,jj,k;

#ifdef sgi
      

/* Plot the distance matrix */ 

      if(Model.Transformation) {
        mmode(MPROJECTION);
        getmatrix(saveP);
        mmode(MVIEWING);}

      getmatrix(RotT);

      getsize(&xsize1,&ysize1);
      getorigin(&xorg1,&yorg1);

      ortho2(1,num1,1,num2 );

      st=0.5;

      for(i=0 ; i < num1 ; i++) {
       for(j=i+1 ; j < num2 ; j++)   {

        jj = LDP_info.AtomIndexList2[j];
        ii = LDP_info.AtomIndexList1[i];
             tmp1 = (x[ii]-x[jj]);
             tmp2 = (y[ii]-y[jj]);
             tmp3 = (z[ii]-z[jj]);

        dist=sqrt( tmp1 * tmp1 + 
                   tmp2 * tmp2 + 
                   tmp3 * tmp3);

         c3s(WHITEv);

        if(dist > min1 && dist < max1 ) c3s(GREENv);

        if(dist >= min2 && dist < max2) c3s(BLUEv);

        if(dist >= min3 && dist < max3) c3s(REDv);

        if(dist >= min4 && dist < max4) c3s(YELLOWv);

        if(dist >= rest ) c3s(CYANv);

        bgnpolygon();

        vec[0]=(float)(i);
        vec[1]=(float)(j); 
        v2f(vec);
        vec[0]=(float)(i+1);
        vec[1]=(float)(j  );
        v2f(vec);
        vec[0]=(float)(i+1);
        vec[1]=(float)(j+1);
        v2f(vec);
        vec[0]=(float)(i  );
        vec[1]=(float)(j+1);
        v2f(vec);

        endpolygon();

        }
       }

      c3s(BLACKv);

      k=num1/50;

      if( k > 0) {

      for(i=1 ; i <= k ; i++) {

      j=50*i;

      move2i(j,1);
      draw2i(j,num1);

            }}

      k=num2/50;

      if( k > 0) {

      for(i=1 ; i <= k ; i++) {

      j=50*i;

      move2i(1,j);
      draw2i(num2,j);

      }
      }


      c3s(WHITEv);
      cmov2(num1/2.1,4.0*num2/10.);
       sprintf(text,"         dist <  %4.2f  WHITE",min1);
      charstr(text);
      c3s(GREENv);
      cmov2(num1/2.1,3.5*num2/10.);
       sprintf(text," %4.2f  < dist <  %4.2f  GREEN",min1,max1);
      charstr(text);
      c3s(BLUEv);
      cmov2(num1/2.1,3.0*num2/10.);
       sprintf(text," %4.2f  < dist <  %4.2f  BLUE ",min2,max2);
      charstr(text);
      c3s(REDv);
      cmov2(num1/2.1,2.5*num2/10.);
       sprintf(text," %4.2f  < dist <  %4.2f  RED  ",min3,max3);
      charstr(text);
      c3s(YELLOWv);
      cmov2(num1/2.1,2.0*num2/10.);
       sprintf(text," %4.2f  < dist <  %4.2f  YELLOW",min4,max4);
      charstr(text);
      c3s(CYANv);
      cmov2(num1/2.1,1.5*num2/10.);
       sprintf(text," %4.2f  < dist           CYAN",rest);
      charstr(text);

      c3s(txcolor);
      cmov2(num1/6.1,num2/10.);
      charstr("Input file name: ");
      charstr(mnlist[0]); /* gives always the name of the FIRST molecule */

      MakeOrtho();
      loadmatrix(RotT);

      if(Model.Transformation) {
        mmode(MPROJECTION);
        loadmatrix(saveP);
        mmode(MVIEWING);}

#else
      PrintMessage("?ERROR - not implemented on this device ");
#endif
}

#ifdef sgi
/***********************************************************************/
PollLdpMouse()
/***********************************************************************/
{
       static short Wval;
       static long Wdev;
       static long Wxsize;
        static long Wysize;
       static long Wxorg;
        static long Wyorg;

       static int Wxc;
        static int Wyc;
 
       static long ReturnMenu,Wmenuval;

       static int i,j;

       char OutText[BUFF_LEN];

       ReturnMenu = defpup(
       "Return Menu %t | Return %x1 | Exit %x2");

       getsize(&Wxsize , &Wysize);
       getorigin(&Wxorg , &Wyorg);

       for(;;) {

        while(qtest()) {
         Wdev=qread(&Wval);

       if (Wdev == LEFTMOUSE && Wval) {
       Wxc=getvaluator(MOUSEX);
       Wyc=getvaluator(MOUSEY);
       Wxc=MOUSEXMAP(Wxc) + 1;
       Wyc=MOUSEYMAP(Wyc) + 1;

       if( (Wxc <= LDP_info.NumAtoms1 && Wxc >= 1) && Wyc >= Wxc ) {

       i = LDP_info.AtomIndexList1[Wxc - 1];
       j = LDP_info.AtomIndexList2[Wyc - 1];

       sprintf(OutText," #1 %d %.4s %d #2 %d %.4s %d ",
              Wxc,resnam+(4*i),res1[i],
              Wyc,resnam+(4*j),res1[j]);
       PrintMessage(OutText);
       break;}
       else {
       setbell(1); ringbell(); }
        }

       else if (Wdev == RKEY && Wval) { 
        freepup(ReturnMenu);
        return;}

       else if (Wdev == ESCKEY && Wval) {
        freepup(ReturnMenu);
        qreset();
        return;}

       else if(Wdev== REDRAW && Wval) { 
        bang_it();}

       else if (Wdev == INPUTCHANGE) {
                if(HandleInputChange((int)Wval))
                   PrintMessage("?ERROR - in handling of input change");
       }
                   
       else if(Wdev == MENUBUTTON) {

        Wmenuval = dopup(ReturnMenu);

          switch(Wmenuval) {
	  case 1: freepup(ReturnMenu);
                  winset(GetMainWindowID());
                  return;
          case 2: shut_down(0);}}
       }}
}


#endif
/***********************************************************************/
int BuildLDPList() 
/***********************************************************************/
{

  register int IndexList1;
  register int IndexList2;
  register int Iloop;

  int *sel_list;

  if(DeleteLDPList()) {
     PrintMessage("?ERROR - can't build LDP structure");
     return(1);}


  sel_list           = ivector(atom_list_max());
  LDP_info.NumAtoms1 = select_list(LDP_info.Segm1 , 
                                   LDP_info.Resi1 ,
                                   LDP_info.Atom1 , sel_list);

  if(!LDP_info.NumAtoms1) {
      PrintMessage("?ERROR - no atoms in selection list (1)");
      return(1);}

  LDP_info.AtomIndexList1 = ivector(LDP_info.NumAtoms1);
  if(LDP_info.AtomIndexList1 == NULL) {
     PrintMessage("?ERROR - can't get space in building the LDP strcuture");
     return(1);}

  for(Iloop = 0 ; Iloop < LDP_info.NumAtoms1 ; Iloop++)
                  LDP_info.AtomIndexList1[Iloop] = sel_list[Iloop];

  free(sel_list);

  sel_list           = ivector(atom_list_max());
  LDP_info.NumAtoms2 = select_list(LDP_info.Segm2 ,
                                   LDP_info.Resi2 ,
                                   LDP_info.Atom2 , sel_list);

  if(!LDP_info.NumAtoms2) {
          PrintMessage("?ERROR - no atoms in selection list (2)");
	        return(1);}

  LDP_info.AtomIndexList2 = ivector(LDP_info.NumAtoms2);
  if(LDP_info.AtomIndexList2 == NULL) {
     PrintMessage("?ERROR - can't get space in building the LDP strcuture");
     return(1);}

  for(Iloop = 0 ; Iloop < LDP_info.NumAtoms2 ; Iloop++)
                  LDP_info.AtomIndexList2[Iloop] = sel_list[Iloop];

  free(sel_list);

  return(0);
}
/***********************************************************************/
int DeleteLDPList()
/***********************************************************************/
{
    if(LDP_info.NumAtoms1) free(LDP_info.AtomIndexList1);
    LDP_info.NumAtoms1 = 0;
    if(LDP_info.NumAtoms2) free(LDP_info.AtomIndexList2);
    LDP_info.NumAtoms2 = 0;
    return(0);
}

/***********************************************************************/
int PushAtomToLDP(int Watom , char *segm , char *resi , char *atom)
/***********************************************************************/
{
     switch(Watom) {

     case 1: /* atom 1 */
             if(segm[0] == '\0') {
             strncpy(LDP_info.Atom1,"CA",MAX_ATM_NAME_LEN);
             strncpy(LDP_info.Resi1,"*",MAX_RES_NAME_LEN);
             strncpy(LDP_info.Segm1,"*",MAX_SEG_NAME_LEN);}
             else {
             strncpy(LDP_info.Atom1,atom,MAX_ATM_NAME_LEN);
             strncpy(LDP_info.Resi1,resi,MAX_RES_NAME_LEN);
             strncpy(LDP_info.Segm1,segm,MAX_SEG_NAME_LEN);}
             break;
     case 2: /* atom 2 */
             if(segm[0] == '\0') {
             strncpy(LDP_info.Atom2,"CA",MAX_ATM_NAME_LEN);
             strncpy(LDP_info.Resi2,"*",MAX_RES_NAME_LEN);
             strncpy(LDP_info.Segm2,"*",MAX_SEG_NAME_LEN);}
             else {
             strncpy(LDP_info.Atom2,atom,MAX_ATM_NAME_LEN);
	     strncpy(LDP_info.Resi2,resi,MAX_RES_NAME_LEN);
	     strncpy(LDP_info.Segm2,segm,MAX_SEG_NAME_LEN);}
	   }

      return(0);
}


/***********************************************************************/
int ChangeLDPBounds( char *text1 , char *text2 , char *text3 ,
                     char *text4 , char *text5 , char *text6 ,
                     char *text7 , char *text8 , char *text9)
/***********************************************************************/
{

     LDPBounds.min1 = atof(text1);
     LDPBounds.max1 = atof(text2);
     LDPBounds.min2 = atof(text3);
     LDPBounds.max2 = atof(text4);
     LDPBounds.min3 = atof(text5);
     LDPBounds.max3 = atof(text6);
     LDPBounds.min4 = atof(text7);
     LDPBounds.max4 = atof(text8);
     LDPBounds.rest = atof(text9);
      
     return(0);
}


/***********************************************************************/
int ResetLDPBounds()
/***********************************************************************/
{

     LDPBounds.min1 = 3.5;
     LDPBounds.max1 = 4.0;
     LDPBounds.min2 = 4.0;
     LDPBounds.max2 = 6.0;
     LDPBounds.min3 = 6.0;
     LDPBounds.max3 = 8.0;
     LDPBounds.min4 = 8.0;
     LDPBounds.max4 = 10.0;
     LDPBounds.rest = 10.0;
      
     return(0);
}
