/*****************************************************************************
* 
* The following source code is in the public domain.
* Specifically, we give to the public domain all rights for future licensing
* of the source code, all resale rights, and all publishing rights.
* 
* We ask, but do not require, that the following message be included in all
* derived works:
* 
* Portions developed at the National Center for Supercomputing Applications at
* the University of Illinois at Urbana-Champaign.
* 
* THE UNIVERSITY OF ILLINOIS GIVES NO WARRANTY, EXPRESSED OR IMPLIED, FOR THE
* SOFTWARE AND/OR DOCUMENTATION PROVIDED, INCLUDING, WITHOUT LIMITATION,
* WARRANTY OF MERCHANTABILITY AND WARRANTY OF FITNESS FOR A PARTICULAR PURPOSE
* 
****************************************************************************/

#include <stdio.h>
#ifdef SGI
#include <gl.h>
#include <device.h>
#if SGI_IMAGE
#include <gl/image.h>
#endif
#endif
#include <math.h>
#include "isovis.h"


#ifdef sgi

#define TRANSPARENCY
#ifdef TRANSPARENCY
static transp;
#endif
static long backc;
static float zdist;
static int have_stencil;
#define TORADIANS(x)	((x)*M_PI/180.)

#define DISPLAY_LIST

#ifdef DISPLAY_LIST
static float *vlist, *nlist;
static int vsize;
#endif

int shade;
int show_normals;

draw_normals(p, n, nv)
float *p, *n;
{
    struct { float x, y, z; } nn;
    int i;

    cpack(0xFF00FFFF);
    for (i = 0; i < nv; i++) {
	nn.x = *n++ + *p++;
	nn.y = *n++ + *p++;
	nn.z = *n++ + *p++;
	bgnline(); v3f(p - 3); v3f(&nn); endline();
    }
}

#ifdef DISPLAY_LIST
static tmesh_obj;

make_tmesh() {
    if (VERBOSE) printf("tmeshing ... ");
    tmesh_obj = tmesh(vlist,nlist,vsize, (NORMAL_TYPE ? 1 : 0));
    if (VERBOSE) printf("done\n");
}

display(p, n, nvert)
float *p;
float *n;
int    nvert;
{
    static wire_obj;
    static norm_obj;

    if (!tmesh_obj && shade != 2) {

	if (VERBOSE) printf("tmeshing ... ");
	tmesh_obj = tmesh(p,n,nvert, (NORMAL_TYPE ? 1 : 0));
	if (VERBOSE) printf("done\n");
    }
    if (shade == 2 || shade == 3) {

	if (!wire_obj) {
	    int i;
	    if (VERBOSE) printf("creating wire obj\n");
#ifdef FOO
	    makeobj(wire_obj = genobj());
	    for (i = 0; i < nvert / 3; i++, p += 9) {
		bgnclosedline();
		v3f(p); v3f(p + 3); v3f(p + 6);
		endclosedline();
	    }
	    closeobj();
	    p -= nvert*3;
#else
	    wire_obj = trilines(p, nvert);
#endif
	}

#ifdef ANTIALIAS
	if (antialias) {
	    linesmooth(SML_ON|SML_SMOOTHER|SML_END_CORRECT);
	    blendfunction(BF_SA, BF_MSA);
	    callobj(wire_obj);
	    blendfunction(BF_ONE, BF_ZERO);
	    linesmooth(SML_OFF);
	} else
	    callobj(wire_obj);
#else
	callobj(wire_obj);
#endif
#ifdef POLYMODE
out:;
#endif
    } else if (shade < 2) {
	callobj(tmesh_obj);
    }
    if (show_normals) {
	if (!norm_obj) {
	    if(VERBOSE) printf("creating normal obj\n");
#ifdef FOO
	    makeobj(norm_obj = genobj());
	    draw_normals(p, n, nvert);
	    closeobj();
#else
	    norm_obj = trinorms(p, n, nvert, 1.0);
#endif
	}
	cpack(0xFF00FFFF);
#ifdef ANTIALIAS
	if (antialias) {
	    linesmooth(SML_ON|SML_SMOOTHER|SML_END_CORRECT);
	    blendfunction(BF_SA, BF_MSA);
	    callobj(norm_obj);
	    blendfunction(BF_ONE, BF_ZERO);
	    linesmooth(SML_OFF);
	} else
	    callobj(norm_obj);
#else
	callobj(norm_obj);
#endif
    }
}
#endif

write_sgi(p, n, nvert)
float *p;
float *n;
int    nvert;
{
    int i;
/*
#define SMOOTH
#ifdef SMOOTH
    static smoothed;
    if (!NORMAL_TYPE && !smoothed) {
	printf("smoothing ... ");
	smooth(p, n, nvert);
	printf("done\n");
	shade = 1;
	shademodel(GOURAUD);
	smoothed++;
    }
#endif
*/
    if (BBOX) {
	struct { float x, y, z; } v;
	cpack(0xFFFFFF00);
#ifdef ANTIALIAS
	if (antialias) {
	    linesmooth(SML_ON|SML_SMOOTHER|SML_END_CORRECT);
	    blendfunction(BF_SA, BF_MSA);
	}
#endif
	bgnclosedline();
	v.x = -XDIM/2; v.y = -YDIM/2; v.z = -ZDIM/2;
	v3f(&v);
	v.x = XDIM/2; v3f(&v);
	v.y = YDIM/2; v3f(&v);
	v.x = -XDIM/2; v3f(&v);
	v.y = -YDIM/2; /*v3f(&v);*/
	endclosedline();
	bgnclosedline();
	v.z = ZDIM/2; v3f(&v);
	v.x = XDIM/2; v3f(&v);
	v.y = YDIM/2; v3f(&v);
	v.x = -XDIM/2; v3f(&v);
	v.y = -YDIM/2; /*v3f(&v);*/
	endclosedline();
	bgnline(); v3f(&v); v.z = -ZDIM/2; v3f(&v); endline();
	v.x = XDIM/2;
	bgnline(); v3f(&v); v.z = ZDIM/2; v3f(&v); endline();
	v.y = YDIM/2;
	bgnline(); v3f(&v); v.z = -ZDIM/2; v3f(&v); endline();
	v.x = -XDIM/2;
	bgnline(); v3f(&v); v.z = ZDIM/2; v3f(&v); endline();
#ifdef ANTIALIAS
	if (antialias) {
	    blendfunction(BF_ONE, BF_ZERO);
	    linesmooth(SML_OFF);
	}
#endif
      }
    vlist = p; nlist = n; vsize = nvert;
    if (shade == 2 || shade == 3) {
	if (shade == 3) {
	    cpack(backc);
	    for (i = 0; i < nvert / 3; i++, p += 9) {
#define TMESH
#ifdef TMESH
		bgntmesh();
		v3f(p);
		v3f(p + 3);
		v3f(p + 6);
		endtmesh();
#else
		bgnpolygon();
		v3f(p);
		v3f(p + 3);
		v3f(p + 6);
		endpolygon();
#endif
	    }
	    p -= nvert*3;
	}

	for (i = 0; i < nvert / 3; i++, p += 9) {
	    bgnclosedline();
	    v3f(p);
	    v3f(p + 3);
	    v3f(p + 6);
	    v3f(p);
	    endclosedline();
	}
	p -= nvert*3;
    } else if (shade < 2) {
#ifdef SMOOTH
	if (NORMAL_TYPE || smoothed) {
#else
	if (NORMAL_TYPE) {
#endif
	    for (i = 0; i < nvert / 3; i++, p += 9, n += 9) {
#define TMESH
#ifdef TMESH
		bgntmesh();
		n3f(n);
		v3f(p);
		n3f(n + 3);
		v3f(p + 3);
		n3f(n + 6);
		v3f(p + 6);
		endtmesh();
#else
		bgnpolygon();
		n3f(n);
		v3f(p);
		n3f(n + 3);
		v3f(p + 3);
		n3f(n + 6);
		v3f(p + 6);
		endpolygon();
#endif
	    }
	} else {
	    for (i = 0; i < nvert / 3; i++, p += 9, n += 9) {
		bgnpolygon();
		n3f(n);
		v3f(p);
		v3f(p + 3);
		v3f(p + 6);
		endpolygon();
	    }
	}
	p -= nvert*3; n -= nvert*3;
    }
    if (show_normals)
	draw_normals(p, n, nvert);
}

#endif	/* SGI */
