/*****************************************************************************
* 
* The following source code is in the public domain.
* Specifically, we give to the public domain all rights for future licensing
* of the source code, all resale rights, and all publishing rights.
* 
* We ask, but do not require, that the following message be included in all
* derived works:
* 
* Portions developed at the National Center for Supercomputing Applications at
* the University of Illinois at Urbana-Champaign.
* 
* THE UNIVERSITY OF ILLINOIS GIVES NO WARRANTY, EXPRESSED OR IMPLIED, FOR THE
* SOFTWARE AND/OR DOCUMENTATION PROVIDED, INCLUDING, WITHOUT LIMITATION,
* WARRANTY OF MERCHANTABILITY AND WARRANTY OF FITNESS FOR A PARTICULAR PURPOSE
* 
****************************************************************************/
/*
     This code has extensively been modified by
     Leif Laaksonen, Centre for Scientific Computing, Espoo, Finland
     1992
*/


#include <stdio.h>
#include <sys/types.h>
#include <malloc.h>
#ifdef sgi
#include <gl/gl.h>
#include <device.h>
#endif
#include "maxdefs.h"
#include "isovis.h"

#define Rabs(a)    ( ( a ) > 0.0 ? (a) : -(a))

#define TRANSLATE(a,b,c) translateO(a,b,c) /* use own translation function */

     extern float AUtoA;
     extern float sumx,sumy,sumz;

/* contour structure */

     extern int    ContoursDefined;   /* number of contours defined */

     extern struct Contour_Struct {
     float *data;           /* contour data */
     float min;
     float max;
     int xdim;
     int ydim;
     int zdim;
     float Xtrans;
     float Ytrans;
     float Ztrans;
     float Xscale;
     float Yscale;
     float Zscale;
     float ColVal[MAX_CONT];
     int   NumVal;
     char  ColNam[MAX_CONT][BUFF_LEN];
     char  ContFile[BUFF_LEN];
     float AlphaBlend;
     int   ContSmooth;
     char  Name[BUFF_LEN];
     int  Display;} ContourInfo[MAX_CONTOURS];



/**************************** get_data ****************************/
/**************************** get_data ****************************/
/**************************** get_data ****************************/
/**************************** get_data ****************************/

int get_data(filename,data,xdim,ydim,zdim)
char *filename;
float **data;
int *xdim,*ydim,*zdim;
/* This subroutine will read in the data file. */
{

  int rank;
  int shape[3];
  int size;
  int ret;
  char OutText[BUFF_LEN];

  ret=SCAREgetdims(filename,&rank,shape,3);
  if (ret != 0) {
     sprintf(OutText,"%s: error from SCAREgetdims %d for %s",
             MY_NAME,ret,filename);
     PrintMessage(OutText);
     return -1;
  }

  if (rank != 3) {
     sprintf(OutText,"%s: error from SCAREgetdims %d for %s",
             MY_NAME,ret,filename);
     PrintMessage(OutText);
     return -1;
  }

  *xdim = shape[0];  *ydim = shape[1];  *zdim = shape[2];
  if (VERBOSE)
     printf("%s: data set size xdim=%d ydim=%d zdim=%d\n",
            MY_NAME,*xdim,*ydim,*zdim);

  size = (*xdim) * (*ydim) * (*zdim) * sizeof(float);

  if ((*data = (float *)malloc(size)) == NULL) {
    sprintf(OutText,"%s: error, not enough memory for the data set\n",MY_NAME);
    PrintMessage(OutText);
    sprintf(OutText,"Need space for '%d * %d * %d = %d' entries",
                     *xdim,*ydim,*zdim,
                    (*xdim)*(*ydim)*(*zdim));
    PrintMessage(OutText);
    fclose(ISO_file);
    return -1;
  }


  ret=SCAREgetdata(filename,rank,shape,*data);
  if (ret != 0) {
     sprintf(OutText,"%s: error from SCAREgetdata %d file %s",
             MY_NAME,ret,filename);
     PrintMessage(OutText);
     return -1;
  }

  return 0;
}

#define RECORD()   { Items = \
                   fread(&record, sizeof(int) , 1L , ISO_file);\
                   if(Items < 1) {\
                     PrintMessage("?ERROR - in reading contour file (*)");\
                     fclose(ISO_file);\
                     return(1);}}

#define FREAD(value_p , size)    { Items = \
                                 fread(value_p, size , 1L , ISO_file);\
                                 if(Items < 1) {\
                     PrintMessage("?ERROR - in reading contour file (**)");\
                     fclose(ISO_file);\
                     return(2);}}

#define FREADN(value_p , num , size) { Items = \
                                fread(value_p, size , num , ISO_file);\
                   if(Items != num) {\
                     PrintMessage("?ERROR - in reading contour file (***)");\
                     fclose(ISO_file);\
                     return(3);}}


/**************************** SCAREgetdims ****************************/
/**************************** SCAREgetdims ****************************/
/**************************** SCAREgetdims ****************************/
/**************************** SCAREgetdims ****************************/
int SCAREgetdims(filename,rank,shape,unknown)
      char *filename;
      int  *rank;
      int   shape[];
      int   unknown;
{
      char OutText[BUFF_LEN];
      int Items;
      
      ISO_file = fopen(filename,"rb");
      if(ISO_file == NULL) {
         printf("?ERROR - can't open file contour file '%s'\n",filename);
         return(1);}

/* first position is the rank */
       FREAD(rank, sizeof(int));

/* type of surface            */
       FREAD(&TypeOfSurface, sizeof(int));

       if(VERBOSE) {
         switch(TypeOfSurface) {
         case 0: 
         PrintMessage("?WARNING - unknown surface type ");
         break;
          case 1:
          PrintMessage("=> Reading a VSS surface ");
          break;
           case 2:
           PrintMessage("=> Reading an orbital/density surface");
           break;
            case 3:
            PrintMessage("=> Reading a probe surface");
            break;}}

/* read shape ...             */
        FREAD(&shape[2] , sizeof(int));
        FREAD(&shape[1] , sizeof(int));
        FREAD(&shape[0] , sizeof(int));
       
       if(VERBOSE)
         printf("zdim: %d , ydim: %d , xdim: %d\n",shape[2],shape[1],shape[0]);
/* done with shape */

/* read min/max ... */
       FREAD(&ISO_zmin , sizeof(float));
       FREAD(&ISO_zmax , sizeof(float));
        FREAD(&ISO_ymin , sizeof(float));
        FREAD(&ISO_ymax , sizeof(float));
         FREAD(&ISO_xmin , sizeof(float));
         FREAD(&ISO_xmax , sizeof(float));

       if(VERBOSE)
         printf("x: %f %f \ny: %f %f \nz: %f %f\n",
         ISO_zmin,
         ISO_zmax,
         ISO_ymin,
         ISO_ymax,
         ISO_xmin,
         ISO_xmax);
          
/* done with min/max */

      ISO_StepX = (ISO_xmax - ISO_xmin) / 2.0 + ISO_xmin - sumx;
       ISO_StepY = (ISO_ymax - ISO_ymin) / 2.0 + ISO_ymin - sumy;
        ISO_StepZ = (ISO_zmax - ISO_zmin) / 2.0 + ISO_zmin - sumz;

      if(VERBOSE)
       printf("Translate %f %f %f \n",ISO_StepX,ISO_StepY,ISO_StepZ);

      ContourInfo[ContoursDefined].Xtrans = ISO_StepX;
       ContourInfo[ContoursDefined].Ytrans = ISO_StepY;
        ContourInfo[ContoursDefined].Ztrans = ISO_StepZ;

      ISO_StepX = (ISO_xmax - ISO_xmin) / ((float) (shape[0] - 1));
      ISO_StepY = (ISO_ymax - ISO_ymin) / ((float) (shape[1] - 1));
      ISO_StepZ = (ISO_zmax - ISO_zmin) / ((float) (shape[2] - 1));

      if(VERBOSE)
        printf("Scale %f %f %f \n",ISO_StepX,ISO_StepY,ISO_StepZ);

      ContourInfo[ContoursDefined].Xscale = ISO_StepX;
       ContourInfo[ContoursDefined].Yscale = ISO_StepY;
        ContourInfo[ContoursDefined].Zscale = ISO_StepZ;

    return(0);
  }

/**************************** SCAREgetdata ****************************/
/**************************** SCAREgetdata ****************************/
/**************************** SCAREgetdata ****************************/
/**************************** SCAREgetdata ****************************/
int SCAREgetdata(filename,rank,shape,data)
      char *filename;
      int rank;
      int *shape;
      float *data;
{   
      int Items;
      int size;

      size = shape[2] * shape[1] * shape[0];

      FREADN(data , size , sizeof(float));

      fclose(ISO_file);

      return(0);
  }


