/*  

                       Copyright (c) 1990, 1992 by:
        Leif Laaksonen , Centre for Scientific Computing, ESPOO, FINLAND
            Confidential unpublished property of Leif Laaksonen
                        All rights reserved
  

*/

#include <stdio.h>
#include <math.h>
#include <string.h>
#include <ctype.h>
#include <malloc.h>
#include "maxdefs.h"
#include "mopac5_key.h"

#define CHARGED_RESIDUES 16
#define NUM_ATOMS  19
#define CONV_ATOMS 57
#define DEFAULT_ICON8     "icon8.inp"
#define DEFAULT_MOPAC     "mopac6.inp"
#define DEFAULT_PROBESURF "probesurf.inp"
#define DEFAULT_VSS       "vss_scare.inp"
#define DEFAULT_DENSITY   "density.inp"
#define WRITE_STRUC() { sprintf(OutText,"\n Writing structure: %d ",\
                                                 (current_struct+1));\
                        PrintMessage(OutText);}

    extern int    numat;
    extern char  *disp_list;
    extern char  *element;
    extern int    element_p[MAXelements];
    extern float *x,*y,*z;
    extern int   *res1,*res2;
    extern float *atm_charge;
    extern char  *resnam,*atnam,*segment;
    extern float  sumx,sumy,sumz;
    extern char  *cvector();
    extern float *vdw_list;
    extern float  near,far;
    extern int    term_type;
    extern void   PrintMessage();
    extern int    ShowForm1();
    extern int    ShowForm2();
    extern int    ShowForm3();
    extern int   *ivector();
    extern float *vector();

     extern int current_struct;
     extern int mlist_deep;      /* stack number indicator */
     extern int mlists[MAX_MLIST]; /* First index for molecule list */
     extern int mliste[MAX_MLIST]; /* Second index for molecule list */
     extern char mnlist[MAX_MLIST][BUFF_LEN]; 
                                /* name list for molecule file names */

/* stack to contain the different atnam, resnam */
    extern char *atnam_stack;
    extern int   atnam_stack_deep;
    extern int   atnam_stack_max;
    extern int  *atnam_stack_num;
    extern char *resnam_stack;   /* and segment names */
    extern int   resnam_stack_deep; 
    extern int   resnam_stack_max;
    extern int  *resnam_stack_num;
    extern char *segment_stack;
    extern int   segment_stack_deep;
    extern int   segment_stack_max;

    extern char parsed[MAXparse][MAXlinel];
    extern void build_name_stack();

    extern int trace_wind; /* = 0 , no display , = 1 trace display */

/* structure to hold the trace of atoms       */

   extern struct {
    int trace_on;        /* switch to indicate that a trace is saved (=1)   */
    int trace_sets;      /* number of trace sets                            */
    int trace_step;      /* step length                                     */
    int *trace_atoms;    /* number of traced atoms in each set              */
    int *trace_list;     /* list of atoms to be traced                      */
    float *trx;          /* array to contain the x coordinates of the trace */
    float *try;
    float *trz;} trace_info;

/* structure for the dynamics trajectory file */

   extern struct {
    char traj_file[BUFF_LEN];                 /* file name          */
    int natom;                                /* number of atoms    */
    int nstep;                                /* number of steps    */
    int time_bw_steps;                        /* time between steps */
    int time_first_frame;                     /* time of first frame */
    int first_frame;                          /* first frame to be displayed */
    int last_frame;                           /* last frame to be displayed  */
    int delta_frame;                          /* display every delta frame */
                   }    trajectory_info;     


    struct SURF_LIM {
    int set;             /* = 0 , not set , > 0 set */
    float Xmin;
    float Xmax;
    float Ymin;
    float Ymax;
    float Zmin;
    float Zmax;
    char  MeshFile[BUFF_LEN];
    char  WFFile[BUFF_LEN];
    float ProbeVal;
    int Orbital;
    int Dmethod;
    int Xpts;
    int Ypts;
    int Zpts;
                   } ;

    struct SURF_LIM DENSITY_limits = { 0 , -1. , 1. , -1. , 1. , -1. , 1. ,
                                       "---unknown---", "---unknown---",
                                       0.0 , 1 , 0 , 60 , 60 , 60};
    struct SURF_LIM PROBE_limits =   { 0 , -1. , 1. , -1. , 1. , -1. , 1. ,
                                       "---unknown---", "---unknown---",
                                       1.9 , 0 , 0 , 60 , 60 , 60};
    struct SURF_LIM VSS_limits   =   { 0 , -1. , 1. , -1. , 1. , -1. , 1. ,
                                       "---unknown---", "---unknown---",
                                       0.0 , 0 , 0 , 60 , 60 , 60};

/***********************************************************************/
int input_gen(which_program)  /* input generator for various programs */

     char *which_program;    /*  ICON8
                                 MOPAC5
                                 GAMESS
                                 PROBESURF
                                 DENSITY           */
/***********************************************************************/
{
     extern void tupper(),toller();
     extern int indexo();

     toller(which_program);

     if(indexo(which_program,"icon8") == 1) {
             gen_icon8();
             return(0);}

     if(indexo(which_program,"mopac") == 1) {
             gen_mopac();
             return(0);}

     if(indexo(which_program,"gamess") == 1) {
             gen_gamess();
             return(0);}

     if(indexo(which_program,"probesurf") == 1) {
             gen_probsurf();
             return(0);}

     if(indexo(which_program,"density") == 1) {
             gen_density();
             return(0);}

     if(indexo(which_program,"vss") == 1) {
             gen_vss();
             return(0);}

     printf("?UNKNOWN program interface >%s< \n",which_program);
     return(1);
}


/***********************************************************************/
gen_icon8()    /* generate icon8 input */
/***********************************************************************/
{

/* externals                   */

   extern int numat;
   extern float *x,*y,*z;
   extern int *res1,*res2;
   extern char *resnam,*atnam,*segment;
   extern char *cvector();
   
   FILE *icon8_p;

   static char *print = "FTTTTTTFFTTTTTTFTTTT";
   static char *punch = "FFFFFFFFFTFFFFFFFFFF";
   static char *def_title = "Default title for: ICON8";
   static char *element_vec;
   static char Icon8File[BUFF_LEN] = DEFAULT_ICON8;

   static int i,j,ret_val;
   static int nh; /* number of hydrogen atoms */
   static int na; /* number of heavy atoms    */
   static int charge=0; /* molecular charge   */
   static int meth=0;   /* calculational method desired */
   static int iprint=0;  
   static int ipunch=0;
   static char l1='F';
   static char l2='F';
   static char l3='F';
   static char l4='F';
   static char l5='F';
   static float con=0.0;  /* constant used in H(i,j) formula */
   static float peep=0.0; /* hydrogen orbital exponen (defaulr 1.30) */
   static float coulh=0.0;/* hydrogen H(i,i) (default -13.6) */

   static  int    ChargedResNum = CHARGED_RESIDUES;
   static  char  *ChargedRes =
    "ARGNARG ASP GLU HSC LYSNLYS GLYPCa  Mg  Fe  Zn  Li  Na  K   Cl  ";

   static float  ChargedResVal[CHARGED_RESIDUES] = {
    0.0 , 1.0 , -1.0 , -1.0 , 1.0 , 0.0 , 1.0 , 0.8 , 2.0 , 2.0 , 2.0 , 2.0 ,
    1.0 , 1.0 , 1.0 , -1.0};

   static char OutText[BUFF_LEN];
   static float SCharge;

   static int Switch;

/* Check if an input name is supplied */
   if(parsed[3][0] != '\0') { /* ok there is a name coming ... */
     strncpy(Icon8File,parsed[3],BUFF_LEN);}
   else {
     strncpy(Icon8File,DEFAULT_ICON8,BUFF_LEN);}

   sprintf(OutText,"=> Writing ICON8 input to '%s'",Icon8File);
   PrintMessage(OutText);

/* build the residue name stack ... */
   build_name_stack(2);

   if(resnam_stack_deep < 1) {
     PrintMessage("?ERROR - no residue names defined");
     return;}

/* build the total charge ... */
      SCharge = 0.0;
      for(i = 0 ; i < resnam_stack_deep ; i++) {
         for(j = 0 ; j < CHARGED_RESIDUES ; j++) {
            Switch = 4;
             if(ChargedRes[4*j+3] == ' ') Switch = 3;
              if(ChargedRes[4*j+2] == ' ') Switch = 2;
               if(ChargedRes[4*j+1] == ' ') Switch = 1;
            if(!strncmp(resnam_stack+4*i,ChargedRes+4*j,Switch)) {
               SCharge += ChargedResVal[j];
               break;}
	  }
       }


   icon8_p = fopen(Icon8File,"w");
   if(icon8_p == NULL) {
   sprintf(OutText,"?ERROR - can't open output file '%s'",Icon8File);
   PrintMessage(OutText);
   return;}

/* calculate first number of hydrogens and heavy atoms */

   nh=0;
   na=0;

   for(i = mlists[current_struct] ; i < mliste[current_struct] ; i++) {

      if(disp_list[i] == 0) continue;

      if(strncmp((atnam+4*i),"H",1) == 0) nh++;

      else na++;
   }


   WRITE_STRUC();

   printf("\n\n **** ICON8 input generator \n");
   printf(" Number of heavy atoms    : %d \n",na);
   printf(" Number of hydrogen atoms : %d \n",nh);
   printf(" System charge: %f\n",SCharge);

   if((na+nh) != (mliste[current_struct]-mlists[current_struct])) 
   printf(" Writing a subset of all atoms (na+nh) = %d \n",na+nh);

 element_vec = cvector(2*(mliste[current_struct]-mlists[current_struct] + 1));

   for(i = mlists[current_struct] ; i < mliste[current_struct] ; i++) {
    if(disp_list[i] == 0) continue;
     strncpy(element_vec+2*i,atnam+4*i,2);
   }
   ret_val = which_element(element_vec); /* check the atoms if they are allowed */
   if(ret_val > 0) {
     free(element_vec);
      return;}

   fprintf(icon8_p,"%s\n",def_title); 

/* OBS! I'm killing nh now!  */

   na = nh + na;
   nh = 0;

   charge = SCharge > 0.0 ? (int) (SCharge + 0.5) : (int) (SCharge -0.5);

   fprintf(icon8_p,"%3d%3d%3d%3d%3d%3d%c%c%c%c%c%5.2f%6.3f%6.3f%s%s\n",
          nh,na,charge,meth,iprint,ipunch,l1,l2,l3,l4,l5,con,peep,coulh,
          print,punch);

/* write out the heavy atoms first      */
   for(i = mlists[current_struct] ; i < mliste[current_struct] ; i++) {

      if(disp_list[i] == 0) continue;

      if(strncmp((element_vec+2*i+1),"H",1) == 0) continue;

      fprintf(icon8_p,"%15.6f%15.6f%15.6f\n",(x[i]+sumx),
                                             (y[i]+sumy),
                                             (z[i]+sumz));
   }

/* now the hydrogens                   */
   for(i = mlists[current_struct] ; i < mliste[current_struct] ; i++) {

      if(disp_list[i] == 0) continue;

      if(strncmp((element_vec+2*i+1),"H",1) != 0) continue;

      fprintf(icon8_p,"%15.6f%15.6f%15.6f\n",(x[i]+sumx),
                                             (y[i]+sumy),
                                             (z[i]+sumz));
   }

/* now write the atom labels starting with the heavy atoms */
   j = 0;
   for(i = mlists[current_struct] ; i < mliste[current_struct] ; i++) {

      if(disp_list[i] == 0) continue;

      if(strncmp((element_vec+2*i+1),"H",1) == 0) continue;
      if(j == 40) {
      fprintf(icon8_p,"\n");
      j = 0;}

      fprintf(icon8_p,"%.2s",element_vec+2*i);
      j++;
   }
/* now the hydrogen atoms */

   for(i = mlists[current_struct] ; i < mliste[current_struct] ; i++) {

      if(disp_list[i] == 0) continue;

      if(strncmp((element_vec+2*i+1),"H",1) != 0) continue;
      if(j == 40) {
      fprintf(icon8_p,"\n");
      j = 0;}

      fprintf(icon8_p,"%.2s",element_vec+2*i);
      j++;
   }

   fprintf(icon8_p,"\n");
   fclose(icon8_p);
   free(element_vec);
}  


/**********************************************************************/
int which_element(element_vec)

      char *element_vec;
/**********************************************************************/
{

      extern int numat;

      static int nsymbl= CONV_ATOMS; /* atom symbol list */
/*
*
*/
      static char  *pt =
"?? HHeLiBe B C N O FNeNaMgAlSi P SClArCACBCGCDCECZNANBNGNDNENZOAOBOGODOEOZOHSASBSGSDHHHGHZNHCHOCHAHBHCHDHEHNHTHOCa";
      static char  *PT =
" HHeLiBe B C N O FNeNaMgAlSi P SClArCa";

      static int velec[NUM_ATOMS]  = { 1 , 2 , 1 , 2 , 3 , 4 , 5 , 6 , 7 , 8 ,
                                       1 , 2 , 3 , 4 , 5 , 6 , 7 , 8 , 2};
      static int vshell[NUM_ATOMS] = { 1 , 1 , 1 , 4 , 4 , 4 , 4 , 4 , 4 , 4 ,
                                       1 , 1 , 4 , 4 , 4 , 4 , 4 , 4 , 4};
                                       
      static int ihelpv[CONV_ATOMS] = {0,
                  1,2,
                  3,4,
                  5,6,7,8,9,10,
                  11,12,
                  13,14,15,16,17,18,
                  6,6,6,6,6,6,
                  7,7,7,7,7,7,
                  8,8,8,8,8,8,8,
                  16,16,16,16,
                  1,1,1,7,6,8,1,1,1,1,1,1,1,1,19};
       static int morbit[3] = { 1 , 5 , 14 };
       static int me[3]     = { 2 , 10 , 18 };
       static int mshell    = 3;
       static int natom,norbit,ne;
       static int i,j,swtch,nerror;

       static char OutText[BUFF_LEN];

      natom  = 0;
      norbit = 0;
      ne     = 0;

/* clear all numbers in the element vector */
      for(i = mlists[current_struct] ; i < mliste[current_struct] ; i++) {
         if(disp_list[i] == 0) continue;

         if(element_vec[2*i+1] == ' ' || 
            element_vec[2*i+1] == '\0') {
            element_vec[2*i+1] = element_vec[2*i];
            element_vec[2*i] = ' ';}

         if(isdigit(element_vec[2*i+1])) {
           element_vec[2*i+1] = element_vec[2*i];
           element_vec[2*i] = ' ';}
       }

      for(i = mlists[current_struct] ; i < mliste[current_struct] ; i++) {

       if(disp_list[i] == 0) continue;
       swtch = 0;
       for(j = 0 ; j < nsymbl ; j++) { 
          if(strncmp((element_vec+2*i),(pt+2*j),2) == 0)  {

             strncpy(element_vec+2*i,PT+2*(ihelpv[j]-1),2);
                ne     += velec[ihelpv[j] - 1];
                natom  += 1;
                norbit += vshell[ihelpv[j] - 1];
                swtch   = 1;
                break;

           break;
           }
        }
        if(swtch != 0) continue;

        sprintf(OutText," ?WARNING - undefined element  >%.2s<",
              element_vec+2*i);
        PrintMessage(OutText);
        PrintMessage("Allowed atoms are:\n");
         for(j = 0 ; j < strlen(PT)/ 30 ; j++) {
         sprintf(OutText,"%s",PT+j*30);
         PrintMessage(OutText);}
         if(strlen(PT) - 30 * ( strlen(PT) / 30)) {
           sprintf(OutText,"%s",PT+(strlen(PT) / 30)*30);
           PrintMessage(OutText);}
        nerror++;
      }
        if(nerror > 0) return(1);

        sprintf(OutText," Number of atoms : %d ",natom);
        PrintMessage(OutText);
         sprintf(OutText," Number of orbitals: %d ",norbit);
         PrintMessage(OutText);
          sprintf(OutText," Number of electrons: %d ",ne);
          PrintMessage(OutText);
        return(0);
}

/***********************************************************************/
gen_mopac()    /* generate mopac input */
/***********************************************************************/
{
/* externals                   */

   extern int numat;
   extern float *x,*y,*z;
   extern int *res1,*res2;
   extern char *resnam,*atnam,*segment;
   extern char *cvector();
   
   FILE *mopac_p;

   static char *def_title = "Default title for: MOPAC";
   static char *element_vec;
   static char mopac_input[BUFF_LEN] = DEFAULT_MOPAC;
   static char temp[4];

   static int i,j,k,ret_val,optim = 0;
   static int nh; /* number of hydrogen atoms */
   static int na; /* number of heavy atoms    */
   static int charge=0; /* molecular charge   */

   char OutText[BUFF_LEN];

/* Check if an input name is supplied */
   if(parsed[3][0] != '\0') { /* ok there is a name coming ... */
     strncpy(mopac_input,parsed[3],BUFF_LEN);}
   else {
     strncpy(mopac_input,DEFAULT_MOPAC,BUFF_LEN);}

   sprintf(OutText,"=> Writing MOPAC5 input to '%s'",mopac_input);
   PrintMessage(OutText);

   mopac_p = fopen(mopac_input,"w");
   if(mopac_p == NULL) {
   printf("?ERROR - can't open MOPAC5 input file '%s' \n",mopac_input);
   return;}

/* calculate first number of hydrogens and heavy atoms */

   nh=0;
   na=0;

   for(i = mlists[current_struct] ; i < mliste[current_struct] ; i++) {

      if(disp_list[i] == 0) continue;

      if(strncmp((atnam+4*i),"H",1) == 0) nh++;

      else na++;
   }


   WRITE_STRUC();

   printf("\n\n **** MOPAC5 input generator \n");
   printf(" Number of heavy atoms    : %d \n",na);
   printf(" Number of hydrogen atoms : %d \n",nh);

 element_vec = cvector(2*(mliste[current_struct]-mlists[current_struct] + 1));

   for(i = mlists[current_struct] ; i < mliste[current_struct] ; i++) {
    if(disp_list[i] == 0) continue;
     strncpy(element_vec+2*i,atnam+4*i,2);
   }
   ret_val = which_element(element_vec); /* check the atoms if they are allowed */
   if(ret_val > 0) {
     free(element_vec);
      return;}

/* start writing input file */
   fprintf(mopac_p,"AM1 \n");
   fprintf(mopac_p,"%s\n",def_title);
   fprintf(mopac_p," \n");

   for(i = mlists[current_struct] ; i < mliste[current_struct] ; i++) {

      if(disp_list[i] == 0) continue;

      fprintf(mopac_p,"%.2s %f %d %f %d %f %d \n",element_vec+2*i,x[i],optim,
                                                                  y[i],optim,
                                                                  z[i],optim);}

   fclose(mopac_p);
    free(element_vec);
}


/***********************************************************************/
gen_gamess()    /* generate gamess input */
/***********************************************************************/
{
/* externals                   */

   
   FILE *gamess_p;

   static char *def_title = "Default title for: GAMESS";
   static char *element_vec;
   static char gamess_input[BUFF_LEN] = "gamess.inp";
   static char temp[4];

   static int i,j,k,ret_val,optim = 0;
   static int nh; /* number of hydrogen atoms */
   static int na; /* number of heavy atoms    */
   static int charge=0; /* molecular charge   */

   static float zcore;
   static char OutText[BUFF_LEN];

   gamess_p = fopen(gamess_input,"w");
   if(gamess_p == NULL) {
   printf("?ERROR - can't open '%s' file \n",gamess_input);
   return;}

/* calculate first number of hydrogens and heavy atoms */

   nh=0;
   na=0;

   for(i = 0 ; i < mliste[0] ; i++) {

      if(disp_list[i] == 0) continue;

      if(strncmp((atnam+4*i),"H",1) == 0) nh++;

      else na++;
   }

   WRITE_STRUC();

   printf("\n\n **** GAMESS input generator \n");
   printf(" Number of heavy atoms    : %d \n",na);
   printf(" Number of hydrogen atoms : %d \n",nh);

/* start writing input file */
   fprintf(gamess_p," $CONTRL SCFTYP=RHF RUNTYP=ENERGY    $END \n");
   fprintf(gamess_p," $BASIS GBASIS=STO NGAUSS=3 $END \n");
   fprintf(gamess_p," $DATA \n");
   fprintf(gamess_p,"%s\n",def_title);
   fprintf(gamess_p,"C1 \n");
/*    fprintf(gamess_p," \n"); */ /* for C1 symmetry no blank card */

 element_vec = cvector(2*(mliste[current_struct]-mlists[current_struct] + 1));

   for(i = mlists[current_struct] ; i < mliste[current_struct] ; i++) {
    if(disp_list[i] == 0) continue;
     strncpy(element_vec+2*i,atnam+4*i,2);
   }
   ret_val = which_element(element_vec); /* check the atoms if they are allowed */
   if(ret_val > 0) {
     free(element_vec);
      return;}

   for(i = mlists[current_struct] ; i < mliste[current_struct] ; i++) {

    zcore = -1.0;
      for(j = 0 ; j < MAXelements ; j++) {
         if(strncmp(element+4*j,element_vec+2*i,2) == 0) {
           zcore = (float) element_p[j];
           break;}
      }
      if(zcore < 0.0) {
        printf("?WARNING - can't solve the element '%.4s' \n",atnam+4*i);}

      fprintf(gamess_p,"%.4s %3.1f %f %f %f \n",atnam+4*i,zcore,x[i],
                                                                y[i],
                                                                z[i]);}
   fprintf(gamess_p," $END \n");

   fclose(gamess_p);

   free(element_vec);
}
/***********************************************************************/
gen_probsurf()    /* generate probsurf input */
/***********************************************************************/
{
/* externals                   */

   extern int numat;
   extern float *x,*y,*z;
   extern int *res1,*res2;
   extern char *resnam,*atnam,*segment;
   extern char *cvector();
   
   FILE *probsurf_p;

   static char *def_title = "Default title for: PROBESURF";
   static char *element_vec;
   static char probsurf_input[BUFF_LEN] = DEFAULT_PROBESURF;
   static char temp[4];

   static int i,j,k,ret_val;
   static int na; /* number of heavy atoms    */
   static int charge=0; /* molecular charge   */

   char OutText[BUFF_LEN];
   float Xmin,Xmax;
   float Ymin,Ymax;
   float Zmin,Zmax;
   float ProbeVal = 1.9;
   int Xpts,Ypts,Zpts;
   int FileNameDef = 0;  /* 0 not defined, 1 defined */

   FileNameDef = 0;

/* Check if an input name is supplied */
   if(parsed[3][0] != '\0' && isalpha(parsed[3][0])) { 
                             /* ok there is a name coming ... */
     strncpy(probsurf_input,parsed[3],BUFF_LEN);
     FileNameDef = 1;}
   else {
     strncpy(probsurf_input,DEFAULT_PROBESURF,BUFF_LEN);}

   Xmin = near + sumx;
   Xmax = far + sumx;
    Ymin = near + sumy;
    Ymax = far + sumy;
     Zmin = near + sumz;
     Zmax = far + sumz;
   Xpts = 80;
   Ypts = 80;
   Zpts = 80;

   if(PROBE_limits.set < 2) {
     PROBE_limits.set = 1;
       PROBE_limits.Xmin = Xmin;
        PROBE_limits.Ymin = Ymin;
         PROBE_limits.Zmin = Zmin;
       PROBE_limits.Xmax = Xmax;
        PROBE_limits.Ymax = Ymax;
         PROBE_limits.Zmax = Zmax;}

   if(PROBE_limits.Xpts < 1)
      PROBE_limits.Xpts = Xpts;
   if(PROBE_limits.Ypts < 1)
      PROBE_limits.Ypts = Ypts;
   if(PROBE_limits.Xpts < 1)
      PROBE_limits.Zpts = Zpts;
   if(PROBE_limits.ProbeVal < 0.001)
      PROBE_limits.ProbeVal = ProbeVal;

#if defined(USEFORMS) && defined(sgi)
   if(term_type == 1)
                     if(ShowForm1()) {
                       return;};
#endif

   sprintf(OutText,"=> Writing PROBESURF input to '%s'",probsurf_input);
   PrintMessage(OutText);

   probsurf_p = fopen(probsurf_input,"w");
   if(probsurf_p == NULL) {
   sprintf(OutText,"?ERROR - can't open PROBESURF input file '%s' \n",probsurf_input);
   PrintMessage(OutText);
   return;}

   na = 0;
   for(i = mlists[current_struct] ; i < mliste[current_struct] ; i++) {
      if(disp_list[i]) na++;}
 
      if(trace_info.trace_on /*&& trace_wind */) {
        na += Atoms_In_Trace();
      }
 
  WRITE_STRUC();

   printf("\n\n **** PROBESURF input generator \n");
   printf(" Number of atoms    : %d \n",na);

/* start writing input file */
   fprintf(probsurf_p,"%s\n",def_title);
   fprintf(probsurf_p,"%s\n",def_title);
   fprintf(probsurf_p,"%d \n",na);

   for(i = mlists[current_struct] ; i < mliste[current_struct] ; i++) {

      if(!disp_list[i]) continue; /* look into display list */

      fprintf(probsurf_p,"%f %f %f %f \n",(x[i] + sumx),
                                          (y[i] + sumy),
                                          (z[i] + sumz),vdw_list[i]);}

      if(trace_info.trace_on /*&& trace_wind */) {
         Write_Atom_Trace(probsurf_p);}

   fprintf(probsurf_p,"%f %f %f %f %f %f \n",PROBE_limits.Xmin,
                                             PROBE_limits.Xmax,
                                             PROBE_limits.Ymin,
                                             PROBE_limits.Ymax,
                                             PROBE_limits.Zmin,
                                             PROBE_limits.Zmax);
   fprintf(probsurf_p,"%d %d %d\n",PROBE_limits.Xpts,
                                   PROBE_limits.Ypts,
                                   PROBE_limits.Zpts);
   fprintf(probsurf_p,"%f \n",PROBE_limits.ProbeVal);

   fclose(probsurf_p);
}
/***********************************************************************/
gen_density()    /* generate density input */
/***********************************************************************/
{
/* externals                   */

   extern int numat;
   extern float *x,*y,*z;
   extern int *res1,*res2;
   extern char *resnam,*atnam,*segment;
   extern char *cvector();
   
   FILE *density_p;

   static char *def_title = "Default title for: DENSITY";
   static char *element_vec;
   static char density_input[BUFF_LEN] = DEFAULT_DENSITY;
   static char temp[4];

   static int i,j,k,ret_val;
   static int na; /* number of heavy atoms    */
   static int nh; /* number of hydrogen atoms */
   static int charge=0; /* molecular charge   */

   char OutText[BUFF_LEN];
   float Xmin,Xmax;
   float Ymin,Ymax;
   float Zmin,Zmax;
   int Xpts,Ypts,Zpts;
   int Orbital,Method;
   int FileNameDef = 0;  /* 0 not defined, 1 defined */

   FileNameDef = 0;

/* Check if an input name is supplied */
   if(parsed[3][0] != '\0' && isalpha(parsed[3][0])) { 
     /* ok there is a name coming ... */
     strncpy(density_input,parsed[3],BUFF_LEN);
     FileNameDef = 1;}
   else {
     strncpy(density_input,DEFAULT_DENSITY,BUFF_LEN);}

   sprintf(OutText,"=> Writing DENSITY input to '%s'",density_input);
   PrintMessage(OutText);

   density_p = fopen(density_input,"w");
   if(density_p == NULL) {
   printf("?ERROR - can't open DENSITY input file '%s' \n",density_input);
   return;}

/* calculate first number of hydrogens and heavy atoms */

   nh=0;
   na=0;

   for(i = mlists[current_struct] ; i < mliste[current_struct] ; i++) {

      if(disp_list[i] == 0) continue;

      if(strncmp((atnam+4*i),"H",1) == 0) nh++;

      else na++;
   }


   Xmin = near + sumx;
   Xmax = far + sumx;
    Ymin = near + sumy;
    Ymax = far + sumy;
     Zmin = near + sumz;
     Zmax = far + sumz;
   Xpts = 60;
   Ypts = 60;
   Zpts = 60;

   if(DENSITY_limits.set < 2) {
      DENSITY_limits.set = 1;
       DENSITY_limits.Xmin = Xmin;
        DENSITY_limits.Ymin = Ymin;
         DENSITY_limits.Zmin = Zmin;
       DENSITY_limits.Xmax = Xmax;
        DENSITY_limits.Ymax = Ymax;
         DENSITY_limits.Zmax = Zmax;
         DENSITY_limits.Dmethod  = 0;}

   strncpy(DENSITY_limits.WFFile,"fort.7",BUFF_LEN);

   if(DENSITY_limits.Xpts < 1)
      DENSITY_limits.Xpts = Xpts;
   if(DENSITY_limits.Ypts < 1)
      DENSITY_limits.Ypts = Ypts;
   if(DENSITY_limits.Zpts < 1)
      DENSITY_limits.Zpts = Zpts;
   if(DENSITY_limits.Orbital < 1)
      DENSITY_limits.Orbital = 1;


#if defined(USEFORMS) && defined(sgi)
   if(term_type == 1)
                     if(ShowForm2()) {
                       return;}
#endif

   WRITE_STRUC();

   printf("\n\n **** DENSITY input generator \n");
   printf(" Number of heavy atoms    : %d \n",na);
   printf(" Number of hydrogen atoms : %d \n",nh);

   if((na+nh) != (mliste[current_struct] - mlists[current_struct]) ) 
   printf(" Writing a subset of all atoms (na+nh) = %d \n",na+nh);

 element_vec = cvector(2*(mliste[current_struct]-mlists[current_struct] + 1));

   for(i = mlists[current_struct] ; i < mliste[current_struct] ; i++) {
    if(disp_list[i] == 0) continue;
     strncpy(element_vec+2*i,atnam+4*i,2);
   }
   ret_val = which_element(element_vec); 
                       /* check the atoms if they are allowed */
   if(ret_val > 0) {
     free(element_vec);
      return;}

/* start writing input file */
   fprintf(density_p,"%s\n",def_title);
   fprintf(density_p,"%s\n",def_title);
   fprintf(density_p,"%d \n",(na+nh));

/* write out the heavy atoms first      */
   for(i = mlists[current_struct] ; i < mliste[current_struct] ; i++) {

      if(disp_list[i] == 0) continue;

      if(strncmp((element_vec+2*i+1),"H",1) == 0) continue;

      fprintf(density_p,"%f %f %f  %.2s\n",(x[i]+sumx),
                                           (y[i]+sumy),
                                           (z[i]+sumz),
                                           element_vec+2*i);
   }

/* now the hydrogens                   */
   for(i = mlists[current_struct] ; i < mliste[current_struct] ; i++) {

      if(disp_list[i] == 0) continue;

      if(strncmp((element_vec+2*i+1),"H",1) != 0) continue;

      fprintf(density_p,"%f %f %f  %.2s\n",(x[i]+sumx),
                                           (y[i]+sumy),
                                           (z[i]+sumz),
                                           element_vec+2*i);
   }


   fprintf(density_p,"%s\n",DENSITY_limits.WFFile);
   fprintf(density_p,"%f %f %f %f %f %f \n",DENSITY_limits.Xmin,
                                            DENSITY_limits.Xmax,
                                            DENSITY_limits.Ymin,
                                            DENSITY_limits.Ymax,
                                            DENSITY_limits.Zmin,
                                            DENSITY_limits.Zmax);
   fprintf(density_p,"%d %d %d\n",DENSITY_limits.Xpts,
                                  DENSITY_limits.Ypts,
                                  DENSITY_limits.Zpts);
   fprintf(density_p,"%d %d\n",DENSITY_limits.Orbital,
                               DENSITY_limits.Dmethod);

   fclose(density_p);

   free(element_vec);
}
/*******/

/***********************************************************************/
gen_vss()    /* generate vss input */
/***********************************************************************/
{
/* externals                   */

   FILE *vss_p;

   static char  *def_title = "Default title for: VSS";
   static char  *element_vec;
   static int   *loc_velec;
   static float *loc_screen;
   static char vss_input[BUFF_LEN] = DEFAULT_VSS;
   static char temp[4];

   static int i,j,k,ret_val;
   static int na; /* number of heavy atoms    */
   static int nh; /* number of hydrogen atoms */
   static int charge=0; /* molecular charge   */

   char OutText[BUFF_LEN];
   float Xmin,Xmax;
   float Ymin,Ymax;
   float Zmin,Zmax;
   int Xpts,Ypts,Zpts;
   int Orbital,Method;
   int FileNameDef = 0;  /* 0 not defined, 1 defined */

   FileNameDef = 0;

/* Check if an input name is supplied */
   if(parsed[3][0] != '\0' && isalpha(parsed[3][0])) { 
     /* ok there is a name coming ... */
     strncpy(vss_input,parsed[3],BUFF_LEN);
     FileNameDef = 1;}
   else {
     strncpy(vss_input,DEFAULT_VSS,BUFF_LEN);}

   sprintf(OutText,"=> Writing VSS input to '%s'",vss_input);
   PrintMessage(OutText);

   vss_p = fopen(vss_input,"w");
   if(vss_p == NULL) {
   printf("?ERROR - can't open VSS input file '%s' \n",vss_input);
   return;}

   strncpy(VSS_limits.WFFile,"fort.7",BUFF_LEN);

/* calculate first number of hydrogens and heavy atoms */

   nh=0;
   na=0;

   for(i = mlists[current_struct] ; i < mliste[current_struct] ; i++) {

      if(disp_list[i] == 0) continue;

      if(strncmp((atnam+4*i),"H",1) == 0) nh++;

      else na++;
   }


   Xmin = near + sumx;
   Xmax = far + sumx;
    Ymin = near + sumy;
    Ymax = far + sumy;
     Zmin = near + sumz;
     Zmax = far + sumz;
   Xpts = 60;
   Ypts = 60;
   Zpts = 60;

   if(VSS_limits.set < 2) {
      VSS_limits.set = 1;
       VSS_limits.Xmin = Xmin;
        VSS_limits.Ymin = Ymin;
         VSS_limits.Zmin = Zmin;
      VSS_limits.Xmax = Xmax;
       VSS_limits.Ymax = Ymax;
        VSS_limits.Zmax = Zmax;
   VSS_limits.Dmethod  = 0;}

   if(VSS_limits.Xpts < 1)
      VSS_limits.Xpts = Xpts;
   if(VSS_limits.Ypts < 1)
      VSS_limits.Ypts = Ypts;
   if(VSS_limits.Zpts < 1)
      VSS_limits.Zpts = Zpts;

#if defined(USEFORMS) && defined(sgi)
/*
   if(term_type == 1)
                     if(ShowForm2()) {
                      return;}
*/
#endif

   WRITE_STRUC();

   printf("\n\n **** VSS input generator \n");
   printf(" Number of heavy atoms    : %d \n",na);
   printf(" Number of hydrogen atoms : %d \n",nh);

   if((na+nh) != (mliste[current_struct] - mlists[current_struct]) ) 
   printf(" Writing a subset of all atoms (na+nh) = %d \n",na+nh);

 element_vec = cvector(2*(mliste[current_struct]-mlists[current_struct] + 1));

   for(i = mlists[current_struct] ; i < mliste[current_struct] ; i++) {
    if(disp_list[i] == 0) continue;
     strncpy(element_vec+2*i,atnam+4*i,2);
   }
   ret_val = which_element(element_vec); 
                       /* check the atoms if they are allowed */
   if(ret_val > 0) {
     free(element_vec);
      return;}
   loc_velec = ivector(mliste[current_struct]-mlists[current_struct]);
   ret_val = which_velec(loc_velec,element_vec);
   if(ret_val > 0) {
     free(element_vec);
     free(loc_velec);
      return;}
   loc_screen = vector(mliste[current_struct]-mlists[current_struct]);
   ret_val = which_screen(loc_screen,element_vec);
   if(ret_val > 0) {
     free(loc_velec);
     free(element_vec);
     free(loc_screen);
      return;}

/* start writing input file */
   fprintf(vss_p,"%s\n",def_title);
   fprintf(vss_p,"%s\n",def_title);
   fprintf(vss_p,"%s\n",def_title);
   fprintf(vss_p,"%d %d 1\n",(na+nh),nh);

/* write out the heavy atoms first      */
   for(i = mlists[current_struct] ; i < mliste[current_struct] ; i++) {

      if(disp_list[i] == 0) continue;

      if(strncmp((element_vec+2*i+1),"H",1) == 0) continue;

      fprintf(vss_p,"%f %f %f  %d\n",(x[i]+sumx),
                                           (y[i]+sumy),
                                           (z[i]+sumz),
                                           loc_velec[i]);
   }

/* now the hydrogens                   */
   for(i = mlists[current_struct] ; i < mliste[current_struct] ; i++) {

      if(disp_list[i] == 0) continue;

      if(strncmp((element_vec+2*i+1),"H",1) != 0) continue;

      fprintf(vss_p,"%f %f %f  %d\n",(x[i]+sumx),
                                           (y[i]+sumy),
                                           (z[i]+sumz),
                                           loc_velec[i]);
   }

/* write out the heavy atoms first      */
   for(i = mlists[current_struct] ; i < mliste[current_struct] ; i++) {

      if(disp_list[i] == 0) continue;

      if(strncmp((element_vec+2*i+1),"H",1) == 0) continue;

      fprintf(vss_p,"%f %f\n",((float)loc_velec[i] - atm_charge[i]),loc_screen[i]);
   }

/* now the hydrogens                   */
   for(i = mlists[current_struct] ; i < mliste[current_struct] ; i++) {

      if(disp_list[i] == 0) continue;

      if(strncmp((element_vec+2*i+1),"H",1) != 0) continue;

      fprintf(vss_p,"%f %f\n",((float)loc_velec[i] - atm_charge[i]),
                                      loc_screen[i]);
   }


   fprintf(vss_p," 2\n");
   fprintf(vss_p,"%f %f %f %f %f %f \n",VSS_limits.Xmin,
                                            VSS_limits.Xmax,
                                            VSS_limits.Ymin,
                                            VSS_limits.Ymax,
                                            VSS_limits.Zmin,
                                            VSS_limits.Zmax);
   fprintf(vss_p,"%d %d %d\n",VSS_limits.Xpts,
                                  VSS_limits.Ypts,
                                  VSS_limits.Zpts);

   fclose(vss_p);

   free(element_vec);
   free(loc_velec);
   free(loc_screen);
}


/**********************************************************************/
int which_velec(Nelec,element_vec)

      int  *Nelec;
      char *element_vec;
/**********************************************************************/
{

      extern int numat;

      static int nsymbl= CONV_ATOMS; /* atom symbol list */
/*
*
*/
      static char  *pt =
"?? HHeLiBe B C N O FNeNaMgAlSi P SClArCACBCGCDCECZNANBNGNDNENZOAOBOGODOEOZOHSASBSGSDHHHGHZNHCHOCHAHBHCHDHEHNHTHO";
      static char  *PT =
" HHeLiBe B C N O FNeNaMgAlSi P SCl";

      static int velec[NUM_ATOMS]  = { 1 , 2 , 1 , 2 , 3 , 4 , 5 , 6 , 7 , 8 ,
                                       1 , 2 , 3 , 4 , 5 , 6 , 7};
                                       
      static int ihelpv[CONV_ATOMS] = {0,
                  1,2,
                  3,4,
                  5,6,7,8,9,10,
                  11,12,
                  13,14,15,16,17,18,
                  6,6,6,6,6,6,
                  7,7,7,7,7,7,
                  8,8,8,8,8,8,8,
                  16,16,16,16,
                  1,1,1,7,6,8,1,1,1,1,1,1,1,1};

       static int i,j;

       static char OutText[BUFF_LEN];

      for(i = mlists[current_struct] ; i < mliste[current_struct] ; i++) {

       if(disp_list[i] == 0) continue;
       for(j = 0 ; j < nsymbl ; j++) { 
          if(strncmp((element_vec+2*i),(pt+2*j),2) == 0)  {

           Nelec[i] = velec[ihelpv[j] - 1]; 
           break;
           }
        }

     }
        return(0);
}


/**********************************************************************/
int which_screen(screen,element_vec)

      float  *screen;
      char   *element_vec;
/**********************************************************************/
{

      extern int numat;

      static int nsymbl= CONV_ATOMS; /* atom symbol list */

      static char  *pt =
"?? HHeLiBe B C N O FNeNaMgAlSi P SClArCACBCGCDCECZNANBNGNDNENZOAOBOGODOEOZOHSASBSGSDHHHGHZNHCHOCHAHBHCHDHEHNHTHO";
      static char  *PT =
" HHeLiBe B C N O FNeNaMgAlSi P SCl";

      static float ScreenEHT[NUM_ATOMS] = {
      1.3 , 1.688 , 0.650 , 0.975 , 1.3 , 1.625 , 1.950 , 2.275 , 2.425 , 
/*    H     He      Li      Be      B     C       N       O       F       */
      2.879 , 0.733 , 0.950 , 1.167 , 1.383 , 1.497 , 1.651 , 2.033 };
/*    Ne      Na      Mg      Al      Si      P       S       Cl          */
                                       
      static int ihelpv[CONV_ATOMS] = {0,
                  1,2,
                  3,4,
                  5,6,7,8,9,10,
                  11,12,
                  13,14,15,16,17,18,
                  6,6,6,6,6,6,
                  7,7,7,7,7,7,
                  8,8,8,8,8,8,8,
                  16,16,16,16,
                  1,1,1,7,6,8,1,1,1,1,1,1,1,1};

       static int i,j;
       static char OutText[BUFF_LEN];

      for(i = mlists[current_struct] ; i < mliste[current_struct] ; i++) {

       if(disp_list[i] == 0) continue;
       for(j = 0 ; j < nsymbl ; j++) { 
          if(strncmp((element_vec+2*i),(pt+2*j),2) == 0)  {

           screen[i] = ScreenEHT[ihelpv[j] - 1];
           break;
           }
        }
      }

        return(0);
}


/************************************************************************/
Write_Atom_Trace(File_point)
      FILE *File_point;
/************************************************************************/
{

   static int i,j,k,jj,loop,loopI,in_set,in_set1;


    in_set  = 0;
    in_set1 = 0;

    for(k = 0 ; k < trace_info.trace_sets ; k++) {

    for(j = 0 ; j < trace_info.trace_atoms[k] ; j++) {

     loopI = 0;

     for(i = (trajectory_info.first_frame - 1) ; 
         i <  trajectory_info.last_frame       ; 
         i += trajectory_info.delta_frame) {

     jj = in_set + loopI * trace_info.trace_atoms[k];

                   loopI++;

    fprintf(File_point,"%f %f %f %f\n",
     trace_info.trx[j + jj] + sumx,
      trace_info.try[j + jj] + sumy, 
       trace_info.trz[j + jj] + sumz,
        vdw_list[trace_info.trace_list[j + in_set1]]); 
    }

    }
   in_set  += (trajectory_info.last_frame - trajectory_info.first_frame + 1) *
               trace_info.trace_atoms[k];
   in_set1 += trace_info.trace_atoms[k];}

}

/************************************************************************/
int Atoms_In_Trace()
/************************************************************************/
{

   static int i,j,k,jj,loop,in_set,in_set1;


    in_set  = 0;
    in_set1 = 0;

    loop = 0;

    for(k = 0 ; k < trace_info.trace_sets ; k++) {

    for(j = 0 ; j < trace_info.trace_atoms[k] ; j++) {

     for(i = (trajectory_info.first_frame - 1) ; 
         i <  trajectory_info.last_frame       ; 
         i += trajectory_info.delta_frame) {

     loop++;
    }

    }
   in_set  += (trajectory_info.last_frame - trajectory_info.first_frame + 1) *
               trace_info.trace_atoms[k];
   in_set1 += trace_info.trace_atoms[k];}


   return(loop);
}





