/*  

                       Copyright (c) 1990, 1993 by:
        Leif Laaksonen , Center for Scientific Computing, ESPOO, FINLAND
            Confidential unpublished property of Leif Laaksonen
                        All rights reserved
  

*/

#include <stdio.h>
#include <math.h>
#include "maxdefs.h"

#ifdef sgi
#include <gl/gl.h>
#endif

/* the status line will now be 

         BLUE    backround
         WHITE   text
         RED     inicates where the pointer is on the line 

*/
#define BACKGROUND    BLUEv
#define TEXT          WHITEv
#define POINTER       REDv
#define BOX_HIGH      0.024
#define BOX_TEXT_X    0.02
#define BOX_TEXT_Y    0.005

#define MAKE_BOX(a,b,c,d)   {  bgnpolygon();\
                               Tvec[0] = Tvec[1] = a;\
                               v2f(Tvec);\
                                Tvec[0] = c;\
                                v2f(Tvec);\
                                 Tvec[1] = d;\
                                 v2f(Tvec);\
                                  Tvec[0] = b;\
                                  v2f(Tvec);\
                                endpolygon();}

   extern void  MakeOrtho();
   extern long  GetMainWindowID();
   extern int   IsStereoON();
   extern float rotB[][4];
   extern float idmat[][4];
   extern char prompt[];
   extern short REDv[];
   extern short BLUEv[];
   extern short WHITEv[];
   extern short GREENv[];
   extern float near,far;
   extern short txcolor[]; 
   extern long xsize,ysize,xorg,yorg;
   extern int deep;
   extern char *bottom_line;
   extern int   text_bottom;
   extern int term_type;
   extern int yes_no_graph;
   extern short txcolor[3]; 


/*  MAGIC structure */
    extern struct {
    int level;}  Magic;

/*
      Scarecrow is using the following Projection Transformations

      0 => Scarecrow is using ortho
      1 =>                    perspective
*/
      extern struct Projection {
       int Fovy;           /* in tenths of degrees */
       int Transformation; } Model;

   struct Bline {
     int Start;      /* index to a filed in the message start point */
     int Stop;       /*                                 end   point */
     int Llength;    /* length of message line                      */
     char *Message;}
                      Sline;



/************************************************************************/
going_on()    /* Tell the user what is going on */
/************************************************************************/
{


   static long chr_hight,space_for;
   static int i,swop,Icheck;
   float step;
   static float t1,t2,t3;
   static float saveMV[4][4];
   static float savePV[4][4];
   static char TempB[BUFF_LEN];
   static short MBlue[4] = { 0 , 0 , 100};
   static float Tvec[2];
   static int   WinId;
   static int   Tint;

   if(term_type != 1 || !yes_no_graph || !text_bottom || Magic.level ||
      IsStereoON()) 
     return; /* no graphics display or don't want to display the bottom text */

#ifdef sgi

   WinId = winget(); /* save old window id */

   winset(GetMainWindowID());

/* determine size of window and lower left corner */

   getsize(&xsize,&ysize);
   getorigin(&xorg,&yorg);

/* determine hight of character font  */

   chr_hight = getheight();
   space_for = ysize / chr_hight; /* space for lines */
   step = 1./(float)(space_for);


   if(Model.Transformation) {
       mmode(MPROJECTION);
         getmatrix(savePV);}

   mmode(MVIEWING);
    getmatrix(saveMV); /* save transformation matrix */
     frontbuffer(TRUE);
      zbuffer(FALSE);
        ortho2( 0.0 , 1. , 0.0 , 1. ); 
         loadmatrix(idmat);


   Tint      = (int)((float)ysize * BOX_HIGH);
     if(Tint < chr_hight) {
        t2 = ((float)chr_hight + 1.0) / ((float)ysize);}
     else
        t2 = BOX_HIGH;

/*     rectf( 0.0 , 0.0 , 1.0 , t2);*/
     c3s(BACKGROUND);
     MAKE_BOX( 0.0 , 0.0 , 1.0 , t2);
     c3s(MBlue);
     MAKE_BOX( 0.002 , 0.002 , 0.998 , t2 - 0.002);

     c3s(TEXT); 
       t1 = BOX_TEXT_X;
       t2 = BOX_TEXT_Y;
       cmov2(t1 , t2 );
     charstr(bottom_line);

     if(Sline.Start < Sline.Llength) {
       swop = strlen(prompt);
       strncpy(TempB,bottom_line,BUFF_LEN);
       for(i = 0 ; i < strlen(bottom_line) ; i++) bottom_line[i] = ' ';

       Icheck = Sline.Stop - Sline.Start + 1;
       if(Icheck < 1) Icheck = 0;
        if(Icheck >= PORTchar) Icheck = (PORTchar - 1);
       strncpy(bottom_line+(Sline.Start + swop),
               (TempB+Sline.Start + swop),
                Icheck);
   c3s(POINTER);
   cmov2(t1 , t2 );
   charstr(bottom_line);}

     frontbuffer(FALSE);
     zbuffer(TRUE);
     MakeOrtho();                          /* put transformation
                                                     matrix back */

   if(Model.Transformation) {
       mmode(MPROJECTION);
         loadmatrix(savePV);
   
       mmode(MVIEWING);}

     loadmatrix(saveMV);

   winset(WinId);

   return;
#endif

}
/************************************************************************/
loctow( xpoint , ypoint , zpoint) /* transforms a point in the axis
                                        x: 0 -> 1
                                        y: 0 -> 1
                                        z: 0 -> 1
                                     to the working coordinate system */
     float *xpoint;
     float *ypoint;
     float *zpoint;
/************************************************************************/
{

     extern float near,far;

     float delta;

     delta = far - near;
     *xpoint = (*xpoint) * delta + near ;
     *ypoint = (*ypoint) * delta + near ;
     *zpoint = (*zpoint) * delta + near ;

}
/************************************************************************/
screen_stat()    /* Tell the user some facts */
/************************************************************************/
{

   extern float near,far;
   extern float rotB[][4];
   extern long xsize,ysize,xorg,yorg;
   extern int term_type;
   extern int yes_no_graph;

   static int i;
   static float saveM[4][4];
   static float vec1[3] = { -0.9 , 0.9 , 0.0};
   static float vec2[3];
   static float T1,T2,T3,T4,T5,T6,T7,T8,T9;


   if(term_type != 1 || yes_no_graph == 0 || text_bottom == 0 ) 
   return; /* no graphics display or don't want to display the bottom text */

#ifdef sgi
    ApplyRota((vec1[0] + 0.1) , vec1[1] , vec1[2] , &T1 , &T2 , &T3);
    ApplyRota(vec1[0] , (vec1[1] + 0.1) , vec1[2] , &T4 , &T5 , &T6);
    ApplyRota(vec1[0] , vec1[1] , (vec1[2] + 0.1) , &T7 , &T8 , &T9);

   getmatrix(saveM);

   ortho( -1. , 1. , -1. , 1. , 1. , -1.); 

/* x - axis */
    c3s(REDv);
    bgnline();
    v3f(vec1);
     vec2[0] = T1;
      vec2[1] = T2;
       vec2[2] = T3;
     v3f(vec2);
    endline();
/* y-axis */
    c3s(GREENv);
    bgnline();
    v3f(vec1);
     vec2[0] = T4;
      vec2[1] = T5;
       vec2[2] = T6;
     v3f(vec2);
    endline();
/* z-axis */
    c3s(BLUEv);
    bgnline();
    v3f(vec1);
     vec2[0] = T7;
      vec2[1] = T8;
       vec2[2] = T9;
     v3f(vec2);
    endline();
/* */
   MakeOrtho();                               /* put transformation
                                                        matrix back */
   loadmatrix(saveM);

   return;
#endif

}

