/*
      Function to read the MUMOD trajectory file

      Copyright Leif Laaksonen 1991
      Centre for Scientific Computing, Espoo, FINLAND

*/

#include <stdio.h>
#include <math.h>
#include <malloc.h>
#include <string.h>
#include "maxdefs.h"

#define MOD(a,b)  (((a+1)/b)*b - (a+1))

    extern double *dvector();
    extern float   *vector();

/* externals    */
    extern FILE *charmm_oc;
    extern float *x,*y,*z;
    extern int numat;
    extern char traj_file[BUFF_LEN];

/* structure for the dynamics trajectory file */

   extern struct {
   char traj_file[BUFF_LEN];                 /* file name          */
   int natom;                                /* number of atoms    */
   int nstep;                                /* number of steps    */
   int time_bw_steps;                        /* time between steps */
   int time_first_frame;                     /* time of first frame */
   int first_frame;                          /* first frame to be displayed */
   int last_frame;                           /* last frame to be displayed  */
   int delta_frame;                          /* display every delta frame */
                   }    trajectory_info;     

     extern int mlist_deep;      /* stack number indicator */
     extern int mlists[MAX_MLIST]; /* First index for molecule list */
     extern int mliste[MAX_MLIST]; /* Second index for molecule list */
     extern char mnlist[MAX_MLIST][BUFF_LEN]; 
                                /* name list for molecule file names */

     extern int MAXatom;
     extern int traj_in_core;

/***************************************************************************/
int get_frame_mumod(alt,iappend)  /* read one frame from a mumod trajectory */


    int alt;     /* mode of operation (=0) first time in read
                                      (>0) trajectory number */
    int iappend; /* if = 0 no append , if = 1 append */
/***************************************************************************/
{

   static long record_len=0;         /* the "record" length in bytes of one
                                       record containing the x,y and z
                                       coordinates plus the information
                                       in between the coordinates */
   static long ret_fseek;

   static int icount;
   static int record;
   static float tstep;     /* time step in 10**(-12) sec */
   static int   ifre;      /* sampling frequency         */
   static int natom;       /* number of mumod atoms      */
   static int npts7;       /* number of frames in file   */
   static float x2;        /* box size in x, y and z     */
   static float y2;
   static float z2;
   static int i , idx1;

/*  start reading  */

/* read controll record */
    icount  = fread(&record,sizeof(int), 1 , charmm_oc) * sizeof(int);
/* read ...             */
    icount += fread(&tstep,sizeof(float), 1 ,charmm_oc) * sizeof(float);
    icount += fread(&ifre ,sizeof(int)  , 1 ,charmm_oc) * sizeof(int);
    icount += fread(&natom,sizeof(int)  , 1 ,charmm_oc) * sizeof(int);
    icount += fread(&npts7,sizeof(int)  , 1 ,charmm_oc) * sizeof(int);
#ifdef W64BITS
    icount += fread(&x2   ,sizeof(double), 1 ,charmm_oc) * sizeof(double);
    icount += fread(&y2   ,sizeof(double), 1 ,charmm_oc) * sizeof(double);
    icount += fread(&z2   ,sizeof(double), 1 ,charmm_oc) * sizeof(double);
#else
    icount += fread(&x2   ,sizeof(float), 1 ,charmm_oc) * sizeof(float);
    icount += fread(&y2   ,sizeof(float), 1 ,charmm_oc) * sizeof(float);
    icount += fread(&z2   ,sizeof(float), 1 ,charmm_oc) * sizeof(float);
#endif

/* read controll record (icount gives now number of bytes from start) */
    icount += fread(&record,sizeof(int), 1 , charmm_oc) * sizeof(int);

    record = icount;

/* header information done   */
/* determine the "record length"    */
  if(natom != mliste[0]) {
   PrintMessage("?ERROR - number of atoms in file != current number of atoms");
   return(-1);}
        record_len = 
                     natom * sizeof(float) * 3 + 2 * sizeof(int);

/* check things and go ahead */
/* read controll record */

/* so far icount bytes ... */
    if(alt > 0) {
    ret_fseek = fseek(charmm_oc,(alt*record_len),1);
    if(ret_fseek) {
    printf("?ERROR - can't read trajectory file : %s \n",traj_file);
    return(-1);}}

/* next records are specific for one frame */

    if(!iappend) {

/* read controll record */
     icount = fread(&record,sizeof(int), 1 ,charmm_oc);
    for(i = 0 ; i < natom ; i++) {
      icount = fread(&x[i],sizeof(float), 1 ,charmm_oc);
       icount = fread(&y[i],sizeof(float), 1 ,charmm_oc);
        icount = fread(&z[i],sizeof(float), 1 ,charmm_oc);}
     icount = fread(&record,sizeof(int), 1 , charmm_oc);

  }
    else {

    idx1 = mliste[mlist_deep - 1];

/* check dimensions */
    if((idx1+natom) > MAXatom) {
      printf("?ERROR - next frame does not fit into the coordinate array \n");
      return(-1);}

    icount = fread(&record,sizeof(int), 1 ,charmm_oc);
     for(i = idx1 ; i < (idx1 + mliste[0]) ;i++) {
      icount = fread(&x[i],sizeof(float), 1 ,charmm_oc);
       icount = fread(&y[i],sizeof(float), 1 ,charmm_oc);
        icount = fread(&z[i],sizeof(float), 1 ,charmm_oc);}
    icount = fread(&record,sizeof(int), 1 ,charmm_oc);

  }

    update_mlist(natom);

    return(0);
/*                                  */

}
/***************************************************************************/
int read_traj_mumod(alt,numset,pasback)
                                 /* read one frame from a mumod trajectory */
    int alt;                     /* mode of operation (=0) first time in read
                                    (>0) trajectory number */
    int pasback[];
    int *numset;
/***************************************************************************/
{

   FILE *mumod_oc;

   static long record_len=0;         /* the "record" length in bytes of one
                                       record containing the x,y and z
                                       coordinates plus the information
                                       in between the coordinates */
   static int conf_num;    /* mumod configuration number */

   static int icount;
   static int record;
   static int nstep;
   static float tstep;     /* time step in 10**(-13) sec */
   static int   ifre;      /* sampling frequency         */
   static int natom;       /* number of mumod atoms      */
   static int npts7;       /* number of frames in file   */
   static float x2;        /* box size in x, y and z     */
   static float y2;
   static float z2;
   static int i;
   static char  OutText[BUFF_LEN];

   mumod_oc = fopen(traj_file,"r");
   if(mumod_oc == NULL) {
   sprintf(OutText,">>> Can't open input file: %s",traj_file);
   PrintMessage(OutText);
   return(-1); }


/*  start reading  */

/* read controll record */
    icount = fread(&record,sizeof(int), 1 , mumod_oc);
/* read ...             */
    icount += fread(&tstep,sizeof(float), 1 ,mumod_oc) * sizeof(float);
    icount += fread(&ifre ,sizeof(int)  , 1 ,mumod_oc) * sizeof(int);
    icount += fread(&natom,sizeof(int)  , 1 ,mumod_oc) * sizeof(int);
    icount += fread(&npts7,sizeof(int)  , 1 ,mumod_oc) * sizeof(int);
#ifdef W64BITS
    icount += fread(&x2   ,sizeof(double), 1 ,mumod_oc) * sizeof(double);
    icount += fread(&y2   ,sizeof(double), 1 ,mumod_oc) * sizeof(double);
    icount += fread(&z2   ,sizeof(double), 1 ,mumod_oc) * sizeof(double);
#else
    icount += fread(&x2   ,sizeof(float), 1 ,mumod_oc) * sizeof(float);
    icount += fread(&y2   ,sizeof(float), 1 ,mumod_oc) * sizeof(float);
    icount += fread(&z2   ,sizeof(float), 1 ,mumod_oc) * sizeof(float);
#endif
/* read controll record (icount gives now number of bytes from start) */
    icount += fread(&record,sizeof(int), 1 , mumod_oc) * sizeof(int);

    record = icount;

/* header information done   */

    if(alt == 1) {

/* check number of records */

/* go first to the end of file */
        icount = fseek(mumod_oc,0L,2);
         if(icount != 0) {
         PrintMessage("?ERROR - can't find end of trajectory file");
         return(-1);}

        icount = ftell(mumod_oc) - record;

        record_len = 
                     natom * sizeof(float) * 3 + 2 * sizeof(int);

        nstep = icount / record_len;


/* update trajectory info ... */
        trajectory_info.natom            = natom;
        trajectory_info.nstep            = nstep;
        *numset =                          nstep;

        for(i = 0 ; i < 20 ; i++) pasback[i] = 0;

        trajectory_info.time_bw_steps    = ((int)(tstep * 1000.)*ifre)/10;

        sprintf(OutText," Info for trajectory file   : %s ",traj_file);
        PrintMessage(OutText);
	sprintf(OutText," Atoms found                : %d ",natom);
        PrintMessage(OutText);
	sprintf(OutText," Dynamics steps             : %d ",nstep);
        PrintMessage(OutText);
        sprintf(OutText," Time between data sets     : %d ",
                 ((int)(tstep * 1000.)*ifre)/10);
        PrintMessage(OutText);

         pasback[0] = nstep;
          pasback[1] = 0;
           pasback[2] = trajectory_info.time_bw_steps;

/*
        printf(" Time of the first data set : %d \n",icntrl[1]);
*/
        traj_in_core = 2; /* always out of core */
        fclose(mumod_oc);
        return(0);}


/* read controll record */
    icount = fread(&record,sizeof(int), 1 ,mumod_oc);

     for(i = 0 ; i < mliste[0] ; i++) {
      icount = fread(&x[i],sizeof(float), 1 ,mumod_oc);
       icount = fread(&y[i],sizeof(float), 1 ,mumod_oc);
        icount = fread(&z[i],sizeof(float), 1 ,mumod_oc);}

    icount = fread(&record,sizeof(int), 1 , mumod_oc);

    update_mlist(natom);

    return(0);

/*                                  */

}



