#include <stdio.h>
#include <math.h>
#include <malloc.h>
#include <string.h>
#include "maxdefs.h"

#define MOD(a,b)  (((a+1)/b)*b - (a+1))

#define FIXED_SIZED_HEADER_LEN      34
#define VARIABLE_SIZED_HEADER_LEN   17
#define COORD_AND_VELOC_DATA_LEN     6
#define DYNA_INFO_DATA_LEN           8

    extern double *dvector();
    extern float   *vector();
/* structure for the dynamics trajectory file */

   extern struct {
   char traj_file[BUFF_LEN];                 /* file name          */
   int natom;                                /* number of atoms    */
   int nstep;                                /* number of steps    */
   int time_bw_steps;                        /* time between steps */
   int time_first_frame;                     /* time of first frame */
   int first_frame;                          /* first frame to be displayed */
   int last_frame;                           /* last frame to be displayed  */
   int delta_frame;                          /* display every delta frame */
                   }    trajectory_info;     

     extern int mlist_deep;      /* stack number indicator */
     extern int mlists[MAX_MLIST]; /* First index for molecule list */
     extern int mliste[MAX_MLIST]; /* Second index for molecule list */
     extern char mnlist[MAX_MLIST][BUFF_LEN]; 
                                /* name list for molecule file names */

     extern int MAXatom;
     extern int traj_in_core;


/***************************************************************************/
get_frame_hyperchem(alt,iappend)  /* read one frame from a HyperChem trajectory   */


    int alt;     /* mode of operation (=0) first time in read
                                      (>0) trajectory number */
    int iappend; /* if = 0 no append , if = 1 append */
/***************************************************************************/
{
/* externals    */
    extern FILE *charmm_oc;
    extern float *x,*y,*z;
    extern int numat;
    extern char traj_file[BUFF_LEN];

   static long record_len=0;         /* the "record" length in bytes of one
                                       record containing the x,y and z
                                       coordinates plus the information
                                       in between the coordinates */
   static long ret_fseek;

   static char title[BUFF_LEN];  /* HyperChem title */
   static int natom;       /* number of HyperChem atoms */
   static int icount;
   static int record;
   static int i;
   static int idx1;
   static int LabelRecord;
   static float *Master;
   static int FixedSizedHeader[FIXED_SIZED_HEADER_LEN];
   static float CoordAndVelocData[COORD_AND_VELOC_DATA_LEN];
   static float DynaInfoData[DYNA_INFO_DATA_LEN];


           /* always from first atom list */

/* determine the "record length"    */
        natom = mliste[0] - mlists[0];
        numat = mliste[0] - mlists[0];
        record_len = natom * sizeof(float) * 6 + 8 * sizeof(float);

/*  start reading  */

    icount = fread(FixedSizedHeader,sizeof(int), 
                   FIXED_SIZED_HEADER_LEN ,charmm_oc);

    ret_fseek = fseek(charmm_oc,(FixedSizedHeader[1] + alt*record_len),
                      SEEK_SET);
    if(ret_fseek) {
    printf("?ERROR - can't read trajectory file : %s \n",traj_file);
    return(-1);}

/* next records are specific for one frame */

    if(iappend == 0) {

/* read controll record */
    for(i = 0 ; i < natom ; i++) {

    icount = fread(CoordAndVelocData,sizeof(float), 
                   COORD_AND_VELOC_DATA_LEN ,charmm_oc);

       x[i] = CoordAndVelocData[0];
        y[i] = CoordAndVelocData[1];
         z[i] = CoordAndVelocData[2];}

  }
    else {

    idx1 = mliste[mlist_deep - 1];

/* check dimensions */
    if((idx1+natom) > MAXatom) {
      printf("?ERROR - next frame does not fit into the coordinate array \n");
      return(-1);}

    for(i = 0 ; i < natom ; i++) {

    icount = fread(CoordAndVelocData,sizeof(float),
                   COORD_AND_VELOC_DATA_LEN ,charmm_oc);

       x[idx1 + i] = CoordAndVelocData[0];
        y[idx1 + i] = CoordAndVelocData[1];
         z[idx1 + i] = CoordAndVelocData[2];}

  }

    update_mlist(natom);

    return(0);
/*                                  */

}
/***************************************************************************/
read_traj_hyperchem(alt,numset,pasback)
                           /* read one frame from a HyperChem trajectory   */


    int alt;     /* mode of operation (=0) first time in read
                                      (>0) trajectory number */
    int pasback[];
    int *numset;
/***************************************************************************/
{
/* externals    */
    extern FILE *charmm_oc;
    extern float *x,*y,*z;
    extern int numat;
    extern char traj_file[BUFF_LEN];

   FILE *HyperChem_oc;

   static long record_len=0;         /* the "record" length in bytes of one
                                       record containing the x,y and z
                                       coordinates plus the information
                                       in between the coordinates */
   static char title[80];  /* HyperChem title */
   static int natom;       /* number of HyperChem atoms */
   static int icount;
   static int record;
   static int nstep;
   static int LabelRecord;
   static int FileOffset;
   static int SnapshotPeriod;
   static int OptimizerType;
   static int UsingPeriod;
   static int ConstantTemp;
   static float TimeStep;
   static float HeatTime;
   static float RunTime;
   static float CoolTime;
   static float TempStep;
   static int   DataCollPeriod;
   static char OutText[BUFF_LEN];

   HyperChem_oc = fopen(traj_file,"r");
   if(HyperChem_oc == NULL) {
   printf(">>> Can't open input file: %s\n",traj_file);
   return(-1); }


/*  start reading  */

    icount = fread(&nstep,sizeof(int), 1 ,HyperChem_oc);
    icount = fread(&FileOffset,sizeof(int), 1 ,HyperChem_oc);
    icount = fread(&natom,sizeof(int), 1 ,HyperChem_oc);

    if(natom != (mliste[0] - mlists[0])) {
       PrintMessage("?ERROR - number of atoms in traj file does not match defined atoms");
       return(-1);}

    icount = fread(&SnapshotPeriod,sizeof(int), 1 ,HyperChem_oc);
    icount = fread(&record,sizeof(int), 1 , HyperChem_oc);
    icount = fread(&OptimizerType,sizeof(int), 1 , HyperChem_oc);
    icount = fread(&record,sizeof(int), 1 , HyperChem_oc);
    icount = fread(&record,sizeof(int), 1 , HyperChem_oc);
    icount = fread(&record,sizeof(int), 1 , HyperChem_oc);
    icount = fread(&record,sizeof(int), 1 , HyperChem_oc);
    icount = fread(&record,sizeof(int), 1 , HyperChem_oc);
    icount = fread(&UsingPeriod,sizeof(int), 1 , HyperChem_oc);
    icount = fread(&ConstantTemp,sizeof(int), 1 , HyperChem_oc);
    icount = fread(&record,sizeof(int), 1 , HyperChem_oc);
    icount = fread(&record,sizeof(int), 1 , HyperChem_oc);
    icount = fread(&record,sizeof(int), 1 , HyperChem_oc);
    icount = fread(&record,sizeof(int), 1 , HyperChem_oc);
    icount = fread(&record,sizeof(int), 1 , HyperChem_oc);
    icount = fread(&record,sizeof(int), 1 , HyperChem_oc);
    icount = fread(&record,sizeof(int), 1 , HyperChem_oc);
    icount = fread(&record,sizeof(int), 1 , HyperChem_oc);
    icount = fread(&record,sizeof(int), 1 , HyperChem_oc);
    icount = fread(&HeatTime,sizeof(float), 1 , HyperChem_oc);
    icount = fread(&RunTime,sizeof(float), 1 , HyperChem_oc);
    icount = fread(&CoolTime,sizeof(float), 1 , HyperChem_oc);
    icount = fread(&TimeStep,sizeof(float), 1 , HyperChem_oc);
    icount = fread(&TempStep,sizeof(float), 1 , HyperChem_oc);
    icount = fread(&record,sizeof(int), 1 , HyperChem_oc);
    icount = fread(&record,sizeof(int), 1 , HyperChem_oc);
    icount = fread(&record,sizeof(int), 1 , HyperChem_oc);
    icount = fread(&record,sizeof(int), 1 , HyperChem_oc);
    icount = fread(&DataCollPeriod,sizeof(int), 1 , HyperChem_oc);
    icount = fread(&record,sizeof(int), 1 , HyperChem_oc);

    if(alt == 1) {

/* update trajectory info ... */
        trajectory_info.natom            = natom;
        trajectory_info.nstep            = nstep;
        *numset =                          nstep;

        pasback[0] = nstep;
        pasback[1] = 0;
        pasback[2] = 0;

        trajectory_info.time_bw_steps    = DataCollPeriod * 
                                           (int)(TimeStep * 1.e+3);
        trajectory_info.time_first_frame = 0;

        sprintf(OutText," Info for trajectory file     : %s",traj_file);
        PrintMessage(OutText);
	sprintf(OutText," Atoms found                  : %d",natom);
        PrintMessage(OutText);
	sprintf(OutText," Dynamics steps               : %d",nstep);
        PrintMessage(OutText);
        sprintf(OutText," Heat time (ps)               : %f",HeatTime);
        PrintMessage(OutText);
        sprintf(OutText," Run time (ps)                : %f",RunTime);
        PrintMessage(OutText);
        sprintf(OutText," Cool time (ps)               : %f",CoolTime);
        PrintMessage(OutText);
        sprintf(OutText," Time step (ps)               : %f",TimeStep);
        PrintMessage(OutText);

        if(trajectory_info.time_bw_steps) {
        sprintf(OutText," Time between data frames (fs): %d",trajectory_info.time_bw_steps);
        PrintMessage(OutText);
        pasback[2] = trajectory_info.time_bw_steps;}

        traj_in_core = 2; /* always out of core */
        fclose(HyperChem_oc);
        return(0);}


        PrintMessage("?ERROR - you should not land here ???");

        return(-1);

/*                                  */

}

