/*
 Based on code from BIOSYM Technologies Inc. 
 and hacked further to c by
 Leif Laaksonen Centre for Scientific Computing 1991

*/

#include <stdio.h>
#include "maxdefs.h"

/* define some useful things */

#define MAX_DISCM  10000      /* max Discover molecules */

#define RECORD()   { record = \
                   fread(&record, sizeof(int) , 1L , charmm_oc);\
                   if(record < 1) {\
                     PrintMessage("?ERROR - in reading trajectory file");\
                     return(1);}}

#define FREAD(value_p , size)    { record = \
                                 fread(value_p, size , 1L , charmm_oc);\
                                 if(record < 1) {\
                     PrintMessage("?ERROR - in reading trajectory file");\
                     return(1);}}

#define FREADN(value_p , num , size) { record = \
                                fread(value_p, size , num , charmm_oc);\
                   if(record != num) {\
                     PrintMessage("?ERROR - in reading trajectory file");\
                     return(1);}}

#define NAME_LEN 4   /* name is 4 bytes long */

#define DISC_MAX_ATOMS 30000        /* max atoms in DISCOVER */

/* externals                         */
   extern float  *vector();
   extern int    *ivector();
   extern char   *cvector();
   extern double *dvector();
   extern void PrintMessage();

   extern FILE *charmm_oc;
   extern float *x;
   extern float *y;
   extern float *z;
   extern int numat;
   extern char traj_file[];
   extern int dynamics_frames;
   extern int traj_in_core;
   extern int mlist_deep;
   extern int current_struct;
   extern float sumx,sumy,sumz;

     extern int mlist_deep;      /* stack number indicator */
     extern int mlists[MAX_MLIST]; /* First index for molecule list */
     extern int mliste[MAX_MLIST]; /* Second index for molecule list */
     extern char mnlist[MAX_MLIST][BUFF_LEN]; 
                                /* name list for molecule file names */

   extern int MAXatom;

/* structure for the dynamics trajectory file */

   extern struct {
   char traj_file[BUFF_LEN];                 /* file name          */
   int natom;                                /* number of atoms    */
   int nstep;                                /* number of steps    */
   int time_bw_steps;                        /* time between steps */
   int time_first_frame;                     /* time of first frame */
   int first_frame;                          /* first frame to be displayed */
   int last_frame;                           /* last frame to be displayed  */
   int delta_frame;                          /* display every delta frame */
                   }    trajectory_info;     

/* structur containing pointers to dynamics display variables */
    extern struct dyna_disp_var {
      int numset;             /* number of sets (or variables) */
      int current_set;        /* index to current set          */
      int point_len;          /* length of point array         */
      int *point_vec;         /* pointer to point array        */
      int dist_len;           /* length of dist array          */
      int *dist_vec;          /* pointer to dist array         */
      int ang_len;            /* length of angle array         */
      int *ang_vec;           /* pointer to angle array        */
      int tors_len;           /* length of torsion array       */
      int *tors_vec;          /* pointer to torsion array      */
      int obs_vec_len;        /* observation array length      */
      int obs_vec_curr;       /* display current               */
      float *obs_vec;};       /* pointer to observation array  */

    extern struct dyna_disp_var play_dynam_frames;
/*                                   */

/* Common Block Declarations */

struct {
    int nat;
    char at[800];
} atdat_;

#define atdat_1 atdat_

struct {
    int  *knd;
    char *jname;
} kindat_;

#define kindat_1 kindat_

struct {
    double cmprsb, demax, dseed, dtemp, dtoten, pressb, temp, tempb, 
	    temp0, timprs, timtmp, tmstpi, tmstpo, toten, vscale, vershn;
    int iprint, iread;
    char ititlr[80], iver[80], jtitlr[80];
    int katpfc, katscl, kavpr, kcnstr, kexact, kinit, kinitv, kpresb, 
	    kprint, krsclv, krstfc, kshape, kstppr, ktempb, ktsscl, kvrscl, 
	    mlhis, lhis, hiscnt, loprst, nclnan, nrlnan, nsteps, nstpav, 
	    nwrstp;
} mdopt_;

#define mdopt_1 mdopt_

struct {
    double etotl, eb, et, ep, eop, ebb, ebt, ett, ebp, etph, ettp, ebb2, 
	    eoo, elj, erp, edp, est, ehb, dobelj, doberp, dobedp, dobest;
} energ_;

#define energ_1 energ_

struct {
    double etotml[MAX_DISCM];
    double ebmol[MAX_DISCM];
    double etmol[MAX_DISCM];
    double epmol[MAX_DISCM];
    double eopmol[MAX_DISCM];
    double ebbmol[MAX_DISCM];
    double ebtmol[MAX_DISCM];
    double ettmol[MAX_DISCM];
    double ettpml[MAX_DISCM];
    double eoomol[MAX_DISCM];
    double eljmol[MAX_DISCM];
    double erpmol[MAX_DISCM];
    double edpmol[MAX_DISCM];
    double estmol[MAX_DISCM];
    double ebpmol[MAX_DISCM];
    double ehbmol[MAX_DISCM];
    double etpmol[MAX_DISCM];
    double ebb2ml[MAX_DISCM];
} enmol_;

#define enmol_1 enmol_

struct {
    int lprint, ncall;
} enrgps_;

#define enrgps_1 enrgps_

struct {
    double atemp, etk, etot, etp;
    int nenrg;
} mdeng_;

#define mdeng_1 mdeng_

struct {
    int *ibw;	/* was [2][11400] */
} intdat_;

#define intdat_1 intdat_

struct {
    double erpmlr[MAX_DISCM];
    double edpmlr[MAX_DISCM];
    double eljmlr[MAX_DISCM];
    double estmlr[MAX_DISCM];
    double ehbmlr[MAX_DISCM];
} interm_;

#define interm_1 interm_

struct {
    double ctemp, ctmpav, tpresm, tpress, tprmav, tprsav, uenavs[17], 
	    uens[17], utk, utkav, utot, utotav, utp, utpav;
    int isteps, istpav, jstfor;
} mdavs_;

#define mdavs_1 mdavs_

struct {
    double presur, etkv[9]	/* was [3][3] */, virial[9]	/* was [3][3] 
	    */, presst[9]	/* was [3][3] */, presrm, etkm[9]	/* 
	    was [3][3] */, virilm[9]	/* was [3][3] */, prestm[9]	/* 
	    was [3][3] */;
} mdpres_;

#define mdpres_1 mdpres_

struct {
    double atmas[200], timcnv, fconv, tmpcnv, tmpacv, econv, ekconv, 
	    ekcnvt, prscnv, avono, boltz, gaskcn, aclcnv, velcnv, ratmas[200],
	     timstp, h2d2, rh2d2;
    int nlinep;
} mdkons_;

#define mdkons_1 mdkons_

struct {
    int molxyz[MAX_DISCM];
    int natmol[MAX_DISCM];
    int molres[MAX_DISCM];
    int nrsmol[MAX_DISCM]; 
    int molbp[MAX_DISCM];
    int moltp[MAX_DISCM];
    int molpp[MAX_DISCM];
    int molop[MAX_DISCM];
    int molttp[MAX_DISCM];
    int molgrp[MAX_DISCM];
    int molbbp[MAX_DISCM];
} molptr_;

#define molptr_1 molptr_

struct {
    double bufzon;
    int nmove, natmov, natmv3, nat32m, nbmv, nthmv, nphmv, nopmv, ntthmv, 
	    nbbmv, imove[DISC_MAX_ATOMS], lmove[DISC_MAX_ATOMS];
} movinf_;

#define movinf_1 movinf_

struct {
    int nmol, nres, natom, nbond, ntheta, nphi, nopln, nthth, nbb, nint, 
	    nbnded, nat3, ihydnb, ngroup;
} numinf_;

#define numinf_1 numinf_

struct {
    int nnmres;
    char namres[400];
} resdat_;

#define resdat_1 resdat_

struct {
    int lisres[MAX_DISCM];
    int ifirst[MAX_DISCM];
    int last[MAX_DISCM];
    int mresml[MAX_DISCM];
    int irsgpf[MAX_DISCM];
    int irsgpl[MAX_DISCM];
} resinf_;

#define resinf_1 resinf_

struct {
    double aboxa, aboxb, aboxc, boxlim, boxmnx, boxmny, boxmnz, boxmxx, 
	    boxmxy, boxmxz, carcry[9]	/* was [3][3] */, crycar[9]	/* 
	    was [3][3] */, symcr[1764]	/* was [3][3][196] */, symops[1764]	
	    /* was [3][3][196] */, tranop[588]	/* was [3][196] */, ucvcar[9]	
	    /* was [3][3] */, ucvec[6], volum;
    int ncellx, ncelly, ncellz, ncelsz, ncelx2, ncely2, 
	    ncelz2, nclszy, nsymcd, nsymm2, nsymop;
} symdat_;

#define symdat_1 symdat_

struct {
    char spacgp[14];
} symnam_;

#define symnam_1 symnam_

struct {
    float *xcoor;
    float *ycoor;
    float *zcoor;
    float *xvlcty;
    float *yvlcty; 
    float *zvlcty;
} tempry_;

#define tempry_1 tempry_


/***************************************************************************/
get_frame_discover(alt,iappend)  /* read one frame from a insight trajectory */

    int alt;     /* mode of operation (=0) first time in read
                                      (>0) trajectory number 
                                      (<0) take just trajectory info */
    int iappend; /* if = 0 no append , if = 1 append */
/***************************************************************************/
{
    /* System generated locals */
    int i_1, i_2, i_3, i_4, i_5, i_6, i_7, i_8, i_9;

    /* Table of constant values */

    static int c__20 = 20;
    static int c__1 = 1;
    static int c__6 = 6;
    static int c__9 = 9;
    static int c__1764 = 1764;
    static int c__588 = 588;

    /* Local variables */
    static int ibond, nsymsm;
#define enrgys ((double *)&energ_1)
#define enmols ((double *)&enmol_1 + MAX_DISCM)
    static int ia, iat, ien, inm, iml, imol, ires;
    static int record,kntrl;
    static int FixedAtoms;

    static char OutText[BUFF_LEN];
    static struct {
      long WhereInFile;
      long JumpPoint;
      long RetSeek;} Discover;

    static long RecordL;
    static long RecordL1;
    static long RecordL2;
    static long RecordA;

    static float *xtemp;
    static float *ytemp;
    static float *ztemp;

/* Function */
/*       Read one frame from an unformatted history file written by */
/*       DISCOVER version 2.2 or later. */

/*  Description of items in his file                      number of bytes */
/*------------------------------------------------------------------------
   kntrl  = 0 for first record, 1 for all others           4   
   iver   = program header                                 80   
   vershn = Discover version number                        8   
   jtitlr = run title                                      80   
   ititlr = run subtitle                                   80   
   nat    = number of atom types                           4   
   at     = names of atom types                            4*nat   
   atmas  = masses of atom types                           8*nat   
   nnmres = number of unique residues in system            4   
   namres = names of residues included in system           4*nnmres   
   natom  = number of atoms in system                      4   
   knd    = pointer to atom type for each atom             4*natom   
   jname  = unique name for each atom                      4*natom   
   nmove  =                                                4   
   natmov = number of moving atoms in system               4   
   nmol   = number of molecules in system                  4   
   natmol = number of atoms in each molecule               4*nmol   
   nrsmol = number of residues in each molecule            4*nmol   
   nres   = number of residues in system                   4   
   ifirst = pointer to first atom of each residue in knd   4*nres   
   last   = pointer to last atom of each residue in knd    4*nres   
   lisres = pointer to residue name in namres              4*nres   
   nbond  = number of bonds                                4   
   ibw    = pointers to bonded atoms in knd                8*nbond   
   ucvec  = unit cell vectors                              72   
   ucvcar = cartesian components of unit cell vectors      72   
   crycar = matrix to convert cryst. to cart. coordinates  72   
   carcry = matrix to convert cart. to cryst. coordinates  72   
   symops = symmetry operations                            72*mxsym   
   tranop = translational part of symmetry operations      24*mxsym   
   symcr  = symmetry operations for cartesian coordinates  72*mxsym   
   nsymop = number of symmetry operations                  4   
   aboxa, aboxb, aboxc                                     24   
   boxlim =   
   nsymsm =   
   boxmnx =   
   boxmny =   
   boxmnz =   
   ncellx = # of unit cells in one direction along x axis  4   
   ncelly = # of unit cells in one direction along y axis  4   
   ncellz = # of unit cells in one direction along z axis  4   
   ncelx2 = 2*ncellx + 1                                   4   
   ncely2 = 2*ncelly + 1                                   4   
   ncelz2 = 2*ncellz + 1                                   4   
   nenrg  = number of energies                             4   
   tmstpi = time per step in femtoseconds                  8   
   nwrstp = number of steps before writing history file    4   
   isteps =                                                4   
   etot   = total energy                                   8   
   etp    = total potential energy                         8   
   etk    = total kinetic energy                           8   
   enrgys = system energies (bond, angle, torsion, etc.)   8*nenrg   
   etotml = total energy in each molecule                  8*nmol   
   enmols = molecular energies                             8*nmol*nenrg   

   edpmlr = dipole energy in each molecule                 8*nmol   
   erpmlr = repulsion energy in each molecule              8*nmol   
   eljmlr = Lennard-Jones energy in each molecule          8*nmol   
   estmlr = electrostatic energy in each molecule          8*nmol   
   presur =                                                8   
   presrm =                                                8   
   presst =                                                72   
   prestm =                                                72   
   etkv   =                                                72   
   etkm   =                                                72   
   virial =                                                72   
   virilm =                                                72   
   xcoor  = x,y,z coordinates (in angstroms) of each atom  24*natom   
   velcty = x,y,z components of velocities for each atom   24*natmov   
 */
/* ====================================================================== 
*/
/*  To increase (or decrease) the capacity of DISCOVER to handle larger */
/*  or smaller systems, one need only change MXATM, MXRES, and MXMOL as */
/*  desired and the rest of the program will adjust as necessary. */
/*  Remember that any changes to this file will, in general, require */
/*  recompilation of the entire program. */
/*  How the dimensions of the various internal coordinate arrays scale */
/*  with system size is determined by experience with typical systems. */
/*  For example, the number of bonds in a polypeptide is roughly 1.02 */
/*  times the number of atoms.  To allow a safety margin, this observed */
/*  ratio is increased slightly and then used to scale MXBND (e.g., */
/*  MXBND = 1.2 * MXATM).  The empirical ratios found in large protein */
/*  systems along with the actual factors used to determine the values */
/*  found in param.ins are given below.  These scaling factors are */
/*  used explicitly in the parameter statements below to automatically */
/*  scale the appropriate parameters as MXATM and MXRES are changed. */

/*                                             ave #/atom   #/atom ratio 
*/
/*                                               found in  used to scale 
*/
/*        parameter   meaning                    proteins     parameters 
*/
/*        ---------   ---------------------    ----------    ---------- */

/*            mxbnd   maximum # of bonds            1.02          1.20 */
/*           mxthet   maximum # of angles           1.83          2.00 */
/*            mxphi   maximum # of torsions         2.68          3.00 */
/*           mxopln   maximum # of out-of-planes    0.20          0.30 */
/*           mxthth   maximum # of angle-angles     3.03          3.50 */
/*            mxecl   maximum # of excluded atoms  10.00         13.00 */
/* ---MXSYM s the maximum number of symmetry operators permitted */
/* ---ipulmx is the maximum allowable number of 'pulled' atom pairs */
/*     CTLOPT contains primarily control flags. */
/*     added 6/86: PRMPTR - indicates if there are valid pointers to the 
*/
/*                   parameters in the CPV array.  This is used to avoid 
*/
/*                   redundant and potentially time consuming re */
/*                   generation of internals/pointer in MOLIN/GENTOP. */
/*     added 6/86: NONEIB - indicates if there is "NO NEIghBOR list" for 
*/
/*                   the current conformation.  Again, this is to save */
/*                   time (generation can be time consuming) but need */
/*                   not be done unless energy calculations or print */
/*                   of the list is needed. */
/*    added 9/86: PAXFIT,PAXREF - indicate if the FITted or REFerence */
/*                   molecules have been rotated to a Principal Axis */
/*                   coordinate system. */
/*    added 1/87: KASYM,USEGRP - kASYMmetric unit indicator for symmetry 
*/
/*                          USEGRP indicates if "charge groups" are used 
*/

/*     BIOVER is the version of Discover, set in BLKDAT. */
/*     FILVER is the version read in from topology/restart file. */
/*     CVFVER is the version read in from CVFF forcefield file. */
/*     SPACGP is the name of the space group (for PBC/symmetry) */

   if(alt < 0) {
/* Open history file and start working ... */

   charmm_oc = fopen(traj_file,"r");
   if(charmm_oc == NULL) {
     sprintf(OutText,"?ERROR - cannot open DISCOVER trajectory file '%s'",
             traj_file);
     PrintMessage(OutText);
     return(1);}


    RECORD();

    FREAD(&kntrl, sizeof(int));

    RECORD();


/*     DISCOVER HEADER AND VERSION NUMBER */

    RECORD();
    FREAD(mdopt_1.iver , (long)80 );

    sprintf(OutText,"<Trajectory information for file '%s'>",traj_file);
    PrintMessage(OutText);
    sprintf(OutText,"Program header: '%s'",mdopt_1.iver);
    PrintMessage(OutText);

    FREAD(&mdopt_1.vershn, sizeof(double));

    sprintf(OutText,"Discover version number:        %f",mdopt_1.vershn);
    PrintMessage(OutText);

    RECORD();

    mdopt_1.lhis = 20;


/*     READ INITIAL RECORD */

	RECORD();
	FREAD(mdopt_1.jtitlr, (long)80 );
        mdopt_1.jtitlr[79] = '\0';  /* null terminate string */

        PrintMessage("Run Title:");
        PrintMessage(mdopt_1.jtitlr);

	RECORD();

	RECORD();
	FREAD(mdopt_1.ititlr, (long)80 );
        mdopt_1.ititlr[79] = '\0'; /* null terminate string */

        PrintMessage("Run Subtitle:");
        PrintMessage(mdopt_1.ititlr);

	RECORD();

	RECORD();

	FREAD(&atdat_1.nat, sizeof(int));

	i_1 = atdat_1.nat;

#ifdef DISCOALL

        FREADN(&atdat_1.at[0], i_1 , (long)4);

	i_2 = atdat_1.nat;

        FREADN(&mdkons_1.atmas[0], i_2 , sizeof(double));
#else

        i_2 = i_1 * (sizeof(int) + sizeof(double));

    Discover.RetSeek = fseek(charmm_oc , i_2 , SEEK_CUR);
    if(Discover.RetSeek) {
    printf("?ERROR - can't read trajectory file : %s \n",traj_file);
    return(-1);}

#endif

	RECORD();

	RECORD();
	FREAD(&resdat_1.nnmres, sizeof(int));
	i_1 = resdat_1.nnmres;

#ifdef DISCOALL

        FREADN(&resdat_1.namres[0] , i_1 , (long)4);

#else
        i_2 = i_1 * sizeof(int);

    Discover.RetSeek = fseek(charmm_oc , i_2 , SEEK_CUR);
    if(Discover.RetSeek) {
    printf("?ERROR - can't read trajectory file : %s \n",traj_file);
    return(-1);}

#endif

	RECORD();

	RECORD();
	FREAD(&numinf_1.natom, sizeof(int));

     if(mliste[0] != numinf_1.natom) {
       PrintMessage("?ERROR - natom != DISCOVER trajectory natom");
       return(-1);}

     if(numinf_1.natom >= DISC_MAX_ATOMS) {
       PrintMessage("?ERROR - too many atoms in DISCOVER trajectory ");
       return(-1);}

     sprintf(OutText,"Number of atoms:               %d",numinf_1.natom);
        PrintMessage(OutText);

	i_1 = numinf_1.natom;

/* get space ... */
        kindat_1.knd = ivector(i_1);

	    FREADN(&kindat_1.knd[0] , i_1 , sizeof(int));

	i_2 = numinf_1.natom;

/* get space ... */
        kindat_1.jname = cvector(i_2 * NAME_LEN);

	    FREADN(&kindat_1.jname[0] , i_2 , (long)4);

	RECORD();

	if (mdopt_1.vershn < 2.6) {
	    RECORD();
	    FREAD(&movinf_1.nmove  , sizeof(int));
	    FREAD(&movinf_1.natmov , sizeof(int));
	    RECORD();
	} else {
	    RECORD();
	    FREAD(&movinf_1.nmove  , sizeof(int));
	    FREAD(&movinf_1.natmov , sizeof(int));
	    i_1 = movinf_1.natmov;

            FREADN(&movinf_1.lmove[0], i_1 , sizeof(int));

	    RECORD();
	}

        FixedAtoms = numinf_1.natom - movinf_1.natmov ;
        numat      = numinf_1.natom;

     sprintf(OutText,"Number of moving atoms:         %d",movinf_1.natmov);
        PrintMessage(OutText);
     sprintf(OutText,"Number of fixed atoms:          %d",FixedAtoms);
        PrintMessage(OutText);

	RECORD();
	FREAD(&numinf_1.nmol, sizeof(int));
	i_1 = numinf_1.nmol;

    if(i_1 >= MAX_DISCM) { /* too many molecules */
       PrintMessage("?ERROR - too many DISCOVER molecules ");
/* free scratch space ... */
    free(kindat_1.knd);
     free(kindat_1.jname);
       return(-1);}

	    FREADN(&molptr_1.natmol[0], i_1 , sizeof(int));

	i_2 = numinf_1.nmol;

	    FREADN(&molptr_1.nrsmol[0], i_2 , sizeof(int));

	RECORD();

	RECORD();
	FREAD(&numinf_1.nres, sizeof(int));
	i_1 = numinf_1.nres;
	for (ires = 0; ires < i_1; ++ires) {
	    FREAD(&resinf_1.ifirst[ires], sizeof(int));
	    FREAD(&resinf_1.last[ires], sizeof(int));
	}
	i_2 = numinf_1.nres;

	    FREADN(&resinf_1.lisres[0], i_2 , sizeof(int));

	RECORD();

	RECORD();
	FREAD(&numinf_1.nbond, sizeof(int));
	i_1 = numinf_1.nbond;
              intdat_1.ibw = ivector(2 * i_1);

/* here are the latest chnages from BIOSYM (1992-09-21) */
	if (mdopt_1.vershn > 2.7) {
	RECORD();
	RECORD();}

	for (ibond = 0; ibond < i_1; ++ibond) {
	    for (iat = 0; iat < 2; ++iat) {
		FREAD(&intdat_1.ibw[iat + 2 * ibond], sizeof(int));
	    }
	}
              free(intdat_1.ibw);
	RECORD();

	RECORD();
	FREADN(&symdat_1.ucvec[0] , c__6 , sizeof(double));
	FREADN(&symdat_1.ucvcar[0], c__9 , sizeof(double));
	FREADN(&symdat_1.crycar[0], c__9 , sizeof(double));
	FREADN(&symdat_1.carcry[0], c__9 , sizeof(double));
	FREADN(&symdat_1.symops[0], c__1764 , sizeof(double));
	FREADN(&symdat_1.tranop[0], c__588 , sizeof(double));
	FREADN(&symdat_1.symcr[0] ,  c__1764 ,sizeof(double));
	FREAD(&symdat_1.nsymop, sizeof(int));
	FREAD(&symdat_1.aboxa ,  sizeof(double));
	FREAD(&symdat_1.aboxb ,  sizeof(double));
	FREAD(&symdat_1.aboxc , sizeof(double));
	FREAD(&symdat_1.boxlim, sizeof(double));
	FREAD(&nsymsm         , sizeof(int));
	FREAD(&symdat_1.boxmnx, sizeof(double));
	FREAD(&symdat_1.boxmxx, sizeof(double));
	FREAD(&symdat_1.boxmny, sizeof(double));
	FREAD(&symdat_1.boxmxy, sizeof(double));
	FREAD(&symdat_1.boxmnz, sizeof(double));
	FREAD(&symdat_1.boxmxz, sizeof(double));
	FREAD(&symdat_1.ncellx, sizeof(int));
	FREAD(&symdat_1.ncelly, sizeof(int));
	FREAD(&symdat_1.ncellz, sizeof(int));
	FREAD(&symdat_1.ncelx2, sizeof(int));
	FREAD(&symdat_1.ncely2, sizeof(int));
	FREAD(&symdat_1.ncelz2, sizeof(int));
	RECORD();

	RECORD();
	FREAD(&mdeng_1.nenrg , sizeof(int));
#ifdef DEBUG
printf("Number of energies %d\n",mdeng_1.nenrg);
#endif
	FREAD(&mdopt_1.tmstpi, sizeof(double));
	FREAD(&mdopt_1.nwrstp, sizeof(int));
	FREAD(&mdavs_1.isteps, sizeof(int));
	RECORD();

        trajectory_info.time_bw_steps    = (int) mdopt_1.tmstpi;

/* Ok the header field is now done ... */

        if(alt < 0) { 
        RecordL = 
              4 * sizeof(int)                    +
                  sizeof(int)                    +
              3 * sizeof(double)                 +
  mdeng_1.nenrg * sizeof(double)                 +
  numinf_1.nmol * sizeof(double)                 +
  mdeng_1.nenrg * numinf_1.nmol * sizeof(double) +
              4 * numinf_1.nmol * sizeof(double) +
              2 * sizeof(double)                 +
             54 * sizeof(double)                 +
                  sizeof(int);

        RecordA =      sizeof(int)               +
                  6  * sizeof(double)            +
                  9  * sizeof(double)            +
                       sizeof(int);

        RecordL1 = 6 * numinf_1.natom  * sizeof(float);

        RecordL2 = 6 * movinf_1.natmov * sizeof(float);

        Discover.WhereInFile = ftell(charmm_oc); 

        /* no need to  do more, I was just interested in headers */
        /* just look for the number of frames                    */
    Discover.RetSeek = fseek(charmm_oc,0L,SEEK_END);
    if(Discover.RetSeek) {
    printf("?ERROR - can't read trajectory file : %s \n",traj_file);
    return(-1);}
    dynamics_frames = (ftell(charmm_oc) - (RecordL + RecordL1) 
                                        -  Discover.WhereInFile) / 
                       (RecordL + RecordA + RecordL2 + 
                                            3 * sizeof(int)) + 1;

/*    RecordL   =  RecordL + 6 * movinf_1.natmov * sizeof(float); */

     trajectory_info.nstep    = dynamics_frames;
     play_dynam_frames.numset = dynamics_frames;
     sprintf(OutText,"Number of frames:              %d",dynamics_frames);
          PrintMessage(OutText);

/* free scratch space ... */

    free(kindat_1.knd);
     free(kindat_1.jname);

          traj_in_core = 2; /* always out of core */

          fclose(charmm_oc);
          return(0);}
     }

        if(alt > 0) {  /* for all other records there is first the control 
                          block */

        Discover.JumpPoint = Discover.WhereInFile + RecordL + RecordL1 + 
                             (alt - 1) * (RecordL + RecordL2 + RecordA + 
                             3 * sizeof(int));

    Discover.RetSeek = fseek(charmm_oc,Discover.JumpPoint,SEEK_CUR);
    if(Discover.RetSeek) {
    printf("?ERROR - can't read trajectory file : %s \n",traj_file);
    return(-1);}

      
	  RECORD();
          FREAD(&kntrl, sizeof(int));
           if(kntrl < 1) {
             PrintMessage("?ERROR - in control record of Discover file ");
             return(-1);}
	  RECORD();

        } 
        else {
        Discover.JumpPoint =  Discover.WhereInFile;
         Discover.RetSeek = fseek(charmm_oc,Discover.JumpPoint,SEEK_CUR);
          if(Discover.RetSeek) {
           sprintf(OutText,"?ERROR - can't read trajectory file : %s \n",traj_file);
           PrintMessage(OutText);
            return(-1);}}

	RECORD();
	FREAD(&mdeng_1.etot, sizeof(double));
	FREAD(&mdeng_1.etp , sizeof(double));
	FREAD(&mdeng_1.etk , sizeof(double));

	i_1 = mdeng_1.nenrg;
	    FREADN(&enrgys[0], i_1 , sizeof(double));
	i_2 = numinf_1.nmol;
	    FREADN(&enmol_1.etotml[0], i_2 , sizeof(double));

	i_3 = mdeng_1.nenrg;
	for (ien = 0; ien < i_3; ++ien) {
	    i_4 = numinf_1.nmol;
	    for (iml = 0; iml < i_4; ++iml) {
	    FREAD(&enmols[iml + ien * MAX_DISCM - MAX_DISCM], sizeof(double));
	    }
	}
	i_5 = numinf_1.nmol;
	    FREADN(&interm_1.edpmlr[0], i_5 , sizeof(double));
	i_6 = numinf_1.nmol;
	    FREADN(&interm_1.erpmlr[0], i_6 , sizeof(double));
	i_7 = numinf_1.nmol;
	    FREADN(&interm_1.eljmlr[0], i_7 , sizeof(double));
	i_8 = numinf_1.nmol;
	    FREADN(&interm_1.estmlr[0], i_8 , sizeof(double));

	FREAD(&mdpres_1.presur, sizeof(double));
	FREAD(&mdpres_1.presrm, sizeof(double));
	FREADN(&mdpres_1.presst[0], c__9 , sizeof(double));
	FREADN(&mdpres_1.prestm[0], c__9 , sizeof(double));
	FREADN(&mdpres_1.etkv[0]  , c__9 , sizeof(double));
	FREADN(&mdpres_1.etkm[0]  , c__9 , sizeof(double));
	FREADN(&mdpres_1.virial[0], c__9 , sizeof(double));
	FREADN(&mdpres_1.virilm[0], c__9 , sizeof(double));
	RECORD();

        if(alt) {
	RECORD();
	FREADN(&symdat_1.ucvec[0]  , c__6 , sizeof(double));
	FREADN(&symdat_1.ucvcar[0] , c__9 , sizeof(double));
	RECORD();}
         

    if(iappend) {   /* append atoms */

    i_1 = mliste[mlist_deep - 1];

/* check dimensions */
    if((i_1 + numinf_1.natom) > MAXatom) {
      printf("?ERROR - next frame does not fit into the coordinate array \n");
      return(-1);}

      RECORD();

        if( FixedAtoms > 0 && alt > 0) {
           xtemp = vector(movinf_1.natmov);
            ytemp = vector(movinf_1.natmov);
             ztemp = vector(movinf_1.natmov);

	for (iat = 0; iat < movinf_1.natmov; iat++) {
	    FREAD(&xtemp[iat], sizeof(float));
	    FREAD(&ytemp[iat], sizeof(float));
	    FREAD(&ztemp[iat], sizeof(float));}

        for(iat = 0 ; iat < numinf_1.natom ; iat++) {
              i_2 = iat + i_1;
            x[i_2] = x[iat] + sumx;
             y[i_2] = y[iat] + sumy;
              z[i_2] = z[iat] + sumz;}

        for(iat = 0 ; iat < movinf_1.natmov ; iat++) {
              i_2 = i_1 + movinf_1.lmove[iat] - 1;
            x[i_2] = xtemp[iat];
             y[i_2] = ytemp[iat];
              z[i_2] = ztemp[iat];}

        free(xtemp);
         free(ytemp);
          free(ztemp);}

        else {

     tempry_1.xcoor = &x[i_1]; 
      tempry_1.ycoor = &y[i_1]; 
       tempry_1.zcoor = &z[i_1];

	for (iat = 0; iat < numinf_1.natom; iat++) {
            FREAD(&tempry_1.xcoor[iat], sizeof(float)); 
	    FREAD(&tempry_1.ycoor[iat], sizeof(float));
	    FREAD(&tempry_1.zcoor[iat], sizeof(float));}
   }}

     else {  /* no append */

/* check dimensions */
    if(numinf_1.natom > MAXatom) {
      printf("?ERROR - next frame does not fit into the coordinate array \n");
      return(-1);}
     
                     
	RECORD();

        if( FixedAtoms > 0 && alt > 0) {
           xtemp = vector(movinf_1.natmov);
            ytemp = vector(movinf_1.natmov);
             ztemp = vector(movinf_1.natmov);

	for (iat = 0; iat < movinf_1.natmov; iat++) {
	    FREAD(&xtemp[iat], sizeof(float));
	    FREAD(&ytemp[iat], sizeof(float));
	    FREAD(&ztemp[iat], sizeof(float));}

        for(iat = 0 ; iat < numinf_1.natom ; iat++) {
            x[iat] += sumx;
             y[iat] += sumy;
              z[iat] += sumz;}

        for(iat = 0 ; iat < movinf_1.natmov ; iat++) {
             i_2 = movinf_1.lmove[iat] - 1;
            x[i_2] = xtemp[iat];
             y[i_2] = ytemp[iat];
              z[i_2] = ztemp[iat];}

        free(xtemp);
         free(ytemp);
          free(ztemp);}

        else {

     tempry_1.xcoor = &x[0]; 
      tempry_1.ycoor = &y[0]; 
       tempry_1.zcoor = &z[0];

	for (iat = 0; iat < numinf_1.natom; iat++) {
	    FREAD(&tempry_1.xcoor[iat], sizeof(float));
	    FREAD(&tempry_1.ycoor[iat], sizeof(float));
	    FREAD(&tempry_1.zcoor[iat], sizeof(float));
	  }}}

	RECORD();

/* get temp space for the velocities (they are not used now) */

        tempry_1.xvlcty = vector(numinf_1.natom);
         tempry_1.yvlcty = vector(numinf_1.natom);
          tempry_1.zvlcty = vector(numinf_1.natom);

	RECORD();

        if(kntrl) 
          i_1 = movinf_1.natmov;
        else 
          i_1 = numinf_1.natom; 

	for (iat = 0; iat < i_1; ++iat) {
	    FREAD(&tempry_1.xvlcty[iat], sizeof(float));
	    FREAD(&tempry_1.yvlcty[iat], sizeof(float));
	    FREAD(&tempry_1.zvlcty[iat], sizeof(float));
	}
	RECORD();

        update_mlist(numinf_1.natom);

/* free the velocity array ...*/

        free(tempry_1.xvlcty);
         free(tempry_1.yvlcty);
          free(tempry_1.zvlcty);

    rewind(charmm_oc);
    return(0);

/*     PARTIAL RECORD HAS BEEN READ IN.  SET ERROR FLAG TO 1 AND RETURN */


L900:

/* free scratch space ... */

    free(kindat_1.knd);
     free(kindat_1.jname);

    return (-1);
} /* rdin22_ */

#undef enmols
#undef enrgys


