/*  

                       Copyright (c) 1990,1991,1992 by:
        Leif Laaksonen , Centre for Scientific Computing, ESPOO, FINLAND
            Confidential unpublished property of Leif Laaksonen
                        All rights reserved
  

*/

#include <stdio.h>
#include <math.h>
#include <malloc.h>
#include <string.h>
#include "maxdefs.h"

#define MOD(a,b)  (((a+1)/b)*b - (a+1))

#define CHARMM_TEXT_FIELD 80

     extern void   PrintMessage();
     extern int   *ivector();
     extern float *vector();
     extern float *x;
     extern float *y;
     extern float *z;

/* this is a temporary fix    */
     extern float sumx;
     extern float sumy;
     extern float sumz;
/* fix it as soon as possible */

     extern int MAXatom;         /*  the real maximum number of atoms the
                                     programs is able to deal with  */

     extern int mlist_deep;      /* stack number indicator */
     extern int mlists[MAX_MLIST]; /* First index for molecule list */
     extern int mliste[MAX_MLIST]; /* Second index for molecule list */
     extern char mnlist[MAX_MLIST][BUFF_LEN]; 
                                /* name list for molecule file names */
     extern int force_type;

     extern struct {
     int nfreat;                        /* number of free atoms */
     int *free_atom_list;} free_alist;  /* list of free (not fixed) atoms */

/* structure for the dynamics trajectory file */

   extern struct {
    char traj_file[BUFF_LEN];                 /* file name          */
    int natom;                                /* number of atoms    */
    int nstep;                                /* number of steps    */
    int time_bw_steps;                        /* time between steps */
    int time_first_frame;                     /* time of first frame */
    int first_frame;                          /* first frame to be displayed */
    int last_frame;                           /* last frame to be displayed  */
    int delta_frame;                          /* display every delta frame */
                   }    trajectory_info;     


/* Read a frame from the trajectory file. This function opens the file,
   reads the header information 'fseeks' the place and read the frame.
   after that the file is closed again. */

/*  Symmetric shape index data for a Crystal/Constant pressure calculation */
    struct sym_shape {
     float xtlabc[6];};       /* lower triangle is used */

    extern struct sym_shape SymShapeMat;

    extern struct SimCryst {
    double xtlabc[6];} ShapeIndex;

/***************************************************************************/
int get_frame(ipar1,ipar2)  /* distributes the get to the right file type */
              int ipar1;    /* on return < 0 error >=0 ok return          */
              int ipar2;
/***************************************************************************/
{
         static int retv;

         switch(force_type) {

         case 0: /* type is not set */
                 printf("?ERROR - trajectory type is not set \n");
                 return(-1);

	 case 1: /* charmm type */
                 retv = get_frame_charmm(ipar1,ipar2);
                 return(retv);              

	 case 2: /* discover type */
                 retv = get_frame_discover(ipar1,ipar2);
                 return(retv);

 	 case 3: /* amber type */
                 retv = get_frame_amber(ipar1,ipar2);
                 return(retv);

	 case 4: /* yasp type */
                 retv = get_frame_yasp(ipar1,ipar2);
                 return(retv);

	 case 5: /* mumod type */
                 retv = get_frame_mumod(ipar1,ipar2);
                 return(retv);

	 case 6: /* gromos type */
                 retv = get_frame_gromos(ipar1,ipar2);
                 return(retv);

         case 7: /* hyperchem type */
                 retv = get_frame_hyperchem(ipar1,ipar2);
                 return(retv);

	 default: /* there is something wrong */
                 printf("?ERROR - can't continue (in 'get_frame')\n");
                 shut_down(1);
	       }
}

/***************************************************************************/
int get_frame_charmm(alt,iappend)  
                        /* read frame number 'alt' from charmm trajectory   */
    int alt;            /* mode of operation (=0) first time in read
                                      (>0) trajectory number */
    int iappend;        /* if = 0 no append , if = 1 append */
/***************************************************************************/
{
/*  
     Program to read CHARMm binary files

     leif laaksonen  1989

     1992-11-17. Added constant pressure/crystal information record. LUL

*/
/* externals    */
    extern FILE *charmm_oc;
    extern float *x,*y,*z;
    extern int numat;
    extern char traj_file[BUFF_LEN];

/* 1 HDR , ICONTR  */
  char hdr[4];      /* unknown header information */
  static int icntrl[20];/* contains information about the datasets held in file

                     (1) number of data sets in the file. Not necessary correct
                     (2) time of the first data set. Usually in femtoseconds
                     (3) time steps between data sets
                     (9) number of fixed atoms (NFIXED)   
                     (11) 1 for crystal/constant pressure calculation
                          0 otherwise
                     (20) version number (22 for CHARMm 22, 0 for
                          previous version */

/* 2 TITLE         */
  int ntitl;      /* (title(i,j), i=1,10),j=1,ntitl)
                     double precision title(10,10) */

/* 3 NATOM          (NFREAT = NATOM - NFIXED) */
  static int natom;


   static int icount,i;
   static int record;
   static int memory;
   static int nstep,ifbeg,ifstep;
   static int every_step;              /* reading only every 'every_step' from
                                          the trajectory file */
   static int read_loop;
   static long record_len1=0;        /* the "record" length in bytes of one
                                      record containing the x,y and z
                                      coordinates plus the information
                                      in between the coordinates (first 
                                      record)*/
   static long record_len2;          /* rest of the records if icntrl[8] > 0 */

   static long ret_fseek;
   static int idx1,idx2,idx3;
   static int nfreat; /* number of free atoms */

   static float *tax; /* temp vectors in case of fixed atoms */
   static float *tay;
   static float *taz;
   static int jumps;
   static int qcrys;
   static int CrystLen;

   char label[BUFF_LEN];
   int numset,  /* number of data sets */
   pasback[20]; /* information about the trajectory */

   every_step = 1;
   CrystLen = 0;


/*  start reading  */

#ifdef CRAY
  
    icount = fread(&record,sizeof(int), 1 ,charmm_oc);
    icount = fread(hdr,sizeof(char), 4 ,charmm_oc);
    icount = fread(icntrl,sizeof(int), 20 ,charmm_oc);
    icount = fread(&record,sizeof(int), 1 ,charmm_oc);
    icount = fread(&ntitl,sizeof(int), 1 ,charmm_oc);

    if(ntitl > MAX_TITLE_LINES_TRAJ) {
    PrintMessage("?ERROR - problems in reading the title in the trajectory file");
    PrintMessage("Are you sure this is a CHARMM trajectory?");
    return(-1);}

    for(i = 0 ; i < ntitl ; i++) {
    icount = fread(label,10*sizeof(double),1,charmm_oc);
    label[79] = '\0';
    }

    icount = fread(&record,sizeof(int), 1 ,charmm_oc);
    icount = fread(&natom,sizeof(int), 1 , charmm_oc);
    icount = fread(&record,sizeof(int), 1 ,charmm_oc);

    qcrys = 0;
    if(icntrl[10]) {
      qcrys = 1;
       CrystLen = 2 * sizeof(int) + 6 * sizeof(float);}

    if(icntrl[8] > 0) {/* there are fixed atoms */
     if(free_alist.nfreat > 0) free(free_alist.free_atom_list);
    nfreat = natom - icntrl[8];
    free_alist.nfreat = nfreat;
    free_alist.free_atom_list = ivector(nfreat);
 
     tax = vector(nfreat);
       tay = vector(nfreat);
        taz = vector(nfreat);

    icount = fread(free_alist.free_atom_list,sizeof(int), nfreat , charmm_oc);
    icount = fread(&record,sizeof(int), 1 ,charmm_oc);}

#else
  
    icount = fread(&record,sizeof(int), 1 ,charmm_oc);

    icount = fread(hdr,sizeof(char), 4 ,charmm_oc);
    icount = fread(icntrl,sizeof(int), 20 ,charmm_oc);

    icount = fread(&record,sizeof(int), 1 ,charmm_oc);
    icount = fread(&record,sizeof(int), 1 ,charmm_oc);

    icount = fread(&ntitl,sizeof(int), 1 ,charmm_oc);

    for(i = 0 ; i < ntitl ; i++) {
    icount = fread(label, CHARMM_TEXT_FIELD ,1,charmm_oc);
    label[CHARMM_TEXT_FIELD - 1] = '\0';
    }

    icount = fread(&record,sizeof(int), 1 ,charmm_oc);
    icount = fread(&record,sizeof(int), 1 ,charmm_oc);

    icount = fread(&natom,sizeof(int), 1 , charmm_oc);
    icount = fread(&record,sizeof(int), 1 ,charmm_oc);

    nfreat = natom;

    qcrys = 0;
    if(icntrl[10]) {
      qcrys = 1;
       CrystLen = 2 * sizeof(int) + 6 * sizeof(double);}

    if(icntrl[8] > 0) {/* there are fixed atoms */
     if(free_alist.nfreat > 0) free(free_alist.free_atom_list);
    nfreat = natom - icntrl[8];
    free_alist.nfreat = nfreat;
    free_alist.free_atom_list = ivector(nfreat);

      tax = vector(nfreat);
       tay = vector(nfreat);
        taz = vector(nfreat);

    icount = fread(&record,sizeof(int), 1 ,charmm_oc);
    icount = fread(free_alist.free_atom_list,sizeof(int), nfreat , charmm_oc);
    icount = fread(&record,sizeof(int), 1 ,charmm_oc);}

#endif

/* determine the "record length"    */
    record_len1 = 6 * sizeof(int) + /* the record contribution */
                  3 * natom * sizeof(float); /* x-,y- and z-contribution */
/* record length if there are fixed atoms */
    record_len2 = 6 * sizeof(int) + /* the record contribution */
                  3 * nfreat * sizeof(float); /* x-,y- and z-contribution */

    if(qcrys) {
        record_len1 += CrystLen;
        record_len2 += CrystLen;}

/*                                  */

        for(i = 0 ; i < 20 ; i++) pasback[i] = icntrl[i];

	nstep=icntrl[0];
        numset = nstep;
	ifbeg=icntrl[1];
	ifstep=icntrl[2];

/* update trajectory info ... */
        trajectory_info.natom            = natom;
        trajectory_info.nstep            = nstep;
        trajectory_info.time_bw_steps    = icntrl[2];
        trajectory_info.time_first_frame = 0;


/* test that number of atoms in the file is the same as for the displayed
   molecule  */

  if(natom != mliste[0]) {
  sprintf(label,"\07\07 **** ERROR number of atoms in the file does not match\n");
  PrintMessage(label);
  return(-1);}

  if(icntrl[8]) {
    if(alt > 0) {
    ret_fseek = fseek(charmm_oc,(record_len1 + (alt - 1) * record_len2),1);
    if(ret_fseek) {
    sprintf(label,"?ERROR - can't read trajectory file : %s \n",traj_file);
    PrintMessage(label);
    return(-1);}}
  }
    else {
    if(alt > 0) {
    ret_fseek = fseek(charmm_oc,(alt*record_len1),1);
    if(ret_fseek) {
    sprintf(label,"?ERROR - can't read trajectory file : %s \n",traj_file);
    PrintMessage(label);
    return(-1);}}}

#ifdef DEBUG
    printf(" Retrieving frame number : %d \n",alt+1);
#endif

    if(iappend == 0) {

    if(icntrl[8] > 0 && alt > 0) {

    if(qcrys) {
      icount = fread(&record,sizeof(int), 1 ,charmm_oc);
       icount = fread(ShapeIndex.xtlabc,sizeof(double),6,charmm_oc);
        icount = fread(&record,sizeof(int), 1 ,charmm_oc);}

    icount = fread(&record,sizeof(int), 1 ,charmm_oc);
    icount = fread(tax,sizeof(float),nfreat,charmm_oc);
    icount = fread(&record,sizeof(int), 1 ,charmm_oc);

    icount = fread(&record,sizeof(int), 1 ,charmm_oc);
    icount = fread(tay,sizeof(float),nfreat,charmm_oc);
    icount = fread(&record,sizeof(int), 1 ,charmm_oc);

    icount = fread(&record,sizeof(int), 1 ,charmm_oc);
    icount = fread(taz,sizeof(float),nfreat,charmm_oc);
    icount = fread(&record,sizeof(int), 1 ,charmm_oc);
    
    for(i = 0 ; i < natom ; i++) {
       x[i] += sumx;
        y[i] += sumy;
         z[i] += sumz;}

/* put new values in */
    for(i = 0 ; i < nfreat; i++) {
       x[free_alist.free_atom_list[i] - 1] = tax[i];
        y[free_alist.free_atom_list[i] - 1] = tay[i];
         z[free_alist.free_atom_list[i] - 1] = taz[i];}

    update_mlist(natom);
    }
    else {

    if(qcrys) {
      icount = fread(&record,sizeof(int), 1 ,charmm_oc);
       icount = fread(ShapeIndex.xtlabc,sizeof(double),6,charmm_oc);
        icount = fread(&record,sizeof(int), 1 ,charmm_oc);}

    icount = fread(&record,sizeof(int), 1 ,charmm_oc);
    icount = fread(x,sizeof(float),natom,charmm_oc);
    icount = fread(&record,sizeof(int), 1 ,charmm_oc);

    icount = fread(&record,sizeof(int), 1 ,charmm_oc);
    icount = fread(y,sizeof(float),natom,charmm_oc);
    icount = fread(&record,sizeof(int), 1 ,charmm_oc);

    icount = fread(&record,sizeof(int), 1 ,charmm_oc);
    icount = fread(z,sizeof(float),natom,charmm_oc);
    icount = fread(&record,sizeof(int), 1 ,charmm_oc);

    update_mlist(natom);
  }}
    else {

    idx1 = mliste[mlist_deep - 1];

/* check dimensions */
    if((idx1+natom) > MAXatom) {
      PrintMessage("?ERROR - next frame does not fit into the coordinate array");
      return(-1);}

    if(icntrl[8] > 0 && alt > 0) {

    if(qcrys) {
      icount = fread(&record,sizeof(int), 1 ,charmm_oc);
       icount = fread(ShapeIndex.xtlabc,sizeof(double),6,charmm_oc);
        icount = fread(&record,sizeof(int), 1 ,charmm_oc);}

    icount = fread(&record,sizeof(int), 1 ,charmm_oc);
    icount = fread(tax,sizeof(float),nfreat,charmm_oc);
    icount = fread(&record,sizeof(int), 1 ,charmm_oc);

    icount = fread(&record,sizeof(int), 1 ,charmm_oc);
    icount = fread(tay,sizeof(float),nfreat,charmm_oc);
    icount = fread(&record,sizeof(int), 1 ,charmm_oc);

    icount = fread(&record,sizeof(int), 1 ,charmm_oc);
    icount = fread(taz,sizeof(float),nfreat,charmm_oc);
    icount = fread(&record,sizeof(int), 1 ,charmm_oc);
    
    for(i = 0 ; i < natom ; i++) {
       x[i + idx1] = x[i] + sumx;
        y[i + idx1] = y[i] + sumy;
         z[i + idx1]=  z[i] + sumz ;}

/* put new values in */
    for(i = 0 ; i < nfreat; i++) {
       x[idx1 + free_alist.free_atom_list[i] - 1] = tax[i];
        y[idx1 + free_alist.free_atom_list[i] - 1] = tay[i];
         z[idx1 + free_alist.free_atom_list[i] - 1] = taz[i];}

    update_mlist(natom);
    }

    else {

    if(qcrys) {
      icount = fread(&record,sizeof(int), 1 ,charmm_oc);
       icount = fread(ShapeIndex.xtlabc,sizeof(double),6,charmm_oc);
        icount = fread(&record,sizeof(int), 1 ,charmm_oc);}

    icount = fread(&record,sizeof(int), 1 ,charmm_oc);
    icount = fread(&x[idx1],sizeof(float),natom,charmm_oc);
    icount = fread(&record,sizeof(int), 1 ,charmm_oc);

    icount = fread(&record,sizeof(int), 1 ,charmm_oc);
    icount = fread(&y[idx1],sizeof(float),natom,charmm_oc);
    icount = fread(&record,sizeof(int), 1 ,charmm_oc);

    icount = fread(&record,sizeof(int), 1 ,charmm_oc);
    icount = fread(&z[idx1],sizeof(float),natom,charmm_oc);
    icount = fread(&record,sizeof(int), 1 ,charmm_oc);

    update_mlist(natom);
  }}

    if(icntrl[8]) {
      free(tax);
       free(tay);
        free(taz);}

   return(0);
/*                                  */

}


