/*  

                       Copyright (c) 1990, 1991, 1992 by:
        Leif Laaksonen , Centre for Scientific Computing, ESPOO, FINLAND
            Confidential unpublished property of Leif Laaksonen
                        All rights reserved
  

*/

#include <stdio.h>
#include <string.h>
#include <math.h>
#include "maxdefs.h"

#define CHECK_TRAJ_FILE() { if(trajectory_info.traj_file[0] == '\0') {   \
                       PrintMessage("?ERROR - no trajectory file defined \n"); \
                       check_if_fatal(1); \
                       return;}}

/* structure for the dynamics trajectory file */

   extern struct {
    char traj_file[BUFF_LEN];                 /* file name          */
    int natom;                                /* number of atoms    */
    int nstep;                                /* number of steps    */
    int time_bw_steps;                        /* time between steps */
    int time_first_frame;                     /* time of first frame */
    int first_frame;                          /* first frame to be displayed */
    int last_frame;                           /* last frame to be displayed  */
    int delta_frame;                          /* display every delta frame */
                   }    trajectory_info;     


    extern int keyb_command;

     extern char parsed[MAXparse][MAXlinel];
     extern int term_type;
     extern int yes_no_graph;

     extern void PrintMessage();

/************************************************************************/
fill_fac(input,num)   /* interpret the fill command */
   char *input; 
   int num;
/************************************************************************/
{

     int k;
     char OutText[BUFF_LEN];

     toller(parsed[1]);

/* help text                     */
   if(indexo(parsed[1],"?") == 1) {
   PrintMessage("fill dist*ance arra*y         ! Fill distance array ");
   PrintMessage("               null           ! Delete all distance arrays ");
   PrintMessage("    -dis*tance                ! Delete all distance arrays ");
   PrintMessage("fill angl*e arra*y            ! Fill angle array ");
   PrintMessage("            null              ! Delete all angle arrays ");
   PrintMessage("    -ang*le                   ! Delete all angle arrays ");
   PrintMessage("fill tors*ion arra*y          ! Fill torsion array ");
   PrintMessage("              null            ! Delete all torsion arrays ");
   PrintMessage("    -tor*sion                 ! Delete all torsion arrays ");
   PrintMessage("fill tote*nergy array         ! Fill total energy array ");
   PrintMessage("                null          ! Delete total energy array ");
   PrintMessage("    -tot*energy               ! Delete total energy array ");
   PrintMessage("fill pote*nergy array         ! Fill potential energy array ");
   PrintMessage("                null          ! Delete potential energy array ");
   PrintMessage("    -pot*energy               ! Delete potential energy array ");
   PrintMessage("fill kine*nergy array         ! Fill kinetic energy array ");
   PrintMessage("                null          ! Delete kinetic energy array ");
   PrintMessage("    -kin*energy               ! Delete kinetic energy array ");
   PrintMessage("fill temp*erature array       ! Fill temperature array ");
   PrintMessage("                  null        ! Delete temperature array ");
   PrintMessage("    -tem*perature             ! Delete temperature array ");

   PrintMessage("fill bond        array        ! Fill bond energy array ");
   PrintMessage("                  null        ! Delete bond array ");
   PrintMessage("    -bon*d                    ! Delete bond array ");

   PrintMessage("fill angl*e       array       ! Fill angle energy array ");
   PrintMessage("                  null        ! Delete angle array ");
   PrintMessage("    -ang*le                   ! Delete angle array ");

   PrintMessage("fill dihe*dral    array       ! Fill dihedral energy array ");
   PrintMessage("                  null        ! Delete dihedral array ");
   PrintMessage("    -dih*edral                ! Delete dihedral array ");

   PrintMessage("fill impr*oper    array       ! Fill improper energy array ");
   PrintMessage("                  null        ! Delete improper array ");
   PrintMessage("    -imp*roper                ! Delete improper array ");

   PrintMessage("fill vdw         array        ! Fill vdW energy array ");
   PrintMessage("                  null        ! Delete  vdW array ");
   PrintMessage("    -vdw                      ! Delete  vdW array ");

   PrintMessage("fill elec*tronic  array       ! Fill elec energy array ");
   PrintMessage("                  null        ! Delete elec array ");
   PrintMessage("    -ele*c             ! Delete elec array ");

   PrintMessage("fill hbon*d       array       ! Fill hbond hbond energy array ");
   PrintMessage("                  null        ! Delete hbond array ");
   PrintMessage("    -hbo*nd                   ! Delete hbond array ");

   return;}

/* fill point vector          */
     if(indexo(parsed[1],"poin") == 1) {
       CHECK_TRAJ_FILE();
       toller(parsed[2]);
          if(indexo(parsed[2],"arra") == 1 || 
             indexo(parsed[2],"vect") == 1 ||
             indexo(parsed[2],"list") == 1) {
          keyb_command = 1;
          study_dynamics(46);
          return;}
          if(indexo(parsed[2],"null") == 1) {
          keyb_command = 1;
          study_dynamics(16);
          return;}
     }
     if(indexo(parsed[1],"-poi") == 1) {
       CHECK_TRAJ_FILE();
          keyb_command = 1;
          study_dynamics(16);
          return;
     }

/* fill distance vector          */
     if(indexo(parsed[1],"dist") == 1) {
       CHECK_TRAJ_FILE();
       toller(parsed[2]);
          if(indexo(parsed[2],"arra") == 1 || 
             indexo(parsed[2],"vect") == 1 ||
             indexo(parsed[2],"list") == 1) {
          keyb_command = 1;
          study_dynamics(9);
          return;}
          if(indexo(parsed[2],"null") == 1) {
          keyb_command = 1;
          study_dynamics(16);
          return;}
     }
     if(indexo(parsed[1],"-dis") == 1) {
       CHECK_TRAJ_FILE();
          keyb_command = 1;
          study_dynamics(16);
          return;
     }

     if(indexo(parsed[1],"angl") == 1) {
       CHECK_TRAJ_FILE();
       toller(parsed[2]);
          if(indexo(parsed[2],"arra") == 1 || 
             indexo(parsed[2],"vect") == 1 ||
             indexo(parsed[2],"list") == 1) {
          keyb_command = 1;
          study_dynamics(10);
          return;}
          if(indexo(parsed[2],"null") == 1) {
          keyb_command = 1;
          study_dynamics(16);
          return;}
     }
     if(indexo(parsed[1],"-ang") == 1) {
       CHECK_TRAJ_FILE();
          keyb_command = 1;
          study_dynamics(16);
          return;
     }

     if(indexo(parsed[1],"tors") == 1) {
       CHECK_TRAJ_FILE();
       toller(parsed[2]);
          if(indexo(parsed[2],"arra") == 1 || 
             indexo(parsed[2],"vect") == 1 ||
             indexo(parsed[2],"list") == 1) {
          keyb_command = 1;
          study_dynamics(11);
          return;}
          if(indexo(parsed[2],"null") == 1) {
          keyb_command = 1;
          study_dynamics(16);
          return;}
     }

     if(indexo(parsed[1],"-tor") == 1) {
       CHECK_TRAJ_FILE();
          keyb_command = 1;
          study_dynamics(16);
          return;
     }
     if(indexo(parsed[1],"tote") == 1) {
       toller(parsed[2]);
          if(indexo(parsed[2],"arra") == 1 || indexo(parsed[2],"vect") == 1) {
          keyb_command = 1;
          study_dynamics(12);
          return;}
          if(indexo(parsed[2],"null") == 1) {
          keyb_command = 1;
          study_dynamics(16);
          return;}
     }

     if(indexo(parsed[1],"-tot") == 1) {
          keyb_command = 1;
          study_dynamics(16);
          return;
     }

     if(indexo(parsed[1],"pote") == 1) {
       toller(parsed[2]);
          if(indexo(parsed[2],"arra") == 1 || indexo(parsed[2],"vect") == 1) {
          keyb_command = 1;
          study_dynamics(13);
          return;}
          if(indexo(parsed[2],"null") == 1) {
          keyb_command = 1;
          study_dynamics(16);
          return;}
     }

     if(indexo(parsed[1],"-pot") == 1) {
          keyb_command = 1;
          study_dynamics(16);
          return;
     }

     if(indexo(parsed[1],"kine") == 1) {
       toller(parsed[2]);
          if(indexo(parsed[2],"arra") == 1 || indexo(parsed[2],"vect") == 1) {
          keyb_command = 1;
          study_dynamics(14);
          return;}
          if(indexo(parsed[2],"null") == 1) {
          keyb_command = 1;
          study_dynamics(16);
          return;}
     }

     if(indexo(parsed[1],"-kin") == 1) {
          keyb_command = 1;
          study_dynamics(16);
          return;
     }

     if(indexo(parsed[1],"temp") == 1) {
       toller(parsed[2]);
          if(indexo(parsed[2],"arra") == 1 || indexo(parsed[2],"vect") == 1) {
          keyb_command = 1;
          study_dynamics(15);
          return;}
          if(indexo(parsed[2],"null") == 1 ) {
          keyb_command = 1;
          study_dynamics(16);
          return;}
     }

     if(indexo(parsed[1],"-tem") == 1) {
          keyb_command = 1;
          study_dynamics(16);
          return;
     }

     if(indexo(parsed[1],"bond") == 1) {
       toller(parsed[2]);
          if(indexo(parsed[2],"arra") == 1 || indexo(parsed[2],"vect") == 1) {
          keyb_command = 1;
          study_dynamics(50);
          return;}
          if(indexo(parsed[2],"null") == 1 ) {
          keyb_command = 1;
          study_dynamics(16);
          return;}
     }

     if(indexo(parsed[1],"-bon") == 1) {
          keyb_command = 1;
          study_dynamics(16);
          return;
     }

     if(indexo(parsed[1],"angl") == 1) {
       toller(parsed[2]);
          if(indexo(parsed[2],"arra") == 1 || indexo(parsed[2],"vect") == 1) {
          keyb_command = 1;
          study_dynamics(51);
          return;}
          if(indexo(parsed[2],"null") == 1 ) {
          keyb_command = 1;
          study_dynamics(16);
          return;}
     }

     if(indexo(parsed[1],"-ang") == 1) {
          keyb_command = 1;
          study_dynamics(16);
          return;
     }

     if(indexo(parsed[1],"dihe") == 1) {
       toller(parsed[2]);
          if(indexo(parsed[2],"arra") == 1 || indexo(parsed[2],"vect") == 1) {
          keyb_command = 1;
          study_dynamics(52);
          return;}
          if(indexo(parsed[2],"null") == 1 ) {
          keyb_command = 1;
          study_dynamics(16);
          return;}
     }

     if(indexo(parsed[1],"-dih") == 1) {
          keyb_command = 1;
          study_dynamics(16);
          return;
     }

     if(indexo(parsed[1],"impr") == 1) {
       toller(parsed[2]);
          if(indexo(parsed[2],"arra") == 1 || indexo(parsed[2],"vect") == 1) {
          keyb_command = 1;
          study_dynamics(53);
          return;}
          if(indexo(parsed[2],"null") == 1 ) {
          keyb_command = 1;
          study_dynamics(16);
          return;}
     }

     if(indexo(parsed[1],"-imp") == 1) {
          keyb_command = 1;
          study_dynamics(16);
          return;
     }

     if(indexo(parsed[1],"vdw") == 1) {
       toller(parsed[2]);
          if(indexo(parsed[2],"arra") == 1 || indexo(parsed[2],"vect") == 1) {
          keyb_command = 1;
          study_dynamics(54);
          return;}
          if(indexo(parsed[2],"null") == 1 ) {
          keyb_command = 1;
          study_dynamics(16);
          return;}
     }

     if(indexo(parsed[1],"-vdw") == 1) {
          keyb_command = 1;
          study_dynamics(16);
          return;
     }

     if(indexo(parsed[1],"elec") == 1) {
       toller(parsed[2]);
          if(indexo(parsed[2],"arra") == 1 || indexo(parsed[2],"vect") == 1) {
          keyb_command = 1;
          study_dynamics(55);
          return;}
          if(indexo(parsed[2],"null") == 1 ) {
          keyb_command = 1;
          study_dynamics(16);
          return;}
     }

     if(indexo(parsed[1],"-ele") == 1) {
          keyb_command = 1;
          study_dynamics(16);
          return;
     }

/*
     if(indexo(parsed[1],"exte") == 1) {
       toller(parsed[2]);
          if(indexo(parsed[2],"arra") == 1 || indexo(parsed[2],"vect") == 1) {
          keyb_command = 1;
          study_dynamics(55);
          return;}
          if(indexo(parsed[2],"null") == 1 ) {
          keyb_command = 1;
          study_dynamics(16);
          return;}
     }
     if(indexo(parsed[1],"-ext") == 1) {
          keyb_command = 1;
          study_dynamics(16);
          return;
     }

*/
/* default position "command not recognized"  */

     sprintf(OutText,"?ERROR: Following command not recognized: %s \n",input);
     PrintMessage(OutText);

}      /* end of define_fac */

