/*  

                       Copyright (c) 1990, 1994 by:
        Leif Laaksonen , Center for Scientific Computing, ESPOO, FINLAND
            Confidential unpublished property of Leif Laaksonen
                        All rights reserved
  

*/

#include <stdio.h>
#include <string.h>
#include <malloc.h>
#include <math.h>
#include "traja.h"
#include "maxdefs.h"

     extern int **cnct;
     extern char *segment;
     extern char *resnam;
     extern char *atnam;
     extern int atom_list_max();
     extern char parsed[MAXparse][MAXlinel];
     extern int numat;
     extern int *ivector();
     extern int select_list();
     extern int *res1;

     extern void PrintMessage();
     extern int  PutAtmName();
     extern int  PutResName();
     extern int  PutSegName();

     void edit_bond(int , char *, char *, char *, char *, char *,char *);

/************************************************************************/
edit_fac(input,num)   /* edit command */
   char *input; 
   int num;
/************************************************************************/
{

     int i;
     char OutText[BUFF_LEN];

/* switch to small characters                 */
     toller(parsed[1]);

/* help display                               */
   if(indexo(parsed[1],"?") == 1) {
   PrintMessage("edit atom char*ge seg:res:atom fcharge  ! Edit atom charge ");
   PrintMessage("          type    seg:res:atom itype    ! Edit atom type");
   PrintMessage("     bond add s1:r1:a1 s2:r2:a2         ! Add bond ");
   PrintMessage("     bond brea*k s1:r1:a1 s2:r2:a2      ! Break bond");
#ifdef USEFORMS
   PrintMessage("     text                               ! Edit text");
#else
   PrintMessage("     text dele*te nr                    ! Edit text");
   PrintMessage("          list                          ! Edit text");
#endif
   PrintMessage("     segm*ent name seg:res:atm name     ! Edit segment name");
   PrintMessage("     resi*due name seg:res:atm name     ! Edit residue name");
   PrintMessage("     atom     name seg:res:atm name     ! Edit atom name");
   return;}

/* atomic                                     */
   if(indexo(parsed[1],"atom") == 1) {
     toller(parsed[2]);

        if(indexo(parsed[2],"name") == 1) {
          if(parsed[6][0] == '\0') {
            return;}
          EditAtomName(parsed[3],parsed[4],parsed[5],parsed[6]);
            return;}

         if(indexo(parsed[2],"char") == 1) {
         edit_charge();
         return;}
         if(indexo(parsed[2],"type") == 1) {
         edit_type();
         return;}
          }

/* edit bond                          */
       if(indexo(parsed[1],"bond") == 1) {
         toller(parsed[2]);
         if(indexo(parsed[2],"add") == 1) {
         edit_bond(1,parsed[3],parsed[4],parsed[5],parsed[6],parsed[7],parsed[8]);
         return;}
         if(indexo(parsed[2],"brea") == 1) {
         edit_bond(2,parsed[3],parsed[4],parsed[5],parsed[6],parsed[7],parsed[8]);
         return;}
       }

/* edit text                                  */
     if(indexo(parsed[1],"text") == 1) {
#ifdef USEFORMS
            edit_text(parsed[2],parsed[3],0);
            return;
#else
         toller(parsed[2]);
         if(indexo(parsed[2],"list") == 1) {
            edit_text(parsed[2],parsed[3],0);
            return;}
         if(indexo(parsed[2],"dele") == 1) {
            edit_text(parsed[2],parsed[3],1);
            return;}
#endif
      }

/* edit segment                                   */
     if(indexo(parsed[1],"segm") == 1) {
        toller(parsed[2]);
        if(indexo(parsed[2],"name") == 1) {
          if(parsed[6][0] == '\0') {
            return;}
          EditSegmName(parsed[3],parsed[4],parsed[5],parsed[6]);
            return;}}
/* edit residue                                   */
     if(indexo(parsed[1],"resi") == 1) {
        toller(parsed[2]);
        if(indexo(parsed[2],"name") == 1) {
          if(parsed[6][0] == '\0') {
            return;}
          EditResiName(parsed[3],parsed[4],parsed[5],parsed[6]);
            return;}}

/* default position "command not recognized"  */

     sprintf(OutText,"?ERROR: Following command not recognized: %s \n",input);
     PrintMessage(OutText);

}      /* end of edit_fac */
/************************************************************************/
edit_charge()
/************************************************************************/
{
     extern char parsed[MAXparse][MAXlinel];
     extern int *ivector();
     extern int select_list();
     extern int numat;
     extern float *atm_charge;

     static int i,si;
     static char chelp[BUFF_LEN];
     static int ihelp,atom_max;
     static float fhelp;
     static int *sel_list;
     static int slong;
     static char OutText[BUFF_LEN];

     atom_max = atom_list_max();

     sel_list = ivector(atom_max);
     fhelp = atof(parsed[6]);

     slong = select_list(parsed[3],parsed[4],parsed[5],sel_list);

     if(slong > 0) {
     ihelp = 0;

        for(i = 0 ; i < slong ; i++) {
          atm_charge[sel_list[i]] = fhelp;
          ihelp++;}
        sprintf(OutText,"Changed atom charge for %d atom(s)",ihelp);
        PrintMessage(OutText);
      }
      else
      PrintMessage("?ERROR - no atoms in the selection list");

        free(sel_list);
}
/************************************************************************/
edit_type()
/************************************************************************/
{
     extern char parsed[MAXparse][MAXlinel];
     extern int *ivector();
     extern int numat;
     extern int select_list();
     extern float *atm_charge;
     extern int   *atm_type;
     extern float *vdw_list;
     extern float find_mass(),find_vdwrad();

     static int i,si;
     static char chelp[BUFF_LEN];
     static int ihelp,ihelp1,atom_max;
     static float fhelp,fhelp1,fhelp2;
     static int *sel_list;
     static int slong;
     static char OutText[BUFF_LEN];

     atom_max = atom_list_max();
     sel_list = ivector(atom_max);
     ihelp = atoi(parsed[6]);

     if(ihelp <= 0) return;

     fhelp1 = find_mass(ihelp);
     fhelp2 = find_vdwrad(ihelp);

/*     if(fhelp1 < 0.00001 || fhelp2 < 0.00001) return;*/

     slong = select_list(parsed[3],parsed[4],parsed[5],sel_list);

     if(slong > 0) {
     ihelp1 = 0;
        for(i = 0 ; i < slong ; i++) {
          si = sel_list[i];
          atm_type[si] = ihelp;
          vdw_list[si] = fhelp2;
          ihelp1++;}
   }
   else
   PrintMessage("?ERROR - no atoms in the selection list");

      sprintf(OutText,"Changed atom type for %d atom(s)",ihelp1);
      PrintMessage(OutText);
        free(sel_list);
}

/************************************************************************/
void edit_bond(alt,text1,text2,text3,text4,text5,text6)
     int alt;
     char *text1;
     char *text2;
     char *text3;
     char *text4;
     char *text5;
     char *text6;
/************************************************************************/
{

     static int i,j,si;
     static char chelp[BUFF_LEN];
     static int ihelp;
     static float fhelp;
     static int *sel_list1,*sel_list2;
     static int slong1,slong2,atom_max;
     static char OutText[BUFF_LEN];

     atom_max = atom_list_max();
     sel_list1 = ivector(atom_max);
     sel_list2 = ivector(atom_max);

     slong1 = select_list(text1,text2,text3,sel_list1);
     slong2 = select_list(text4,text5,text6,sel_list2);

/*
     printf(" %d %d \n",slong1,slong2);
     printf(" '%s' '%s' '%s' \n",text1,text2,text3);
     printf(" '%s' '%s' '%s' \n",text4,text5,text6);

     printf(">> '%.4s' '%.4s' '%.4s'\n",segment+4*sel_list1[0],resnam+4*sel_list1[0],atnam+4*sel_list1[0]);
     printf(">> '%.4s' '%.4s' '%.4s'\n",segment+4*sel_list2[0],resnam+4*sel_list2[0],atnam+4*sel_list2[0]);
*/
     if(slong1 > 1 || slong2 > 1) {
       PrintMessage("?ERROR - more than one atom in selection list 1 or 2");
       return;}

     switch(alt) {

     case 1: /* add bond */

     if(slong1 == 1 && slong2 == 1) {

          i = sel_list1[0];
          j = sel_list2[0];

/* check first if there is a bond between atoms i and j */

   if(!cbond_ij(i,j)) {
   PrintMessage("?WARNING - there is already a bond between specified atoms ");
   return;}

          ihelp = cnct[i][0] + 1;

          if(ihelp >= MAXconn) {
            PrintMessage("?ERROR - max connections reached");
            free(sel_list1);
            free(sel_list2);
              return;}

          cnct[i][0] = ihelp;
          cnct[i][ihelp] = j;

          ihelp = cnct[j][0] + 1;

          if(ihelp >= MAXconn) {
            PrintMessage("?ERROR - max connections reached");
            free(sel_list1);
            free(sel_list2);
              return;}

          cnct[j][0] = ihelp;
          cnct[j][ihelp] = i;

        sprintf(OutText,"Created bond between '%.4s:%.4s(%d):%.4s' and '%.4s:%.4s(%d):%.4s' \n",
        segment+4*i,resnam+4*i,res1[i],atnam+4*i,
        segment+4*j,resnam+4*j,res1[j],atnam+4*j);
        PrintMessage(OutText);
      }
      else
      PrintMessage("?ERROR - no atoms in the selection list 1 or 2 ");

      break;

      case 2:  /*break bond */

      if(slong1 == 1 && slong2 == 1) {

          i = sel_list1[0];
          j = sel_list2[0];

/* check first if there is a bond between atoms i and j */
         if(cbond_ij(i,j)) {
          PrintMessage("?WARNING - there is no bond between specified atoms ");
          return;}
/* remove bond i - j from the connectivity matrix */
          bbond_ij(i,j);

        sprintf(OutText,"Breaked bond between '%.4s:%.4s(%d):%.4s' and '%.4s:%.4s(%d):%.4s'",
        segment+4*i,resnam+4*i,res1[i],atnam+4*i,
        segment+4*j,resnam+4*j,res1[j],atnam+4*j);
        PrintMessage(OutText);
      }
      else
      PrintMessage("?ERROR - no atoms in the selection list 1 or 2");

      break;

      default:
               PrintMessage("?ERROR - you should not be here in edit_bond \n");
               return;
      }
        free(sel_list1);
        free(sel_list2);

        return;
}
/************************************************************************/
int cbond_ij(i,j)   /* check bond */
    int i; 
    int j;
/************************************************************************/
{
    static int k,l;

    l = cnct[i][0]; /* number of connections for atom i */
    for(k = 1 ; k <= l ; k++) 
       if(cnct[i][k] == j) return(0); /* yes there is a bond */
     
    return(1); /* no bond found */
}
/************************************************************************/
int bbond_ij(i,j)   /* break bond i - j */
/************************************************************************/
{

      static int k,l,n;

      l = cnct[i][0];

      for(k = 1 ; k <= l ; k++) {
         if(cnct[i][k] == j) { /* delete it */

           if(k == l) cnct[i][0]--;

           for(n = k ; n < l ; n++) { /* pop stack */
              cnct[i][n] = cnct[i][n+1];
              cnct[i][0]--;
         }
              goto next_loop;}
       }
              return(1); 

next_loop:;

      l = cnct[j][0];

      for(k = 1 ; k <= l ; k++) {
         if(cnct[j][k] == i) { /* delete it */

           if(k == l) cnct[j][0]--;

           for(n = k ; n < l ; n++) { /* pop stack */
              cnct[j][n] = cnct[j][n+1];
              cnct[j][0]--;
         }
              return(0);}
       }
              return(1); 
}

/************************************************************************/
EditSegmName(Seg,Res,Atm,text)
      char *Seg;
      char *Res;
      char *Atm;
      char *text;
/************************************************************************/
{
     extern int *ivector();
     extern int select_list();
     extern int numat;
     extern float *atm_charge;

     static int i,j;
     static char chelp[BUFF_LEN];
     static int ihelp,atom_max;
     static float fhelp;
     static int *sel_list;
     static int slong;
     static char OutText[BUFF_LEN];

     atom_max = atom_list_max();

     sel_list = ivector(atom_max);

     slong = select_list(Seg,Res,Atm,sel_list);

     if(slong > 0) {
     ihelp = 0;
     if(strlen(text) > 4) 
       PrintMessage("Truncating segment name to 4 characters");

        for(i = 0 ; i < slong ; i++) {
          PutSegName(text , i);
          ihelp++;}
        sprintf(OutText,"Changed segment name for %d atom(s)",ihelp);
        PrintMessage(OutText);
      }
      else
      PrintMessage("?ERROR - no atoms in the selection list");

        free(sel_list);
}
/************************************************************************/
EditResiName(Seg,Res,Atm,text)
      char *Seg;
      char *Res;
      char *Atm;
      char *text;
/************************************************************************/
{
     extern int *ivector();
     extern int select_list();
     extern int numat;

     static int i;
     static char chelp[BUFF_LEN];
     static int ihelp,atom_max;
     static float fhelp;
     static int *sel_list;
     static int slong;
     static char OutText[BUFF_LEN];

     atom_max = atom_list_max();

     sel_list = ivector(atom_max);

     slong = select_list(Seg,Res,Atm,sel_list);

     if(slong > 0) {
     ihelp = 0;
     if(strlen(text) > 4) 
       PrintMessage("Truncating residue name to 4 characters");


        for(i = 0 ; i < slong ; i++) {
          PutResName(text , i);
          ihelp++;}
        sprintf(OutText,"Changed residue name for %d atom(s)",ihelp);
        PrintMessage(OutText);
      }
      else
      PrintMessage("?ERROR - no atoms in the selection list");

        free(sel_list);
}
/************************************************************************/
EditAtomName(Seg,Res,Atm,text)
      char *Seg;
      char *Res;
      char *Atm;
      char *text;
/************************************************************************/
{
     extern int *ivector();
     extern int select_list();
     extern int numat;

     static int i;
     static char chelp[BUFF_LEN];
     static int ihelp,atom_max;
     static float fhelp;
     static int *sel_list;
     static int slong;
     static char OutText[BUFF_LEN];

     atom_max = atom_list_max();

     sel_list = ivector(atom_max);

     slong = select_list(Seg,Res,Atm,sel_list);

     if(slong > 0) {
     ihelp = 0;
     if(strlen(text) > 4) 
       PrintMessage("Truncating atom name to 4 characters");

        for(i = 0 ; i < slong ; i++) {
          PutAtmName(text , i);
          ihelp++;}
        sprintf(OutText,"Changed atom names for %d atom(s)",ihelp);
        PrintMessage(OutText);
      }
      else
      PrintMessage("?ERROR - no atoms in the selection list");

        free(sel_list);
}
/************************************************************************/
AddNewBond()
/************************************************************************/
{
     int BondList[MAXdlen];
     int BondListLong;
     char SEGnam1[MAX_SEG_NAME_LEN];
     char RESnam1[MAX_RES_NAME_LEN];
     char ATMnum1[BUFF_LEN];
     char SEGnam2[MAX_SEG_NAME_LEN];
     char RESnam2[MAX_RES_NAME_LEN];
     char ATMnum2[BUFF_LEN];

     BuildPairArray(&BondListLong , BondList);

     if(BondListLong == 2) {
         strncpy(SEGnam1,segment+4*BondList[0],MAX_SEG_NAME_LEN);
         strncpy(RESnam1,resnam+4*BondList[0], MAX_RES_NAME_LEN);
         sprintf(ATMnum1,"%d",BondList[0]+1);

         strncpy(SEGnam2,segment+4*BondList[1],MAX_SEG_NAME_LEN);
         strncpy(RESnam2,resnam+4*BondList[1], MAX_RES_NAME_LEN);
         sprintf(ATMnum2,"%d",BondList[1]+1);

     printf(" '%s' '%s' '%s' '%s '%s' '%s' \n",SEGnam1 , RESnam1 , ATMnum1 , SEGnam2 , RESnam2 , ATMnum2);
     edit_bond( 1 , SEGnam1 , RESnam1 , ATMnum1 , SEGnam2 , RESnam2 , ATMnum2);
      }
}
/************************************************************************/
DeleteOldBond()
/************************************************************************/
{
     int BondList[MAXdlen];
     int BondListLong;
     char SEGnam1[MAX_SEG_NAME_LEN];
     char RESnam1[MAX_RES_NAME_LEN];
     char ATMnum1[BUFF_LEN];
     char SEGnam2[MAX_SEG_NAME_LEN];
     char RESnam2[MAX_RES_NAME_LEN];
     char ATMnum2[BUFF_LEN];

     BuildPairArray(&BondListLong , BondList);

     if(BondListLong == 2) {
         strncpy(SEGnam1,segment+4*BondList[0],MAX_SEG_NAME_LEN);
         strncpy(RESnam1,resnam+4*BondList[0], MAX_RES_NAME_LEN);
         sprintf(ATMnum1,"%d",BondList[0] + 1);

         strncpy(SEGnam2,segment+4*BondList[1],MAX_SEG_NAME_LEN);
         strncpy(RESnam2,resnam+4*BondList[1], MAX_RES_NAME_LEN);
         sprintf(ATMnum2,"%d",BondList[1] + 1);

     edit_bond( 2 , SEGnam1 , RESnam1 , ATMnum1 , SEGnam2 , RESnam2 , ATMnum2);

      }
}



















