/*  

                       Copyright (c) 1990 and 1992 by:
        Leif Laaksonen , Centre for Scientific Computing, ESPOO, FINLAND
            Confidential unpublished property of Leif Laaksonen
                        All rights reserved
  

*/


#include <stdio.h>
#include <math.h>
#include <string.h>
#include <ctype.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/resource.h>
#include <sys/procfs.h>
#include <malloc.h>

#ifdef sgi
#include <gl/gl.h>
#include <device.h>
#endif

#include "maxdefs.h"
#include "ScareTypedefs.h"

#define MAX_FLOAT  1.e+35    /* This max float is just a guess */
#define MAX(a,b)  ((a) > (b) ? (a) : (b))
#define MIN(a,b)  ((a) < (b) ? (a) : (b))
#define Rabs(a)    ( ( a ) > 0   ? (a) : -(a))
#define Fabs(a)    ( ( a ) > 0.0 ? (a) : -(a))
#define SCALE(a,b,c)     scaleO(a,b,c) /* use own scale function */

/* define parameters for check of file (to function access()) */
#define FILE_READ     04
#define FILE_WRITE    02
#define FILE_EXECUTE  01
#define FILE_EXIST    00

#define FIX  1        /* 1 flexible , 0 is stiff */

#define DEFSSDIST2   4.5    /* default S-S search distance to power 2 */

#define STACKFILE    ".SCARESTACK"

#define LFKEY  1        /* function keys */
#define HFKEY 12

#define STRTOK(a,b) own_strtok(a,b)

    extern int numat;
    extern int **cnct;
    extern float *vdw_list;
    extern int yn_surf;
    extern char *surface_list;
    extern char *liquorice_list;
    extern void going_on();
    extern void tupper();
    extern void send_command();
    extern int RunStatistics();
    extern int indexo();
    extern int   *ivector();
    extern float *vector();
    extern char  *cvector();
    extern int atom_list_max();
    extern void stack_text();
    extern void file_info();
    extern int own_parser();
    extern void WriteToLogFile();
    extern int IsStereoON();
    extern void edit_bond(int,char *,char *,char *, char *,char *, char *);
    extern char *module_name;
    extern int current_struct;
    extern float *cpk_scale;
    extern int server_mode;
    extern int **atmcol;
    extern int selection_mode;
    extern char input_from_file[];
    extern int term_type;
    extern char *disp_list;
    extern int CurMaterial;
    extern char *own_strtok();
    extern char *bottom_line;
    extern float rotB[][4];
    extern float near,far;
    extern short val;
    extern char prompt[];
    extern int fake_now;
    extern int video_mode;
    extern short BLACKv[3],BLUEv[3],CYANv[3];
     extern float *x,*y,*z;
     extern float sumx,sumy,sumz;
     extern int numat;
      extern char *segment;
      extern char *resnam;
      extern char *atnam;
      extern char *label_list;

     extern char scr_data[];
     extern char home_path[];
     extern char scr_bin[];

     extern int  save_input_l;                   /* stack depth            */
     extern char save_input[MAX_SAVE][MAXlinel]; /* save commands in stack */

     extern char parsed[MAXparse][MAXlinel];
     extern int no_graphics_yet;
     extern int mlist_deep;      /* stack number indicator */
     extern int mlists[MAX_MLIST]; /* First index for molecule list */
     extern int mliste[MAX_MLIST]; /* Second index for molecule list */
     extern char mnlist[MAX_MLIST][BUFF_LEN]; 
                                /* name list for molecule file names */

/*  debug structure */

    extern prusage_t ProcessInfo;

    extern struct {
    int DebugL;} DebugS;

      extern struct  param_struct {
    int     type;
    float bndrad;
    float vdwrad;
    float plurad;
    char  global;
    float   emin;
    float   rmin;
    float   patom;
    float  mass;
    int    cnct;
    char   hbond;
    char   atype[4];} ;
    extern int param203_terms;              /* terms in the parameters list */
    extern struct param_struct param203[MAXatc];

/*  cell dimensions */
    extern struct cell_dim {
    float a;
    float b;
    float c;
    float alpha;
    float beta;
    float gamma;
    float Xtrans;
    float Ytrans;
    float Ztrans;};
    
    extern struct cell_dim cell;

    extern int  save_input_l;                   /* stack depth            */
    extern char save_input[MAX_SAVE][MAXlinel]; /* save commands in stack */


    char *atnam_stack;    /* stack to contain the different atnam, resnam */
    int   atnam_stack_deep=0;
    int   atnam_stack_max=100;
    int  *atnam_stack_num;
    char *resnam_stack;   /* and segment names */
    int   resnam_stack_deep=0; 
    int   resnam_stack_max=50;
    int  *resnam_stack_num;
    char *segment_stack;
    int   segment_stack_deep=0;
    int   segment_stack_max=30;

    int frame_count = 0;  /* frame counter at video recording */

/* define the CHARMm structure                          */
   extern struct CHARMm { /* Charmm structure */
     int numat;          /* number of atoms in this structure */
     int *res1;          /* residue number 1 list */
     int *res2;          /* residue number 2 list */
     char *resnam;       /* residue name list */
     char *atnam;        /* atom name list */
     char *segment;      /* segment name list */
     float *x;           /* x,y and z coordinates */
     float *y;
     float *z;
     float *bvalue;}      /* bvalue list */
                     *Charmm_struct;
   extern int NumCharmmStruct;  /* number of Charmm structures present */
/* end of CHARMm structure                           */

/* draw mode structure. Draw mode is on if != 0      */
     struct DrawMS {
      int NormalDraw;
      int OverDraw;
      int UnderDraw;
      int PupDraw;
      int CursosDraw;}
                        DrawMode = { 1 , 0 , 0 , 0 , 0};

 /*  external    */
      extern int numat;
      extern int *res1,*res2;
      extern int minres1,maxres1,minres2,maxres2;
      extern float *corad;
      extern float *x,*y,*z;
      extern float *bvalue;
      extern float near,far;
      extern float minx,maxx,miny,maxy,minz,maxz;
      extern int *atm_type;
      extern float *atm_charge;
      extern int covalent_rad();


     extern struct {  /* structure to hold the command for the Funct keys */
       char f1[BUFF_LEN];
       char f2[BUFF_LEN];
       char f3[BUFF_LEN];
       char f4[BUFF_LEN];
       char f5[BUFF_LEN];
       char f6[BUFF_LEN];
       char f7[BUFF_LEN];
       char f8[BUFF_LEN];
       char f9[BUFF_LEN];
       char f10[BUFF_LEN];
       char f11[BUFF_LEN];
       char f12[BUFF_LEN]; } FUNKEY;

    extern struct {                 
                    /* coordinate manipulation at read coordinates */
     int AtomCent;
           } CoordMani;

/* double/single buffer controller                          */
   extern struct {
   char Changed;       /* if > 0 mode has changed               */
   int BufferMode;     /* 1 = single buffer , 2 = double buffer */
   } DBuffer;

/*
      Scarecrow is using the following Projection Transformations

      0 => Scarecrow is using ortho
      1 =>                    perspective
*/
      extern struct Projection {
       int Fovy;           /* in tenths of degrees */
       int Transformation; } Model;

      struct {
      int zbuffer;      /* number of bitplanes in the zbuffer */
      int XPmax;        /* number of pixels in x */
      int YPmax;        /* number of pixels in y */
      int Blend;        /* 1 alpha blend possible , 0 not possible */
      char Info[BUFF_LEN]; /* Hardware and GL library version */
      } HW;

/* structure to contain info about start up window */
      struct {
         int X;             /* x - coordinate */
         int Y;             /* y - coordinate */
         int XW;            /* x - wide       */
         int YW;            /* y - wide       */
         int Set;           /* != 0 , window set */
                  } StartWindow = { 0 , 0 , 0 , 0 , 0};

       struct {
         float Angle;       /* rotation angle (in tenths of degrees)*/
         float Translate;   /* translation from the centre */
         int   Active;      /* == 0 off , != 0 on */
         int   Set;         /* == 0 reset , != do not reset */
                  } StereoPlot = { 30.0 , 0.0 , 0 , 0};

       struct {
         int Set;         /* =  0 , not set, != 0 set              */
         int FirstFrame;  /* first frame in trajectory to be displ */
         int LastFrame;   /* last          -"-                     */
         int StepFrame;   /* step to be used                       */
                  } TrajFrame = { 0 , 0 , 0 , 1};

       struct {
         int Saved;
         int Atoms;
         float *XCoord;
         float *YCoord;
         float *ZCoord;
               } SavedCoordinates = {0 , 0 , NULL , NULL , NULL};

       int CalcMolDimensions();
       int IsNumber();
       int SaveCoordinates();
       int DeleteOldSavedCoord();
       int GetSavedCoord();
       int CheckOldSelList(int Index , int Total , int *List);

/***********************************************************************/
 do_util()     /*  do some settings for the graphics part */
/***********************************************************************/
{

      char local[4];
      int retv,i;
      int from,to;
      float covrad;
      char OutText[BUFF_LEN];

      from = mlists[mlist_deep - 1];
      to   = mliste[mlist_deep - 1];

      if((to - from) < 1) return;  
                                                      /* no atoms */

      for(i = from ; i < to ; i++) {

/* set atom type to 0 */
      atm_type[i] = 0;
/* .................. */
/* set atom charge to 0.0 */
/*      atm_charge[i] = 0.0; */
/* ...................... */
/* set cpk scale to 1.    */
      cpk_scale[i] = 1.;
/* ...................... */
/* set display mode on    */
      disp_list[i] = 1;
/* ...................... */
/* set labels off         */
      label_list[i] = 0;

      strncpy(local,atnam+MAX_ATM_NAME_LEN*i,MAX_ATM_NAME_LEN);

      retv = covalent_rad(i,local,&covrad);

      if(retv > 0) {
      sprintf(OutText," There is something wrong with the atom nr: %d =>:%.4s:%.4s:%.4s:<= \n",
      i+1,segment+MAX_SEG_NAME_LEN*i,resnam+MAX_RES_NAME_LEN*i,
          atnam+MAX_ATM_NAME_LEN*i);
      PrintMessage(OutText);
      }

      corad[i] = covrad;

      }

       atom_conn(mlist_deep);

 /*   pre set colours  */

      i = current_struct;
       current_struct = mlist_deep - 1;
       set_colour(0);
      current_struct = i;

 /* don't do these things if a structure is appended (mlist_deep > 1)
    OR the FIX  switch is set */

 if(mlist_deep < 2 || FIX) {

       calc_mp(0);


    (void)CalcMolDimensions();

/*   calculate dipole moment  from partial charges */

/*     cal_moment();  */

     }
     else
         calc_mp(1);


 /*  Calculate the smallest/highest residue number of res1 and res2  */

     maxres1=0;
      maxres2=0;
     minres1=100000;
      minres2=100000;

      for(i = mlists[0] ; i < mliste[mlist_deep - 1] ; i++) {
      if(res1[i] > maxres1) maxres1 = res1[i];
      if(res1[i] < minres1) minres1 = res1[i];

      if(res2[i] > maxres2) maxres2 = res2[i];
      if(res2[i] < minres2) minres2 = res2[i]; }


     vdw_rad();  /* hook the van der Waals radius to the atoms */

}

#ifdef sgi

 /***********************************************************************/
 plot_cross(xpt,ypt,zpt)  /* plot a cross at xpt,ypt,zpt */

       float xpt,ypt,zpt;
 /***********************************************************************/
 {

    static float cross_len=0.2; /* size of the cross */
    static float vec[3];

    bgnline(); /* x - direction */
    vec[0] = xpt-cross_len;
     vec[1] = ypt;
      vec[2] = zpt;
    v3f(vec);
    vec[0] = xpt+cross_len;
    v3f(vec);
    endline();

    bgnline(); /* y - direction */
    vec[0] = xpt;
     vec[1] = ypt - cross_len;
      vec[2] = zpt;
    v3f(vec);
    vec[1] = ypt+cross_len;
    v3f(vec);
    endline();

    bgnline(); /* z - direction */
    vec[0] = xpt;
     vec[1] = ypt ;
      vec[2] = zpt - cross_len;
    v3f(vec);
    vec[2] = zpt+cross_len;
    v3f(vec);
    endline();
 }


/***********************************************************************/
pre_utility()   /* routine to handle the utility service */
/***********************************************************************/
{

       extern long menuval;
       extern long menuUtil;

       static long localval;

/* pop up utility menu */

       localval = dopup(menuUtil);

       if(localval < 0) return;

       switch(localval) {

       case 0: return;

       case 1: /* do 2d plotting */
               PrintMessage("\07Not yet working \n");
	       break;

       case 2: /* give structure information */
	       struct_info();
	       break;

       case 3: /* QM interface               */
	       input_gen("icon8");
	       break;

       default: PrintMessage("\07\07 ****** ERROR in pre_util \n");
		shut_down(1);
       }
}

/***********************************************************************/
struct_info()
/***********************************************************************/
{

       extern long menuUtilsi;
       extern int numat;
       extern int text_port;

       static long localval;
       static float lxmin,lxmax,lymin,lymax,lzmin,lzmax;

		int fromi;

       char text[BUFF_LEN];

 /* pop up structure information menu */

       localval = dopup(menuUtilsi);

       switch(localval) {

       case 0:  return;

       case 1:  /* find min and max for the x,y,z coordinates */
		find_coord_max(&lxmin,&lxmax,&lymin,&lymax,&lzmin,&lzmax);
		PrintMessage(" ");
		PrintMessage("Min and max values for the coordinates");
		sprintf(text,"Min x: %f",lxmin);
		PrintMessage(text);
		sprintf(text,"Max x: %f",lxmax);
		PrintMessage(text);
		sprintf(text,"Min y: %f",lymin);
		PrintMessage(text);
		sprintf(text,"Max y: %f",lymax);
		PrintMessage(text);
		sprintf(text,"Min z: %f",lzmin);
		PrintMessage(text);
		sprintf(text,"Max z: %f",lzmax);
		PrintMessage(text);
		text_port = 1;

		PrintMessage("Min and max values for the coordinates\n");
		sprintf(text,"Min x: %f\n",lxmin);
                 PrintMessage(text);
		sprintf(text,"Max x: %f\n",lxmax);
                 PrintMessage(text);
		sprintf(text,"Min y: %f\n",lymin);
                 PrintMessage(text);
		sprintf(text,"Max y: %f\n",lymax);
                 PrintMessage(text);
		sprintf(text,"Min z: %f\n",lzmin);
                 PrintMessage(text);
		sprintf(text,"Max z: %f\n",lzmax);
                 PrintMessage(text);

		break;

       case 2:  /* calculate radial distribution function */

                PrintMessage("?ERROR - NOT WORKIN ");
                break;


       default: printf("\07\07 ****** ERROR in struct_info \n");
		shut_down(1);
       }

 }

#endif

 /***********************************************************************/
 find_coord_max(lxmin,lxmax,lymin,lymax,lzmin,lzmax)

     float *lxmin,*lxmax,*lymin,*lymax,*lzmin,*lzmax;
 /***********************************************************************/
 {


     static int i;

     *lxmin = *lymin = *lzmin =  1.e+30;
     *lxmax = *lymax = *lzmax = -1.e+30;

     for(i = mlists[current_struct] ; i < mliste[current_struct] ; i++) {

      *lxmin = MIN(*lxmin,x[i]);
      *lymin = MIN(*lymin,y[i]);
      *lzmin = MIN(*lzmin,z[i]); 
      *lxmax = MAX(*lxmax,x[i]);
      *lymax = MAX(*lymax,y[i]);
      *lzmax = MAX(*lzmax,z[i]); 
     }

}
/***********************************************************************/
int det_term()  /* determine terminal type */
/***********************************************************************/
{

   extern char which_term[BUFF_LEN];
   extern int yes_no_graph;

   char *getenv();

   if(server_mode) {
   printf("     Program running now in server mode \n");
   yes_no_graph = 0;
   return(5);}

   strcpy(which_term , getenv("TERM"));

   if(which_term[0] != '\0') {
      printf("    Terminal is now defined as: %s\n",which_term);

   if(indexo(which_term,"iris") == 1) { /* iris system */
   yes_no_graph = 1; /* graphics is possible */
   return(1);}

   if(indexo(which_term,"vt100") == 1) { /* vt100 terminal */
    yes_no_graph = 0; /* graphics is not possible */
     if(input_from_file[0] != '\0')  { /* input comes from file */
       return(4);}
   return(2);}

   printf("**** Unknown terminal type : %s\n",which_term);
   return(0);

    }
   else 
   printf("**** Unknown terminal type \n");

   return(0);

} 
/***********************************************************************/
sign_char(input)   /* look for significant characters */

     char *input;       /* The input string can contain following characters:
			   ? and * where "?" means that the position can be
			   any character and "*" which means that the rest
			   of the string can be any characters.
			   The input string is max MAX_SEG_NAME_LEN
                            characters   */
/***********************************************************************/
 {

      register int i;
      register int ast;
      register int qmk;
      register int ast_pos;
      register char mask;
      static   int slong;

      /* check first if there are any "*" and "?" in the string */

      ast  =   0;
      qmk  =   0;
      mask = 255;

      slong = strlen(input); /* input string is 'long' characters long */
      if(slong > MAX_SEG_NAME_LEN) slong = MAX_SEG_NAME_LEN;

      for(i = 0 ; i < slong ; i++) {
	if(input[i] == '*') ast++;
	if(input[i] == '?') qmk++;
      }
      if(slong < MAX_SEG_NAME_LEN) {
      for(i = slong ; i < MAX_SEG_NAME_LEN ; i++) input[i] = ' ';
       slong = MAX_SEG_NAME_LEN;}

      if(ast == 0 && qmk == 0) return;

	 if(ast) { /* interpret the "*" */
	       for(i = 0 ; i < slong ; i++ ) if(input[i] == '*') break;
	 }

	 ast_pos = i; 
         input[i] = mask;
         if(slong-(i+1)) {
	   for(i = (ast_pos+1) ; i < slong ; i++)  {

              if(!isalnum(input[i])) input[i] = mask;}

         }

	 if(qmk == 0) return;

	 if(qmk) { /* interpret the "?" */

	       for(i = 0 ; i < slong ; i++) {
		  if(input[i] == '?') input[i] = mask;
	       }
	 }

 }
 /*************************************************************************/
 build_name_stack(alt)   /* build the atnam, resnam and segment stacks */

      int alt;
 /*************************************************************************/
 {
      extern int numat;
      extern char *atnam;
      extern char *resnam;
      extern char *segment;
      extern int  *res1;
      int i;
      char temp[4];

      if(mliste[0] < 1 ) {
      printf("?ERROR - can't build name stacks because no atoms defined \n");
      return;}

      switch(alt) {

      case 1:
 /* first atom name stack */
      atnam_stack_deep = 0;
      for(i = 0 ; i < atnam_stack_max ; i++) atnam_stack_num[i] = 0;

      for(i = 0 ; i < mliste[0] ; i++) {
	 strncpy(temp,atnam+MAX_ATM_NAME_LEN*i,MAX_ATM_NAME_LEN);
	   if(isdigit(temp[3])) temp[3] = '\0';
	   if(isdigit(temp[2])) temp[2] = '\0';
	   if(isdigit(temp[1])) temp[1] = '\0';
	 if(atnam_stack_deep == 0) {
	   strncpy(atnam_stack,temp,MAX_ATM_NAME_LEN);
 /* delete the number in the name */
	   atnam_stack_deep++;
	   continue;
	 }
 /* check the stack if the name is there already if not place it there */
      check_name_stack(1,temp);
      }
	break;

      case 2:
 /* then residue name stack */
      resnam_stack_deep = 0; /* there always has to be at least one residue */
      for(i = 0 ; i < resnam_stack_max ; i++) resnam_stack_num[i] = 0;

      for(i = 0 ; i < mliste[0] ; i++) {

      if(i > 0 ) {
	if(res1[i] == res1[i-1]) continue;
      }
	 strncpy(temp,resnam+MAX_RES_NAME_LEN*i,MAX_RES_NAME_LEN);

	 if(resnam_stack_deep == 0) {
	   strncpy(resnam_stack,temp,MAX_RES_NAME_LEN);
           resnam_stack_num[0] = 1;
	   resnam_stack_deep++;
	   continue;
	 }
 /* check the stack if the name is there already if not place it there */
      check_name_stack(2,temp);
      }
	 break;

	 case 3:
 /* then segment name stack */
      segment_stack_deep = 0;

      for(i = 0 ; i < mliste[0] ; i++) {
	      strncpy(temp,segment+MAX_SEG_NAME_LEN*i,MAX_SEG_NAME_LEN);
	 if(segment_stack_deep == 0) {
	   strncpy(segment_stack,temp,MAX_SEG_NAME_LEN);
	   segment_stack_deep++;
	   continue;
	 }
 /* check the stack if the name is there already if not place it there */
      check_name_stack(3,temp);
      }
	 break;
    }
 }

 /*************************************************************************/
 check_name_stack(alt,temp)

       int alt;
       char *temp;
 /*************************************************************************/
 {
       extern char *atnam;

       int i;

       switch(alt) {

       case 1:
       for(i = 0 ; i < atnam_stack_deep ; i++ ) {
	if(strncmp(atnam_stack+MAX_ATM_NAME_LEN*i,temp,MAX_ATM_NAME_LEN) == 0) {
	 atnam_stack_num[i]++; /* increment counter */
	 return; /* yes it is in the stack */
       }
       }
 /* no it is not so put it there */
       strncpy(atnam_stack+MAX_ATM_NAME_LEN*atnam_stack_deep,temp,
                           MAX_ATM_NAME_LEN);
       atnam_stack_num[atnam_stack_deep] = 1;
     if(atnam_stack_deep == atnam_stack_max) {
      atnam_stack_max = atnam_stack_max + 50;
      atnam_stack = (char *) realloc((char *) atnam_stack, 
                             atnam_stack_max * MAX_ATM_NAME_LEN);
     }
       atnam_stack_deep++;
       break;

	case 2:
       for(i = 0 ; i < resnam_stack_deep ; i++ ) {
	if(strncmp(resnam_stack+MAX_RES_NAME_LEN*i,temp,MAX_RES_NAME_LEN) == 0) {
	 resnam_stack_num[i]++;
	 return; /* yes it is in the stack */
	}
       }
 /* no it is not so put it there */
       strncpy(resnam_stack+MAX_RES_NAME_LEN*resnam_stack_deep,temp,
                            MAX_RES_NAME_LEN);
       resnam_stack_num[resnam_stack_deep] = 1;
     if(resnam_stack_deep == resnam_stack_max) {
      resnam_stack_max = resnam_stack_max + 50;
      resnam_stack = (char *) realloc((char *) resnam_stack, 
                              resnam_stack_max * MAX_RES_NAME_LEN);
     }
       resnam_stack_deep++;
       break;

       case 3:
       for(i = 0 ; i < segment_stack_deep ; i++ ) {
	if(strncmp(segment_stack+MAX_SEG_NAME_LEN*i,temp,MAX_SEG_NAME_LEN) == 0) {
	 return; /* yes it is in the stack */
	}
       }
 /* no it is not so put it there */
       strncpy(segment_stack+MAX_SEG_NAME_LEN*segment_stack_deep,temp,
                             MAX_SEG_NAME_LEN);
     if(segment_stack_deep == segment_stack_max) {
      segment_stack_max = segment_stack_max + 30;
      segment_stack = (char *) realloc((char *) segment_stack, 
                               segment_stack_max * MAX_SEG_NAME_LEN);
     }
       segment_stack_deep++;
       break;
     }
 }

 /***********************************************************************/
 char_to_int(string,num) /* character to integer print */
      char *string;
      int num;
 /***********************************************************************/
 {
     static int i;
     static line=60;

     for(i = 0 ; i < num ; i++) {
     printf(">%d<",string[i]);
     if(((i/line)*line - i) == 0 && i > 0) printf("\n");}

     printf("\n");
 }





 /***********************************************************************/
 and_oper(input1,input2,output)
       char *input1;
       char *input2;
       char *output;
 /***********************************************************************/
 {
	   output[0] = input1[0] & input2[0];
	   output[1] = input1[1] & input2[1];
	   output[2] = input1[2] & input2[2];
	   output[3] = input1[3] & input2[3];

 }

 /***********************************************************************/
 int comp_str(input1,input2)
       char *input1;
       char *input2;
 /***********************************************************************/
 {
       register  int i;
       register  char mask;

       mask = 255;

       for(i = 0 ; i < MAX_RES_NAME_LEN ; i++)  {
	if(input1[i] == mask || input2[i] == mask) continue;
	if(input1[i] != input2[i]) return(0);
       }
       return(1);
 }
/***********************************************************************/
pre_rainbow(hh,rr,gg,bb)
      double hh;
      int *rr;
      int *gg;
      int *bb;
/***********************************************************************/
{
     static double r,g,b,s=1.0,v=1.0;

/* truncate it to inside interval 0 ... 1 and reverse the colouring */

     if(hh > 1.0) hh = 1.0;
     if(hh < 0.0) hh = 0.0;

     hh = 1. - hh;   /* it's now from blue to red ... */

     rainbow(hh,s,v,&r,&g,&b);

     *rr = floor(r*255.999);
     *gg = floor(g*255.999);
     *bb = floor(b*255.999);
}     

/*   rainbow(h, s, v, r, g, b)
     double h, s, v, *r, *g, *b;
 
 This routine computes colors suitable for use in color level plots.
 Typically s=v=1 and h varies from 0 (red) to 1 (blue) in
 equally spaced steps.  (h=.5 gives green; 1<h<1.5 gives magenta.)
 To convert for frame buffer, use   R = floor(255.999*pow(*r,1/gamma))  etc.
 To get tables calibrated for other devices or to report complaints,
 contact  Eric Grosse   research!ehg    201-582-5828.
*/

double huettab[] = {
 0.0000, 0.0062, 0.0130, 0.0202, 0.0280, 0.0365, 0.0457, 0.0559, 0.0671, 0.0796,
 0.0936, 0.1095, 0.1275, 0.1482, 0.1806, 0.2113, 0.2393, 0.2652, 0.2892, 0.3119,
 0.3333, 0.3556, 0.3815, 0.4129, 0.4526, 0.5060, 0.5296, 0.5501, 0.5679, 0.5834,
 0.5970, 0.6088, 0.6191, 0.6281, 0.6361, 0.6430, 0.6490, 0.6544, 0.6590, 0.6631,
 0.6667, 0.6713, 0.6763, 0.6815, 0.6873, 0.6937, 0.7009, 0.7092, 0.7190, 0.7308,
 0.7452, 0.7631, 0.7856, 0.8142, 0.8621, 0.9029, 0.9344, 0.9580, 0.9755, 0.9889,
 1.0000
 };
  /* computed from the FMC-1 color difference formula */
  /* Barco monitor, max(r,g,b)=1, n=61 magenta,  2 Jan 1986 */
 
rainbow(h, s, v, r, g, b)
double h, s, v, *r, *g, *b;
{
  int i;
  double  trash;
  h = 60*modf(h/1.5,&trash);
  i = floor(h);
  h = huettab[i] + (huettab[i+1]-huettab[i])*(h-i);
  dhsv2rgb(h,s,v,r,g,b);
}
 
dhsv2rgb(h, s, v, r, g, b)    /*...hexcone model...*/
double h, s, v, *r, *g, *b;    /* all variables in range [0,1] */
  /* here, h=.667 gives blue, h=0 or 1 gives red. */
{  /* see Alvy Ray Smith, Color Gamut Transform Pairs, SIGGRAPH '78 */
  int i;
  double f, m, n, k;
  double  trash;
  h = 6*modf(h,&trash);
  i = floor(h);
  f = h-i;
  m = (1-s);
  n = (1-s*f);
  k = (1-(s*(1-f)));
  switch(i){
    case 0: *r=1; *g=k; *b=m; break;
    case 1: *r=n; *g=1; *b=m; break;
    case 2: *r=m; *g=1; *b=k; break;
    case 3: *r=m; *g=n; *b=1; break;
    case 4: *r=k; *g=m; *b=1; break;
    case 5: *r=1; *g=m; *b=n; break;
    default: fprintf(stderr,"bad i: %f %d",h,i); exit(1);
  }
  f = *r;
  if( f < *g ) f = *g;
  if( f < *b ) f = *b;
  f = v / f;
  *r *= f;
  *g *= f;
  *b *= f;
}

/***********************************************************************/
float find_mass(alt)  /* find mass from the atom type 'alt' */
      int alt;
/***********************************************************************/
{

       extern int numat;
       char OutText[BUFF_LEN];

       int i;

       for(i = 0 ; i < param203_terms ; i++) {
         if(param203[i].type == alt) {
            return(param203[i].mass);}
       }
       sprintf(OutText,"?ERROR - undefined atom type: %d (in mass)",alt);
       PrintMessage(OutText);
       return(0.0);
}

/***********************************************************************/
int find_cnct(alt)  /* find atom connection for atom type 'alt' */
      int alt;
/***********************************************************************/
{

       extern int numat;
       char OutText[BUFF_LEN];

       int i;

       for(i = 0 ; i < param203_terms ; i++ ) {

          if(param203[i].type == alt) {
          return(param203[i].cnct);}
	}

       sprintf(OutText,"?ERROR - undefined atom type: %d (in connection)",alt);
       PrintMessage(OutText);
       return(-1);
}
/************************************************************************/
float find_vdwrad(alt) /* find the vdw radius fore atom type alt */
      int alt;                
/************************************************************************/
{

    extern int param203_terms;              /* terms in the parameters list */
    char OutText[BUFF_LEN];

    int i;

       for(i = 0 ; i < param203_terms ; i++ ) {

          if(param203[i].type == alt) {
          return(param203[i].vdwrad);}
	}

    sprintf(OutText,"?ERROR - undefined atom type <%d> (in vdW rad)",alt);
    PrintMessage(OutText);
    return(0.0);
}

/************************************************************************/
char *find_atype(alt) /* find the atom ascii atom type */
      int alt;                
/************************************************************************/
{

    extern int param203_terms;              /* terms in the parameters list */
    char OutText[BUFF_LEN];

    int i;

       for(i = 0 ; i < param203_terms ; i++ ) {

          if(param203[i].type == alt) {
          return(param203[i].atype);}

	}

    sprintf(OutText,"?ERROR - undefined atom type <%d> (in atom type)",alt);
    PrintMessage(OutText);
    return((char *)0);
}

/************************************************************************/
select_round(pindex,sel_list,sel_list_long,rad,swtch,Rappend,crgb,color_def)
      int pindex;  /* index to the select list (sel_list) */
      int *sel_list; /* selection list */
      int sel_list_long; /* length of selection list */
      float rad; /* radius for the search                   */
      int swtch;/* = 0 do not append to the list, > 0 append to the list */
      int Rappend; /* true append (global)   */
      int crgb[]; /* rgb color to be used if the colouring is on */
      int color_def; /* colouring switch  = 0 off , = 1 , on */
/************************************************************************/
{
  extern int numat;
  extern int maxres1;
  extern int minres1;
  extern float *x,*y,*z;
  extern char *disp_list;

  static int *disp_res;
  static int i,j;
  static int disp_atoms = 0;
  static float xf,yf,zf,rad2;
  static int resij,from,atom_max;
  static char Res1[MAX_SEG_NAME_LEN];
  static char Res2[MAX_RES_NAME_LEN];
  static char OutText[BUFF_LEN];

  atom_max = atom_list_max();

  disp_res      = ivector(atom_max);

  from = sel_list[pindex];

  xf = x[from];
   yf = y[from];
    zf = z[from];
     rad2 = rad*rad;


  for(i = mlists[0] ; i < mliste[mlist_deep - 1] ; i++) 
              disp_res[i] = 0;   /* first all off ... */

  for(i = 0 ; i < sel_list_long ; i++) 
              disp_res[sel_list[i]] = 2; /* atoms in main list */


  for( i = mlists[0] ; i < mliste[mlist_deep - 1] ; i++) {

/* don't include atoms already selected */

   if(disp_res[i]) continue;              /* first level     */

     if(!swtch) disp_list[i]=0;            /* append or no !? */

   if(!Rappend && disp_list[i]) continue;  /* second level    */

   resij = res1[i];
   strncpy(Res1,segment+MAX_SEG_NAME_LEN*i,MAX_SEG_NAME_LEN);
   strncpy(Res2,resnam +MAX_RES_NAME_LEN*i,MAX_RES_NAME_LEN);

    if(   ( (x[i]-xf)*(x[i]-xf) 
          + (y[i]-yf)*(y[i]-yf)
          + (z[i]-zf)*(z[i]-zf))  < rad2 ) {

/* check the selection mode */
  if(selection_mode == 0) {
    for(j = mlists[0] ; j < mliste[mlist_deep - 1] ; j++) {
       if((!strncmp(Res1,segment+MAX_SEG_NAME_LEN*j,MAX_SEG_NAME_LEN)) && 
          (!strncmp(Res2,resnam +MAX_RES_NAME_LEN*j,MAX_RES_NAME_LEN)) &&
            (res1[j] == resij)) disp_res[j] = 1;}
  }
  else 
       disp_res[i] = 1;
  } }
  disp_atoms = 0;
  for(j=mlists[0] ; j < mliste[mlist_deep - 1]      ; j++) {

      if(disp_res[j]) {
          disp_list[j] = 1;

          if(color_def > 0 && disp_res[j] < 2) {
            atmcol[j][0] = crgb[0];
            atmcol[j][1] = crgb[1];
            atmcol[j][2] = crgb[2];}

          disp_atoms++;}
    }
  free(disp_res);

   if(DebugS.DebugL > 0) {
    sprintf(OutText,"Number of atoms in display list is : %d",disp_atoms);
     PrintMessage(OutText);}

   return;
}

/************************************************************************/
select_round_xyz(xc,yc,zc,rad,swtch,crgb,color_def)
      float xc,yc,zc; /* center for the search */
      float rad; /* radius for the search                   */
      int swtch;/* = 0 do not append to the list, > 0 append to the list */
      int crgb[]; /* colour code to be used */
      int color_def; /* colouring switch = 0 , off , = 1 on */
/************************************************************************/
{
  extern int numat;
  extern int maxres1;
  extern int minres1;
  extern float *x,*y,*z;
  extern char *disp_list;
  extern int *ivector();

  static int res_arr,*disp_res,disp_point;
  static int yes_list,i,j,resij,atom_max;
  static int disp_atoms = 0;
  static float rad2;
  static char Res1[MAX_SEG_NAME_LEN];
  static char Res2[MAX_RES_NAME_LEN];
  static char OutText[BUFF_LEN];

  atom_max = atom_list_max();

  res_arr = maxres1 - minres1 +1;
  disp_res      = ivector(atom_max);
  disp_point = 0;
  rad2 = rad*rad;

  for(i = 0 ; i < mliste[mlist_deep - 1] ; i++) disp_res[i] = 0;

  for( i = mlists[0] ; i < mliste[mlist_deep - 1] ; i++) {

   if(swtch == 0) disp_list[i]=0;

/* don't include atoms already selected */
  if((disp_list[i]) || (disp_res[i])) continue;

   resij = res1[i];
   strncpy(Res1,segment+MAX_SEG_NAME_LEN*i,MAX_SEG_NAME_LEN);
   strncpy(Res2,resnam +MAX_RES_NAME_LEN*i,MAX_RES_NAME_LEN);

    if(   ( (x[i]-xc)*(x[i]-xc) 
          + (y[i]-yc)*(y[i]-yc)
          + (z[i]-zc)*(z[i]-zc))  < rad2 ) {
/* check the selection mode */
  if(selection_mode == 0) {
    for(j = mlists[0] ; j < mliste[mlist_deep - 1] ; j++) {
       if((!strncmp(Res1,segment+MAX_SEG_NAME_LEN*j,MAX_SEG_NAME_LEN)) && 
          (!strncmp(Res2,resnam +MAX_RES_NAME_LEN*j,MAX_RES_NAME_LEN)) &&
            (res1[j] == resij)) disp_res[j] = 1;}
  }
  else 
       disp_res[i] = 1;
  } }
  disp_atoms = 0;
  for(j=mlists[0] ; j < mliste[mlist_deep - 1]      ; j++) {

      if(disp_res[j] == 1) {
          disp_list[j] = 1;
          if(color_def > 0 ) {
            atmcol[j][0] = crgb[0];
            atmcol[j][1] = crgb[1];
            atmcol[j][2] = crgb[2];}
          disp_atoms++;}
   }
  free(disp_res);

   if(DebugS.DebugL > 0) {
    sprintf(OutText,"Number of atoms in display list is : %d",disp_atoms);
     PrintMessage(OutText);}

   return;
}

/************************************************************************/
get_env()   /* go and hunt for environment parameters */
/************************************************************************/
{
     char *getenv(),*envp;
     char OutText[BUFF_LEN];

     envp = getenv("SCR_DATA");
     if(envp == NULL) { /* sorry data directory not defined */
       if(scr_data[0] == '\0') {  
                         /* check that it is not imported from startup */
       PrintMessage("?ERROR - path to data directory not defined");
       shut_down(1);}}

     if(envp != NULL)
        strncpy(scr_data,envp,BUFF_LEN);
     sprintf(OutText,"    Data path: %s ",scr_data);
     PrintMessage(OutText);

     envp = getenv("SCR_BIN");
     if(envp == NULL) { /* sorry bin directory not defined */
       if(scr_bin[0] == '\0') { 
                        /* check that it is not imported from startup */
       PrintMessage("?ERROR - path to bin directory not defined");
       shut_down(1);}}

     if(envp != NULL)
        strcpy(scr_bin,envp);
     sprintf(OutText,"    Bin path:  %s ",scr_bin);
     PrintMessage(OutText);

     envp = getenv("HOME");
     if(envp == NULL) {
      PrintMessage("?WARNING - home path not defined");
       home_path[0] = '\0';}
     else {
      strcpy(home_path,envp);
       sprintf(OutText,"    Home path: %s ",home_path);
        PrintMessage(OutText);}
}
/************************************************************************/
get_date(alt)        /* get and print date and time */
/************************************************************************/
{
    char *date_time;
    time_t t;
    float secs,secs1;
    char this_host[BUFF_LEN];
    char OutText[BUFF_LEN];

    secs = 0.0;
     secs1 = 0.0;

    time(&t);
    if(t == -1) {
    PrintMessage("?ERROR - can't get the time ");
    return;}

    date_time = ctime(&t);

    gethostname(this_host,sizeof(this_host));

    if(RunStatistics() == -1) {
     PrintMessage("?ERROR - can't get information about resource utilization");
      }

    switch(alt) {

    case 1:  /* print date and time at start */
    sprintf(OutText,"    ****** Starting on host '%s' on %s ",this_host,date_time);
    PrintMessage(OutText);
    break;

    case 2: /* print date and time at the end */
    get_cpu_secs(&secs , &secs1);
    sprintf(OutText,"    ****** Exit on host '%s' on %s ",this_host,date_time);
    PrintMessage(OutText);
    sprintf(OutText,"   Wasted cpu secs: %.2f (Child: %.2f secs)",secs,secs1);
    PrintMessage(OutText);
    get_wall_secs(&secs1);
    sprintf(OutText,"   In %.3f hours of wall clock time (%.3f%c)\n",
           secs1/3600.,(secs/secs1)*100.,'%');
    PrintMessage(OutText);
    (void) InformIObytes();

    break;    
 
    case 3: /* print general date and time */
    sprintf(OutText,"    ****** Host  '%s' on %s",this_host,date_time);
    PrintMessage(OutText);
    break; 

  }
}
/************************************************************************/
calc_cmass()    /* calculate centre of mass */
/************************************************************************/
{
     extern int *ivector();
     extern int numat;
     extern float *x,*y,*z;
     extern float find_mass();
     extern int *atm_type;
     extern int select_list();

     static int i,si;
     static int *sel_list;
     static int slong;
     static int ihelp,atom_max;
     static float mass1[3],mass2,mass3;
     static char OutText[BUFF_LEN];
     
   atom_max = atom_list_max();
   sel_list = ivector(atom_max);

   sprintf(OutText,"Centre of mass (x, y and z) calculated from selection list : >%.4s<>%.4s<>%.4s<",parsed[2],parsed[3],parsed[4]);
   PrintMessage(OutText);

   slong = select_list(parsed[2],parsed[3],parsed[4],sel_list);

   if(slong > 0) {
   ihelp = 0;
   mass1[0] = mass1[1] = mass1[2] = 0.0;
   mass2 = 0.0;

        for(i = 0 ; i < slong ; i++) {
        si = sel_list[i];

/* now bang it together  .... */
          ihelp++;
          mass3 = find_mass(atm_type[si]);
          mass1[0] += mass3*x[si];
           mass1[1] += mass3*y[si];
            mass1[2] += mass3*z[si];
          mass2 +=mass3;}

         if(mass2 < 0.01) {
         PrintMessage("?ERROR - atomic masses are not defined or set ");
         return;}

         mass1[0] /= mass2;
         mass1[1] /= mass2;
         mass1[2] /= mass2;

         sprintf(OutText," %f  %f  %f ",mass1[0]+sumx,mass1[1]+sumy,mass1[2]+sumz);
         PrintMessage(OutText);
         printf("Total mass is: %f for %d atoms \n",mass2,ihelp);
         }
         else
         PrintMessage("?ERROR - no atoms in the selection list");

         free(sel_list);
}

/************************************************************************/
calc_ccentre()    /* calculate coordinate centre */
/************************************************************************/
{
     extern int *ivector();
     extern int numat;
     extern float *x,*y,*z;
     extern int *atm_type;
     extern int select_list();

     static int i,si;
     static int *sel_list;
     static int slong;
     static int ihelp,atom_max;
     static float mass1[3],mass2,mass3;
     static char OutText[BUFF_LEN];
     
   atom_max = atom_list_max();
   sel_list = ivector(atom_max);

   sprintf(OutText,"Coordinate Centre (x, y and z) calculated from selection list : >%.4s<>%.4s<>%.4s<",parsed[2],parsed[3],parsed[4]);
   PrintMessage(OutText);

   slong = select_list(parsed[2],parsed[3],parsed[4],sel_list);

   if(slong > 0) {
   ihelp = 0;
   mass1[0] = mass1[1] = mass1[2] = 0.0;

        for(i = 0 ; i < slong ; i++) {
        si = sel_list[i];

/* now bang it together  .... */
          ihelp++;

          mass1[0] += x[si];
           mass1[1] += y[si];
            mass1[2] += z[si];}

         mass1[0] /= (float)slong;
         mass1[1] /= (float)slong;
         mass1[2] /= (float)slong;

         sprintf(OutText," %f  %f  %f ",mass1[0]+sumx,mass1[1]+sumy,mass1[2]+sumz);
         PrintMessage(OutText);
         }
         else
         PrintMessage("?ERROR - no atoms in the selection list");

         free(sel_list);
}

#ifdef sgi

/************************************************************************/
plot_sphere(xc,yc,zc,rad,bf)   /* plot a spehere with radius rad at x,y,z  */
    float xc;
    float yc;
    float zc;
    float rad;
    float bf;  /* blending factor */
/************************************************************************/
{

   int i,j,nn;

   extern float vsphe[][3],vspher[][3];
   extern int sphere_array[Sphere_max];
   extern int sphere_seg;
   extern short obcolor[3];
   extern float light1[];

   register int ii,im1,jj;
   register float div_rad;
   static float n0[3],param[4];
   static float mat_col[] = { DIFFUSE , 
                              1.0 , 1.0 , 1.0 , 
                              LMNULL 
                              }; 

#ifdef FAST

   param[0] = xc;
    param[1] = yc;
     param[2] = zc;
      param[3] = rad;

   frontbuffer(TRUE);
   i = sphdraw(param);
   frontbuffer(FALSE);
   if(i < 0) {
     PrintMessage("?ERROR - error in sphdraw ");
     return;}

#else

   nn = sphere_seg;
/*
   msave = material[9];

     material[9] = bf;
*/
     blendfunction(BF_SA, BF_ONE);

   mat_col[1] = ((float) obcolor[0] / 255.0);
   mat_col[2] = ((float) obcolor[1] / 255.0);
   mat_col[3] = ((float) obcolor[2] / 255.0);


     lmdef(DEFMATERIAL, CurMaterial, 0 , mat_col);  
/*
     lmbind(MATERIAL, 1);
*/
   build_sphere( nn , rad);

   div_rad = 1.0 / rad;

   frontbuffer(TRUE);
   for(i = 1 ; i < nn ; i++) {

    ii = sphere_array[i];
     im1 = sphere_array[i-1];

    for(j = 1 ; j <= 2*nn ; j++) {

    jj = j+im1-1;
    vspher[0][0]=xc+vsphe[jj][0];
    vspher[0][1]=yc+vsphe[jj][1];
    vspher[0][2]=zc+vsphe[jj][2];

    ++jj;
    vspher[1][0]=xc+vsphe[jj][0];
    vspher[1][1]=yc+vsphe[jj][1];
    vspher[1][2]=zc+vsphe[jj][2];

    jj = j+ii;
    vspher[2][0]=xc+vsphe[jj][0];
    vspher[2][1]=yc+vsphe[jj][1];
    vspher[2][2]=zc+vsphe[jj][2];

    --jj;
    vspher[3][0]=xc+vsphe[jj][0];
    vspher[3][1]=yc+vsphe[jj][1];
    vspher[3][2]=zc+vsphe[jj][2];

    bgnpolygon();
    jj = j+im1-1;
    n0[0]=vsphe[jj][0] * div_rad;
    n0[1]=vsphe[jj][1] * div_rad;
    n0[2]=vsphe[jj][2] * div_rad;

    n3f(n0); v3f(vspher[0]);
    ++jj;
    n0[0]=vsphe[jj][0] * div_rad;
    n0[1]=vsphe[jj][1] * div_rad;
    n0[2]=vsphe[jj][2] * div_rad;

    n3f(n0); v3f(vspher[1]);
    jj = j+ii;
    n0[0]=vsphe[jj][0] * div_rad;
    n0[1]=vsphe[jj][1] * div_rad;
    n0[2]=vsphe[jj][2] * div_rad;

    n3f(n0); v3f(vspher[2]);
    --jj;
    n0[0]=vsphe[jj][0] * div_rad;
    n0[1]=vsphe[jj][1] * div_rad;
    n0[2]=vsphe[jj][2] * div_rad;

    n3f(n0); v3f(vspher[3]);
    endpolygon();  }} 

     blendfunction(BF_ONE, BF_ZERO);

     frontbuffer(FALSE);

#endif

}  

#endif

/***********************************************************************/
vecsub(vec , sub , n)   

      float *vec;
      float sub;
      int     n;
/***********************************************************************/
{

      static int i;

      for(i = 0 ; i < n ; i++) vec[i] -= sub;

}


/***********************************************************************/
float fmaxi(vec , n) /* Find maximum floating point value in array vec */

      float *vec;
      int     n;
/***********************************************************************/
{

      static int i;
      static float flmax;

      flmax = -MAX_FLOAT;

      for(i = 0 ; i < n ; i++) {

         if(vec[i] > flmax) flmax = vec[i];
       }

      if(Rabs((flmax+MAX_FLOAT)) < 0.001) {
      printf("?WARNING - fmaxi routine is returning : %f \n",flmax);
      }
      return(flmax);
}


/***********************************************************************/
float fmini(vec , n) /* Find minimum floating point value in array vec */

      float *vec;
      int     n;
/***********************************************************************/
{

      static int i;
      static float flmin;

      flmin = MAX_FLOAT;

      for(i = 0 ; i < n ; i++) {

         if(vec[i] < flmin) flmin = vec[i];
       }

      if(Rabs((flmin-MAX_FLOAT)) < 0.001) {
      printf("?WARNING - fmini routine is returning : %f \n",flmin);
      }
      return(flmin);
}



/***********************************************************************/
void print_names(atom)  /* print segment, residue and atom names for atom
                      number 'atom' */
       int atom;
/***********************************************************************/
{
      extern char *atnam;
      extern char *resnam;
      extern char *segment;
      extern int  *res1;
      extern int numat;

      if(mliste[0] == 0) {
      PrintMessage("?ERROR - no atoms defined ");
      return;}

      if(atom < 0 || atom >= mliste[mlist_deep - 1]) { 
                            /* not in alloved range */
      PrintMessage("?ERROR - index out of range in 'print_names'");
      return;}

      printf("<%.4s><%.4s(%d)><%.4s>",segment+MAX_SEG_NAME_LEN*atom,
                                      resnam+MAX_RES_NAME_LEN*atom,
                                      res1[atom],
                                      atnam+MAX_ATM_NAME_LEN*atom);
}

/***********************************************************************/
char *sprint_names(atom)  /* pointer to segment, residue and atom names 
                             for atom number 'atom' */
       int atom;
/***********************************************************************/
{
      extern char *atnam;
      extern char *resnam;
      extern char *segment;
      extern int  *res1;
      extern int numat;

      static char OutText[BUFF_LEN];

      if(mliste[0] == 0) {
      PrintMessage("?ERROR - no atoms defined ");
      return(NULL);}

      if(atom < 0 || atom >= mliste[mlist_deep - 1]) { 
                            /* not in alloved range */
      PrintMessage("?ERROR - index out of range in 'print_names'");
      strncpy(OutText,"****** ERROR *******",BUFF_LEN);
      return(OutText);}

      sprintf(OutText,"<%.4s><%.4s(%d)><%.4s>",segment+MAX_SEG_NAME_LEN*atom,
                                               resnam+MAX_RES_NAME_LEN*atom,
                                               res1[atom],
                                               atnam+MAX_ATM_NAME_LEN*atom);
      return(OutText);
}
/************************************************************************/
int find_hydr_bond(ai,aj,dist) /* check if there can be a hydrogen bond */
      int ai;                  /* between atom nr 'ai' and nr 'aj'      */    
      int aj;
      float dist;              /* distance between atoms                */
                               /* if distance 0.0 it is calculated      */
/************************************************************************/
{

      extern int *atm_type;
      extern float *x,*y,*z;
      extern float hydbond;
      extern float hydhyd;

    extern int param203_terms;              /* terms in the parameters list */

    static int i;
    static char hbi,hbj;
    static float tmp1,tmp2,tmp3;

/* check that the parameters list is set */
        if(param203_terms < 1) {
          printf("?ERROR - atom parameter list is not set \n");
           return(0);}

/* check input distance 'dist' */

       if(dist < 0.001) { /* calculate it */
               tmp1 = (x[ai] - x[aj]);
               tmp2 = (y[ai] - y[aj]);
               tmp3 = (z[ai] - z[aj]);

         dist = sqrt( tmp1 * tmp1 +
                      tmp2 * tmp2 +
                      tmp3 * tmp3);}

         if(dist > hydbond) /* no chance for hydrogen bond */
         return(0);

/* check if atom type is set ... */
       if(atm_type[ai] == 0 || atm_type[aj] == 0) { /* not set */
       printf("?ERROR - atom types not set, can't check hydrogen bonding \n");
        return(0);}

/* first atom ai */
       for(i = 0 ; i < param203_terms ; i++ ) {
          if(param203[i].type == atm_type[ai]) {
          hbi = param203[i].hbond;
          break;}
	}
/*
        if(i < param203_terms) {
        printf("Hydrogen bond type for atom nr %d >%c<\n",ai,hbi);}
        else {
        printf("Could not determine type \n");
        return;}
*/
/* then atom aj */
       for(i = 0 ; i < param203_terms ; i++ ) {
          if(param203[i].type == atm_type[aj]) {
          hbj = param203[i].hbond;
          break;}
	}
/*
        if(i < param203_terms) {
        printf("Hydrogen bond type for atom nr %d >%c<\n",aj,hbj);}
        else {
        printf("Could not determine type \n");
        return(0);}
*/

/* look if either of the atoms is a hydrogen on the donor */
        if(atm_type[ai] < 5 || atm_type[aj] < 5) { /* check if we are looking
                                                      at a hydrogen atom */
          if(dist > hydhyd) return(0);}

/* check now and accept A&D, D&A , A&E and E&A */

        if(hbi == 'N' || hbj == 'N') return(0);

        if(hbi == 'A') {
          if(hbj == 'D' || hbj == 'E') return(1); /* yes it is true */
          return(0);}

        if(hbi == 'D') {
          if(hbj == 'A') return(1);
          return(0);}

        if(hbi == 'E') {
          if(hbj == 'A') return(1);
          return(0);}

    printf("?ERROR - undefined hydrogen bond type <%c> <%c>\n",hbi,hbj);
    return(0);
}
/************************************************************************/
int is_it_alpha(text,exchr)   /* test if the string text contains (A-Z or a-z)
                                 or a character from exchar list */
       char *text;
       char *exchr;
/************************************************************************/
{
       int slong1,slong2;
       int i,j;

       slong1 = strlen(text);
       for(i = 0 ; i < slong1 ; i++) {
          if(isalpha(text[i])) {
            return(1);}}

/* not match so far , look into the extra character list ... */

       slong2 = strlen(exchr);
       for(i = 0 ; i < slong2 ; i++)
          for(j = 0 ; j < slong1 ; j++) {
             if(strncmp(&text[j],&exchr[i],1) == 0) {
             return(1);}}

/* no match */
       return(0);
}  
/***********************************************************************/
float vecsum(vec,dim)  /* vector addition */
      float *vec;
      int dim;
/***********************************************************************/
{
     int i;
     float fhelp;

     fhelp = 0.0;

     for(i = 0 ; i < dim ; i++) fhelp += vec[i];

     return(fhelp);
} 

/*
    for a BSD Unix machine one can use the getrusage function

     #include <sys/time.h>
     #include <sys/resource.h>

     #define RUSAGE_SELF      0          calling process 
     #define RUSAGE_CHILDREN  -1         terminated child processes 

     int getrusage(int who, struct rusage *rusage);

*/

/**************************************************************************/
get_proc_info()       /* get process memory */
/**************************************************************************/
{
   int pagesize;    /* system page size */
   int pid_num;     /* process pid number */
   int i,str_long;
   char cmd[BUFF_LEN];
   char buf[BUFF_LEN];
   int buf_len = BUFF_LEN;
   int t_size;  /* total size of process */
   int r_size;  /* total resident size of process */
   char *get_it;

   FILE *ptr;

   if(module_name[0] == NULL) {
     PrintMessage("?WARNING - lost program name");
     return;}

   str_long = strlen(module_name);
    for(i = str_long ; i >= 0 ; i--) {
       if(module_name[i] == '/') break;}

   pid_num  = getpid();
   pagesize = getpagesize();

   t_size = 0;
   r_size = 0;

#ifdef JUNK 

    sprintf(cmd,"ps -el | grep %d | grep %.8s ",pid_num,&module_name[i+1]);

   if((ptr = popen(cmd,"r")) != NULL) {
      if(fgets(buf,buf_len,ptr) != NULL) {
      sscanf(buf,"%*d %*c %*d %*d %*d %*d %*d %*d %*c %s",cmd);

      get_it = STRTOK(cmd,":");
        t_size = atoi(get_it) * pagesize / 1000;
      get_it = STRTOK(NULL,":");
        r_size = atoi(get_it) * pagesize / 1000;

    sprintf(buf,"    Program name:                    %s ",module_name);
    PrintMessage(buf);
    sprintf(buf,"    Process pid:                     %d ",pid_num);
    PrintMessage(buf);
    sprintf(buf,"    System pagesize:                 %d  (bytes)",pagesize);
    PrintMessage(buf);
    sprintf(buf,"    Total size of process:           %d   (Kbytes)",t_size);
    PrintMessage(buf);
    sprintf(buf,"    Total resident size of process:  %d   (Kbytes)",r_size);
    PrintMessage(buf);}
      else {
      PrintMessage("?ERROR - Can't grep the process");}}
    else {
    printf("?ERROR - Can't make pipe \n");}

    pclose(ptr);

#endif

  if(RunStatistics() == -1) {
    PrintMessage("?ERROR - can't get information about resource utilization");
    }

    t_size = ProcessInfo.pu_size    * pagesize / 1000;

#ifdef IRIX4
    r_size = ProcessInfo.pu_rsssize * pagesize / 1000;
#else
    r_size = ProcessInfo.pu_rss     * pagesize / 1000;
#endif

    sprintf(buf,"    Program name:                    %s ",module_name);
    PrintMessage(buf);
    sprintf(buf,"    Process pid:                     %d ",pid_num);
    PrintMessage(buf);
    sprintf(buf,"    System pagesize:                 %d  (bytes)",pagesize);
    PrintMessage(buf);
    sprintf(buf,"    Total size of process:           %d   (Kbytes)",t_size);
    PrintMessage(buf);
    sprintf(buf,"    Total resident size of process:  %d   (Kbytes)",r_size);
    PrintMessage(buf);
    
 }
/***********************************************************************/
update_video_log(FrameCount)   /* update video log file */
      int FrameCount;
/***********************************************************************/
{
     time_t t;
     static char *date_time;
     static char start_date_time[BUFF_LEN];
     static float used_cpu       = 0.0;
     static float used_cpu_child = 0.0;
     static float used_time      = 0.0;
     FILE *log_p;
     static char *video_log_file = "VIDEO.LOG";
     int i;

    log_p = fopen(video_log_file,"w");

    if(log_p == NULL) {
      printf("?ERROR - Can't open video log file \n");
      return;}

    time(&t);
     if(t == -1) {
      printf("?ERROR - can't get the time \n");
       return;}

    date_time = ctime(&t);
    used_cpu       = 0.0;
    used_cpu_child = 0.0;
    get_cpu_secs(&used_cpu , &used_cpu_child);

/* calculate used wall time */
    get_wall_secs(&used_time);
    
/* save start date and time */
    if(FrameCount < 2) strncpy(start_date_time,date_time,BUFF_LEN);

/* write to log file */
    fprintf(log_p,"Start date and time       : %s \n",start_date_time);
    fprintf(log_p,"Date and time of the frame: %s \n",date_time);
   fprintf(log_p,"Frame number: %d , av. cpu time(in sec)/frame: %f \n",
            FrameCount,
            used_cpu /((float) FrameCount));
   fprintf(log_p,"                   av. child cpu time(in sec)/frame: %f \n",
            used_cpu_child /((float) FrameCount));
   fprintf(log_p,"                   av. wall clock time(in sec)/frame: %f \n",
            used_time /((float) FrameCount));
    for(i = 0 ; i < save_input_l ; i++) 
       fprintf(log_p,"%s\n",save_input[i]);
/* close file and continue */
    fclose(log_p);
}


/***********************************************************************/
int check_if_file_exist(file_name)  /* on return: 0 ok, file is there */
    char *file_name;                /*            < 0 can't access file */
/***********************************************************************/
{
    static int retv;
    char OutText[BUFF_LEN];

/* first check existence of file */
    retv = access(file_name,FILE_EXIST);

    if(retv == -1) {
    sprintf(OutText,"?ERROR - File '%s' does not exist ",file_name);
    PrintMessage(OutText);
    return(-1);}    /* problems with the file */
    else { /* check read permission */
    retv = access(file_name,FILE_READ);
         if(retv == -1) { 
         sprintf(OutText,"?ERROR - no read permission to file '%s' ",file_name);
         return(-1);}
    }

    if(DebugS.DebugL > 0) 
       (void)file_info(file_name);

    return(0);
}
/***********************************************************************/
PrintMessage(text)           /* print message (bang it)                */
     char *text;             /* text to be displayed                   */
/***********************************************************************/
{
   int i;

/* print on standard error */
/*
  fprintf(stderr,"%s\n",text);
*/
      i = strlen(text);
      if(text[i - 1] == '\n') text[i - 1] = '\0'; 
      printf("%s\n",text);

      WriteToLogFile(text);

/* now for the graphics screen */

   if((term_type == 1 || term_type == 3) && no_graphics_yet) {
   strncpy(bottom_line,text,PORTchar);
   going_on();
   stack_text(text);
   }

}
/***********************************************************************/
int FindSSbonds(SDistance)
    float SDistance;                                /* search distance */
/***********************************************************************/
{

     static int i,j,k,l,m,n;                 /* loop index     */
     static int *SSlist;                     /* pointer list   */
     static int *InStruct;                   /* structure pointer */
     static int Incr=10;                     /* list increment */
     static int RIndx;
     static int TempStruct;
     static float SSdist2 = DEFSSDIST2;
     static float   dist;

     static char TRes[MAX_RES_NAME_LEN];
     static char TAtm[MAX_ATM_NAME_LEN];

     static char OutText[BUFF_LEN];
     static char Tmp1[BUFF_LEN];
     static char Tmp2[BUFF_LEN];
     static char Tmp3[BUFF_LEN];
     static char Tmp4[BUFF_LEN];

     if(mlist_deep < 1) {
       PrintMessage("?ERROR - No atoms defined ");
       return(-1);}

     TempStruct = current_struct;

     if(SDistance > 0.01) SSdist2 = SDistance*SDistance;

     SSlist = ivector(Incr);
     if(SSlist == NULL) {
       PrintMessage("?ERROR - Can't allocate space in 'FindSSbonds'");
       current_struct = TempStruct;
       return(-1);}

     InStruct = ivector(Incr);
     if(InStruct == NULL) {
       PrintMessage("?ERROR - Can't allocate space in 'FindSSbonds'");
       current_struct = TempStruct;
       return(-1);}

/* Look for the CYS residues and SG atoms (capital letters!!!!) ... */

     k = 0;
     RIndx = Incr;
     for(i = 0 ; i < mlist_deep ; i++) {

        for(j = mlists[i] ; j < mliste[i] ; j++) {

        strncpy(TRes,resnam+MAX_RES_NAME_LEN*j,MAX_RES_NAME_LEN);
/*        toller(TRes); */
        strncpy(TAtm,atnam+MAX_ATM_NAME_LEN*j,MAX_ATM_NAME_LEN);
/*        toller(TAtm); */

        if((!strncmp(TRes,"CYS",3)) && (!strncmp(TAtm,"SG",2))) {

          if(k < RIndx) { 
            SSlist[k] = j;
            InStruct[k] = i;
            k++;}
          else {
            RIndx = RIndx + Incr;
            SSlist = (int *) realloc(SSlist , RIndx * sizeof(int));

            if(SSlist == NULL) { 
            PrintMessage("?ERROR - Can't allocate space in 'FindSSbonds'");
            current_struct = TempStruct;
            return(-1);}

            InStruct = (int *) realloc(InStruct , RIndx * sizeof(int));

            if(InStruct == NULL) { 
            PrintMessage("?ERROR - Can't allocate space in 'FindSSbonds'");
            current_struct = TempStruct;
            return(-1);}

            SSlist[k] = j;
            InStruct[k] = i;
            k++;}
	}

      }
            if(k > 0) { /* yes I did find some */
            sprintf(OutText,"SS - bonds for molecule nr: '%d'",(i+1));
            PrintMessage(OutText);

            for(j = 0 ; j < k ; j++) {

            l = SSlist[j];
            sprintf(OutText,"(%d) - '%.4s' CYS(%d) SG(%d)",
             (j+1),segment+4*l,res1[l],(l+1));
            PrintMessage(OutText);}

            if(k < 2) { /* only one CYS no bonds possible */
               return(0);}

                strncpy(Tmp3,"SG",2);
                 Tmp3[2] = '\0';
                strncpy(Tmp4,"SG",2);
                 Tmp4[2] = '\0';

            for(j = 0 ; j < (k - 1) ; j++) {

               l = SSlist[j];
               strncpy(TRes,segment+MAX_SEG_NAME_LEN*l,MAX_SEG_NAME_LEN);
/*               toller(TRes); */

               for(m = j+1 ; m < k ; m++)  {

               n = SSlist[m];

               strncpy(TAtm,segment+MAX_SEG_NAME_LEN*n,MAX_SEG_NAME_LEN);
/*               toller(TAtm); */
               
               if(strncmp(TRes,TAtm,MAX_SEG_NAME_LEN)) continue;

               dist = (x[l] - x[n])*(x[l] - x[n]) +
                      (y[l] - y[n])*(y[l] - y[n]) +
                      (z[l] - z[n])*(z[l] - z[n]);

               if(dist < SSdist2) {
               sprintf(OutText,"Distance < %f ==> Bonding between",sqrt(SSdist2));
               PrintMessage(OutText);
               sprintf(OutText,"(%d) - '%.4s' CYS(%d) SG(%d)",
               (j+1),segment+4*l,res1[l],(l+1));
               PrintMessage(OutText);
               sprintf(OutText,"(%d) - '%.4s' CYS(%d) SG(%d)",
               (m+1),segment+4*n,res1[n],(n+1));
               PrintMessage(OutText);
               sprintf(Tmp1,"%d",res1[l]);
               sprintf(Tmp2,"%d",res1[n]);
               fake_now = 1;
                if(InStruct[j] == InStruct[m]) {
                   current_struct = InStruct[j];
                edit_bond(1,TRes,Tmp1,Tmp3,TRes,Tmp2,Tmp4);
                fake_now = 0;}
             }
             }}            
	    }
            else {
            PrintMessage("No SS-bonds found (is this a protein?)");}

      }

            current_struct = TempStruct;


            free(InStruct);
            free(SSlist);

            return(0);
}

/* 

    Rotate the coordinates xc,yc and zc with the current rotations
    matrix and return the answer in nxc,nyc and nzc.

    Leif Laaksonen 1991

*/
/***********************************************************************/
void ApplyRota(xc,yc,zc,nxc,nyc,nzc)
       float xc,yc,zc;          /* old coordinates */
       float *nxc,*nyc,*nzc;    /* coordinates after applied with the current
                                   rotation matrix */ 
/***********************************************************************/
{

       float RotaM[4][4];
       float RotaT[4][4];
       float diffs;

#ifdef sgi
                          mmode(MVIEWING);
                          getmatrix(RotaM);
                           mmode(MPROJECTION); 
                            getmatrix(RotaT);
                             multmatrix(RotaM);
                            getmatrix(RotaM);
                           loadmatrix(RotaT);
                           mmode(MVIEWING);

       diffs = far - near;
    
     *nxc = 0.5 * diffs * (RotaM[0][0]*xc+RotaM[1][0]*yc+
            RotaM[2][0]*zc+RotaM[3][0]-rotB[3][0]);
     *nyc = 0.5 * diffs * (RotaM[0][1]*xc+RotaM[1][1]*yc+
            RotaM[2][1]*zc+RotaM[3][1]-rotB[3][1]);
     *nzc = 0.5 * diffs * (RotaM[0][2]*xc+RotaM[1][2]*yc+
            RotaM[2][2]*zc+RotaM[3][2]-rotB[3][2]);

#else

       PrintMessage("?ERROR - not implemented on this device ");

#endif

}
/***********************************************************************/
int SliceZ(z_cut)
     float z_cut;
/***********************************************************************/
{

    static int i;
    static float X_c,Y_c,Z_c;

    for(i = mlists[current_struct] ; i < mliste[current_struct] ; i++) {

      if(!disp_list[i]) continue;

      ApplyRota(x[i],y[i],z[i],&X_c,&Y_c,&Z_c);

/*
printf(" %f %f %f => %f %f %f \n",x[i],y[i],z[i],X_c,Y_c,Z_c);
*/
      if(surface_list[i]) 
            if((Z_c - vdw_list[i]) < z_cut) {
               printf(" %f %f \n",z[i],(Z_c-vdw_list[i]));
               disp_list[i] = 0;}
      else
            if(Z_c < z_cut) disp_list[i] = 0;
    }

}
       

/***********************************************************************/
int SliceX(x_cut)
     float x_cut;
/***********************************************************************/
{

    static int i;
    static float X_c,Y_c,Z_c;

    for(i = mlists[0] ; i < mliste[0] ; i++) {

      if(!disp_list[i]) continue;

      ApplyRota(x[i],y[i],z[i],&X_c,&Y_c,&Z_c);

printf(" %f %f %f => %f %f %f \n",x[i],y[i],z[i],X_c,Y_c,Z_c);

      if(X_c < x_cut) disp_list[i] = 0;

    }

}
       
/***********************************************************************/
int SliceY(y_cut)
     float y_cut;
/***********************************************************************/
{

    static int i;
    static float X_c,Y_c,Z_c;

    for(i = mlists[0] ; i < mliste[0] ; i++) {

      if(!disp_list[i]) continue;

      ApplyRota(x[i],y[i],z[i],&X_c,&Y_c,&Z_c);

printf(" %f %f %f => %f %f %f \n",x[i],y[i],z[i],X_c,Y_c,Z_c);

      if(Y_c < y_cut) disp_list[i] = 0;

    }

}

/***********************************************************************/
short CheckEventQueue()
/***********************************************************************/
{
#ifdef sgi

       static short Val;
       static long Dev;

       if(qtest()) {

         Dev = qread(&Val);

         if(Dev == KEYBD) {

         switch(Val) {

	   case 3: /* ^C , end loop */
                  PrintMessage("**** User Interrupt ****");
                  return(Val);

	   default: /* no action */
                  return(0);
		}
       }}

       return(0);
#else
       PrintMessage("?ERROR - not implemented on this device ");
#endif
}

/***********************************************************************/
UpdateCharmmStruct(atoms)
       int atoms;
/***********************************************************************/
{
     register int i,j;

         if(!NumCharmmStruct) {
             Charmm_struct = (struct CHARMm *) malloc(
                              mlist_deep * sizeof(*Charmm_struct));}
         else {
             Charmm_struct = (struct CHARMm *) realloc(Charmm_struct ,
                              mlist_deep * sizeof(*Charmm_struct));}

          if(Charmm_struct == NULL) {
             PrintMessage("?ERROR - can't update CHARMM structure");
             shut_down(1);}

         NumCharmmStruct = mlist_deep;

         for(i = 0 ; i < mlist_deep ; i++) { 
           j = mlists[i];
           Charmm_struct[i].numat   = mliste[i] - mlists[i];
           Charmm_struct[i].res1    = &res1[j];
           Charmm_struct[i].res2    = &res2[j];
           Charmm_struct[i].resnam  = &resnam[MAX_RES_NAME_LEN * j];
           Charmm_struct[i].atnam   = &atnam[MAX_ATM_NAME_LEN * j];
           Charmm_struct[i].segment = &segment[MAX_SEG_NAME_LEN * j];
           Charmm_struct[i].x       = &x[j];
           Charmm_struct[i].y       = &y[j];
           Charmm_struct[i].z       = &z[j];
           Charmm_struct[i].bvalue  = &bvalue[j];}

}
/***********************************************************************/
int SaveCommandStack()
/***********************************************************************/
{
      int i;
      FILE *Comm_s;

      Comm_s = fopen(STACKFILE , "w");
       if(Comm_s == NULL) {
         PrintMessage("!WARNING - can't save command stack");
         fclose(Comm_s);
         return(1);}

         fprintf(Comm_s,"%d\n",save_input_l);
      for(i = 0 ; i < save_input_l ; i++) 
         fprintf(Comm_s,"%s\n",save_input[i]);

      fclose(Comm_s);
      return(0);
}
/***********************************************************************/
int ReadCommandStack()
/***********************************************************************/
{
      int i,j;
      FILE *Comm_s;
      char Buffer[BUFF_LEN];

      save_input_l = 0;
      Comm_s = fopen(STACKFILE , "r");
       if(Comm_s != NULL) {
/*         PrintMessage("Retrieving old command stack"); */

         if(fgets(Buffer,BUFF_LEN,Comm_s) == NULL) {
            save_input_l = 0;
            return(1);}

         save_input_l = atoi(Buffer);
         if(save_input_l < 1) {
            save_input_l = 0;
            return(1);}
         if(save_input_l >= MAX_SAVE) save_input_l = (MAX_SAVE - 1);

      for(i = 0 ; i < save_input_l ; i++) {
         fgets(save_input[i], BUFF_LEN ,Comm_s);
         j = strlen(save_input[i]);
         if(save_input[i][j-1] == '\n') save_input[i][j-1] = '\0';}

      fclose(Comm_s);
      return(0);}

      return(0);
}
/***********************************************************************/
int MenuCStack()
/***********************************************************************/
{
      static long MenuStack;
      static int i;
      static int retv;

#ifdef sgi
      MenuStack = newpup(); /* create the menu */
      addtopup(MenuStack, "Choose command %t");

      for(i = (save_input_l - 1) ; i >= 0 ; i--) 
                          addtopup(MenuStack,save_input[i]);


       i = dopup(MenuStack) - 1;

       freepup(MenuStack); /* delete the menu to be able to create it again */

       if(i < 0) return(0);

/* hook on ascii value 26 (special service from keyb_input) */
       val = 26;
       retv = keyb_input(save_input[save_input_l - (i + 1)]);
        strncpy(bottom_line,prompt,PORTchar);
         strncat(bottom_line,
                 save_input[save_input_l -( i + 1)],
                 (PORTchar - strlen(bottom_line)));
          going_on();

       return(0);
#endif

}




/***********************************************************************/
get_wall_secs(TimeSecs)
     float *TimeSecs;
/***********************************************************************/
{
      static time_t GetTime = 1;
      static int Switch = -1;
      static time_t TimeAtStart = 0;

      time(&GetTime);

      *TimeSecs = 0.0;

      if(Switch < 0) {
        TimeAtStart = GetTime;
        Switch = 1;}
      else {
        *TimeSecs = (float)(GetTime - TimeAtStart);}
}
/***********************************************************************/
char *LookForPar(InputString)
      char *InputString;
/***********************************************************************/
{
      static char *FindIt;
             char *Transfer;
      static int   MemReady = 0;
             int Loop;
             int NumLeft = 0;
             int NumRight = 0;
             int Occu = 0;

      if(!MemReady) {
        FindIt = (char *) malloc(BUFF_LEN);
        if(FindIt == NULL) {
          PrintMessage("?ERROR - can't allocate memory in 'LookForPar'");
          return(NULL);}
        MemReady = 1;}

        for(Loop = 0 ; Loop < BUFF_LEN ; Loop++) FindIt[Loop] = '\0';

      if(!strlen(InputString)) {  /* null string supplied */
      PrintMessage("?WARNING - null string supplied ");
      return(NULL);}

      NumLeft  = LookForChar(InputString,'(');
      NumRight = LookForChar(InputString,')');

      if(NumLeft-NumRight) {
         PrintMessage("?ERROR - unbalanced '()'");
         return(NULL);}

      if((Transfer = strchr(InputString,'(')) != NULL) {
         if(strchr(InputString,')') == NULL) {
         PrintMessage("?ERROR - unbalanced '()'");
         return(NULL);}
         Occu = 0;
/*
         for(Loop = 1 ; Loop < BUFF_LEN ; Loop++) {
                         if(Loop == BUFF_LEN) {
                         return(FindIt);}
                         if(Transfer[Loop] == ')') {
                           Occu++;
                           if(Occu == NumRight) return(FindIt);}
                         FindIt[Loop-1] = Transfer[Loop];}
*/
         NumLeft  = 1; /* already found one */
         NumRight = 0;

         Loop = 1;

/* no check for end of string here, has to be done before */
         while(1) {
                   if(Transfer[Loop] == ')') {
                      NumRight++;
                      if(!(NumLeft-NumRight)) return(FindIt);
                      FindIt[Loop - 1] = Transfer[Loop];
                      Loop++;
		      }
                   else {
                      FindIt[Loop - 1] = Transfer[Loop];
                      Loop++;}

	 }
       }
       return(NULL);  /* nothing really */

    }

/***********************************************************************/
char *LookForBra(InputString)
      char *InputString;
/***********************************************************************/
{
      static char *FindIt;
             char *Transfer;
      static int   MemReady = 0;
             int Loop;
             int NumLeft  = 0;
             int NumRight = 0;
             int Occu     = 0;

      if(!MemReady) {
        FindIt = (char *) malloc(BUFF_LEN);
        if(FindIt == NULL) {
          PrintMessage("?ERROR - can't allocate memory in 'LookForBra'");
          return(NULL);}
        MemReady = 1;}

        for(Loop = 0 ; Loop < BUFF_LEN ; Loop++) FindIt[Loop] = '\0';

      if(!strlen(InputString)) {  /* null string supplied */
      PrintMessage("?WARNING - null string supplied ");
      return(NULL);}

      NumLeft  = LookForChar(InputString,'[');
      NumRight = LookForChar(InputString,']');

      if(NumLeft-NumRight) {
         PrintMessage("?ERROR - unbalanced '[]'");
         return(NULL);}

      if((Transfer = strchr(InputString,'[')) != NULL) {
         if(strchr(InputString,']') == NULL) {
         PrintMessage("?ERROR - unbalanced '[]'");
         return(NULL);}
         Occu = 0;
         for(Loop = 1 ; (Loop < BUFF_LEN); Loop++) {
                         if(Loop == BUFF_LEN) {
                         return(FindIt);}
                         if(Transfer[Loop] == ']') {
                           Occu++;
                           if(Occu == NumRight) return(FindIt);}
                         FindIt[Loop-1] = Transfer[Loop];}

       }
       return(NULL);   /* nothing really */
   }
/***********************************************************************/
int LookForChar(InputString,SearchChar)
    char *InputString;
    char  SearchChar;
/***********************************************************************/
{
    int i,j;

    if(InputString[0] == '\0') return(0);

    j = 0;

    for(i = 0 ; i < strlen(InputString) ; i++) {
        if(InputString[i] == SearchChar) j++;
      }

    return(j);
}
/***********************************************************************/
void CheckConnTable(TheTable)
     int **TheTable;
/***********************************************************************/
{
     register int i,j,k,l;
     static int Bingo;

     for(i = mlists[mlist_deep - 1] ; i < mliste[mlist_deep - 1] ; i++) {
        for(j = 1 ; j <= TheTable[i][0] ; j++) {
           k = TheTable[i][j]; 
           Bingo = 0;
           for(l = 1 ; l <= TheTable[k][0] ; l++) {
              if(TheTable[k][l] == i) {
                Bingo = 1;
                break;}}
           if(!Bingo) printf("Miss match at %d %d \n",i,k);
       }
     }
printf("Done here in 'CheckConnTable'... \n");
}

/*
    The text field can also be right justified.
    The leading space is removed

    1993 , leif laaksonen
*/
/***********************************************************************/
int ExtractFromString(StringIn,StringOut,NumChar)
    char *StringIn;    /* Input string  */
    char *StringOut;   /* Place NumChar of characters from input here */
    int   NumChar;
/***********************************************************************/
{
    register int i;
    static   int CharFound;

    CharFound = 0;

    for(i = 0; i < NumChar ; i++) {
       StringOut[i] = '\0';
       if(StringIn[i] == ' ')  {
         if(!CharFound) continue;
           StringOut[CharFound] = '\0';
             return(CharFound);}
       StringOut[CharFound] = StringIn[i];
                 CharFound++;}

    return(CharFound);
}

/***********************************************************************/
int PutSegName(Sting , Point)
      char *Sting;  /* string length is defined in MAX_SEG_NAME_LEN */
      int   Point;
/***********************************************************************/
{
    static int Retv;

    Retv = ExtractFromString(Sting , (segment+MAX_SEG_NAME_LEN*Point) , 
           MAX_SEG_NAME_LEN);

    return(0);
}
/***********************************************************************/
int PutResName(Sting,Point)
    char *Sting;   /* string length is defined in MAX_RES_NAME_LEN */
    int Point;
/***********************************************************************/
{
    static int Retv;

    Retv = ExtractFromString(Sting , (resnam+MAX_RES_NAME_LEN*Point) , 
           MAX_RES_NAME_LEN);

    return(0);
}
/***********************************************************************/
int PutAtmName(Sting,Point)
    char *Sting;  /* string length is defined in MAX_ATM_NAME_LEN */
    int Point;
/***********************************************************************/
{
    static int Retv;

    Retv = ExtractFromString(Sting , (atnam+MAX_ATM_NAME_LEN*Point) , 
    MAX_ATM_NAME_LEN);

    return(0);
}
/***********************************************************************/
int PutResNum1(ResNum , Point)
    int  Point;
/***********************************************************************/
{
    static int Retv;

    res1[Point] = ResNum;

    return(0);
}
/***********************************************************************/
int PutResNum2(ResNum , Point)
    int  Point;
/***********************************************************************/
{
    static int Retv;

    res2[Point] = ResNum;

    return(0);
}
/***********************************************************************/
int PutXCoord(XCoord , Point)
    float  XCoord;
    int    Point;
/***********************************************************************/
{
    static int Retv;

    x[Point] = XCoord;

    return(0);
}
/***********************************************************************/
int PutYCoord(YCoord,Point)
    float  YCoord;
    int    Point;
/***********************************************************************/
{
    static int Retv;

    y[Point] = YCoord;

    return(0);
}
/***********************************************************************/
int PutZCoord(ZCoord , Point)
    float  ZCoord;
    int    Point;
/***********************************************************************/
{
    static int Retv;

    z[Point] = ZCoord;

    return(0);
}
/***********************************************************************/
int PutBValue(Value , Point)
    float  Value;
    int    Point;
/***********************************************************************/
{
    static int Retv;

    bvalue[Point] = Value;

    return(0);
}
/***********************************************************************/
int PutDispList(Value , Point)
    int    Value;   /* disp off = 0 , disp on > 0 */
    int    Point;
/***********************************************************************/
{
    static int Retv;

    disp_list[Point] = Value;

    return(0);
}
/***********************************************************************/
int PutCPKList(Value , Point)
    int    Value;   /* disp off = 0 , disp on > 0 */
    int    Point;
/***********************************************************************/
{
    static int Retv;

    surface_list[Point] = Value;

    return(0);
}
/***********************************************************************/
int PutLicoList(Value , Point)
    int    Value;   /* disp off = 0 , disp on > 0 */
    int    Point;
/***********************************************************************/
{
    static int Retv;

    liquorice_list[Point] = Value;

    return(0);
}

/***********************************************************************/
int PutAtmCharge(Value , Point)
    float  Value;
    int    Point;
/***********************************************************************/
{
    static int Retv;

    atm_charge[Point] = Value;

    return(0);
}
/***********************************************************************/

/***********************************************************************/
char *GetSegName(Point)
      int Point;
/***********************************************************************/
{
    static char ExSting[MAX_SEG_NAME_LEN + 1]; /* always NUL terminated */
    static int Retv;

    for(Retv = 0 ; Retv < MAX_SEG_NAME_LEN ; Retv++) ExSting[Retv] = '\0';

    Retv = ExtractFromString((segment+MAX_SEG_NAME_LEN*Point) , ExSting , 
           MAX_SEG_NAME_LEN);

    ExSting[MAX_SEG_NAME_LEN] = '\0';

    return(ExSting);
}
/***********************************************************************/
char *GetResName(Point)
      int Point;
/***********************************************************************/
{
    static char ExSting[MAX_RES_NAME_LEN + 1]; /* always NUL terminated */
    static int Retv;

    for(Retv = 0 ; Retv < MAX_RES_NAME_LEN ; Retv++) ExSting[Retv] = '\0';

    Retv = ExtractFromString((resnam+MAX_RES_NAME_LEN*Point) , ExSting , 
    MAX_RES_NAME_LEN);

    ExSting[MAX_RES_NAME_LEN] = '\0';

    return(ExSting);
}
/***********************************************************************/
char *GetAtmName(Point)
      int Point;
/***********************************************************************/
{
    static char ExSting[MAX_ATM_NAME_LEN + 1]; /* always NUL terminated */
    static int Retv;

    for(Retv = 0 ; Retv < MAX_ATM_NAME_LEN ; Retv++) ExSting[Retv] = '\0';

    Retv = ExtractFromString((atnam+MAX_ATM_NAME_LEN*Point) , ExSting , 
    MAX_ATM_NAME_LEN);

    ExSting[MAX_ATM_NAME_LEN] = '\0';

    return(ExSting);
}
/***********************************************************************/
int GetResNum1(Point)
    int  Point;
/***********************************************************************/
{
    static int i;

    i = res1[Point];

    return(i);
}
/***********************************************************************/
int GetResNum2(Point)
    int  Point;
/***********************************************************************/
{
    static int i;

    i = res1[Point];

    return(i);
}
/***********************************************************************/
float GetXCoord(Point)
    int    Point;
/***********************************************************************/
{
    static float Xc;

    Xc = x[Point];

    return(Xc);
}
/***********************************************************************/
float GetYCoord(Point)
    int    Point;
/***********************************************************************/
{
    static float Yc;

    Yc = y[Point];

    return(Yc);
}
/***********************************************************************/
float GetZCoord(Point)
    int    Point;
/***********************************************************************/
{
    static float Zc;

    Zc = z[Point];

    return(Zc);
}
/***********************************************************************/
float GetBValue(Point)
    int    Point;
/***********************************************************************/
{
    static float Bv;

    Bv = bvalue[Point];

    return(Bv);
}
/***********************************************************************/
int GetDispList(Point)
    int    Point;
/***********************************************************************/
{
    static int Retv;

    return(disp_list[Point]);
}

/***********************************************************************/
int GetCPKList(Point)
    int    Point;
/***********************************************************************/
{
    static int Retv;

    return(surface_list[Point]);
}
/***********************************************************************/
int GetLicoList(Point)
    int    Point;
/***********************************************************************/
{
    static int Retv;

    return(liquorice_list[Point]);
}
/***********************************************************************/
float GetAtmCharge(Point)
    int    Point;
/***********************************************************************/
{
    static float Bv;

    Bv = atm_charge[Point];

    return(Bv);
}



/***********************************************************************/
FILE *RetFilePoint(FileName)  /* look first in current directory then in */
     char *FileName;          /* the SCARECROW data directory            */     
/***********************************************************************/
{

     FILE *par_p;
     char chelp[BUFF_LEN];
     char OutText[BUFF_LEN];

     strncpy(chelp,FileName,BUFF_LEN);

/* try first to open in working directory */
     par_p=fopen(FileName,"r");
     if(par_p==NULL) {
       strncpy(chelp,scr_data,BUFF_LEN);
        strcat(chelp,"/");
         strncat(chelp,FileName,(BUFF_LEN - strlen(chelp)));
/* try then in the "data" directory */
         par_p = fopen(chelp,"r");
     if(par_p == NULL) {
     sprintf(OutText,"**** Can't open file: %s ",FileName);
     PrintMessage(OutText);
     check_if_fatal(1); 
     return(0);}}

     return(par_p);
}

/***********************************************************************/
Mmult4(a,b)     /* matrix multiplication matrix(4) * matrix(4) */

   float a[][4],b[][4];
/***********************************************************************/
{
/* a , b and the result c are square */
   register int i,j,k;
   int four=4,nh=4;
   static float c[4][4],temp;

          for(i = 0 ; i < nh ; i++) {
            c[i][0]=0.0;
             c[i][1]=0.0;
              c[i][2]=0.0;
               c[i][3]=0.0;}

      for(k = 0 ; k < nh ; k++) {
/*   */
         for( j = 0 ; j < nh ; j++) {
/*   */
          temp=b[k][j];
          c[0][j] += a[0][k]*temp;
          c[1][j] += a[1][k]*temp;
          c[2][j] += a[2][k]*temp;
          c[3][j] += a[3][k]*temp;
      }}
/* move data from c to b    */
      for(i = 0 ; i < four ; i++) {
        b[i][0]=c[i][0];
        b[i][1]=c[i][1];
        b[i][2]=c[i][2];
        b[i][3]=c[i][3];}
}

/***********************************************************************/
Mmult3(a,b)     /* matrix multiplication matrix(3) * matrix(3) */

   float a[][4],b[][3];
/***********************************************************************/
{
/* a , b and the result c are square */
   register int i,j,k;
   int three=3,nh=3;
   static float c[3][3],temp;

          for(i = 0 ; i < nh ; i++) {
            c[i][0]=0.0;
             c[i][1]=0.0;
              c[i][2]=0.0;}

      for(k = 0 ; k < nh ; k++) {
/*   */
         for( j = 0 ; j < nh ; j++) {
/*   */
          temp=b[k][j];
          c[0][j] += a[0][k]*temp;
          c[1][j] += a[1][k]*temp;
          c[2][j] += a[2][k]*temp;
      }}
/* move data from c to b    */
      for(i = 0 ; i < three ; i++) {
        b[i][0]=c[i][0];
        b[i][1]=c[i][1];
        b[i][2]=c[i][2];}
}
/***********************************************************************/
MakeIdMat3(a)     /* make a to identity matrix */

   float a[][3];
/***********************************************************************/
{
   a[0][0] = a[1][1] = a[2][2] = 1.;

   a[0][1] = a[0][2] = 0.0;
   a[1][0] = a[1][2] = 0.0;
   a[2][0] = a[2][1] = 0.0;
}

/***********************************************************************/
Driver_MakeSequence()
/***********************************************************************/
{
        static char *SeqListNames;
        static int   SeqLists;
        static int  *SeqListStart;
        static int  *SeqListLong;
        int i;

        SeqListNames = cvector((maxres1+1) * MAX_RES_NAME_LEN);
        SeqListStart = ivector(maxres1+1); 
        SeqListLong  = ivector(maxres1+1);

        MakeSequence(SeqListNames,&SeqLists,SeqListStart,SeqListLong);

        for(i = 0 ; i < SeqLists ; i++) { 
           printf("Name '%.4s' %d %d\n",SeqListNames+MAX_RES_NAME_LEN*i,
                   SeqListStart[i],SeqListLong[i]);}

        free(SeqListNames);
         free(SeqListStart);
          free(SeqListLong);
}
/***********************************************************************/
MakeSequence(SeqListNames,SeqLists,SeqListStart,SeqListLong)     
                                   /* Put the residue names into list */ 
        char *SeqListNames;
        int  *SeqLists;
        int  *SeqListStart;
        int  *SeqListLong;
/***********************************************************************/
{
        int i,j,TempR;
        char OutText[BUFF_LEN];

/* make the list for the current structure */

        i = current_struct;
        sprintf(OutText,"Making sequence list for structure '%d'",(i+1));
        PrintMessage(OutText);

        strncpy(SeqListNames,GetResName(mlists[i]),MAX_RES_NAME_LEN);
        SeqListStart[0] = mlists[i];
        TempR = GetResNum1(mlists[i]);

        *SeqLists = 0;
         SeqListLong[0] = 1;

        for(j = mlists[i] + 1 ; j < mliste[i] ; j++) {

           if(GetResNum1(j) == TempR) {
             SeqListLong[*SeqLists]++;
             continue;}
           else {
             (*SeqLists)++;
              SeqListLong[*SeqLists] = 1;
              SeqListStart[*SeqLists] = j;
              TempR = res1[j];
              strncpy(SeqListNames+(MAX_RES_NAME_LEN * (*SeqLists)),
                      GetResName(j),MAX_RES_NAME_LEN);}

         }
             (*SeqLists)++;
 }
             
/***********************************************************************/
void MakeOrtho()
/***********************************************************************/
{

#ifdef sgi

   float near2;

     static long Xwind;
     static long Ywind;

     register float GlobalScale;


     getsize(&Xwind , &Ywind);

     GlobalScale = (float)Xwind / (float)Ywind;


     if(IsStereoON())
                      return;

   if(!Model.Transformation) {

      ortho(GlobalScale * near , GlobalScale * far , near , far , near , far); 

   }
   else {

     near2 = near + near;
     perspective(Model.Fovy , GlobalScale , Fabs(near2) , 
                             Fabs(near2 + near2));  
     lookat(0.0 , 0.0 , Fabs(near2 + near) , 0.0 , 0.0 , 0.0 , 0);
   }

#else
   PrintMessage("?ERROR - 'ortho' not implemented on this device");
#endif

}
/***********************************************************************/
void HWlookup()
/***********************************************************************/
{

   char OutText[BUFF_LEN];

   HW.zbuffer = 0;
   HW.XPmax   = 0;
   HW.YPmax   = 0;
   HW.Blend   = 0;

#ifdef sgi
   HW.zbuffer = getgdesc(GD_BITS_NORM_ZBUFFER);
   HW.XPmax   = getgdesc(GD_XPMAX);
   HW.YPmax   = getgdesc(GD_YPMAX);
   HW.Blend   = getgdesc(GD_BLEND);

   (void) gversion(HW.Info);

   sprintf(OutText,"    Current hardware and GL version: %s",HW.Info);
   PrintMessage(OutText);
#endif
}
/***********************************************************************/
void ScareSwapbuffers()
/***********************************************************************/
{

#ifdef sgi
   if(DBuffer.BufferMode == 2) { 
         swapbuffers();
         return;}

   if(DBuffer.BufferMode != 1) 
      PrintMessage("?ERROR - error in buffer mode (unknown mode)");
#else

   return;

#endif
}
/***********************************************************************/
void PutSBuffer()
/***********************************************************************/
{
#ifdef sgi
    singlebuffer();
    gconfig();
#else
    return;
#endif
}
/***********************************************************************/
void PutDBuffer()
/***********************************************************************/
{
#ifdef sgi
    doublebuffer();
    gconfig();
#else
    return;
#endif
}
/***********************************************************************/
int DefFKey( Key , num)
    int    Key;
    int    num;
/***********************************************************************/
{

    int i;
    char Ctext[BUFF_LEN];

    NULL_STRING(Ctext);

     strncpy(Ctext,parsed[2],BUFF_LEN);
     for(i = 1 ; i < (num-2) ; i++) {
        strncat(Ctext," ",(BUFF_LEN - strlen(Ctext)));
         strncat(Ctext,parsed[2+i],(BUFF_LEN - strlen(Ctext)));}

      
    if(Key < LFKEY || Key > HFKEY) {
      PrintMessage("?ERROR - not an allowed key number ");
      return(1);}

    switch(Key) {

    case 1:
    if(Ctext[0] == '\0') NULL_STRING(FUNKEY.f1);
    else
    strncpy(FUNKEY.f1,Ctext,BUFF_LEN);
    break;
     case 2:
     if(Ctext[0] == '\0') NULL_STRING(FUNKEY.f2);
     else
     strncpy(FUNKEY.f2,Ctext,BUFF_LEN);
     break;
      case 3:
      if(Ctext[0] == '\0') NULL_STRING(FUNKEY.f3);
      else
      strncpy(FUNKEY.f3,Ctext,BUFF_LEN);
      break;
       case 4:
       if(Ctext[0] == '\0') NULL_STRING(FUNKEY.f4);
       else
       strncpy(FUNKEY.f4,Ctext,BUFF_LEN);
       break;
        case 5:
        if(Ctext[0] == '\0') NULL_STRING(FUNKEY.f5);
        else
        strncpy(FUNKEY.f5,Ctext,BUFF_LEN);
        break;
         case 6:
         if(Ctext[0] == '\0') NULL_STRING(FUNKEY.f6);
         else
         strncpy(FUNKEY.f6,Ctext,BUFF_LEN);
         break;
          case 7:
          if(Ctext[0] == '\0') NULL_STRING(FUNKEY.f7);
          else
          strncpy(FUNKEY.f7,Ctext,BUFF_LEN);
          break;
           case 8:
           if(Ctext[0] == '\0') NULL_STRING(FUNKEY.f8);
           else
           strncpy(FUNKEY.f8,Ctext,BUFF_LEN);
           break;
            case 9:
            if(Ctext[0] == '\0') NULL_STRING(FUNKEY.f9);
            else
            strncpy(FUNKEY.f9,Ctext,BUFF_LEN);
            break;
             case 10:
             if(Ctext[0] == '\0') NULL_STRING(FUNKEY.f10);
             else
             strncpy(FUNKEY.f10,Ctext,BUFF_LEN);
             break;
              case 11:
              if(Ctext[0] == '\0') NULL_STRING(FUNKEY.f11);
              else
              strncpy(FUNKEY.f11,Ctext,BUFF_LEN);
              break;
               case 12:
               if(Ctext[0] == '\0') NULL_STRING(FUNKEY.f12);
               else
               strncpy(FUNKEY.f12,Ctext,BUFF_LEN);
               break;
	  }

          return(0);
}
/***********************************************************************/
int RunFKey(Key)
    int Key;
/***********************************************************************/
{

    if(Key < LFKEY || Key > HFKEY) {
      PrintMessage("?ERROR - not an allowed key number ");
      return(1);}


    switch(Key) {

    case 1:
    if(FUNKEY.f1[0] == '\0') return(0);
    send_command(FUNKEY.f1);
    break;
    case 2:
    if(FUNKEY.f2[0] == '\0') return(0);
    send_command(FUNKEY.f2);
    break;
    case 3:
    if(FUNKEY.f3[0] == '\0') return(0);
    send_command(FUNKEY.f3);
    break;
    case 4:
    if(FUNKEY.f4[0] == '\0') return(0);
    send_command(FUNKEY.f4);
    break;
    case 5:
    if(FUNKEY.f5[0] == '\0') return(0);
    send_command(FUNKEY.f5);
    break;
    case 6:
    if(FUNKEY.f6[0] == '\0') return(0);
    send_command(FUNKEY.f6);
    break;
    case 7:
    if(FUNKEY.f7[0] == '\0') return(0);
    send_command(FUNKEY.f7);
    break;
    case 8:
    if(FUNKEY.f8[0] == '\0') return(0);
    send_command(FUNKEY.f8);
    break;
    case 9:
    if(FUNKEY.f9[0] == '\0') return(0);
    send_command(FUNKEY.f9);
    break;
    case 10:
    if(FUNKEY.f10[0] == '\0') return(0);
    send_command(FUNKEY.f10);
    break;
    case 11:
    if(FUNKEY.f11[0] == '\0') return(0);
    send_command(FUNKEY.f11);
    break;
    case 12:
    if(FUNKEY.f12[0] == '\0') return(0);
    send_command(FUNKEY.f12);
    break;
  }
    return(0);
}
/***********************************************************************/
NULL_STRING(a)
    char *a;
/***********************************************************************/
{
    int i;

    for(i = 0 ; i < BUFF_LEN ; i++) a[i] = '\0';
}
/***********************************************************************/
int IsStringFloat(InString)
    char *InString;             /* test if input is a float value
                                   On return:
                                   0 it is not a float
                                  >0 it is a float   */
/***********************************************************************/
{

    int i,j;


    j = strlen(InString);

    if(j < 1) return(0);

    for(i = 0 ; i < j ; i++) {
        if(isalpha(InString[i])) return(0);
/* some special cases: '*' and '?' */
         if(InString[i] == '*') return(0);
          if(InString[i] == '?') return(0);
           if(InString[i] == '.') return(1);}

    return(i);
  }

/************************************************************************/
Show_round(pindex,sel_list,sel_list_long,rad,Collect,
           already_in_list,Seg,Res,Atm)
      int pindex;  /* index to the select list (sel_list) */
      int *sel_list; /* selection list */
      int sel_list_long; /* length of selection list */
      float rad; /* radius for the search                   */
      int *Collect;
      int *already_in_list;
      char *Seg;
      char *Res;
      char *Atm;
/************************************************************************/
{
  extern int numat;
  extern int maxres1;
  extern int minres1;
  extern float *x,*y,*z;
  extern char *disp_list;

  static int *disp_res,*Comp_set,Comp_set_long;
  static int i,j;
  static int disp_atoms = 0;
  static float xf,yf,zf,rad2;
  static int resij,from,atom_max;
  static char Res1[MAX_SEG_NAME_LEN];
  static char Res2[MAX_RES_NAME_LEN];
  static char OutText[BUFF_LEN];

  atom_max = atom_list_max();

  disp_res      = ivector(atom_max);

  from = sel_list[pindex];

  xf = x[from];
   yf = y[from];
    zf = z[from];
     rad2 = rad*rad;


  for(i = mlists[0] ; i < mliste[mlist_deep - 1] ; i++) 
              disp_res[i] = 0;   /* first all off ... */

  for(i = 0 ; i < sel_list_long ; i++) 
              disp_res[sel_list[i]] = 2; /* atoms in main list */


  for( i = mlists[0] ; i < mliste[mlist_deep - 1] ; i++) {

/* don't include atoms already selected */

   if(disp_res[i]) continue;              /* first level     */

   resij = res1[i];
   strncpy(Res1,segment+MAX_SEG_NAME_LEN*i,MAX_SEG_NAME_LEN);
   strncpy(Res2,resnam +MAX_RES_NAME_LEN*i,MAX_RES_NAME_LEN);

    if(   ( (x[i]-xf)*(x[i]-xf) 
          + (y[i]-yf)*(y[i]-yf)
          + (z[i]-zf)*(z[i]-zf))  < rad2 ) {
/* check the selection mode */
  if(selection_mode == 0) {
    for(j = mlists[0] ; j < mliste[mlist_deep - 1] ; j++) {
       if((!strncmp(Res1,segment+MAX_RES_NAME_LEN*j,MAX_SEG_NAME_LEN)) && 
          (!strncmp(Res2,resnam +MAX_RES_NAME_LEN*j,MAX_RES_NAME_LEN)) &&
            (res1[j] == resij)) disp_res[j] = 1;}
  }
  else 
       disp_res[i] = 1;
  } }

  disp_atoms = 0;

  Comp_set      = ivector(atom_max);
  Comp_set_long = select_list(Seg,Res,Atm,Comp_set);

  if(Comp_set_long < 1) {
     PrintMessage("?ERROR - no atoms in the comparison set");
      *Collect = 0;
       free(disp_res);
        free(Comp_set);
        return;}


  for(i = 0 ; i < mliste[mlist_deep - 1] ; i++) {

      if(disp_res[i] == 1) {

      for(j = 0 ; j < Comp_set_long ; j++) {
          if(Comp_set[j] == i) {
            disp_atoms++;
            break;}}
    }}

    if(*Collect == 0) {
     *Collect  = disp_atoms;
      j = 0;
      for(i = 0 ; i < mliste[mlist_deep - 1] ; i++) {
         if(disp_res[i] == 1) {
         already_in_list[j] = i;
         j++;
         }}}
    else {
      j = *Collect;
      for(i = 0 ; i < mliste[mlist_deep - 1] ; i++) {
         if(disp_res[i] == 1) {
          if(!CheckOldSelList(i , j , already_in_list)) {
          already_in_list[j] = i;
          j++;}}}
      *Collect = j;}

  free(Comp_set);
  free(disp_res);

   return;
}

/************************************************************************/
Show_round_xyz(xc,yc,zc,rad,Seg,Res,Atm)
      float xc,yc,zc; /* center for the search */
      float rad; /* radius for the search                   */
      char *Seg;
      char *Res;
      char *Atm;
/************************************************************************/
{
  extern int numat;
  extern int maxres1;
  extern int minres1;
  extern float *x,*y,*z;
  extern char *disp_list;
  extern int *ivector();

  static int *disp_res,*Comp_set,Comp_set_long;
  static int i,j,resij,atom_max;
  static int disp_atoms = 0;
  static float rad2;
  static char Res1[MAX_SEG_NAME_LEN];
  static char Res2[MAX_RES_NAME_LEN];
  static char OutText[BUFF_LEN];

  atom_max = atom_list_max();

  disp_res      = ivector(atom_max);

  rad2 = rad*rad;


  for(i = 0 ; i < mliste[mlist_deep - 1] ; i++) disp_res[i] = 0;

  for( i = mlists[0] ; i < mliste[mlist_deep - 1] ; i++) {


/* don't include atoms already selected */
  if(disp_res[i]) continue;

   resij = res1[i];
   strncpy(Res1,segment+MAX_SEG_NAME_LEN*i,MAX_SEG_NAME_LEN);
   strncpy(Res2,resnam +MAX_RES_NAME_LEN*i,MAX_RES_NAME_LEN);  

    if(   ( (x[i]-xc)*(x[i]-xc) 
          + (y[i]-yc)*(y[i]-yc)
          + (z[i]-zc)*(z[i]-zc))  < rad2 ) {
/* check the selection mode */
  if(selection_mode == 0) {
    for(j = mlists[0] ; j < mliste[mlist_deep - 1] ; j++) {
       if((!strncmp(Res1,segment+MAX_SEG_NAME_LEN*j,MAX_SEG_NAME_LEN)) && 
          (!strncmp(Res2,resnam +MAX_RES_NAME_LEN*j,MAX_RES_NAME_LEN)) &&
            (res1[j] == resij)) disp_res[j] = 1;}
  }
  else 
       disp_res[i] = 1;
  } }

  disp_atoms = 0;

  Comp_set      = ivector(atom_max);
  Comp_set_long = select_list(Seg,Res,Atm,Comp_set);

  if(Comp_set_long < 1) {
     PrintMessage("?ERROR - no atoms in the comparison set");
      free(disp_res);
       free(Comp_set);
        return;}


  for(i = 0 ; i < mliste[mlist_deep - 1] ; i++) {

      if(disp_res[i] == 1) {

      for(j = 0 ; j < Comp_set_long ; j++) {
          if(Comp_set[j] == i) {
            disp_atoms++;
            break;}}
    }}

  free(Comp_set);
  free(disp_res);

    PrintMessage("Number of atoms in the set is :");
    sprintf(OutText," %d",disp_atoms);
     PrintMessage(OutText);

   return;
}
/*

    Calculate the number of bytes in the file from the current
    file pointer to the end of the file.

    1992 LUL
*/
/************************************************************************/
int TellBytes(FilePointer)
    FILE *FilePointer;
/************************************************************************/
{
    int Where1,Where2;

    Where1 = ftell(FilePointer);

    if(fseek(FilePointer , 0L , SEEK_END)) {
       PrintMessage("?ERROR - can't determine end of file position");
       return(-1);};

    Where2 = ftell(FilePointer);

    return(Where2 - Where1);
}

/* 
     Calculate the centre of current displayed coordinates

     If alt != 0 Calculate new centre and make the translation

     If alt == 0 Calculate new centre but make no translation
*/
/***********************************************************************/
CalcCoordCentre(alt)  /* Calculate centre of given coordinates  */
     int alt;
/***********************************************************************/
{
     int i;
     float numsum;
     int from,to;
     char OutText[BUFF_LEN];

     float Tsumx,Tsumy,Tsumz;

       Tsumx=0.0; Tsumy=0.0; Tsumz=0.0;
       numsum = 0.0;

     from = mlists[0];
     to   = mliste[mlist_deep - 1];

       for(i = from ; i < to ; i++) {
       if(disp_list[i] == 0) continue;
       numsum = numsum + 1.;
       Tsumx = Tsumx + x[i]; 
        Tsumy = Tsumy + y[i]; 
         Tsumz = Tsumz + z[i]; }

       Tsumx = Tsumx/numsum; 
        Tsumy = Tsumy/numsum; 
         Tsumz = Tsumz/numsum;

   if(alt) {
     for(i = from ; i < to ; i++) {
      x[i] = x[i] - Tsumx; 
       y[i] = y[i] - Tsumy; 
        z[i] = z[i] - Tsumz; }

     sumx = Tsumy;
      sumy = Tsumy;
       sumz = Tsumz;
   }

     if(DebugS.DebugL) {
       sprintf(OutText,"Translating ... x: %f , y: %f , z: %f \n",
                        -Tsumx,-Tsumy,-Tsumz);
       PrintMessage(OutText);}

}
/***********************************************************************/
int GetStartUpWindow(IString)
    char *IString;
/***********************************************************************/
{

    int i,j;
    char ISparsed[MAXparse][MAXlinel];


    i = own_parser(IString , ISparsed , &j , "x");

    if(j < 3) {
      PrintMessage("?ERROR - please supply all parameters (-wXCxYCxXW[xYW])");
      return(1);}

    StartWindow.X = atoi(ISparsed[0]);
     StartWindow.Y = atoi(ISparsed[1]);

    StartWindow.XW = atoi(ISparsed[2]);
      StartWindow.YW = atoi(ISparsed[3]);
       
       if(StartWindow.YW < 1) StartWindow.YW = StartWindow.XW;

    if(StartWindow.X < 0 || StartWindow.Y < 0) {
      PrintMessage("?ERROR - in window coordinates (too small)");
      StartWindow.Set = 0;
      return(1);}

    if(StartWindow.XW < 1 || StartWindow.YW < 1) {
      PrintMessage("?ERROR - window is too small");
      StartWindow.Set = 0;
      return(1);}

/* ok return ... */

    StartWindow.Set = 1;

    return(0);
}
/***********************************************************************/
int InformIObytes()
/***********************************************************************/
{
    char OutText[BUFF_LEN];

    PrintMessage("     ****  I / O  I N F O  ****");
    sprintf(OutText,"     Write: %d Gbytes %d Kbytes",ProcessInfo.pu_gbwrit,
                                        ProcessInfo.pu_bwrit / 1000);
    PrintMessage(OutText);

    sprintf(OutText,"     Read : %d Gbytes %d Kbytes",ProcessInfo.pu_gbread,
                                        ProcessInfo.pu_bread / 1000);
    PrintMessage(OutText);

    return(0);
}

/***********************************************************************/
int LookRepField(InFields , InText)  /* look if the input field contains an 
                                        equal '%' sign 
                                        on return  0 is OK
                                                  !0 error */
    int  InFields;
    char InText[][MAXlinel];
/***********************************************************************/
{
    int i;

    if(InFields < 2) return(0);

    for(i = 1 ; i < InFields ; i++) {
        if(indexo(InText[3 * i], REP_CHAR) > 0) 
           strncpy(InText[3 * i] , InText[3 * (i - 1)] , MAX_SEG_NAME_LEN);
        if(indexo(InText[3 * i + 1], REP_CHAR) > 0) 
           strncpy(InText[3 * i + 1] , InText[3 * (i - 1) + 1] , 
                   MAX_RES_NAME_LEN);
        if(indexo(InText[3 * i + 2], REP_CHAR) > 0) 
           strncpy(InText[3 * i + 2] , InText[3 * (i - 1) + 2] , 
                   MAX_ATM_NAME_LEN);
     }
     return(0);
}
/*

     Trajectory frames run from 0 to N-1

     Leif Laaksonen 1992-12-04
*/

/***********************************************************************/
int GetNumFrames()
/***********************************************************************/
{
  if(!TrajFrame.Set) return(-1);

  return((TrajFrame.LastFrame - TrajFrame.FirstFrame)/TrajFrame.StepFrame);
}
/***********************************************************************/
int GetFirstFrame()
/***********************************************************************/
{
    if(!TrajFrame.Set) return(-1);

    return(TrajFrame.FirstFrame);

}
/***********************************************************************/
int PutFirstFrame(Iframe)
    int Iframe;
/***********************************************************************/
{

    TrajFrame.FirstFrame = Iframe;

    return(0);
}
/***********************************************************************/
int GetLastFrame()
/***********************************************************************/
{
    if(!TrajFrame.Set) return(-1);

    return(TrajFrame.LastFrame);

}
/***********************************************************************/
int PutLastFrame(Iframe)
    int Iframe;
/***********************************************************************/
{

    TrajFrame.LastFrame = Iframe;

    return(0);
}
/***********************************************************************/
int GetStepFrame()
/***********************************************************************/
{
    if(!TrajFrame.Set) return(-1);

    return(TrajFrame.StepFrame);

}
/***********************************************************************/
int PutStepFrame(Iframe)
    int Iframe;
/***********************************************************************/
{

    TrajFrame.StepFrame = Iframe;

    return(0);
}
/***********************************************************************/
int ShowFrameStat()
/***********************************************************************/
{
    static char OutText[BUFF_LEN];

    if(!TrajFrame.Set) {
        PrintMessage("?ERROR - Trajectory limits not defined");
        return(1);}

    PrintMessage("** Trajectory frame statistics ***");
    sprintf(OutText,"First frame: %d",TrajFrame.FirstFrame);
    PrintMessage(OutText);
    sprintf(OutText,"Last frame:  %d",TrajFrame.LastFrame);
    PrintMessage(OutText);
    sprintf(OutText,"Step frame:  %d",TrajFrame.StepFrame);
    PrintMessage(OutText);

    return(0);
}
/***********************************************************************/
int CheckFrames(Iframe , Istep)
    int Iframe;
    int Istep;
/***********************************************************************/
{
    static char OutText[BUFF_LEN];

    if(!TrajFrame.Set) {
        PrintMessage("?ERROR - Trajectory limits not defined");
        return(1);}

    if(Iframe < TrajFrame.LastFrame) {
      sprintf(OutText,"?WARNING - NumFrames (file) %d  < last frame def %d",
             Iframe,TrajFrame.LastFrame);
      PrintMessage(OutText);
      TrajFrame.LastFrame = Iframe;}

    if(Istep > (TrajFrame.LastFrame - TrajFrame.FirstFrame)) {
                TrajFrame.StepFrame = 
                TrajFrame.LastFrame - TrajFrame.FirstFrame;}

    TrajFrame.Set = 1; /* set from now*/

    return(0);
}
/***********************************************************************/
int ResetFrame()
/***********************************************************************/
{
    TrajFrame.Set        = 0;
    TrajFrame.LastFrame  = 0;
    TrajFrame.FirstFrame = 0;
    TrajFrame.StepFrame  = 1;

    return(0);
}
/***********************************************************************/
int SetFrame(Ifirst,Ilast,Istep)
/***********************************************************************/
{
    if(TrajFrame.Set) return(0);

    if(Ifirst < 1) Ifirst = 1;
    (void) PutFirstFrame(Ifirst);

    (void) PutLastFrame(Ilast);

    if(Istep < 1) Istep = 1;
    (void) PutStepFrame(Istep);

    (void) CheckFrames(Ilast,Istep);

}
/***********************************************************************/
CalcMolDimensions()
/***********************************************************************/
{

      int i;

 /* Calculate min and max of the x,y and z coordinates  */

      minx=1.e+30; maxx= -1.e+30;
      miny=1.e+30; maxy= -1.e+30;
      minz=1.e+30; maxz= -1.e+30;

      for(i = mlists[0] ; i < mliste[mlist_deep - 1] ; i++) {
       if(x[i] < minx)  minx=x[i];
       if(x[i] > maxx)  maxx=x[i];

       if(y[i] < miny)  miny=y[i];
       if(y[i] > maxy)  maxy=y[i];

       if(z[i] < minz)  minz=z[i];
       if(z[i] > maxz)  maxz=z[i]; 
       }


/* set default cell dimensions */
     cell.alpha = 90.;
      cell.beta = 90.;
       cell.gamma = 90.;
     cell.a = cell.b = cell.c = 1.e+20;

/*
     cell.a = cell.b = cell.c = 
     (MAX( maxz , MAX(maxx , maxy))) - 
     (MIN( minz , MIN(minx , miny)));
*/
     cell.Xtrans = cell.Ytrans = cell.Ztrans = 0.0;

/* To prevent clipping in case of rotating a box (periodic boundary conditions)
   the clipping plane is calculated to the edge of the box ( sqrt(2)*r ) */

       minx=(minx > 0.0 ? minx*0.67 : minx*1.41);
       maxx=(maxx < 0.0 ? maxx*0.67 : maxx*1.41);
       miny=(miny > 0.0 ? miny*0.67 : miny*1.41);
       maxy=(maxy < 0.0 ? maxy*0.67 : maxy*1.41);
       minz=(minz > 0.0 ? minz*0.67 : minz*1.41);
       maxz=(maxz < 0.0 ? maxz*0.67 : maxz*1.41);


       near = MIN( minz , MIN(minx , miny));
       far  = MAX( maxz , MAX(maxx , maxy));

/* 
    LUL 1992-04-21 put abs(far) = abs(near)
*/
       far  =   MAX(Fabs(far) , Fabs(near));
       near = - far;

/*  ok done ...                                                     */

       return(0);
}
/***********************************************************************/
char *GetInsideLim(ParseString , ParseWith)
    char  *ParseString;
    char  *ParseWith;
/***********************************************************************/
{

    int     i;
    PARSING ParseStuff;
    static char OutStuff[BUFF_LEN];


    strncpy(ParseStuff.IString,ParseString,BUFF_LEN);
    strncpy(ParseStuff.IParse ,ParseWith  ,BUFF_LEN);

    i = own_parser( ParseStuff.IString , 
                    ParseStuff.ISparsed , 
                   &ParseStuff.IParams , 
                    ParseStuff.IParse);
printf("'%s' '%s' '%s' %d\n",ParseStuff.IString,ParseStuff.ISparsed,ParseStuff.IParse,ParseStuff.IParams);

      strncpy(OutStuff,ParseStuff.ISparsed[0],BUFF_LEN);

/* okay return ... */
    return(OutStuff);
}
/***********************************************************************/
int GetStringLenPAR(InText)
    char *InText;
/***********************************************************************/
{
    char LPA = '(';
    int  iLPA = 0;
    char RPA = ')';
    int  iRPA = 0;
    char *RunP;
    int  Ilen;

    int i;

    RunP = InText;
    Ilen = strlen(InText);

    if(Ilen < 1)     return(0);
    if(*RunP != LPA) return(0);

    for(i = 0 ; i < Ilen ; i++) {
       if(*RunP == LPA) iLPA++;
       if(*RunP == RPA) iRPA++;
     if(!(iLPA - iRPA)) return(i+1);
       RunP++;
    }

    return(0);
}

/*
     Check the text string if it is a number

*/
/***********************************************************************/
int IsNumber(InText)
    char *InText;
/***********************************************************************/
{
    register int i;
    static   int Numbers;
    static   int Characters;

                   if(InText[0] == '+') return(1); /* yes */
                   if(InText[0] == '-') return(1); /* yes */
                   if(InText[0] == '.') return(1); /* yes */

    Numbers = Characters = 0;

    for(i = 0 ; i < strlen(InText) ; i++)  {
                   if(InText[i] == '.') return(1);  /* yes */
                   if(isalpha(InText[i])) Characters++;
                   if(isdigit(InText[i])) Numbers++;
    }
                   if(Numbers && !Characters) return(1);
    return(0);
}

/*   Subroutine bangle          */
/*   Calculate the angle between atoms i,j and k
     using c2=a2+b2-2ab*cos(angle)
     and calculate the bond lengths i-j and j-k.

     leif laaksonen   1993

     takes the x,y anz coordinates as parameters

*/

/***********************************************************************/
void Bangle( ix , iy , iz , 
             jx , jy , jz ,
             kx , ky , kz , angijk )  /* calculate bond angle */
float  ix,iy,iz;
float  jx,jy,jz;
float  kx,ky,kz;
float *angijk ;
/***********************************************************************/
{
static double d2ij,d2jk,d2ik,tmp1,tmp2,tmp3,temp;

            tmp1 = (ix-jx);
            tmp2 = (iy-jy);
            tmp3 = (iz-jz);

       d2ij= tmp1 * tmp1 +
             tmp2 * tmp2 +
             tmp3 * tmp3;

            tmp1 = (jx-kx);
            tmp2 = (jy-ky);
            tmp3 = (jz-kz);

       d2jk= tmp1 * tmp1 +
             tmp2 * tmp2 +
             tmp3 * tmp3;

            tmp1 = (ix-kx);
            tmp2 = (iy-ky);
            tmp3 = (iz-kz);

       d2ik= tmp1 * tmp1 +
             tmp2 * tmp2 +
             tmp3 * tmp3;

       temp =  0.5*(d2ij+d2jk-d2ik)/sqrt(d2ij*d2jk);

       *angijk= ( temp >  1. ?  1. : temp);
       *angijk= ( temp < -1. ? -1. : temp);

       *angijk = acos( *angijk ) ;

}
/***********************************************************************/
int SaveCoordinates(int WhichSet)
/***********************************************************************/
{
    int i;

    if(SavedCoordinates.Saved) { /* delete old one */
       DeleteOldSavedCoord();}

    SavedCoordinates.XCoord = vector(mliste[0] - mlists[0]);
    SavedCoordinates.YCoord = vector(mliste[0] - mlists[0]);
    SavedCoordinates.ZCoord = vector(mliste[0] - mlists[0]);

    for(i = mlists[0] ; i < mliste[0] ; i++) {
        SavedCoordinates.XCoord[i] = x[i];
        SavedCoordinates.YCoord[i] = y[i];
        SavedCoordinates.ZCoord[i] = z[i];}

    SavedCoordinates.Saved = 1;
    SavedCoordinates.Atoms = mliste[0] - mlists[0];
}
    
/***********************************************************************/
int DeleteOldSavedCoord()
/***********************************************************************/
{
    free(SavedCoordinates.XCoord);
    free(SavedCoordinates.YCoord);
    free(SavedCoordinates.ZCoord);

    SavedCoordinates.Saved = 0;

    return(0);
}
/***********************************************************************/
int GetSavedCoord()
/***********************************************************************/
{
    int i;

    if(SavedCoordinates.Atoms != (mliste[0] - mlists[0])) {
       PrintMessage("?ERROR - saved atom list does not match current list");
       return(1);}

    for(i = mlists[0] ; i < mliste[0] ; i++) {
        x[i] = SavedCoordinates.XCoord[i];
        y[i] = SavedCoordinates.YCoord[i];
        z[i] = SavedCoordinates.ZCoord[i];}

    (void)DeleteOldSavedCoord();

    return(0);


}
/***********************************************************************/
int CheckOldSelList(Index , Total , List)
    int Index;
    int Total;
    int *List;
/***********************************************************************/
{
    register int i;

    for(i = 0 ; i < Total ; i++) {
        if(List[i] == Index) 
           return(1);  /* already in list */
    }
    
    return(0);
}      
