 
/*************************************************************************\
*                                                                         *
*  FILE:  cursors.h                                                       *
*                                                                         *
*  DESCRIPTION:  include file containing cursor pattern definitions       *
*                This should give a good start to your own creative       *
*                flights of fantasy.  Note that the multi-color           *
*                cursors are useless on the 4D-2x series :-(              *
*                                                                         *
*  I'll take the credit, you take the blame! tomm@voodoo.boeing.com  ;^)  *
*                                                                         *
\*************************************************************************/
 
 
/*
** The following pattern definitions must be flipped 180 degrees to
** provide proper input to defcursor().  Use either flip_C16X1() or
** filp_C16X2() to flip the cursor array from its visual orientation
** to the proper input orientation.
*/
 
static
unsigned short	cir_target[2][16] =	/* RED border, YELLOW target */
	{						/* 1's bits RED */
	    __		_ _ _ _ _ X X X X X _ _ _ _ _ _		,
	    __		_ _ _ X X X X X X X X X _ _ _ _		,
	    __		_ _ X X X _ _ _ _ _ X X X _ _ _		,
	    __		_ X X _ _ _ _ _ _ _ _ _ X X _ _		,
	    __		_ X X _ _ _ _ _ _ _ _ _ X X _ _		,
	    __		X X _ _ _ _ _ _ _ _ _ _ _ X X _		,
	    __		X X _ _ _ _ _ _ _ _ _ _ _ X X _		,
	    __		X X _ _ _ _ _ _ _ _ _ _ _ X X _		,
	    __		X X _ _ _ _ _ _ _ _ _ _ _ X X _		,
	    __		X X _ _ _ _ _ _ _ _ _ _ _ X X _		,
	    __		_ X X _ _ _ _ _ _ _ _ _ X X _ _		,
	    __		_ X X _ _ _ _ _ _ _ _ _ X X _ _		,
	    __		_ _ X X X _ _ _ _ _ X X X _ _ _		,
	    __		_ _ _ X X X X X X X X X _ _ _ _		,
	    __		_ _ _ _ _ X X X X X _ _ _ _ _ _		,
	    __		_ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _		,
 
							/* 2's bits YELLOW */
	    __		_ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _		,
	    __		_ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _		,
	    __		_ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _		,
	    __		_ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _		,
	    __		_ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _		,
	    __		_ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _		,
	    __		_ _ _ _ _ _ _ X _ _ _ _ _ _ _ _		,
	    __		_ _ _ _ _ _ X X X _ _ _ _ _ _ _		,
	    __		_ _ _ _ _ _ _ X _ _ _ _ _ _ _ _		,
	    __		_ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _		,
	    __		_ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _		,
	    __		_ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _		,
	    __		_ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _		,
	    __		_ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _		,
	    __		_ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _		,
	    __		_ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _
	};
 
static
unsigned short	x_target_1[1][16] =
	{
	    __		_ _ _ X X X X X X X X X _ _ _ _		,
	    __		_ _ _ _ X X X X X X X _ _ _ _ _		,
	    __		_ _ _ _ _ X X X X X _ _ _ _ _ _		,
	    __		X _ _ _ _ _ X X X _ _ _ _ _ X _		,
	    __		X X _ _ _ _ _ X _ _ _ _ _ X X _		,
	    __		X X X _ _ _ _ _ _ _ _ _ X X X _		,
	    __		X X X X _ _ _ _ _ _ _ X X X X _		,
	    __		X X X X X _ _ _ _ _ X X X X X _		,
	    __		X X X X _ _ _ _ _ _ _ X X X X _		,
	    __		X X X _ _ _ _ _ _ _ _ _ X X X _		,
	    __		X X _ _ _ _ _ X _ _ _ _ _ X X _		,
	    __		X _ _ _ _ _ X X X _ _ _ _ _ X _		,
	    __		_ _ _ _ _ X X X X X _ _ _ _ _ _		,
	    __		_ _ _ _ X X X X X X X _ _ _ _ _		,
	    __		_ _ _ X X X X X X X X X _ _ _ _		,
	    __		_ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _
	};
 
 
static
unsigned short	clock[1][16] =
	{
	    __		_ _ _ _ _ X X X X X X _ _ _ _ _		,
	    __		_ _ _ X X _ _ _ _ _ _ X X _ _ _		,
	    __		_ _ X X _ _ _ X X _ _ _ X X _ _		,
	    __		_ X X _ _ _ _ _ _ _ _ _ _ X X _		,
	    __		_ X _ _ _ _ _ _ _ _ _ _ _ _ X _		,
	    __		X _ _ _ _ X _ _ _ _ _ _ _ _ _ X		,
	    __		X _ _ _ _ _ X _ _ _ _ _ _ _ _ X		,
	    __		X _ X _ _ _ _ X X _ _ _ _ X _ X		,
	    __		X _ X _ _ _ _ X X _ _ _ _ X _ X		,
	    __		X _ _ _ _ _ _ _ X _ _ _ _ _ _ X		,
	    __		X _ _ _ _ _ _ _ _ X _ _ _ _ _ X		,
	    __		_ X _ _ _ _ _ _ _ X _ _ _ _ X _		,
	    __		_ X X _ _ _ _ _ _ _ X _ _ X X _		,
	    __		_ _ X X _ _ _ X X _ X _ X X _ _		,
	    __		_ _ _ X X _ _ _ _ _ _ X X _ _ _		,
	    __		_ _ _ _ _ X X X X X X _ _ _ _ _
	};
 
static
unsigned short	hourglass[2][16] =	  /* RED hourglass, YELLOW sand */
	{						/* 1's bits RED */
	    __		_ X X X X X X X X X X X X X _ _		,
	    __		_ X X X X X X X X X X X X X _ _		,
	    __		_ _ _ X X _ _ _ _ _ X X _ _ _ _		,
	    __		_ _ _ X X _ _ _ _ _ X X _ _ _ _		,
	    __		_ _ _ X X _ _ _ _ _ X X _ _ _ _		,
	    __		_ _ _ X X X _ _ _ X X X _ _ _ _		,
	    __		_ _ _ _ _ X X _ X X _ _ _ _ _ _		,
	    __		_ _ _ _ _ _ _ X _ _ _ _ _ _ _ _		,
	    __		_ _ _ _ _ _ _ X _ _ _ _ _ _ _ _		,
	    __		_ _ _ _ _ X X _ X X _ _ _ _ _ _		,
	    __		_ _ _ X X X _ _ _ X X X _ _ _ _		,
	    __		_ _ _ X X _ _ _ _ _ X X _ _ _ _		,
	    __		_ _ _ X X _ _ _ _ _ X X _ _ _ _		,
	    __		_ _ _ X X _ _ _ _ _ X X _ _ _ _		,
	    __		_ X X X X X X X X X X X X X _ _		,
	    __		_ X X X X X X X X X X X X X _ _		,
							/* 2's bits YELLOW */
	    __		_ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _		,
	    __		_ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _		,
	    __		_ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _		,
	    __		_ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _		,
	    __		_ _ _ _ _ X X _ X X _ _ _ _ _ _		,
	    __		_ _ _ _ _ _ _ X _ _ _ _ _ _ _ _		,
	    __		_ _ _ _ _ _ _ X _ _ _ _ _ _ _ _		,
	    __		_ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _		,
	    __		_ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _		,
	    __		_ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _		,
	    __		_ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _		,
	    __		_ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _		,
	    __		_ _ _ _ _ _ _ X _ _ _ _ _ _ _ _		,
	    __		_ _ _ _ _ _ X X X _ _ _ _ _ _ _		,
	    __		_ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _		,
	    __		_ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _
	};
 
static
unsigned short	martini[2][16] =	   /* RED swizzle, YELLOW glass */
	{						/* 1's bits RED */
	    __		X _ _ _ _ _ _ _ _ _ _ _ _ _ _ X		,
	    __		_ X _ _ _ _ _ _ _ _ _ _ _ _ X _		,
	    __		_ _ X X X X X X X _ _ X X X _ _		,
	    __		_ _ _ X _ _ _ _ _ _ _ _ X _ _ _		,
	    __		_ _ _ _ X _ _ _ _ _ _ X _ _ _ _		,
	    __		_ _ _ _ _ X _ _ _ _ X _ _ _ _ _		,
	    __		_ _ _ _ _ _ X _ _ X _ _ _ _ _ _		,
	    __		_ _ _ _ _ _ _ X X _ _ _ _ _ _ _		,
	    __		_ _ _ _ _ _ _ X X _ _ _ _ _ _ _		,
	    __		_ _ _ _ _ _ _ X X _ _ _ _ _ _ _		,
	    __		_ _ _ _ _ _ _ X X _ _ _ _ _ _ _		,
	    __		_ _ _ _ _ _ _ X X _ _ _ _ _ _ _		,
	    __		_ _ _ _ _ _ _ X X _ _ _ _ _ _ _		,
	    __		_ _ _ _ _ _ _ X X _ _ _ _ _ _ _		,
	    __		_ _ _ _ _ _ _ X X _ _ _ _ _ _ _		,
	    __		_ _ _ X X X X X X X X X X _ _ _		,
							/* 2's bits YELLOW */
	    __		_ _ _ _ _ _ _ _ _ _ _ X _ _ _ _		,
	    __		_ _ _ _ _ _ _ _ _ _ X _ _ _ _ _		,
	    __		_ _ _ _ _ _ _ _ _ X _ _ _ _ _ _		,
	    __		_ _ _ _ _ _ _ _ X _ _ _ _ _ _ _		,
	    __		_ _ _ _ _ _ X X _ _ _ _ _ _ _ _		,
	    __		_ _ _ _ _ _ X X _ _ _ _ _ _ _ _		,
	    __		_ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _		,
	    __		_ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _		,
	    __		_ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _		,
	    __		_ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _		,
	    __		_ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _		,
	    __		_ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _		,
	    __		_ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _		,
	    __		_ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _		,
	    __		_ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _		,
	    __		_ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _
	};
 
static
unsigned short	coffee_cup[1][16] =
	{
	    __		_ _ _ _ X _ _ X _ _ _ _ _ _ _ _		,
	    __		_ _ _ _ _ X _ _ X _ _ _ _ _ _ _		,
	    __		_ _ _ _ _ X _ _ X _ _ _ _ _ _ _		,
	    __		_ _ _ _ _ _ X _ _ X _ _ _ _ _ _		,
	    __		_ _ _ _ X X X X X X _ _ _ _ _ _		,
	    __		_ _ X X _ X _ _ X _ X X _ _ _ _		,
	    __		_ X _ _ _ X _ _ X _ _ _ X _ X _		,
	    __		_ X _ _ _ _ _ _ _ _ _ _ X X _ X		,
	    __		_ X X X _ _ _ _ _ _ X X X _ _ X		,
	    __		_ X _ _ X X X X X X _ _ X _ _ X		,
	    __		_ _ X _ _ _ _ _ _ _ _ X _ _ _ X		,
	    __		_ _ X _ _ _ _ _ _ _ _ X _ _ X _		,
	    __		_ _ X _ _ _ _ _ _ _ _ X _ X _ _		,
	    __		_ _ X _ _ _ _ _ _ _ _ X X _ _ _		,
	    __		_ _ X X _ _ _ _ _ _ X X _ _ _ _		,
	    __		_ _ _ _ X X X X X X _ _ _ _ _ _
	};
 
 
static
unsigned short	circle_dot[1][16] =
	{
	    __		_ _ _ _ _ X X X X X _ _ _ _ _ _		,
	    __		_ _ _ X X X X X X X X X _ _ _ _		,
	    __		_ _ X X X _ _ _ _ _ X X X _ _ _		,
	    __		_ X X _ _ _ _ _ _ _ _ _ X X _ _		,
	    __		_ X X _ _ _ _ _ _ _ _ _ X X _ _		,
	    __		X X _ _ _ _ _ _ _ _ _ _ _ X X _		,
	    __		X X _ _ _ _ _ _ _ _ _ _ _ X X _		,
	    __		X X _ _ _ _ _ X _ _ _ _ _ X X _		,
	    __		X X _ _ _ _ _ _ _ _ _ _ _ X X _		,
	    __		X X _ _ _ _ _ _ _ _ _ _ _ X X _		,
	    __		_ X X _ _ _ _ _ _ _ _ _ X X _ _		,
	    __		_ X X _ _ _ _ _ _ _ _ _ X X _ _		,
	    __		_ _ X X X _ _ _ _ _ X X X _ _ _		,
	    __		_ _ _ X X X X X X X X X _ _ _ _		,
	    __		_ _ _ _ _ X X X X X _ _ _ _ _ _		,
	    __		_ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _
	};
 
 
static
unsigned short	blank[1][16] =
	{
	    __		_ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _		,
	    __		_ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _		,
	    __		_ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _		,
	    __		_ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _		,
	    __		_ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _		,
	    __		_ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _		,
	    __		_ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _		,
	    __		_ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _		,
	    __		_ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _		,
	    __		_ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _		,
	    __		_ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _		,
	    __		_ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _		,
	    __		_ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _		,
	    __		_ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _		,
	    __		_ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _		,
	    __		_ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _
	};
 
 

