/*  

                       Copyright (c) 1990, 1992 by:
        Leif Laaksonen , Centre for Scientific Computing, ESPOO, FINLAND
            Confidential unpublished property of Leif Laaksonen
                        All rights reserved
  

*/

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#ifdef sgi
#include <gl/gl.h>
#include <device.h>
#endif
#include <math.h>
#include "maxdefs.h"
#include "isovis.h"

#define TRANSLATE(a,b,c) translateO(a,b,c) /* use own translation function */

     extern void PrintMessage();
     extern void MakeOrtho();
     extern int name_to_rgb();
     extern char parsed[MAXparse][MAXlinel];
     extern int numat;
     extern short obcolor[];
     extern short txcolor[];
     extern float near;
     extern float far;
     extern float sumx,sumy,sumz;
     extern void translateO();
     extern int own_parser();
     extern int show_text();
     extern int video_mode;

/* double/single buffer controller                          */
   extern struct {
   char Changed;       /* if > 0 mode has changed               */
   int BufferMode;     /* 1 = single buffer , 2 = double buffer */
   } DBuffer;

/* contour structure */
     int    ContoursDefined = 0;   /* number of contours defined */

     struct Contour_Struct {
     float *data;           /* contour data */
     float min;
     float max;
     int xdim;
     int ydim;
     int zdim;
     float Xtrans;
     float Ytrans;
     float Ztrans;
     float Xscale;
     float Yscale;
     float Zscale;
     float ColVal[MAX_CONT];
     int   NumVal;
     char  ColNam[MAX_CONT][BUFF_LEN];
     char  ContFile[BUFF_LEN];
     float AlphaBlend;
     int   ContSmooth;
     char  Name[BUFF_LEN];
     int   Display;} ContourInfo[MAX_CONTOURS];

/************************************************************************/
contour_fac(input,num)   /* contour command */
   char *input; 
   int num;
/************************************************************************/
{

     int i;
     char OutText[BUFF_LEN];
     float fhelp;

/* help contour                               */
   if(indexo(parsed[1],"?") == 1) {
   PrintMessage("***** Contour facility *****");
   PrintMessage("cont*our file.name tag       ! Define contour file and tag");
   return;}

/* contour                                    */
   if(parsed[1][0] != '\0') {
      i = ContourDriver(parsed[1] , parsed[2]);
   return;
   }

   if(parsed[1][0] == '\0') {
   PrintMessage("?ERROR - contour file name missing");
   return;}

/* default position "command not recognized"  */

     sprintf(OutText,"?ERROR: Following command not recognized: %s \n",input);
     PrintMessage(OutText);

}      /* end of contour_fac */

/************************************************************************/
int  ContourDriver(ContFile,ContName)
     char *ContFile;
     char *ContName;
/************************************************************************/
{
     static float *Cdata;
     static int    Cxdim;
     static int    Cydim;
     static int    Czdim;
     static float  Cmax;
     static float  Cmin;
     static int i,j;
     static char OutText[BUFF_LEN];


     if(ContoursDefined == MAX_CONTOURS) {
        PrintMessage("?ERROR - Max number of contour files defined");
        return(-1);}

/* get the data from file ... */

  if (get_data(ContFile,&Cdata,
                        &Cxdim,
                        &Cydim,
                        &Czdim) == -1) {
     PrintMessage("Error from get_data");
     return(-1);
  }

/* save grabbed information */
     ContourInfo[ContoursDefined].xdim = Cxdim;
      ContourInfo[ContoursDefined].ydim = Cydim;
       ContourInfo[ContoursDefined].zdim = Czdim;
        ContourInfo[ContoursDefined].data = Cdata;

  strncpy(ContourInfo[ContoursDefined].ContFile,ContFile,BUFF_LEN);

  get_max_min(ContourInfo[ContoursDefined].data,
                               ContourInfo[ContoursDefined].xdim,
                               ContourInfo[ContoursDefined].ydim,
                               ContourInfo[ContoursDefined].zdim,
                               &Cmax,
                               &Cmin);

     ContourInfo[ContoursDefined].max = Cmax;
      ContourInfo[ContoursDefined].min = Cmin;

     sprintf(OutText,"Minimum value %f maximum value %f",Cmin,Cmax);
     PrintMessage(OutText);

/* ready with the file ...  */

/* look if there are some contours already defined */

        ContourInfo[ContoursDefined].NumVal         = 0;
         ContourInfo[ContoursDefined].Display       = 0;
          ContourInfo[ContoursDefined].ContSmooth   = 0;
           ContourInfo[ContoursDefined].AlphaBlend  = 1.;

     if(ContName[0] == '\0') { /* no contour name defined */
        sprintf(OutText,"%d",ContoursDefined+1);
        strncpy(ContourInfo[ContoursDefined].Name,OutText,BUFF_LEN);}
     else {
        strncpy(ContourInfo[ContoursDefined].Name,ContName,BUFF_LEN);}

     ContoursDefined++;

     return;

#ifdef OBSOLETE

     ContourInfo.ColVal[0] = 0.0;
     strncpy(ContourInfo.ColNam,"white",BUFF_LEN);

   i = 0;
   while(1) {
     if((i+1) == MAX_CONT) {
       PrintMessage("?ERROR - max contour levels reached");
       break;} 
     if(parsed[2+i+i][0] == '\0') break;
     ContourInfo.ColVal[i] = atof(parsed[2+i+i]);

/* test for allowed values ... */

  if ((ContourInfo.ColVal[i] < Cmin) || (Cmax < ContourInfo.ColVal[i] )) {
     sprintf(OutText,"Minimum value %f maximum value %f",Cmin,Cmax);
     PrintMessage(OutText);
     PrintMessage("Error, threshold must be between the maximum");
     PrintMessage("and minimum data values.");
     continue;
     }

/* done ... */

      if(parsed[3+i+i][0] == '\0') strncpy(parsed[3+i+i],"white",BUFF_LEN);
      strncpy(ContourInfo.ColNam[i],parsed[3+i+i],BUFF_LEN);
       sprintf(OutText,"Looking for threshold %f in colour '%s'",
               ContourInfo.ColVal[i],ContourInfo.ColNam[i]);
       PrintMessage(OutText);
       i++;}

       if(i < 1) {
         PrintMessage("?ERROR - no contour levels defined ");
         return;}

       ContourInfo.NumVal = i;

#endif

}

/************************************************************************/
PlotIsoSurf()
/************************************************************************/
{
#if defined(sgi)
  static int i,j,k;
  static int ColC[3];
  static float ContVal;
  static float DefAlphaBlend[] =
               {ALPHA , 0.5 , LMNULL};

  static long  SetRGBA[4];
  char ColPar[MAXparse][MAXlinel];
  int ColI;
  static int SayCol[3] = {255 , 255 , 0};

      if(ContoursDefined < 1) {
        PrintMessage("?ERROR - no contours defined ");
        return;}

   backface(FALSE);

      mmode(MVIEWING); 

   for(k = 0 ; k < ContoursDefined ; k++) {

      if(!ContourInfo[k].Display) continue;

      pushmatrix();

      translate(ContourInfo[k].Xtrans ,
                ContourInfo[k].Ytrans ,
                ContourInfo[k].Ztrans);

      scale(ContourInfo[k].Xscale ,
            ContourInfo[k].Yscale ,
            ContourInfo[k].Zscale);


/*     glcompat(GLC_OLDPOLYGON);*/
      backface(FALSE);

         if(ContourInfo[k].AlphaBlend < 1.0) 
            blendfunction(BF_SA , BF_MSA);
         else
            blendfunction(BF_ONE, BF_ZERO);



/* change cursor ...    */
   setcursor(CURS_TYPE);
/* show some text */
   if(DBuffer.BufferMode == 2 && !video_mode)
      i = show_text("Working ...","Helvetica",SayCol,15.,0.8,0.9,FRONTBUFFER);

  for(i = 0 ; i < ContourInfo[k].NumVal ; i++) {

     ContVal = ContourInfo[k].ColVal[i];

     j = name_to_rgb(ContourInfo[k].ColNam[i],&ColC[0],&ColC[1],&ColC[2]);

         if(j) continue; /* name not found */


      lmcolor(LMC_DIFFUSE);

        SetRGBA[0] = ColC[0];
         SetRGBA[1] = ColC[1];
          SetRGBA[2] = ColC[2];
           SetRGBA[3] = (long)(255.*ContourInfo[k].AlphaBlend);
            c4i(SetRGBA);

      lmcolor(LMC_COLOR);

     NORMAL_TYPE = 0;           /* default type OFF */

     if(ContourInfo[k].ContSmooth) NORMAL_TYPE = ContourInfo[k].ContSmooth;

     if (iso_surface(ContourInfo[k].data,
                  ContourInfo[k].xdim,
                  ContourInfo[k].ydim,
                  ContourInfo[k].zdim,
                  ContVal) == -1) {
     PrintMessage("Error from iso_surface");
     /* change cursor back ...    */
       setcursor(0);
        MakeOrtho();
         popmatrix();
          if(DBuffer.BufferMode == 2) 
                             backface(TRUE);
          blendfunction(BF_ONE , BF_ZERO);

          mmode(MVIEWING); 
     return(1);
     } 

     if(SMOOTH) {
              smooth_norms();
              NORMAL_TYPE = 1;}

     if(DISPLAY) 
                dump_sgi();
   }


/* change cursor back ...    */
       setcursor(0);

       MakeOrtho();

       popmatrix();

       if(DBuffer.BufferMode == 2) 
                          backface(TRUE);

        blendfunction(BF_ONE , BF_ZERO);

      }
          mmode(MVIEWING); 
#endif
}











