 
/*
************************************************************************
*                                                                      *
*  FILE:  cursors.c                                                    *
*                                                                      *
*  DESCRIPTION: Implementation file for cursor creation routines       *
*                                                                      *
************************************************************************
*/
 
#include <stdio.h>
#ifdef sgi
#include <device.h>
#include <gl.h>
#endif
#include "bit_defs.h"
#include "cursors.h"
 
void flip_C16X1(c_array)
unsigned short	 c_array[][16];
{
    register
    int		 i, j;
 
    unsigned short tmp_array[1][16];
 
    for (i=0; i<16; i++)
	tmp_array[0][i] = c_array[0][i];
 
    j = 15;
    for (i=0; i<16; i++)
    {
	c_array[0][i] = tmp_array[0][j];
	j--;
    }
}
 
void flip_C16X2(c_array)
unsigned short	 c_array[][16];
{
    register
    int		 h, i, j;
 
    unsigned short tmp_array[2][16];
 
    for (h=0; h<2; h++)
    {
	for (i=0; i<16; i++)
	{
	    tmp_array[h][i] = c_array[h][i];
	}
    }
 
    for (h=0; h<2; h++)
    {
	j = 15;
	for (i=0; i<16; i++)
	{
	    c_array[h][i] = tmp_array[h][j];
	    j--;
	}
    }
}
 
/*
** flip_C32X[12] left as an excercise for the reader!
*/

 
void map_cursor_colors()
{

#ifdef JUNK
    mapcolor(1, 255,   0,   0);	/* RED */
    mapcolor(2, 255, 255,   0);	/* YELLOW */
    mapcolor(3,   0,   0, 255);	/* BLUE */
#endif
}

void init_cursors()
{
    long	saved_mode;
 
#ifdef sgi
    saved_mode = getdrawmode();
    drawmode(CURSORDRAW);
 
    map_cursor_colors();
 
    curstype(C16X2);
 
    flip_C16X2(cir_target);
    defcursor(1, cir_target);
    curorigin(1, 7, 8);
 
    flip_C16X2(hourglass);
    defcursor(2, hourglass);
    curorigin(2, 7, 7);
 
    flip_C16X2(martini);
    defcursor(3, martini);
    curorigin(3, 7, 8);
 
    curstype(C16X1);
 
    flip_C16X1(x_target_1);
    defcursor(4, x_target_1);
    curorigin(4, 7, 8);
 
    flip_C16X1(clock);
    defcursor(5, clock);
    curorigin(5, 7, 8);
 
    flip_C16X1(coffee_cup);
    defcursor(6, coffee_cup);
    curorigin(6, 7, 7);
 
    flip_C16X1(circle_dot);
    defcursor(7, circle_dot);
    curorigin(7, 7, 8);
 
    defcursor(8, blank);
    curorigin(8, 7, 8);
 
    drawmode(saved_mode);
#else
    PrintMessage("?ERROR - not implemented on this device ");
#endif
}
