/*  

                       Copyright (c) 1990,1993 by:
        Leif Laaksonen , Center for Scientific Computing, ESPOO, FINLAND
            Confidential unpublished property of Leif Laaksonen
                        All rights reserved
  

*/

#include <stdio.h>
#include <math.h>
#include <malloc.h>
#include "maxdefs.h"

   extern float *x,*y,*z;
   extern int numat;
   extern float sumx,sumy,sumz;
   extern int current_struct;
   extern float *vector();
   extern int atom_list_max();
   extern void PrintMessage();
   extern int TrajectoryLastFrame();
   extern int TrajectoryFirstFrame();
   extern int TrajectoryStepFrame();
   extern int FramesInSet();

   extern FILE *charmm_oc;

/* structure for the dynamics trajectory file */

   extern struct {
    char traj_file[BUFF_LEN];                 /* file name          */
    int natom;                                /* number of atoms    */
    int nstep;                                /* number of steps    */
    int time_bw_steps;                        /* time between steps */
    int time_first_frame;                     /* time of first frame */
    int first_frame;                          /* first frame to be displayed */
    int last_frame;                           /* last frame to be displayed  */
    int delta_frame;                          /* display every delta frame */
                   }    trajectory_info;     

     extern int mlist_deep;      /* stack number indicator */
     extern int mlists[MAX_MLIST]; /* First index for molecule list */
     extern int mliste[MAX_MLIST]; /* Second index for molecule list */
     extern char mnlist[MAX_MLIST][BUFF_LEN]; 
                                /* name list for molecule file names */

/* The original structure stored in x,y and z will be replaced by the
   average structure. The average is for the FIRST atom set */
/**************************************************************************/
int traj_av_structure()  /* average structure from the trajectory */
/**************************************************************************/
{
    static int i,j,atom_max,retv;
    static float *avx,*avy,*avz,fstep;
    static OutText[BUFF_LEN];

/* check that the info in the trajectory file matches the current ones */

/* always first structure */
     if(trajectory_info.natom != mliste[0]) {
       PrintMessage("?ERROR - number of atoms does not match number of atoms in file");
       return(1);}

      if(trajectory_info.traj_file[0] == '\0') {
        PrintMessage("?ERROR - trajectory file name is unknown");
        return(1);}

     /* open trajectory file */

        charmm_oc = fopen(trajectory_info.traj_file,"r");
        if(charmm_oc == NULL) {
        sprintf(OutText,">>> Can't open input file: %s\n",trajectory_info.traj_file);
        PrintMessage(OutText);
        shut_down(1); }

/* get some scratch space */
        atom_max = atom_list_max();

        avx = vector(atom_max);
         avy = vector(atom_max);
          avz = vector(atom_max);

        for(i = mlists[0] ; i < mliste[0] ; i++) 
           avx[i] = avy[i] = avz[i] = 0.0;

        sprintf(OutText,"First farme: %d. Last Frame: %d. Step: %d",
                TrajectoryFirstFrame(),TrajectoryLastFrame(),
                TrajectoryStepFrame());
        PrintMessage(OutText);

/* loop through the conformations */

   for(i =  TrajectoryFirstFrame() - 1 ; 
       i <  TrajectoryLastFrame() ; 
       i += TrajectoryStepFrame()) {  /* frames         */

      mlist_deep     = 0;
      current_struct = 0;
      retv = rtraj_frame(i);         /* read trajectory into x,y and z */
      if(retv < 0) {
        fclose(charmm_oc);
      free(avx); /* free the scratch space */
       free(avy);
        free(avz);
        return(1);}
/* all ower again ... */
      rewind(charmm_oc);

      for(j = mlists[0] ; j < mliste[0] ; j++) {  /* atoms */
      avx[j] += x[j];
       avy[j] += y[j];
        avz[j] += z[j]; }}

   fstep = (float)FramesInSet();

   for(i = mlists[0] ; i < mliste[0] ; i++) {   
                                    /* put average structure in x,y and z */
       x[i] = avx[i] / fstep - sumx;
       y[i] = avy[i] / fstep - sumy;
       z[i] = avz[i] / fstep - sumz; }

   free(avx); /* free the scratch space */
    free(avy);
     free(avz);

   PrintMessage(".... Average structure calculated ....");

   fclose(charmm_oc);

   return(0);
}
/**************************************************************************/
int TrajAvStructure(FirstF,LastF,StepF)  /* average structure from the trajectory */
    int FirstF;
    int LastF;
    int StepF;
/**************************************************************************/
{
    static int i,j,atom_max,retv;
    static float *avx,*avy,*avz,fstep;
    static char OutText[BUFF_LEN];

/* check that the info in the trajectory file matches the current ones */

/* always first structure */
     if(trajectory_info.natom != mliste[0]) {
       PrintMessage("?ERROR - number of atoms does not match number of atoms in file");
       return(1);}

      if(trajectory_info.traj_file[0] == '\0') {
        PrintMessage("?ERROR - trajectory file name is unknown");
        return(1);}

      PrintMessage("Calculating average structure");
      sprintf(OutText,"First frame: %d, Last frame: %d, Step: %d",FirstF,LastF,StepF);
      PrintMessage(OutText);

     /* open trajectory file */

        charmm_oc = fopen(trajectory_info.traj_file,"r");
        if(charmm_oc == NULL) {
        sprintf(OutText,">>> Can't open input file: %s",trajectory_info.traj_file);
        PrintMessage(OutText);
        shut_down(1); }

/* get some scratch space */
        atom_max = atom_list_max();

        avx = vector(atom_max);
         avy = vector(atom_max);
          avz = vector(atom_max);

        for(i = mlists[0] ; i < mliste[0] ; i++) 
           avx[i] = avy[i] = avz[i] = 0.0;

/* loop through the conformations */

   fstep = 0.0;

   for(i = FirstF - 1 ; i < LastF ; i += StepF) {  /* frames         */

      mlist_deep     = 0;
      current_struct = 0;
      retv = rtraj_frame(i);         /* read trajectory into x,y and z */
      if(retv < 0) {
        fclose(charmm_oc);
      free(avx); /* free the scratch space */
       free(avy);
        free(avz);
        return(1);}
/* all ower again ... */
      rewind(charmm_oc);

      fstep += 1.0;

      for(j = mlists[0] ; j < mliste[0] ; j++) {  /* atoms */
      avx[j] += x[j];
       avy[j] += y[j];
        avz[j] += z[j]; }}

   for(i = mlists[0] ; i < mliste[0] ; i++) {   
                                    /* put average structure in x,y and z */
       x[i] = avx[i] / fstep - sumx;
       y[i] = avy[i] / fstep - sumy;
       z[i] = avz[i] / fstep - sumz; }

   free(avx); /* free the scratch space */
    free(avy);
     free(avz);

   PrintMessage(".... Average structure calculated ....");

   fclose(charmm_oc);

   return(0);
}

