/*

   Tools to be used with spectrum

   Leif Laaksonen 1991
*/


#include <stdio.h>
#include <malloc.h>
#include <audio.h>
#include "spectrum.h"

#define SHORT_PEAK 32000.


/***************************************************************************/
float *vector_add(vec,nh)   /* add more memory to a floating pointer array */
     float *vec;            /* name of array to get more memory */
     int nh;                /* new length of array              */
                            /* Leif Laaksonen 1990              */
/***************************************************************************/
{
     float *v;

     v = (float *) realloc((char *)vec , (nh*sizeof(float)));
     if( v == NULL) {
     PrintMessage("\n** ERROR in vector ... Reallocation failure \n\n");
     shut_down(1); }

     return v;
}
/***************************************************************************/
double *dvector_add(vec,nh)   /* add more memory to a double pointer array */
     double *vec;             /* name of array to get more memory */
     int nh;                  /* new length of array              */
                              /* Leif Laaksonen 1990              */
/***************************************************************************/
{
     double *v;

     v = (double *) realloc((char *)vec , (nh*sizeof(double)));
     if( v == NULL) {
     PrintMessage("\n** ERROR in dvector ... Reallocation failure \n\n");
     shut_down(1); }

     return v;
}

/***************************************************************************/
double *dvector(nh)   /* reserve memory for double array */
     int nh;         /* expected length of array       */
                     /* Leif Laaksonen 1990            */
/***************************************************************************/
{
     double *v;

     v = (double *) malloc(nh*sizeof(double));
     if( v == NULL) {
     PrintMessage("\n** ERROR in dvector ... Allocation failure \n\n");
     shut_down(1); }

     return v;
}


/***************************************************************************/
float *vector(nh)   /* reserve memory for float array */
     int nh;        /* expected length of array       */
                    /* Leif Laaksonen 1990            */
/***************************************************************************/
{
     float *v;

     v = (float *) malloc(nh*sizeof(float));
     if( v == NULL) {
     PrintMessage("\n** ERROR in vector ... Allocation failure \n\n");
     shut_down(1); }

     return v;
}

/***************************************************************************/
int *ivector_add(vec,nh)    /* add more memory to an integer pointer array */
     int *vec;              /* name of array to get more memory */
     int nh;                /* new length of array              */
                            /* Leif Laaksonen 1990              */
/***************************************************************************/
{
     int *v;

     v = (int *) realloc((char *)vec , (nh*sizeof(int)));
     if( v == NULL) {
     PrintMessage("\n** ERROR in ivector ... Reallocation failure \n\n");
     shut_down(1); }

     return v;
}

/***************************************************************************/
int *ivector(nh)  /* reserve memory for integer array */
     int nh;      /* expected length of array         */
                  /* Leif Laaksonen 1990              */
/***************************************************************************/
{
     int *v;

     v = (int *) malloc(nh*sizeof(int));
     if( v == NULL) {
     PrintMessage("\n** ERROR in ivector ... Allocation failure ... \n\n");
     shut_down(1); }

     return v;
}

/***************************************************************************/
short *svector(nh)  /* reserve memory for a short array */
     int nh;      /* expected length of array         */
                  /* Leif Laaksonen 1990              */
/***************************************************************************/
{
     short *v;

     v = (short *) malloc(nh*sizeof(short));
     if( v == NULL) {
     PrintMessage("\n** ERROR in svector ... Allocation failure ... \n\n");
     shut_down(1); }

     return v;
}


/***************************************************************************/
char *cvector_add(vec,nh)   /* add more space to character array */
     char *vec;             /* array to get the space */
     int nh;                /* expected length        */
                            /* Leif Laaksonen 1990    */
/***************************************************************************/
{
     char *v;

     v = (char *) realloc( vec , nh);
     if( v == NULL) {
     PrintMessage("\n?ERROR - in cvector ... Reallocation failure \n\n");
     shut_down(1); }

     return v;
}

/***************************************************************************/
char *cvector(nh)   /* reserve memory for character array */
     int nh;        /* length of character array          */
                    /* Leif Laaksonen 1990                */
/***************************************************************************/
{
     char *v;

     v = (char *) malloc( nh );
     if( v == NULL) {
     PrintMessage("\n** ERROR in cvector ... Allocation failure ...\n\n");
     shut_down(1); }

     return v;
}
/***************************************************************************/
int LinesInFile(FPointer)
    FILE *FPointer;
/***************************************************************************/
{

    int   i = 0;
    char  InText[BUFF_LEN];

    rewind(FPointer);

    while(fgets(InText,BUFF_LEN,FPointer) != NULL) i++;

    rewind(FPointer);

#ifdef DEBUG
    printf("Number of lines %d\n",i);
#endif

    return(i);
}
/***************************************************************************/
int GetXYFile(FPointer , Lines)
    FILE *FPointer;
    int   Lines;
/***************************************************************************/
{
    int i,j;
    char InLine[BUFF_LEN];

    j = 2 * check_pow_2(Lines / 2);

    for(i = 0 ; i < j ; i++) {

       if(i < Lines) {
       if(fgets(InLine, BUFF_LEN , FPointer) == NULL) return(1);

       sscanf(InLine,"%f %f",&TimeSeries.XData[i],
                               &TimeSeries.YData[i]);}
       else {
           TimeSeries.XData[i] = 0.0;
           TimeSeries.YData[i] = 0.0;}}

    TimeSeries.SFreq   = NSECO / (TimeSeries.XData[1] - TimeSeries.XData[0]);
    TimeSeries.Observ  = j;
    TimeSeries.RealObs = Lines;

    return(0);
}

/***************************************************************************/
void PrintMessage(MString)
/***************************************************************************/
{
   printf("%s\n",MString);
}
/***************************************************************************/
void shut_down()
/***************************************************************************/
{
   exit(0);
}
/***************************************************************************/
void GoGetSpace(Lines)
   int Lines;
/***************************************************************************/
{

   TimeSeries.XData  = vector(Lines);
   TimeSeries.YData  = vector(Lines);
   TimeSeries.Spec   = vector(Lines);
   TimeSeries.SpecX1 = vector(Lines);
   TimeSeries.SpecX2 = vector(Lines);

   if(TimeSeries.XData == NULL ||
      TimeSeries.YData == NULL ||
      TimeSeries.Spec  == NULL ||
      TimeSeries.SpecX1 == NULL ||
      TimeSeries.SpecX2 == NULL) {
      PrintMessage("?ERROR - can't allocate space");
      shut_down(1);}
}

/***************************************************************************/
int check_pow_2(n)
    int n;
/***************************************************************************/
{

    int i;

    i = 1;
    for(;;) {
    if(i >= n) break;
    i *= 2;}

#ifdef DEBUG
    printf("Return value from 'check_pow_2': %d\n",i);
#endif

    return(i);
}

/***************************************************************************/
int PowSpec()
/***************************************************************************/
{

    int   i,j;
    float temp1,temp2,temp3;


    temp3 = 1.0 / ((float) TimeSeries.Observ);

    TimeSeries.Spec[0]                        = 
               TimeSeries.YData[0] * TimeSeries.YData[0] * temp3; 
     TimeSeries.Spec[TimeSeries.Observ/2 - 1] = 
               TimeSeries.YData[1] * TimeSeries.YData[1] * temp3; 

    j = 2;
    for(i = 1 ; i < TimeSeries.Observ/2 - 1 ; i++) {
        temp1 = TimeSeries.YData[j];
         temp2 = TimeSeries.YData[j+1];
        TimeSeries.Spec[i] = (temp1*temp1 + temp2*temp2) * temp3;
         j +=2;}

    for(i = 0 ; i < TimeSeries.Observ/2 ; i++) {
       temp1 = (TimeSeries.SFreq * ((float)(i)) / 
                        ((float)TimeSeries.Observ));
       temp2 = 100. * temp1 / SPEEDLIGHT;
       TimeSeries.SpecX1[i] = temp1;
       TimeSeries.SpecX2[i] = temp2;
       printf("%f %f %f\n",temp1,temp2,TimeSeries.Spec[i]);}

/*    if(DoAudio()) exit(1); */

    return(0);
}
/***************************************************************************/
int CalcAver(Lines)
    int Lines;
/***************************************************************************/
{
    int i;
    float Aver;

    Aver = 0;


    for(i = 0 ; i < Lines ; i++) Aver += TimeSeries.YData[i];

    Aver = Aver / (float)(Lines);

    for(i = 0 ; i < Lines ; i++) TimeSeries.YData[i] -= Aver;

    return(0);
}
/***************************************************************************/
int DoAudio()
/***************************************************************************/
{

    float Smax;
    float Smin = 0.0;

    int i,j;

    ALconfig audio_port_config;
    ALport p;


    Smax = 0.0;
    for(i = 0 ; i < TimeSeries.Observ/2 ; i++) {
        if(TimeSeries.Spec[i] > Smax) Smax = TimeSeries.Spec[i];
      }

    TimeSeries.ASpec = svector(TimeSeries.Observ/2);

    for(i = 0 ; i < TimeSeries.Observ/2 ; i++) {
                    TimeSeries.ASpec[i] = 
                    (short) (SHORT_PEAK * TimeSeries.Spec[i] / Smax);
      }


    audio_port_config = ALnewconfig();

    ALsetwidth( audio_port_config , AL_SAMPLE_16);
    ALsetchannels( audio_port_config , AL_MONO);

    p  = ALopenport("hello", "w", audio_port_config);

    if(p == NULL) {
    PrintMessage("?ERROR - can't open audio port");
    exit(1);}

    TempBuff = svector(TempBuffLen);

    for(i = 0 ; i < TimeSeries.Observ/2 ; i++) {
     
     for(j = 0 ; j < TempBuffLen ; j++) TempBuff[j] = TimeSeries.ASpec[i];

     ALwritesamps(p, TempBuff , TempBuffLen );    /* play buffer of sound */
     while(ALgetfilled(p) > 0)   /* still sound to play */
     sginap(1);              /* sleep for 1/60 of a second */
   }
     ALcloseport(p);
   
     return(0); 
}





