/*

                       Copyright (c) 1993 by:
        Leif Laaksonen , Center for Scientific Computing, ESPOO, FINLAND
            Confidential unpublished property of Leif Laaksonen
                        All rights reserved
  

                       in collaboration with

                 MOL/IX Molecular Astrophysics Group
                Max-Planck-Institut  fuer Astrophysik
                        Garching, GERMANY
*/

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <sys/time.h>
#include <netdb.h>
#include <fcntl.h>
#include <stdio.h>
#include <string.h>
#include <signal.h>
#include <string.h>
#include <ctype.h>

#include "NetServices.h"


/* Listen for connect requests on this arbitrarily-chosen port */

#define SERVER_PORT	6543

#define LINE_LEN	1024
#define BUFF_LEN         256
#define SEND_BUFFER     4096
#define RECEIVE_BUFFER  4096

    extern char *getlogin(); 
    struct hostent *gethostbyname();

    int readline(int fd  , char *Text , int maxlen);

/*
 *
 *           This is the communication library to be used
 *
 *   The routines to be called are:
 *
 *           NetStart()   - Start communication
 *           NetClose()   - Terminate a connection
 *           NetAccept()  - Accept an incoming connection
 *           NetRInt()    - Receive an integer
 *           NetRIntN()   - Receive n integers
 *           NetRFloat()  - Receive a floating point number
 *           NetRFloatN() - Receive n floating point numbers
 *           NetRText()   - Receive a text string
 *           NetSInt()    - Send an integer
 *           NetSIntN()   - Send n integers
 *           NetSFloat()  - Send a floating point number
 *           NetSFloatN() - Send n floating point numbers
 *           NetSText()   - Send a text string
 *           NetAllowed() - Check if connection is allowed
*/

    static void die();
           int  NetAccept();

    struct sockaddr_in ConnectTo;
    struct sockaddr_in ConnectFrom;

    int    ServerPort = SERVER_PORT;

/* networking functions *
 int  NetStart();      /*  Start communication                  */
 int NetClose();       /*  Terminate a connection               */
 int NetAccept();      /*  Accept an incoming connection        */
 int NetRInt();        /*  Receive an integer                   */
 int NetRIntN();       /*  Receive n integers                   */
 int NetRFloat();      /*  Receive a floating point number      */
 int NetRFloatN();     /*  Receive n floating point numbers     */
 int NetRText();       /*  Receive a text string                */
 int NetSInt();        /*  Send an integer                      */
 int NetSIntN();       /*  Send n integers                      */
 int NetSFloat();      /*  Send a floating point number         */
 int NetSFloatN();     /*  Send n floating point numbers        */
 int NetSText();       /*  Send a text string                   */
 int NetAllowed();     /*  Check if connection is allowed       */
/*.........................*/

    extern int CheckConnectedNode();

/**************************************************************************/
int NetStart(type , server_name , port_num , sock)
    int   type;            /* 0 : server , 1: client */
    char *server_name;
    int   port_num;
    int  *sock;
/**************************************************************************/
{
    int cnt;
    struct hostent *hp;
    char line[LINE_LEN];
    struct in_addr *ptr;

    if(port_num < 1024) {
        perror("Port number out of range");
        return(1);}

    if ((*sock = socket (AF_INET, SOCK_STREAM, 0)) < 0) {
	perror("Can't open socket");
        return(1);
    }

/*
printf("'%s'\n",hp->h_name);
printf("'%s'\n",inet_ntoa(*ptr));
*/
    bzero((char *) &ConnectTo, sizeof(ConnectTo));
    ConnectTo.sin_family       = AF_INET;
    ConnectTo.sin_addr.s_addr  = htonl(INADDR_ANY);
    ConnectTo.sin_port         = htons(port_num);

    if(type) {/* Connect to the server */

    /* Initialize the socket address to the server's address. */

    hp = gethostbyname(server_name);    /* to get host address */
    if (hp == NULL) {
	fprintf(stderr, "Can't find address for %s\n", server_name);
	close(*sock);
	return(1);}

    ptr = (struct in_addr *)hp->h_addr_list[0];
    bcopy (hp->h_addr, &(ConnectTo.sin_addr.s_addr), hp->h_length);
    ConnectTo.sin_addr.s_addr  = inet_addr(inet_ntoa(*ptr));

      if (connect(*sock, &ConnectTo,sizeof(ConnectTo)) < 0) {
	  close(*sock);
   	  perror("Connect to server");
	  return(1);
       }}
     else {  /* we are the server */

    /* Prepare the socket queue for connection requests */

    if (bind (*sock,(struct sockaddr *) &ConnectTo,sizeof(ConnectTo)) < 0) {
	perror("binding stream socket");
	return(1);
    }

    if(listen(*sock,5) != 0) {
       perror("?ERROR - in NetStart");
       close(*sock);
       return(1);}
   }



    /*
     * If the server goes away while sending data, we'll get a SIGPIPE signal. 
     * Catch it so we can print an error message.
     */
    signal(SIGPIPE, die);

        return(0);
}

/**************************************************************************/
static void die()
/**************************************************************************/
{

    fprintf(stderr, "Server closed connection\n");
    exit(1);

}

/*************************************************************************/
int readline(fd  , Text , maxlen)
    register int   fd;
    register char *Text;
    register int   maxlen;
/*************************************************************************/
{

     int n, rc;
     char c;

     for( n = 0 ; n < maxlen ; n++) {

          if((rc = read(fd , &c , 1)) == 1) {
                   *Text++ = c;
                    if(c == '\n')
                             break;
             
	  } else if (rc == 0) {
                  if (n == 1)
                        return(0);    /* EOF , no data read */
                  else
                        break;        /* EOF , some data was read */
	  } else
                  return(1);         /* ERROR */
      }

      *Text = 0;

       return(n);
}
/*************************************************************************/
int NetClose(sock)
    int sock;
/*************************************************************************/
{
    close(sock);

    return(0);
}
/*************************************************************************/
int NetAccept(sock , msgsock , action_type)
    int  sock;
    int *msgsock;
    int  action_type;
/*************************************************************************/
{
    int length;
    int i,j;
    char line[LINE_LEN];
    char OutText[BUFF_LEN];
    char *con_host;
    struct hostent *hp;

#ifdef CRAY
    setenv("HOSTLOOKUP named");
#endif


    length = sizeof(ConnectFrom);
    *msgsock = accept(sock, (struct sockaddr *) &ConnectFrom, &length);
    if (*msgsock < 0) {
	perror("accept");
	exit(1);
    }
#ifdef CRAY
    con_host = inet_ntoa(sin.sin_addr);
    printf("Connection from host %s, port %d\n",
	con_host, sin.sin_port);
    fflush(stdout);
#else

#endif

       return(0);
}
/*************************************************************************/
int NetAllowed()
/*************************************************************************/
{
#ifdef SERVER

    char OutText[BUFF_LEN];
    struct hostent *cli_host_name;


    cli_host_name = gethostbyaddr((char *) &ConnectFrom.sin_addr,
                                     sizeof(struct in_addr),
                                     AF_INET);

    printf("Connection from: '%s'\n",cli_host_name->h_name);

    if(CheckConnectedNode(cli_host_name->h_name)) {
     sprintf(OutText,"Host '%s' was not allowed to connect",
                      cli_host_name->h_name);
     PrintMessage(OutText);
     return(1);}

     return(0);
#else
     PrintMessage("?ERROR - this module can't be a server");
     exit(1);
#endif
}
/*************************************************************************/
int NetRInt(sock , value)
    int  sock;
    int *value;
/*************************************************************************/
{
     int k,nvalue;

     if( (k = read(sock , &nvalue , 4)) <= 0) {
       if(k == 0) perror("Connection broken");
       else
                  perror("Error in NetRInt");
       return(1);
     }

     *value = nvalue;

     return(0);
}
/*************************************************************************/
int NetSInt(sock , value)
    int  sock;
    int  value;
/*************************************************************************/
{
     int k;

     if( (k = write(sock , &value , 4)) < 0) {
          perror("Error in NetSInt");
          return(1);
     }

     return(0);
}

/*************************************************************************/
int NetRFloat(sock , value)
    int    sock;
    float *value;
/*************************************************************************/
{
     int k;
     float nvalue;

     if( (k = read(sock , &nvalue , 4)) <= 0) {
       if(k == 0) perror("Connection broken");
       else
                  perror("Error in NetRFloat");
       return(1);
     }

     *value = nvalue;

     return(0);
}
/*************************************************************************/
int NetSFloat(sock , value)
    int   sock;
    float value;
/*************************************************************************/
{
     int k;

     if( (k = write(sock , &value , 4)) < 0) {
          perror("Error in NetSInt");
          return(1);
     }

     return(0);
}

/*************************************************************************/
int NetRIntN(sock , value , length)
    int  sock;
    int *value;
    int *length;
/*************************************************************************/
{
     int i,j,k,l,m;
     char *run_buff;

/* receive first number of elements to come */
     if( (k = read(sock , &i , 4)) <= 0) {
       if(k == 0) perror("Connection broken");
       else
                  perror("Error in NetRIntN");
       return(1);
     }

     run_buff = (char *) value;

     for(l = i ; l > 0 ; l -= j) {  /* buffers to receive */

     if(l > RECEIVE_BUFFER/sizeof(int))
            j = RECEIVE_BUFFER/sizeof(int);
     else
            j = l;

      for(m = 4*j ; m > 0 ; m -= k) {
       if( (k = read(sock , run_buff , m)) <= 0) {
        if(k == 0) 
                 perror("Connection broken");
        else
                 perror("Error in NetRIntN");
        return(1);
       }
        run_buff += k;
      }
    }

     *length = i;

     return(0);
}
/*************************************************************************/
int NetSIntN(sock , value , length)
    int  sock;
    int *value;
    int  length;
/*************************************************************************/
{
     int i,j,k,l,m;
     char *run_buff;

/* send first number of elements to come */
     if( (k = write(sock , &length , 4)) <= 0) {
                  perror("Error in NetSIntN");
       return(1);
     }

     run_buff = (char *) value;

     for( i = length; i > 0 ; i -= j) {  /* buffers to send */

     if(i > SEND_BUFFER/sizeof(int))
            j = SEND_BUFFER/sizeof(int);
     else
            j = i;

       if( (k = write(sock , run_buff , sizeof(int)*j)) <= 0) {
        if(k == 0)
                 perror("Connection broken");
        else
                 perror("Error in NetSIntN");
        return(1);
       }

       run_buff += sizeof(int) * j;
     }

     return(0);
}

/*************************************************************************/
int NetRFloatN(sock , value , length)
    int    sock;
    float *value;
    int   *length;
/*************************************************************************/
{
     int i,j,k,l,m;
     char *run_buff;

/* receive first number of elements to come */
     if( (k = read(sock , &i , 4)) <= 0) {
       if(k == 0) perror("Connection broken");
       else
                  perror("Error in NetRFloatN");
       return(1);
     }

     run_buff = (char *) value;

     for(l = i ; l > 0 ; l -= j) {  /* buffers to receive */

     if(l > RECEIVE_BUFFER/sizeof(float))
            j = RECEIVE_BUFFER/sizeof(float);
     else
            j = l;

      for(m = 4*j ; m > 0 ; m -= k) {
       if( (k = read(sock , run_buff , m)) <= 0) {
        if(k == 0)
                 perror("Connection broken");
        else
                 perror("Error in NetRFloatN");
        return(1);
      }
        run_buff += k;
     }
    }

     *length = i;

     return(0);
}
/*************************************************************************/
int NetSFloatN(sock , value , length)
    int    sock;
    float *value;
    int    length;
/*************************************************************************/
{
     int i,j,k;
     char *run_buff;

/* send first number of elements to come */
     if( (k = write(sock , &length , 4)) <= 0) {
                  perror("Error in NetSFloatN");
       return(1);
     }

     run_buff = (char *) value;

     for( i = length; i > 0 ; i -= j) {  /* buffers to send */

     if(i > SEND_BUFFER/sizeof(float))
            j = SEND_BUFFER/sizeof(float);
     else
            j = i;

       if( (k = write(sock , run_buff , sizeof(float)*j)) <= 0) {
        if(k == 0)
                 perror("Connection broken");
        else
                 perror("Error in NetSFloatN");
        return(1);
       }

       run_buff += sizeof(float) * j;
     }

     return(0);
}
/* */
/*************************************************************************/
int NetRText(sock , value , length)
    int   sock;
    char *value;
    int  *length;
/*************************************************************************/
{
     int i,j,k,l,m;
     char *run_buff;

/* receive first number of elements to come */
     if( (k = read(sock , &i , 4)) <= 0) {
       if(k == 0) perror("Connection broken");
       else
                  perror("Error in NetRText");
       return(1);
     }

     run_buff = (char *) value;

     for(l = i ; l > 0 ; l -= j) {  /* buffers to receive */

     if(l > RECEIVE_BUFFER)
            j = RECEIVE_BUFFER;
     else
            j = l;

      for(m = j ; m > 0 ; m -= k) {
       if( (k = read(sock , run_buff , m)) <= 0) {
        if(k == 0)
                 perror("Connection broken");
        else
                 perror("Error in NetRText");
        return(1);
      }
        run_buff += k;
     }
    }

     *length = i;

     return(0);
}
/*************************************************************************/
int NetSText(sock , value , length)
    int   sock;
    char *value;
    int   length;
/*************************************************************************/
{
     int i,j,k;
     char *run_buff;

     if(length <= 0) length = strlen(value);

/* send first number of elements to come */
     if( (k = write(sock , &length , 4)) <= 0) {
                  perror("Error in NetSText");
       return(1);
     }

     run_buff = (char *) value;

     for( i = length; i > 0 ; i -= j) {  /* buffers to send */

     if(i > SEND_BUFFER)
            j = SEND_BUFFER;
     else
            j = i;

       if( (k = write(sock , run_buff , j)) <= 0) {
        if(k == 0)
                 perror("Connection broken");
        else
                 perror("Error in NetSText");
        return(1);
      }
       run_buff += j;
   }

     return(0);
}

