/*
 * support.c
 *
 * This file is part of the basis of the Forms Library.
 *
 * It contains the initialization routine and some routines used at
 * many places.
 *
 * Written by: Mark Overmars
 *
 * Version 2.1 a
 * Date: Oct  6, 1992
 */

#include <stdio.h>
#include <malloc.h>
#include <string.h>
#include <gl/gl.h>
#include "forms.h"

/****** Graphical Mode ******/

int fl_rgbmode = TRUE;		/* Whether in RGBmode */
int fl_doublebuf = TRUE;	/* Whether in double buffered mode */

static int initialized = FALSE;	/* Whether mode has been initializes */

void fl_init()
/* Initialises the FORMS library. */
{
  if (initialized) return;
  initialized = TRUE;
  /* Set the graphics mode based on the machine type */
  if (getgdesc(GD_BITS_NORM_SNG_RED) == 0) /* no rgbmode possible */
    { fl_doublebuf = FALSE; fl_rgbmode = FALSE;}
  else if (getgdesc(GD_BITS_NORM_DBL_RED) < 4) /* no nice double buffering */
    { fl_doublebuf = FALSE;}
  /* intialize the colormap */
  fl_init_colormap();
  /* initialize the fonts used */
  fl_init_fonts();
  /* initialize the event handling */
  fl_init_events();
  /* initialize the symbols */
  fl_init_symbols();
}


void fl_set_graphics_mode(int rgbmode, int doublebuf)
/* Sets the graphical mode being used. */
{
  fl_init();
  fl_rgbmode = rgbmode;
  fl_doublebuf = doublebuf;
}

/****** Error handling ******/

static int showerrors = TRUE;

void fl_show_errors(int show)
/* Used to switch error checking on and off */
  { showerrors = show; }

void fl_error(char str1[], char str2[])
/* Shows a two line alert box */
{
  int rep;
  char str[128];
  if (! showerrors) return;
  sprintf(str,"FORMS Error in %s\n",str1);
  rep = fl_show_choice(str,"",str2,3,"Continue","Exit","Hide Errors");
  if (rep == 2) exit(-1);
  if (rep == 3) showerrors = FALSE;
}

/****** Memory Allocation ******/

void *fl_malloc(size_t amount)
/* Replacement for the normal malloc, doing checking */
{
  void *ttt = malloc(amount);
  if (ttt == NULL) fl_error("fl_malloc","Cannot allocate memory.");
  return ttt;
}

/****** Setting windows ******/

static long userwind = -1;	    /* The current user window */
static int usersaved = 0;	    /* How often user window is saved */
static long formwind = -1;	    /* The current form window */

void fl_save_user_window()
/* Saves the window identifier for the user window */
{
  if (usersaved++ == 0) userwind = winget();
}

void fl_restore_user_window()
/* Sets back the user window */
{
  if (usersaved <= 0)
    fl_error("fl_restore_user_window","Internal Error: usersaved <= 0");
  else if (usersaved > 1) usersaved--;
  else
  {
    if (userwind != -1 && userwind != 257) winset(userwind);
    userwind = -1; formwind = -1;
    usersaved = 0;
  }
}

void fl_set_forms_window(FL_FORM *form)
/* Sets the form windom */
{
  if (form == NULL || form->window == formwind) return;
  formwind = form->window;
  winset(formwind);
}

