
/*
 * goodies.c
 *
 * This file belongs to the goodies of the Forms Library.
 *
 * It contains the soft button box, the messages, etc and the color selector.
 *
 * Written by: Mark Overmars
 *
 * Version 2.1 b
 * Date: Oct  4,  1992
 */

#include <gl/gl.h>
#include <gl/device.h>
#include "forms.h"

/********** A SOFT BUTTON BOX **********/

static FL_FORM *buttonbox;
static FL_OBJECT *box_button[32];
static int buttonbox_created = 0;

static void handle_buttonbox(FL_OBJECT *obj, long arg)
  { qenter( (short) (SW0+arg), (short) fl_get_button(obj)); }

static void create_buttonbox()
{
  FL_OBJECT *obj;
  int i;
  float xx, yy;
  if (buttonbox_created) return; else buttonbox_created = 1;
  buttonbox = fl_bgn_form(FL_UP_BOX,310.0,310.0);
  xx = 10.0; yy = 260.0;
  for (i=0; i<32; i++)
  {
    if (i==0 || i==28) xx += 50.0;
    box_button[i] = fl_add_button(FL_INOUT_BUTTON,xx,yy,40.0,40.0,"");
    fl_set_object_color(box_button[i],47,43);
    fl_set_call_back(box_button[i],handle_buttonbox,i);
    xx += 50.0;
    if (i==3 || i==9 || i==15 || i==21 || i==27) {yy -= 50.0; xx = 10.0;}
  }
  fl_end_form();
}

long fl_show_buttonbox()
/* Shows the buttonbox on the screen */
{
  create_buttonbox();
  return fl_show_form(buttonbox,FL_PLACE_FREE,TRUE,"buttonbox"); 
}

void fl_hide_buttonbox()
/* Hides the buttonbox */
  { fl_hide_form(buttonbox); }

void fl_set_buttonbox_label(int but, char str[])
/* Sets the label for a button in the buttonbox */
{ 
  create_buttonbox();
  if (but<32)
    fl_set_object_label(box_button[but],str);
  else
    fl_set_object_label(box_button[but-SW0],str);
}
  
/********** SOME SIMPLE FORMS **********/

static FL_FORM *message_form;
static FL_OBJECT *message_str1, *message_str2, *message_str3,
		*message_but;

static FL_FORM *question_form;
static FL_OBJECT *question_str1, *question_str2, *question_str3,
		*question_yes, *question_no;

static FL_FORM *choice_form;
static FL_OBJECT *choice_str1, *choice_str2, *choice_str3,
		*choice_but1, *choice_but2, *choice_but3;

static FL_FORM *input_form;
static FL_OBJECT *input_str1, *input_value, *input_but;

static FL_OBJECT *retobj;

static int simpleforms_created = 0;

static void create_simpleforms()
/* Make all the forms */
{
  if (simpleforms_created) return; else simpleforms_created = 1;
  message_form = fl_bgn_form(FL_UP_BOX,460.0,130.0);
    message_str1  = fl_add_box(FL_NO_BOX,20.0,95.0,420.0,20.0,"");
    message_str2  = fl_add_box(FL_NO_BOX,20.0,75.0,420.0,20.0,"");
    message_str3  = fl_add_box(FL_NO_BOX,20.0,55.0,420.0,20.0,"");
    message_but  = fl_add_button(FL_RETURN_BUTTON,185.0,15.0,90.0,25.0,"OK");
  fl_end_form();
  question_form = fl_bgn_form(FL_UP_BOX,460.0,130.0);
    question_str1  = fl_add_box(FL_NO_BOX,20.0,95.0,420.0,20.0,"");
    question_str2  = fl_add_box(FL_NO_BOX,20.0,75.0,420.0,20.0,"");
    question_str3  = fl_add_box(FL_NO_BOX,20.0,55.0,420.0,20.0,"");
    question_yes  = fl_add_button(FL_NORMAL_BUTTON,80.0,15.0,90.0,25.0,"Yes");
    fl_set_button_shortcut(question_yes, "yY");
    question_no  = fl_add_button(FL_NORMAL_BUTTON,290.0,15.0,90.0,25.0,"No");
    fl_set_button_shortcut(question_no, "nN");
  fl_end_form();
  choice_form = fl_bgn_form(FL_UP_BOX,460.0,130.0);
    choice_str1  = fl_add_box(FL_NO_BOX,20.0,95.0,420.0,20.0,"");
    choice_str2  = fl_add_box(FL_NO_BOX,20.0,75.0,420.0,20.0,"");
    choice_str3  = fl_add_box(FL_NO_BOX,20.0,55.0,420.0,20.0,"");
    choice_but1  = fl_add_button(FL_NORMAL_BUTTON,40.0,15.0,90.0,25.0,"");
    fl_set_button_shortcut(choice_but1, "1");
    choice_but2  = fl_add_button(FL_NORMAL_BUTTON,185.0,15.0,90.0,25.0,"");
    fl_set_button_shortcut(choice_but2, "2");
    choice_but3  = fl_add_button(FL_NORMAL_BUTTON,330.0,15.0,90.0,25.0,"");
    fl_set_button_shortcut(choice_but3, "3");
  fl_end_form();
  input_form = fl_bgn_form(FL_UP_BOX,460.0,130.0);
    input_str1  = fl_add_box(FL_NO_BOX,20.0,95.0,420.0,20.0,"");
    input_value = fl_add_input(FL_NORMAL_INPUT,30.0,50.0,400.0,30.0,"");
    input_but  = fl_add_button(FL_RETURN_BUTTON,185.0,15.0,90.0,25.0,"OK");
  fl_end_form();
}

static int xposit()
{
  int x;
  x = (int) getvaluator(MOUSEX)-230;
  if (x<0) x=0;
  return x;
}

static int yposit()
{
  int y;
  y = (int) getvaluator(MOUSEY)-27;
  if (y<0) y=0;
  return y;
}

void fl_show_message(char str1[],char str2[],char str3[])
/* Shows a simple message with an OK button */
{
  create_simpleforms();
  if (message_form->visible) return;
  fl_set_object_label(message_str1,str1);
  fl_set_object_label(message_str2,str2);
  fl_set_object_label(message_str3,str3);
  fl_deactivate_all_forms();
  fl_set_form_position(message_form,xposit(),yposit());
  fl_show_form(message_form,FL_PLACE_POSITION,FALSE,"message");
  do retobj = fl_do_only_forms(); while (retobj != message_but);
  fl_hide_form(message_form);
  fl_activate_all_forms();
}

int fl_show_question(char str1[],char str2[],char str3[])
/* Shows a question with two buttons, yes, and no */
{
  create_simpleforms();
  fl_set_object_label(question_str1,str1);
  fl_set_object_label(question_str2,str2);
  fl_set_object_label(question_str3,str3);
  fl_deactivate_all_forms();
  fl_set_form_position(question_form,xposit(),yposit());
  fl_show_form(question_form,FL_PLACE_POSITION,FALSE,"question");
  do
    retobj = fl_do_only_forms();
  while (retobj != question_yes && retobj != question_no);
  fl_hide_form(question_form);
  fl_activate_all_forms();
  return (retobj == question_yes);
}

char *fl_show_input(char str1[], char defstr[])
/* Asks the user for textual input */
{
  create_simpleforms();
  fl_set_object_label(input_str1,str1);
  fl_set_input(input_value,defstr);
  fl_deactivate_all_forms();
  fl_set_form_position(input_form,xposit(),yposit());
  fl_show_form(input_form,FL_PLACE_POSITION,FALSE,"input");
  do retobj = fl_do_only_forms(); while (retobj != input_but);
  fl_hide_form(input_form);
  fl_activate_all_forms();
  return (fl_get_input(input_value));
}

int fl_show_choice(char str1[], char str2[], char str3[],
		int numb, char but1[], char but2[], char but3[])
/* Asks the user for a choice */
{
  create_simpleforms();
  fl_set_object_label(choice_str1,str1);
  fl_set_object_label(choice_str2,str2);
  fl_set_object_label(choice_str3,str3);
  fl_hide_object(choice_but1);
  fl_hide_object(choice_but2);
  fl_hide_object(choice_but3);
  switch (numb)
  {
    case 3:
        fl_set_object_label(choice_but3,but3);
        fl_show_object(choice_but3);
    case 2:
        fl_set_object_label(choice_but2,but2);
        fl_show_object(choice_but2);
    case 1:
        fl_set_object_label(choice_but1,but1);
        fl_show_object(choice_but1);
	break;
    default:
	return 0;
  }
  fl_deactivate_all_forms();
  fl_set_form_position(choice_form,xposit(),yposit());
  fl_show_form(choice_form,FL_PLACE_POSITION,FALSE,"choice");
  do
    retobj = fl_do_only_forms();
  while (retobj != choice_but1&& retobj != choice_but2&& retobj != choice_but3);
  fl_hide_form(choice_form);
  fl_activate_all_forms();
  if (retobj == choice_but1) return 1;
  else if (retobj == choice_but2) return 2;
  else return 3;
}

/****************** Color Selector Goodie ************************/

static FL_FORM *colorform;
static FL_OBJECT *col[64], *next, *prev, *cancel;
static int colorform_created = 0;

static void create_colorform()
{
  FL_OBJECT *obj;
  int i,j;
  if (colorform_created) return; else colorform_created = 1;
  colorform = fl_bgn_form(FL_UP_BOX,240.0,220.0);
  for (i=0; i<8; i++) for (j=0; j<8; j++)
  {
    col[8*i+j] = fl_add_button(FL_NORMAL_BUTTON,40.0+j*20.0,190.0-i*20.0,
					20.0,20.0,"");
    fl_set_object_boxtype(col[8*i+j],FL_BORDER_BOX);
    fl_set_object_lcol(col[8*i+j],7);
  }
  prev = fl_add_button(FL_NORMAL_BUTTON,10.0,50.0,30.0,160.0,"@4");
  next = fl_add_button(FL_NORMAL_BUTTON,200.0,50.0,30.0,160.0,"@6");
  cancel = fl_add_button(FL_NORMAL_BUTTON,40.0,10.0,160.0,30.0,"Cancel");
  fl_end_form();
}

static void init_colors(int cc, int thecol)
/* initializes the colors */
{
  int i;
  fl_freeze_form(colorform);
  for (i=0; i<64; i++)
  {
    fl_set_object_color(col[i],cc+i,cc+i);
    fl_set_object_label(col[i],"");
    if (thecol == cc+i) fl_set_object_label(col[i],"@9plus");
  }
  fl_unfreeze_form(colorform);
}

int fl_show_colormap(int oldcol)
/* Shows a colormap color selector from which the user can select a color. */
{
  FL_OBJECT *ob;
  int i, cc = 64 * (oldcol/64), ready = 0, thecol =oldcol;
  create_colorform();
  init_colors(cc,thecol);
  fl_set_object_color(cancel,thecol,thecol);
  fl_deactivate_all_forms();
  fl_show_form(colorform,FL_PLACE_MOUSE,FALSE,"colormap");
  while (!ready) 
  {
    ob = fl_do_only_forms();
    if (ob == prev && cc>0) {cc -= 64; init_colors(cc,thecol);}
    else if (ob == next ) {cc += 64; init_colors(cc,thecol);}
    else if (ob == cancel) ready = TRUE;
    else for (i=0; i<64; i++) if (ob == col[i]) {ready = TRUE; thecol = cc+i;}
  }
  fl_hide_form(colorform);
  fl_activate_all_forms();
  return thecol;
}
