/*
 * free.c
 *
 * Forms Object class: FREE
 *
 * Written by: Mark Overmars
 *
 * Version 2.0 a
 * Date: Nov 11, 1991
 */

#include "forms.h"

FL_OBJECT *fl_create_free(int type,float x,float y,float w,float h,char label[],
			FL_HANDLEPTR handle)
/* creates a free object */
{
  FL_OBJECT *obj;
  obj = fl_make_object(FL_FREE,type,x,y,w,h,label,handle);

  if (type == FL_SLEEPING_FREE) obj->active = 0;
  if (type == FL_CONTINUOUS_FREE) obj->automatic = 1;
  if (type == FL_INPUT_FREE) obj->input = 1;
  if (type == FL_ALL_FREE) {obj->input = 1; obj->automatic = 1;}

  return obj;
}

FL_OBJECT *fl_add_free(int type, float x, float y, float w, float h,
			 char label[], FL_HANDLEPTR handle)
/* Adds an object */
{
  FL_OBJECT *ob;
  ob = fl_create_free(type,x,y,w,h,label,handle);
  fl_add_object(fl_current_form,ob);
  return ob;
}
