/*
 * choice.c
 *
 * Forms Object class: CHOICE
 *
 * Written by: Mark Overmars and Trevor Paquette
 *
 * Version 2.1 b
 * Date: Oct  1, 1992
 */

#include <malloc.h>
#include <strings.h>
#include <gl/device.h>
#include <gl/gl.h>
#include "forms.h"

/* Object specific information */
typedef struct{
   int  val;                    /* last menu item selected */
   int  numitems;               /* number of items in choice */
   float fontsize;              /* font size */
   int fontstyle;               /* font style */
   char *items[FL_CHOICE_MAXITEMS+1]; /* individual choice items */
   int counter;			/* counts mouse events */
} SPEC;

static void draw_choice(FL_OBJECT *ob)
/* Draws a choice object */
{
  int c1;
  SPEC *sp = ((SPEC *)(ob->spec));
  if(ob->belowmouse && ob->col1 == FL_CHOICE_COL1)
     c1 = FL_CHOICE_MCOL;
  else
    c1 = ob->col1;
  fl_drw_box(ob->boxtype,ob->x,ob->y,ob->w,ob->h,c1,FL_CHOICE_BW);
  fl_drw_text_beside(ob->align,ob->x,ob->y,ob->w,ob->h,ob->lcol,
                        ob->lsize,ob->lstyle,ob->label);
  if (sp->val >0)
    fl_drw_text(FL_ALIGN_CENTER,ob->x,ob->y,ob->w,ob->h,ob->col2,
                        sp->fontsize,sp->fontstyle,sp->items[sp->val]);
}

static int mousebutton=0;

static int handle_choice(FL_OBJECT *ob,int event,float mx,float my,char key)
/* Handles an event, returns whether value has changed. */
{
  int val,i;
  long menu;
  SPEC *sp = ((SPEC *)(ob->spec));
  switch (event)
  {
    case FL_DRAW:
        /* Draw the object */
        draw_choice(ob);
        return 0;
    case FL_PUSH:
	mousebutton = key;
        if (sp->numitems == 0) return 0;
        sp->counter = 0;
        if (mousebutton == 1)
        {
          menu = newpup();
          for (i=1; i<=sp->numitems;i++) addtopup(menu,sp->items[i]);
          val =  (int) dopup(menu);
	  qenter(RIGHTMOUSE,0); /* Eaten up by the menu call. */
          if(val > 0) sp->val = val;
          freepup(menu);
          fl_redraw_object(ob);
        }
        return 0;
    case FL_MOUSE:
        if (sp->numitems == 0) return 0;
        if (mousebutton == 3 && sp->counter++ % 20 == 0)
        {
          if(sp->val == sp->numitems) sp->val = 1; else sp->val++;
          fl_redraw_object(ob);
	}
        else if (mousebutton == 2 && sp->counter++ % 20 == 0)
        {
          if(sp->val <= 1) sp->val = sp->numitems; else sp->val--;
          fl_redraw_object(ob);
	}
        return 0;
    case FL_RELEASE:
	mousebutton = 0;
        if (sp->numitems == 0) return 0;
        return 1;
    case FL_ENTER:
    case FL_LEAVE:
        if (ob->col1 == FL_CHOICE_COL1) fl_redraw_object(ob);
        return 0;
    case FL_FREEMEM:
	for (i=1; i<=sp->numitems;i++) free(sp->items[i]);
	free(ob->spec);
	return 0;

    default:
        return 0;
  }
}

/*-------------------------------------------*/

FL_OBJECT *fl_create_choice(int type,float x,float y,float w,float h,char label[])
/* creates an object */
{
  FL_OBJECT *ob;
  int i;
  SPEC *sp;
  ob = fl_make_object(FL_CHOICE,type,x,y,w,h,label,handle_choice);
  ob->boxtype = FL_CHOICE_BOXTYPE;
  ob->col1 = FL_CHOICE_COL1;
  ob->col2 = FL_CHOICE_COL2;
  ob->lcol = FL_CHOICE_LCOL;
  ob->align = FL_CHOICE_ALIGN;
  ob->spec = (int *) fl_malloc(sizeof(SPEC));
  sp = ((SPEC *)(ob->spec));
  sp->val = 0;
  sp->numitems = 0;
  sp->fontsize = FL_NORMAL_FONT;
  sp->fontstyle = FL_NORMAL_STYLE;
  for(i = 0; i <= FL_CHOICE_MAXITEMS; i++) sp->items[i] = NULL;
  return ob;
}

FL_OBJECT *fl_add_choice(int type, float x, float y, float w, float h, char label[])
/* Adds an object */
{
  FL_OBJECT *ob;
  ob = fl_create_choice(type,x,y,w,h,label);
  fl_add_object(fl_current_form,ob);
  return ob;
}

/*-------------------------------------*/

void fl_clear_choice(FL_OBJECT *ob)
/* Clears the choice object */
{
  SPEC *sp = ((SPEC *)(ob->spec));
  sp->val = 0;
  sp->numitems = 0;
  fl_redraw_object(ob);
}

void fl_addto_choice(FL_OBJECT *ob, char str[])
/* Adds a line to the choice item. */
{
  SPEC *sp = ((SPEC *)(ob->spec));
  if (sp->numitems >= FL_CHOICE_MAXITEMS) return;
  sp->numitems++;
  if (sp->items[sp->numitems] == NULL)
    sp->items[sp->numitems] = (char *) fl_malloc(FL_CHOICE_MAXSTR+1);
  strncpy(sp->items[sp->numitems],str,FL_CHOICE_MAXSTR);
  sp->items[sp->numitems][FL_CHOICE_MAXSTR] = NULL;
  if (sp->val == 0) { sp->val = 1; fl_redraw_object(ob); }
}

void fl_replace_choice(FL_OBJECT *ob, int numb, char str[])
/* Replaces a line to the choice item. */
{
  SPEC *sp = ((SPEC *)(ob->spec));
  if (numb<1 || numb >sp->numitems) return;
  strncpy(sp->items[numb],str,FL_CHOICE_MAXSTR);
  sp->items[numb][FL_CHOICE_MAXSTR] = NULL;
  if (sp->val == numb) fl_redraw_object(ob);
}

void fl_delete_choice(FL_OBJECT *ob, int numb)
/* Removes a line from the choice item. */
{
  int i;
  SPEC *sp = ((SPEC *)(ob->spec));
  if (numb<1 || numb >sp->numitems) return;
  free(sp->items[numb]);
  for (i=numb; i<sp->numitems;i++) sp->items[i] = sp->items[i+1];
  sp->items[sp->numitems] = NULL;
  sp->numitems--;
  if (sp->val == numb)
  {
    if (sp->val > sp->numitems) sp->val = sp->numitems;
    fl_redraw_object(ob);
  }
  else if (sp->val > numb) sp->val--;
}  

/*------------------------------------------*/

void fl_set_choice(FL_OBJECT *ob, int choice)
/* Sets the number of the choice. */
{
  SPEC *sp = ((SPEC *)(ob->spec));
  if (choice<1 || choice >sp->numitems) sp->val = 0; else sp->val = choice;
  fl_redraw_object(ob);
}

int fl_get_choice(FL_OBJECT *ob)
/* Returns the number of the choice. */
{
  SPEC *sp = ((SPEC *)(ob->spec));
  return sp->val;
}

char *fl_get_choice_text(FL_OBJECT *ob)
/* Returns the text of the choice. */
{
  SPEC *sp = ((SPEC *)(ob->spec));
  if (sp->val == 0) return NULL;
  return sp->items[sp->val];
}

/*--------------------------------------------------*/

void fl_set_choice_fontsize(FL_OBJECT *ob, float size)
/* Sets the font size inside the choice. */
{
  ((SPEC *)(ob->spec))->fontsize = size;
  fl_redraw_object(ob);
}

void fl_set_choice_fontstyle(FL_OBJECT *ob, int style)
/* Sets the font style inside the choice. */
{
  ((SPEC *)(ob->spec))->fontstyle = style;
  fl_redraw_object(ob);
}
