/*
 This is an example file showing which routines should be provided
 to add a class of objects to the forms library.
 Also some changes have to be made to the file forms.h.
*/

/*
 * NEW.c
 *
 * Forms Object class:
 *
 * Written by:
 *
 * Version
 * Date:
 */

#include "forms.h"

static int fl_handle_NEW(FL_OBJECT *ob, int event, float mx, float my, char key)
/* Handles an event, returns whether value has changed. */
{
  switch (event)
  {
    case FL_DRAW:
 	/* Draw the object */
        return 0;
    case FL_ENTER:
	/* Handle a mouse enter event (mx,my is the mouse position) */
        return ???;
    case FL_LEAVE:
	/* Handle a mouse leave event (mx,my is the mouse position) */
        return ???;
    case FL_MOVE:
	/* Mouse was moved in object. mx, my is the new mouse position */
        return ???;
    case FL_PUSH:
	/* Handle a mouse push event (mx,my is the mouse position) */
        return ???;
    case FL_RELEASE:
	/* Handle a mouse release event (mx,my is the mouse position) */
        return ???;
    case FL_MOUSE:
	/* Mouse was moved while pushed. mx, my is the new mouse position */
        return ???;
    case FL_FOCUS:
	/* Handle an input focus event */
        return ???;
    case FL_UNFOCUS:
	/* Handle an input unfocus event */
        return ???;
    case FL_KEYBOARD:
	/* Handle a keyboard event. key is the key pressed. */
        return ???;
    case FL_STEP:
	/* Handle a step event (when automatic) */
        return ???;
    case FL_SHORTCUT:
	/* Handle the use of a keyboard shortcut */
	return ???;
    case FL_FREEMEM:
	/* Free any memory allocated by the object. */
	return 0;
  }
  return 0;
}

/*------------------------------*/

FL_OBJECT *fl_create_NEW(int type, float x, float y, float w, float h, char label[])
/* Create an object */
{
  FL_OBJECT *ob;
  ob = fl_make_object(FL_NEW,type,x,y,w,h,label,handle_NEW);

  /* FILLING IN DEFAULTS */

  return ob;
}

FL_OBJECT *fl_add_NEW(int type, float x, float y, float w, float h, char label[])
/* Adds an object */
{
  FL_OBJECT *ob;
  ob = fl_create_NEW(type,x,y,w,h,label);
  fl_add_object(fl_current_form,ob);
  return ob;
}
