      SUBROUTINE WRTKEY(KEYWRD)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      INCLUDE 'SIZES'
      CHARACTER*241 KEYWRD, ALLKEY
***********************************************************************
*
*  WRTKEY CHECKS ALL KEY-WORDS AND PRINTS THOSE IT RECOGNIZES.  IF IT
*  FINDS A WORD IT DOES NOT RECOGNIZE THE PROGRAM WILL BE STOPPED.
*
***********************************************************************
      COMMON /NUMCAL/ NUMCAL
      COMMON /TIMDMP/ TLEFT, TDUMP
      LOGICAL UHF, TRIP, BIRAD, EXCI, CI, MYWORD
      LOGICAL AM1, MNDO, MINDO3, PM3
      CHARACTER CH*1, CHRONO*7
      SAVE AM1, MNDO, MINDO3
      DATA AM1, MNDO, MINDO3, PM3 /4*.FALSE./
      ALLKEY=KEYWRD
C    DUMMY IF STATEMENT TO REMOVE AMPERSAND AND PLUS SIGNS, IF PRESENT
      IF(MYWORD(ALLKEY(160:),' SETUP'))I=1
      IF(MYWORD(ALLKEY,'&'))I=2
      IF(MYWORD(ALLKEY,' +'))I=3
      IF(MYWORD(ALLKEY,'AUTHOR')) THEN
         WRITE(6,'(10X,'' MOPAC - A GENERAL MOLECULAR ORBITAL PACKAGE'',
     1/         ,10X,''   ORIGINAL VERSION WRITTEN IN 1983'')')
         WRITE(6,'(10X,''     BY JAMES J. P. STEWART AT THE'',/
     1         ,10X,''     UNIVERSITY OF TEXAS AT AUSTIN'',/
     2         ,10X,''          AUSTIN, TEXAS, 78712'')')
      ENDIF
      IF (MYWORD(ALLKEY,'VECT') ) WRITE(6,210)
      IF (MYWORD(ALLKEY,' EXTE') ) THEN
         I=INDEX(KEYWRD,' EXTE')
         J=INDEX(KEYWRD(I:),'=')+I
         I=INDEX(KEYWRD(J:),' ')+J-1
         WRITE(6,220)KEYWRD(J:I)
      ENDIF
      MAXGEO=0
      IF (MYWORD(ALLKEY,' DENS') ) WRITE(6,230)
      IF (MYWORD(ALLKEY,'SPIN') ) WRITE(6,240)
      IF (MYWORD(ALLKEY,' DEPVAR') )
     1WRITE(6,250)READA(KEYWRD,INDEX(KEYWRD,'DEPVAR'))
      IF (MYWORD(ALLKEY,' DEP ') )WRITE(6,260)
      IF (MYWORD(ALLKEY,'VELO') )WRITE(6,270)
      IF (MYWORD(ALLKEY,'TIMES') )WRITE(6,280)
      IF (MYWORD(ALLKEY,'PARASOK') ) WRITE(6,290)
      IF (MYWORD(ALLKEY,'NODIIS') ) WRITE(6,300)
C  *** FOLLOWING LINE ADDED AS NOTED
C  IN QCPE BULLETIN VOL. 11, NO. 3, PP. 52-54 (1991).
      IF (MYWORD(ALLKEY,'NOTHIE') ) WRITE(6,305)
      IF (MYWORD(ALLKEY,'BONDS') ) WRITE(6,310)
      IF (MYWORD(ALLKEY,'GEO-OK') ) WRITE(6,320)
      IF (MYWORD(ALLKEY,'FOCK') ) WRITE(6,330)
      IF (MYWORD(ALLKEY,'LARGE') ) WRITE(6,340)
      IF (MYWORD(ALLKEY,' K=') ) WRITE(6,350)
      IF (MYWORD(ALLKEY,'NOLOG') ) WRITE(6,360)
      IF (MYWORD(ALLKEY,'AIGIN') ) WRITE(6,370)
      IF (MYWORD(ALLKEY,'AIGOUT') ) WRITE(6,380)
      IF (MYWORD(ALLKEY,'AIDER') ) WRITE(6,390)
      IF (MYWORD(ALLKEY,' S1978') ) WRITE(6,400)
      IF (MYWORD(ALLKEY,' SI1978') ) WRITE(6,410)
      IF (MYWORD(ALLKEY,' GRAP') ) WRITE(6,420)
      IF (MYWORD(ALLKEY,'NOANCI') ) WRITE(6,440)
      IF (MYWORD(ALLKEY,'1ELEC') ) WRITE(6,430)
      IF (MYWORD(ALLKEY(:162),' SETUP') ) WRITE(6,470)
      IF (MYWORD(ALLKEY,' NOMM') ) WRITE(6,460)
      IF (MYWORD(ALLKEY,' MMOK') ) WRITE(6,480)
      IF (MYWORD(ALLKEY,'INTERP') ) WRITE(6,490)
      IF (MYWORD(ALLKEY,' ESR') ) WRITE(6,450)
      IF (MYWORD(ALLKEY,'DFP') ) WRITE(6,500)
      IF (MYWORD(ALLKEY,'ANALYT') ) WRITE(6,510)
      IF (MYWORD(ALLKEY,' MECI') ) WRITE(6,520)
      IF (MYWORD(ALLKEY,'LOCAL') ) WRITE(6,560)
      IF (MYWORD(ALLKEY,'MULLIK') ) WRITE(6,570)
      IF (MYWORD(ALLKEY,' XYZ') ) WRITE(6,580)
      IF (MYWORD(ALLKEY,' PI') ) WRITE(6,590)
      IF (MYWORD(ALLKEY,'ECHO') ) WRITE(6,600)
      IF (MYWORD(ALLKEY, 'SING') ) WRITE(6,910)
      IF (MYWORD(ALLKEY, 'DOUB') ) WRITE(6,920)
      IF (MYWORD(ALLKEY, 'QUAR') ) WRITE(6,940)
      IF (MYWORD(ALLKEY, 'QUIN') ) WRITE(6,950)
      IF (MYWORD(ALLKEY, 'SEXT') ) WRITE(6,960)
      IF (MYWORD(ALLKEY,'H-PRIO') ) WRITE(6,610)
      IF (MYWORD(ALLKEY,'X-PRIO') ) WRITE(6,620)
      IF (MYWORD(ALLKEY,'T-PRIO') ) WRITE(6,630)
      IF (MYWORD(ALLKEY,'COMPFG') ) WRITE(6,650)
      IF (MYWORD(ALLKEY,'POLAR') ) WRITE(6,640)
      IF (MYWORD(ALLKEY,'DEBUG ') ) WRITE(6,660)
      IF (MYWORD(ALLKEY,'RESTART') ) WRITE(6,670)
      IF (MYWORD(ALLKEY,'AQUO') ) WRITE(6,1520)
      IF (MYWORD(ALLKEY,'ENVAQ') ) WRITE(6,1540)
      IF (MYWORD(ALLKEY,'NOFUL') ) WRITE(6,1550)
C
C     KEYWORDS ADDED FOR ESP MOPAC
C
      IF (MYWORD(ALLKEY,'ESP ') ) WRITE(6,680)
      IF (MYWORD(ALLKEY,'NSURF') ) WRITE(6,690)
      IF (MYWORD(ALLKEY,'SCALE') ) WRITE(6,700)
      IF (MYWORD(ALLKEY,'SCINCR') ) WRITE(6,710)
      IF (MYWORD(ALLKEY,'SLOPE') ) WRITE(6,720)
      IF (MYWORD(ALLKEY,'DIPOLE') ) WRITE(6,730)
      IF (MYWORD(ALLKEY,'DIPX') ) WRITE(6,740)
      IF (MYWORD(ALLKEY,'DIPY') ) WRITE(6,750)
      IF (MYWORD(ALLKEY,'DIPZ') ) WRITE(6,760)
      IF (MYWORD(ALLKEY,'CONNOLLY') ) WRITE(6,770)
      IF (MYWORD(ALLKEY,'ESPRST') ) WRITE(6,780)
      IF (MYWORD(ALLKEY,' POTWRT') ) WRITE(6,790)
      IF (MYWORD(ALLKEY,'WILLIAMS') ) WRITE(6,800)
      IF (MYWORD(ALLKEY,'SYMAVG') ) WRITE(6,810)
      IF (MYWORD(ALLKEY,'STO3G') ) WRITE(6,820)
      IF (MYWORD(ALLKEY,'IUPD')) THEN
         II=NINT(READA(KEYWRD,INDEX(KEYWRD,'IUPD=')))
         IF (II.EQ.0) WRITE(6,90)
         IF (II.EQ.1) WRITE(6,100)
         IF (II.EQ.2) WRITE(6,110)
      ENDIF
      IF (MYWORD(ALLKEY,'HESS')) THEN
         II=NINT(READA(KEYWRD,INDEX(KEYWRD,'HESS=')))
         IF (II.EQ.0) WRITE(6,120)
         IF (II.EQ.1) WRITE(6,130)
         IF (II.EQ.2) WRITE(6,140)
         IF (II.EQ.3) WRITE(6,150)
      ENDIF
      IF (MYWORD(ALLKEY,' MODE')) WRITE(6,160)
     1 NINT(READA(KEYWRD,INDEX(KEYWRD,'MODE=')))
      IF (MYWORD(ALLKEY,' RECALC')) WRITE(6,170)
     1 NINT(READA(KEYWRD,INDEX(KEYWRD,'RECALC')))
      IF (MYWORD(ALLKEY,' DMAX')) WRITE(6,180)
     1 READA(KEYWRD,INDEX(KEYWRD,'DMAX='))
      IF (MYWORD(ALLKEY,' MS=')) WRITE(6,190)
     1 NINT(READA(KEYWRD,INDEX(KEYWRD,' MS=')))
      IF (MYWORD(ALLKEY,' PRNT')) WRITE(6,200)
      IF (MYWORD(ALLKEY,'IRC=') ) THEN
         MAXGEO=1
         WRITE(6,830)NINT(READA(KEYWRD,INDEX(KEYWRD,'IRC=')))
      ELSEIF (MYWORD(ALLKEY,'IRC') ) THEN
         MAXGEO=1
         WRITE(6,840)
      ENDIF
      IF (MYWORD(ALLKEY,'CHARGE') )
     1 WRITE(6,850)NINT(READA(KEYWRD,INDEX(KEYWRD,'CHARGE')))
      IF (MYWORD(ALLKEY,'GRAD') ) WRITE(6,860)
      UHF=(MYWORD(ALLKEY,'UHF') )
      IF(UHF)WRITE(6,870)
      BIRAD=(MYWORD(ALLKEY,'BIRAD') )
      IF(BIRAD)WRITE(6,890)
      EXCI=(MYWORD(ALLKEY,'EXCITED') )
      IF(EXCI) WRITE(6,900)
      TRIP=(MYWORD(ALLKEY,'TRIP') )
      IF(TRIP)WRITE(6,930)
      IF (MYWORD(ALLKEY,'SYM') ) WRITE(6,970)
      IF(MYWORD(ALLKEY,'OPEN('))THEN
         I=INDEX(KEYWRD,'OPEN(')
         IELEC=READA(KEYWRD,I)
         ILEVEL=READA(KEYWRD,I+7)
         WRITE(6,990)IELEC,ILEVEL
      ENDIF
      IF(MYWORD(ALLKEY,'MICROS'))
     1WRITE(6,980)INT(READA(KEYWRD,INDEX(KEYWRD,'MICROS')))
      IF(MYWORD(ALLKEY,'DRC='))THEN
         MAXGEO=1
         WRITE(6,540)READA(KEYWRD,INDEX(KEYWRD,'DRC='))
      ELSEIF (MYWORD(ALLKEY,' DRC') ) THEN
         MAXGEO=1
         WRITE(6,530)
      ENDIF
      IF(MYWORD(ALLKEY,'KINE'))
     1WRITE(6,550)READA(KEYWRD,INDEX(KEYWRD,'KINE'))
      CHRONO='SECONDS'
      TIME=1
      IF(MYWORD(ALLKEY,' T=')) THEN
         I=INDEX(KEYWRD,' T=')
         TLEFT=READA(KEYWRD,I)
         DO 10 J=I+3,241
            IF( J.EQ.241.OR.KEYWRD(J+1:J+1).EQ.' ') THEN
               CH=KEYWRD(J:J)
               IF( CH .EQ. 'M') CHRONO='MINUTES'
               IF( CH .EQ. 'M') TIME=60
               IF( CH .EQ. 'H') CHRONO='HOURS'
               IF( CH .EQ. 'H') TIME=3600
               IF( CH .EQ. 'D') CHRONO='DAYS'
               IF( CH .EQ. 'D') TIME=86400
               GOTO 20
            ENDIF
   10    CONTINUE
   20    CONTINUE
         IF(TLEFT.LT.99999.9D0)THEN
            WRITE(6,1000)TLEFT,CHRONO
         ELSE
            WRITE(6,1010)TLEFT,CHRONO
         ENDIF
         TLEFT=TLEFT*TIME
      ELSEIF(NUMCAL.EQ.1)THEN
         TLEFT=MAXTIM
         WRITE(6,1000)TLEFT,'SECONDS'
      ELSE
         WRITE(6,1000)TLEFT,'SECONDS'
      ENDIF
      TIME=1
      CHRONO='SECONDS'
      IF(MYWORD(ALLKEY,' DUMP')) THEN
         I=INDEX(KEYWRD,' DUMP')
         TDUMP=READA(KEYWRD,I)
         DO 30 J=I+6,241
            IF( J.EQ.241.OR.KEYWRD(J+1:J+1).EQ.' ') THEN
               CH=KEYWRD(J:J)
               IF( CH .EQ. 'M') CHRONO='MINUTES'
               IF( CH .EQ. 'M') TIME=60.D0
               IF( CH .EQ. 'H') CHRONO='HOURS'
               IF( CH .EQ. 'H') TIME=3600.D0
               IF( CH .EQ. 'D') CHRONO='DAYS'
               IF( CH .EQ. 'D') TIME=86400.D0
               GOTO 40
            ENDIF
   30    CONTINUE
   40    CONTINUE
         IF(TDUMP.LT.99999.9D0)THEN
            WRITE(6,1020)TDUMP,CHRONO
         ELSE
            WRITE(6,1030)TDUMP,CHRONO
         ENDIF
         TDUMP=TDUMP*TIME
      ELSEIF(NUMCAL.EQ.1)THEN
         TDUMP=MAXDMP
         WRITE(6,1020)TDUMP,'SECONDS'
      ELSE
         WRITE(6,1020)TDUMP,'SECONDS'
      ENDIF
      IF (MYWORD(ALLKEY,'1SCF') ) THEN
         WRITE(6,1040)
         IF(INDEX(KEYWRD,'RESTART').EQ.0)MAXGEO=MAXGEO+1
      ENDIF
      CI=MYWORD(ALLKEY,'C.I.')
      IF (CI) THEN
         J=INDEX(KEYWRD,'C.I.=(')
         IF(J.NE.0)THEN
            WRITE(6,1060)INT(READA(KEYWRD,INDEX(KEYWRD,'C.I.=(')+7)),
     1      INT(READA(KEYWRD,INDEX(KEYWRD,'C.I.=(')+5))
         ELSE
            WRITE(6,1050)INT(READA(KEYWRD,INDEX(KEYWRD,'C.I.')+5))
         ENDIF
      ENDIF
      IF (MYWORD(ALLKEY,' FORCE') ) THEN
         WRITE(6,1070)
         MAXGEO=MAXGEO+1
      ENDIF
      IF (MYWORD(ALLKEY,' EF')) THEN
         WRITE(6,70)
         MAXGEO=MAXGEO+1
      ENDIF
      IF (MYWORD(ALLKEY,' TS')) THEN
         WRITE(6,80)
         MAXGEO=MAXGEO+1
      ENDIF
      METHOD=0
      IF (MYWORD(ALLKEY,'MINDO') ) THEN
         WRITE(6,1080)
         MINDO3=.TRUE.
         METHOD=1
      ENDIF
      IF (MYWORD(ALLKEY,'AM1') ) THEN
         WRITE(6,1090)
         AM1=.TRUE.
         METHOD=METHOD+1
      ENDIF
      IF (MYWORD(ALLKEY,'PM3') ) THEN
         WRITE(6,1100)
         PM3=.TRUE.
         METHOD=METHOD+1
      ENDIF
      IF (MYWORD(ALLKEY,'MNDO') ) THEN
         MNDO=.TRUE.
         METHOD=METHOD+1
      ENDIF
      IF (MYWORD(ALLKEY,'OLDGEO') ) WRITE(6,1120)
      IF (MYWORD(ALLKEY,'PREC') ) WRITE(6,1110)
      IF (MYWORD(ALLKEY,'NOINTER') ) WRITE(6,1130)
      IF (MYWORD(ALLKEY,'ISOTOPE') ) WRITE(6,1140)
      IF (MYWORD(ALLKEY,'DENOUT') ) WRITE(6,1150)
      IF (MYWORD(ALLKEY,'SHIFT') ) WRITE(6,1160)
     1 READA(KEYWRD,INDEX(KEYWRD,'SHIFT'))
      IF (MYWORD(ALLKEY,'OLDENS') ) WRITE(6,1170)
      IF (MYWORD(ALLKEY,'SCFCRT') ) WRITE(6,1180)
     1 READA(KEYWRD,INDEX(KEYWRD,'SCFCRT'))
      IF (MYWORD(ALLKEY,'ENPART') ) WRITE(6,1190)
      IF (MYWORD(ALLKEY,'NOXYZ') ) WRITE(6,1200)
      IF (MYWORD(ALLKEY,'SIGMA') ) THEN
         WRITE(6,1210)
         MAXGEO=MAXGEO+1
      ENDIF
      IF (MYWORD(ALLKEY,'NLLSQ') ) THEN
         WRITE(6,1220)
         MAXGEO=MAXGEO+1
      ENDIF
      IF (MYWORD(ALLKEY,'ROOT') ) WRITE(6,1230)
     1 NINT(READA(KEYWRD,INDEX(KEYWRD,'ROOT')))
      IF (MYWORD(ALLKEY,'TRANS=') ) THEN
         WRITE(6,1250)NINT(READA(KEYWRD,INDEX(KEYWRD,'TRANS=')))
      ELSEIF (MYWORD(ALLKEY,'TRANS') ) THEN
         WRITE(6,1240)
      ENDIF
      IF (MYWORD(ALLKEY,'SADDLE') ) THEN
         WRITE(6,1260)
         MAXGEO=MAXGEO+1
      ENDIF
      IF (MYWORD(ALLKEY,' LET') ) WRITE(6,1270)
      IF (MYWORD(ALLKEY,'COMPFG') ) WRITE(6,1280)
      IF (MYWORD(ALLKEY,'GNORM') ) WRITE(6,1290)
     1 READA(KEYWRD,INDEX(KEYWRD,'GNORM'))
      IF (MYWORD(ALLKEY,'PULAY') ) WRITE(6,1300)
      IF (MYWORD(ALLKEY,' STEP1')  )WRITE(6,1310)
     1 READA(KEYWRD,INDEX(KEYWRD,'STEP1')+6)
      IF (MYWORD(ALLKEY,' STEP2')  )WRITE(6,1320)
     1 READA(KEYWRD,INDEX(KEYWRD,'STEP2')+6)
      IF (MYWORD(ALLKEY,' STEP')  )WRITE(6,1500)
     1 READA(KEYWRD,INDEX(KEYWRD,'STEP')+5)
      IF (MYWORD(ALLKEY,' POINT1')  )THEN
         IP1=READA(KEYWRD,INDEX(KEYWRD,'POINT1')+7)
         WRITE(6,1330) IP1
      ENDIF
      IF (MYWORD(ALLKEY,' POINT2')  )THEN
         IP2=READA(KEYWRD,INDEX(KEYWRD,'POINT2')+7)
         WRITE(6,1340) IP2
      ENDIF
      IF (MYWORD(ALLKEY,' MAX') ) WRITE(6,1350)
      IF (MYWORD(ALLKEY,' POINT')  )THEN
         IP=READA(KEYWRD,INDEX(KEYWRD,'POINT')+6)
         WRITE(6,1510) IP
      ENDIF
      IF (MYWORD(ALLKEY,'BAR') ) WRITE(6,1360)
     1 READA(KEYWRD,INDEX(KEYWRD,'BAR'))
      IF (MYWORD(ALLKEY,'CAMP') ) WRITE(6,1370)
      IF (MYWORD(ALLKEY,'KING') ) WRITE(6,1370)
      IF (MYWORD(ALLKEY,'EIGS') ) WRITE(6,1380)
      IF (MYWORD(ALLKEY,'EIGINV') ) WRITE(6,1390)
      IF (MYWORD(ALLKEY,'NONR') ) WRITE(6,1400)
      IF (MYWORD(ALLKEY,'ORIDE') ) WRITE(6,1410)
      IF (MYWORD(ALLKEY,'HYPERF') ) WRITE(6,1420)
      IF (MYWORD(ALLKEY,' PL') ) WRITE(6,1430)
      IF (MYWORD(ALLKEY,'FILL') ) WRITE(6,1440)
     1 NINT(READA(KEYWRD,INDEX(KEYWRD,'FILL')))
      IF (MYWORD(ALLKEY,'ITRY') ) WRITE(6,1470)
     1 NINT(READA(KEYWRD,INDEX(KEYWRD,'ITRY')))
      IF (MYWORD(ALLKEY,'0SCF') ) WRITE(6,1490)
      IF(UHF)THEN
         IF(BIRAD.OR.EXCI.OR.CI)THEN
            WRITE(6,'(//10X,
     1'' UHF USED WITH EITHER BIRAD, EXCITED OR C.I. '')')
            WRITE(6,1480)
            GOTO 60
         ENDIF
      ELSE
         IF(EXCI.AND. TRIP) THEN
            WRITE(6,'(//10X,'' EXCITED USED WITH TRIPLET'')')
            WRITE(6,1480)
            GOTO 60
         ENDIF
      ENDIF
      IF (INDEX(KEYWRD,'T-PRIO').NE.0.AND.
     1INDEX(KEYWRD,'DRC').EQ.0) THEN
         WRITE (6,'(//10X,''T-PRIO AND NO DRC'')')
         WRITE (6,1480)
         GOTO 60
      ENDIF
      IF ( METHOD .GT. 1) THEN
         WRITE(6,'(//10X,
     1'' ONLY ONE OF MINDO, MNDO, AM1 AND PM3 ALLOWED'')')
         WRITE (6,1480)
         GOTO 60
      ENDIF
      IF (MYWORD(ALLKEY,'THERMO') )THEN
         WRITE(6,1450)
         IF(MYWORD(ALLKEY,' ROT')) THEN
            WRITE(6,1460)NINT(READA(KEYWRD,INDEX(KEYWRD,' ROT')))
         ELSE
            WRITE(6,'
     1    (//10X,'' YOU MUST SUPPLY THE SYMMETRY NUMBER "ROT"'')')
            STOP
         ENDIF
      ENDIF
      IF(MAXGEO.GT.1)THEN
         WRITE(6,'(//10X,''MORE THAN ONE GEOMETRY OPTION HAS BEEN '',
     1''SPECIFIED'',/10X,
     2''CONFLICT MUST BE RESOLVED BEFORE JOB WILL RUN'')')
         STOP
      ENDIF
      IF(INDEX(KEYWRD,'MULLIK').NE.0.AND.UHF)THEN
         WRITE(6,'(A)')' MULLIKEN POPULATION NOT AVAILABLE WITH UHF'
         STOP
      ENDIF
      IF(ALLKEY.NE.' ')THEN
         J=0
         DO 50 I=1,240
            IF(ALLKEY(I:I).NE.' '.OR.ALLKEY(I:I+1).NE.'  ')THEN
               J=J+1
               CH=ALLKEY(I:I)
               ALLKEY(J:J)=CH
            ENDIF
   50    CONTINUE
         IF(ALLKEY(241:241).NE.' ')THEN
            J=J+1
            CH=ALLKEY(241:241)
            ALLKEY(J:J)=CH
         ENDIF
         J=MAX(1,J)
         L=INDEX(KEYWRD,'DEBUG')
         IF(L.NE.0)THEN
            WRITE(6,'('' *  DEBUG KEYWORDS USED:  '',A)')ALLKEY(:J)
         ELSE
            WRITE(6,'(///10X,''UNRECOGNIZED KEY-WORDS: ('',A,'')'')')
     1ALLKEY(:J)
            WRITE(6,'(///10X,''CALCULATION STOPPED TO AVOID WASTING TIME
     1.'')')
            WRITE(6,'(///10X,''IF THESE ARE DEBUG KEYWORDS, ADD THE KEYW
     1ORD "DEBUG"'')')
            STOP
         ENDIF
      ENDIF
      RETURN
   60 WRITE(6,'(//10X,'' CALCULATION ABANDONED, SORRY!'')')
      STOP
C ***********************************************************
C ***********************************************************
   70 FORMAT(' *  EF       - USE EF ROUTINE FOR MINIMUM SEARCH')
   80 FORMAT(' *  TS       - USE EF ROUTINE FOR TS SEARCH')
   90 FORMAT(' *  IUPD=    - HESSIAN WILL NOT BE UPDATED')
  100 FORMAT(' *  IUPD=    - HESSIAN WILL BE UPDATED USING POWELL')
  110 FORMAT(' *  IUPD=    - HESSIAN WILL BE UPDATED USING BFGS')
  120 FORMAT(' *  HESS=    - DIAGONAL HESSIAN USED AS INITIAL GUESS')
  130 FORMAT(' *  HESS=    - INITIAL HESSIAN WILL BE CALCULATED')
  140 FORMAT(' *  HESS=    - INITIAL HESSIAN READ FROM DISK')
  150 FORMAT(' *  HESS=    - INITIAL HESSIAN READ FROM INPUT')
  160 FORMAT(' *  MODE=    - FOLLOW HESSIAN MODE',I3,' TOWARD TS')
  170 FORMAT(' *  RECALC=  - DO',I4,' CYCLES BETWEEN HESSIAN RECALC')
  180 FORMAT(' *  DMAX=    - TAKE MAXIMUM STEPSIZE OF',F5.3,' ANG/RAD')
  190 FORMAT(' *  MS=      - IN MECI, MAGNETIC COMPONENT OF SPIN =',I3)
  200 FORMAT(' *  PRNT     - EXTRA PRINTING IN EF ROUTINE')
C ***********************************************************
  210 FORMAT(' *  VECTORS  - FINAL EIGENVECTORS TO BE PRINTED')
  220 FORMAT(' *  EXTERNAL - USE ATOMIC PARAMETERS FROM THE FOLLOWING '
     1,'FILE',/15X,A)
  230 FORMAT(' *  DENSITY  - FINAL DENSITY MATRIX TO BE PRINTED')
  240 FORMAT(' *  SPIN     - FINAL UHF SPIN MATRIX TO BE PRINTED')
  250 FORMAT(' *  DEPVAR=N - SPECIFIED DISTANCE IS',F7.4,
     1' TIMES BOND LENGTH')
  260 FORMAT(' *  DEP      - OUTPUT FORTRAN CODE FOR BLOCK-DATA')
  270 FORMAT(' *  VELOCITY - INPUT STARTING VELOCITIES FOR DRC')
  280 FORMAT(' *  TIMES    - TIMES OF VARIOUS STAGES TO BE PRINTED')
  290 FORMAT(' *  PARASOK  - USE SOME MNDO PARAMETERS IN AN AM1 CALCULA'
     1,'TION')
  300 FORMAT(' *  NODIIS   - DO NOT USE GDIIS GEOMETRY OPTIMIZER')
C  *** FOLLOWING LINE ADDED AS NOTED
C  IN QCPE BULLETIN VOL. 11, NO. 3, PP. 52-54 (1991).
  305 FORMAT(' *  NOTHIEL  - DO NOT USE THIEL''S FSTMIN OPTION')
  310 FORMAT(' *  BONDS    - FINAL BOND-ORDER MATRIX TO BE PRINTED')
  320 FORMAT(' *  GEO-OK   - OVERRIDE INTERATOMIC DISTANCE CHECK')
  330 FORMAT(' *  FOCK     - LAST FOCK MATRIX TO BE PRINTED')
  340 FORMAT(' *  LARGE    - EXPANDED OUTPUT TO BE PRINTED')
  350 FORMAT(' *   K=      - BRILLOUIN ZONE STRUCTURE TO BE CALCULATED')
  360 FORMAT(' *  NOLOG    - SUPPRESS LOG FILE TRAIL, WHERE POSSIBLE')
  370 FORMAT(' *  AIGIN    - GEOMETRY MUST BE IN GAUSSIAN FORMAT')
  380 FORMAT(' *  AIGOUT   - IN ARC FILE, INCLUDE AB-INITIO GEOMETRY')
  390 FORMAT(' *  AIDER    - READ IN AB INITIO DERIVATIVES')
  400 FORMAT(' *  S1978    - 1978 SULFUR PARAMETERS TO BE USED')
  410 FORMAT(' *  SI1978   - 1978 SILICON PARAMETERS TO BE USED')
  420 FORMAT(' *  GRAPH    - GENERATE FILE FOR GRAPHICS')
  430 FORMAT(' *  1ELECTRON- FINAL ONE-ELECTRON MATRIX TO BE PRINTED')
  440 FORMAT(' *  NOANCI   - DO NOT USE ANALYTICAL C.I. DERIVATIVES')
  450 FORMAT(' *  ESR      - RHF SPIN DENSITY CALCULATION REQUESTED')
  460 FORMAT(' *  NOMM     - DO NOT MAKE MM CORRECTION TO CONH BARRIER')
  470 FORMAT(' *  SETUP    - EXTRA KEYWORDS TO BE READ FROM FILE SETUP')
  480 FORMAT(' *  MMOK     - APPLY MM CORRECTION TO CONH BARRIER')
  490 FORMAT(' *  INTERP   - PRINT DETAILS OF CAMP-KING CONVERGER')
  500 FORMAT(' *  DFP      - USE DAVIDON FLETCHER POWELL OPTIMIZER')
  510 FORMAT(' *  ANALYT   - USE ANALYTIC DERIVATIVES ')
  520 FORMAT(' *  MECI     - M.E.C.I. WORKING TO BE PRINTED')
  530 FORMAT(' *  DRC      - DYNAMIC REACTION COORDINATE CALCULATION')
  540 FORMAT(' *  DRC=     - HALF-LIFE FOR KINETIC ENERGY LOSS =',F9.2,
     1' * 10**(-15) SECONDS')
  550 FORMAT(' *  KINETIC= - ',F9.3,' KCAL KINETIC ENERGY ADDED TO DRC')
  560 FORMAT(' *  LOCALIZE - LOCALIZED ORBITALS TO BE PRINTED')
  570 FORMAT(' *  MULLIK   - THE MULLIKEN ANALYSIS TO BE PERFORMED')
  580 FORMAT(' *   XYZ     - CARTESIAN COORDINATE SYSTEM TO BE USED')
  590 FORMAT(' *   PI      - BONDS MATRIX, SPLIT INTO SIGMA-PI-DELL',
     1' COMPONENTS, TO BE PRINTED')
  600 FORMAT(' *  ECHO     - ALL INPUT DATA TO BE ECHOED BEFORE RUN')
  610 FORMAT(' *  H-PRIOR  - HEAT OF FORMATION TAKES PRIORITY IN DRC')
  620 FORMAT(' *  X-PRIOR  - GEOMETRY CHANGES TAKE PRIORITY IN DRC')
  630 FORMAT(' *  T-PRIOR  - TIME TAKES PRIORITY IN DRC')
  640 FORMAT(' *  POLAR    - CALCULATE FIRST, SECOND AND THIRD-ORDER'
     1,' POLARIZABILITIES')
  650 FORMAT(' *  COMPFG   - PRINT HEAT OF FORMATION CALC''D IN COMPFG')
  660 FORMAT(' *  DEBUG    - DEBUG OPTION TURNED ON')
  670 FORMAT(' *  RESTART  - CALCULATION RESTARTED')
C
C     KEYWORDS ADDED FOR ESP MOPAC
C
  680 FORMAT(' *  ESP      - ELECTROSTATIC POTENTIAL CALCULATION')
  690 FORMAT(' *  NSURF    - NUMBER OF LAYERS')
  700 FORMAT(' *  SCALE    - SCALING FACTOR FOR VAN DER WAALS DISTANCE')
  710 FORMAT(' *  SCINCR   - INCREMENT BETWEEN LAYERS')
  720 FORMAT(' *  SLOPE    - SLOPE - USED TO SCALE MNDO ESP CHARGES')
  730 FORMAT(' *  DIPOLE   - FIT THE ESP TO THE CALCULATED DIPOLE')
  740 FORMAT(' *  DIPX     - X COMPONENT OF DIPOLE TO BE FIT')
  750 FORMAT(' *  DIPY     - Y COMPONENT OF DIPOLE TO BE FIT')
  760 FORMAT(' *  DIPZ     - Z COMPONENT OF DIPOLE TO BE FIT')
  770 FORMAT(' *  CONNOLLY - USE CONNOLLY SURFACE')
  780 FORMAT(' *  ESPRST   - RESTART OF ELECTRIC POTENTIAL CALCULATION')
  790 FORMAT(' *  POTWRT   - WRITE OUT ELECTRIC POT. DATA TO FILE 21')
  800 FORMAT(' *  WILLIAMS - USE WILLIAMS SURFACE')
  810 FORMAT(' *  SYMAVG   - AVERAGE SYMMETRY EQUIVALENT ESP CHARGES')
  820 FORMAT(' *  STO3G    - DEORTHOGONALIZE ORBITALS IN STO-3G BASIS')
  830 FORMAT(' *  IRC=N    - INTRINSIC REACTION COORDINATE',I3,
     1' DEFINED')
  840 FORMAT(' *  IRC      - INTRINSIC REACTION COORDINATE CALCULATION')
  850 FORMAT(3(' *',/),' *',15X,'  CHARGE ON SYSTEM =',I3,3(/,' *'))
  860 FORMAT(' *  GRADIENTS- ALL GRADIENTS TO BE PRINTED')
  870 FORMAT(' *  UHF      - UNRESTRICTED HARTREE-FOCK CALCULATION')
  880 FORMAT(' *  SINGLET  - STATE REQUIRED MUST BE A SINGLET')
  890 FORMAT(' *  BIRADICAL- SYSTEM HAS TWO UNPAIRED ELECTRONS')
  900 FORMAT(' *  EXCITED  - FIRST EXCITED STATE IS TO BE OPTIMIZED')
  910 FORMAT(' *  SINGLET  - SPIN STATE DEFINED AS A SINGLET')
  920 FORMAT(' *  DOUBLET  - SPIN STATE DEFINED AS A DOUBLET')
  930 FORMAT(' *  TRIPLET  - SPIN STATE DEFINED AS A TRIPLET')
  940 FORMAT(' *  QUARTET  - SPIN STATE DEFINED AS A QUARTET')
  950 FORMAT(' *  QUINTET  - SPIN STATE DEFINED AS A QUINTET')
  960 FORMAT(' *  SEXTET   - SPIN STATE DEFINED AS A SEXTET')
  970 FORMAT(' *  SYMMETRY - SYMMETRY CONDITIONS TO BE IMPOSED')
  980 FORMAT(' *  MICROS=N -',I4,' MICROSTATES TO BE SUPPLIED FOR C.I.')
  990 FORMAT(' *  OPEN(N,N)- THERE ARE',I2,' ELECTRONS IN',I2,' LEVELS')
 1000 FORMAT(' *   T=      - A TIME OF',F8.1,' ',A7,' REQUESTED')
 1010 FORMAT(' *   T=      - A TIME OF',G11.3,' ',A7,' REQUESTED')
 1020 FORMAT(' *  DUMP=N   - RESTART FILE WRITTEN EVERY',F8.1,
     1' ',A7)
 1030 FORMAT(' *  DUMP=N   - RESTART FILE WRITTEN EVERY',G11.3,
     1' ',A7)
 1040 FORMAT(' *  1SCF     - DO 1 SCF AND THEN STOP ')
 1050 FORMAT(' *  C.I.=N   -',I2,' M.O.S TO BE USED IN C.I.')
 1060 FORMAT(' * C.I.=(N,M)-',I2,' DOUBLY FILLED LEVELS USED IN A ',/
     1,      ' *             C.I. INVOLVING ',I2,' M.O.''S')
 1070 FORMAT(' *  FORCE    - FORCE CALCULATION SPECIFIED')
 1080 FORMAT(' *  MINDO/3  - THE MINDO/3 HAMILTONIAN TO BE USED')
 1090 FORMAT(' *  AM1      - THE AM1 HAMILTONIAN TO BE USED')
 1100 FORMAT(' *  PM3      - THE PM3 HAMILTONIAN TO BE USED')
 1110 FORMAT(' *  PRECISE  - CRITERIA TO BE INCREASED BY 100 TIMES')
 1120 FORMAT(' *  OLDGEO   - PREVIOUS GEOMETRY TO BE USED')
 1130 FORMAT(' *  NOINTER  - INTERATOMIC DISTANCES NOT TO BE PRINTED')
 1140 FORMAT(' *  ISOTOPE  - FORCE MATRIX WRITTEN TO DISK (CHAN. 9 )')
 1150 FORMAT(' *  DENOUT   - DENSITY MATRIX OUTPUT ON CHANNEL 10')
 1160 FORMAT(' *  SHIFT    - A DAMPING FACTOR OF',F8.2,' DEFINED')
 1170 FORMAT(' *  OLDENS   - INITIAL DENSITY MATRIX READ OF DISK')
 1180 FORMAT(' *  SCFCRT   - DEFAULT SCF CRITERION REPLACED BY',G12.3)
 1190 FORMAT(' *  ENPART   - ENERGY TO BE PARTITIONED INTO COMPONENTS')
 1200 FORMAT(' *  NOXYZ    - CARTESIAN COORDINATES NOT TO BE PRINTED')
 1210 FORMAT(' *  SIGMA    - GEOMETRY TO BE OPTIMIZED USING SIGMA.')
 1220 FORMAT(' *  NLLSQ    - GRADIENTS TO BE MINIMIZED USING NLLSQ.')
 1230 FORMAT(' *  ROOT     - IN A C.I. CALCULATION, ROOT',I2,
     1                       ' TO BE OPTIMIZED.')
 1240 FORMAT(' *  TRANS    - THE REACTION VIBRATION TO BE DELETED FROM',
     1' THE THERMO CALCULATION')
 1250 FORMAT(' *  TRANS=   - ',I4,' VIBRATIONS ARE TO BE DELETED FROM',
     1' THE THERMO CALCULATION')
 1260 FORMAT(' *  SADDLE   - TRANSITION STATE TO BE OPTIMIZED')
 1270 FORMAT(' *   LET     - OVERRIDE SOME SAFETY CHECKS')
 1280 FORMAT(' *  COMPFG   - PRINT HEAT OF FORMATION CALC''D IN COMPFG')
 1290 FORMAT(' *  GNORM=   - EXIT WHEN GRADIENT NORM DROPS BELOW ',G8.3)
 1300 FORMAT(' *  PULAY    - PULAY''S METHOD TO BE USED IN SCF')
 1310 FORMAT(' *  STEP1    - FIRST  STEP-SIZE IN GRID =',F7.2)
 1320 FORMAT(' *  STEP2    - SECOND STEP-SIZE IN GRID =',F7.2)
 1330 FORMAT(' *  POINT1   - NUMBER OF ROWS IN GRID =',I3)
 1340 FORMAT(' *  POINT2   - NUMBER OF COLUMNS IN GRID =',I3)
 1350 FORMAT(' *  MAX      - GRID SIZE 23*23 ')
 1360 FORMAT(' *  BAR=     - REDUCE BAR LENGTH BY A MAX. OF',F7.2)
 1370 FORMAT(' *  CAMP,KING- THE CAMP-KING CONVERGER TO BE USED')
 1380 FORMAT(' *  EIGS     - PRINT ALL EIGENVALUES IN ITER')
 1390 FORMAT(' *  EIGINV   - USE HESSIAN EIGENVALUE REVERSION IN EF')
 1400 FORMAT(' *  NONR     - DO NOT USE NEWTON-RAPHSON STEP IN EF')
 1410 FORMAT(' *  ORIDE    - UNCONDITIONALLY, USE CALCULATED LAMDAS IN'
     1//' EF')
 1420 FORMAT(' *  HYPERFINE- HYPERFINE COUPLING CONSTANTS TO BE'
     1,' PRINTED')
 1430 FORMAT(' *   PL      - MONITOR CONVERGANCE IN DENSITY MATRIX')
 1440 FORMAT(' *  FILL=    - IN RHF CLOSED SHELL, FORCE M.O.',I3,' TO BE
     1 FILLED')
 1450 FORMAT(' *  THERMO   - THERMODYNAMIC QUANTITIES TO BE CALCULATED')
 1460 FORMAT(' *  ROT      - SYMMETRY NUMBER OF',I3,' SPECIFIED')
 1470 FORMAT(' *  ITRY=    - DO A MAXIMUM OF',I6,' ITERATIONS FOR SCF')
 1480 FORMAT( //10X,' IMPOSSIBLE OPTION REQUESTED,')
 1490 FORMAT(' *  0SCF     - AFTER READING AND PRINTING DATA, STOP')
 1500 FORMAT(' *  STEP     - STEP-SIZE IN PATH=',F7.3)
 1510 FORMAT(' *  POINT    - NUMBER OF POINTS IN PATH=',I3)
 1520 FORMAT(' *  AQUO     - AM1-SM1 CALCULATION TO BE DONE')
 1540 FORMAT(' *  ENVAQ    - AM1-SM1a COMPUTATION to BE DONE')
 1550 FORMAT(' *  NOFUL    - DO NOT USE FULL SCF DERIV WITH AQUO OR 
     1ENVAQ')
      END
      LOGICAL FUNCTION MYWORD(KEYWRD,TESTWD)
      CHARACTER KEYWRD*(*), TESTWD*(*)
      MYWORD=.FALSE.
   10 J=INDEX(KEYWRD,TESTWD)
      IF(J.NE.0)THEN
   20    IF(KEYWRD(J:J).NE.' ')GOTO 30
         J=J+1
         GOTO 20
   30    MYWORD=.TRUE.
         DO 60 K=J,241
            IF(KEYWRD(K:K).EQ.'='.OR.KEYWRD(K:K).EQ.' ') THEN
C
C     CHECK FOR ATTACHED '=' SIGN
C
               J=K
               IF(KEYWRD(J:J).EQ.'=')GOTO 50
C
C     CHECK FOR SEPARATED '=' SIGN
C
               DO 40 J=K+1,241
                  IF(KEYWRD(J:J).EQ.'=') GOTO 50
   40          IF(KEYWRD(J:J).NE.' ')GOTO 10
C
C    THERE IS NO '=' SIGN ASSOCIATED WITH THIS KEYWORD
C
               GOTO 10
   50          KEYWRD(J:J)=' '
C
C   THERE MUST BE A NUMBER AFTER THE '=' SIGN, SOMEWHERE
C
               GOTO 20
            ENDIF
   60    KEYWRD(K:K)=' '
      ENDIF
      RETURN
      END
